/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.TDistribution;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.Combinations;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class Ttest
extends AbstractAlgorithm {
    public static final int GROUP_A = 1;
    public static final int GROUP_B = 2;
    public static final int NEITHER_GROUP = 3;
    public static final int JUST_ALPHA = 4;
    public static final int STD_BONFERRONI = 5;
    public static final int ADJ_BONFERRONI = 6;
    public static final int BETWEEN_SUBJECTS = 7;
    public static final int ONE_CLASS = 8;
    public static final int MAX_T = 9;
    public static final int MIN_P = 10;
    public static final int PAIRED = 11;
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    protected boolean stop = false;
    protected int function;
    protected float factor;
    protected boolean absolute;
    protected FloatMatrix expMatrix;
    boolean hierarchical_tree;
    boolean drawSigTreesOnly;
    int method_linkage;
    boolean calculate_genes;
    boolean calculate_experiments;
    protected Vector[] clusters;
    protected int k;
    protected int numGenes;
    protected int numExps;
    protected int falseNum;
    protected float alpha;
    protected float falseProp;
    protected int significanceMethod;
    protected boolean isPermut;
    protected boolean useWelchDf;
    protected boolean calculateAdjFDRPVals;
    protected boolean useFastFDRApprox;
    protected int[] groupAssignments;
    protected int[] pairedGroupAExpts;
    protected int[] pairedGroupBExpts;
    protected int numCombs;
    boolean useAllCombs;
    int tTestDesign;
    float oneClassMean = 0.0f;
    AlgorithmEvent event;
    double[] tValues;
    double[] oneClassMeans;
    double[] groupAMeans;
    double[] groupBMeans;
    double[] oneClassSDs;
    double[] groupASDs;
    double[] groupBSDs;
    double[] dfValues;
    double[] origPVals;
    double[] adjustedPVals;
    protected boolean[] isSig;
    protected int hcl_function;
    protected boolean hcl_absolute;
    int validN;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        int i2;
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("distance-absolute", false);
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        this.hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        if (this.hierarchical_tree) {
            this.drawSigTreesOnly = map.getBoolean("draw-sig-trees-only");
        }
        this.method_linkage = map.getInt("method-linkage", 0);
        this.calculate_genes = map.getBoolean("calculate-genes", false);
        this.calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.expMatrix = data.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.tTestDesign = map.getInt("tTestDesign", 7);
        if (this.tTestDesign == 8) {
            this.oneClassMean = map.getFloat("oneClassMean", 0.0f);
        }
        this.alpha = map.getFloat("alpha", 0.01f);
        this.significanceMethod = map.getInt("significance-method", 4);
        this.isPermut = map.getBoolean("is-permut", false);
        this.useWelchDf = map.getBoolean("useWelchDf", true);
        this.numCombs = map.getInt("num-combs", 100);
        this.useAllCombs = map.getBoolean("use-all-combs", false);
        if (this.significanceMethod == 12 || this.significanceMethod == 13) {
            this.calculateAdjFDRPVals = map.getBoolean("calculateAdjFDRPVals", false);
            this.useFastFDRApprox = map.getBoolean("useFastFDRApprox", true);
        }
        if (this.significanceMethod == 12) {
            this.falseNum = map.getInt("falseNum", 10);
        }
        if (this.significanceMethod == 13) {
            this.falseProp = map.getFloat("falseProp", 0.05f);
        }
        if (this.tTestDesign == 8 || this.tTestDesign == 7) {
            this.groupAssignments = data.getIntArray("group-assignments");
        }
        if (this.tTestDesign == 11) {
            FloatMatrix pairedAExptsMatrix = data.getMatrix("pairedAExptsMatrix");
            FloatMatrix pairedBExptsMatrix = data.getMatrix("pairedBExptsMatrix");
            this.pairedGroupAExpts = new int[pairedAExptsMatrix.getRowDimension()];
            this.pairedGroupBExpts = new int[pairedBExptsMatrix.getRowDimension()];
            for (int i3 = 0; i3 < pairedAExptsMatrix.getRowDimension(); ++i3) {
                this.pairedGroupAExpts[i3] = (int)pairedAExptsMatrix.A[i3][0];
                this.pairedGroupBExpts[i3] = (int)pairedBExptsMatrix.A[i3][0];
            }
        }
        if (this.significanceMethod == 12 || this.significanceMethod == 13) {
            if (this.tTestDesign == 7) {
                this.computeBtnSubOrigVals();
            } else if (this.tTestDesign == 8) {
                this.computeOneClassOrigVals();
            } else if (this.tTestDesign == 11) {
                this.computePairedOrigVals();
            }
            this.origPVals = this.getRawPValsFromTDist();
        } else if (this.tTestDesign == 7) {
            this.computeBtnSubOrigVals();
            this.origPVals = !this.isPermut ? this.getRawPValsFromTDist() : this.getTwoClassRawPValsFromPerms();
        } else if (this.tTestDesign == 8) {
            this.computeOneClassOrigVals();
            this.origPVals = !this.isPermut ? this.getRawPValsFromTDist() : this.getOneClassRawPValsFromPerms();
        } else if (this.tTestDesign == 11) {
            this.computePairedOrigVals();
            this.origPVals = !this.isPermut ? this.getRawPValsFromTDist() : this.getPairedRawPValsFromPerms();
        }
        Vector clusterVector = new Vector();
        Vector<Integer> sigGenes = new Vector<Integer>();
        Vector<Integer> nonSigGenes = new Vector<Integer>();
        if (this.significanceMethod == 12 || this.significanceMethod == 13) {
            boolean[] isGeneSig = new boolean[1];
            isGeneSig = this.significanceMethod == 12 ? this.isGeneSigByFDRNum() : this.isGeneSigByFDRPropNew2();
            if (!this.calculateAdjFDRPVals) {
                this.adjustedPVals = new double[this.numGenes];
            }
            for (int i4 = 0; i4 < this.numGenes; ++i4) {
                if (isGeneSig[i4]) {
                    sigGenes.add(new Integer(i4));
                    continue;
                }
                nonSigGenes.add(new Integer(i4));
            }
        } else {
            this.adjustedPVals = this.getAdjPVals(this.origPVals, this.significanceMethod);
            this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
            this.fireValueChanged(this.event);
            this.event.setId(2);
            for (int i5 = 0; i5 < this.numGenes; ++i5) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(i5);
                this.event.setDescription("Finding significant genes: Current gene = " + (i5 + 1));
                this.fireValueChanged(this.event);
                float currAdjP = (float)this.adjustedPVals[i5];
                if (this.significanceMethod == 6) {
                    if (this.isSig[i5]) {
                        sigGenes.add(new Integer(i5));
                        continue;
                    }
                    nonSigGenes.add(new Integer(i5));
                    continue;
                }
                if (currAdjP <= this.alpha) {
                    sigGenes.add(new Integer(i5));
                    continue;
                }
                nonSigGenes.add(new Integer(i5));
            }
        }
        clusterVector.add(sigGenes);
        clusterVector.add(nonSigGenes);
        this.k = clusterVector.size();
        FloatMatrix qValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix rawPValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix adjPValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix tValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix dfMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix meansAMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix meansBMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix sdAMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix sdBMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix isSigMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix oneClassMeansMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix oneClassSDsMatrix = new FloatMatrix(this.numGenes, 1);
        for (i2 = 0; i2 < isSigMatrix.getRowDimension(); ++i2) {
            isSigMatrix.A[i2][0] = 0.0f;
        }
        for (i2 = 0; i2 < sigGenes.size(); ++i2) {
            int currentGene = (Integer)sigGenes.get(i2);
            isSigMatrix.A[currentGene][0] = 1.0f;
        }
        float[] qvalues = this.getQValsFromPVals(this.origPVals);
        for (i = 0; i < this.numGenes; ++i) {
            qValuesMatrix.A[i][0] = qvalues[i];
            rawPValuesMatrix.A[i][0] = (float)this.origPVals[i];
            adjPValuesMatrix.A[i][0] = (float)this.adjustedPVals[i];
            tValuesMatrix.A[i][0] = (float)this.tValues[i];
            dfMatrix.A[i][0] = (float)this.dfValues[i];
            if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                meansAMatrix.A[i][0] = (float)this.groupAMeans[i];
                meansBMatrix.A[i][0] = (float)this.groupBMeans[i];
                sdAMatrix.A[i][0] = (float)this.groupASDs[i];
                sdBMatrix.A[i][0] = (float)this.groupBSDs[i];
                continue;
            }
            if (this.tTestDesign != 8) continue;
            oneClassMeansMatrix.A[i][0] = (float)this.oneClassMeans[i];
            oneClassSDsMatrix.A[i][0] = (float)this.oneClassSDs[i];
        }
        this.clusters = new Vector[this.k];
        for (i = 0; i < this.k; ++i) {
            this.clusters[i] = (Vector)clusterVector.get(i);
        }
        FloatMatrix means = this.getMeans(this.clusters);
        FloatMatrix variances = this.getVariances(this.clusters, means);
        AlgorithmEvent event = null;
        if (this.hierarchical_tree) {
            event = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(event);
            event.setIntValue(0);
            event.setId(2);
            this.fireValueChanged(event);
        }
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i6 = 0; i6 < this.clusters.length; ++i6) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.convert2int(this.clusters[i6]);
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!this.hierarchical_tree) continue;
            if (this.drawSigTreesOnly) {
                if (i6 != 0) continue;
                node.setValues(this.calculateHierarchicalTree(features, this.method_linkage, this.calculate_genes, this.calculate_experiments));
                event.setIntValue(i6 + 1);
                this.fireValueChanged(event);
                continue;
            }
            node.setValues(this.calculateHierarchicalTree(features, this.method_linkage, this.calculate_genes, this.calculate_experiments));
            event.setIntValue(i6 + 1);
            this.fireValueChanged(event);
        }
        AlgorithmData result = new AlgorithmData();
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        result.addMatrix("qValues", qValuesMatrix);
        result.addMatrix("rawPValues", rawPValuesMatrix);
        result.addMatrix("adjPValues", adjPValuesMatrix);
        result.addMatrix("tValues", tValuesMatrix);
        result.addMatrix("dfValues", dfMatrix);
        result.addMatrix("meansAMatrix", meansAMatrix);
        result.addMatrix("meansBMatrix", meansBMatrix);
        result.addMatrix("sdAMatrix", sdAMatrix);
        result.addMatrix("sdBMatrix", sdBMatrix);
        result.addMatrix("isSigMatrix", isSigMatrix);
        result.addMatrix("oneClassMeansMatrix", oneClassMeansMatrix);
        result.addMatrix("oneClassSDsMatrix", oneClassSDsMatrix);
        return result;
    }

    private float[] getQValsFromPVals(double[] pvals) {
        int i;
        float[] qvals = new float[pvals.length];
        float[] temppvals = new float[pvals.length];
        float[] origIndex = new float[pvals.length];
        for (i = 0; i < temppvals.length; ++i) {
            temppvals[i] = (float)pvals[i];
            origIndex[i] = i;
        }
        ExperimentUtil.sort2(temppvals, origIndex);
        for (i = 0; i < temppvals.length; ++i) {
            qvals[(int)origIndex[i]] = temppvals[i] / ((float)(Arrays.binarySearch(temppvals, temppvals[i]) + 1) / (float)temppvals.length);
        }
        return qvals;
    }

    protected NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.getSubExperiment(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    protected void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    protected FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    protected void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    protected int[] convert2int(Vector source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (Integer)source.get(i);
        }
        return int_matrix;
    }

    protected FloatMatrix getMeans(Vector[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.numExps);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    protected FloatMatrix getMean(Vector cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.numExps);
        int n = cluster.size();
        int denom = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(((Integer)cluster.get(j)).intValue(), i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    protected FloatMatrix getVariances(Vector[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    protected float getSampleNormalizedSum(Vector cluster, int column, float mean) {
        int size = cluster.size();
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(((Integer)cluster.get(i)).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    protected float getSampleVariance(Vector cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    protected boolean[] isGeneSigByFDRPropOld() throws AlgorithmException {
        double[] nonNanPVals = new double[this.origPVals.length];
        for (int i = 0; i < this.origPVals.length; ++i) {
            nonNanPVals[i] = Double.isNaN(this.origPVals[i]) ? Double.POSITIVE_INFINITY : this.origPVals[i];
        }
        QSort sortOrigPVals = new QSort(nonNanPVals, 1);
        double[] sortedOrigPVals = sortOrigPVals.getSortedDouble();
        int[] sortedIndices = sortOrigPVals.getOrigIndx();
        boolean[] isGeneSig = new boolean[this.numGenes];
        for (int i = 0; i < isGeneSig.length; ++i) {
            isGeneSig[i] = false;
        }
        double yKZero = this.getYConservative(this.alpha, 0);
        if (sortedOrigPVals[0] >= yKZero) {
            return isGeneSig;
        }
        isGeneSig[sortedIndices[0]] = true;
        if (this.useFastFDRApprox) {
            for (int i = 1; i < sortedOrigPVals.length; ++i) {
                int rGamma = (int)Math.floor((float)(i + 1) * this.falseProp);
                int rMinusOneGamma = (int)Math.floor((float)i * this.falseProp);
                double yKRGamma = this.getYConservative(this.alpha, rGamma);
                System.out.println("rGamma = " + rGamma + ", (r - 1)Gamma = " + rMinusOneGamma + ", yKRGamma = " + yKRGamma);
                if (rGamma <= rMinusOneGamma && !(sortedOrigPVals[i] < yKRGamma)) break;
                isGeneSig[sortedIndices[i]] = true;
            }
        }
        return isGeneSig;
    }

    protected boolean[] isGeneSigByFDRPropNew2() throws AlgorithmException {
        double[] nonNanPVals = new double[this.origPVals.length];
        for (int i = 0; i < this.origPVals.length; ++i) {
            nonNanPVals[i] = Double.isNaN(this.origPVals[i]) ? Double.POSITIVE_INFINITY : this.origPVals[i];
        }
        QSort sortOrigPVals = new QSort(nonNanPVals, 1);
        double[] sortedOrigPVals = sortOrigPVals.getSortedDouble();
        int[] sortedIndices = sortOrigPVals.getOrigIndx();
        boolean[] isGeneSig = new boolean[this.numGenes];
        for (int i = 0; i < isGeneSig.length; ++i) {
            isGeneSig[i] = false;
        }
        double[] yKArray = this.getYKArray();
        if (sortedOrigPVals[0] >= yKArray[0]) {
            return isGeneSig;
        }
        isGeneSig[sortedIndices[0]] = true;
        if (this.useFastFDRApprox) {
            for (int i = 1; i < sortedOrigPVals.length; ++i) {
                int rGamma = (int)Math.floor((float)(i + 1) * this.falseProp);
                int rMinusOneGamma = (int)Math.floor((float)i * this.falseProp);
                double yKRGamma = yKArray[rGamma];
                if (rGamma <= rMinusOneGamma && !(sortedOrigPVals[i] < yKRGamma)) break;
                isGeneSig[sortedIndices[i]] = true;
            }
        }
        return isGeneSig;
    }

    protected boolean[] isGeneSigByFDRPropNew() throws AlgorithmException {
        double[] nonNanPVals = new double[this.origPVals.length];
        for (int i = 0; i < this.origPVals.length; ++i) {
            nonNanPVals[i] = Double.isNaN(this.origPVals[i]) ? Double.POSITIVE_INFINITY : this.origPVals[i];
        }
        QSort sortOrigPVals = new QSort(nonNanPVals, 1);
        double[] sortedOrigPVals = sortOrigPVals.getSortedDouble();
        int[] sortedIndices = sortOrigPVals.getOrigIndx();
        boolean[] isGeneSig = new boolean[this.numGenes];
        for (int i = 0; i < isGeneSig.length; ++i) {
            isGeneSig[i] = false;
        }
        FloatMatrix sortedExpMatrix = new FloatMatrix(this.expMatrix.getRowDimension(), this.expMatrix.getColumnDimension());
        for (int i = 0; i < this.expMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < this.expMatrix.getColumnDimension(); ++j) {
                sortedExpMatrix.A[i][j] = this.expMatrix.A[sortedIndices[i]][j];
            }
        }
        double yKZero = this.getYConservative(this.alpha, 0);
        if (sortedOrigPVals[0] >= yKZero) {
            return isGeneSig;
        }
        isGeneSig[sortedIndices[0]] = true;
        if (this.useFastFDRApprox) {
            int currMinGene = 1;
            int currMaxGene = 100;
            if (currMaxGene > this.numGenes - 1) {
                currMaxGene = this.numGenes - 1;
            }
            int rGammaPrev = (int)Math.floor(2.0f * this.falseProp);
            boolean sig = true;
            block4: while (sig) {
                System.out.println("Entering while, sig = " + sig);
                if (currMinGene > this.numGenes - 1) break;
                if (currMaxGene > this.numGenes - 1) {
                    currMaxGene = this.numGenes - 1;
                    sig = false;
                }
                System.out.println("currMinGene = " + currMinGene + ", currMaxGene = " + currMaxGene);
                FloatMatrix smallMatrix = sortedExpMatrix.getMatrix(0, currMaxGene, 0, sortedExpMatrix.getColumnDimension() - 1);
                double[][] pValMatrix = this.getSortedPermPValMatrix(smallMatrix);
                double yKRGamma = this.getYKFromPMatrix(pValMatrix, rGammaPrev);
                for (int i = currMinGene; i <= currMaxGene; currMaxGene += 100, ++i) {
                    int rGamma = (int)Math.floor((float)(i + 1) * this.falseProp);
                    int rMinusOneGamma = (int)Math.floor((float)i * this.falseProp);
                    if (rGamma > currMaxGene) continue block4;
                    System.out.println("i = " + i + ", rGamma = " + rGamma + ",  rMinusOneGamma = " + rMinusOneGamma + ", rGammaPrev = " + rGammaPrev);
                    if (rGamma != rGammaPrev) {
                        yKRGamma = this.getYKFromPMatrix(pValMatrix, rGamma);
                        rGammaPrev = rGamma;
                    }
                    System.out.println("yKRGamma = " + yKRGamma);
                    if (rGamma <= rMinusOneGamma && !(sortedOrigPVals[i] < yKRGamma)) {
                        sig = false;
                        System.out.println("false");
                        continue block4;
                    }
                    isGeneSig[sortedIndices[i]] = true;
                    System.out.println("true");
                    currMinGene = currMaxGene + 1;
                }
            }
        }
        return isGeneSig;
    }

    protected double getYKFromPMatrix(double[][] pMatrix, int u) {
        double[] uPlusOnePValArray = new double[pMatrix[u].length];
        for (int i = 0; i < pMatrix[u].length; ++i) {
            uPlusOnePValArray[i] = pMatrix[u][i];
        }
        QSort sortPValArray = new QSort(uPlusOnePValArray, 1);
        double[] sortedPValArray = sortPValArray.getSortedDouble();
        int selectedIndex = (int)Math.floor((float)sortedPValArray.length * this.alpha) - 1;
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        return sortedPValArray[selectedIndex];
    }

    protected double[][] getSortedPermPValMatrix(FloatMatrix inputMatrix) throws AlgorithmException {
        AlgorithmEvent event2 = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(event2);
        event2.setId(2);
        double[][] pValMatrix = new double[inputMatrix.getRowDimension()][this.numCombs];
        if (this.tTestDesign == 7 && !this.useAllCombs) {
            for (int i = 0; i < this.numCombs; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                event2.setIntValue(i);
                event2.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                this.fireValueChanged(event2);
                int[] permutedExpts = new int[1];
                Vector<Integer> validExpts = new Vector<Integer>();
                for (int j = 0; j < this.groupAssignments.length; ++j) {
                    if (this.groupAssignments[j] == 3) continue;
                    validExpts.add(new Integer(j));
                }
                int[] validArray = new int[validExpts.size()];
                for (int j = 0; j < validArray.length; ++j) {
                    validArray[j] = (Integer)validExpts.get(j);
                }
                permutedExpts = this.getPermutedValues(this.numExps, validArray);
                FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                double[] currentPermTValues = this.getTwoClassUnpairedTValues(permutedMatrix);
                int[] currPermDfValues = this.getTwoClassDfs(permutedMatrix);
                double[] currPermPVals = this.getParametricPVals(currentPermTValues, currPermDfValues);
                for (int j = 0; j < currPermPVals.length; ++j) {
                    if (!Double.isNaN(currPermPVals[j])) continue;
                    currPermPVals[j] = Double.POSITIVE_INFINITY;
                }
                QSort sortCurrPVals = new QSort(currPermPVals, 1);
                double[] sortedCurrPVals = sortCurrPVals.getSortedDouble();
                for (int j = 0; j < pValMatrix.length; ++j) {
                    pValMatrix[j][i] = sortedCurrPVals[i];
                }
            }
        }
        return pValMatrix;
    }

    protected boolean[] isGeneSigByFDRNum() throws AlgorithmException {
        int i;
        double[] nonNanPVals = new double[this.origPVals.length];
        for (int i2 = 0; i2 < this.origPVals.length; ++i2) {
            nonNanPVals[i2] = Double.isNaN(this.origPVals[i2]) ? Double.POSITIVE_INFINITY : this.origPVals[i2];
        }
        QSort sortOrigPVals = new QSort(nonNanPVals, 1);
        double[] sortedOrigPVals = sortOrigPVals.getSortedDouble();
        int[] sortedIndices = sortOrigPVals.getOrigIndx();
        boolean[] isGeneSig = new boolean[this.numGenes];
        for (i = 0; i < isGeneSig.length; ++i) {
            isGeneSig[i] = false;
        }
        for (i = 0; i < this.falseNum; ++i) {
            isGeneSig[sortedIndices[i]] = true;
        }
        if (this.useFastFDRApprox) {
            double yK = this.getYConservative(this.alpha, this.falseNum);
            for (int i3 = this.falseNum; i3 < sortedOrigPVals.length && sortedOrigPVals[i3] < yK; ++i3) {
                isGeneSig[sortedIndices[i3]] = true;
            }
        } else {
            for (i = this.falseNum; i < this.origPVals.length; ++i) {
            }
        }
        return isGeneSig;
    }

    protected double[] getYKArray() throws AlgorithmException {
        double[] sortedCurrPVals;
        double[] currPermPVals;
        FloatMatrix permutedMatrix;
        int[] permutedExpts;
        AlgorithmEvent event2 = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(event2);
        event2.setId(2);
        int maxRGamma = (int)Math.floor((float)this.numGenes * this.falseProp);
        double[][] pValArray = new double[maxRGamma + 1][this.numCombs];
        if (this.tTestDesign == 8) {
            if (!this.useAllCombs) {
                int i;
                boolean[] changeSign = new boolean[1];
                Random rand = new Random();
                long[] randomSeeds = new long[this.numCombs];
                for (i = 0; i < this.numCombs; ++i) {
                    randomSeeds[i] = rand.nextLong();
                }
                for (i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(i);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(event2);
                    permutedExpts = new int[1];
                    Vector<Integer> validExpts = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] != 1) continue;
                        validExpts.add(new Integer(j));
                    }
                    int[] validArray = new int[validExpts.size()];
                    for (int j = 0; j < validArray.length; ++j) {
                        validArray[j] = (Integer)validExpts.get(j);
                    }
                    changeSign = this.getOneClassChangeSignArray(randomSeeds[i], validArray);
                    FloatMatrix permutedMatrix2 = this.getOneClassPermMatrix(this.expMatrix, changeSign);
                    double[] currentPermTValues = this.getOneClassTValues(permutedMatrix2);
                    int[] currPermDfValues = this.getOneClassDfs(permutedMatrix2);
                    double[] currPermPVals2 = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals2.length; ++j) {
                        if (!Double.isNaN(currPermPVals2[j])) continue;
                        currPermPVals2[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals2, 1);
                    double[] sortedCurrPVals2 = sortCurrPVals.getSortedDouble();
                    for (int j = 0; j < pValArray.length; ++j) {
                        pValArray[j][i] = sortedCurrPVals2[j];
                    }
                }
            } else {
                for (int i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(i);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(event2);
                    Vector<Integer> validExpts = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] != 1) continue;
                        validExpts.add(new Integer(j));
                    }
                    int[] validArray = new int[validExpts.size()];
                    for (int j = 0; j < validArray.length; ++j) {
                        validArray[j] = (Integer)validExpts.get(j);
                    }
                    boolean[] changeSign = this.getOneClassChangeSignArrayAllUniquePerms(i, validArray);
                    permutedMatrix = this.getOneClassPermMatrix(this.expMatrix, changeSign);
                    double[] currentPermTValues = this.getOneClassTValues(permutedMatrix);
                    int[] currPermDfValues = this.getOneClassDfs(permutedMatrix);
                    currPermPVals = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals.length; ++j) {
                        if (!Double.isNaN(currPermPVals[j])) continue;
                        currPermPVals[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals, 1);
                    sortedCurrPVals = sortCurrPVals.getSortedDouble();
                    for (int j = 0; j < pValArray.length; ++j) {
                        pValArray[j][i] = sortedCurrPVals[j];
                    }
                }
            }
        } else if (this.tTestDesign == 7) {
            if (!this.useAllCombs) {
                for (int i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(i);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(event2);
                    int[] permutedExpts2 = new int[1];
                    Vector<Integer> validExpts = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] == 3) continue;
                        validExpts.add(new Integer(j));
                    }
                    int[] validArray = new int[validExpts.size()];
                    for (int j = 0; j < validArray.length; ++j) {
                        validArray[j] = (Integer)validExpts.get(j);
                    }
                    permutedExpts2 = this.getPermutedValues(this.numExps, validArray);
                    permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts2);
                    double[] currentPermTValues = this.getTwoClassUnpairedTValues(permutedMatrix);
                    int[] currPermDfValues = this.getTwoClassDfs(permutedMatrix);
                    currPermPVals = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals.length; ++j) {
                        if (!Double.isNaN(currPermPVals[j])) continue;
                        currPermPVals[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals, 1);
                    sortedCurrPVals = sortCurrPVals.getSortedDouble();
                    for (int j = 0; j < pValArray.length; ++j) {
                        pValArray[j][i] = sortedCurrPVals[j];
                    }
                }
            } else {
                int[] permutedExpts3 = new int[this.numExps];
                for (int i = 0; i < this.numExps; ++i) {
                    permutedExpts3[i] = i;
                }
                Vector<Integer> usedExptsVector = new Vector<Integer>();
                int numGroupAValues = 0;
                for (int i = 0; i < this.groupAssignments.length; ++i) {
                    if (this.groupAssignments[i] != 3) {
                        usedExptsVector.add(new Integer(i));
                    }
                    if (this.groupAssignments[i] != 1) continue;
                    ++numGroupAValues;
                }
                int[] usedExptsArray = new int[usedExptsVector.size()];
                for (int i = 0; i < usedExptsArray.length; ++i) {
                    usedExptsArray[i] = (Integer)usedExptsVector.get(i);
                }
                int[] combArray = new int[numGroupAValues];
                for (int i = 0; i < combArray.length; ++i) {
                    combArray[i] = -1;
                }
                int numGroupBValues = usedExptsArray.length - numGroupAValues;
                int permCounter = 0;
                while (Combinations.enumerateCombinations((int)usedExptsArray.length, (int)numGroupAValues, (int[])combArray)) {
                    int i;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(permCounter);
                    event2.setDescription("Permuting matrix: Current permutation = " + (permCounter + 1));
                    this.fireValueChanged(event2);
                    int[] notInCombArray = new int[numGroupBValues];
                    int notCombCounter = 0;
                    for (i = 0; i < usedExptsArray.length; ++i) {
                        if (this.belongsInArray(i, combArray)) continue;
                        notInCombArray[notCombCounter] = i;
                        ++notCombCounter;
                    }
                    for (i = 0; i < combArray.length; ++i) {
                        permutedExpts3[usedExptsArray[i]] = usedExptsArray[combArray[i]];
                    }
                    for (i = 0; i < notInCombArray.length; ++i) {
                        permutedExpts3[usedExptsArray[combArray.length + i]] = usedExptsArray[notInCombArray[i]];
                    }
                    FloatMatrix permutedMatrix3 = this.getPermutedMatrix(this.expMatrix, permutedExpts3);
                    double[] currentPermTValues = this.getTwoClassUnpairedTValues(permutedMatrix3);
                    int[] currPermDfValues = this.getTwoClassDfs(permutedMatrix3);
                    double[] currPermPVals3 = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals3.length; ++j) {
                        if (!Double.isNaN(currPermPVals3[j])) continue;
                        currPermPVals3[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals3, 1);
                    double[] sortedCurrPVals3 = sortCurrPVals.getSortedDouble();
                    for (int j = 0; j < pValArray.length; ++j) {
                        pValArray[j][permCounter] = sortedCurrPVals3[j];
                    }
                    ++permCounter;
                }
            }
        } else if (this.tTestDesign == 11) {
            if (!this.useAllCombs) {
                Random rand = new Random();
                for (int i = 0; i < this.numCombs; ++i) {
                    event2.setIntValue(i);
                    event2.setDescription("Calculating raw p values: Current permutation = " + (i + 1));
                    this.fireValueChanged(event2);
                    long randomSeed = rand.nextLong();
                    if (this.stop) {
                        throw new AbortException();
                    }
                    permutedExpts = this.permuteWithinPairs(randomSeed);
                    FloatMatrix permutedMatrix4 = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                    double[] currentPermTValues = this.getPairedTValues(permutedMatrix4);
                    int[] currPermDfValues = this.getPairedDfs(permutedMatrix4);
                    double[] currPermPVals4 = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals4.length; ++j) {
                        if (!Double.isNaN(currPermPVals4[j])) continue;
                        currPermPVals4[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals4, 1);
                    double[] sortedCurrPVals4 = sortCurrPVals.getSortedDouble();
                    for (int j = 0; j < pValArray.length; ++j) {
                        pValArray[j][i] = sortedCurrPVals4[j];
                    }
                }
            } else {
                for (int i = 0; i < this.numCombs; ++i) {
                    event2.setIntValue(i);
                    event2.setDescription("Calculating raw p values: Current permutation = " + (i + 1));
                    this.fireValueChanged(event2);
                    int[] permutedExpts4 = this.permuteWithinPairsAllPerms(i);
                    FloatMatrix permutedMatrix5 = this.getPermutedMatrix(this.expMatrix, permutedExpts4);
                    double[] currentPermTValues = this.getPairedTValues(permutedMatrix5);
                    int[] currPermDfValues = this.getPairedDfs(permutedMatrix5);
                    double[] currPermPVals5 = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals5.length; ++j) {
                        if (!Double.isNaN(currPermPVals5[j])) continue;
                        currPermPVals5[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals5, 1);
                    double[] sortedCurrPVals5 = sortCurrPVals.getSortedDouble();
                    for (int j = 0; j < pValArray.length; ++j) {
                        pValArray[j][i] = sortedCurrPVals5[j];
                    }
                }
            }
        }
        double[] yKArray = new double[pValArray.length];
        for (int i = 0; i < pValArray.length; ++i) {
            int j;
            double[] currRow = new double[pValArray[i].length];
            for (j = 0; j < currRow.length; ++j) {
                currRow[j] = pValArray[i][j];
            }
            for (j = 0; j < currRow.length; ++j) {
                if (!Double.isNaN(currRow[j])) continue;
                currRow[j] = Double.POSITIVE_INFINITY;
            }
            QSort sortCurrRow = new QSort(currRow, 1);
            double[] sortedCurrRow = sortCurrRow.getSortedDouble();
            int selectedIndex = (int)Math.floor((float)sortedCurrRow.length * this.alpha) - 1;
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            yKArray[i] = sortedCurrRow[selectedIndex];
        }
        return yKArray;
    }

    protected double getYConservative(double alphaQuantile, int u) throws AlgorithmException {
        double[] sortedCurrPVals;
        double[] currPermPVals;
        FloatMatrix permutedMatrix;
        int[] permutedExpts;
        AlgorithmEvent event2 = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(event2);
        event2.setId(2);
        Vector<Double> uPlusOneSmallestPVector = new Vector<Double>();
        if (this.tTestDesign == 8) {
            if (!this.useAllCombs) {
                int i;
                boolean[] changeSign = new boolean[1];
                Random rand = new Random();
                long[] randomSeeds = new long[this.numCombs];
                for (i = 0; i < this.numCombs; ++i) {
                    randomSeeds[i] = rand.nextLong();
                }
                for (i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(i);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(event2);
                    permutedExpts = new int[1];
                    Vector<Integer> validExpts = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] != 1) continue;
                        validExpts.add(new Integer(j));
                    }
                    int[] validArray = new int[validExpts.size()];
                    for (int j = 0; j < validArray.length; ++j) {
                        validArray[j] = (Integer)validExpts.get(j);
                    }
                    changeSign = this.getOneClassChangeSignArray(randomSeeds[i], validArray);
                    FloatMatrix permutedMatrix2 = this.getOneClassPermMatrix(this.expMatrix, changeSign);
                    double[] currentPermTValues = this.getOneClassTValues(permutedMatrix2);
                    int[] currPermDfValues = this.getOneClassDfs(permutedMatrix2);
                    double[] currPermPVals2 = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals2.length; ++j) {
                        if (!Double.isNaN(currPermPVals2[j])) continue;
                        currPermPVals2[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals2, 1);
                    double[] sortedCurrPVals2 = sortCurrPVals.getSortedDouble();
                    uPlusOneSmallestPVector.add(new Double(sortedCurrPVals2[u]));
                }
            } else {
                for (int i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(i);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(event2);
                    Vector<Integer> validExpts = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] != 1) continue;
                        validExpts.add(new Integer(j));
                    }
                    int[] validArray = new int[validExpts.size()];
                    for (int j = 0; j < validArray.length; ++j) {
                        validArray[j] = (Integer)validExpts.get(j);
                    }
                    boolean[] changeSign = this.getOneClassChangeSignArrayAllUniquePerms(i, validArray);
                    permutedMatrix = this.getOneClassPermMatrix(this.expMatrix, changeSign);
                    double[] currentPermTValues = this.getOneClassTValues(permutedMatrix);
                    int[] currPermDfValues = this.getOneClassDfs(permutedMatrix);
                    currPermPVals = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals.length; ++j) {
                        if (!Double.isNaN(currPermPVals[j])) continue;
                        currPermPVals[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals, 1);
                    sortedCurrPVals = sortCurrPVals.getSortedDouble();
                    uPlusOneSmallestPVector.add(new Double(sortedCurrPVals[u]));
                }
            }
        } else if (this.tTestDesign == 7) {
            if (!this.useAllCombs) {
                for (int i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(i);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(event2);
                    int[] permutedExpts2 = new int[1];
                    Vector<Integer> validExpts = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] == 3) continue;
                        validExpts.add(new Integer(j));
                    }
                    int[] validArray = new int[validExpts.size()];
                    for (int j = 0; j < validArray.length; ++j) {
                        validArray[j] = (Integer)validExpts.get(j);
                    }
                    permutedExpts2 = this.getPermutedValues(this.numExps, validArray);
                    permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts2);
                    double[] currentPermTValues = this.getTwoClassUnpairedTValues(permutedMatrix);
                    int[] currPermDfValues = this.getTwoClassDfs(permutedMatrix);
                    currPermPVals = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals.length; ++j) {
                        if (!Double.isNaN(currPermPVals[j])) continue;
                        currPermPVals[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals, 1);
                    sortedCurrPVals = sortCurrPVals.getSortedDouble();
                    uPlusOneSmallestPVector.add(new Double(sortedCurrPVals[u]));
                }
            } else {
                int[] permutedExpts3 = new int[this.numExps];
                for (int i = 0; i < this.numExps; ++i) {
                    permutedExpts3[i] = i;
                }
                Vector<Integer> usedExptsVector = new Vector<Integer>();
                int numGroupAValues = 0;
                for (int i = 0; i < this.groupAssignments.length; ++i) {
                    if (this.groupAssignments[i] != 3) {
                        usedExptsVector.add(new Integer(i));
                    }
                    if (this.groupAssignments[i] != 1) continue;
                    ++numGroupAValues;
                }
                int[] usedExptsArray = new int[usedExptsVector.size()];
                for (int i = 0; i < usedExptsArray.length; ++i) {
                    usedExptsArray[i] = (Integer)usedExptsVector.get(i);
                }
                int[] combArray = new int[numGroupAValues];
                for (int i = 0; i < combArray.length; ++i) {
                    combArray[i] = -1;
                }
                int numGroupBValues = usedExptsArray.length - numGroupAValues;
                int permCounter = 0;
                while (Combinations.enumerateCombinations((int)usedExptsArray.length, (int)numGroupAValues, (int[])combArray)) {
                    int i;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(permCounter);
                    event2.setDescription("Permuting matrix: Current permutation = " + (permCounter + 1));
                    this.fireValueChanged(event2);
                    int[] notInCombArray = new int[numGroupBValues];
                    int notCombCounter = 0;
                    for (i = 0; i < usedExptsArray.length; ++i) {
                        if (this.belongsInArray(i, combArray)) continue;
                        notInCombArray[notCombCounter] = i;
                        ++notCombCounter;
                    }
                    for (i = 0; i < combArray.length; ++i) {
                        permutedExpts3[usedExptsArray[i]] = usedExptsArray[combArray[i]];
                    }
                    for (i = 0; i < notInCombArray.length; ++i) {
                        permutedExpts3[usedExptsArray[combArray.length + i]] = usedExptsArray[notInCombArray[i]];
                    }
                    FloatMatrix permutedMatrix3 = this.getPermutedMatrix(this.expMatrix, permutedExpts3);
                    double[] currentPermTValues = this.getTwoClassUnpairedTValues(permutedMatrix3);
                    int[] currPermDfValues = this.getTwoClassDfs(permutedMatrix3);
                    double[] currPermPVals3 = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals3.length; ++j) {
                        if (!Double.isNaN(currPermPVals3[j])) continue;
                        currPermPVals3[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals3, 1);
                    double[] sortedCurrPVals3 = sortCurrPVals.getSortedDouble();
                    uPlusOneSmallestPVector.add(new Double(sortedCurrPVals3[u]));
                    ++permCounter;
                }
            }
        } else if (this.tTestDesign == 11) {
            if (!this.useAllCombs) {
                Random rand = new Random();
                for (int i = 0; i < this.numCombs; ++i) {
                    event2.setIntValue(i);
                    event2.setDescription("Calculating raw p values: Current permutation = " + (i + 1));
                    this.fireValueChanged(event2);
                    long randomSeed = rand.nextLong();
                    if (this.stop) {
                        throw new AbortException();
                    }
                    permutedExpts = this.permuteWithinPairs(randomSeed);
                    FloatMatrix permutedMatrix4 = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                    double[] currentPermTValues = this.getPairedTValues(permutedMatrix4);
                    int[] currPermDfValues = this.getPairedDfs(permutedMatrix4);
                    double[] currPermPVals4 = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals4.length; ++j) {
                        if (!Double.isNaN(currPermPVals4[j])) continue;
                        currPermPVals4[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals4, 1);
                    double[] sortedCurrPVals4 = sortCurrPVals.getSortedDouble();
                    uPlusOneSmallestPVector.add(new Double(sortedCurrPVals4[u]));
                }
            } else {
                for (int i = 0; i < this.numCombs; ++i) {
                    event2.setIntValue(i);
                    event2.setDescription("Calculating raw p values: Current permutation = " + (i + 1));
                    this.fireValueChanged(event2);
                    int[] permutedExpts4 = this.permuteWithinPairsAllPerms(i);
                    FloatMatrix permutedMatrix5 = this.getPermutedMatrix(this.expMatrix, permutedExpts4);
                    double[] currentPermTValues = this.getPairedTValues(permutedMatrix5);
                    int[] currPermDfValues = this.getPairedDfs(permutedMatrix5);
                    double[] currPermPVals5 = this.getParametricPVals(currentPermTValues, currPermDfValues);
                    for (int j = 0; j < currPermPVals5.length; ++j) {
                        if (!Double.isNaN(currPermPVals5[j])) continue;
                        currPermPVals5[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort sortCurrPVals = new QSort(currPermPVals5, 1);
                    double[] sortedCurrPVals5 = sortCurrPVals.getSortedDouble();
                    uPlusOneSmallestPVector.add(new Double(sortedCurrPVals5[u]));
                }
            }
        }
        double[] uPlusOneSmallestArray = new double[uPlusOneSmallestPVector.size()];
        for (int i = 0; i < uPlusOneSmallestPVector.size(); ++i) {
            uPlusOneSmallestArray[i] = (Double)uPlusOneSmallestPVector.get(i);
        }
        QSort sortUPlusOneArray = new QSort(uPlusOneSmallestArray, 1);
        double[] sortedUPlusOneArray = sortUPlusOneArray.getSortedDouble();
        int selectedIndex = (int)Math.floor((double)sortedUPlusOneArray.length * alphaQuantile) - 1;
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        return sortedUPlusOneArray[selectedIndex];
    }

    protected double getMinY(double alphaQuantile, int r, int u) {
        return 0.0;
    }

    protected double[] getOneClassRawPValsFromPerms() throws AlgorithmException {
        int i;
        this.event = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        double[] rawPVals = new double[this.numGenes];
        for (i = 0; i < this.numGenes; ++i) {
            rawPVals[i] = Double.isNaN(this.tValues[i]) ? Double.NaN : 0.0;
        }
        if (!this.useAllCombs) {
            int i2;
            boolean[] changeSign = new boolean[1];
            Random rand = new Random();
            long[] randomSeeds = new long[this.numCombs];
            for (i2 = 0; i2 < this.numCombs; ++i2) {
                randomSeeds[i2] = rand.nextLong();
            }
            for (i2 = 0; i2 < this.numCombs; ++i2) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(i2);
                this.event.setDescription("Permuting matrix: Current permutation = " + (i2 + 1));
                this.fireValueChanged(this.event);
                int[] permutedExpts = new int[1];
                Vector<Integer> validExpts = new Vector<Integer>();
                for (int j = 0; j < this.groupAssignments.length; ++j) {
                    if (this.groupAssignments[j] != 1) continue;
                    validExpts.add(new Integer(j));
                }
                int[] validArray = new int[validExpts.size()];
                for (int j = 0; j < validArray.length; ++j) {
                    validArray[j] = (Integer)validExpts.get(j);
                }
                changeSign = this.getOneClassChangeSignArray(randomSeeds[i2], validArray);
                FloatMatrix permutedMatrix = this.getOneClassPermMatrix(this.expMatrix, changeSign);
                double[] currentPermTValues = this.getOneClassTValues(permutedMatrix);
                for (int gene = 0; gene < this.numGenes; ++gene) {
                    if (!(this.tValues[gene] < currentPermTValues[gene])) continue;
                    rawPVals[gene] = rawPVals[gene] + 1.0;
                }
            }
            for (i2 = 0; i2 < this.numGenes; ++i2) {
                rawPVals[i2] = rawPVals[i2] / (double)this.numCombs;
            }
        } else {
            for (i = 0; i < this.numCombs; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(i);
                this.event.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                this.fireValueChanged(this.event);
                Vector<Integer> validExpts = new Vector<Integer>();
                for (int j = 0; j < this.groupAssignments.length; ++j) {
                    if (this.groupAssignments[j] != 1) continue;
                    validExpts.add(new Integer(j));
                }
                int[] validArray = new int[validExpts.size()];
                for (int j = 0; j < validArray.length; ++j) {
                    validArray[j] = (Integer)validExpts.get(j);
                }
                boolean[] changeSign = this.getOneClassChangeSignArrayAllUniquePerms(i, validArray);
                FloatMatrix permutedMatrix = this.getOneClassPermMatrix(this.expMatrix, changeSign);
                double[] currentPermTValues = this.getOneClassTValues(permutedMatrix);
                for (int gene = 0; gene < this.numGenes; ++gene) {
                    if (!(this.tValues[gene] < currentPermTValues[gene])) continue;
                    rawPVals[gene] = rawPVals[gene] + 1.0;
                }
            }
            for (i = 0; i < this.numGenes; ++i) {
                rawPVals[i] = rawPVals[i] / (double)this.numCombs;
            }
        }
        return rawPVals;
    }

    protected float getAllCombsOneClassProb(int gene) {
        int validNumExps = this.getNumValidOneClassExpts();
        int numAllPossOneClassPerms = (int)Math.pow(2.0, validNumExps);
        float[] currentGene = this.expMatrix.A[gene];
        float[] origGeneValues = this.getOneClassGeneValues(gene);
        float origOneClassT = (float)Math.abs(this.getOneClassTValue(origGeneValues));
        if (Float.isNaN(origOneClassT)) {
            return Float.NaN;
        }
        int exceedCount = 0;
        for (int j = 0; j < numAllPossOneClassPerms; ++j) {
            boolean[] changeSign = this.getOneClassPermutArray(j);
            float[] randomizedGene = new float[currentGene.length];
            for (int l = 0; l < changeSign.length; ++l) {
                randomizedGene[l] = changeSign[l] ? currentGene[l] - 2.0f * (currentGene[l] - this.oneClassMean) : currentGene[l];
            }
            float[] reducedRandGene = new float[validNumExps];
            int count = 0;
            for (int l = 0; l < this.groupAssignments.length; ++l) {
                if (this.groupAssignments[l] != 1) continue;
                reducedRandGene[count] = randomizedGene[l];
                ++count;
            }
            double randTValue = Math.abs(this.getOneClassTValue(reducedRandGene));
            if (!(randTValue > (double)origOneClassT)) continue;
            ++exceedCount;
        }
        double prob = (double)exceedCount / (double)numAllPossOneClassPerms;
        return (float)prob;
    }

    protected boolean[] getOneClassChangeSignArray(long seed, int[] validExpts) {
        boolean[] changeSignArray = new boolean[this.numExps];
        for (int i = 0; i < changeSignArray.length; ++i) {
            changeSignArray[i] = false;
        }
        Random generator2 = new Random(seed);
        for (int i = 0; i < validExpts.length; ++i) {
            changeSignArray[validExpts[i]] = generator2.nextBoolean();
        }
        return changeSignArray;
    }

    protected FloatMatrix getOneClassPermMatrix(FloatMatrix inputMatrix, boolean[] changeSign) {
        FloatMatrix permutedMatrix = new FloatMatrix(inputMatrix.getRowDimension(), inputMatrix.getColumnDimension());
        for (int i = 0; i < inputMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < inputMatrix.getColumnDimension(); ++j) {
                permutedMatrix.A[i][j] = changeSign[j] ? inputMatrix.A[i][j] - 2.0f * (inputMatrix.A[i][j] - this.oneClassMean) : inputMatrix.A[i][j];
            }
        }
        return permutedMatrix;
    }

    protected boolean[] getOneClassChangeSignArrayAllUniquePerms(int num, int[] validExpts) {
        boolean[] changeSignArray = new boolean[this.numExps];
        for (int i = 0; i < changeSignArray.length; ++i) {
            changeSignArray[i] = false;
        }
        int numValidExps = validExpts.length;
        String binaryString = Integer.toBinaryString(num);
        char[] binArray = binaryString.toCharArray();
        if (binArray.length < numValidExps) {
            int i;
            Vector<Character> binVector = new Vector<Character>();
            for (i = 0; i < numValidExps - binArray.length; ++i) {
                binVector.add(new Character('0'));
            }
            for (i = 0; i < binArray.length; ++i) {
                binVector.add(new Character(binArray[i]));
            }
            binArray = new char[binVector.size()];
            for (i = 0; i < binArray.length; ++i) {
                binArray[i] = ((Character)binVector.get(i)).charValue();
            }
        }
        for (int i = 0; i < validExpts.length; ++i) {
            changeSignArray[validExpts[i]] = binArray[i] == '1';
        }
        return changeSignArray;
    }

    boolean[] getOneClassPermutArray(int num) {
        int i;
        boolean[] oneClassPermutArray = new boolean[this.numExps];
        for (int i2 = 0; i2 < oneClassPermutArray.length; ++i2) {
            oneClassPermutArray[i2] = false;
        }
        int validNumExps = this.getNumValidOneClassExpts();
        String binaryString = Integer.toBinaryString(num);
        char[] binArray = binaryString.toCharArray();
        if (binArray.length < validNumExps) {
            Vector<Character> binVector = new Vector<Character>();
            for (i = 0; i < validNumExps - binArray.length; ++i) {
                binVector.add(new Character('0'));
            }
            for (i = 0; i < binArray.length; ++i) {
                binVector.add(new Character(binArray[i]));
            }
            binArray = new char[binVector.size()];
            for (i = 0; i < binArray.length; ++i) {
                binArray[i] = ((Character)binVector.get(i)).charValue();
            }
        }
        int counter = 0;
        for (i = 0; i < oneClassPermutArray.length; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            oneClassPermutArray[i] = binArray[counter] == '1';
            ++counter;
        }
        return oneClassPermutArray;
    }

    public int getNumValidOneClassExpts() {
        int validNum = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            ++validNum;
        }
        return validNum;
    }

    protected float[] getOneClassGeneValues(int gene) {
        Vector<Float> currentGene = new Vector<Float>();
        for (int i = 0; i < this.numExps; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            currentGene.add(new Float(this.expMatrix.A[gene][i]));
        }
        float[] currGeneArray = new float[currentGene.size()];
        for (int i = 0; i < currGeneArray.length; ++i) {
            currGeneArray[i] = ((Float)currentGene.get(i)).floatValue();
        }
        return currGeneArray;
    }

    protected double getOneClassTValue(int gene, FloatMatrix inputMatrix) {
        Vector<Float> currentGene = new Vector<Float>();
        for (int i = 0; i < this.numExps; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            currentGene.add(new Float(inputMatrix.A[gene][i]));
        }
        float[] currGeneArray = new float[currentGene.size()];
        for (int i = 0; i < currGeneArray.length; ++i) {
            currGeneArray[i] = ((Float)currentGene.get(i)).floatValue();
        }
        return this.getOneClassTValue(currGeneArray);
    }

    protected float getSomeCombsOneClassProb(int gene) {
        int validNumExps = this.getNumValidOneClassExpts();
        float[] currentGene = this.expMatrix.A[gene];
        float[] origGeneValues = this.getOneClassGeneValues(gene);
        float origOneClassT = (float)Math.abs(this.getOneClassTValue(origGeneValues));
        if (Float.isNaN(origOneClassT)) {
            return Float.NaN;
        }
        Random rand = new Random();
        long[] randomSeeds = new long[this.numCombs];
        for (int i = 0; i < this.numCombs; ++i) {
            randomSeeds[i] = rand.nextLong();
        }
        int exceedCount = 0;
        for (int i = 0; i < this.numCombs; ++i) {
            boolean[] changeSign = this.getSomeCombsPermutArray(randomSeeds[i]);
            float[] randomizedGene = new float[origGeneValues.length];
            for (int l = 0; l < changeSign.length; ++l) {
                randomizedGene[l] = changeSign[l] ? origGeneValues[l] - 2.0f * (origGeneValues[l] - this.oneClassMean) : origGeneValues[l];
            }
            double randTValue = Math.abs(this.getOneClassTValue(randomizedGene));
            if (!(randTValue > (double)origOneClassT)) continue;
            ++exceedCount;
        }
        double prob = (double)exceedCount / (double)this.numCombs;
        return (float)prob;
    }

    protected boolean[] getSomeCombsPermutArray(long seed) {
        boolean[] boolArray = new boolean[this.getNumValidOneClassExpts()];
        for (int i = 0; i < boolArray.length; ++i) {
            boolArray[i] = false;
        }
        Random generator2 = new Random(seed);
        for (int i = 0; i < boolArray.length; ++i) {
            boolArray[i] = generator2.nextBoolean();
        }
        return boolArray;
    }

    protected double[] getPairedRawPValsFromPerms() throws AlgorithmException {
        int i;
        this.event = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        double[] rawPVals = new double[this.numGenes];
        for (i = 0; i < this.numGenes; ++i) {
            rawPVals[i] = Double.isNaN(this.tValues[i]) ? Double.NaN : 0.0;
        }
        if (!this.useAllCombs) {
            Random rand = new Random();
            for (int i2 = 0; i2 < this.numCombs; ++i2) {
                long randomSeed = rand.nextLong();
                if (this.stop) {
                    throw new AbortException();
                }
                int[] permutedExpts = this.permuteWithinPairs(randomSeed);
                FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                this.event.setIntValue(i2);
                this.event.setDescription("Calculating raw p values: Current permutation = " + (i2 + 1));
                this.fireValueChanged(this.event);
                for (int gene = 0; gene < this.numGenes; ++gene) {
                    double currT = this.getPairedTValue(gene, permutedMatrix);
                    if (!(this.tValues[gene] < currT)) continue;
                    rawPVals[gene] = rawPVals[gene] + 1.0;
                }
            }
        } else {
            for (i = 0; i < this.numCombs; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                int[] permutedExpts = this.permuteWithinPairsAllPerms(i);
                FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                this.event.setIntValue(i);
                this.event.setDescription("Calculating raw p values: Current permutation = " + (i + 1));
                this.fireValueChanged(this.event);
                for (int gene = 0; gene < this.numGenes; ++gene) {
                    double currT = this.getPairedTValue(gene, permutedMatrix);
                    if (!(this.tValues[gene] < currT)) continue;
                    rawPVals[gene] = rawPVals[gene] + 1.0;
                }
            }
        }
        for (int i3 = 0; i3 < this.numGenes; ++i3) {
            rawPVals[i3] = rawPVals[i3] / (double)this.numCombs;
        }
        return rawPVals;
    }

    protected int[] permuteWithinPairsAllPerms(int num) {
        int[] permutedValues = new int[this.numExps];
        for (int i = 0; i < permutedValues.length; ++i) {
            permutedValues[i] = i;
        }
        boolean[] changeSign = this.getChangeSignArrayForAllPairedPerms(num);
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            boolean swap = changeSign[i];
            if (!swap) continue;
            int temp = permutedValues[this.pairedGroupBExpts[i]];
            permutedValues[this.pairedGroupBExpts[i]] = permutedValues[this.pairedGroupAExpts[i]];
            permutedValues[this.pairedGroupAExpts[i]] = temp;
        }
        return permutedValues;
    }

    boolean[] getChangeSignArrayForAllPairedPerms(int num) {
        boolean[] permutArray = new boolean[this.pairedGroupAExpts.length];
        for (int i = 0; i < permutArray.length; ++i) {
            permutArray[i] = false;
        }
        int numPairs = this.pairedGroupAExpts.length;
        String binaryString = Integer.toBinaryString(num);
        char[] binArray = binaryString.toCharArray();
        if (binArray.length < numPairs) {
            int i;
            Vector<Character> binVector = new Vector<Character>();
            for (i = 0; i < numPairs - binArray.length; ++i) {
                binVector.add(new Character('0'));
            }
            for (i = 0; i < binArray.length; ++i) {
                binVector.add(new Character(binArray[i]));
            }
            binArray = new char[binVector.size()];
            for (i = 0; i < binArray.length; ++i) {
                binArray[i] = ((Character)binVector.get(i)).charValue();
            }
        }
        for (int i = 0; i < permutArray.length; ++i) {
            permutArray[i] = binArray[i] == '1';
        }
        return permutArray;
    }

    protected int[] permuteWithinPairs(long seed) {
        int[] permutedValues = new int[this.numExps];
        for (int i = 0; i < permutedValues.length; ++i) {
            permutedValues[i] = i;
        }
        Random generator2 = new Random(seed);
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            boolean swap = generator2.nextBoolean();
            if (!swap) continue;
            int temp = permutedValues[this.pairedGroupBExpts[i]];
            permutedValues[this.pairedGroupBExpts[i]] = permutedValues[this.pairedGroupAExpts[i]];
            permutedValues[this.pairedGroupAExpts[i]] = temp;
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return permutedValues;
    }

    protected double[] getTwoClassRawPValsFromPerms() throws AlgorithmException {
        int i;
        this.event = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        double[] rawPVals = new double[this.numGenes];
        for (i = 0; i < this.numGenes; ++i) {
            rawPVals[i] = Double.isNaN(this.tValues[i]) ? Double.NaN : 0.0;
        }
        if (!this.useAllCombs) {
            for (i = 0; i < this.numCombs; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(i);
                this.event.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                this.fireValueChanged(this.event);
                int[] permutedExpts = new int[1];
                Vector<Integer> validExpts = new Vector<Integer>();
                for (int j = 0; j < this.groupAssignments.length; ++j) {
                    if (this.groupAssignments[j] == 3) continue;
                    validExpts.add(new Integer(j));
                }
                int[] validArray = new int[validExpts.size()];
                for (int j = 0; j < validArray.length; ++j) {
                    validArray[j] = (Integer)validExpts.get(j);
                }
                permutedExpts = this.getPermutedValues(this.numExps, validArray);
                FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                double[] currentPermTValues = this.getTwoClassUnpairedTValues(permutedMatrix);
                for (int gene = 0; gene < this.numGenes; ++gene) {
                    if (!(this.tValues[gene] < currentPermTValues[gene])) continue;
                    rawPVals[gene] = rawPVals[gene] + 1.0;
                }
            }
            for (i = 0; i < this.numGenes; ++i) {
                rawPVals[i] = rawPVals[i] / (double)this.numCombs;
            }
        } else {
            int[] permutedExpts = new int[this.numExps];
            for (int i2 = 0; i2 < this.numExps; ++i2) {
                permutedExpts[i2] = i2;
            }
            Vector<Integer> usedExptsVector = new Vector<Integer>();
            int numGroupAValues = 0;
            for (int i3 = 0; i3 < this.groupAssignments.length; ++i3) {
                if (this.groupAssignments[i3] != 3) {
                    usedExptsVector.add(new Integer(i3));
                }
                if (this.groupAssignments[i3] != 1) continue;
                ++numGroupAValues;
            }
            int[] usedExptsArray = new int[usedExptsVector.size()];
            for (int i4 = 0; i4 < usedExptsArray.length; ++i4) {
                usedExptsArray[i4] = (Integer)usedExptsVector.get(i4);
            }
            int[] combArray = new int[numGroupAValues];
            for (int i5 = 0; i5 < combArray.length; ++i5) {
                combArray[i5] = -1;
            }
            int numGroupBValues = usedExptsArray.length - numGroupAValues;
            int permCounter = 0;
            while (Combinations.enumerateCombinations((int)usedExptsArray.length, (int)numGroupAValues, (int[])combArray)) {
                int i6;
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(permCounter);
                this.event.setDescription("Permuting matrix: Current permutation = " + (permCounter + 1));
                this.fireValueChanged(this.event);
                int[] notInCombArray = new int[numGroupBValues];
                int notCombCounter = 0;
                for (i6 = 0; i6 < usedExptsArray.length; ++i6) {
                    if (this.belongsInArray(i6, combArray)) continue;
                    notInCombArray[notCombCounter] = i6;
                    ++notCombCounter;
                }
                for (i6 = 0; i6 < combArray.length; ++i6) {
                    permutedExpts[usedExptsArray[i6]] = usedExptsArray[combArray[i6]];
                }
                for (i6 = 0; i6 < notInCombArray.length; ++i6) {
                    permutedExpts[usedExptsArray[combArray.length + i6]] = usedExptsArray[notInCombArray[i6]];
                }
                FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                double[] currentPermTValues = this.getTwoClassUnpairedTValues(permutedMatrix);
                for (int gene = 0; gene < this.numGenes; ++gene) {
                    if (!(this.tValues[gene] < currentPermTValues[gene])) continue;
                    rawPVals[gene] = rawPVals[gene] + 1.0;
                }
                ++permCounter;
            }
            for (int i7 = 0; i7 < this.numGenes; ++i7) {
                rawPVals[i7] = rawPVals[i7] / (double)permCounter;
            }
        }
        return rawPVals;
    }

    protected float[][] randomlyPermute(float[] gene, int[] groupedExpts, int groupALength, int groupBLength) {
        int i;
        float[][] groupedValues = new float[][]{new float[groupALength], new float[groupBLength]};
        if (groupALength > groupBLength) {
            groupedValues[0] = new float[groupBLength];
            groupedValues[1] = new float[groupALength];
        }
        Vector<Integer> groupedExptsVector = new Vector<Integer>();
        for (i = 0; i < groupedExpts.length; ++i) {
            groupedExptsVector.add(new Integer(groupedExpts[i]));
        }
        for (i = 0; i < groupedValues[0].length; ++i) {
            int randInt = (int)Math.round(Math.random() * (double)(groupedExptsVector.size() - 1));
            int randIndex = (Integer)groupedExptsVector.remove(randInt);
            groupedValues[0][i] = gene[randIndex];
        }
        for (i = 0; i < groupedValues[1].length; ++i) {
            int index = (Integer)groupedExptsVector.get(i);
            groupedValues[1][i] = gene[index];
        }
        return groupedValues;
    }

    protected double[] getParametricPVals(double[] tVals, int[] dfs) {
        double[] pVals = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            if (Double.isNaN(tVals[i])) {
                pVals[i] = Double.NaN;
                continue;
            }
            TDistribution tDist = new TDistribution(dfs[i]);
            double cumulP = tDist.cumulative(tVals[i]);
            double prob = 2.0 * (1.0 - cumulP);
            if (prob > 1.0) {
                prob = 1.0;
            }
            pVals[i] = prob;
        }
        return pVals;
    }

    protected double[] getRawPValsFromTDist() throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        double[] rawPVals = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(i);
            this.event.setDescription("Calculating raw p values: Current gene = " + (i + 1));
            this.fireValueChanged(this.event);
            if (Double.isNaN(this.tValues[i])) {
                rawPVals[i] = Double.NaN;
                continue;
            }
            TDistribution tDist = new TDistribution((int)this.dfValues[i]);
            double cumulP = tDist.cumulative(this.tValues[i]);
            double prob = 2.0 * (1.0 - cumulP);
            if (prob > 1.0) {
                prob = 1.0;
            }
            rawPVals[i] = prob;
        }
        return rawPVals;
    }

    protected double[] getAdjPVals(double[] rawPVals, int adjMethod) throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        double[] adjPVals = new double[rawPVals.length];
        if (adjMethod == 4) {
            adjPVals = rawPVals;
        }
        if (adjMethod == 5) {
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(i);
                this.event.setDescription("Computing adjusted p-values: Current gene = " + (i + 1));
                this.fireValueChanged(this.event);
                double currP = rawPVals[i];
                double currAdjP = currP * (double)this.numGenes;
                if (currAdjP > 1.0) {
                    currAdjP = 1.0;
                }
                adjPVals[i] = currAdjP;
            }
        }
        if (adjMethod == 6) {
            adjPVals = this.getAdjBonfPVals(rawPVals);
        }
        if (adjMethod == 9) {
            adjPVals = this.getMaxTPVals();
        }
        return adjPVals;
    }

    protected double[] getMaxTPVals() throws AlgorithmException {
        int i;
        QSort sortDescTValues;
        double[] origTValues = this.tValues;
        double[] descTValues = new double[this.numGenes];
        int[] descGeneIndices = new int[this.numGenes];
        double[] adjPValues = new double[this.numGenes];
        double[][] permutedRankedTValues = new double[this.numCombs][this.numGenes];
        double[][] uMatrix = new double[this.numGenes][this.numCombs];
        AlgorithmEvent event2 = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(event2);
        event2.setId(2);
        if (this.tTestDesign == 7) {
            sortDescTValues = new QSort(origTValues, 2);
            descTValues = sortDescTValues.getSortedDouble();
            descGeneIndices = sortDescTValues.getOrigIndx();
            if (!this.useAllCombs) {
                for (i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(i);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(event2);
                    int[] permutedExpts = new int[1];
                    Vector<Integer> validExpts = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] == 3) continue;
                        validExpts.add(new Integer(j));
                    }
                    int[] validArray = new int[validExpts.size()];
                    for (int j = 0; j < validArray.length; ++j) {
                        validArray[j] = (Integer)validExpts.get(j);
                    }
                    permutedExpts = this.getPermutedValues(this.numExps, validArray);
                    FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                    double[] currentPermTValues = this.getTwoClassUnpairedTValues(permutedMatrix);
                    uMatrix[this.numGenes - 1][i] = Double.isNaN(currentPermTValues[descGeneIndices[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : currentPermTValues[descGeneIndices[this.numGenes - 1]];
                    for (int j = this.numGenes - 2; j >= 0; --j) {
                        uMatrix[j][i] = Double.isNaN(currentPermTValues[descGeneIndices[j]]) ? uMatrix[j + 1][i] : Math.max(uMatrix[j + 1][i], currentPermTValues[descGeneIndices[j]]);
                    }
                }
            } else {
                int[] permutedExpts = new int[this.numExps];
                for (int i2 = 0; i2 < this.numExps; ++i2) {
                    permutedExpts[i2] = i2;
                }
                Vector<Integer> usedExptsVector = new Vector<Integer>();
                int numGroupAValues = 0;
                for (int i3 = 0; i3 < this.groupAssignments.length; ++i3) {
                    if (this.groupAssignments[i3] != 3) {
                        usedExptsVector.add(new Integer(i3));
                    }
                    if (this.groupAssignments[i3] != 1) continue;
                    ++numGroupAValues;
                }
                int[] usedExptsArray = new int[usedExptsVector.size()];
                for (int i4 = 0; i4 < usedExptsArray.length; ++i4) {
                    usedExptsArray[i4] = (Integer)usedExptsVector.get(i4);
                }
                int[] combArray = new int[numGroupAValues];
                for (int i5 = 0; i5 < combArray.length; ++i5) {
                    combArray[i5] = -1;
                }
                int numGroupBValues = usedExptsArray.length - numGroupAValues;
                int permCounter = 0;
                while (Combinations.enumerateCombinations((int)usedExptsArray.length, (int)numGroupAValues, (int[])combArray)) {
                    int i6;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(permCounter);
                    event2.setDescription("Permuting matrix: Current permutation = " + (permCounter + 1));
                    this.fireValueChanged(event2);
                    int[] notInCombArray = new int[numGroupBValues];
                    int notCombCounter = 0;
                    for (i6 = 0; i6 < usedExptsArray.length; ++i6) {
                        if (this.belongsInArray(i6, combArray)) continue;
                        notInCombArray[notCombCounter] = i6;
                        ++notCombCounter;
                    }
                    for (i6 = 0; i6 < combArray.length; ++i6) {
                        permutedExpts[usedExptsArray[i6]] = usedExptsArray[combArray[i6]];
                    }
                    for (i6 = 0; i6 < notInCombArray.length; ++i6) {
                        permutedExpts[usedExptsArray[combArray.length + i6]] = usedExptsArray[notInCombArray[i6]];
                    }
                    FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                    double[] currentPermTValues = this.getTwoClassUnpairedTValues(permutedMatrix);
                    uMatrix[this.numGenes - 1][permCounter] = Double.isNaN(currentPermTValues[descGeneIndices[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : currentPermTValues[descGeneIndices[this.numGenes - 1]];
                    for (int j = this.numGenes - 2; j >= 0; --j) {
                        uMatrix[j][permCounter] = Double.isNaN(currentPermTValues[descGeneIndices[j]]) ? uMatrix[j + 1][permCounter] : Math.max(uMatrix[j + 1][permCounter], currentPermTValues[descGeneIndices[j]]);
                    }
                    ++permCounter;
                }
            }
        } else if (this.tTestDesign == 11) {
            sortDescTValues = new QSort(origTValues, 2);
            descTValues = sortDescTValues.getSortedDouble();
            descGeneIndices = sortDescTValues.getOrigIndx();
            if (!this.useAllCombs) {
                Random rand = new Random();
                for (int i7 = 0; i7 < this.numCombs; ++i7) {
                    long randomSeed = rand.nextLong();
                    if (this.stop) {
                        throw new AbortException();
                    }
                    int[] permutedExpts = this.permuteWithinPairs(randomSeed);
                    FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                    event2.setIntValue(i7);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i7 + 1));
                    this.fireValueChanged(event2);
                    double[] currentPermTValues = new double[this.numGenes];
                    for (int gene = 0; gene < this.numGenes; ++gene) {
                        currentPermTValues[gene] = this.getPairedTValue(gene, permutedMatrix);
                    }
                    uMatrix[this.numGenes - 1][i7] = Double.isNaN(currentPermTValues[descGeneIndices[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : currentPermTValues[descGeneIndices[this.numGenes - 1]];
                    for (int j = this.numGenes - 2; j >= 0; --j) {
                        uMatrix[j][i7] = Double.isNaN(currentPermTValues[descGeneIndices[j]]) ? uMatrix[j + 1][i7] : Math.max(uMatrix[j + 1][i7], currentPermTValues[descGeneIndices[j]]);
                    }
                }
            } else {
                for (int i8 = 0; i8 < this.numCombs; ++i8) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    int[] permutedExpts = this.permuteWithinPairsAllPerms(i8);
                    FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                    event2.setIntValue(i8);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i8 + 1));
                    this.fireValueChanged(event2);
                    double[] currentPermTValues = new double[this.numGenes];
                    for (int gene = 0; gene < this.numGenes; ++gene) {
                        currentPermTValues[gene] = this.getPairedTValue(gene, permutedMatrix);
                    }
                    uMatrix[this.numGenes - 1][i8] = Double.isNaN(currentPermTValues[descGeneIndices[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : currentPermTValues[descGeneIndices[this.numGenes - 1]];
                    for (int j = this.numGenes - 2; j >= 0; --j) {
                        uMatrix[j][i8] = Double.isNaN(currentPermTValues[descGeneIndices[j]]) ? uMatrix[j + 1][i8] : Math.max(uMatrix[j + 1][i8], currentPermTValues[descGeneIndices[j]]);
                    }
                }
            }
        } else if (this.tTestDesign == 8) {
            sortDescTValues = new QSort(origTValues, 2);
            descTValues = sortDescTValues.getSortedDouble();
            descGeneIndices = sortDescTValues.getOrigIndx();
            if (!this.useAllCombs) {
                int i9;
                boolean[] changeSign = new boolean[1];
                Random rand = new Random();
                long[] randomSeeds = new long[this.numCombs];
                for (i9 = 0; i9 < this.numCombs; ++i9) {
                    randomSeeds[i9] = rand.nextLong();
                }
                for (i9 = 0; i9 < this.numCombs; ++i9) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(i9);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i9 + 1));
                    this.fireValueChanged(event2);
                    int[] permutedExpts = new int[1];
                    Vector<Integer> validExpts = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] != 1) continue;
                        validExpts.add(new Integer(j));
                    }
                    int[] validArray = new int[validExpts.size()];
                    for (int j = 0; j < validArray.length; ++j) {
                        validArray[j] = (Integer)validExpts.get(j);
                    }
                    changeSign = this.getOneClassChangeSignArray(randomSeeds[i9], validArray);
                    FloatMatrix permutedMatrix = this.getOneClassPermMatrix(this.expMatrix, changeSign);
                    double[] currentPermTValues = this.getOneClassTValues(permutedMatrix);
                    uMatrix[this.numGenes - 1][i9] = Double.isNaN(currentPermTValues[descGeneIndices[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : currentPermTValues[descGeneIndices[this.numGenes - 1]];
                    for (int j = this.numGenes - 2; j >= 0; --j) {
                        uMatrix[j][i9] = Double.isNaN(currentPermTValues[descGeneIndices[j]]) ? uMatrix[j + 1][i9] : Math.max(uMatrix[j + 1][i9], currentPermTValues[descGeneIndices[j]]);
                    }
                }
            } else {
                for (int i10 = 0; i10 < this.numCombs; ++i10) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(i10);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i10 + 1));
                    this.fireValueChanged(event2);
                    Vector<Integer> validExpts = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] != 1) continue;
                        validExpts.add(new Integer(j));
                    }
                    int[] validArray = new int[validExpts.size()];
                    for (int j = 0; j < validArray.length; ++j) {
                        validArray[j] = (Integer)validExpts.get(j);
                    }
                    boolean[] changeSign = this.getOneClassChangeSignArrayAllUniquePerms(i10, validArray);
                    FloatMatrix permutedMatrix = this.getOneClassPermMatrix(this.expMatrix, changeSign);
                    double[] currentPermTValues = this.getOneClassTValues(permutedMatrix);
                    uMatrix[this.numGenes - 1][i10] = Double.isNaN(currentPermTValues[descGeneIndices[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : currentPermTValues[descGeneIndices[this.numGenes - 1]];
                    for (int j = this.numGenes - 2; j >= 0; --j) {
                        uMatrix[j][i10] = Double.isNaN(currentPermTValues[descGeneIndices[j]]) ? uMatrix[j + 1][i10] : Math.max(uMatrix[j + 1][i10], currentPermTValues[descGeneIndices[j]]);
                    }
                }
            }
        }
        for (int i11 = 0; i11 < this.numGenes; ++i11) {
            int pCounter = 0;
            for (int j = 0; j < this.numCombs; ++j) {
                if (!(uMatrix[i11][j] >= descTValues[i11])) continue;
                ++pCounter;
            }
            adjPValues[descGeneIndices[i11]] = (double)pCounter / (double)this.numCombs;
        }
        int NaNPCounter = 0;
        for (i = 0; i < this.numGenes; ++i) {
            if (!Double.isNaN(origTValues[i])) continue;
            adjPValues[i] = Double.NaN;
            ++NaNPCounter;
        }
        for (i = 1; i < this.numGenes - NaNPCounter; ++i) {
            adjPValues[descGeneIndices[i]] = Math.max(adjPValues[descGeneIndices[i]], adjPValues[descGeneIndices[i - 1]]);
        }
        return adjPValues;
    }

    double[] getOneClassTValues(FloatMatrix inputMatrix) {
        double[] tValsFromMatrix = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            tValsFromMatrix[i] = Math.abs(this.getOneClassTValue(i, inputMatrix));
        }
        return tValsFromMatrix;
    }

    protected boolean belongsInArray(int i, int[] arr) {
        boolean belongs = false;
        for (int j = 0; j < arr.length; ++j) {
            if (i != arr[j]) continue;
            belongs = true;
            break;
        }
        return belongs;
    }

    protected float getTValue(int gene, FloatMatrix inputMatrix) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = inputMatrix.A[gene][i];
        }
        int groupACounter = 0;
        int groupBCounter = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++groupACounter;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++groupBCounter;
        }
        float[] groupAValues = new float[groupACounter];
        float[] groupBValues = new float[groupBCounter];
        groupACounter = 0;
        groupBCounter = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                groupAValues[groupACounter] = geneValues[i];
                ++groupACounter;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            groupBValues[groupBCounter] = geneValues[i];
            ++groupBCounter;
        }
        float tValue = this.calculateTValue(groupAValues, groupBValues);
        return tValue;
    }

    protected double[] getTwoClassUnpairedTValues(FloatMatrix inputMatrix) {
        double[] tValsFromMatrix = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            tValsFromMatrix[i] = Math.abs(this.getTValue(i, inputMatrix));
        }
        return tValsFromMatrix;
    }

    protected FloatMatrix getPermutedMatrix(FloatMatrix inputMatrix, int[] permExpts) {
        FloatMatrix permutedMatrix = new FloatMatrix(inputMatrix.getRowDimension(), inputMatrix.getColumnDimension());
        for (int i = 0; i < inputMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < inputMatrix.getColumnDimension(); ++j) {
                permutedMatrix.A[i][j] = inputMatrix.A[i][permExpts[j]];
            }
        }
        return permutedMatrix;
    }

    protected int[] getPermutedValues(int arrayLength, int[] validArray) {
        int i;
        int[] permutedValues = new int[arrayLength];
        for (int i2 = 0; i2 < permutedValues.length; ++i2) {
            permutedValues[i2] = i2;
        }
        int[] permutedValidArray = new int[validArray.length];
        for (i = 0; i < validArray.length; ++i) {
            permutedValidArray[i] = validArray[i];
        }
        for (i = permutedValidArray.length; i > 1; --i) {
            Random generator2 = new Random();
            int randVal = generator2.nextInt(i - 1);
            int temp = permutedValidArray[randVal];
            permutedValidArray[randVal] = permutedValidArray[i - 1];
            permutedValidArray[i - 1] = temp;
        }
        for (i = 0; i < validArray.length; ++i) {
            permutedValues[validArray[i]] = permutedValidArray[i];
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return permutedValues;
    }

    protected double[] getAdjBonfPVals(double[] rawPValArray) {
        int i;
        double[] adjPValArray = new double[rawPValArray.length];
        this.isSig = new boolean[rawPValArray.length];
        for (int i2 = 0; i2 < this.isSig.length; ++i2) {
            this.isSig[i2] = false;
        }
        QSort sortRawPs = new QSort(rawPValArray, 1);
        double[] sortedRawPVals = sortRawPs.getSortedDouble();
        int[] origIndices = sortRawPs.getOrigIndx();
        int n = this.numGenes;
        adjPValArray[origIndices[0]] = sortedRawPVals[0] * (double)n;
        for (i = 1; i < this.numGenes; ++i) {
            if (sortedRawPVals[i - 1] < sortedRawPVals[i]) {
                --n;
            }
            if (n <= 0) {
                n = 1;
            }
            adjPValArray[origIndices[i]] = sortedRawPVals[i] * (double)n;
        }
        for (i = 0; i < adjPValArray.length; ++i) {
            if (!(adjPValArray[i] > 1.0)) continue;
            adjPValArray[i] = 1.0;
        }
        for (i = 0; i < origIndices.length && !(adjPValArray[origIndices[i]] > (double)this.alpha); ++i) {
            if (!(adjPValArray[origIndices[i]] <= (double)this.alpha)) continue;
            this.isSig[origIndices[i]] = true;
        }
        return adjPValArray;
    }

    protected int[] getPairedDfs(FloatMatrix inputMatrix) {
        int[] pairedDfs = new int[this.numGenes];
        for (int gene = 0; gene < this.numGenes; ++gene) {
            float[] geneValues = new float[this.numExps];
            for (int i = 0; i < this.numExps; ++i) {
                geneValues[i] = inputMatrix.A[gene][i];
            }
            float[] groupAValues = new float[this.pairedGroupAExpts.length];
            float[] groupBValues = new float[this.pairedGroupBExpts.length];
            int numbValidValuesA = 0;
            int numbValidValuesB = 0;
            for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
                groupAValues[i] = geneValues[this.pairedGroupAExpts[i]];
                if (!Float.isNaN(geneValues[this.pairedGroupAExpts[i]])) {
                    ++numbValidValuesA;
                }
                groupBValues[i] = geneValues[this.pairedGroupBExpts[i]];
                if (Float.isNaN(geneValues[this.pairedGroupBExpts[i]])) continue;
                ++numbValidValuesB;
            }
            if (numbValidValuesA < 2 || numbValidValuesB < 2) {
                pairedDfs[gene] = -1;
                continue;
            }
            int N = 0;
            for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
                if (Double.isNaN(inputMatrix.A[gene][this.pairedGroupAExpts[i]]) || Double.isNaN(inputMatrix.A[gene][this.pairedGroupBExpts[i]])) continue;
                ++N;
            }
            pairedDfs[gene] = N - 1;
        }
        return pairedDfs;
    }

    protected int[] getTwoClassDfs(FloatMatrix inputMatrix) {
        int[] twoClassDfs = new int[this.numGenes];
        for (int gene = 0; gene < this.numGenes; ++gene) {
            float[] geneValues = new float[this.numExps];
            for (int i = 0; i < this.numExps; ++i) {
                geneValues[i] = inputMatrix.A[gene][i];
            }
            int groupACounter = 0;
            int groupBCounter = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    ++groupACounter;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                ++groupBCounter;
            }
            float[] groupAValues = new float[groupACounter];
            float[] groupBValues = new float[groupBCounter];
            int numbValidValuesA = 0;
            int numbValidValuesB = 0;
            groupACounter = 0;
            groupBCounter = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    groupAValues[groupACounter] = geneValues[i];
                    if (!Float.isNaN(geneValues[i])) {
                        ++numbValidValuesA;
                    }
                    ++groupACounter;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                groupBValues[groupBCounter] = geneValues[i];
                if (!Float.isNaN(geneValues[i])) {
                    ++numbValidValuesB;
                }
                ++groupBCounter;
            }
            twoClassDfs[gene] = numbValidValuesA < 2 || numbValidValuesB < 2 ? -1 : this.calculateDf(groupAValues, groupBValues);
        }
        return twoClassDfs;
    }

    protected int[] getOneClassDfs(FloatMatrix inputMatrix) {
        int[] oneClassDfValues = new int[this.numGenes];
        for (int gene = 0; gene < this.numGenes; ++gene) {
            Vector<Float> currentGene = new Vector<Float>();
            for (int i = 0; i < this.numExps; ++i) {
                if (this.groupAssignments[i] != 1) continue;
                currentGene.add(new Float(inputMatrix.A[gene][i]));
            }
            float[] currGeneArray = new float[currentGene.size()];
            for (int i = 0; i < currGeneArray.length; ++i) {
                currGeneArray[i] = ((Float)currentGene.get(i)).floatValue();
            }
            int validNum = 0;
            for (int i = 0; i < currGeneArray.length; ++i) {
                if (Float.isNaN(currGeneArray[i])) continue;
                ++validNum;
            }
            oneClassDfValues[gene] = validNum - 1;
        }
        return oneClassDfValues;
    }

    protected void computeOneClassOrigVals() throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.oneClassMeans = new double[this.numGenes];
        this.oneClassSDs = new double[this.numGenes];
        this.dfValues = new double[this.numGenes];
        this.tValues = new double[this.numGenes];
        for (int gene = 0; gene < this.numGenes; ++gene) {
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(gene);
            this.event.setDescription("Calculating t values: Current gene = " + (gene + 1));
            this.fireValueChanged(this.event);
            Vector<Float> currentGene = new Vector<Float>();
            for (int i = 0; i < this.numExps; ++i) {
                if (this.groupAssignments[i] != 1) continue;
                currentGene.add(new Float(this.expMatrix.A[gene][i]));
            }
            float[] currGeneArray = new float[currentGene.size()];
            for (int i = 0; i < currGeneArray.length; ++i) {
                currGeneArray[i] = ((Float)currentGene.get(i)).floatValue();
            }
            this.tValues[gene] = this.getOneClassTValue(currGeneArray);
            this.oneClassMeans[gene] = this.getMean(currGeneArray);
            this.oneClassSDs[gene] = Math.sqrt(this.getVar(currGeneArray));
            int validNum = 0;
            for (int i = 0; i < currGeneArray.length; ++i) {
                if (Float.isNaN(currGeneArray[i])) continue;
                ++validNum;
            }
            this.dfValues[gene] = validNum - 1;
        }
    }

    protected double getOneClassTValue(float[] geneArray) {
        float mean = this.getMean(geneArray);
        double stdDev = Math.sqrt(this.getVar(geneArray));
        int validNum = 0;
        for (int i = 0; i < geneArray.length; ++i) {
            if (Float.isNaN(geneArray[i])) continue;
            ++validNum;
        }
        double stdErr = stdDev / Math.sqrt(validNum);
        double tValue = (double)(mean - this.oneClassMean) / stdErr;
        return Math.abs(tValue);
    }

    protected void computePairedOrigVals() throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.groupAMeans = new double[this.numGenes];
        this.groupBMeans = new double[this.numGenes];
        this.groupASDs = new double[this.numGenes];
        this.groupBSDs = new double[this.numGenes];
        this.dfValues = new double[this.numGenes];
        this.tValues = new double[this.numGenes];
        for (int gene = 0; gene < this.numGenes; ++gene) {
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(gene);
            this.event.setDescription("Calculating t values: Current gene = " + (gene + 1));
            this.fireValueChanged(this.event);
            float[] geneValues = new float[this.numExps];
            for (int i = 0; i < this.numExps; ++i) {
                geneValues[i] = this.expMatrix.A[gene][i];
            }
            float[] groupAValues = new float[this.pairedGroupAExpts.length];
            float[] groupBValues = new float[this.pairedGroupBExpts.length];
            int numbValidValuesA = 0;
            int numbValidValuesB = 0;
            for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
                groupAValues[i] = geneValues[this.pairedGroupAExpts[i]];
                if (!Float.isNaN(geneValues[this.pairedGroupAExpts[i]])) {
                    ++numbValidValuesA;
                }
                groupBValues[i] = geneValues[this.pairedGroupBExpts[i]];
                if (Float.isNaN(geneValues[this.pairedGroupBExpts[i]])) continue;
                ++numbValidValuesB;
            }
            if (numbValidValuesA < 2 || numbValidValuesB < 2) {
                this.tValues[gene] = Double.NaN;
                this.dfValues[gene] = Double.NaN;
                this.groupAMeans[gene] = Double.NaN;
                this.groupBMeans[gene] = Double.NaN;
                this.groupASDs[gene] = Double.NaN;
                this.groupBSDs[gene] = Double.NaN;
                continue;
            }
            this.tValues[gene] = this.getPairedTValue(gene, this.expMatrix);
            int N = 0;
            for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
                if (Double.isNaN(this.expMatrix.A[gene][this.pairedGroupAExpts[i]]) || Double.isNaN(this.expMatrix.A[gene][this.pairedGroupBExpts[i]])) continue;
                ++N;
            }
            this.dfValues[gene] = N - 1;
            this.groupAMeans[gene] = this.getMean(groupAValues);
            this.groupBMeans[gene] = this.getMean(groupBValues);
            this.groupASDs[gene] = Math.sqrt(this.getVar(groupAValues));
            this.groupBSDs[gene] = Math.sqrt(this.getVar(groupBValues));
        }
    }

    protected double getPairedTValue(int gene, FloatMatrix inputMatrix) {
        double sumDev = 0.0;
        int N = 0;
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            if (Double.isNaN(inputMatrix.A[gene][this.pairedGroupAExpts[i]]) || Double.isNaN(inputMatrix.A[gene][this.pairedGroupBExpts[i]])) continue;
            sumDev += (double)(inputMatrix.A[gene][this.pairedGroupAExpts[i]] - inputMatrix.A[gene][this.pairedGroupBExpts[i]]);
            ++N;
        }
        if (N < 2) {
            return Double.NaN;
        }
        double meanDev = sumDev / (double)N;
        double sumSquaredDev = 0.0;
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            if (Double.isNaN(inputMatrix.A[gene][this.pairedGroupAExpts[i]]) || Double.isNaN(inputMatrix.A[gene][this.pairedGroupBExpts[i]])) continue;
            sumSquaredDev += Math.pow(inputMatrix.A[gene][this.pairedGroupAExpts[i]] - inputMatrix.A[gene][this.pairedGroupBExpts[i]], 2.0);
        }
        double ssD = sumSquaredDev - Math.pow(sumDev, 2.0) / (double)N;
        double sHatDSquared = ssD / (double)(N - 1);
        double sHatDBar = Math.sqrt(sHatDSquared / (double)N);
        return Math.abs(meanDev / sHatDBar);
    }

    protected double[] getPairedTValues(FloatMatrix inputMatrix) {
        double[] pairedTValues = new double[inputMatrix.getRowDimension()];
        for (int i = 0; i < pairedTValues.length; ++i) {
            pairedTValues[i] = this.getPairedTValue(i, inputMatrix);
        }
        return pairedTValues;
    }

    protected void computeBtnSubOrigVals() throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.groupAMeans = new double[this.numGenes];
        this.groupBMeans = new double[this.numGenes];
        this.groupASDs = new double[this.numGenes];
        this.groupBSDs = new double[this.numGenes];
        this.dfValues = new double[this.numGenes];
        this.tValues = new double[this.numGenes];
        for (int gene = 0; gene < this.numGenes; ++gene) {
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(gene);
            this.event.setDescription("Calculating t values: Current gene = " + (gene + 1));
            this.fireValueChanged(this.event);
            float[] geneValues = new float[this.numExps];
            for (int i = 0; i < this.numExps; ++i) {
                geneValues[i] = this.expMatrix.A[gene][i];
            }
            int groupACounter = 0;
            int groupBCounter = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    ++groupACounter;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                ++groupBCounter;
            }
            float[] groupAValues = new float[groupACounter];
            float[] groupBValues = new float[groupBCounter];
            int numbValidValuesA = 0;
            int numbValidValuesB = 0;
            groupACounter = 0;
            groupBCounter = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    groupAValues[groupACounter] = geneValues[i];
                    if (!Float.isNaN(geneValues[i])) {
                        ++numbValidValuesA;
                    }
                    ++groupACounter;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                groupBValues[groupBCounter] = geneValues[i];
                if (!Float.isNaN(geneValues[i])) {
                    ++numbValidValuesB;
                }
                ++groupBCounter;
            }
            if (numbValidValuesA < 2 || numbValidValuesB < 2) {
                this.tValues[gene] = Double.NaN;
                this.dfValues[gene] = Double.NaN;
                this.groupAMeans[gene] = Double.NaN;
                this.groupBMeans[gene] = Double.NaN;
                this.groupASDs[gene] = Double.NaN;
                this.groupBSDs[gene] = Double.NaN;
                continue;
            }
            this.tValues[gene] = this.calculateTValue(groupAValues, groupBValues);
            this.dfValues[gene] = this.calculateDf(groupAValues, groupBValues);
            this.groupAMeans[gene] = this.getMean(groupAValues);
            this.groupBMeans[gene] = this.getMean(groupBValues);
            this.groupASDs[gene] = Math.sqrt(this.getVar(groupAValues));
            this.groupBSDs[gene] = Math.sqrt(this.getVar(groupBValues));
        }
    }

    protected float calculateTValue(float[] groupA, float[] groupB) {
        int i;
        if (this.useWelchDf) {
            int i2;
            int kA = groupA.length;
            int kB = groupB.length;
            float meanA = this.getMean(groupA);
            float meanB = this.getMean(groupB);
            float varA = this.getVar(groupA);
            float varB = this.getVar(groupB);
            int numbValidGroupAValues = 0;
            int numbValidGroupBValues = 0;
            for (i2 = 0; i2 < groupA.length; ++i2) {
                if (Float.isNaN(groupA[i2])) continue;
                ++numbValidGroupAValues;
            }
            for (i2 = 0; i2 < groupB.length; ++i2) {
                if (Float.isNaN(groupB[i2])) continue;
                ++numbValidGroupBValues;
            }
            if (numbValidGroupAValues < 2 || numbValidGroupBValues < 2) {
                return Float.NaN;
            }
            float tValue = (float)((double)(meanA - meanB) / Math.sqrt(varA / (float)numbValidGroupAValues + varB / (float)numbValidGroupBValues));
            return Math.abs(tValue);
        }
        int numbValidGroupAValues = 0;
        int numbValidGroupBValues = 0;
        for (i = 0; i < groupA.length; ++i) {
            if (Float.isNaN(groupA[i])) continue;
            ++numbValidGroupAValues;
        }
        for (i = 0; i < groupB.length; ++i) {
            if (Float.isNaN(groupB[i])) continue;
            ++numbValidGroupBValues;
        }
        if (numbValidGroupAValues < 2 || numbValidGroupBValues < 2) {
            return Float.NaN;
        }
        float ssA = this.getSumSquares(groupA);
        float ssB = this.getSumSquares(groupB);
        float term1 = ssA + ssB;
        float term2 = numbValidGroupAValues + numbValidGroupBValues - 2;
        float term3 = 1.0f / (float)numbValidGroupAValues + 1.0f / (float)numbValidGroupBValues;
        float denom = (float)Math.sqrt(term1 * term3 / term2);
        float meanA = this.getMean(groupA);
        float meanB = this.getMean(groupB);
        float tValue = (meanA - meanB) / denom;
        return Math.abs(tValue);
    }

    protected float getSumSquares(float[] arr) {
        int N = 0;
        float sumX = 0.0f;
        float sumXSquared = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            if (Float.isNaN(arr[i])) continue;
            ++N;
            sumX += arr[i];
            sumXSquared += arr[i] * arr[i];
        }
        if (N == 0) {
            return Float.NaN;
        }
        float sumSq = sumXSquared - sumX * sumX / (float)N;
        return sumSq;
    }

    protected int calculateDf(float[] groupA, float[] groupB) {
        int i;
        int kA = 0;
        int kB = 0;
        for (i = 0; i < groupA.length; ++i) {
            if (Float.isNaN(groupA[i])) continue;
            ++kA;
        }
        for (i = 0; i < groupB.length; ++i) {
            if (Float.isNaN(groupB[i])) continue;
            ++kB;
        }
        if (!this.useWelchDf) {
            int df = kA + kB - 2;
            if (df < 0) {
                df = 0;
            }
            return df;
        }
        float meanA = this.getMean(groupA);
        float meanB = this.getMean(groupB);
        float varA = this.getVar(groupA);
        float varB = this.getVar(groupB);
        float numerator = (float)Math.pow(varA / (float)kA + varB / (float)kB, 2.0);
        float denom = (float)(Math.pow(varA / (float)kA, 2.0) / (double)(kA - 1) + Math.pow(varB / (float)kB, 2.0) / (double)(kB - 1));
        int df = (int)Math.floor(numerator / denom);
        return df;
    }

    protected float getMean(float[] group) {
        float sum = 0.0f;
        int n = 0;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sum += group[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float mean = sum / (float)n;
        if (Float.isInfinite(mean)) {
            return Float.NaN;
        }
        return mean;
    }

    protected float getVar(float[] group) {
        float mean = this.getMean(group);
        int n = 0;
        float sumSquares = 0.0f;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sumSquares = (float)((double)sumSquares + Math.pow(group[i] - mean, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float var = sumSquares / (float)(n - 1);
        if (Float.isInfinite(var)) {
            return Float.NaN;
        }
        return var;
    }
}

