/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.FDistribution;
import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;

public class TFA
extends AbstractAlgorithm {
    public static final int JUST_ALPHA = 4;
    public static final int STD_BONFERRONI = 5;
    public static final int ADJ_BONFERRONI = 6;
    public static final int MAX_T = 9;
    public static final int MIN_P = 10;
    public static final int HAS_EMPTY_CELL = 21;
    public static final int ALL_CELLS_HAVE_ONE_SAMPLE = 22;
    public static final int SOME_CELLS_HAVE_ONE_SAMPLE = 23;
    public static final int BALANCED_WITH_REPLICATION = 24;
    public static final int UNBALANCED_WITH_REPLICATION = 25;
    protected boolean stop = false;
    protected int function;
    protected float factor;
    protected boolean absolute;
    protected FloatMatrix expMatrix;
    boolean hierarchical_tree;
    int method_linkage;
    boolean calculate_genes;
    boolean calculate_experiments;
    protected Vector[] clusters;
    protected int k;
    protected int numGenes;
    protected int numExps;
    protected int[] numFactorLevels;
    protected int[] factorAAssignments;
    protected int[] factorBAssignments;
    protected boolean allCellsHaveOneSample;
    protected boolean isBalancedDesign;
    protected boolean usePerms;
    protected boolean drawSigTreesOnly;
    protected int adjustmentMethod;
    protected float alpha;
    protected int numPerms;
    double[] origFactorAPValues;
    double[] origFactorBPValues;
    double[] origInteractionPValues;
    double[] factorAFValues;
    double[] factorBFValues;
    double[] interactionFValues;
    double[] factorADfValues;
    double[] factorBDfValues;
    double[] interactionDfValues;
    double[] errorDfValues;
    double[] adjFactorAPValues;
    double[] adjFactorBPValues;
    double[] adjInteractionPValues;
    protected int hcl_function;
    protected boolean hcl_absolute;
    int validN;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        int i2;
        int i3;
        this.numFactorLevels = data.getIntArray("numFactorLevels");
        this.factorAAssignments = data.getIntArray("factorAAssignments");
        this.factorBAssignments = data.getIntArray("factorBAssignments");
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("distance-absolute", false);
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        this.hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        if (this.hierarchical_tree) {
            this.drawSigTreesOnly = map.getBoolean("draw-sig-trees-only");
        }
        this.method_linkage = map.getInt("method-linkage", 0);
        this.calculate_genes = map.getBoolean("calculate-genes", false);
        this.calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.expMatrix = data.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.allCellsHaveOneSample = map.getBoolean("allCellsHaveOneSample", false);
        this.isBalancedDesign = map.getBoolean("isBalancedDesign", false);
        this.usePerms = map.getBoolean("usePerms", true);
        this.adjustmentMethod = map.getInt("adjustmentMethod", 4);
        this.alpha = map.getFloat("alpha", 0.01f);
        this.numPerms = map.getInt("numPerms", 1000);
        this.origFactorAPValues = new double[this.numGenes];
        this.origFactorBPValues = new double[this.numGenes];
        this.origInteractionPValues = new double[this.numGenes];
        this.adjFactorAPValues = new double[this.numGenes];
        this.adjFactorBPValues = new double[this.numGenes];
        this.adjInteractionPValues = new double[this.numGenes];
        this.factorAFValues = new double[this.numGenes];
        this.factorBFValues = new double[this.numGenes];
        this.interactionFValues = new double[this.numGenes];
        this.factorADfValues = new double[this.numGenes];
        this.factorBDfValues = new double[this.numGenes];
        this.interactionDfValues = new double[this.numGenes];
        this.errorDfValues = new double[this.numGenes];
        for (int i4 = 0; i4 < this.numGenes; ++i4) {
            this.origFactorAPValues[i4] = 0.0;
            this.origFactorBPValues[i4] = 0.0;
            this.origInteractionPValues[i4] = 0.0;
        }
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(event);
        event.setId(2);
        int nonMissingDataGenes = 0;
        boolean[] hasMissingValues = new boolean[this.numGenes];
        for (i3 = 0; i3 < hasMissingValues.length; ++i3) {
            hasMissingValues[i3] = false;
        }
        for (i3 = 0; i3 < this.numGenes; ++i3) {
            boolean missing = false;
            for (int j = 0; j < this.numExps; ++j) {
                if (this.factorAAssignments[j] == 0 || this.factorBAssignments[j] == 0 || !Float.isNaN(this.expMatrix.A[i3][j])) continue;
                missing = true;
                break;
            }
            if (missing) {
                hasMissingValues[i3] = true;
                continue;
            }
            ++nonMissingDataGenes;
        }
        for (i3 = 0; i3 < this.numGenes; ++i3) {
            double permInteractionFValue;
            double permFBValue;
            double permFAValue;
            double[] permFValuesAndDfs;
            Vector[][] currentGenePermutedFactorValues;
            int j;
            double[] fValuesAndDfs;
            if (this.stop) {
                throw new AbortException();
            }
            event.setIntValue(i3);
            event.setDescription("Calculating unadjusted p-values: Current gene = " + (i3 + 1));
            this.fireValueChanged(event);
            Vector[][] currentGeneFactorValues = this.getCurrentGeneFactorValues(i3);
            int currGeneFactorCondition = this.getCurrGeneFactorCondition(currentGeneFactorValues);
            if (currGeneFactorCondition == 21) {
                this.origFactorAPValues[i3] = Double.NaN;
                this.origFactorBPValues[i3] = Double.NaN;
                this.origInteractionPValues[i3] = Double.NaN;
                this.adjFactorAPValues[i3] = Double.NaN;
                this.adjFactorBPValues[i3] = Double.NaN;
                this.adjInteractionPValues[i3] = Double.NaN;
                this.factorAFValues[i3] = Double.NaN;
                this.factorBFValues[i3] = Double.NaN;
                this.interactionFValues[i3] = Double.NaN;
                this.factorADfValues[i3] = Double.NaN;
                this.factorBDfValues[i3] = Double.NaN;
                this.interactionDfValues[i3] = Double.NaN;
                this.errorDfValues[i3] = Double.NaN;
                continue;
            }
            if (currGeneFactorCondition == 23) {
                this.origFactorAPValues[i3] = Double.NaN;
                this.origFactorBPValues[i3] = Double.NaN;
                this.origInteractionPValues[i3] = Double.NaN;
                this.adjFactorAPValues[i3] = Double.NaN;
                this.adjFactorBPValues[i3] = Double.NaN;
                this.adjInteractionPValues[i3] = Double.NaN;
                this.factorAFValues[i3] = Double.NaN;
                this.factorBFValues[i3] = Double.NaN;
                this.interactionFValues[i3] = Double.NaN;
                this.factorADfValues[i3] = Double.NaN;
                this.factorBDfValues[i3] = Double.NaN;
                this.interactionDfValues[i3] = Double.NaN;
                this.errorDfValues[i3] = Double.NaN;
                continue;
            }
            if (currGeneFactorCondition == 24) {
                fValuesAndDfs = this.getBalancedFValuesAndDfs(currentGeneFactorValues);
                this.factorAFValues[i3] = fValuesAndDfs[0];
                this.factorBFValues[i3] = fValuesAndDfs[1];
                this.interactionFValues[i3] = fValuesAndDfs[2];
                this.factorADfValues[i3] = fValuesAndDfs[3];
                this.factorBDfValues[i3] = fValuesAndDfs[4];
                this.interactionDfValues[i3] = fValuesAndDfs[5];
                this.errorDfValues[i3] = fValuesAndDfs[6];
                if (!this.usePerms) {
                    this.origFactorAPValues[i3] = this.getPValueFromFDist(this.factorAFValues[i3], (int)this.factorADfValues[i3], (int)this.errorDfValues[i3]);
                    this.origFactorBPValues[i3] = this.getPValueFromFDist(this.factorBFValues[i3], (int)this.factorBDfValues[i3], (int)this.errorDfValues[i3]);
                    this.origInteractionPValues[i3] = this.getPValueFromFDist(this.interactionFValues[i3], (int)this.interactionDfValues[i3], (int)this.errorDfValues[i3]);
                    continue;
                }
                if (!hasMissingValues[i3]) continue;
                for (j = 0; j < this.numPerms; ++j) {
                    currentGenePermutedFactorValues = this.getCurrentGenePermutedFactorValues(i3);
                    permFValuesAndDfs = this.getBalancedFValuesAndDfs(currentGenePermutedFactorValues);
                    permFAValue = permFValuesAndDfs[0];
                    permFBValue = permFValuesAndDfs[1];
                    permInteractionFValue = permFValuesAndDfs[2];
                    if (permFAValue >= this.factorAFValues[i3]) {
                        this.origFactorAPValues[i3] = this.origFactorAPValues[i3] + 1.0;
                    }
                    if (permFBValue >= this.factorBFValues[i3]) {
                        this.origFactorBPValues[i3] = this.origFactorBPValues[i3] + 1.0;
                    }
                    if (!(permInteractionFValue >= this.interactionFValues[i3])) continue;
                    this.origInteractionPValues[i3] = this.origInteractionPValues[i3] + 1.0;
                }
                continue;
            }
            if (currGeneFactorCondition == 25) {
                fValuesAndDfs = this.getUnbalancedFValuesAndDfs(currentGeneFactorValues);
                this.factorAFValues[i3] = fValuesAndDfs[0];
                this.factorBFValues[i3] = fValuesAndDfs[1];
                this.interactionFValues[i3] = fValuesAndDfs[2];
                this.factorADfValues[i3] = fValuesAndDfs[3];
                this.factorBDfValues[i3] = fValuesAndDfs[4];
                this.interactionDfValues[i3] = fValuesAndDfs[5];
                this.errorDfValues[i3] = fValuesAndDfs[6];
                if (!this.usePerms) {
                    this.origFactorAPValues[i3] = this.getPValueFromFDist(this.factorAFValues[i3], (int)this.factorADfValues[i3], (int)this.errorDfValues[i3]);
                    this.origFactorBPValues[i3] = this.getPValueFromFDist(this.factorBFValues[i3], (int)this.factorBDfValues[i3], (int)this.errorDfValues[i3]);
                    this.origInteractionPValues[i3] = this.getPValueFromFDist(this.interactionFValues[i3], (int)this.interactionDfValues[i3], (int)this.errorDfValues[i3]);
                    continue;
                }
                if (!hasMissingValues[i3]) continue;
                for (j = 0; j < this.numPerms; ++j) {
                    currentGenePermutedFactorValues = this.getCurrentGenePermutedFactorValues(i3);
                    permFValuesAndDfs = this.getUnbalancedFValuesAndDfs(currentGenePermutedFactorValues);
                    permFAValue = permFValuesAndDfs[0];
                    permFBValue = permFValuesAndDfs[1];
                    permInteractionFValue = permFValuesAndDfs[2];
                    if (permFAValue >= this.factorAFValues[i3]) {
                        this.origFactorAPValues[i3] = this.origFactorAPValues[i3] + 1.0;
                    }
                    if (permFBValue >= this.factorBFValues[i3]) {
                        this.origFactorBPValues[i3] = this.origFactorBPValues[i3] + 1.0;
                    }
                    if (!(permInteractionFValue >= this.interactionFValues[i3])) continue;
                    this.origInteractionPValues[i3] = this.origInteractionPValues[i3] + 1.0;
                }
                continue;
            }
            if (currGeneFactorCondition != 22) continue;
            fValuesAndDfs = this.getBalancedMainEffectsFValuesAndDfs(currentGeneFactorValues);
            this.factorAFValues[i3] = fValuesAndDfs[0];
            this.factorBFValues[i3] = fValuesAndDfs[1];
            this.interactionFValues[i3] = Double.NaN;
            this.factorADfValues[i3] = fValuesAndDfs[2];
            this.factorBDfValues[i3] = fValuesAndDfs[3];
            this.interactionDfValues[i3] = Double.NaN;
            this.errorDfValues[i3] = fValuesAndDfs[4];
            this.origInteractionPValues[i3] = Double.NaN;
            if (!this.usePerms) {
                this.origFactorAPValues[i3] = this.getPValueFromFDist(this.factorAFValues[i3], (int)this.factorADfValues[i3], (int)this.errorDfValues[i3]);
                this.origFactorBPValues[i3] = this.getPValueFromFDist(this.factorBFValues[i3], (int)this.factorBDfValues[i3], (int)this.errorDfValues[i3]);
                continue;
            }
            if (!hasMissingValues[i3]) continue;
            for (j = 0; j < this.numPerms; ++j) {
                currentGenePermutedFactorValues = this.getCurrentGenePermutedFactorValues(i3);
                permFValuesAndDfs = this.getBalancedMainEffectsFValuesAndDfs(currentGenePermutedFactorValues);
                permFAValue = permFValuesAndDfs[0];
                permFBValue = permFValuesAndDfs[1];
                if (permFAValue >= this.factorAFValues[i3]) {
                    this.origFactorAPValues[i3] = this.origFactorAPValues[i3] + 1.0;
                }
                if (!(permFBValue >= this.factorBFValues[i3])) continue;
                this.origFactorBPValues[i3] = this.origFactorBPValues[i3] + 1.0;
            }
        }
        if (this.usePerms && nonMissingDataGenes > 0) {
            int firstNonMissingGene = -1;
            for (int i5 = 0; i5 < hasMissingValues.length; ++i5) {
                if (hasMissingValues[i5]) continue;
                firstNonMissingGene = i5;
                break;
            }
            Vector[][] geneFactorValues = this.getCurrentGeneFactorValues(firstNonMissingGene);
            int geneFactorCondition = this.getCurrGeneFactorCondition(geneFactorValues);
            Vector<Integer> validIndices = new Vector<Integer>();
            for (int i6 = 0; i6 < this.numExps; ++i6) {
                if (this.factorAAssignments[i6] == 0 || this.factorBAssignments[i6] == 0) continue;
                validIndices.add(new Integer(i6));
            }
            int[] validArray = new int[validIndices.size()];
            for (int i7 = 0; i7 < validArray.length; ++i7) {
                validArray[i7] = (Integer)validIndices.get(i7);
            }
            event = new AlgorithmEvent((Object)this, 1, this.numPerms);
            this.fireValueChanged(event);
            event.setId(2);
            for (int j = 0; j < this.numPerms; ++j) {
                double currGenePermInteractionFValue;
                double currGenePermFBValue;
                double currGenePermFAValue;
                double[] permFValuesAndDfs;
                Vector[][] currentGenePermFactorValues;
                if (this.stop) {
                    throw new AbortException();
                }
                event.setIntValue(j);
                event.setDescription("Calculating unadjusted p-values for some genes: Current permutation = " + (j + 1));
                this.fireValueChanged(event);
                int[] permutedExpts = this.getPermutedValues(this.numExps, validArray);
                FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
                if (geneFactorCondition == 24) {
                    for (i2 = 0; i2 < this.numGenes; ++i2) {
                        if (hasMissingValues[i2]) continue;
                        currentGenePermFactorValues = this.getCurrentGeneFactorValuesFromPermMatrix(permutedMatrix, i2);
                        permFValuesAndDfs = this.getBalancedFValuesAndDfs(currentGenePermFactorValues);
                        currGenePermFAValue = permFValuesAndDfs[0];
                        currGenePermFBValue = permFValuesAndDfs[1];
                        currGenePermInteractionFValue = permFValuesAndDfs[2];
                        if (currGenePermFAValue >= this.factorAFValues[i2]) {
                            this.origFactorAPValues[i2] = this.origFactorAPValues[i2] + 1.0;
                        }
                        if (currGenePermFBValue >= this.factorBFValues[i2]) {
                            this.origFactorBPValues[i2] = this.origFactorBPValues[i2] + 1.0;
                        }
                        if (!(currGenePermInteractionFValue >= this.interactionFValues[i2])) continue;
                        this.origInteractionPValues[i2] = this.origInteractionPValues[i2] + 1.0;
                    }
                    continue;
                }
                if (geneFactorCondition == 25) {
                    for (i2 = 0; i2 < this.numGenes; ++i2) {
                        if (hasMissingValues[i2]) continue;
                        currentGenePermFactorValues = this.getCurrentGeneFactorValuesFromPermMatrix(permutedMatrix, i2);
                        permFValuesAndDfs = this.getUnbalancedFValuesAndDfs(currentGenePermFactorValues);
                        currGenePermFAValue = permFValuesAndDfs[0];
                        currGenePermFBValue = permFValuesAndDfs[1];
                        currGenePermInteractionFValue = permFValuesAndDfs[2];
                        if (currGenePermFAValue >= this.factorAFValues[i2]) {
                            this.origFactorAPValues[i2] = this.origFactorAPValues[i2] + 1.0;
                        }
                        if (currGenePermFBValue >= this.factorBFValues[i2]) {
                            this.origFactorBPValues[i2] = this.origFactorBPValues[i2] + 1.0;
                        }
                        if (!(currGenePermInteractionFValue >= this.interactionFValues[i2])) continue;
                        this.origInteractionPValues[i2] = this.origInteractionPValues[i2] + 1.0;
                    }
                    continue;
                }
                if (geneFactorCondition != 22) continue;
                for (i2 = 0; i2 < this.numGenes; ++i2) {
                    if (hasMissingValues[i2]) continue;
                    currentGenePermFactorValues = this.getCurrentGeneFactorValuesFromPermMatrix(permutedMatrix, i2);
                    permFValuesAndDfs = this.getBalancedMainEffectsFValuesAndDfs(currentGenePermFactorValues);
                    currGenePermFAValue = permFValuesAndDfs[0];
                    currGenePermFBValue = permFValuesAndDfs[1];
                    if (currGenePermFAValue >= this.factorAFValues[i2]) {
                        this.origFactorAPValues[i2] = this.origFactorAPValues[i2] + 1.0;
                    }
                    if (!(currGenePermFBValue >= this.factorBFValues[i2])) continue;
                    this.origFactorBPValues[i2] = this.origFactorBPValues[i2] + 1.0;
                }
            }
        }
        if (this.usePerms) {
            for (i3 = 0; i3 < this.numGenes; ++i3) {
                this.origFactorAPValues[i3] = this.origFactorAPValues[i3] / (double)this.numPerms;
                this.origFactorBPValues[i3] = this.origFactorBPValues[i3] / (double)this.numPerms;
                this.origInteractionPValues[i3] = this.origInteractionPValues[i3] / (double)this.numPerms;
            }
        }
        for (i3 = 0; i3 < this.numGenes; ++i3) {
            if (Double.isNaN(this.factorAFValues[i3])) {
                this.origFactorAPValues[i3] = Double.NaN;
            }
            if (Double.isNaN(this.factorBFValues[i3])) {
                this.origFactorBPValues[i3] = Double.NaN;
            }
            if (!Double.isNaN(this.interactionFValues[i3])) continue;
            this.origInteractionPValues[i3] = Double.NaN;
        }
        if (this.adjustmentMethod == 4) {
            for (i3 = 0; i3 < this.numGenes; ++i3) {
                this.adjFactorAPValues[i3] = this.origFactorAPValues[i3];
                this.adjFactorBPValues[i3] = this.origFactorBPValues[i3];
                this.adjInteractionPValues[i3] = this.origInteractionPValues[i3];
            }
        }
        Vector<Vector> clusterVector = new Vector<Vector>();
        Vector<Integer> sigAGenes = new Vector<Integer>();
        Vector nonSigAGenes = new Vector();
        Vector<Integer> sigBGenes = new Vector<Integer>();
        Vector nonSigBGenes = new Vector();
        Vector<Integer> sigInteractionGenes = new Vector<Integer>();
        Vector nonSigInteractionGenes = new Vector();
        Vector nonSigAllGenes = new Vector();
        for (i2 = 0; i2 < this.numGenes; ++i2) {
            if ((float)this.adjFactorAPValues[i2] <= this.alpha) {
                sigAGenes.add(new Integer(i2));
            }
            if ((float)this.adjFactorBPValues[i2] <= this.alpha) {
                sigBGenes.add(new Integer(i2));
            }
            if (!((float)this.adjInteractionPValues[i2] <= this.alpha)) continue;
            sigInteractionGenes.add(new Integer(i2));
        }
        Vector<Integer> allGenes = new Vector<Integer>();
        for (int i8 = 0; i8 < this.numGenes; ++i8) {
            allGenes.add(new Integer(i8));
        }
        nonSigAGenes = (Vector)allGenes.clone();
        nonSigAGenes.removeAll(sigAGenes);
        nonSigBGenes = (Vector)allGenes.clone();
        nonSigBGenes.removeAll(sigBGenes);
        nonSigInteractionGenes = (Vector)allGenes.clone();
        nonSigInteractionGenes.removeAll(sigInteractionGenes);
        nonSigAllGenes = (Vector)allGenes.clone();
        nonSigAllGenes.removeAll(sigAGenes);
        nonSigAllGenes.removeAll(sigBGenes);
        nonSigAllGenes.removeAll(sigInteractionGenes);
        clusterVector.add(sigAGenes);
        clusterVector.add(sigBGenes);
        clusterVector.add(sigInteractionGenes);
        clusterVector.add(nonSigAGenes);
        clusterVector.add(nonSigBGenes);
        clusterVector.add(nonSigInteractionGenes);
        clusterVector.add(nonSigAllGenes);
        this.k = clusterVector.size();
        FloatMatrix factorAFValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix factorBFValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix interactionFValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix factorADfValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix factorBDfValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix interactionDfValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix errorDfValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix origFactorAPValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix origFactorBPValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix origInteractionPValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix adjFactorAPValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix adjFactorBPValuesMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix adjInteractionPValuesMatrix = new FloatMatrix(this.numGenes, 1);
        for (i = 0; i < this.numGenes; ++i) {
            factorAFValuesMatrix.A[i][0] = (float)this.factorAFValues[i];
            factorBFValuesMatrix.A[i][0] = (float)this.factorBFValues[i];
            interactionFValuesMatrix.A[i][0] = (float)this.interactionFValues[i];
            factorADfValuesMatrix.A[i][0] = (float)this.factorADfValues[i];
            factorBDfValuesMatrix.A[i][0] = (float)this.factorBDfValues[i];
            interactionDfValuesMatrix.A[i][0] = (float)this.interactionDfValues[i];
            errorDfValuesMatrix.A[i][0] = (float)this.errorDfValues[i];
            origFactorAPValuesMatrix.A[i][0] = (float)this.origFactorAPValues[i];
            origFactorBPValuesMatrix.A[i][0] = (float)this.origFactorBPValues[i];
            origInteractionPValuesMatrix.A[i][0] = (float)this.origInteractionPValues[i];
            adjFactorAPValuesMatrix.A[i][0] = (float)this.adjFactorAPValues[i];
            adjFactorBPValuesMatrix.A[i][0] = (float)this.adjFactorBPValues[i];
            adjInteractionPValuesMatrix.A[i][0] = (float)this.adjInteractionPValues[i];
        }
        this.clusters = new Vector[this.k];
        for (i = 0; i < this.k; ++i) {
            this.clusters[i] = (Vector)clusterVector.get(i);
        }
        FloatMatrix means = this.getMeans(this.clusters);
        FloatMatrix variances = this.getVariances(this.clusters, means);
        event = null;
        if (this.hierarchical_tree) {
            event = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(event);
            event.setIntValue(0);
            event.setId(2);
            this.fireValueChanged(event);
        }
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i9 = 0; i9 < this.clusters.length; ++i9) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.convert2int(this.clusters[i9]);
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!this.hierarchical_tree) continue;
            if (this.drawSigTreesOnly) {
                if (i9 > 2) continue;
                node.setValues(this.calculateHierarchicalTree(features, this.method_linkage, this.calculate_genes, this.calculate_experiments));
                event.setIntValue(i9 + 1);
                this.fireValueChanged(event);
                continue;
            }
            node.setValues(this.calculateHierarchicalTree(features, this.method_linkage, this.calculate_genes, this.calculate_experiments));
            event.setIntValue(i9 + 1);
            this.fireValueChanged(event);
        }
        AlgorithmData result = new AlgorithmData();
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        result.addMatrix("factorAFValuesMatrix", factorAFValuesMatrix);
        result.addMatrix("factorBFValuesMatrix", factorBFValuesMatrix);
        result.addMatrix("interactionFValuesMatrix", interactionFValuesMatrix);
        result.addMatrix("factorADfValuesMatrix", factorADfValuesMatrix);
        result.addMatrix("factorBDfValuesMatrix", factorBDfValuesMatrix);
        result.addMatrix("interactionDfValuesMatrix", interactionDfValuesMatrix);
        result.addMatrix("errorDfValuesMatrix", errorDfValuesMatrix);
        result.addMatrix("origFactorAPValuesMatrix", origFactorAPValuesMatrix);
        result.addMatrix("origFactorBPValuesMatrix", origFactorBPValuesMatrix);
        result.addMatrix("origInteractionPValuesMatrix", origInteractionPValuesMatrix);
        result.addMatrix("adjFactorAPValuesMatrix", adjFactorAPValuesMatrix);
        result.addMatrix("adjFactorBPValuesMatrix", adjFactorBPValuesMatrix);
        result.addMatrix("adjInteractionPValuesMatrix", adjInteractionPValuesMatrix);
        return result;
    }

    protected NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.getSubExperiment(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    protected void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    protected FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    protected void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    protected int[] convert2int(Vector source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (Integer)source.get(i);
        }
        return int_matrix;
    }

    protected FloatMatrix getMeans(Vector[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.numExps);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    protected FloatMatrix getMean(Vector cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.numExps);
        int n = cluster.size();
        int denom = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(((Integer)cluster.get(j)).intValue(), i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    protected FloatMatrix getVariances(Vector[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    protected float getSampleNormalizedSum(Vector cluster, int column, float mean) {
        int size = cluster.size();
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(((Integer)cluster.get(i)).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    protected float getSampleVariance(Vector cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    protected double getPValueFromFDist(double fValue, int groupsDF, int errorDF) {
        FDistribution fDist = new FDistribution((double)groupsDF, (double)errorDF);
        double cumulProb = fDist.cumulative(fValue);
        double pValue = 1.0 - cumulProb;
        if (pValue > 1.0) {
            pValue = 1.0;
        }
        return pValue;
    }

    protected double convertNegFValues(double fValue) {
        double convFValue = fValue > -0.001 && fValue < 0.0 ? Double.MIN_VALUE : fValue;
        return convFValue;
    }

    protected double[] getUnbalancedFValuesAndDfs(Vector[][] currGeneFactorValues) {
        double[][] unadjCellSums = this.getCellSums(currGeneFactorValues);
        double[][] cellMeans = new double[currGeneFactorValues.length][currGeneFactorValues[0].length];
        for (int i = 0; i < currGeneFactorValues.length; ++i) {
            for (int j = 0; j < currGeneFactorValues[i].length; ++j) {
                cellMeans[i][j] = unadjCellSums[i][j] / (double)currGeneFactorValues[i][j].size();
            }
        }
        double sumRecipCellSizes = 0.0;
        int dfError = 0;
        for (int i = 0; i < currGeneFactorValues.length; ++i) {
            for (int j = 0; j < currGeneFactorValues[i].length; ++j) {
                sumRecipCellSizes += 1.0 / (double)currGeneFactorValues[i][j].size();
                dfError += currGeneFactorValues[i][j].size() - 1;
            }
        }
        double harmonicCellSize = (double)(this.numFactorLevels[0] * this.numFactorLevels[1]) / sumRecipCellSizes;
        double[][] adjustedCellSums = new double[currGeneFactorValues.length][currGeneFactorValues[0].length];
        for (int i = 0; i < currGeneFactorValues.length; ++i) {
            for (int j = 0; j < currGeneFactorValues[i].length; ++j) {
                adjustedCellSums[i][j] = cellMeans[i][j] * harmonicCellSize;
            }
        }
        int dfA = this.numFactorLevels[0] - 1;
        int dfB = this.numFactorLevels[1] - 1;
        int dfInteraction = dfA * dfB;
        double T = this.getTUnbalanced(adjustedCellSums, harmonicCellSize);
        double A = this.getAUnbalanced(adjustedCellSums, harmonicCellSize);
        double B = this.getBUnbalanced(adjustedCellSums, harmonicCellSize);
        double AB = this.getABUnbalanced(adjustedCellSums, harmonicCellSize);
        double msA = (A - T) / (double)dfA;
        double msB = (B - T) / (double)dfB;
        double msInteraction = (AB - A - B + T) / (double)dfInteraction;
        double ssError = 0.0;
        for (int i = 0; i < currGeneFactorValues.length; ++i) {
            for (int j = 0; j < currGeneFactorValues[i].length; ++j) {
                Vector vect = currGeneFactorValues[i][j];
                ssError += this.getSumSquaredDiffs(vect);
            }
        }
        double msError = ssError / (double)dfError;
        double fA = msA / msError;
        double fB = msB / msError;
        double fInteraction = msInteraction / msError;
        double[] fValuesAndDfs = new double[]{this.convertNegFValues(fA), this.convertNegFValues(fB), this.convertNegFValues(fInteraction), dfA, dfB, dfInteraction, dfError};
        return fValuesAndDfs;
    }

    protected double[] getBalancedFValuesAndDfs(Vector[][] currGeneFactorValues) {
        double[][] cellSums = this.getCellSums(currGeneFactorValues);
        int sampleSizePerCell = currGeneFactorValues[0][0].size();
        int dfA = this.numFactorLevels[0] - 1;
        int dfB = this.numFactorLevels[1] - 1;
        int dfInteraction = dfA * dfB;
        int dfError = this.numFactorLevels[0] * this.numFactorLevels[1] * (sampleSizePerCell - 1);
        double Y = this.getYBalanced(currGeneFactorValues);
        double AB = this.getABBalanced(currGeneFactorValues, cellSums);
        double T = this.getTBalanced(currGeneFactorValues, cellSums);
        double A = this.getABalanced(currGeneFactorValues, cellSums);
        double B = this.getBBalanced(currGeneFactorValues, cellSums);
        double msA = (A - T) / (double)dfA;
        double msB = (B - T) / (double)dfB;
        double msInteraction = (AB - A - B + T) / (double)dfInteraction;
        double msError = (Y - AB) / (double)dfError;
        double fA = msA / msError;
        double fB = msB / msError;
        double fInteraction = msInteraction / msError;
        double[] fValuesAndDfs = new double[]{this.convertNegFValues(fA), this.convertNegFValues(fB), this.convertNegFValues(fInteraction), dfA, dfB, dfInteraction, dfError};
        return fValuesAndDfs;
    }

    protected double[] getBalancedMainEffectsFValuesAndDfs(Vector[][] currGeneFactorValues) {
        double[][] cellSums = this.getCellSums(currGeneFactorValues);
        int dfA = this.numFactorLevels[0] - 1;
        int dfB = this.numFactorLevels[1] - 1;
        int dfRemainder = dfA * dfB;
        double Y = this.getYBalanced(currGeneFactorValues);
        double AB = this.getABBalanced(currGeneFactorValues, cellSums);
        double T = this.getTBalanced(currGeneFactorValues, cellSums);
        double A = this.getABalanced(currGeneFactorValues, cellSums);
        double B = this.getBBalanced(currGeneFactorValues, cellSums);
        double msA = (A - T) / (double)dfA;
        double msB = (B - T) / (double)dfB;
        double msRemainder = (AB - A - B + T) / (double)dfRemainder;
        double fA = msA / msRemainder;
        double fB = msB / msRemainder;
        double[] fValuesAndDfs = new double[]{this.convertNegFValues(fA), this.convertNegFValues(fB), dfA, dfB, dfRemainder};
        return fValuesAndDfs;
    }

    protected double getYBalanced(Vector[][] currGeneFactorVals) {
        double Y = 0.0;
        for (int i = 0; i < currGeneFactorVals.length; ++i) {
            for (int j = 0; j < currGeneFactorVals[i].length; ++j) {
                for (int k = 0; k < currGeneFactorVals[i][j].size(); ++k) {
                    double currVal = ((Float)currGeneFactorVals[i][j].get(k)).doubleValue();
                    Y += currVal * currVal;
                }
            }
        }
        return Y;
    }

    protected double getABUnbalanced(double[][] adjCellSums, double adjSampleSize) {
        double sumSquaresCellSums = 0.0;
        for (int i = 0; i < adjCellSums.length; ++i) {
            for (int j = 0; j < adjCellSums[i].length; ++j) {
                sumSquaresCellSums += adjCellSums[i][j] * adjCellSums[i][j];
            }
        }
        double ABUnbalanced = sumSquaresCellSums / adjSampleSize;
        return ABUnbalanced;
    }

    protected double getABBalanced(Vector[][] currGeneFactorVals, double[][] cellSums) {
        double sumSquaresCellSums = 0.0;
        for (int i = 0; i < cellSums.length; ++i) {
            for (int j = 0; j < cellSums[i].length; ++j) {
                sumSquaresCellSums += cellSums[i][j] * cellSums[i][j];
            }
        }
        int sampleSizePerCell = currGeneFactorVals[0][0].size();
        double AB = sumSquaresCellSums / (double)sampleSizePerCell;
        return AB;
    }

    protected double getAUnbalanced(double[][] adjCellSums, double adjSampleSize) {
        double sumSquaresA = 0.0;
        for (int i = 0; i < adjCellSums.length; ++i) {
            double currLevelASum = 0.0;
            for (int j = 0; j < adjCellSums[i].length; ++j) {
                currLevelASum += adjCellSums[i][j];
            }
            sumSquaresA += currLevelASum * currLevelASum;
        }
        double AUnbalanced = sumSquaresA / ((double)this.numFactorLevels[1] * adjSampleSize);
        return AUnbalanced;
    }

    protected double getABalanced(Vector[][] currGeneFactorVals, double[][] cellSums) {
        double sumSquaresA = 0.0;
        for (int i = 0; i < cellSums.length; ++i) {
            double currLevelASum = 0.0;
            for (int j = 0; j < cellSums[i].length; ++j) {
                currLevelASum += cellSums[i][j];
            }
            sumSquaresA += currLevelASum * currLevelASum;
        }
        int sampleSizePerCell = currGeneFactorVals[0][0].size();
        double ABalanced = sumSquaresA / (double)(this.numFactorLevels[1] * sampleSizePerCell);
        return ABalanced;
    }

    protected double getBUnbalanced(double[][] adjCellSums, double adjSampleSize) {
        double sumSquaresB = 0.0;
        for (int i = 0; i < adjCellSums[0].length; ++i) {
            double currLevelBSum = 0.0;
            for (int j = 0; j < adjCellSums.length; ++j) {
                currLevelBSum += adjCellSums[j][i];
            }
            sumSquaresB += currLevelBSum * currLevelBSum;
        }
        double BUnbalanced = sumSquaresB / ((double)this.numFactorLevels[0] * adjSampleSize);
        return BUnbalanced;
    }

    protected double getBBalanced(Vector[][] currGeneFactorVals, double[][] cellSums) {
        double sumSquaresB = 0.0;
        for (int i = 0; i < cellSums[0].length; ++i) {
            double currLevelBSum = 0.0;
            for (int j = 0; j < cellSums.length; ++j) {
                currLevelBSum += cellSums[j][i];
            }
            sumSquaresB += currLevelBSum * currLevelBSum;
        }
        int sampleSizePerCell = currGeneFactorVals[0][0].size();
        double BBalanced = sumSquaresB / (double)(this.numFactorLevels[0] * sampleSizePerCell);
        return BBalanced;
    }

    protected double getTBalanced(Vector[][] currGeneFactorVals, double[][] cellSums) {
        double totalSum = 0.0;
        for (int i = 0; i < cellSums.length; ++i) {
            for (int j = 0; j < cellSums[i].length; ++j) {
                totalSum += cellSums[i][j];
            }
        }
        int sampleSizePerCell = currGeneFactorVals[0][0].size();
        double TBalanced = totalSum * totalSum / (double)(this.numFactorLevels[0] * this.numFactorLevels[1] * sampleSizePerCell);
        return TBalanced;
    }

    protected double getTUnbalanced(double[][] adjCellSums, double adjSampleSize) {
        double adjTotalSum = 0.0;
        for (int i = 0; i < adjCellSums.length; ++i) {
            for (int j = 0; j < adjCellSums[i].length; ++j) {
                adjTotalSum += adjCellSums[i][j];
            }
        }
        double TUnbalanced = adjTotalSum * adjTotalSum / ((double)(this.numFactorLevels[0] * this.numFactorLevels[1]) * adjSampleSize);
        return TUnbalanced;
    }

    protected double[][] getCellSums(Vector[][] currGeneFactorVals) {
        double[][] cellSums = new double[currGeneFactorVals.length][currGeneFactorVals[0].length];
        for (int i = 0; i < currGeneFactorVals.length; ++i) {
            for (int j = 0; j < currGeneFactorVals[i].length; ++j) {
                cellSums[i][j] = this.getSum(currGeneFactorVals[i][j]);
            }
        }
        return cellSums;
    }

    protected double[][] getCellMeans(Vector[][] currGeneFactorVals) {
        int j;
        int i;
        double[][] cellMeans = new double[currGeneFactorVals.length][currGeneFactorVals[0].length];
        for (i = 0; i < currGeneFactorVals.length; ++i) {
            for (j = 0; j < currGeneFactorVals[i].length; ++j) {
                cellMeans[i][j] = this.getSum(currGeneFactorVals[i][j]);
            }
        }
        for (i = 0; i < currGeneFactorVals.length; ++i) {
            for (j = 0; j < currGeneFactorVals[i].length; ++j) {
                cellMeans[i][j] = cellMeans[i][j] / (double)currGeneFactorVals[i][j].size();
            }
        }
        return cellMeans;
    }

    protected double getSum(Vector vect) {
        double sum = 0.0;
        for (int i = 0; i < vect.size(); ++i) {
            sum += ((Float)vect.get(i)).doubleValue();
        }
        return sum;
    }

    protected double getSumSquares(Vector vect) {
        double sumSquares = 0.0;
        for (int i = 0; i < vect.size(); ++i) {
            sumSquares += ((Float)vect.get(i)).doubleValue() * ((Float)vect.get(i)).doubleValue();
        }
        return sumSquares;
    }

    protected double getSumSquaredDiffs(Vector vect) {
        return this.getSumSquares(vect) - this.getSum(vect) * this.getSum(vect) / (double)vect.size();
    }

    protected int[] getPermutedValues(int arrayLength, int[] validArray) {
        int i;
        int[] permutedValues = new int[arrayLength];
        for (int i2 = 0; i2 < permutedValues.length; ++i2) {
            permutedValues[i2] = i2;
        }
        int[] permutedValidArray = new int[validArray.length];
        for (i = 0; i < validArray.length; ++i) {
            permutedValidArray[i] = validArray[i];
        }
        for (i = permutedValidArray.length; i > 1; --i) {
            Random generator2 = new Random();
            int randVal = generator2.nextInt(i - 1);
            int temp = permutedValidArray[randVal];
            permutedValidArray[randVal] = permutedValidArray[i - 1];
            permutedValidArray[i - 1] = temp;
        }
        for (i = 0; i < validArray.length; ++i) {
            permutedValues[validArray[i]] = permutedValidArray[i];
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return permutedValues;
    }

    protected FloatMatrix getPermutedMatrix(FloatMatrix inputMatrix, int[] permExpts) {
        FloatMatrix permutedMatrix = new FloatMatrix(inputMatrix.getRowDimension(), inputMatrix.getColumnDimension());
        for (int i = 0; i < inputMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < inputMatrix.getColumnDimension(); ++j) {
                permutedMatrix.A[i][j] = inputMatrix.A[i][permExpts[j]];
            }
        }
        return permutedMatrix;
    }

    protected Vector[][] getCurrentGenePermutedFactorValues(int gene) {
        int i;
        Vector[][] permutedCurrGeneFactorValues = new Vector[this.numFactorLevels[0]][this.numFactorLevels[1]];
        Vector<Integer> validIndices = new Vector<Integer>();
        for (int i2 = 0; i2 < this.numExps; ++i2) {
            if (this.factorAAssignments[i2] == 0 || this.factorBAssignments[i2] == 0 || Float.isNaN(this.expMatrix.A[gene][i2])) continue;
            validIndices.add(new Integer(i2));
        }
        int[] validArray = new int[validIndices.size()];
        for (int i3 = 0; i3 < validArray.length; ++i3) {
            validArray[i3] = (Integer)validIndices.get(i3);
        }
        int[] permutedFactorAIndices = this.getPermutedValues(this.numExps, validArray);
        int[] permutedFactorBIndices = this.getPermutedValues(this.numExps, validArray);
        int[] permutedFactorAAssignments = new int[permutedFactorAIndices.length];
        int[] permutedFactorBAssignments = new int[permutedFactorBIndices.length];
        for (i = 0; i < permutedFactorAIndices.length; ++i) {
            permutedFactorAAssignments[i] = this.factorAAssignments[permutedFactorAIndices[i]];
            permutedFactorBAssignments[i] = this.factorBAssignments[permutedFactorBIndices[i]];
        }
        for (i = 0; i < permutedCurrGeneFactorValues.length; ++i) {
            for (int j = 0; j < permutedCurrGeneFactorValues[i].length; ++j) {
                permutedCurrGeneFactorValues[i][j] = new Vector();
            }
        }
        for (i = 0; i < permutedFactorAAssignments.length; ++i) {
            if (permutedFactorAAssignments[i] == 0 || permutedFactorBAssignments[i] == 0 || Float.isNaN(this.expMatrix.A[gene][i])) continue;
            permutedCurrGeneFactorValues[permutedFactorAAssignments[i] - 1][permutedFactorBAssignments[i] - 1].add(new Float(this.expMatrix.A[gene][i]));
        }
        return permutedCurrGeneFactorValues;
    }

    protected Vector[][] getCurrentGeneFactorValues(int gene) {
        int i;
        Vector[][] currGeneFactorValues = new Vector[this.numFactorLevels[0]][this.numFactorLevels[1]];
        for (i = 0; i < currGeneFactorValues.length; ++i) {
            for (int j = 0; j < currGeneFactorValues[i].length; ++j) {
                currGeneFactorValues[i][j] = new Vector();
            }
        }
        for (i = 0; i < this.factorAAssignments.length; ++i) {
            if (this.factorAAssignments[i] == 0 || this.factorBAssignments[i] == 0 || Float.isNaN(this.expMatrix.A[gene][i])) continue;
            currGeneFactorValues[this.factorAAssignments[i] - 1][this.factorBAssignments[i] - 1].add(new Float(this.expMatrix.A[gene][i]));
        }
        return currGeneFactorValues;
    }

    protected Vector[][] getCurrentGeneFactorValuesFromPermMatrix(FloatMatrix permMatrix, int gene) {
        int i;
        Vector[][] currGeneFactorValues = new Vector[this.numFactorLevels[0]][this.numFactorLevels[1]];
        for (i = 0; i < currGeneFactorValues.length; ++i) {
            for (int j = 0; j < currGeneFactorValues[i].length; ++j) {
                currGeneFactorValues[i][j] = new Vector();
            }
        }
        for (i = 0; i < this.factorAAssignments.length; ++i) {
            if (this.factorAAssignments[i] == 0 || this.factorBAssignments[i] == 0 || Float.isNaN(permMatrix.A[gene][i])) continue;
            currGeneFactorValues[this.factorAAssignments[i] - 1][this.factorBAssignments[i] - 1].add(new Float(permMatrix.A[gene][i]));
        }
        return currGeneFactorValues;
    }

    protected int getCurrGeneFactorCondition(Vector[][] currGeneFactorAssignments) {
        int i;
        int[] cellSizes = new int[currGeneFactorAssignments.length * currGeneFactorAssignments[0].length];
        int cellCounter = 0;
        for (i = 0; i < currGeneFactorAssignments.length; ++i) {
            for (int j = 0; j < currGeneFactorAssignments[i].length; ++j) {
                cellSizes[cellCounter] = currGeneFactorAssignments[i][j].size();
                ++cellCounter;
            }
        }
        for (i = 0; i < cellSizes.length; ++i) {
            if (cellSizes[i] != 0) continue;
            return 21;
        }
        if (cellSizes[0] == 1) {
            boolean allOne = true;
            for (int i2 = 1; i2 < cellSizes.length; ++i2) {
                if (cellSizes[i2] == 1) continue;
                allOne = false;
                break;
            }
            if (allOne) {
                return 22;
            }
        }
        for (i = 0; i < cellSizes.length; ++i) {
            if (cellSizes[i] != 1) continue;
            return 23;
        }
        int firstCellCount = cellSizes[0];
        boolean balanced = true;
        for (int i3 = 1; i3 < cellSizes.length; ++i3) {
            if (cellSizes[i3] == firstCellCount) continue;
            balanced = false;
            break;
        }
        if (balanced) {
            return 24;
        }
        return 25;
    }
}

