/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;

public class SVM
extends AbstractAlgorithm {
    private static final int POSITIVE_DIAGONAL = 0;
    private static final int NEGATIVE_DIAGONAL = 1;
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private int number_of_genes;
    private int number_of_samples;
    private boolean svmGenes = true;
    private FloatMatrix expMatrix;
    private boolean seenUnderflow = false;
    private float prevObjective;
    private boolean calcHCL = false;
    private boolean calcGeneHCL = false;
    private boolean calcSampleHCL = false;
    private int method = 0;
    private boolean classifyGens = true;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("hcl-distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("hcl-distance-absolute", false);
        this.expMatrix = data.getMatrix("experiment");
        this.number_of_genes = this.expMatrix.getRowDimension();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        this.svmGenes = map.getBoolean("classify-genes", true);
        float constant = map.getFloat("constant", 0.0f);
        float coefficient = map.getFloat("coefficient", 0.0f);
        float power = map.getFloat("power", 0.0f);
        this.calcHCL = map.getBoolean("calculate-hcl", false);
        this.calcGeneHCL = map.getBoolean("calculate-genes-hcl", false);
        this.calcSampleHCL = map.getBoolean("calculate-samples-hcl", false);
        this.method = map.getInt("linkage-method", 0);
        AlgorithmData result = new AlgorithmData();
        boolean isClassify = map.getBoolean("is-classify", true);
        if (isClassify) {
            FloatMatrix trainingMatrix = data.getMatrix("training");
            FloatMatrix weightsMatrix = data.getMatrix("weights");
            float[] weights = weightsMatrix.getColumnPackedCopy();
            FloatMatrix discriminantMatrix = this.classify(trainingMatrix, weights, coefficient, constant, power);
            int[][] clusters = new int[][]{this.getPositives(discriminantMatrix), this.getNegatives(discriminantMatrix)};
            if (this.calcHCL) {
                Cluster result_cluster = new Cluster();
                NodeList nodeList = result_cluster.getNodeList();
                for (int i = 0; i < clusters.length; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    int[] features = clusters[i];
                    Node node = new Node(features);
                    nodeList.addNode(node);
                    node.setValues(this.calculateHierarchicalTree(features, this.method, this.calcGeneHCL, this.calcSampleHCL));
                }
                result.addCluster("cluster", result_cluster);
            }
            result.addMatrix("discriminant", discriminantMatrix);
            result.addIntArray("positives", this.getPositives(discriminantMatrix));
            result.addIntArray("negatives", this.getNegatives(discriminantMatrix));
            FloatMatrix means = this.getMeans(discriminantMatrix);
            result.addMatrix("means", means);
            result.addMatrix("variances", this.getVariance(discriminantMatrix, means));
        } else {
            int[] classes = data.getIntArray("classes");
            int seed = map.getInt("seed", 0);
            boolean normalize = map.getBoolean("normalize", false);
            boolean radial = map.getBoolean("radial", false);
            float widthFactor = map.getFloat("width-factor", 1.0f);
            float positiveDiagonal = map.getFloat("positive-diagonal", 0.0f);
            float negativeDiagonal = map.getFloat("negative-diagonal", 0.0f);
            float diagonalFactor = map.getFloat("diagonal-factor", 0.0f);
            float positiveConstraint = map.getFloat("positive-constraint", 1.0f);
            float negativeConstraint = map.getFloat("negative-constraint", 1.0f);
            float convergenceThreshold = map.getFloat("convergence-threshold", 1.0E-5f);
            boolean constrainWeights = map.getBoolean("constrain-weights", true);
            float[] weights = this.train(this.expMatrix, classes, seed, normalize, radial, coefficient, constant, power, widthFactor, positiveDiagonal, negativeDiagonal, diagonalFactor, positiveConstraint, negativeConstraint, convergenceThreshold, constrainWeights);
            result.addMatrix("weights", new FloatMatrix(weights, 1));
        }
        return result;
    }

    public void abort() {
        this.stop = true;
    }

    private final void setSeenUnderflow(boolean seenUnderflow) {
        this.seenUnderflow = seenUnderflow;
    }

    private final boolean isSeenUnderflow() {
        return this.seenUnderflow;
    }

    private FloatMatrix computeBaseKernelMatrix(FloatMatrix trainingMatrix) {
        FloatMatrix kernelMatrix = new FloatMatrix(this.number_of_genes, this.number_of_genes);
        for (int row1 = 0; row1 < this.expMatrix.getRowDimension(); ++row1) {
            for (int row2 = 0; row2 < trainingMatrix.getRowDimension(); ++row2) {
                kernelMatrix.set(row1, row2, ExperimentUtil.geneDistance(this.expMatrix, trainingMatrix, row1, row2, this.function, 1.0f, false));
            }
        }
        return kernelMatrix;
    }

    private FloatMatrix computeNormalizedBaseKernelMatrix(FloatMatrix trainingMatrix) {
        FloatMatrix normTrainingMatrix = new FloatMatrix(this.number_of_genes, this.number_of_samples);
        FloatMatrix kernelMatrix = new FloatMatrix(this.number_of_genes, this.number_of_genes);
        float sumOfSquares = 0.0f;
        for (int row = 0; row < this.number_of_genes; ++row) {
            int col;
            sumOfSquares = 0.0f;
            for (col = 0; col < this.number_of_samples; ++col) {
                float value = trainingMatrix.get(row, col);
                if (Float.isNaN(value)) continue;
                sumOfSquares = (float)((double)sumOfSquares + Math.pow(value, 2.0));
            }
            if ((double)sumOfSquares == 0.0) continue;
            sumOfSquares = (float)Math.sqrt(sumOfSquares);
            for (col = 0; col < this.number_of_samples; ++col) {
                normTrainingMatrix.set(row, col, trainingMatrix.get(row, col) / sumOfSquares);
            }
        }
        int N1 = this.expMatrix.getRowDimension();
        int N2 = trainingMatrix.getRowDimension();
        for (int row1 = 0; row1 < N1; ++row1) {
            for (int row2 = row1; row2 < N2; ++row2) {
                float kernalValue = this.geneDotProduct(normTrainingMatrix, normTrainingMatrix, row1, row2);
                kernelMatrix.set(row1, row2, kernalValue);
                kernelMatrix.set(row2, row1, kernalValue);
            }
        }
        return kernelMatrix;
    }

    private float[] createSelfKernelValues(FloatMatrix kernelMatrix) {
        float[] selfKernelValues = new float[kernelMatrix.getRowDimension()];
        this.extractSelfKernelValues(kernelMatrix, selfKernelValues);
        return selfKernelValues;
    }

    private void extractSelfKernelValues(FloatMatrix kernelMatrix, float[] selfKernelValues) {
        int size = kernelMatrix.getRowDimension();
        for (int i = 0; i < size; ++i) {
            selfKernelValues[i] = kernelMatrix.get(i, i);
        }
    }

    private final float polynomialize(float power, float coefficient, float constant, float value) {
        value += constant;
        return (float)Math.pow(value *= coefficient, power);
    }

    private void polynomializeMatrix(FloatMatrix kernelMatrix, float[] selfKernelValues, float power, float coefficient, float constant) {
        int row;
        int rows = kernelMatrix.getRowDimension();
        int columns = kernelMatrix.getColumnDimension();
        for (row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                kernelMatrix.set(row, column, this.polynomialize(power, coefficient, constant, kernelMatrix.get(row, column)));
            }
        }
        for (row = 0; row < rows; ++row) {
            selfKernelValues[row] = this.polynomialize(power, coefficient, constant, selfKernelValues[row]);
        }
    }

    private final float classify(FloatMatrix kernelMatrix, float[] weights, int test) {
        float returnValue = 0.0f;
        for (int i = 0; i < weights.length; ++i) {
            float thisWeight = weights[i];
            if ((double)thisWeight == 0.0) continue;
            float thisValue = kernelMatrix.get(test, i);
            returnValue += (thisValue *= thisWeight);
        }
        return returnValue;
    }

    private FloatMatrix classifyList(FloatMatrix kernelMatrix, float[] weights) {
        int rows = kernelMatrix.getRowDimension();
        FloatMatrix discriminantMatrix = new FloatMatrix(rows, 2);
        for (int i = 0; i < rows; ++i) {
            float thisDiscriminant = this.classify(kernelMatrix, weights, i);
            if ((double)thisDiscriminant >= 0.0) {
                discriminantMatrix.set(i, 0, 1.0f);
            } else {
                discriminantMatrix.set(i, 0, -1.0f);
            }
            discriminantMatrix.set(i, 1, thisDiscriminant);
        }
        return discriminantMatrix;
    }

    private void normalizeKernelMatrix(FloatMatrix kernelMatrix, float[] selfKernelValues) {
        int row;
        int rows = kernelMatrix.getRowDimension();
        int columns = kernelMatrix.getColumnDimension();
        for (row = 0; row < rows; ++row) {
            float rowDiag = (float)Math.sqrt(selfKernelValues[row]);
            for (int column = 0; column < columns; ++column) {
                float columnDiag = (float)Math.sqrt(selfKernelValues[column]);
                float cell = kernelMatrix.get(row, column);
                cell = (float)((double)cell / ((double)(rowDiag * columnDiag) * 1.0));
                kernelMatrix.set(row, column, cell);
            }
        }
        for (row = 0; row < rows; ++row) {
            selfKernelValues[row] = 1.0f;
        }
    }

    private float computeMedian(float[] array) {
        float returnValue;
        Arrays.sort(array);
        int numberOfItems = array.length;
        if (numberOfItems % 2 == 1) {
            returnValue = array[numberOfItems / 2];
        } else {
            returnValue = array[numberOfItems / 2 - 1];
            returnValue += array[numberOfItems / 2];
            returnValue = (float)((double)returnValue / 2.0);
        }
        return returnValue;
    }

    private final float computeSquaredDistance(float Kxx, float Kxy, float Kyy) {
        return Kxx - 2.0f * Kxy + Kyy;
    }

    private float computeTwoSquaredWidth(FloatMatrix kernelMatrix, int[] classes, float widthFactor) {
        int i;
        int rows = kernelMatrix.getRowDimension();
        int numberOfPositives = 0;
        for (i = 0; i < rows; ++i) {
            if (classes[i] != 1) continue;
            ++numberOfPositives;
        }
        float[] nearestNegatives = new float[numberOfPositives];
        int positive = -1;
        for (i = 0; i < rows; ++i) {
            if (classes[i] != 1) continue;
            nearestNegatives[++positive] = Float.MAX_VALUE;
            for (int j = 0; j < rows; ++j) {
                float squaredDistance;
                if (classes[j] == 1 || !(nearestNegatives[positive] > (squaredDistance = this.computeSquaredDistance(kernelMatrix.get(i, i), kernelMatrix.get(i, j), kernelMatrix.get(j, j))))) continue;
                nearestNegatives[positive] = squaredDistance;
            }
        }
        float returnValue = this.computeMedian(nearestNegatives);
        returnValue = (float)((double)returnValue * (2.0 * (double)widthFactor));
        return returnValue;
    }

    private float radialKernel(float twoSquaredWidth, float Kxx, float Kxy, float Kyy) {
        float returnValue = this.computeSquaredDistance(Kxx, Kxy, Kyy);
        returnValue /= twoSquaredWidth;
        if ((double)(returnValue = (float)Math.exp(-returnValue)) == 0.0 && !this.isSeenUnderflow()) {
            this.setSeenUnderflow(true);
        }
        return returnValue;
    }

    private void radializeMatrix(FloatMatrix kernelMatrix, float[] selfKernelValues, float twoSquaredWidth, float constant) {
        int rows = kernelMatrix.getRowDimension();
        int columns = kernelMatrix.getColumnDimension();
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                float radialValue = this.radialKernel(twoSquaredWidth, selfKernelValues[row], kernelMatrix.get(row, column), selfKernelValues[column]);
                kernelMatrix.set(row, column, radialValue += constant);
            }
        }
        this.extractSelfKernelValues(kernelMatrix, selfKernelValues);
    }

    private float[] getDiagonalConstants(float[] selfKernelValues, int[] classes, float diagonalFactor) {
        if (diagonalFactor == 0.0f) {
            return null;
        }
        int numberOfExamples = classes.length;
        int numberOfPositive = 0;
        int numberOfNegative = 0;
        float medianDiagonal = this.computeMedian(selfKernelValues);
        for (int i = 0; i < numberOfExamples; ++i) {
            if (classes[i] == 1) {
                ++numberOfPositive;
                continue;
            }
            ++numberOfNegative;
        }
        float[] diagonals = new float[]{(float)numberOfPositive / (float)numberOfExamples * diagonalFactor * medianDiagonal, (float)numberOfNegative / (float)numberOfExamples * diagonalFactor * medianDiagonal};
        return diagonals;
    }

    private void addToKernelDiagonal(FloatMatrix kernelMatrix, float[] selfKernelValues, int[] classes, float positiveDiagonal, float negativeDiagonal, float diagonalFactor) {
        float[] diagonals = this.getDiagonalConstants(selfKernelValues, classes, diagonalFactor);
        if (diagonals != null) {
            positiveDiagonal = diagonals[0];
            negativeDiagonal = diagonals[1];
        }
        int rows = kernelMatrix.getRowDimension();
        for (int row = 0; row < rows; ++row) {
            if (classes[row] == 1) {
                kernelMatrix.set(row, row, kernelMatrix.get(row, row) + positiveDiagonal);
                continue;
            }
            kernelMatrix.set(row, row, kernelMatrix.get(row, row) + negativeDiagonal);
        }
    }

    private float computeDiscriminant(FloatMatrix kernelMatrix, float[] weights, int[] classes, int thisItem) {
        float returnValue = 0.0f;
        for (int i = 0; i < classes.length; ++i) {
            if (Float.isNaN(kernelMatrix.get(thisItem, i))) continue;
            returnValue += weights[i] * kernelMatrix.get(thisItem, i) * (float)classes[i];
        }
        return returnValue;
    }

    private boolean converged(AlgorithmEvent event, FloatMatrix kernelMatrix, float[] weights, int[] classes, float convergenceThreshold) {
        float delta = 0.0f;
        float objective = this.computeObjective(kernelMatrix, weights, classes);
        delta = objective - this.prevObjective;
        this.prevObjective = objective;
        if (!Float.isNaN(delta) && !Float.isInfinite(delta)) {
            event.setFloatValue(Math.abs(delta));
            this.fireValueChanged(event);
        }
        return Math.abs(delta) < convergenceThreshold;
    }

    private float computeObjective(FloatMatrix kernelMatrix, float[] weights, int[] classes) {
        float sum = 0.0f;
        for (int i = 0; i < classes.length; ++i) {
            sum = (float)((double)sum + (double)weights[i] * (2.0 - (double)(this.computeDiscriminant(kernelMatrix, weights, classes, i) * (float)classes[i])));
        }
        return sum;
    }

    private float updateWeight(FloatMatrix kernelMatrix, float[] weights, int[] classes, float constraint, boolean constrainWeights, int thisItem) {
        float thisDiscriminant = this.computeDiscriminant(kernelMatrix, weights, classes, thisItem);
        float selfDistance = kernelMatrix.get(thisItem, thisItem);
        float thisWeight = weights[thisItem];
        float thisClass = classes[thisItem];
        float newWeight = 1.0f - thisClass * thisDiscriminant + thisWeight * selfDistance;
        newWeight = (double)selfDistance == 0.0 ? (newWeight /= newWeight) : (newWeight /= selfDistance);
        if ((double)selfDistance != 0.0) {
            thisWeight = weights[thisItem];
            weights[thisItem] = newWeight;
            weights[thisItem] = newWeight;
            thisDiscriminant = this.computeDiscriminant(kernelMatrix, weights, classes, thisItem);
            weights[thisItem] = thisWeight;
        }
        if (constrainWeights && newWeight > constraint) {
            newWeight = constraint;
        } else if ((double)newWeight < 0.0) {
            newWeight = 0.0f;
        }
        return newWeight;
    }

    private long optimizeWeights(FloatMatrix kernelMatrix, float[] weights, int[] classes, int seed, float positiveConstraint, float negativeConstraint, float convergenceThreshold, boolean constrainWeights) throws AlgorithmException {
        long iter = 0L;
        float newWeight = 0.5f;
        float INITIAL_VALUE = 0.5f;
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = INITIAL_VALUE;
        }
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 3);
        this.fireValueChanged(event);
        Random random = new Random(seed);
        while (!this.converged(event, kernelMatrix, weights, classes, convergenceThreshold)) {
            this.isStop();
            for (int i = 0; i < classes.length; ++i) {
                int randItem = random.nextInt(classes.length);
                float constraint = classes[randItem] == 1 ? positiveConstraint : negativeConstraint;
                weights[randItem] = newWeight = this.updateWeight(kernelMatrix, weights, classes, constraint, constrainWeights, randItem);
            }
            if (iter > 1000L) {
                if (JOptionPane.showConfirmDialog(null, "                                Warning: 1000 iterations have failed to optimize weights.\nPlease press OK to continue analysis using current weights OR press CANCEL to abort and try new parameters.\n", "Weight Optimization Warning", 2, 2) == 0) break;
                this.stop = true;
            }
            ++iter;
        }
        return iter + 1L;
    }

    private void signWeights(float[] weights, int[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            weights[i] = weights[i] * (float)classes[i];
        }
    }

    private FloatMatrix classify(FloatMatrix trainingMatrix, float[] weights, float coefficient, float constant, float power) {
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 2, 0);
        this.sendEvent(event, "CLASSIFYING\n");
        event.setDescription("Computing base kernel matrix\n");
        this.fireValueChanged(event);
        FloatMatrix kernelMatrix = this.computeNormalizedBaseKernelMatrix(trainingMatrix);
        float[] selfKernelValues = this.createSelfKernelValues(kernelMatrix);
        event.setDescription("Polynomializing kernel matrix\n");
        this.fireValueChanged(event);
        this.polynomializeMatrix(kernelMatrix, selfKernelValues, power, coefficient, constant);
        FloatMatrix discriminantMatrix = this.classifyList(kernelMatrix, weights);
        return discriminantMatrix;
    }

    private float[] train(FloatMatrix trainingMatrix, int[] classes, int seed, boolean normalize, boolean radial, float coefficient, float constant, float power, float widthFactor, float positiveDiagonal, float negativeDiagonal, float diagonalFactor, float positiveConstraint, float negativeConstraint, float convergenceThreshold, boolean constrainWeights) throws AlgorithmException {
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 2, 0);
        this.sendEvent(event, "TRAINING SVM\n");
        this.sendEvent(event, "Computing base kernel matrix\n");
        FloatMatrix kernelMatrix = this.computeNormalizedBaseKernelMatrix(trainingMatrix);
        this.sendEvent(event, "Extract the diagonal from the kernel matrix.\n");
        float[] selfKernelValues = this.createSelfKernelValues(kernelMatrix);
        this.isStop();
        if (normalize) {
            this.sendEvent(event, "Normalizing kernel matrix\n");
            this.normalizeKernelMatrix(kernelMatrix, selfKernelValues);
        }
        this.isStop();
        if (!radial) {
            this.sendEvent(event, "Polynomializing kernel matrix\n");
            this.polynomializeMatrix(kernelMatrix, selfKernelValues, power, coefficient, constant);
        }
        if (radial) {
            this.sendEvent(event, "Convert to a radial basis kernel.\n");
            float twoSquaredWidth = this.computeTwoSquaredWidth(kernelMatrix, classes, widthFactor);
            this.radializeMatrix(kernelMatrix, selfKernelValues, twoSquaredWidth, constant);
        }
        this.isStop();
        this.sendEvent(event, "Adding constants to kernel matrix\n");
        this.addToKernelDiagonal(kernelMatrix, selfKernelValues, classes, positiveDiagonal, negativeDiagonal, diagonalFactor);
        this.isStop();
        float[] weights = new float[this.number_of_genes];
        this.sendEvent(event, "Optimizing weights\n");
        this.optimizeWeights(kernelMatrix, weights, classes, seed, positiveConstraint, negativeConstraint, convergenceThreshold, constrainWeights);
        this.sendEvent(event, "Encoding the classifications as the signs of the weights.\n");
        this.signWeights(weights, classes);
        return weights;
    }

    private void isStop() throws AbortException {
        if (this.stop) {
            throw new AbortException();
        }
    }

    private void sendEvent(AlgorithmEvent event, String description) {
        event.setDescription(description);
        this.fireValueChanged(event);
    }

    private int[] getPositives(FloatMatrix matrix) {
        int cnt = 0;
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            if ((double)matrix.get(i, 0) != 1.0) continue;
            ++cnt;
        }
        int[] pos = new int[cnt];
        cnt = 0;
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            if ((double)matrix.get(i, 0) != 1.0) continue;
            pos[cnt] = i;
            ++cnt;
        }
        return pos;
    }

    private int[] getNegatives(FloatMatrix matrix) {
        int cnt = 0;
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            if (!(matrix.get(i, 0) <= 0.0f)) continue;
            ++cnt;
        }
        int[] neg = new int[cnt];
        cnt = 0;
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            if (!(matrix.get(i, 0) <= 0.0f)) continue;
            neg[cnt] = i;
            ++cnt;
        }
        return neg;
    }

    private float geneDotProduct(FloatMatrix matrix, FloatMatrix M, int g1, int g2) {
        if (M == null) {
            M = matrix;
        }
        int k = matrix.getColumnDimension();
        int n = 0;
        double sum = 0.0;
        for (int i = 0; i < k; ++i) {
            if (Float.isNaN(matrix.get(g1, i)) || Float.isNaN(M.get(g2, i))) continue;
            sum += (double)(matrix.get(g1, i) * M.get(g2, i));
            ++n;
        }
        return (float)sum;
    }

    private FloatMatrix getMeans(FloatMatrix discMatrix) {
        int numSamples = this.expMatrix.getColumnDimension();
        int numGenes = this.expMatrix.getRowDimension();
        FloatMatrix means = new FloatMatrix(2, numSamples);
        float posMean = 0.0f;
        float negMean = 0.0f;
        int posCnt = 0;
        int negCnt = 0;
        for (int j = 0; j < numSamples; ++j) {
            for (int i = 0; i < numGenes; ++i) {
                float value;
                float c = discMatrix.get(i, 0);
                if (c == 1.0f) {
                    value = this.expMatrix.get(i, j);
                    if (Float.isNaN(value)) continue;
                    ++posCnt;
                    posMean += value;
                    continue;
                }
                value = this.expMatrix.get(i, j);
                if (Float.isNaN(value)) continue;
                ++negCnt;
                negMean += value;
            }
            means.set(0, j, posCnt != 0 ? posMean / (float)posCnt : 0.0f);
            means.set(1, j, negCnt != 0 ? negMean / (float)negCnt : 0.0f);
            posCnt = 0;
            negCnt = 0;
            posMean = 0.0f;
            negMean = 0.0f;
        }
        return means;
    }

    private FloatMatrix getVariance(FloatMatrix discMatrix, FloatMatrix means) {
        int numSamples = this.expMatrix.getColumnDimension();
        int numGenes = this.expMatrix.getRowDimension();
        FloatMatrix vars = new FloatMatrix(2, numSamples);
        float ssePos = 0.0f;
        int posCnt = 0;
        float sseNeg = 0.0f;
        int negCnt = 0;
        for (int i = 0; i < numSamples; ++i) {
            for (int j = 0; j < numGenes; ++j) {
                float value;
                float c = discMatrix.get(j, 0);
                if (c == 1.0f) {
                    value = this.expMatrix.get(j, i);
                    if (Float.isNaN(value)) continue;
                    ssePos = (float)((double)ssePos + Math.pow(value - means.get(0, i), 2.0));
                    ++posCnt;
                    continue;
                }
                value = this.expMatrix.get(j, i);
                if (Float.isNaN(value)) continue;
                sseNeg = (float)((double)sseNeg + Math.pow(value - means.get(1, i), 2.0));
                ++negCnt;
            }
            vars.set(0, i, (float)(posCnt > 1 ? Math.sqrt(ssePos / (float)(posCnt - 1)) : 0.0));
            vars.set(1, i, (float)(negCnt > 1 ? Math.sqrt(sseNeg / (float)(negCnt - 1)) : 0.0));
            posCnt = 0;
            negCnt = 0;
            ssePos = 0.0f;
            sseNeg = 0.0f;
        }
        return vars;
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.svmGenes ? this.getSubExperiment(this.expMatrix, features) : this.getSubExperimentReducedCols(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        System.out.println("In SVM algorithm , metric for HCL = " + this.function);
        data.addParam("hcl-distance-function", String.valueOf(this.function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            int[] nodes = result.getIntArray("node-order");
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(ArrayList source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (int)((Float)source.get(i)).floatValue();
        }
        return int_matrix;
    }

    private void printMatrix(String title, FloatMatrix matrix) {
        System.out.println("===== " + title + " =====");
        matrix.print(5, 2);
    }

    private void printFloatArray(String title, float[] floatArray) {
        System.out.println("===== " + title + " =====");
        for (int i = 0; i < floatArray.length; ++i) {
            System.out.print(floatArray[i] + " ");
        }
        System.out.println();
    }

    private void printKernelDiagonal(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            System.out.println("Kernal diagonal " + matrix.get(i, i));
        }
    }

    private void printWeights(float[] w) {
        for (int i = 0; i < w.length; ++i) {
            System.out.println("Weight = " + w[i]);
        }
    }
}

