/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.rosuda.JRI.Rengine;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.gui.impl.surv.SURVAlgorithmData;
import org.tigr.rhook.RHook;
import org.tigr.util.FloatMatrix;

public class SURV
extends AbstractAlgorithm {
    private int progress;
    private FloatMatrix expMatrix;
    private boolean stop = false;
    private int[] groupAssignments;
    private int[][] sigGenesArrays;
    private int numGenes;
    private int numExps;
    private int numGroups;
    private int iteration;
    private int numAGroups;
    private int numBGroups;
    private int hcl_function;
    private boolean hcl_absolute;
    private boolean hcl_genes_ordered;
    private boolean hcl_samples_ordered;
    private AlgorithmEvent event;
    private boolean robust;
    private boolean useWeights = false;
    private Vector<Float> eventTimesGroup1;
    private Vector<Float> eventTimesGroup2;
    private Vector<Boolean> eventStatusGroup1;
    private Vector<Boolean> eventStatusGroup2;
    private Vector<Integer> origIndexGroup1;
    private Vector<Integer> origIndexGroup2;
    double[] observed;
    double[] expected;
    int[] sizes;
    double chisq;
    double[][] varianceMatrix;
    double pvalue;
    int degFreedom;
    double coefficient;
    double variance;
    double initialloglik;
    double finalloglik;
    double nativevar;
    double score;
    double rscore;
    double waldtest;
    int iterationcount;
    double[] linearPredictors;
    double[] residuals;
    String[] residualsNames;
    double mean;
    double number;
    double[] weights;
    String method;
    FloatMatrix expression;
    int[] geneIndices;
    String[] sampleNames;
    double lambda1 = 10.0;
    double crossValidationLikelihood = 0.0;
    boolean comparison;
    double[] penalizedCoefficients;
    int[] nonzeroCoefficientsIndexes;
    int[] penalizedCoefficientIndexes;
    double[] unpenalizedCoefficients;
    double[] basesurvTime;
    double[] basesurvSurvival;
    double[] basehazplotx;
    double[] basehazploty;
    double logLikelihood;
    double l1penalty;
    double l2penalty;
    double[] fittedValues;
    double[] curvesurvival;
    double[] curvetime;
    SURVAlgorithmData result = new SURVAlgorithmData();
    int validN;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        return this.execute((SURVAlgorithmData)data);
    }

    public SURVAlgorithmData execute(SURVAlgorithmData data) throws AlgorithmException {
        this.eventStatusGroup1 = data.getGroup1Statuses();
        this.eventStatusGroup2 = data.getGroup2Statuses();
        this.eventTimesGroup1 = data.getGroup1Events();
        this.eventTimesGroup2 = data.getGroup2Events();
        this.origIndexGroup1 = data.getGroup1OriginalIndexes();
        this.origIndexGroup2 = data.getGroup2OriginalIndexes();
        this.expression = data.getExpressionMatrix();
        this.geneIndices = data.getGeneIndices();
        this.sampleNames = data.getSampleLabels();
        this.comparison = data.isComparison();
        this.result.setComparison(data.isComparison());
        this.progress = 0;
        this.event = null;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Calculating...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        this.runRAlg();
        if (this.stop) {
            throw new AbortException();
        }
        if (this.comparison && this.observed == null) {
            throw new AbortException();
        }
        if (this.comparison) {
            Vector<Float> medianSurvival = new Vector<Float>();
            medianSurvival.add(0, SURV.median(this.eventTimesGroup1.toArray(new Float[this.eventTimesGroup1.size()])));
            medianSurvival.add(1, SURV.median(this.eventTimesGroup2.toArray(new Float[this.eventTimesGroup2.size()])));
            this.result.setMedians(medianSurvival);
            Vector<Double> observedv = new Vector<Double>();
            for (int i = 0; i < this.observed.length; ++i) {
                observedv.add(this.observed[i]);
            }
            if (this.observed.length <= 0) {
                this.result.setEmptyResults(true);
                return this.result;
            }
            this.result.setEmptyResults(false);
            Vector<Double> expectedv = new Vector<Double>();
            for (int i = 0; i < this.expected.length; ++i) {
                expectedv.add(this.expected[i]);
            }
            Object[][] variancematrix = new Double[this.varianceMatrix.length][];
            for (int i = 0; i < this.varianceMatrix.length; ++i) {
                variancematrix[i] = new Double[this.varianceMatrix[i].length];
                for (int j = 0; j < this.varianceMatrix[i].length; ++j) {
                    variancematrix[i][j] = new Double(this.varianceMatrix[i][j]);
                }
            }
            this.result.addObjectMatrix("variances", variancematrix);
            this.result.setExpected(this.expected);
            this.result.setObserved(this.observed);
            this.result.setSizes(this.sizes);
            this.result.setChiSquare(new Float(this.chisq).floatValue());
            this.result.setPValue(new Float(this.pvalue).floatValue());
            this.result.addParam("degrees-freedom", new Integer(this.degFreedom).toString());
            this.result.setLinearPredictors(this.linearPredictors);
            this.result.setResiduals(this.residuals);
            this.result.setResidualsNames(this.residualsNames);
            this.result.setCoefficient(this.coefficient);
        } else {
            this.result.setLambda(this.lambda1);
            int[] allCoefficientIndices = this.result.getPenalizedCoefficientIndexes();
            if (allCoefficientIndices.length <= 0) {
                this.result.setEmptyResults(true);
                return this.result;
            }
            this.result.setEmptyResults(false);
            Vector allCoefficients = this.result.getPenalizedCoefficients();
            int[][] clusters = this.separateCoefficients(allCoefficientIndices, allCoefficients);
            this.result.setBasehazplotx(this.basehazplotx);
            this.result.setBasehazploty(this.basehazploty);
            this.result.setBasesurvSurvival(this.basesurvSurvival);
            this.result.setBasesurvTime(this.basesurvTime);
            this.result.setL1penalty(this.l1penalty);
            this.result.setL2penalty(this.l2penalty);
            this.result.setlogLikelihood(this.logLikelihood);
            this.result.setResiduals(this.residuals);
            this.result.setResidualsNames(this.residualsNames);
            this.result.setFittedValues(this.fittedValues);
            this.result.setLinearPredictors(this.linearPredictors);
            this.result.setCoefficient(this.coefficient);
            this.result.setVariance(this.variance);
            this.result.setInitialLogLik(this.initialloglik);
            this.result.setFinalLogLik(this.finalloglik);
            this.result.setNativeVar(this.nativevar);
            this.result.setScore(this.score);
            this.result.setRScore(this.rscore);
            this.result.setWaldTest(this.waldtest);
            this.result.setIterationCount(this.iterationcount);
            this.result.setResiduals(this.residuals);
            this.result.setMean(this.mean);
            this.result.setNumber(this.number);
            this.result.setCrossValLik(this.crossValidationLikelihood);
            if (this.weights != null && this.weights.length > 0) {
                this.result.setWeights(this.weights);
            }
            this.result.setResClusters(clusters);
        }
        return this.result;
    }

    private int[][] separateCoefficients(int[] allCoefficientIndices, Vector<Double> allCoefficients) {
        int[][] clusters = new int[2][];
        int numZeroes = 0;
        for (int i = 0; i < allCoefficientIndices.length; ++i) {
            if (allCoefficients.get(i) != 0.0) continue;
            ++numZeroes;
        }
        clusters[0] = new int[this.penalizedCoefficients.length - numZeroes];
        clusters[1] = new int[numZeroes];
        int zeroesCounter = 0;
        int nonZeroesCounter = 0;
        for (int i = 0; i < allCoefficientIndices.length; ++i) {
            if (allCoefficients.get(i) == 0.0) {
                clusters[1][zeroesCounter] = allCoefficientIndices[i];
                ++zeroesCounter;
                continue;
            }
            clusters[0][nonZeroesCounter] = allCoefficientIndices[i];
            ++nonZeroesCounter;
        }
        return clusters;
    }

    public void runRAlg() throws AbortException {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        try {
            Rengine re = RHook.startRSession();
            if (re == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        try {
            System.out.println("Testing Survival install");
            if (RHook.getOS() == 3 || RHook.getOS() == 1) {
                RHook.testPackage((String)"survival");
            } else {
                RHook.installModule((String)"survival");
            }
            RHook.log((String)"Starting R Algorithim");
            String rCmd = "library(survival)";
            RHook.evalR((String)rCmd);
            rCmd = "library(penalized)";
            RHook.evalR((String)rCmd);
            File tempfile = File.createTempFile("mev_surv", ".txt");
            tempfile.deleteOnExit();
            this.writeEventDataToFile(tempfile.getAbsolutePath());
            String filename = tempfile.getAbsolutePath();
            filename = filename.replace("\\", "/");
            RHook.evalR((String)("sampleAnns <- read.delim('" + filename + "', header=TRUE, check.names=FALSE, sep='\\t', fill=FALSE, na.strings=c(\"N/A\", \"null\"))"));
            if (this.comparison) {
                RHook.evalR((String)"survdata <- survdiff(Surv(eventtime, censoredflag) ~ group, data=sampleAnns)");
                this.observed = RHook.evalR((String)"survdata$obs").asDoubleArray();
                this.expected = RHook.evalR((String)"survdata$exp").asDoubleArray();
                this.sizes = RHook.evalR((String)"survdata$n").asIntArray();
                this.chisq = RHook.evalR((String)"survdata$chisq").asDouble();
                this.varianceMatrix = RHook.evalR((String)"survdata$var").asDoubleMatrix();
                this.pvalue = RHook.evalR((String)"pchisq(survdata$chisq, 1, lower.tail=FALSE)").asDouble();
                this.degFreedom = 1;
                RHook.evalR((String)"model <- coxph(Surv(eventtime, censoredflag) ~ group, data=sampleAnns)");
                this.coefficient = RHook.evalR((String)"model$coefficients").asDouble();
                this.variance = RHook.evalR((String)"model$var").asDouble();
                double[] loglikelihoods = RHook.evalR((String)"model$loglik").asDoubleArray();
                this.initialloglik = loglikelihoods[0];
                this.finalloglik = loglikelihoods[1];
                this.score = RHook.evalR((String)"model$score").asDouble();
                if (this.robust) {
                    this.nativevar = RHook.evalR((String)"model$native.var").asDouble();
                    this.rscore = RHook.evalR((String)"model$rscore").asDouble();
                }
                this.waldtest = RHook.evalR((String)"model$wald.test").asDouble();
                this.iterationcount = RHook.evalR((String)"model$wald.iter").asInt();
                this.linearPredictors = RHook.evalR((String)"model$linear.predictors").asDoubleArray();
                this.residuals = RHook.evalR((String)"model$residuals").asDoubleArray();
                this.residualsNames = RHook.evalR((String)"names(model$residuals)").asStringArray();
                this.mean = RHook.evalR((String)"model$means").asDouble();
                this.number = RHook.evalR((String)"model$n").asDouble();
                if (this.useWeights) {
                    this.weights = RHook.evalR((String)"model$weights").asDoubleArray();
                }
                this.method = RHook.evalR((String)"model$method").asString();
            } else {
                File tempexprfile = File.createTempFile("mev_surv_expr", ".txt");
                tempexprfile.deleteOnExit();
                String[] geneLabels = new String[this.geneIndices.length];
                for (int i = 0; i < this.geneIndices.length; ++i) {
                    geneLabels[i] = new Integer(this.geneIndices[i]).toString();
                }
                String fileLoc = this.writeMatrixToFile(tempexprfile.getAbsolutePath(), this.expression, geneLabels);
                fileLoc = fileLoc.replace("\\", "/");
                RHook.createRDataMatrixFromFile((String)"expressionMatrix", (String)fileLoc, (boolean)true, (String[])this.sampleNames);
                RHook.evalR((String)"alldata <- cbind(eventtime=sampleAnns$eventtime, censoredflag=sampleAnns$censoredflag, t(expressionMatrix))");
                RHook.evalR((String)"alldata <- as.data.frame(alldata)");
                RHook.evalR((String)("capture.output(pen <- penalized(Surv(alldata$eventtime, alldata$censoredflag), penalized = data.matrix(alldata[,c(3:dim(alldata)[[2]])]),data = alldata, lambda1 = " + this.lambda1 + ", " + "model='cox'" + ")" + ")"));
                int nonzero = RHook.evalR((String)"length(coefficients(pen, 'nonzero'))").asInt();
                RHook.evalR((String)("capture.output(cvl <- cvl(Surv(alldata$eventtime, alldata$censoredflag), penalized = data.matrix(alldata[,c(3:dim(alldata)[[2]])]),data = alldata, lambda1 = " + this.lambda1 + ", " + "model='cox'" + ")" + ")"));
                this.crossValidationLikelihood = RHook.evalR((String)"cvl$cvl").asDouble();
                this.penalizedCoefficients = RHook.evalR((String)"coefficients(pen, 'penalized')").asDoubleArray();
                this.penalizedCoefficientIndexes = RHook.evalR((String)"as.integer(names(coefficients(pen, 'penalized')))").asIntArray();
                this.basesurvTime = RHook.evalR((String)"as.data.frame(basesurv(pen))$time").asDoubleArray();
                this.basesurvSurvival = RHook.evalR((String)"as.data.frame(basesurv(pen))$survival").asDoubleArray();
                this.basehazplotx = RHook.evalR((String)"basehaz(pen)$time").asDoubleArray();
                this.basehazploty = RHook.evalR((String)"basehaz(pen)$hazard").asDoubleArray();
                this.logLikelihood = RHook.evalR((String)"loglik(pen)").asDouble();
                this.l1penalty = RHook.evalR((String)"penalty(pen)[[1]]").asDouble();
                this.l2penalty = RHook.evalR((String)"penalty(pen)[[2]]").asDouble();
                this.residuals = RHook.evalR((String)"residuals(pen)").asDoubleArray();
                this.fittedValues = RHook.evalR((String)"fitted.values(pen)").asDoubleArray();
                this.linearPredictors = RHook.evalR((String)"linear.predictors(pen)").asDoubleArray();
                this.weights = RHook.evalR((String)"weights(pen)").asDoubleArray();
                this.curvesurvival = RHook.evalR((String)"as.data.frame(basesurv(pen))$survival").asDoubleArray();
                this.curvetime = RHook.evalR((String)"as.data.frame(basesurv(pen))$time").asDoubleArray();
                this.residualsNames = RHook.evalR((String)"names(residuals(pen))").asStringArray();
                this.result.setPenalizedCoefficientIndexes(this.penalizedCoefficientIndexes);
                this.result.setPenalizedCoefficients(this.penalizedCoefficients);
            }
            RHook.endRSession();
        }
        catch (Exception e) {
            e.printStackTrace();
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
                JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
                throw new AbortException();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.getSubExperiment(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            data.addParam("optimize-gene-ordering", String.valueOf(this.hcl_genes_ordered));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            data.addParam("optimize-sample-ordering", String.valueOf(this.hcl_samples_ordered));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private String writeMatrixToFile(String fileLoc, FloatMatrix fm, String[] rowNames) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
            int row = fm.getRowDimension();
            int col = fm.getColumnDimension();
            String srtVector = "";
            for (int iRow = 0; iRow < row; ++iRow) {
                srtVector = rowNames[iRow] + "\t";
                for (int jCol = 0; jCol < col; ++jCol) {
                    srtVector = jCol == col - 1 ? srtVector + fm.get(iRow, jCol) + "\n" : srtVector + fm.get(iRow, jCol) + "\t";
                }
                out.write(srtVector);
                srtVector = "";
            }
            out.close();
        }
        catch (IOException e) {
            return null;
        }
        return fileLoc;
    }

    private String writeEventDataToFile(String fileLoc) {
        try {
            Boolean flag;
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
            out.write("eventtime\tcensoredflag\tgroup\n");
            String rowContents = "";
            for (i = 0; i < this.eventStatusGroup1.size(); ++i) {
                flag = this.eventStatusGroup1.get(i) == false;
                rowContents = this.origIndexGroup1.get(i) + "\t" + this.eventTimesGroup1.get(i) + "\t" + flag.toString().toUpperCase() + "\t" + "group1\n";
                out.write(rowContents);
            }
            for (i = 0; i < this.eventStatusGroup2.size(); ++i) {
                flag = this.eventStatusGroup2.get(i) == false;
                rowContents = this.origIndexGroup2.get(i) + "\t" + this.eventTimesGroup2.get(i) + "\t" + flag.toString().toUpperCase() + "\t" + "group2\n";
                out.write(rowContents);
            }
            out.close();
        }
        catch (IOException e) {
            return null;
        }
        return fileLoc;
    }

    private String getOneClassDesign() {
        String str = "design <- c(";
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            str = str + Integer.toString(this.groupAssignments[i]);
            if (i >= this.groupAssignments.length - 1) continue;
            str = str + ", ";
        }
        str = str + ")";
        return str;
    }

    private String getTwoClassDesign() {
        String grp1 = "";
        String grp2 = "";
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                grp1 = grp1 + "1";
                grp2 = grp2 + "0";
            } else if (this.groupAssignments[i] == 2) {
                grp1 = grp1 + "1";
                grp2 = grp2 + "1";
            } else {
                grp1 = grp1 + "0";
                grp2 = grp2 + "0";
            }
            if (i >= this.groupAssignments.length - 1) continue;
            grp1 = grp1 + ", ";
            grp2 = grp2 + ", ";
        }
        String str = "design <- cbind(Grp1=c(" + grp1 + "),Grp2=c(" + grp2 + "))";
        return str;
    }

    private String getMultiClassDesign() {
        int i;
        String[] grpArray = new String[this.numGroups];
        for (i = 0; i < this.numGroups; ++i) {
            grpArray[i] = "";
        }
        for (i = 0; i < this.groupAssignments.length; ++i) {
            int j;
            for (j = 0; j < this.numGroups; ++j) {
                grpArray[j] = this.groupAssignments[i] == j + 1 ? grpArray[j] + "1" : grpArray[j] + "0";
            }
            if (i >= this.groupAssignments.length - 1) continue;
            for (j = 0; j < this.numGroups; ++j) {
                grpArray[j] = grpArray[j] + ", ";
            }
        }
        String str = "design <- cbind(";
        for (int i2 = 0; i2 < this.numGroups; ++i2) {
            str = str + "Grp" + (i2 + 1) + "=c(" + grpArray[i2] + ")";
            if (i2 >= this.numGroups - 1) continue;
            str = str + ", ";
        }
        str = str + ")";
        return str;
    }

    private String getTwoFactorDesign() {
        String str = "design <- model.matrix(~0 + TS)";
        return str;
    }

    private String getTimeCourseDesign() {
        String str = "design <- model.matrix(~0 + TS)";
        return str;
    }

    public void updateProgressBar() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / (this.progress + 7));
    }

    public static Float median(Float[] a) {
        Object[] b = new Float[a.length];
        System.arraycopy(a, 0, b, 0, b.length);
        Arrays.sort(b);
        if (a.length % 2 == 0) {
            return new Float((double)(((Float)b[b.length / 2 - 1]).floatValue() + ((Float)b[b.length / 2]).floatValue()) / 2.0);
        }
        return new Float(((Float)b[b.length / 2]).floatValue());
    }
}

