/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Vector;
import org.tigr.util.FloatMatrix;

public class SOTACell {
    public FloatMatrix dataMatrix;
    public SOTACell parent;
    public SOTACell left;
    public SOTACell right;
    public SOTACell pred;
    public SOTACell succ;
    public FloatMatrix centroidGene;
    public Vector members;
    public double cellDiversity;
    public double cellVariance;
    private int numberOfSamples;
    public boolean changedMembership;

    public SOTACell(int NumberOfSamples, FloatMatrix DataMatrix) {
        this.dataMatrix = DataMatrix;
        this.numberOfSamples = NumberOfSamples;
        this.changedMembership = false;
        this.centroidGene = new FloatMatrix(1, this.numberOfSamples);
        for (int i = 0; i < this.numberOfSamples; ++i) {
            this.centroidGene.set(0, i, 0.0f);
        }
        this.members = new Vector();
        this.cellDiversity = 0.0;
        this.cellVariance = 0.0;
        this.succ = null;
        this.pred = null;
        this.right = null;
        this.left = null;
        this.parent = null;
    }

    public void removeMember(int geneNum) {
        for (int i = 0; i < this.members.size(); ++i) {
            if (geneNum != (Integer)this.members.elementAt(i)) continue;
            this.members.removeElementAt(i);
            this.changedMembership = true;
            break;
        }
    }

    public void migrateCentroid(int geneIndex, float nu) {
        for (int i = 0; i < this.numberOfSamples; ++i) {
            if (Float.isNaN(this.dataMatrix.get(geneIndex, i))) continue;
            this.centroidGene.set(0, i, this.centroidGene.get(0, i) + nu * (this.dataMatrix.get(geneIndex, i) - this.centroidGene.get(0, i)));
        }
    }

    public float getColumnVar(int index) {
        int n = this.members.size();
        float sum = 0.0f;
        int numOfNaN = 0;
        for (int i = 0; i < n; ++i) {
            int geneIndex = (Integer)this.members.elementAt(i);
            float currVal = this.dataMatrix.get(geneIndex, index);
            if (Float.isNaN(currVal)) continue;
            sum = (float)((double)sum + Math.pow(currVal - this.centroidGene.get(0, index), 2.0));
            ++numOfNaN;
        }
        if (numOfNaN > 1) {
            return (float)Math.sqrt(sum / (float)(numOfNaN - 1));
        }
        return 0.0f;
    }

    public void addMember(int geneNum) {
        this.members.add(new Integer(geneNum));
        this.changedMembership = true;
    }

    public SOTACell findSister() {
        if (this != null) {
            if (this.parent.left == this) {
                return this.parent.right;
            }
            return this.parent.left;
        }
        return null;
    }
}

