/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.awt.Dimension;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.algorithm.impl.SOTACell;
import org.tigr.util.FloatMatrix;

public class SOTA
extends AbstractAlgorithm {
    private AlgorithmData inData;
    private FloatMatrix dataMatrix;
    private int numberOfGenes;
    private int numberOfSamples;
    public int cycleNum;
    private int numberOfClusters;
    private int utilCounter;
    private float initDivSum;
    private SOTACell root;
    private SOTACell head;
    private SOTACell mostDiverseCell;
    private SOTACell mostVariableCell;
    public SOTACell[] myNucleus;
    private double treeDiversity;
    private Vector cycleDiversity;
    Cluster clusters;
    boolean sotaGenes = true;
    int maxNumEpochs;
    int maxNumCycles;
    float epochCriteria;
    float endCriteria;
    float migW;
    float migP;
    float migS;
    int neighborhoodLevel;
    boolean useClusterVariance;
    float pValue;
    boolean runToMaxCycles;
    boolean stop = false;
    int function;
    float factor;
    float myFactor;
    boolean absolute;
    boolean calcClusterHCL;
    boolean calcFullTreeHCL;
    boolean calculate_genes;
    boolean calculate_experiments;
    int method;
    private int hcl_function;
    private boolean hcl_absolute;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        AlgorithmParameters params = data.getParams();
        this.sotaGenes = params.getBoolean("sota-cluster-genes", true);
        this.maxNumEpochs = params.getInt("max-epochs-per-cycle", 1000);
        this.maxNumCycles = params.getInt("max-number-of-cycles", 10);
        this.epochCriteria = params.getFloat("epoch-improvement-cutoff");
        this.endCriteria = params.getFloat("end-training-diversity");
        this.runToMaxCycles = params.getBoolean("run-to-max-cycles");
        this.useClusterVariance = params.getBoolean("use-cluster-variance", false);
        this.function = params.getInt("distance-function", 4);
        this.absolute = params.getBoolean("distance-absolute", true);
        this.calcClusterHCL = params.getBoolean("calcClusterHCL", false);
        this.calculate_genes = params.getBoolean("calculate-genes", false);
        this.calculate_experiments = params.getBoolean("calculate-experiments", false);
        this.calcFullTreeHCL = params.getBoolean("calcFullTreeHCL", false);
        this.method = params.getInt("method-linkage", 0);
        this.pValue = params.getFloat("pValue", 0.05f);
        this.migW = params.getFloat("mig_w", 0.01f);
        this.migP = params.getFloat("mig_p", 0.005f);
        this.migS = params.getFloat("mig_s", 0.001f);
        this.neighborhoodLevel = params.getInt("neighborhood-level", 5);
        this.hcl_function = params.getInt("hcl-distance-function", 4);
        this.hcl_absolute = params.getBoolean("hcl-distance-absolute", false);
        this.inData = data;
        this.myFactor = this.function == 1 || this.function == 6 || this.function == 7 || this.function == 2 || this.function == 3 || this.function == 5 || this.function == 9 || this.function == 10 ? -1.0f : 1.0f;
        this.factor = 1.0f;
        this.inData.addParam("factor", String.valueOf(this.myFactor));
        this.endCriteria *= this.myFactor;
        this.treeDiversity = Double.POSITIVE_INFINITY;
        this.dataMatrix = data.getMatrix("experiment");
        this.numberOfGenes = this.dataMatrix.getRowDimension();
        this.numberOfSamples = this.dataMatrix.getColumnDimension();
        this.myNucleus = new SOTACell[this.numberOfGenes];
        this.cycleDiversity = new Vector();
        if (this.maxNumCycles >= this.numberOfGenes) {
            this.maxNumCycles = this.numberOfGenes - 1;
        }
        if (this.useClusterVariance) {
            this.endCriteria = this.resampleAndGetNewCutoff(this.dataMatrix, this.pValue);
        }
        this.root = new SOTACell(this.numberOfSamples, this.dataMatrix);
        this.root.right = new SOTACell(this.numberOfSamples, this.dataMatrix);
        this.root.left = new SOTACell(this.numberOfSamples, this.dataMatrix);
        this.numberOfClusters = 2;
        this.root.left.parent = this.root;
        this.root.right.parent = this.root;
        this.head = this.root.left;
        this.root.left.succ = this.root.right;
        this.root.right.pred = this.root.left;
        int[] numberOfValidGenesInSample = new int[this.numberOfSamples];
        for (i = 0; i < this.numberOfSamples; ++i) {
            numberOfValidGenesInSample[i] = 0;
        }
        for (i = 0; i < this.numberOfSamples; ++i) {
            this.root.centroidGene.set(0, i, 0.0f);
        }
        for (i = 0; i < this.numberOfGenes; ++i) {
            this.root.members.add(new Integer(i));
            this.myNucleus[i] = this.root;
            for (int j = 0; j < this.numberOfSamples; ++j) {
                if (Float.isNaN(this.dataMatrix.get(i, j))) continue;
                int n = j;
                numberOfValidGenesInSample[n] = numberOfValidGenesInSample[n] + 1;
                this.root.centroidGene.set(0, j, this.root.centroidGene.get(0, j) + this.dataMatrix.get(i, j));
            }
        }
        this.mostDiverseCell = this.root;
        this.mostVariableCell = this.root;
        for (int j = 0; j < this.numberOfSamples; ++j) {
            this.root.centroidGene.set(0, j, this.root.centroidGene.get(0, j) / (float)numberOfValidGenesInSample[j]);
            this.root.left.centroidGene.set(0, j, this.root.centroidGene.get(0, j));
            this.root.right.centroidGene.set(0, j, this.root.centroidGene.get(0, j));
        }
        this.initDivSum = this.getNodeDiversitySum(this.root);
        this.cycleDiversity.add(new Float(this.initDivSum));
        this.root.cellDiversity = this.initDivSum / (float)this.numberOfGenes;
        if (this.useClusterVariance) {
            this.root.cellVariance = this.getNodeVariance(this.root);
        }
        if (this.runToMaxCycles) {
            this.growSOTUnrestricted();
        } else {
            this.growSOT();
        }
        if (this.calcFullTreeHCL) {
            this.calcFullTreeHCL();
        }
        if (this.calcClusterHCL) {
            this.calculateClusterHCL();
        }
        return this.inData;
    }

    private float resampleAndGetNewCutoff(FloatMatrix origMatrix, float p) {
        int i;
        FloatMatrix randMatrix = this.randomizeMatrix(origMatrix);
        int rows = origMatrix.getRowDimension();
        int cols = origMatrix.getColumnDimension();
        int NUM_BINS = 500;
        int numSamplePoints = 0;
        float[][] distances = new float[rows][rows];
        for (int i2 = 0; i2 < rows - 1; ++i2) {
            for (int j = 0; j < i2; ++j) {
                distances[i2][j] = ExperimentUtil.geneDistance(randMatrix, null, i2, j, this.function, this.factor, this.absolute);
            }
        }
        float[] minAndMax = this.getMinAndMax(distances, rows);
        float min = minAndMax[0];
        float max = minAndMax[1];
        float[] cumDist = new float[NUM_BINS];
        for (i = 0; i < NUM_BINS; ++i) {
            cumDist[i] = 0.0f;
        }
        for (i = 0; i < rows - 1; ++i) {
            for (int j = 0; j < i; ++j) {
                int n = (int)((float)(NUM_BINS - 1) * (distances[i][j] - min) / (max - min));
                cumDist[n] = cumDist[n] + 1.0f;
                ++numSamplePoints;
            }
        }
        i = 0;
        while (i < NUM_BINS) {
            int n = i++;
            cumDist[n] = cumDist[n] / (float)numSamplePoints;
        }
        float cumCount = 0.0f;
        int bin = 0;
        while (cumCount < p) {
            cumCount += cumDist[bin];
            ++bin;
        }
        return ((float)bin - 0.5f) / (float)NUM_BINS * (max - min) + min;
    }

    private float[] getMinAndMax(float[][] A, int dim) {
        float[] minAndMax = new float[2];
        float maxDist = Float.NEGATIVE_INFINITY;
        float minDist = Float.POSITIVE_INFINITY;
        for (int i = 0; i < dim - 1; ++i) {
            for (int j = 0; j < i; ++j) {
                float currDist = A[i][j];
                if (currDist > maxDist) {
                    maxDist = currDist;
                }
                if (!(currDist < minDist)) continue;
                minDist = currDist;
            }
        }
        minAndMax[0] = minDist;
        minAndMax[1] = maxDist;
        return minAndMax;
    }

    private FloatMatrix randomizeMatrix(FloatMatrix origMatrix) {
        FloatMatrix shuffleMatrix = origMatrix.copy();
        int rows = shuffleMatrix.getRowDimension();
        int cols = shuffleMatrix.getColumnDimension();
        int sampleRange = cols - 1;
        for (int i = 0; i < rows; ++i) {
            for (int j = cols - 1; j > 0; --j) {
                int swapIndex = (int)(Math.random() * (double)j);
                float temp = shuffleMatrix.get(i, j);
                shuffleMatrix.set(i, j, shuffleMatrix.get(i, swapIndex));
                shuffleMatrix.set(i, swapIndex, temp);
                --sampleRange;
            }
        }
        return shuffleMatrix;
    }

    private void calcFullTreeHCL() throws AlgorithmException {
        AlgorithmEvent event = null;
        event = new AlgorithmEvent((Object)this, 1, 1, "Calculate Hierarchical Tree, Clustering Experiments");
        this.fireValueChanged(event);
        event.setIntValue(0);
        event.setId(2);
        this.fireValueChanged(event);
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        int[] probesIndexes = new int[this.numberOfGenes];
        for (int i = 0; i < this.numberOfGenes; ++i) {
            probesIndexes[i] = i;
        }
        int[] featuresIndexes = new int[this.numberOfSamples];
        for (int i = 0; i < this.numberOfSamples; ++i) {
            featuresIndexes[i] = i;
        }
        if (this.stop) {
            throw new AbortException();
        }
        Node node = new Node(featuresIndexes);
        nodeList.addNode(node);
        node.setValues(this.calculateHierarchicalTree(probesIndexes, this.method, false, true));
        event.setIntValue(1);
        this.fireValueChanged(event);
        if (result_cluster != null) {
            this.inData.addCluster("full-tree-sample-HCL", result_cluster);
        }
    }

    private void calculateClusterHCL() throws AlgorithmException {
        AlgorithmEvent event = null;
        event = new AlgorithmEvent((Object)this, 1, this.numberOfClusters, "Calculate Hierarchical Trees SOTA Cluster Members");
        this.fireValueChanged(event);
        event.setIntValue(0);
        event.setId(2);
        this.fireValueChanged(event);
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        NodeList resultList = this.clusters.getNodeList();
        for (int i = 0; i < this.numberOfClusters; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            Node currNode = resultList.getNode(i);
            int[] probeIndexes = currNode.getProbesIndexes();
            Node node = new Node(probeIndexes);
            nodeList.addNode(node);
            node.setValues(this.calculateHierarchicalTree(probeIndexes, this.method, this.calculate_genes, this.calculate_experiments));
            event.setIntValue(i + 1);
            this.fireValueChanged(event);
        }
        if (result_cluster != null) {
            this.inData.addCluster("hcl-result-clusters", result_cluster);
        }
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.sotaGenes ? this.getSubExperiment(this.dataMatrix, features) : this.getSubExperimentReducedCols(this.dataMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    public SOTACell getRoot() {
        return this.root;
    }

    public int getPopulation(SOTACell subRoot) {
        this.utilCounter = 0;
        this.getPop(subRoot);
        return this.utilCounter;
    }

    private void getPop(SOTACell curr) {
        if (curr != null) {
            if (curr.left == null && curr.right == null) {
                ++this.utilCounter;
            }
            this.getPop(curr.left);
            this.getPop(curr.right);
        }
    }

    private void growSOT() {
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.maxNumCycles);
        this.fireValueChanged(event);
        AlgorithmEvent event1 = new AlgorithmEvent((Object)this, 1, this.maxNumCycles, "Growing Tree");
        this.fireValueChanged(event1);
        event1.setIntValue(0);
        event1.setId(2);
        this.fireValueChanged(event1);
        boolean stopGrowing = false;
        if (!this.useClusterVariance && this.mostDiverseCell.cellDiversity < (double)this.endCriteria) {
            stopGrowing = true;
        } else if (this.useClusterVariance && this.mostVariableCell.cellVariance < (double)this.endCriteria) {
            stopGrowing = true;
        }
        this.cycleNum = 0;
        while (this.cycleNum < this.maxNumCycles && !stopGrowing) {
            this.runCycle(this.maxNumEpochs, this.epochCriteria);
            this.setDiversities();
            this.cycleDiversity.add(new Float(this.treeDiversity));
            if (!this.useClusterVariance) {
                if (this.mostDiverseCell.cellDiversity > (double)this.endCriteria && this.cycleNum < this.maxNumCycles - 1) {
                    this.divideCell(this.mostDiverseCell);
                } else {
                    stopGrowing = true;
                }
            } else if (this.mostVariableCell.cellVariance > (double)this.endCriteria && this.cycleNum < this.maxNumCycles - 1) {
                this.divideCell(this.mostVariableCell);
            } else {
                stopGrowing = true;
            }
            event1.setId(2);
            event1.setIntValue(this.cycleNum + 1);
            this.fireValueChanged(event1);
            ++this.cycleNum;
        }
        this.trainLeaves(this.maxNumEpochs, this.epochCriteria);
        this.getResults();
    }

    private void growSOTUnrestricted() {
        boolean stopGrowing = false;
        this.cycleNum = 0;
        while (this.cycleNum < this.maxNumCycles && !stopGrowing) {
            this.runCycle(this.maxNumEpochs, this.epochCriteria);
            this.setDiversities();
            this.cycleDiversity.add(new Float(this.treeDiversity));
            if (this.cycleNum < this.maxNumCycles - 1) {
                this.divideCell(this.mostDiverseCell);
            } else {
                stopGrowing = true;
            }
            ++this.cycleNum;
        }
        this.trainLeaves(this.maxNumEpochs, this.epochCriteria);
        this.getResults();
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    private int[] getGenesPerCluster() {
        SOTACell curr = this.head;
        int numCells = 0;
        int i = 0;
        while (curr != null) {
            ++numCells;
            curr = curr.succ;
        }
        int[] genesPerCluster = new int[numCells];
        curr = this.head;
        while (curr != null) {
            genesPerCluster[i] = curr.members.size();
            ++i;
            curr = curr.succ;
        }
        return genesPerCluster;
    }

    public int getFunction() {
        return this.function;
    }

    public boolean getAbsolute() {
        return this.absolute;
    }

    public float getFactor() {
        return this.myFactor;
    }

    private void runCycle(int maxNumEpochs, double epochCriteria) {
        boolean negCounter = false;
        double lastError = Double.POSITIVE_INFINITY;
        double currError = Double.POSITIVE_INFINITY;
        double initialDiversity = this.treeDiversity;
        double diversityImprovement = Double.POSITIVE_INFINITY;
        SOTACell trainingNode = !this.useClusterVariance ? this.mostDiverseCell : this.mostVariableCell;
        boolean stopEpoch = false;
        for (int epochNum = 0; epochNum < maxNumEpochs && !stopEpoch; ++epochNum) {
            initialDiversity = this.treeDiversity;
            Dimension distribCount = this.runNodeEpoch(trainingNode);
            lastError = currError;
            currError = this.getInputError(trainingNode);
            diversityImprovement = lastError != 0.0 ? Math.abs((currError - lastError) / lastError) : 0.0;
            if (!(diversityImprovement < epochCriteria) || !(diversityImprovement >= 0.0) || distribCount.getHeight() == 0.0 || distribCount.getWidth() == 0.0) continue;
            stopEpoch = true;
        }
        this.assignGenesToCells(trainingNode);
    }

    private void assignGenesToCells(SOTACell trainingNode) {
        int n = trainingNode.members.size();
        SOTACell myCell = null;
        for (int i = 0; i < n; ++i) {
            int geneIndex = (Integer)trainingNode.members.elementAt(i);
            myCell = this.findMyCellInSubTree(trainingNode, geneIndex, this.neighborhoodLevel);
        }
    }

    private void getResults() {
        SOTACell curr = this.head;
        int numCells = 0;
        FloatMatrix centroidFM = new FloatMatrix(this.numberOfClusters, this.numberOfSamples);
        FloatMatrix varianceFM = new FloatMatrix(this.numberOfClusters, this.numberOfSamples);
        int[] clusterSize = new int[this.numberOfClusters];
        FloatMatrix clusterDiversity = new FloatMatrix(this.numberOfClusters, 1);
        int numDiv = this.cycleDiversity.size();
        FloatMatrix cycleDivFM = new FloatMatrix(numDiv, 1);
        int[] clusterOrder = new int[this.numberOfClusters];
        this.clusters = new Cluster();
        NodeList nodeList = this.clusters.getNodeList();
        while (curr.succ != null) {
            curr = curr.succ;
        }
        while (numCells <= this.numberOfClusters && curr != null) {
            int clusterPop;
            int i;
            for (i = 0; i < this.numberOfSamples; ++i) {
                centroidFM.set(numCells, i, curr.centroidGene.get(0, i));
                varianceFM.set(numCells, i, curr.getColumnVar(i));
            }
            clusterSize[numCells] = clusterPop = curr.members.size();
            clusterDiversity.set(numCells, 0, (float)curr.cellDiversity * this.myFactor);
            clusterOrder[numCells] = numCells;
            int[] clusterMembership = new int[clusterPop];
            for (i = 0; i < clusterPop; ++i) {
                clusterMembership[i] = (Integer)curr.members.elementAt(i);
            }
            Node newNode = new Node();
            newNode.setProbesIndexes(clusterMembership);
            nodeList.addNode(newNode);
            ++numCells;
            curr = curr.pred;
        }
        if (this.myFactor == 1.0f) {
            float initDiv = ((Float)this.cycleDiversity.elementAt(0)).floatValue();
            for (int i = 0; i < numDiv; ++i) {
                cycleDivFM.set(i, 0, ((Float)this.cycleDiversity.elementAt(i)).floatValue() / initDiv);
            }
        } else {
            float lowerLim = (float)this.numberOfGenes * this.myFactor;
            float initDiv = ((Float)this.cycleDiversity.elementAt(0)).floatValue() + Math.abs(lowerLim);
            for (int i = 0; i < numDiv; ++i) {
                cycleDivFM.set(i, 0, (((Float)this.cycleDiversity.elementAt(i)).floatValue() + Math.abs(lowerLim)) / initDiv);
            }
        }
        this.inData.addParam("cycles", String.valueOf(this.numberOfClusters));
        this.inData.addCluster("cluster", this.clusters);
        this.inData.addMatrix("centroid-matrix", centroidFM);
        this.inData.addMatrix("cluster-variances", varianceFM);
        this.inData.addMatrix("cluster-diversity", clusterDiversity);
        this.inData.addMatrix("cycle-diversity", cycleDivFM);
        this.inData.addIntArray("cluster-population", clusterSize);
        float[] nodeHeight = new float[this.numberOfClusters * 2];
        int[] nodePopulation = new int[this.numberOfClusters * 2];
        int[] leftChild = new int[nodeHeight.length * 2];
        int[] rightChild = new int[nodeHeight.length * 2];
        this.initializeReturnValues(nodeHeight, nodePopulation, leftChild, rightChild);
        this.utilCounter = 0;
        this.loadReturnValues(this.root, 0, nodeHeight, nodePopulation, leftChild, rightChild);
        this.inData.addMatrix("node-heights", new FloatMatrix(nodeHeight, nodeHeight.length));
        this.inData.addIntArray("left-child", leftChild);
        this.inData.addIntArray("right-child", rightChild);
        this.inData.addIntArray("node-population", nodePopulation);
        if (this.useClusterVariance) {
            this.inData.addParam("computed-var-cutoff", String.valueOf(this.endCriteria));
        }
    }

    private void initializeReturnValues(float[] height, int[] pop, int[] left, int[] right) {
        for (int i = 0; i < height.length; ++i) {
            height[i] = -1.0f;
            right[i] = -1;
            left[i] = -1;
            pop[i] = -1;
        }
        for (int j = i; j < left.length; ++j) {
            right[j] = -1;
            left[j] = -1;
        }
    }

    private void loadReturnValues(SOTACell subRoot, int index, float[] h, int[] pop, int[] left, int[] right) {
        pop[index] = subRoot.members.size();
        h[index] = subRoot == this.root ? 0.0f : ExperimentUtil.geneDistance(subRoot.centroidGene, subRoot.parent.centroidGene, 0, 0, this.function, this.factor, this.absolute);
        if (subRoot.left != null) {
            left[index] = this.utilCounter + 1;
            ++this.utilCounter;
            this.loadReturnValues(subRoot.left, this.utilCounter, h, pop, left, right);
            right[index] = this.utilCounter + 1;
            ++this.utilCounter;
            this.loadReturnValues(subRoot.right, this.utilCounter, h, pop, left, right);
        }
    }

    private double getInputError(SOTACell parentNode) {
        int n = parentNode.members.size();
        double cumErr = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            int geneIndex = (Integer)parentNode.members.elementAt(i);
            double d1 = ExperimentUtil.geneDistance(this.dataMatrix, parentNode.left.centroidGene, geneIndex, 0, this.function, this.factor, this.absolute);
            if (d1 <= (d2 = (double)ExperimentUtil.geneDistance(this.dataMatrix, parentNode.right.centroidGene, geneIndex, 0, this.function, this.factor, this.absolute))) {
                cumErr += d1;
                continue;
            }
            cumErr += d2;
        }
        return cumErr / (double)n;
    }

    private Dimension runNodeEpoch(SOTACell trainingNode) {
        SOTACell myCell = null;
        SOTACell sisterCell = null;
        int rightCnt = 0;
        int leftCnt = 0;
        int memberGene = 0;
        for (int geneNum = 0; geneNum < trainingNode.members.size(); ++geneNum) {
            memberGene = (Integer)trainingNode.members.elementAt(geneNum);
            myCell = this.findMyDaughterCell(trainingNode, memberGene);
            if (myCell == trainingNode.left) {
                ++leftCnt;
            } else {
                ++rightCnt;
            }
            myCell.migrateCentroid(memberGene, this.migW);
            sisterCell = this.findSister(myCell);
            if (sisterCell.left != null || sisterCell.right != null) continue;
            myCell.parent.migrateCentroid(memberGene, this.migP);
            sisterCell.migrateCentroid(memberGene, this.migS);
        }
        return new Dimension(leftCnt, rightCnt);
    }

    private SOTACell findMyDaughterCell(SOTACell parentNode, int geneIndex) {
        float dist2;
        float dist1 = ExperimentUtil.geneDistance(this.dataMatrix, parentNode.left.centroidGene, geneIndex, 0, this.function, this.factor, this.absolute);
        if (dist1 <= (dist2 = ExperimentUtil.geneDistance(this.dataMatrix, parentNode.right.centroidGene, geneIndex, 0, this.function, this.factor, this.absolute))) {
            return parentNode.left;
        }
        return parentNode.right;
    }

    private void setDiversities() {
        SOTACell curr = this.head;
        double cellSum = 0.0;
        double cellVar = 0.0;
        double treeSum = 0.0;
        double maxCellDiv = -1.0;
        double maxCellVar = -1.0;
        int numberOfCells = 0;
        double currDist = 0.0;
        this.mostDiverseCell = this.head;
        this.mostVariableCell = this.head;
        while (curr != null) {
            int i;
            ++numberOfCells;
            cellSum = 0.0;
            for (i = 0; i < curr.members.size(); ++i) {
                cellSum += (double)ExperimentUtil.geneDistance(this.dataMatrix, curr.centroidGene, (Integer)curr.members.elementAt(i), 0, this.function, this.factor, this.absolute);
            }
            curr.cellDiversity = cellSum / (double)curr.members.size();
            if (curr.cellDiversity > maxCellDiv && curr.members.size() > 1) {
                maxCellDiv = curr.cellDiversity;
                this.mostDiverseCell = curr;
            }
            treeSum += cellSum;
            if (this.useClusterVariance) {
                cellVar = 0.0;
                currDist = 0.0;
                if (curr.changedMembership) {
                    for (i = 0; i < curr.members.size(); ++i) {
                        for (int j = 0; j < curr.members.size(); ++j) {
                            currDist = ExperimentUtil.geneDistance(this.dataMatrix, null, (Integer)curr.members.elementAt(i), (Integer)curr.members.elementAt(j), this.function, this.factor, this.absolute);
                            if (!(currDist > cellVar)) continue;
                            cellVar = currDist;
                        }
                    }
                    curr.cellVariance = cellVar;
                } else {
                    cellVar = curr.cellVariance;
                }
                if (cellVar > maxCellVar && curr.members.size() > 1) {
                    maxCellVar = cellVar;
                    this.mostVariableCell = curr;
                }
            }
            curr.changedMembership = false;
            curr = curr.succ;
        }
        this.treeDiversity = treeSum;
    }

    private float getNodeDiversitySum(SOTACell curr) {
        float div = 0.0f;
        int n = curr.members.size();
        float sum = 0.0f;
        for (int i = 0; i < n; ++i) {
            int geneIndex = (Integer)curr.members.elementAt(i);
            float currDist = ExperimentUtil.geneDistance(this.dataMatrix, curr.centroidGene, geneIndex, 0, this.function, this.factor, this.absolute);
            if (Float.isNaN(currDist)) continue;
            sum += currDist;
        }
        return sum;
    }

    private float getNodeDiversity(SOTACell curr) {
        float div = 0.0f;
        int n = curr.members.size();
        float sum = 0.0f;
        int numGoodRatios = 0;
        for (int i = 0; i < n; ++i) {
            int geneIndex = (Integer)curr.members.elementAt(i);
            float currDist = ExperimentUtil.geneDistance(this.dataMatrix, curr.centroidGene, geneIndex, 0, this.function, this.factor, this.absolute);
            if (Float.isNaN(currDist)) continue;
            sum += currDist;
            ++numGoodRatios;
        }
        return sum / (float)numGoodRatios;
    }

    private float getNodeVariance(SOTACell curr) {
        float div = 0.0f;
        int n = curr.members.size();
        float maxDist = 0.0f;
        boolean numGoodRatios = false;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int geneIndex2;
                int geneIndex1 = (Integer)curr.members.elementAt(i);
                float currDist = ExperimentUtil.geneDistance(this.dataMatrix, null, geneIndex1, geneIndex2 = ((Integer)curr.members.elementAt(j)).intValue(), this.function, this.factor, this.absolute);
                if (Float.isNaN(currDist) || !(currDist > maxDist)) continue;
                maxDist = currDist;
            }
        }
        return maxDist;
    }

    private void trainLeaves(int maxNumEpochs, double epochCriteria) {
        double initialDiversity = this.treeDiversity;
        double diversityImprovement = Double.POSITIVE_INFINITY;
        SOTACell trainingNode = this.head;
        while (trainingNode != null) {
            diversityImprovement = Double.POSITIVE_INFINITY;
            for (int epochNum = 0; epochNum < maxNumEpochs && diversityImprovement > epochCriteria; ++epochNum) {
                initialDiversity = this.getNodeDiversity(trainingNode);
                this.runLeafEpoch(trainingNode);
                diversityImprovement = Math.abs(((double)this.getNodeDiversity(trainingNode) - initialDiversity) / initialDiversity);
            }
            trainingNode = trainingNode.succ;
        }
        this.setDiversities();
    }

    private void runLeafEpoch(SOTACell trainingNode) {
        Object myCell = null;
        Object sisterCell = null;
        int memberGene = 0;
        for (int geneNum = 0; geneNum < trainingNode.members.size(); ++geneNum) {
            memberGene = (Integer)trainingNode.members.elementAt(geneNum);
            this.myNucleus[memberGene].migrateCentroid(memberGene, this.migW);
        }
    }

    private SOTACell findMyCellInSubTree(SOTACell trainingCell, int geneNum, int level) {
        SOTACell currCell = trainingCell;
        SOTACell myCell = trainingCell;
        for (int levelIndex = 0; currCell.parent != null && levelIndex < level; ++levelIndex) {
            currCell = currCell.parent;
        }
        Vector cellList = new Vector();
        this.getCellsBelow(cellList, currCell);
        float minDist = Float.POSITIVE_INFINITY;
        for (int i = 0; i < cellList.size(); ++i) {
            currCell = (SOTACell)cellList.elementAt(i);
            float currDist = ExperimentUtil.geneDistance(this.dataMatrix, currCell.centroidGene, geneNum, 0, this.function, this.factor, this.absolute);
            if (!(currDist < minDist)) continue;
            minDist = currDist;
            myCell = currCell;
        }
        if (this.myNucleus[geneNum] != myCell) {
            this.myNucleus[geneNum] = myCell;
            myCell.addMember(geneNum);
        }
        return myCell;
    }

    private void getCellsBelow(Vector cellList, SOTACell subRoot) {
        if (subRoot == null) {
            return;
        }
        if (subRoot.left == null && subRoot.right == null) {
            cellList.add(subRoot);
        } else {
            this.getCellsBelow(cellList, subRoot.right);
            this.getCellsBelow(cellList, subRoot.left);
        }
    }

    private SOTACell findMyCell(int geneNum) {
        SOTACell curr = this.head;
        SOTACell myClosestCell = this.head;
        double keyDist = Double.POSITIVE_INFINITY;
        double currDist = 0.0;
        while (curr != null) {
            currDist = ExperimentUtil.geneDistance(this.dataMatrix, curr.centroidGene, geneNum, 0, this.function, this.factor, this.absolute);
            if (currDist <= keyDist) {
                keyDist = currDist;
                myClosestCell = curr;
            }
            curr = curr.succ;
        }
        if (this.myNucleus[geneNum] != myClosestCell) {
            this.myNucleus[geneNum] = myClosestCell;
            myClosestCell.addMember(geneNum);
        }
        return myClosestCell;
    }

    private SOTACell findSister(SOTACell curr) {
        if (curr != null) {
            if (curr.parent.left == curr) {
                return curr.parent.right;
            }
            return curr.parent.left;
        }
        return null;
    }

    private void divideCell(SOTACell cellToDivide) {
        cellToDivide.left = new SOTACell(this.numberOfSamples, this.dataMatrix);
        cellToDivide.right = new SOTACell(this.numberOfSamples, this.dataMatrix);
        ++this.numberOfClusters;
        cellToDivide.left.parent = cellToDivide;
        cellToDivide.right.parent = cellToDivide;
        cellToDivide.right.pred = cellToDivide.left;
        cellToDivide.left.succ = cellToDivide.right;
        if (cellToDivide.pred != null) {
            cellToDivide.left.pred = cellToDivide.pred;
            cellToDivide.left.pred.succ = cellToDivide.left;
        } else {
            cellToDivide.left.pred = null;
        }
        if (cellToDivide.succ != null) {
            cellToDivide.right.succ = cellToDivide.succ;
            cellToDivide.right.succ.pred = cellToDivide.right;
        } else {
            cellToDivide.right.succ = null;
        }
        if (cellToDivide == this.head) {
            this.head = cellToDivide.left;
        }
        cellToDivide.succ = null;
        cellToDivide.pred = null;
        for (int i = 0; i < this.numberOfSamples; ++i) {
            cellToDivide.left.centroidGene.set(0, i, cellToDivide.centroidGene.get(0, i));
            cellToDivide.right.centroidGene.set(0, i, cellToDivide.centroidGene.get(0, i));
        }
    }

    public double getMaxLeafToRootPath() {
        SOTACell curr;
        SOTACell traveler = curr = this.head;
        double maxDist = -1.0;
        while (curr != null) {
            traveler = curr;
            double cumDist = 0.0;
            while (traveler != null) {
                if (traveler.parent != null) {
                    cumDist += (double)ExperimentUtil.geneDistance(traveler.parent.centroidGene, traveler.centroidGene, 0, 0, this.function, this.factor, this.absolute);
                }
                traveler = traveler.parent;
            }
            if (cumDist < maxDist) {
                maxDist = cumDist;
            }
            curr = curr.succ;
        }
        return maxDist;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }
}

