/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.ArrayList;
import java.util.Random;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.algorithm.impl.SOMMatrix;
import org.tigr.util.FloatMatrix;

public class SOM
extends AbstractAlgorithm {
    private static final int INDEX_X = 0;
    private static final int INDEX_Y = 1;
    private static final int WINNER_INFO_SIZE = 2;
    private boolean stop = false;
    private int function;
    private int dim_x;
    private int dim_y;
    private float factor;
    private boolean absolute;
    private String topology;
    private boolean somGenes;
    private int number_of_genes;
    private int number_of_samples;
    private FloatMatrix expMatrix;
    private float[][][] somCodes;
    private int validN;
    private int hcl_function;
    private boolean hcl_absolute;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("distance-absolute", false);
        this.somGenes = map.getBoolean("som-cluster-genes", true);
        this.dim_x = map.getInt("dimension-x", 0);
        this.dim_y = map.getInt("dimension-y", 0);
        int iterations = map.getInt("iterations", 0);
        this.topology = map.getString("topology");
        boolean adoptType = this.topology != null ? this.topology.compareTo("rectangular") == 0 : true;
        boolean is_neighborhood_bubble = map.getBoolean("is_neighborhood_bubble", true);
        boolean is_random_vector = map.getBoolean("is_random_vector", true);
        float radius = map.getFloat("radius", 0.0f);
        float alpha = map.getFloat("alpha", 0.0f);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.expMatrix = data.getMatrix("experiment");
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        this.number_of_genes = this.expMatrix.getRowDimension();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        this.somCodes = is_random_vector ? this.randomVectorInit() : this.randomGeneInit();
        int[] winner_info = new int[2];
        float cRadius = radius;
        float cAlpha = alpha;
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, 200, "Training...");
        this.fireValueChanged(event);
        event.setId(2);
        event.setIntValue(0);
        int sample = 0;
        long progress = iterations / 200;
        for (int i = 0; i < iterations; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            if ((long)i % progress == 0L) {
                event.setIntValue(event.getIntValue() + 1);
                this.fireValueChanged(event);
            }
            cRadius = 1.0f + (radius - 1.0f) * (float)(iterations - i) / (float)iterations;
            cAlpha = this.linearAlpha(i, iterations, alpha);
            this.findWinnerEuclidean(winner_info, sample);
            if (is_neighborhood_bubble) {
                this.bubbleAdapt(sample, winner_info, cRadius, cAlpha, adoptType);
            } else {
                this.gaussianAdapt(sample, winner_info, cRadius, cAlpha, adoptType);
            }
            if (++sample < this.number_of_genes) continue;
            sample = 0;
        }
        SOMMatrix clusters = new SOMMatrix(this.dim_x, this.dim_y, 0);
        FloatMatrix u_matrix = new FloatMatrix(this.dim_x, this.dim_y);
        this.calculateClusters(clusters, u_matrix);
        AlgorithmData result = new AlgorithmData();
        FloatMatrix matrix = new FloatMatrix(this.dim_x * this.dim_y, this.number_of_samples);
        for (int i = 0; i < this.number_of_samples; ++i) {
            for (int x = 0; x < this.dim_x; ++x) {
                for (int y = 0; y < this.dim_y; ++y) {
                    matrix.set(x * this.dim_y + y, i, this.somCodes[x][y][i]);
                }
            }
        }
        result.addMatrix("codes", matrix);
        FloatMatrix means = new FloatMatrix(this.dim_x * this.dim_y, this.number_of_samples);
        FloatMatrix variances = new FloatMatrix(this.dim_x * this.dim_y, this.number_of_samples);
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int x = 0; x < this.dim_x; ++x) {
            for (int y = 0; y < this.dim_y; ++y) {
                int[] features = this.getFeatures(clusters.getArrayList(x, y));
                int dimension = x * this.dim_y + y;
                this.fillMean(means.A[dimension], features);
                this.fillVariance(variances.A[dimension], means.A[dimension], features);
                Node node = new Node(features);
                nodeList.addNode(node);
            }
        }
        if (hierarchical_tree) {
            this.calculateHierarchicalTrees(result_cluster, method_linkage, calculate_genes, calculate_experiments);
        }
        result.addCluster("cluster", result_cluster);
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        result.addMatrix("u_matrix", u_matrix);
        return result;
    }

    private void calculateHierarchicalTrees(Cluster cluster, int method, boolean genes, boolean experiments) throws AlgorithmException {
        NodeList nodeList = cluster.getNodeList();
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, nodeList.getSize(), "Calculate Hierarchical Trees");
        this.fireValueChanged(event);
        event.setId(2);
        for (int i = 0; i < nodeList.getSize(); ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            event.setIntValue(i);
            this.fireValueChanged(event);
            Node node = nodeList.getNode(i);
            node.setValues(this.calculateHierarchicalTree(node.getFeaturesIndexes(), method, genes, experiments));
        }
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.somGenes ? this.getSubExperiment(this.expMatrix, features) : this.getSubExperimentReducedCols(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    public void abort() {
        this.stop = true;
    }

    private int[] getFeatures(ArrayList source) {
        int[] cluster = new int[source.size()];
        for (int i = 0; i < cluster.length; ++i) {
            cluster[i] = ((Float)source.get(i)).intValue();
        }
        return cluster;
    }

    private float[][][] randomGeneInit() {
        Random random = new Random(System.currentTimeMillis());
        float[][][] somCodes = new float[this.dim_x][this.dim_y][this.number_of_samples];
        for (int y = 0; y < this.dim_y; ++y) {
            for (int x = 0; x < this.dim_x; ++x) {
                int gene = (int)(random.nextFloat() * (float)this.number_of_genes);
                for (int k = 0; k < this.number_of_samples; ++k) {
                    somCodes[x][y][k] = this.expMatrix.get(gene, k);
                }
            }
        }
        return somCodes;
    }

    private float[][][] randomVectorInit() {
        int j;
        int i;
        float[][][] somCodes = new float[this.dim_x][this.dim_y][this.number_of_samples];
        float[] maxValue = new float[this.number_of_samples];
        float[] minValue = new float[this.number_of_samples];
        for (i = 0; i < this.number_of_samples; ++i) {
            minValue[i] = Float.MAX_VALUE;
            maxValue[i] = Float.MIN_VALUE;
        }
        for (i = 0; i < this.number_of_genes; ++i) {
            for (j = 0; j < this.number_of_samples; ++j) {
                float dummy = this.expMatrix.get(i, j);
                if (Float.isNaN(dummy)) continue;
                if (maxValue[j] < dummy) {
                    maxValue[j] = dummy;
                }
                if (!(minValue[j] > dummy)) continue;
                minValue[j] = dummy;
            }
        }
        Random random = new Random(System.currentTimeMillis());
        for (i = 0; i < this.dim_x; ++i) {
            for (j = 0; j < this.dim_y; ++j) {
                for (int k = 0; k < this.number_of_samples; ++k) {
                    float value;
                    somCodes[i][j][k] = value = minValue[k] + (maxValue[k] - minValue[k]) * random.nextFloat();
                }
            }
        }
        return somCodes;
    }

    private final float findWinnerEuclidean(int[] winner_info, int sample) {
        winner_info[0] = -1;
        winner_info[1] = -1;
        float winner_distance = -1.0f;
        if (this.number_of_samples == 1) {
            return winner_distance;
        }
        double diffsf = Double.MAX_VALUE;
        FloatMatrix dummyMatrix = new FloatMatrix(1, this.number_of_samples);
        for (int y = 0; y < this.dim_y; ++y) {
            for (int x = 0; x < this.dim_x; ++x) {
                for (int i = 0; i < this.number_of_samples; ++i) {
                    dummyMatrix.set(0, i, this.somCodes[x][y][i]);
                }
                double difference = ExperimentUtil.geneDistance(this.expMatrix, dummyMatrix, sample, 0, this.function, this.factor, this.absolute);
                if (!(difference <= diffsf)) continue;
                winner_info[0] = x;
                winner_info[1] = y;
                diffsf = difference;
                winner_distance = (float)difference;
            }
        }
        return winner_distance;
    }

    private void bubbleAdapt(int sample, int[] winner_info, float radius, float alpha, boolean rectangular) {
        long index = 0L;
        for (int y = 0; y < this.dim_y; ++y) {
            for (int x = 0; x < this.dim_x; ++x) {
                if (rectangular) {
                    if (!(this.rectangularDistance(winner_info, x, y) <= radius)) continue;
                    this.adaptVector(sample, x, y, alpha);
                    continue;
                }
                if (!(this.hexagonalDistance(winner_info, x, y) <= radius)) continue;
                this.adaptVector(sample, x, y, alpha);
            }
        }
    }

    private void gaussianAdapt(int sample, int[] winner_info, float radius, float alpha, boolean rectangular) {
        long index = 0L;
        for (int y = 0; y < this.dim_y; ++y) {
            for (int x = 0; x < this.dim_x; ++x) {
                float dd = rectangular ? this.rectangularDistance(winner_info, x, y) : this.hexagonalDistance(winner_info, x, y);
                float alp = alpha * (float)Math.exp((float)((double)(-dd * dd) / (2.0 * (double)radius * (double)radius)));
                this.adaptVector(sample, x, y, alp);
            }
        }
    }

    private float rectangularDistance(int[] winner_info, int tx, int ty) {
        float diff = winner_info[0] - tx;
        float ret = diff * diff;
        diff = winner_info[1] - ty;
        ret += diff * diff;
        ret = (float)Math.sqrt(ret);
        return ret;
    }

    private float hexagonalDistance(int[] winner_info, int tx, int ty) {
        float diff = winner_info[0] - tx;
        if ((winner_info[1] - ty) % 2 != 0) {
            diff = winner_info[1] % 2 == 0 ? (float)((double)diff - 0.5) : (float)((double)diff + 0.5);
        }
        float ret = diff * diff;
        diff = winner_info[1] - ty;
        ret = (float)((double)ret + 0.75 * (double)diff * (double)diff);
        ret = (float)Math.sqrt(ret);
        return ret;
    }

    private void adaptVector(int sample, int x, int y, float alpha) {
        for (int i = 0; i < this.number_of_samples; ++i) {
            if (Float.isNaN(this.expMatrix.get(sample, i))) continue;
            this.somCodes[x][y][i] = this.somCodes[x][y][i] + alpha * (this.expMatrix.get(sample, i) - this.somCodes[x][y][i]);
        }
    }

    private float linearAlpha(long currentIteration, long iterations, float alpha) {
        return alpha * (float)(iterations - currentIteration) / (float)iterations;
    }

    private void calculateClusters(SOMMatrix clusters, FloatMatrix u_matrix) throws AlgorithmException {
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.number_of_genes, "Creation of the clusters...");
        this.fireValueChanged(event);
        event.setId(2);
        SOMMatrix distances = new SOMMatrix(this.dim_x, this.dim_y, 0);
        for (int y = 0; y < this.dim_y; ++y) {
            for (int x = 0; x < this.dim_x; ++x) {
                u_matrix.set(x, y, 0.0f);
            }
        }
        float max_winner_distance = 0.0f;
        int[] winner_info = new int[2];
        for (int i = 0; i < this.number_of_genes; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            float winner_distance = this.findWinnerEuclidean(winner_info, i);
            if (winner_info[0] != -1 && winner_info[1] != -1) {
                max_winner_distance = Math.max(winner_distance, max_winner_distance);
                if (winner_distance > u_matrix.get(winner_info[0], winner_info[1])) {
                    u_matrix.set(winner_info[0], winner_info[1], winner_distance);
                }
                int counter = 0;
                for (int j = 0; j < distances.getDimension(winner_info[0], winner_info[1]) && !(winner_distance < distances.getValue(winner_info[0], winner_info[1], j)); ++j) {
                    ++counter;
                }
                distances.insertValue(winner_info[0], winner_info[1], counter, winner_distance);
                clusters.insertValue(winner_info[0], winner_info[1], counter, i);
            }
            event.setIntValue(i);
            this.fireValueChanged(event);
        }
        for (int y = 0; y < this.dim_y; ++y) {
            for (int x = 0; x < this.dim_x; ++x) {
                u_matrix.set(x, y, u_matrix.get(x, y) / max_winner_distance);
            }
        }
    }

    private void fillMean(float[] means, int[] cluster) {
        int n = cluster.length;
        this.validN = 0;
        for (int i = 0; i < this.number_of_samples; ++i) {
            float currentMean = 0.0f;
            this.validN = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(cluster[j], i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++this.validN;
            }
            means[i] = currentMean / (float)this.validN;
        }
    }

    private void fillVariance(float[] variances, float[] means, int[] cluster) {
        for (int i = 0; i < this.number_of_samples; ++i) {
            variances[i] = this.getSampleVariance(cluster, i, means[i]);
        }
    }

    private float getSampleNormalizedSum(int[] cluster, int column, float mean) {
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < cluster.length; ++i) {
            float value = this.expMatrix.get(cluster[i], column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float getSampleVariance(int[] cluster, int column, float mean) {
        if (this.validN > 1) {
            return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
        }
        return 0.0f;
    }
}

