/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.Rengine;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMGUI;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMGraph;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMState;
import org.tigr.rhook.RHook;
import org.tigr.util.Combinations;
import org.tigr.util.FloatMatrix;
import org.tigr.util.Permutations;
import org.tigr.util.QSort;

public class SAM
extends AbstractAlgorithm {
    private boolean stop = false;
    private float factor;
    float noNaNs = 1.0E-9f;
    private double sNought = 0.0;
    private int numMultiClassGroups = 0;
    private Vector<Integer>[] clusters;
    private int k;
    private int numGenes;
    private int numExps;
    private int numCombs;
    private int numUniquePerms;
    private int studyDesign;
    private int numNeighbors;
    private int hcl_function;
    private double s0Percentile;
    private double oneClassMean;
    private double delta;
    private double pi0Hat;
    private double userPercentile;
    private boolean hcl_absolute;
    private boolean useRSAM;
    private boolean useTusherEtAlS0;
    private boolean calculateQLowestFDR;
    private boolean useAllUniquePerms;
    private boolean isTimeCourse;
    private boolean useKNearest;
    private boolean drawSigTreesOnly;
    private long[] randomSeeds;
    private boolean[] inSurvivalAnalysis;
    private boolean[] isCensored;
    private float[] timeCourseData;
    private double[] dArray;
    private double[] rArray;
    private double[] sortedDArray;
    private double[] dBarValues;
    private double[] survivalTimes;
    private double[] zkArray;
    private double[] globalAllSValues;
    private double[] globalAllQValues;
    private double[] globalSortedAllSValues;
    private double[] medNumFalselyCalledGenesByDelta;
    private double[] ninetiethPercentileFalselyCalledGenesByDelta;
    private double[] FDRmedian;
    private double[] FDR90thPercentile;
    private double[] qLowestFDR;
    private double[] deltaGrid;
    private int[] dkArray;
    private int[] groupAssignments;
    private int[] pairedGroupAExpts;
    private int[] pairedGroupBExpts;
    private int[] sortedDArrayIndices;
    private int[] numSigGenesByDelta;
    private String[] geneNames;
    private String[] sampleNames;
    private String[] startOrEnd;
    private int[][] rkArray;
    private FloatMatrix expMatrix;
    private FloatMatrix imputedMatrix;
    private FloatMatrix medNumFalseMatrix;
    int validN;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        int i2;
        int i3;
        this.groupAssignments = data.getIntArray("group-assignments");
        FloatMatrix tcData = data.getMatrix("time-course-data");
        this.timeCourseData = new float[tcData.getColumnDimension()];
        for (int i4 = 0; i4 < tcData.getColumnDimension(); ++i4) {
            this.timeCourseData[i4] = tcData.A[0][i4];
        }
        int[] startOrEndInt = data.getIntArray("start-or-end");
        if (this.startOrEnd != null) {
            this.startOrEnd = new String[startOrEndInt.length];
            for (int i5 = 0; i5 < startOrEndInt.length; ++i5) {
                if (startOrEndInt[i5] == 0) {
                    this.startOrEnd[i5] = "";
                    continue;
                }
                if (startOrEndInt[i5] == 1) {
                    this.startOrEnd[i5] = "Start";
                    continue;
                }
                if (startOrEndInt[i5] != 2) continue;
                this.startOrEnd[i5] = "End";
            }
        }
        AlgorithmParameters map = data.getParams();
        this.useRSAM = map.getBoolean("use-r-sam", true);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.isTimeCourse = map.getBoolean("is-time-course", false);
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        if (hierarchical_tree) {
            this.drawSigTreesOnly = map.getBoolean("draw-sig-trees-only");
        }
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        boolean usePreviousGraph = map.getBoolean("use-previous-graph", false);
        this.userPercentile = map.getFloat("userPercentile", 0.0f);
        this.useTusherEtAlS0 = map.getBoolean("useTusherEtAlS0", false);
        this.calculateQLowestFDR = map.getBoolean("calculateQLowestFDR", false);
        this.useAllUniquePerms = map.getBoolean("useAllUniquePerms", false);
        this.numUniquePerms = map.getInt("numUniquePerms", 0);
        this.expMatrix = data.getMatrix("experiment");
        this.geneNames = data.getStringArray("geneLabels");
        this.sampleNames = data.getStringArray("sampleLabels");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.inSurvivalAnalysis = new boolean[this.numExps];
        this.isCensored = new boolean[this.numExps];
        this.survivalTimes = new double[this.numExps];
        this.studyDesign = map.getInt("study-design", 4);
        if (this.studyDesign == 5) {
            FloatMatrix pairedAExptsMatrix = data.getMatrix("pairedAExptsMatrix");
            FloatMatrix pairedBExptsMatrix = data.getMatrix("pairedBExptsMatrix");
            this.pairedGroupAExpts = new int[pairedAExptsMatrix.getRowDimension()];
            this.pairedGroupBExpts = new int[pairedBExptsMatrix.getRowDimension()];
            for (int i6 = 0; i6 < pairedAExptsMatrix.getRowDimension(); ++i6) {
                this.pairedGroupAExpts[i6] = (int)pairedAExptsMatrix.A[i6][0];
                this.pairedGroupBExpts[i6] = (int)pairedBExptsMatrix.A[i6][0];
            }
        }
        if (this.studyDesign == 6) {
            this.numMultiClassGroups = map.getInt("numMultiClassGroups", 0);
        }
        if (this.studyDesign == 8) {
            this.oneClassMean = map.getFloat("oneClassMean", 0.0f);
        }
        if (this.studyDesign == 7) {
            FloatMatrix inAnalysisMatrix = data.getMatrix("inAnalysisMatrix");
            FloatMatrix isCensoredMatrix = data.getMatrix("isCensoredMatrix");
            FloatMatrix survivalTimesMatrix = data.getMatrix("survivalTimesMatrix");
            for (int i7 = 0; i7 < inAnalysisMatrix.getRowDimension(); ++i7) {
                this.inSurvivalAnalysis[i7] = inAnalysisMatrix.A[i7][0] != 0.0f;
                this.isCensored[i7] = isCensoredMatrix.A[i7][0] != 0.0f;
                this.survivalTimes[i7] = survivalTimesMatrix.A[i7][0];
            }
        }
        this.numCombs = map.getInt("num-combs", 100);
        if (this.useAllUniquePerms) {
            this.numCombs = this.numUniquePerms;
        }
        this.useKNearest = map.getBoolean("use-k-nearest", true);
        this.numNeighbors = map.getInt("num-neighbors", 10);
        this.pi0Hat = 0.0;
        this.delta = 0.0;
        this.deltaGrid = new double[1001];
        this.numSigGenesByDelta = new int[this.deltaGrid.length];
        this.sortedDArrayIndices = new int[this.deltaGrid.length];
        this.medNumFalselyCalledGenesByDelta = new double[this.deltaGrid.length];
        this.ninetiethPercentileFalselyCalledGenesByDelta = new double[this.deltaGrid.length];
        this.FDRmedian = new double[this.deltaGrid.length];
        this.FDR90thPercentile = new double[this.deltaGrid.length];
        this.qLowestFDR = new double[1];
        if (!usePreviousGraph && !this.useRSAM) {
            int i8;
            int i9;
            int i10;
            SAMState.useRSAM = this.useRSAM;
            this.imputedMatrix = new FloatMatrix(this.numGenes, this.numExps);
            this.imputedMatrix = this.useKNearest ? this.imputeKNearestMatrix(this.expMatrix, this.numNeighbors) : this.imputeRowAverageMatrix(this.expMatrix);
            SAMState.imputedMatrix = this.imputedMatrix;
            this.zkArray = new double[1];
            this.rkArray = new int[1][];
            this.dkArray = new int[1];
            if (this.studyDesign == 7) {
                this.zkArray = this.getZkArray();
                this.rkArray = this.getRkArray();
                this.dkArray = this.getDkArray();
            }
            this.globalAllSValues = this.getAllSValues();
            QSort sortSValues = new QSort(this.globalAllSValues);
            this.globalSortedAllSValues = sortSValues.getSortedDouble();
            if (this.useTusherEtAlS0) {
                this.globalAllQValues = this.getQValues();
                SAMState.sNought = this.sNought = this.getSNought();
                SAMState.s0Percentile = this.s0Percentile;
            } else {
                SAMState.sNought = this.sNought = this.getSAlpha(this.userPercentile);
                this.s0Percentile = this.userPercentile;
                SAMState.s0Percentile = this.userPercentile;
            }
            this.dArray = new double[this.numGenes];
            this.rArray = new double[this.numGenes];
            for (int i11 = 0; i11 < this.dArray.length; ++i11) {
                this.dArray[i11] = this.getD(i11, this.imputedMatrix);
                this.rArray[i11] = this.getR(i11, this.imputedMatrix);
            }
            SAMState.dArray = this.dArray;
            SAMState.rArray = this.rArray;
            QSort sortDArray = new QSort(this.dArray);
            this.sortedDArray = sortDArray.getSortedDouble();
            SAMState.sortedDArray = this.sortedDArray;
            this.sortedDArrayIndices = sortDArray.getOrigIndx();
            SAMState.sortedDArrayIndices = this.sortedDArrayIndices;
            double[][] permutedDValues = new double[this.numCombs][this.numGenes];
            AlgorithmEvent event2 = new AlgorithmEvent((Object)this, 1, this.numCombs);
            if (this.useAllUniquePerms) {
                event2 = new AlgorithmEvent((Object)this, 1, this.numUniquePerms);
            }
            this.fireValueChanged(event2);
            event2.setId(2);
            Random rand = new Random();
            this.randomSeeds = new long[this.numCombs];
            for (i10 = 0; i10 < this.numCombs; ++i10) {
                this.randomSeeds[i10] = rand.nextLong();
            }
            if (!this.useAllUniquePerms) {
                for (i10 = 0; i10 < this.numCombs; ++i10) {
                    int j;
                    int[] validArray;
                    Vector<Integer> validExpts;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(i10);
                    event2.setDescription("Permuting matrix: Current permutation = " + (i10 + 1));
                    this.fireValueChanged(event2);
                    int[] permutedExpts = new int[1];
                    boolean[] changeSign = new boolean[1];
                    if (this.studyDesign == 4 || this.studyDesign == 6 || this.studyDesign == 7) {
                        validExpts = new Vector<Integer>();
                        if (this.studyDesign == 4) {
                            for (int j2 = 0; j2 < this.groupAssignments.length; ++j2) {
                                if (this.groupAssignments[j2] == 0) continue;
                                validExpts.add(new Integer(j2));
                            }
                        } else if (this.studyDesign == 6) {
                            for (int j3 = 0; j3 < this.groupAssignments.length; ++j3) {
                                if (this.groupAssignments[j3] == 0) continue;
                                validExpts.add(new Integer(j3));
                            }
                        } else if (this.studyDesign == 7) {
                            for (int j4 = 0; j4 < this.inSurvivalAnalysis.length; ++j4) {
                                if (!this.inSurvivalAnalysis[j4]) continue;
                                validExpts.add(new Integer(j4));
                            }
                        }
                        validArray = new int[validExpts.size()];
                        for (j = 0; j < validArray.length; ++j) {
                            validArray[j] = (Integer)validExpts.get(j);
                        }
                        permutedExpts = this.getPermutedValues(this.numExps, validArray);
                    } else if (this.studyDesign == 5) {
                        permutedExpts = this.permuteWithinPairs(this.randomSeeds[i10]);
                    } else if (this.studyDesign == 8) {
                        validExpts = new Vector();
                        for (int j5 = 0; j5 < this.groupAssignments.length; ++j5) {
                            if (this.groupAssignments[j5] != 1) continue;
                            validExpts.add(new Integer(j5));
                        }
                        validArray = new int[validExpts.size()];
                        for (int j6 = 0; j6 < validArray.length; ++j6) {
                            validArray[j6] = (Integer)validExpts.get(j6);
                        }
                        changeSign = this.getOneClassChangeSignArray(this.randomSeeds[i10], validArray);
                    }
                    FloatMatrix permutedMatrix = this.studyDesign == 8 ? this.getOneClassPermMatrix(this.imputedMatrix, changeSign) : this.getPermutedMatrix(this.imputedMatrix, permutedExpts);
                    double[] permDArray = new double[permutedMatrix.getRowDimension()];
                    for (j = 0; j < permutedMatrix.getRowDimension(); ++j) {
                        permDArray[j] = this.getD(j, permutedMatrix);
                    }
                    QSort sortPermDArray = new QSort(permDArray);
                    double[] sortedPermDArray = sortPermDArray.getSortedDouble();
                    for (int j7 = 0; j7 < sortedPermDArray.length; ++j7) {
                        permutedDValues[i10][j7] = sortedPermDArray[j7];
                    }
                }
            } else {
                int i12;
                int[] permutedExpts = new int[this.numExps];
                for (i12 = 0; i12 < this.numExps; ++i12) {
                    permutedExpts[i12] = i12;
                }
                if (this.studyDesign == 4) {
                    Vector<Integer> usedExptsVector = new Vector<Integer>();
                    int numGroupAValues = 0;
                    for (int i13 = 0; i13 < this.groupAssignments.length; ++i13) {
                        if (this.groupAssignments[i13] != 0) {
                            usedExptsVector.add(new Integer(i13));
                        }
                        if (this.groupAssignments[i13] != 1) continue;
                        ++numGroupAValues;
                    }
                    int[] usedExptsArray = new int[usedExptsVector.size()];
                    for (int i14 = 0; i14 < usedExptsArray.length; ++i14) {
                        usedExptsArray[i14] = (Integer)usedExptsVector.get(i14);
                    }
                    int[] combArray = new int[numGroupAValues];
                    for (int i15 = 0; i15 < combArray.length; ++i15) {
                        combArray[i15] = -1;
                    }
                    int numGroupBValues = usedExptsArray.length - numGroupAValues;
                    int permCounter = 0;
                    while (Combinations.enumerateCombinations((int)usedExptsArray.length, (int)numGroupAValues, (int[])combArray)) {
                        int i16;
                        if (this.stop) {
                            throw new AbortException();
                        }
                        event2.setIntValue(permCounter);
                        event2.setDescription("Permuting matrix: Current permutation = " + (permCounter + 1));
                        this.fireValueChanged(event2);
                        int[] notInCombArray = new int[numGroupBValues];
                        int notCombCounter = 0;
                        for (i16 = 0; i16 < usedExptsArray.length; ++i16) {
                            if (this.belongsInArray(i16, combArray)) continue;
                            notInCombArray[notCombCounter] = i16;
                            ++notCombCounter;
                        }
                        for (i16 = 0; i16 < combArray.length; ++i16) {
                            permutedExpts[usedExptsArray[i16]] = usedExptsArray[combArray[i16]];
                        }
                        for (i16 = 0; i16 < notInCombArray.length; ++i16) {
                            permutedExpts[usedExptsArray[combArray.length + i16]] = usedExptsArray[notInCombArray[i16]];
                        }
                        FloatMatrix permutedMatrix = this.getPermutedMatrix(this.imputedMatrix, permutedExpts);
                        double[] permDArray = new double[permutedMatrix.getRowDimension()];
                        for (int j = 0; j < permutedMatrix.getRowDimension(); ++j) {
                            permDArray[j] = this.getD(j, permutedMatrix);
                        }
                        QSort sortPermDArray = new QSort(permDArray);
                        double[] sortedPermDArray = sortPermDArray.getSortedDouble();
                        for (int j = 0; j < sortedPermDArray.length; ++j) {
                            permutedDValues[permCounter][j] = sortedPermDArray[j];
                        }
                        ++permCounter;
                    }
                } else if (this.studyDesign == 5) {
                    for (i12 = 0; i12 < this.numUniquePerms; ++i12) {
                        if (this.stop) {
                            throw new AbortException();
                        }
                        event2.setIntValue(i12);
                        event2.setDescription("Permuting matrix: Current permutation = " + (i12 + 1));
                        this.fireValueChanged(event2);
                        permutedExpts = this.permuteWithinPairsAllPerms(i12);
                        FloatMatrix permutedMatrix = this.getPermutedMatrix(this.imputedMatrix, permutedExpts);
                        double[] permDArray = new double[permutedMatrix.getRowDimension()];
                        for (int j = 0; j < permutedMatrix.getRowDimension(); ++j) {
                            permDArray[j] = this.getD(j, permutedMatrix);
                        }
                        QSort sortPermDArray = new QSort(permDArray);
                        double[] sortedPermDArray = sortPermDArray.getSortedDouble();
                        for (int j = 0; j < sortedPermDArray.length; ++j) {
                            permutedDValues[i12][j] = sortedPermDArray[j];
                        }
                    }
                } else if (this.studyDesign == 8) {
                    for (i12 = 0; i12 < this.numUniquePerms; ++i12) {
                        if (this.stop) {
                            throw new AbortException();
                        }
                        event2.setIntValue(i12);
                        event2.setDescription("Permuting matrix: Current permutation = " + (i12 + 1));
                        this.fireValueChanged(event2);
                        Vector<Integer> validExpts = new Vector<Integer>();
                        for (int j = 0; j < this.groupAssignments.length; ++j) {
                            if (this.groupAssignments[j] != 1) continue;
                            validExpts.add(new Integer(j));
                        }
                        int[] validArray = new int[validExpts.size()];
                        for (int j = 0; j < validArray.length; ++j) {
                            validArray[j] = (Integer)validExpts.get(j);
                        }
                        boolean[] changeSign = this.getOneClassChangeSignArrayAllUniquePerms(i12, validArray);
                        FloatMatrix permutedMatrix = this.getOneClassPermMatrix(this.imputedMatrix, changeSign);
                        double[] permDArray = new double[permutedMatrix.getRowDimension()];
                        for (int j = 0; j < permutedMatrix.getRowDimension(); ++j) {
                            permDArray[j] = this.getD(j, permutedMatrix);
                        }
                        QSort sortPermDArray = new QSort(permDArray);
                        double[] sortedPermDArray = sortPermDArray.getSortedDouble();
                        for (int j = 0; j < sortedPermDArray.length; ++j) {
                            permutedDValues[i12][j] = sortedPermDArray[j];
                        }
                    }
                } else if (this.studyDesign == 7) {
                    Vector<Integer> validExpts = new Vector<Integer>();
                    for (int j = 0; j < this.inSurvivalAnalysis.length; ++j) {
                        if (!this.inSurvivalAnalysis[j]) continue;
                        validExpts.add(new Integer(j));
                    }
                    int[] validArray = new int[validExpts.size()];
                    for (int j = 0; j < validArray.length; ++j) {
                        validArray[j] = (Integer)validExpts.get(j);
                    }
                    int[] comb = new int[validArray.length];
                    for (int i17 = 0; i17 < comb.length; ++i17) {
                        comb[i17] = -1;
                    }
                    int permCounter = 0;
                    while (Permutations.enumeratePermutations((int)validArray.length, (int)validArray.length, (int[])comb)) {
                        if (this.stop) {
                            throw new AbortException();
                        }
                        event2.setIntValue(permCounter);
                        event2.setDescription("Permuting matrix: Current permutation = " + (permCounter + 1));
                        this.fireValueChanged(event2);
                        for (int i18 = 0; i18 < validArray.length; ++i18) {
                            permutedExpts[validArray[i18]] = validArray[comb[i18]];
                        }
                        FloatMatrix permutedMatrix = this.getPermutedMatrix(this.imputedMatrix, permutedExpts);
                        double[] permDArray = new double[permutedMatrix.getRowDimension()];
                        for (int j = 0; j < permutedMatrix.getRowDimension(); ++j) {
                            permDArray[j] = this.getD(j, permutedMatrix);
                        }
                        QSort sortPermDArray = new QSort(permDArray);
                        double[] sortedPermDArray = sortPermDArray.getSortedDouble();
                        for (int j = 0; j < sortedPermDArray.length; ++j) {
                            permutedDValues[permCounter][j] = sortedPermDArray[j];
                        }
                        ++permCounter;
                    }
                }
            }
            this.dBarValues = new double[this.numGenes];
            for (int i19 = 0; i19 < this.numGenes; ++i19) {
                double[] currentGene = new double[this.numCombs];
                for (int j = 0; j < this.numCombs; ++j) {
                    currentGene[j] = permutedDValues[j][i19];
                }
                this.dBarValues[i19] = this.getMean(currentGene);
            }
            SAMState.dBarValues = this.dBarValues;
            double[] oneDimPermutedDValues = new double[this.numCombs * this.numGenes];
            int counter1 = 0;
            for (int i20 = 0; i20 < this.numCombs; ++i20) {
                for (int j = 0; j < this.numGenes; ++j) {
                    oneDimPermutedDValues[counter1] = permutedDValues[i20][j];
                    ++counter1;
                }
            }
            QSort sortAllPermutedDValues = new QSort(oneDimPermutedDValues);
            double[] sortedAllPermutedDValues = sortAllPermutedDValues.getSortedDouble();
            sortAllPermutedDValues.getOrigIndx();
            int percentile25thIndex = (int)Math.round((double)sortedAllPermutedDValues.length * 0.25 - 1.0);
            if (percentile25thIndex < 0) {
                percentile25thIndex = 0;
            } else if (percentile25thIndex >= sortedAllPermutedDValues.length) {
                percentile25thIndex = sortedAllPermutedDValues.length - 1;
            }
            int percentile75thIndex = (int)Math.round((double)sortedAllPermutedDValues.length * 0.75 - 1.0);
            if (percentile75thIndex < 0) {
                percentile75thIndex = 0;
            } else if (percentile75thIndex >= sortedAllPermutedDValues.length) {
                percentile75thIndex = sortedAllPermutedDValues.length - 1;
            }
            double q25 = sortedAllPermutedDValues[percentile25thIndex];
            double q75 = sortedAllPermutedDValues[percentile75thIndex];
            int piCounter = 0;
            for (int i21 = 0; i21 < this.dArray.length; ++i21) {
                if (!(this.dArray[i21] > q25) || !(this.dArray[i21] < q75)) continue;
                ++piCounter;
            }
            this.pi0Hat = (double)piCounter / (0.5 * (double)this.numGenes);
            SAMState.pi0Hat = this.pi0Hat = Math.min(this.pi0Hat, 1.0);
            double maximum = this.getMax(this.dArray);
            double minimum = this.getMin(this.dArray);
            this.delta = Math.abs(maximum) > Math.abs(minimum) ? (double)((float)(0.25 * Math.abs(maximum))) : (double)((float)(0.25 * Math.abs(minimum)));
            double[] diffValues = new double[this.sortedDArray.length];
            for (int i22 = 0; i22 < diffValues.length; ++i22) {
                diffValues[i22] = Math.abs(this.sortedDArray[i22] - this.dBarValues[i22]);
            }
            double maxDelta = this.getMax(diffValues);
            double minDelta = this.getMin(diffValues);
            double deltaIncrement = (maxDelta - minDelta) / 1000.0;
            double currentDelta = minDelta;
            for (int i23 = 0; i23 < this.deltaGrid.length; ++i23) {
                this.deltaGrid[i23] = currentDelta;
                currentDelta += deltaIncrement;
            }
            SAMState.deltaGrid = this.deltaGrid;
            double[] cutUp = new double[this.deltaGrid.length];
            double[] cutLow = new double[this.deltaGrid.length];
            for (i9 = 0; i9 < cutUp.length; ++i9) {
                cutUp[i9] = this.getCutUp(this.deltaGrid[i9]);
                cutLow[i9] = this.getCutLow(this.deltaGrid[i9]);
            }
            this.numSigGenesByDelta = new int[this.deltaGrid.length];
            for (i9 = 0; i9 < this.deltaGrid.length; ++i9) {
                this.numSigGenesByDelta[i9] = this.getNumSigGenesByDelta(cutUp[i9], cutLow[i9]);
            }
            SAMState.numSigGenesByDelta = this.numSigGenesByDelta;
            this.medNumFalselyCalledGenesByDelta = new double[this.deltaGrid.length];
            this.ninetiethPercentileFalselyCalledGenesByDelta = new double[this.deltaGrid.length];
            for (i9 = 0; i9 < this.deltaGrid.length; ++i9) {
                this.medNumFalselyCalledGenesByDelta[i9] = this.getMedNumFalselyCalledGenesByDelta(permutedDValues, cutUp[i9], cutLow[i9]);
                this.ninetiethPercentileFalselyCalledGenesByDelta[i9] = this.getNinetiethPercentileFalselyCalledGenesByDelta(permutedDValues, cutUp[i9], cutLow[i9]);
            }
            for (i9 = 0; i9 < this.deltaGrid.length; ++i9) {
                this.medNumFalselyCalledGenesByDelta[i9] = this.pi0Hat * this.medNumFalselyCalledGenesByDelta[i9];
                this.ninetiethPercentileFalselyCalledGenesByDelta[i9] = this.pi0Hat * this.ninetiethPercentileFalselyCalledGenesByDelta[i9];
            }
            SAMState.medNumFalselyCalledGenesByDelta = this.medNumFalselyCalledGenesByDelta;
            SAMState.ninetiethPercentileFalselyCalledGenesByDelta = this.ninetiethPercentileFalselyCalledGenesByDelta;
            this.FDRmedian = new double[this.deltaGrid.length];
            this.FDR90thPercentile = new double[this.deltaGrid.length];
            for (i9 = 0; i9 < this.deltaGrid.length; ++i9) {
                this.FDRmedian[i9] = this.medNumFalselyCalledGenesByDelta[i9] * 100.0 / (double)this.numSigGenesByDelta[i9];
                this.FDR90thPercentile[i9] = this.ninetiethPercentileFalselyCalledGenesByDelta[i9] * 100.0 / (double)this.numSigGenesByDelta[i9];
            }
            SAMState.FDRmedian = this.FDRmedian;
            SAMState.FDR90thPercentile = this.FDR90thPercentile;
            if (this.calculateQLowestFDR) {
                this.qLowestFDR = new double[this.numGenes];
                AlgorithmEvent event3 = new AlgorithmEvent((Object)this, 1, this.qLowestFDR.length);
                this.fireValueChanged(event3);
                event3.setId(2);
                for (i8 = 0; i8 < this.numGenes; ++i8) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event3.setIntValue(i8);
                    event3.setDescription("Calculating q values: Current gene = " + (i8 + 1));
                    this.fireValueChanged(event3);
                    int sigDeltaIndex = 0;
                    boolean sigFound = false;
                    for (int j = this.deltaGrid.length - 1; j >= 0; --j) {
                        if (!this.isSignificant(i8, cutUp[j], cutLow[j])) continue;
                        sigDeltaIndex = j;
                        sigFound = true;
                        break;
                    }
                    if (sigFound) {
                        double currDelta = this.deltaGrid[sigDeltaIndex];
                        this.qLowestFDR[i8] = this.getMedNumFalselyCalledGenesByDelta(permutedDValues, this.getCutUp(currDelta), this.getCutLow(currDelta));
                        this.qLowestFDR[i8] = this.qLowestFDR[i8] * this.pi0Hat * 100.0 / (double)this.numSigGenesByDelta[sigDeltaIndex];
                        continue;
                    }
                    this.qLowestFDR[i8] = Double.NaN;
                }
            } else {
                this.qLowestFDR = new double[this.numGenes];
            }
            SAMState.qLowestFDR = this.qLowestFDR;
            FloatMatrix qLowestFDRMatrix = new FloatMatrix(this.qLowestFDR.length, 1);
            for (i8 = 0; i8 < this.qLowestFDR.length; ++i8) {
                qLowestFDRMatrix.A[i8][0] = (float)this.qLowestFDR[i8];
            }
        } else if (this.useRSAM && !usePreviousGraph) {
            this.runRAlg();
        } else {
            this.useRSAM = SAMState.useRSAM;
            this.imputedMatrix = SAMState.imputedMatrix;
            this.dBarValues = SAMState.dBarValues;
            this.sortedDArray = SAMState.sortedDArray;
            this.sortedDArrayIndices = SAMState.sortedDArrayIndices;
            this.delta = SAMState.delta;
            this.deltaGrid = SAMState.deltaGrid;
            this.numSigGenesByDelta = SAMState.numSigGenesByDelta;
            this.medNumFalselyCalledGenesByDelta = SAMState.medNumFalselyCalledGenesByDelta;
            this.sNought = SAMState.sNought;
            this.s0Percentile = SAMState.s0Percentile;
            this.pi0Hat = SAMState.pi0Hat;
            this.ninetiethPercentileFalselyCalledGenesByDelta = SAMState.ninetiethPercentileFalselyCalledGenesByDelta;
            this.FDRmedian = SAMState.FDRmedian;
            this.FDR90thPercentile = SAMState.FDR90thPercentile;
            this.qLowestFDR = SAMState.qLowestFDR;
            this.dArray = SAMState.dArray;
            this.rArray = SAMState.rArray;
        }
        FloatMatrix dValuesMatrix = new FloatMatrix(this.dArray.length, 1);
        FloatMatrix rValuesMatrix = new FloatMatrix(this.rArray.length, 1);
        for (int i24 = 0; i24 < this.dArray.length; ++i24) {
            dValuesMatrix.A[i24][0] = (float)this.dArray[i24];
            rValuesMatrix.A[i24][0] = (float)this.rArray[i24];
        }
        FloatMatrix deltaGridMatrix = new FloatMatrix(this.deltaGrid.length, 1);
        this.medNumFalseMatrix = new FloatMatrix(this.medNumFalselyCalledGenesByDelta.length, 1);
        FloatMatrix false90thMatrix = new FloatMatrix(this.ninetiethPercentileFalselyCalledGenesByDelta.length, 1);
        FloatMatrix numSigMatrix = new FloatMatrix(this.numSigGenesByDelta.length, 1);
        FloatMatrix FDRMedianMatrix = new FloatMatrix(this.FDRmedian.length, 1);
        FloatMatrix FDR90thMatrix = new FloatMatrix(this.FDR90thPercentile.length, 1);
        for (int i25 = 0; i25 < this.deltaGrid.length; ++i25) {
            deltaGridMatrix.A[i25][0] = (float)this.deltaGrid[i25];
            this.medNumFalseMatrix.A[i25][0] = (float)this.medNumFalselyCalledGenesByDelta[i25];
            false90thMatrix.A[i25][0] = (float)this.ninetiethPercentileFalselyCalledGenesByDelta[i25];
            numSigMatrix.A[i25][0] = this.numSigGenesByDelta[i25];
            FDRMedianMatrix.A[i25][0] = (float)this.FDRmedian[i25];
            FDR90thMatrix.A[i25][0] = (float)this.FDR90thPercentile[i25];
        }
        FloatMatrix qLowestFDRMatrix = new FloatMatrix(this.qLowestFDR.length, 1);
        for (int i26 = 0; i26 < this.qLowestFDR.length; ++i26) {
            qLowestFDRMatrix.A[i26][0] = (float)this.qLowestFDR[i26];
        }
        float scriptDelta = data.getParams().getFloat("delta", -1.0f);
        boolean graphInteraction = data.getParams().getBoolean("permit-graph-interaction", true);
        if (scriptDelta != -1.0f) {
            this.delta = scriptDelta;
        }
        SAMGraph sg = new SAMGraph(SAMGUI.SAMFrame, this.studyDesign, this.dBarValues, this.sortedDArray, this.delta, this.deltaGrid, this.numSigGenesByDelta, this.medNumFalselyCalledGenesByDelta, this.ninetiethPercentileFalselyCalledGenesByDelta, this.FDRmedian, this.FDR90thPercentile, true);
        if (graphInteraction) {
            sg.setVisible(true);
            this.delta = sg.getDelta();
        }
        SAMState.delta = this.delta = sg.getDelta();
        String numSig = sg.getNumSig();
        String numFalseSigMed = sg.getNumFalseSigMed();
        String numFalseSig90th = sg.getNumFalseSig90th();
        String FDRMedian = sg.getFDRMedian();
        String FDR90th = sg.getFDR90th();
        double upperCutoff = this.getCutUp(this.delta);
        double lowerCutoff = this.getCutLow(this.delta);
        FloatMatrix dBarMatrix = new FloatMatrix(this.dBarValues.length, 1);
        FloatMatrix sortedDMatrix = new FloatMatrix(this.sortedDArray.length, 1);
        for (i3 = 0; i3 < this.dBarValues.length; ++i3) {
            dBarMatrix.A[i3][0] = (float)this.dBarValues[i3];
        }
        for (i3 = 0; i3 < this.sortedDArray.length; ++i3) {
            sortedDMatrix.A[i3][0] = (float)this.sortedDArray[i3];
        }
        FloatMatrix foldChangeMatrix = new FloatMatrix(this.numGenes, 1);
        if (this.studyDesign == 4 || this.studyDesign == 5) {
            for (int i27 = 0; i27 < this.numGenes; ++i27) {
                foldChangeMatrix.A[i27][0] = (float)this.getFoldChange(i27);
            }
        }
        Vector<Integer> posSigGenes = new Vector<Integer>();
        Vector<Integer> negSigGenes = new Vector<Integer>();
        Vector<Integer> nonSigGenes = new Vector<Integer>();
        boolean posSigEncountered = false;
        boolean negSigEncountered = false;
        int lowestPosSigIndex = 0;
        int highestNegSigIndex = 0;
        for (i2 = 0; i2 < this.dBarValues.length; ++i2) {
            if (!(this.dBarValues[i2] > 0.0) || !(this.sortedDArray[i2] - this.dBarValues[i2] > this.delta)) continue;
            lowestPosSigIndex = i2;
            posSigEncountered = true;
            break;
        }
        for (i2 = 0; i2 < this.dBarValues.length; ++i2) {
            if (!(this.dBarValues[i2] < 0.0) || !(this.dBarValues[i2] - this.sortedDArray[i2] > this.delta)) continue;
            highestNegSigIndex = i2;
            negSigEncountered = true;
        }
        boolean useFoldChange = sg.useFoldChange();
        double foldChange = 0.0;
        if (useFoldChange && (this.studyDesign == 4 || this.studyDesign == 5)) {
            foldChange = sg.getFoldChangeValue();
            if (posSigEncountered && negSigEncountered) {
                for (i = 0; i < highestNegSigIndex + 1; ++i) {
                    if (this.satisfiesNegFoldChangeCriterion(foldChange, this.sortedDArrayIndices[i])) {
                        negSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                        continue;
                    }
                    nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                }
                for (i = highestNegSigIndex + 1; i < lowestPosSigIndex; ++i) {
                    nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                }
                for (i = lowestPosSigIndex; i < this.dBarValues.length; ++i) {
                    if (this.satisfiesPosFoldChangeCriterion(foldChange, this.sortedDArrayIndices[i])) {
                        posSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                        continue;
                    }
                    nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                }
            } else if (posSigEncountered && !negSigEncountered) {
                for (i = 0; i < lowestPosSigIndex; ++i) {
                    nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                }
                for (i = lowestPosSigIndex; i < this.dBarValues.length; ++i) {
                    if (this.satisfiesPosFoldChangeCriterion(foldChange, this.sortedDArrayIndices[i])) {
                        posSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                        continue;
                    }
                    nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                }
            } else if (!posSigEncountered && negSigEncountered) {
                for (i = 0; i < highestNegSigIndex + 1; ++i) {
                    if (this.satisfiesNegFoldChangeCriterion(foldChange, this.sortedDArrayIndices[i])) {
                        negSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                        continue;
                    }
                    nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                }
                for (i = highestNegSigIndex + 1; i < this.dBarValues.length; ++i) {
                    nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                }
            } else if (!posSigEncountered && !negSigEncountered) {
                for (i = 0; i < this.dBarValues.length; ++i) {
                    nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
                }
            }
        } else if (posSigEncountered && negSigEncountered) {
            for (i = 0; i < highestNegSigIndex + 1; ++i) {
                negSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
            }
            for (i = highestNegSigIndex + 1; i < lowestPosSigIndex; ++i) {
                nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
            }
            for (i = lowestPosSigIndex; i < this.dBarValues.length; ++i) {
                posSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
            }
        } else if (posSigEncountered && !negSigEncountered) {
            for (i = 0; i < lowestPosSigIndex; ++i) {
                nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
            }
            for (i = lowestPosSigIndex; i < this.dBarValues.length; ++i) {
                posSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
            }
        } else if (!posSigEncountered && negSigEncountered) {
            for (i = 0; i < highestNegSigIndex + 1; ++i) {
                negSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
            }
            for (i = highestNegSigIndex + 1; i < this.dBarValues.length; ++i) {
                nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
            }
        } else if (!posSigEncountered && !negSigEncountered) {
            for (i = 0; i < this.dBarValues.length; ++i) {
                nonSigGenes.add(new Integer(this.sortedDArrayIndices[i]));
            }
        }
        Vector<Integer> allSigGenes = new Vector<Integer>();
        allSigGenes.addAll(posSigGenes);
        allSigGenes.addAll(negSigGenes);
        this.k = this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8 ? 4 : 2;
        this.clusters = new Vector[this.k];
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8) {
            this.clusters[0] = posSigGenes;
            this.clusters[1] = negSigGenes;
            this.clusters[2] = allSigGenes;
            this.clusters[3] = nonSigGenes;
        } else {
            this.clusters[0] = posSigGenes;
            this.clusters[1] = nonSigGenes;
        }
        FloatMatrix means = this.getMeans(this.clusters);
        FloatMatrix variances = this.getVariances(this.clusters, means);
        AlgorithmEvent event = null;
        if (hierarchical_tree) {
            event = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(event);
            event.setIntValue(0);
            event.setId(2);
            this.fireValueChanged(event);
        }
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i28 = 0; i28 < this.clusters.length; ++i28) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.convert2int(this.clusters[i28]);
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            if (this.drawSigTreesOnly) {
                if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8) {
                    if (i28 != 0 && i28 != 1 && i28 != 2) continue;
                    node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
                    event.setIntValue(i28 + 1);
                    this.fireValueChanged(event);
                    continue;
                }
                if (i28 != 0) continue;
                node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
                event.setIntValue(i28 + 1);
                this.fireValueChanged(event);
                continue;
            }
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            event.setIntValue(i28 + 1);
            this.fireValueChanged(event);
        }
        AlgorithmData result = new AlgorithmData();
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        result.addParam("numSigGenes", String.valueOf(numSig));
        result.addParam("numFalseSigMed", String.valueOf(numFalseSigMed));
        result.addParam("numFalseSig90th", numFalseSig90th);
        result.addParam("FDRMedian", FDRMedian);
        result.addParam("FDR90th", FDR90th);
        result.addParam("useFoldChange", String.valueOf(useFoldChange));
        result.addParam("useR", String.valueOf(this.useRSAM));
        result.addParam("foldChangeValue", String.valueOf((float)foldChange));
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        result.addParam("delta", String.valueOf((float)this.delta));
        if (Double.isInfinite(upperCutoff)) {
            result.addParam("upperCutoff", String.valueOf(Float.POSITIVE_INFINITY));
        } else {
            result.addParam("upperCutoff", String.valueOf((float)upperCutoff));
        }
        if (Double.isInfinite(lowerCutoff)) {
            result.addParam("lowerCutoff", String.valueOf(Float.NEGATIVE_INFINITY));
        } else {
            result.addParam("lowerCutoff", String.valueOf((float)lowerCutoff));
        }
        result.addParam("sNought", String.valueOf((float)this.sNought));
        result.addParam("s0Percentile", String.valueOf((float)this.s0Percentile));
        result.addParam("pi0Hat", String.valueOf((float)this.pi0Hat));
        result.addMatrix("dValuesMatrix", dValuesMatrix);
        result.addMatrix("rValuesMatrix", rValuesMatrix);
        result.addMatrix("foldChangeMatrix", foldChangeMatrix);
        result.addMatrix("dBarMatrixX", dBarMatrix);
        result.addMatrix("sortedDMatrixY", sortedDMatrix);
        result.addMatrix("qLowestFDRMatrix", qLowestFDRMatrix);
        result.addMatrix("deltaGridMatrix", deltaGridMatrix);
        result.addMatrix("medNumFalseMatrix", this.medNumFalseMatrix);
        result.addMatrix("false90thMatrix", false90thMatrix);
        result.addMatrix("numSigMatrix", numSigMatrix);
        result.addMatrix("FDRMedianMatrix", FDRMedianMatrix);
        result.addMatrix("FDR90thMatrix", FDR90thMatrix);
        result.addMatrix("imputedMatrix", this.imputedMatrix);
        return result;
    }

    public void runRAlg() throws AbortException {
        try {
            Rengine re = RHook.startRSession();
            if (re == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        try {
            int i;
            int i2;
            if (RHook.getOS() == 3 || RHook.getOS() == 1) {
                RHook.testPackage((String)"sam");
            } else {
                RHook.installModule((String)"samr");
            }
            RHook.log((String)"Starting R Algorithim");
            System.out.println("start of load lib");
            String rCmd = "library(samr)";
            RHook.evalR((String)rCmd);
            System.out.println("end of load lib");
            int numProbes = this.expMatrix.getRowDimension();
            int numSamples = this.expMatrix.getColumnDimension();
            String fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "tmpfile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            String filePath = this.writeMatrixToFile(fileLoc, this.expMatrix, this.geneNames);
            RHook.createRDataMatrixFromFile((String)"x", (String)filePath, (boolean)true, (String[])this.sampleNames);
            int grp1 = numSamples % 2 == 0 ? numSamples / 2 : (numSamples - 1) / 2;
            int grp2 = numSamples - grp1;
            if (this.studyDesign == 5) {
                this.groupAssignments = new int[this.numExps];
                for (i2 = 0; i2 < this.groupAssignments.length; ++i2) {
                    int j;
                    for (j = 0; j < this.pairedGroupAExpts.length; ++j) {
                        if (i2 != this.pairedGroupAExpts[j]) continue;
                        this.groupAssignments[i2] = 1;
                    }
                    for (j = 0; j < this.pairedGroupBExpts.length; ++j) {
                        if (i2 != this.pairedGroupBExpts[j]) continue;
                        this.groupAssignments[i2] = 1;
                    }
                }
            }
            if (this.studyDesign == 7) {
                this.groupAssignments = new int[this.numExps];
                for (i2 = 0; i2 < this.groupAssignments.length; ++i2) {
                    this.groupAssignments[i2] = this.inSurvivalAnalysis[i2] ? 1 : 0;
                }
            }
            String keepSamps = "x <- x[,c(";
            for (int i3 = 0; i3 < this.groupAssignments.length; ++i3) {
                System.out.println("GRPassign[" + i3 + "] " + this.groupAssignments[i3]);
                if (this.groupAssignments[i3] <= 0) continue;
                keepSamps = keepSamps + (i3 + 1) + ",";
            }
            while (keepSamps.substring(keepSamps.length() - 1).equals(",")) {
                keepSamps = keepSamps.substring(0, keepSamps.length() - 1);
            }
            keepSamps = keepSamps + ")]";
            RHook.log((String)keepSamps);
            RHook.evalR((String)keepSamps);
            String design = this.getStudyDesign();
            RHook.log((String)design);
            RHook.evalR((String)design);
            if (this.studyDesign == 7) {
                String cs = this.getCensorStatus();
                RHook.log((String)cs);
                RHook.evalR((String)cs);
            }
            String data_list = "data=list(x=x,y=y," + (this.studyDesign == 7 ? "censoring.status=censoring.status," : "") + " geneid=as.character(1:nrow(x)),genenames=paste('g',as.character(1:nrow(x)),sep=''), logged2=TRUE)";
            RHook.log((String)data_list);
            RHook.evalR((String)data_list);
            String runSam = "samr.obj<-samr(data,  resp.type=";
            runSam = runSam + "'" + this.getDesignString() + "'";
            runSam = runSam + ", nperms=" + this.numCombs;
            runSam = runSam + ", s0=" + this.sNought;
            runSam = runSam + ", s0.perc=" + this.s0Percentile;
            if (this.useKNearest) {
                runSam = runSam + ", knn.neighbors=" + this.numNeighbors;
            }
            runSam = runSam + ")";
            RHook.log((String)runSam);
            RHook.evalR((String)runSam);
            REXP x = RHook.evalR((String)"samr.obj$evo");
            double[] tmp = x.asDoubleArray();
            this.dBarValues = new double[this.numGenes];
            for (i = 0; i < tmp.length; ++i) {
                this.dBarValues[i] = (float)tmp[i];
            }
            x = RHook.evalR((String)"samr.obj$tt");
            tmp = x.asDoubleArray();
            this.dArray = new double[this.numGenes];
            this.rArray = new double[this.numGenes];
            this.qLowestFDR = new double[this.numGenes];
            for (i = 0; i < tmp.length; ++i) {
                this.dArray[i] = (float)tmp[i];
            }
            x = RHook.evalR((String)"samr.compute.delta.table(samr.obj)");
            double[][] samoutdm = x.asDoubleMatrix();
            int numDeltas = samoutdm.length;
            this.deltaGrid = new double[numDeltas];
            this.medNumFalselyCalledGenesByDelta = new double[numDeltas];
            this.ninetiethPercentileFalselyCalledGenesByDelta = new double[numDeltas];
            this.numSigGenesByDelta = new int[numDeltas];
            this.FDRmedian = new double[numDeltas];
            this.FDR90thPercentile = new double[numDeltas];
            for (int i4 = 0; i4 < samoutdm.length; ++i4) {
                this.deltaGrid[i4] = samoutdm[i4][0];
                this.medNumFalselyCalledGenesByDelta[i4] = samoutdm[i4][1];
                this.ninetiethPercentileFalselyCalledGenesByDelta[i4] = samoutdm[i4][2];
                this.numSigGenesByDelta[i4] = (int)samoutdm[i4][3];
                this.FDRmedian[i4] = samoutdm[i4][4];
                this.FDR90thPercentile[i4] = samoutdm[i4][5];
            }
            this.sNought = RHook.evalR((String)"samr.obj$s0").asDouble();
            this.s0Percentile = RHook.evalR((String)"samr.obj$s0.perc").asDouble();
            this.imputedMatrix = new FloatMatrix(this.numGenes, this.numExps);
            this.imputedMatrix = this.useKNearest ? this.imputeKNearestMatrix(this.expMatrix, this.numNeighbors) : this.imputeRowAverageMatrix(this.expMatrix);
            SAMState.imputedMatrix = this.imputedMatrix;
            SAMState.dBarValues = this.dBarValues;
            QSort sortDArray = new QSort(this.dArray);
            this.sortedDArray = sortDArray.getSortedDouble();
            SAMState.sortedDArray = this.sortedDArray;
            this.sortedDArrayIndices = sortDArray.getOrigIndx();
            SAMState.sortedDArrayIndices = this.sortedDArrayIndices;
            double maximum = this.getMax(this.dArray);
            double minimum = this.getMin(this.dArray);
            this.delta = Math.abs(maximum) > Math.abs(minimum) ? (double)((float)(0.25 * Math.abs(maximum))) : (double)((float)(0.25 * Math.abs(minimum)));
            SAMState.delta = this.delta;
            SAMState.deltaGrid = this.deltaGrid;
            SAMState.numSigGenesByDelta = this.numSigGenesByDelta;
            SAMState.medNumFalselyCalledGenesByDelta = this.medNumFalselyCalledGenesByDelta;
            SAMState.sNought = this.sNought;
            SAMState.dArray = this.dArray;
            SAMState.rArray = this.rArray;
            SAMState.ninetiethPercentileFalselyCalledGenesByDelta = this.ninetiethPercentileFalselyCalledGenesByDelta;
            SAMState.FDRmedian = this.FDRmedian;
            SAMState.FDR90thPercentile = this.FDR90thPercentile;
            SAMState.qLowestFDR = this.qLowestFDR;
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private String getCensorStatus() {
        String string = "";
        for (int i = 0; i < this.inSurvivalAnalysis.length; ++i) {
            if (!this.inSurvivalAnalysis[i]) continue;
            string = string + (this.isCensored[i] ? 0 : 1) + ",";
        }
        while (string.substring(string.length() - 1).equals(",")) {
            string = string.substring(0, string.length() - 1);
        }
        String str = "censoring.status=c(" + string + ")";
        return str;
    }

    private String getDesignString() {
        String str = "";
        if (this.studyDesign == 4) {
            str = this.isTimeCourse ? "Two class unpaired timecourse" : "Two class unpaired";
        }
        if (this.studyDesign == 8) {
            str = this.isTimeCourse ? "One class timecourse" : "One class";
        }
        if (this.studyDesign == 5) {
            str = "Two class paired";
        }
        if (this.studyDesign == 6) {
            str = "Multiclass";
        }
        if (this.studyDesign == 7) {
            str = "Survival";
        }
        return str;
    }

    private String writeMatrixToFile(String fileLoc, FloatMatrix fm, String[] rowNames) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
            int row = fm.getRowDimension();
            int col = fm.getColumnDimension();
            String srtVector = "";
            for (int iRow = 0; iRow < row; ++iRow) {
                srtVector = rowNames[iRow] + "\t";
                for (int jCol = 0; jCol < col; ++jCol) {
                    srtVector = jCol == col - 1 ? srtVector + fm.get(iRow, jCol) + "\n" : srtVector + fm.get(iRow, jCol) + "\t";
                }
                out.write(srtVector);
                srtVector = "";
            }
            out.close();
        }
        catch (IOException e) {
            return null;
        }
        return fileLoc;
    }

    private String getStudyDesign() {
        switch (this.studyDesign) {
            case 8: {
                return this.getOneClassDesign();
            }
            case 4: {
                return this.getTwoClassDesign();
            }
            case 6: {
                return this.getMultiClassDesign();
            }
            case 5: {
                return this.getTwoClassPairedDesign();
            }
            case 7: {
                return this.getCenSurDesign();
            }
        }
        return "";
    }

    private String getOneClassDesign() {
        String grp1 = "";
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            grp1 = this.groupAssignments[i] == 1 ? grp1 + (this.isTimeCourse ? "'1Time" + this.timeCourseData[i] + this.startOrEnd[i] + "'" : "1") + "," : grp1 + "";
        }
        while (grp1.substring(grp1.length() - 1).equals(",")) {
            grp1 = grp1.substring(0, grp1.length() - 1);
        }
        String str = "y <- c(" + grp1 + ")";
        return str;
    }

    private String getTwoClassDesign() {
        String grp1 = "";
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            grp1 = this.groupAssignments[i] == 1 ? grp1 + (this.isTimeCourse ? "'1Time" + this.timeCourseData[i] + this.startOrEnd[i] + "'" : "1") + "," : (this.groupAssignments[i] == 2 ? grp1 + (this.isTimeCourse ? "'2Time" + this.timeCourseData[i] + this.startOrEnd[i] + "'" : "2") + "," : grp1 + "");
        }
        while (grp1.substring(grp1.length() - 1).equals(",")) {
            grp1 = grp1.substring(0, grp1.length() - 1);
        }
        String str = "y <- c(" + grp1 + ")";
        return str;
    }

    private String getMultiClassDesign() {
        String grp1 = "";
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            grp1 = this.groupAssignments[i] > 0 ? grp1 + this.groupAssignments[i] + "," : grp1 + "";
        }
        while (grp1.substring(grp1.length() - 1).equals(",")) {
            grp1 = grp1.substring(0, grp1.length() - 1);
        }
        String str = "y <- c(" + grp1 + ")";
        return str;
    }

    private String getTwoClassPairedDesign() {
        Vector<Integer> rpair = new Vector<Integer>();
        for (int i = 0; i < this.numExps; ++i) {
            int j;
            int found = -1;
            for (j = 0; j < this.pairedGroupAExpts.length; ++j) {
                if (this.pairedGroupAExpts[j] != i) continue;
                found = j;
            }
            if (found != -1) {
                rpair.add(found + 1);
                continue;
            }
            for (j = 0; j < this.pairedGroupBExpts.length; ++j) {
                if (this.pairedGroupBExpts[j] != i) continue;
                found = j;
            }
            if (found == -1) continue;
            rpair.add(-found - 1);
        }
        String str = "y <- c(";
        for (int i = 0; i < rpair.size(); ++i) {
            str = str + rpair.get(i) + ",";
        }
        while (str.substring(str.length() - 1).equals(",")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str + ")";
        return str;
    }

    private String getCenSurDesign() {
        String string = "";
        for (int i = 0; i < this.inSurvivalAnalysis.length; ++i) {
            if (!this.inSurvivalAnalysis[i]) continue;
            string = string + this.survivalTimes[i] + ",";
        }
        while (string.substring(string.length() - 1).equals(",")) {
            string = string.substring(0, string.length() - 1);
        }
        String str = "y=c(" + string + ")";
        return str;
    }

    public void abort() {
        this.stop = true;
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.getSubExperiment(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector<Integer> source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = source.get(i);
        }
        return int_matrix;
    }

    private FloatMatrix getMeans(Vector<Integer>[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.numExps);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getMean(Vector<Integer> cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.numExps);
        int n = cluster.size();
        int denom = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(cluster.get(j).intValue(), i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    private FloatMatrix getVariances(Vector<Integer>[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleNormalizedSum(Vector<Integer> cluster, int column, float mean) {
        int size = cluster.size();
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(cluster.get(i).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float getSampleVariance(Vector<Integer> cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    private boolean belongsInArray(int i, int[] arr) {
        boolean belongs = false;
        for (int j = 0; j < arr.length; ++j) {
            if (i != arr[j]) continue;
            belongs = true;
            break;
        }
        return belongs;
    }

    private double getFoldChange(int gene) {
        float[] currentGene = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            currentGene[i] = this.imputedMatrix.A[gene][i];
        }
        double[] unloggedCurrentGene = new double[currentGene.length];
        for (int i = 0; i < unloggedCurrentGene.length; ++i) {
            unloggedCurrentGene[i] = Math.pow(2.0, currentGene[i]);
        }
        double[] groupAValues = new double[1];
        double[] groupBValues = new double[1];
        if (this.studyDesign == 4) {
            int groupACounter = 0;
            int groupBCounter = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    ++groupACounter;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                ++groupBCounter;
            }
            groupAValues = new double[groupACounter];
            groupBValues = new double[groupBCounter];
            int groupAIndex = 0;
            int groupBIndex = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    groupAValues[groupAIndex] = unloggedCurrentGene[i];
                    ++groupAIndex;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                groupBValues[groupBIndex] = unloggedCurrentGene[i];
                ++groupBIndex;
            }
        } else if (this.studyDesign == 5) {
            groupAValues = new double[this.pairedGroupAExpts.length];
            groupBValues = new double[this.pairedGroupBExpts.length];
            for (int i = 0; i < groupAValues.length; ++i) {
                groupAValues[i] = unloggedCurrentGene[this.pairedGroupAExpts[i]];
                groupBValues[i] = unloggedCurrentGene[this.pairedGroupBExpts[i]];
            }
        }
        double meanA = this.getMean(groupAValues);
        double meanB = this.getMean(groupBValues);
        return meanB / meanA;
    }

    private boolean satisfiesPosFoldChangeCriterion(double fold, int gene) {
        float[] currentGene = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            currentGene[i] = this.imputedMatrix.A[gene][i];
        }
        double[] unloggedCurrentGene = new double[currentGene.length];
        for (int i = 0; i < unloggedCurrentGene.length; ++i) {
            unloggedCurrentGene[i] = Math.pow(2.0, currentGene[i]);
        }
        double[] groupAValues = new double[1];
        double[] groupBValues = new double[1];
        if (this.studyDesign == 4) {
            int groupACounter = 0;
            int groupBCounter = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    ++groupACounter;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                ++groupBCounter;
            }
            groupAValues = new double[groupACounter];
            groupBValues = new double[groupBCounter];
            int groupAIndex = 0;
            int groupBIndex = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    groupAValues[groupAIndex] = unloggedCurrentGene[i];
                    ++groupAIndex;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                groupBValues[groupBIndex] = unloggedCurrentGene[i];
                ++groupBIndex;
            }
        } else if (this.studyDesign == 5) {
            groupAValues = new double[this.pairedGroupAExpts.length];
            groupBValues = new double[this.pairedGroupBExpts.length];
            for (int i = 0; i < groupAValues.length; ++i) {
                groupAValues[i] = unloggedCurrentGene[this.pairedGroupAExpts[i]];
                groupBValues[i] = unloggedCurrentGene[this.pairedGroupBExpts[i]];
            }
        }
        double meanA = this.getMean(groupAValues);
        double meanB = this.getMean(groupBValues);
        if (meanA <= 0.0 || meanB <= 0.0) {
            return false;
        }
        return Math.abs(meanB / meanA) >= fold;
    }

    private boolean satisfiesNegFoldChangeCriterion(double fold, int gene) {
        float[] currentGene = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            currentGene[i] = this.imputedMatrix.A[gene][i];
        }
        double[] unloggedCurrentGene = new double[currentGene.length];
        for (int i = 0; i < unloggedCurrentGene.length; ++i) {
            unloggedCurrentGene[i] = Math.pow(2.0, currentGene[i]);
        }
        double[] groupAValues = new double[1];
        double[] groupBValues = new double[1];
        if (this.studyDesign == 4) {
            int groupACounter = 0;
            int groupBCounter = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    ++groupACounter;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                ++groupBCounter;
            }
            groupAValues = new double[groupACounter];
            groupBValues = new double[groupBCounter];
            int groupAIndex = 0;
            int groupBIndex = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    groupAValues[groupAIndex] = unloggedCurrentGene[i];
                    ++groupAIndex;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                groupBValues[groupBIndex] = unloggedCurrentGene[i];
                ++groupBIndex;
            }
        } else if (this.studyDesign == 5) {
            groupAValues = new double[this.pairedGroupAExpts.length];
            groupBValues = new double[this.pairedGroupBExpts.length];
            for (int i = 0; i < groupAValues.length; ++i) {
                groupAValues[i] = unloggedCurrentGene[this.pairedGroupAExpts[i]];
                groupBValues[i] = unloggedCurrentGene[this.pairedGroupBExpts[i]];
            }
        }
        double meanA = this.getMean(groupAValues);
        double meanB = this.getMean(groupBValues);
        if (meanA <= 0.0 || meanB <= 0.0) {
            return false;
        }
        return Math.abs(meanB / meanA) <= 1.0 / fold;
    }

    private boolean isSignificant(int gene, double currentCutUp, double currentCutLow) {
        boolean isSig = false;
        if (this.dArray[gene] >= currentCutUp || this.dArray[gene] <= currentCutLow) {
            isSig = true;
        }
        return isSig;
    }

    private double getMedNumFalselyCalledGenesByDelta(double[][] permDVals, double currentCutUp, double currentCutLow) {
        double[] falselyCalledGenes = new double[permDVals.length];
        for (int i = 0; i < falselyCalledGenes.length; ++i) {
            double[] currentPerm = new double[permDVals[i].length];
            for (int j = 0; j < currentPerm.length; ++j) {
                currentPerm[j] = permDVals[i][j];
            }
            int numFalse = 0;
            for (int j = 0; j < currentPerm.length; ++j) {
                if (!(currentPerm[j] >= currentCutUp) && !(currentPerm[j] <= currentCutLow)) continue;
                ++numFalse;
            }
            falselyCalledGenes[i] = numFalse;
        }
        return this.getMedian(falselyCalledGenes);
    }

    private double getNinetiethPercentileFalselyCalledGenesByDelta(double[][] permDVals, double currentCutUp, double currentCutLow) {
        double[] falselyCalledGenes = new double[permDVals.length];
        for (int i = 0; i < falselyCalledGenes.length; ++i) {
            double[] currentPerm = new double[permDVals[i].length];
            for (int j = 0; j < currentPerm.length; ++j) {
                currentPerm[j] = permDVals[i][j];
            }
            int numFalse = 0;
            for (int j = 0; j < currentPerm.length; ++j) {
                if (!(currentPerm[j] >= currentCutUp) && !(currentPerm[j] <= currentCutLow)) continue;
                ++numFalse;
            }
            falselyCalledGenes[i] = numFalse;
        }
        QSort sortFalselyCalled = new QSort(falselyCalledGenes);
        double[] sortedFalselyCalledGenes = sortFalselyCalled.getSortedDouble();
        int ninetiethPercentileIndex = (int)Math.round((double)sortedFalselyCalledGenes.length * 0.9 - 1.0);
        return sortedFalselyCalledGenes[ninetiethPercentileIndex];
    }

    private double getCutUp(double currentDelta) {
        boolean posSigEncountered = false;
        double cutUp = Double.POSITIVE_INFINITY;
        int lowestPosSigIndex = 0;
        for (int i = 0; i < this.dBarValues.length; ++i) {
            if (!(this.dBarValues[i] > 0.0) || !(this.sortedDArray[i] - this.dBarValues[i] > currentDelta)) continue;
            lowestPosSigIndex = i;
            posSigEncountered = true;
            break;
        }
        cutUp = posSigEncountered ? this.sortedDArray[lowestPosSigIndex] : Double.POSITIVE_INFINITY;
        return cutUp;
    }

    private double getCutLow(double currentDelta) {
        int highestNegSigIndex = 0;
        boolean negSigEncountered = false;
        double cutLow = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.dBarValues.length; ++i) {
            if (!(this.dBarValues[i] < 0.0) || !(this.dBarValues[i] - this.sortedDArray[i] > currentDelta)) continue;
            highestNegSigIndex = i;
            negSigEncountered = true;
        }
        cutLow = negSigEncountered ? this.sortedDArray[highestNegSigIndex] : Double.NEGATIVE_INFINITY;
        return cutLow;
    }

    private int getNumSigGenesByDelta(double currentCutUp, double currentCutLow) {
        int numSigGenes = 0;
        for (int i = 0; i < this.sortedDArray.length; ++i) {
            if (!(this.sortedDArray[i] >= currentCutUp) && !(this.sortedDArray[i] <= currentCutLow)) continue;
            ++numSigGenes;
        }
        return numSigGenes;
    }

    private FloatMatrix getPermutedMatrix(FloatMatrix inputMatrix, int[] permExpts) {
        FloatMatrix permutedMatrix = new FloatMatrix(inputMatrix.getRowDimension(), inputMatrix.getColumnDimension());
        for (int i = 0; i < inputMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < inputMatrix.getColumnDimension(); ++j) {
                permutedMatrix.A[i][j] = inputMatrix.A[i][permExpts[j]];
            }
        }
        return permutedMatrix;
    }

    private FloatMatrix getOneClassPermMatrix(FloatMatrix inputMatrix, boolean[] changeSign) {
        FloatMatrix permutedMatrix = new FloatMatrix(inputMatrix.getRowDimension(), inputMatrix.getColumnDimension());
        for (int i = 0; i < inputMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < inputMatrix.getColumnDimension(); ++j) {
                permutedMatrix.A[i][j] = changeSign[j] ? (float)((double)inputMatrix.A[i][j] - 2.0 * ((double)inputMatrix.A[i][j] - this.oneClassMean)) : inputMatrix.A[i][j];
            }
        }
        return permutedMatrix;
    }

    private int[] permuteWithinPairs(long seed) {
        int[] permutedValues = new int[this.numExps];
        for (int i = 0; i < permutedValues.length; ++i) {
            permutedValues[i] = i;
        }
        Random generator2 = new Random(seed);
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            boolean swap = generator2.nextBoolean();
            if (!swap) continue;
            int temp = permutedValues[this.pairedGroupBExpts[i]];
            permutedValues[this.pairedGroupBExpts[i]] = permutedValues[this.pairedGroupAExpts[i]];
            permutedValues[this.pairedGroupAExpts[i]] = temp;
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return permutedValues;
    }

    private int[] permuteWithinPairsAllPerms(int num) {
        int[] permutedValues = new int[this.numExps];
        for (int i = 0; i < permutedValues.length; ++i) {
            permutedValues[i] = i;
        }
        boolean[] changeSign = this.getChangeSignArrayForAllPairedPerms(num);
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            boolean swap = changeSign[i];
            if (!swap) continue;
            int temp = permutedValues[this.pairedGroupBExpts[i]];
            permutedValues[this.pairedGroupBExpts[i]] = permutedValues[this.pairedGroupAExpts[i]];
            permutedValues[this.pairedGroupAExpts[i]] = temp;
        }
        return permutedValues;
    }

    boolean[] getChangeSignArrayForAllPairedPerms(int num) {
        boolean[] permutArray = new boolean[this.pairedGroupAExpts.length];
        for (int i = 0; i < permutArray.length; ++i) {
            permutArray[i] = false;
        }
        int numPairs = this.pairedGroupAExpts.length;
        String binaryString = Integer.toBinaryString(num);
        char[] binArray = binaryString.toCharArray();
        if (binArray.length < numPairs) {
            int i;
            Vector<Character> binVector = new Vector<Character>();
            for (i = 0; i < numPairs - binArray.length; ++i) {
                binVector.add(new Character('0'));
            }
            for (i = 0; i < binArray.length; ++i) {
                binVector.add(new Character(binArray[i]));
            }
            binArray = new char[binVector.size()];
            for (i = 0; i < binArray.length; ++i) {
                binArray[i] = ((Character)binVector.get(i)).charValue();
            }
        }
        for (int i = 0; i < permutArray.length; ++i) {
            permutArray[i] = binArray[i] == '1';
        }
        return permutArray;
    }

    private int[] getPermutedValues(int arrayLength, int[] validArray) {
        int i;
        int[] permutedValues = new int[arrayLength];
        for (int i2 = 0; i2 < permutedValues.length; ++i2) {
            permutedValues[i2] = i2;
        }
        int[] permutedValidArray = new int[validArray.length];
        for (i = 0; i < validArray.length; ++i) {
            permutedValidArray[i] = validArray[i];
        }
        for (i = permutedValidArray.length; i > 1; --i) {
            Random generator2 = new Random();
            int randVal = generator2.nextInt(i - 1);
            int temp = permutedValidArray[randVal];
            permutedValidArray[randVal] = permutedValidArray[i - 1];
            permutedValidArray[i - 1] = temp;
        }
        for (i = 0; i < validArray.length; ++i) {
            permutedValues[validArray[i]] = permutedValidArray[i];
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return permutedValues;
    }

    private boolean[] getOneClassChangeSignArray(long seed, int[] validExpts) {
        boolean[] changeSignArray = new boolean[this.numExps];
        for (int i = 0; i < changeSignArray.length; ++i) {
            changeSignArray[i] = false;
        }
        Random generator2 = new Random(seed);
        for (int i = 0; i < validExpts.length; ++i) {
            changeSignArray[validExpts[i]] = generator2.nextBoolean();
        }
        return changeSignArray;
    }

    private boolean[] getOneClassChangeSignArrayAllUniquePerms(int num, int[] validExpts) {
        boolean[] changeSignArray = new boolean[this.numExps];
        for (int i = 0; i < changeSignArray.length; ++i) {
            changeSignArray[i] = false;
        }
        int numValidExps = validExpts.length;
        String binaryString = Integer.toBinaryString(num);
        char[] binArray = binaryString.toCharArray();
        if (binArray.length < numValidExps) {
            int i;
            Vector<Character> binVector = new Vector<Character>();
            for (i = 0; i < numValidExps - binArray.length; ++i) {
                binVector.add(new Character('0'));
            }
            for (i = 0; i < binArray.length; ++i) {
                binVector.add(new Character(binArray[i]));
            }
            binArray = new char[binVector.size()];
            for (i = 0; i < binArray.length; ++i) {
                binArray[i] = ((Character)binVector.get(i)).charValue();
            }
        }
        for (int i = 0; i < validExpts.length; ++i) {
            changeSignArray[validExpts[i]] = binArray[i] == '1';
        }
        return changeSignArray;
    }

    private double getMax(double[] array) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(max < array[i])) continue;
            max = array[i];
        }
        return max;
    }

    private double getMin(double[] array) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(min > array[i])) continue;
            min = array[i];
        }
        return min;
    }

    private double rTwoClassUnpaired(int gene, FloatMatrix matrix) {
        int i;
        int groupACount = 0;
        int groupBCount = 0;
        for (i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++groupACount;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++groupBCount;
        }
        float[] groupAValues = new float[groupACount];
        float[] groupBValues = new float[groupBCount];
        groupACount = 0;
        groupBCount = 0;
        for (i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                groupAValues[groupACount] = matrix.A[gene][i];
                ++groupACount;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            groupBValues[groupBCount] = matrix.A[gene][i];
            ++groupBCount;
        }
        double r = this.getMean(groupBValues) - this.getMean(groupAValues);
        return r;
    }

    private double rTwoClassPaired(int gene, FloatMatrix matrix) {
        double zk = 0.0;
        for (int k = 0; k < this.pairedGroupAExpts.length; ++k) {
            zk += (double)(matrix.A[gene][this.pairedGroupBExpts[k]] - matrix.A[gene][this.pairedGroupAExpts[k]]);
        }
        return zk / (double)this.pairedGroupAExpts.length;
    }

    private double rOneClass(int gene, FloatMatrix matrix) {
        int validN = 0;
        double xiBar = 0.0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            ++validN;
            xiBar += (double)matrix.A[gene][i] - this.oneClassMean;
        }
        return xiBar / (double)validN;
    }

    private double rMultiClass(int gene, FloatMatrix matrix) {
        float[] geneValues = new float[matrix.getColumnDimension()];
        for (int i = 0; i < geneValues.length; ++i) {
            geneValues[i] = matrix.A[gene][i];
        }
        int[] groupCounts = this.getGroupCounts();
        double[] xBarIK = this.getXBarIk(geneValues);
        double sigmaNK = 0.0;
        double piNK = 1.0;
        for (int i = 0; i < groupCounts.length; ++i) {
            sigmaNK += (double)groupCounts[i];
            piNK *= (double)groupCounts[i];
        }
        double xBar = this.getMean(geneValues);
        double term2 = 0.0;
        for (int i = 0; i < groupCounts.length; ++i) {
            term2 += (double)groupCounts[i] * Math.pow(xBarIK[i] - xBar, 2.0);
        }
        double r = Math.pow(sigmaNK / piNK * term2, 0.5);
        return r;
    }

    private double sTwoClassPaired(int gene, FloatMatrix matrix) {
        double r = this.rTwoClassPaired(gene, matrix);
        double num = 0.0;
        for (int k = 0; k < this.pairedGroupAExpts.length; ++k) {
            num += Math.pow((double)matrix.A[gene][this.pairedGroupBExpts[k]] - (double)matrix.A[gene][this.pairedGroupAExpts[k]] - r, 2.0);
        }
        int K = this.pairedGroupAExpts.length;
        return Math.sqrt(num / (double)(K * (K - 1)));
    }

    private double sOneClass(int gene, FloatMatrix matrix) {
        double xiBar = this.rOneClass(gene, matrix);
        double sValue = 0.0;
        int validN = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            ++validN;
            sValue += Math.pow((double)matrix.A[gene][i] - xiBar, 2.0);
        }
        return Math.sqrt(sValue / (double)(validN * (validN - 1)));
    }

    private double sMultiClass(int gene, FloatMatrix matrix) {
        float[] geneValues = new float[matrix.getColumnDimension()];
        for (int i = 0; i < geneValues.length; ++i) {
            geneValues[i] = matrix.A[gene][i];
        }
        double[][] geneValuesByGroups = this.getGeneValuesByGroups(geneValues);
        int[] groupCounts = this.getGroupCounts();
        double[] xBarIK = this.getXBarIk(geneValues);
        int sumNkMinusOne = 0;
        for (int i = 0; i < groupCounts.length; ++i) {
            sumNkMinusOne += groupCounts[i] - 1;
        }
        double term1 = 1.0 / (double)sumNkMinusOne;
        double term2 = 0.0;
        for (int i = 0; i < groupCounts.length; ++i) {
            term2 += 1.0 / (double)groupCounts[i];
        }
        double term3 = 0.0;
        for (int k = 0; k < groupCounts.length; ++k) {
            double currentTerm = 0.0;
            for (int j = 0; j < groupCounts[k]; ++j) {
                currentTerm += Math.pow(geneValuesByGroups[k][j] - xBarIK[k], 2.0);
            }
            term3 += currentTerm;
        }
        return Math.pow(term1 * (term2 * term3), 0.5);
    }

    private double rCensoredSurvival(int gene, FloatMatrix matrix) {
        double r = 0.0;
        for (int k = 0; k < this.zkArray.length; ++k) {
            r += this.getXStarIK(gene, matrix, k) - (double)this.dkArray[k] * this.getXBarIK(gene, matrix, k);
        }
        return r;
    }

    private double sCensoredSurvival(int gene, FloatMatrix matrix) {
        double s = 0.0;
        for (int k = 0; k < this.zkArray.length; ++k) {
            double term1 = (double)this.dkArray[k] / (double)this.rkArray[k].length;
            double term2 = 0.0;
            double xBarIK = this.getXBarIK(gene, matrix, k);
            for (int l = 0; l < this.rkArray[k].length; ++l) {
                int currentExp = this.rkArray[k][l];
                term2 += Math.pow((double)matrix.A[gene][currentExp] - xBarIK, 2.0);
            }
            s += term1 * term2;
        }
        return Math.pow(s, 0.5);
    }

    private int[][] getRkArray() {
        int[][] rkArray = new int[this.zkArray.length][];
        for (int i = 0; i < this.zkArray.length; ++i) {
            int j;
            Vector<Integer> currentRkVector = new Vector<Integer>();
            double currentTime = this.zkArray[i];
            for (j = 0; j < this.numExps; ++j) {
                if (!this.inSurvivalAnalysis[j] || !(this.survivalTimes[j] >= currentTime)) continue;
                currentRkVector.add(new Integer(j));
            }
            rkArray[i] = new int[currentRkVector.size()];
            for (j = 0; j < rkArray[i].length; ++j) {
                rkArray[i][j] = (Integer)currentRkVector.get(j);
            }
        }
        return rkArray;
    }

    private double[] getZkArray() {
        Vector<Double> deathTimes = new Vector<Double>();
        for (int i = 0; i < this.survivalTimes.length; ++i) {
            if (!this.inSurvivalAnalysis[i] || this.isCensored[i]) continue;
            deathTimes.add(new Double(this.survivalTimes[i]));
        }
        HashSet s = new HashSet(deathTimes);
        Vector deathTimesSet = new Vector(s);
        double[] zkArray = new double[deathTimesSet.size()];
        for (int i = 0; i < zkArray.length; ++i) {
            zkArray[i] = (Double)deathTimesSet.get(i);
        }
        return zkArray;
    }

    private int[] getDkArray() {
        int[] dkArray = new int[this.zkArray.length];
        for (int i = 0; i < this.zkArray.length; ++i) {
            int counter = 0;
            for (int j = 0; j < this.numExps; ++j) {
                if (!this.inSurvivalAnalysis[j] || this.survivalTimes[j] != this.zkArray[i] || this.isCensored[j]) continue;
                ++counter;
            }
            dkArray[i] = counter;
        }
        return dkArray;
    }

    private double getXStarIK(int gene, FloatMatrix matrix, int k) {
        double x = 0.0;
        double zk = this.zkArray[k];
        for (int i = 0; i < this.inSurvivalAnalysis.length; ++i) {
            if (!this.inSurvivalAnalysis[i] || this.survivalTimes[i] != zk || this.isCensored[i]) continue;
            x += (double)matrix.A[gene][i];
        }
        return x;
    }

    private double getXBarIK(int gene, FloatMatrix matrix, int k) {
        double x = 0.0;
        double zk = this.zkArray[k];
        int mk = this.rkArray[k].length;
        for (int i = 0; i < this.inSurvivalAnalysis.length; ++i) {
            if (!this.inSurvivalAnalysis[i] || !(this.survivalTimes[i] >= zk)) continue;
            x += (double)matrix.A[gene][i];
        }
        return x / (double)mk;
    }

    private double[][] getGeneValuesByGroups(float[] geneValues) {
        int i;
        int[] groupCounts = this.getGroupCounts();
        double[][] geneValuesByGroups = new double[groupCounts.length][];
        for (int i2 = 0; i2 < geneValuesByGroups.length; ++i2) {
            geneValuesByGroups[i2] = new double[groupCounts[i2]];
        }
        int[] groupCounters = new int[groupCounts.length];
        for (i = 0; i < groupCounters.length; ++i) {
            groupCounters[i] = 0;
        }
        for (i = 0; i < this.groupAssignments.length; ++i) {
            int currentGroup = this.groupAssignments[i];
            if (currentGroup == 0) continue;
            geneValuesByGroups[currentGroup - 1][groupCounters[currentGroup - 1]] = geneValues[i];
            int n = currentGroup - 1;
            groupCounters[n] = groupCounters[n] + 1;
        }
        return geneValuesByGroups;
    }

    private double[] getXBarIk(float[] geneValues) {
        int i;
        int[] groupCounts = this.getGroupCounts();
        float[][] geneValuesByGroups = new float[groupCounts.length][];
        for (int i2 = 0; i2 < geneValuesByGroups.length; ++i2) {
            geneValuesByGroups[i2] = new float[groupCounts[i2]];
        }
        int[] groupCounters = new int[groupCounts.length];
        for (i = 0; i < groupCounters.length; ++i) {
            groupCounters[i] = 0;
        }
        for (i = 0; i < this.groupAssignments.length; ++i) {
            int currentGroup = this.groupAssignments[i];
            if (currentGroup == 0) continue;
            geneValuesByGroups[currentGroup - 1][groupCounters[currentGroup - 1]] = geneValues[i];
            int n = currentGroup - 1;
            groupCounters[n] = groupCounters[n] + 1;
        }
        float[] groupMeans = new float[groupCounts.length];
        for (int i3 = 0; i3 < groupMeans.length; ++i3) {
            groupMeans[i3] = this.getMean(geneValuesByGroups[i3]);
        }
        double[] convertedGroupMeans = new double[groupMeans.length];
        for (int i4 = 0; i4 < convertedGroupMeans.length; ++i4) {
            convertedGroupMeans[i4] = groupMeans[i4];
        }
        return convertedGroupMeans;
    }

    private int[] getGroupCounts() {
        int i;
        int[] groupCounts = new int[this.numMultiClassGroups];
        for (i = 0; i < groupCounts.length; ++i) {
            groupCounts[i] = 0;
        }
        for (i = 0; i < this.groupAssignments.length; ++i) {
            int currentGroup = this.groupAssignments[i];
            if (currentGroup == 0) continue;
            int n = currentGroup - 1;
            groupCounts[n] = groupCounts[n] + 1;
        }
        return groupCounts;
    }

    private double sTwoClassUnpaired(int gene, FloatMatrix matrix) {
        int i;
        int groupACount = 0;
        int groupBCount = 0;
        for (i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++groupACount;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++groupBCount;
        }
        float[] groupAValues = new float[groupACount];
        float[] groupBValues = new float[groupBCount];
        groupACount = 0;
        groupBCount = 0;
        for (i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                groupAValues[groupACount] = matrix.A[gene][i];
                ++groupACount;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            groupBValues[groupBCount] = matrix.A[gene][i];
            ++groupBCount;
        }
        int nA = groupAValues.length;
        int nB = groupBValues.length;
        float varA = this.getVar(groupAValues);
        float varB = this.getVar(groupBValues);
        double s = Math.sqrt((1.0f / (float)nA + 1.0f / (float)nB) * (varA + varB) / (float)(nA + nB - 2));
        return s;
    }

    private float getVar(float[] values) {
        float mean = this.getMean(values);
        float var = 0.0f;
        for (int i = 0; i < values.length; ++i) {
            if (Float.isNaN(values[i])) continue;
            float sqDev = (values[i] - mean) * (values[i] - mean);
            var += sqDev;
        }
        return var;
    }

    private double getVar(double[] values) {
        double mean = this.getMean(values);
        double var = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            double sqDev = (values[i] - mean) * (values[i] - mean);
            var += sqDev;
        }
        return var;
    }

    private double[] getQValues() {
        double[] qValues = new double[101];
        qValues[0] = Double.NEGATIVE_INFINITY;
        for (int i = 1; i < qValues.length; ++i) {
            qValues[i] = this.getSAlpha(i);
        }
        return qValues;
    }

    private double getSNought() throws AlgorithmException {
        double sNot = 0.0;
        double[] qValues = this.globalAllQValues;
        double[] alphaArray = new double[101];
        double currentAlpha = 0.0;
        for (int i = 0; i < alphaArray.length; ++i) {
            alphaArray[i] = currentAlpha;
            if (!((currentAlpha += 1.0) > 100.0)) continue;
            currentAlpha = 100.0;
        }
        double[] cvAlphaArray = new double[alphaArray.length];
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, alphaArray.length);
        this.fireValueChanged(event);
        event.setId(2);
        for (int i = 0; i < alphaArray.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            event.setIntValue(i);
            event.setDescription("Calculating S0: Current alpha = " + alphaArray[i]);
            this.fireValueChanged(event);
            cvAlphaArray[i] = this.getCvAlpha(alphaArray[i], qValues);
        }
        QSort sortCvAlphaArray = new QSort(cvAlphaArray);
        sortCvAlphaArray.getSortedDouble();
        int[] sortedCvAlphaArrayIndices = sortCvAlphaArray.getOrigIndx();
        int minAlphaIndex = sortedCvAlphaArrayIndices[0];
        double argminAlpha = alphaArray[minAlphaIndex];
        sNot = this.getSAlpha(argminAlpha);
        this.s0Percentile = argminAlpha;
        return sNot;
    }

    private double getCvAlpha(double alpha, double[] qValues) {
        double[] vjValuesArray = new double[100];
        for (int i = 0; i < vjValuesArray.length; ++i) {
            vjValuesArray[i] = this.getMAD(i + 1, alpha);
        }
        double var = this.getVar(vjValuesArray);
        double mean = this.getMean(vjValuesArray);
        double n = 0.0;
        for (int i = 0; i < vjValuesArray.length; ++i) {
            if (Double.isNaN(vjValuesArray[i])) continue;
            n += 1.0;
        }
        if (n == 1.0) {
            return 0.0;
        }
        if (n == 0.0) {
            return Double.NaN;
        }
        double stdDev = Math.sqrt(var / (n - 1.0));
        return stdDev / mean;
    }

    private double getMAD(int j, double alpha) {
        double[] sValues = this.globalAllSValues;
        double[] qValues = this.globalAllQValues;
        Vector<Vector> validSValuesAndGenes = this.getValidSValuesAndGenes(sValues, qValues, j);
        Vector validSValues = validSValuesAndGenes.get(0);
        Vector validGenes = validSValuesAndGenes.get(1);
        double[] dValues = new double[validSValues.size()];
        for (int i = 0; i < dValues.length; ++i) {
            double currentD;
            int currentGene = (Integer)validGenes.get(i);
            dValues[i] = currentD = this.getDAlpha(currentGene, alpha);
        }
        double medianD = this.getMedian(dValues);
        double[] absDevValues = new double[dValues.length];
        for (int i = 0; i < dValues.length; ++i) {
            absDevValues[i] = Math.abs(dValues[i] - medianD);
        }
        double medianAbsDev = this.getMedian(absDevValues) / 0.6745;
        return medianAbsDev;
    }

    private double getMedian(double[] array) {
        QSort sortArray = new QSort(array);
        double median = 0.0;
        double[] sortedArray = sortArray.getSortedDouble();
        if (sortedArray.length % 2 == 0) {
            double mid2 = sortedArray.length / 2;
            int midIndex2 = (int)Math.round(mid2);
            int midIndex1 = midIndex2 - 1;
            median = (sortedArray[midIndex2] + sortedArray[midIndex1]) / 2.0;
        } else {
            double mid = (double)(sortedArray.length / 2) - 0.5;
            int midIndex = (int)Math.round(mid);
            median = sortedArray[midIndex];
        }
        return median;
    }

    private Vector<Vector> getValidSValuesAndGenes(double[] sValues, double[] qValues, int j) {
        Vector<Vector> validSValuesAndGenes = new Vector<Vector>();
        Vector<Double> validSValues = new Vector<Double>();
        Vector<Integer> validGenes = new Vector<Integer>();
        if (j == 100) {
            for (int i = 0; i < sValues.length; ++i) {
                if (!(sValues[i] >= qValues[j])) continue;
                validSValues.add(new Double(sValues[i]));
                validGenes.add(new Integer(i));
            }
        } else {
            for (int i = 0; i < sValues.length; ++i) {
                if (sValues[i] >= qValues[j] && sValues[i] < qValues[j + 1]) {
                    validSValues.add(new Double(sValues[i]));
                    validGenes.add(new Integer(i));
                    continue;
                }
                if (sValues[i] != qValues[j] || sValues[i] != qValues[j + 1]) continue;
                validSValues.add(new Double(sValues[i]));
                validGenes.add(new Integer(i));
            }
        }
        validSValuesAndGenes.add(validSValues);
        validSValuesAndGenes.add(validGenes);
        return validSValuesAndGenes;
    }

    private double getD(int gene, FloatMatrix matrix) {
        return this.getR(gene, matrix) / (this.getS(gene, matrix) + this.sNought + (double)this.noNaNs);
    }

    private double getDAlpha(int gene, double alpha) {
        return this.getR(gene, this.imputedMatrix) / (this.getS(gene, this.imputedMatrix) + this.getSAlpha(alpha));
    }

    private double getSAlpha(double percentile) {
        double sAlpha = 0.0;
        double[] sortedSValues = this.globalSortedAllSValues;
        int percentileIndex = (int)Math.floor((double)sortedSValues.length * percentile / 100.0) - 1;
        if (percentileIndex < 0) {
            percentileIndex = 0;
        } else if (percentileIndex >= sortedSValues.length) {
            percentileIndex = sortedSValues.length - 1;
        }
        sAlpha = sortedSValues[percentileIndex];
        return sAlpha;
    }

    private double[] getAllSValues() {
        double[] sValues = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            sValues[i] = this.getS(i, this.imputedMatrix);
        }
        return sValues;
    }

    private double getS(int gene, FloatMatrix matrix) {
        double s = 0.0;
        if (this.studyDesign == 4) {
            return this.sTwoClassUnpaired(gene, matrix);
        }
        if (this.studyDesign == 5) {
            return this.sTwoClassPaired(gene, matrix);
        }
        if (this.studyDesign == 6) {
            return this.sMultiClass(gene, matrix);
        }
        if (this.studyDesign == 7) {
            return this.sCensoredSurvival(gene, matrix);
        }
        if (this.studyDesign == 8) {
            return this.sOneClass(gene, matrix);
        }
        return s;
    }

    private double getR(int gene, FloatMatrix matrix) {
        double r = 0.0;
        if (this.studyDesign == 4) {
            return this.rTwoClassUnpaired(gene, matrix);
        }
        if (this.studyDesign == 5) {
            return this.rTwoClassPaired(gene, matrix);
        }
        if (this.studyDesign == 6) {
            return this.rMultiClass(gene, matrix);
        }
        if (this.studyDesign == 7) {
            return this.rCensoredSurvival(gene, matrix);
        }
        if (this.studyDesign == 8) {
            return this.rOneClass(gene, matrix);
        }
        return r;
    }

    private FloatMatrix imputeRowAverageMatrix(FloatMatrix inputMatrix) throws AlgorithmException {
        int numRows = inputMatrix.getRowDimension();
        int numCols = inputMatrix.getColumnDimension();
        FloatMatrix resultMatrix = new FloatMatrix(numRows, numCols);
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(event);
        event.setId(2);
        for (int i = 0; i < numRows; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            event.setIntValue(i);
            event.setDescription("Imputing missing values: Current gene = " + (i + 1));
            this.fireValueChanged(event);
            float[] currentRow = new float[numCols];
            float[] currentOrigRow = new float[numCols];
            for (int j = 0; j < numCols; ++j) {
                currentRow[j] = inputMatrix.A[i][j];
                currentOrigRow[j] = inputMatrix.A[i][j];
            }
            for (int k = 0; k < numCols; ++k) {
                if (!Float.isNaN(inputMatrix.A[i][k])) continue;
                currentRow[k] = this.getMean(currentOrigRow);
            }
            for (int l = 0; l < numCols; ++l) {
                resultMatrix.A[i][l] = currentRow[l];
            }
        }
        return resultMatrix;
    }

    private float getMean(float[] row) {
        float mean = 0.0f;
        int validN = 0;
        for (int i = 0; i < row.length; ++i) {
            if (Float.isNaN(row[i])) continue;
            mean += row[i];
            ++validN;
        }
        if (validN == 0) {
            validN = 1;
        }
        return mean /= (float)validN;
    }

    private double getMean(double[] row) {
        double mean = 0.0;
        int validN = 0;
        for (int i = 0; i < row.length; ++i) {
            if (Double.isNaN(row[i])) continue;
            mean += row[i];
            ++validN;
        }
        if (validN == 0) {
            validN = 1;
        }
        double finalMean = mean / (double)validN;
        return finalMean;
    }

    private FloatMatrix imputeKNearestMatrix(FloatMatrix inputMatrix, int k) throws AlgorithmException {
        int numRows = inputMatrix.getRowDimension();
        int numCols = inputMatrix.getColumnDimension();
        FloatMatrix resultMatrix = new FloatMatrix(numRows, numCols);
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(event);
        event.setId(2);
        for (int i = 0; i < numRows; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            event.setIntValue(i);
            event.setDescription("Imputing missing values: Current gene = " + (i + 1));
            this.fireValueChanged(event);
            if (this.isMissingValues(inputMatrix, i)) {
                Vector<Integer> nonMissingExpts = new Vector<Integer>();
                for (int j = 0; j < numCols; ++j) {
                    if (Float.isNaN(inputMatrix.A[i][j])) continue;
                    nonMissingExpts.add(new Integer(j));
                }
                Vector<Integer> geneSubset = this.getValidGenes(i, inputMatrix, nonMissingExpts);
                Vector<Integer> kNearestGenes = this.getKNearestGenes(i, k, inputMatrix, geneSubset, nonMissingExpts);
                for (int j = 0; j < numCols; ++j) {
                    resultMatrix.A[i][j] = !Float.isNaN(inputMatrix.A[i][j]) ? inputMatrix.A[i][j] : this.getExptWeightedMean(i, j, kNearestGenes, inputMatrix);
                }
                continue;
            }
            for (int j = 0; j < numCols; ++j) {
                resultMatrix.A[i][j] = inputMatrix.A[i][j];
            }
        }
        return this.imputeRowAverageMatrix(resultMatrix);
    }

    private float getExptWeightedMean(int gene, int expt, Vector<Integer> geneVector, FloatMatrix mat) {
        float weightedMean = 0.0f;
        int validN = 0;
        float numerator = 0.0f;
        float[] recipNeighborDistances = new float[geneVector.size()];
        for (int i = 0; i < recipNeighborDistances.length; ++i) {
            int currentGene = geneVector.get(i);
            if (!Float.isNaN(mat.A[currentGene][expt])) {
                float distance = ExperimentUtil.geneEuclidianDistance(mat, null, gene, currentGene, this.factor);
                if (distance == 0.0f) {
                    distance = Float.MIN_VALUE;
                }
                recipNeighborDistances[i] = 1.0f / distance;
                numerator += recipNeighborDistances[i] * mat.A[currentGene][expt];
                ++validN;
                continue;
            }
            recipNeighborDistances[i] = 0.0f;
        }
        float denominator = 0.0f;
        for (int i = 0; i < recipNeighborDistances.length; ++i) {
            denominator += recipNeighborDistances[i];
        }
        weightedMean = numerator / denominator;
        return weightedMean;
    }

    private Vector<Integer> getKNearestGenes(int gene, int k, FloatMatrix mat, Vector<Integer> geneSubset, Vector<Integer> nonMissingExpts) {
        Vector<Integer> allValidGenes = new Vector<Integer>();
        Vector<Integer> nearestGenes = new Vector<Integer>();
        Vector<Float> geneDistances = new Vector<Float>();
        for (int i = 0; i < geneSubset.size(); ++i) {
            int currentGene = geneSubset.get(i);
            if (gene == currentGene) continue;
            float currentDistance = ExperimentUtil.geneEuclidianDistance(mat, null, gene, currentGene, this.factor);
            geneDistances.add(new Float(currentDistance));
            allValidGenes.add(new Integer(currentGene));
        }
        float[] geneDistancesArray = new float[geneDistances.size()];
        for (int i = 0; i < geneDistances.size(); ++i) {
            float currentDist;
            geneDistancesArray[i] = currentDist = ((Float)geneDistances.get(i)).floatValue();
        }
        QSort sortGeneDistances = new QSort(geneDistancesArray);
        sortGeneDistances.getSorted();
        int[] sortedDistanceIndices = sortGeneDistances.getOrigIndx();
        for (int i = 0; i < k; ++i) {
            int currentGeneIndex = sortedDistanceIndices[i];
            int currentNearestGene = (Integer)allValidGenes.get(currentGeneIndex);
            nearestGenes.add(new Integer(currentNearestGene));
        }
        return nearestGenes;
    }

    private boolean isMissingValues(FloatMatrix mat, int row) {
        for (int i = 0; i < mat.getColumnDimension(); ++i) {
            if (!Float.isNaN(mat.A[row][i])) continue;
            return true;
        }
        return false;
    }

    private Vector<Integer> getValidGenes(int gene, FloatMatrix mat, Vector<Integer> validExpts) {
        Vector<Integer> validGenes = new Vector<Integer>();
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            if (!this.hasAllExpts(i, mat, validExpts) || gene == i) continue;
            validGenes.add(new Integer(i));
        }
        if (validGenes.size() < this.numNeighbors) {
            int additionalGenesNeeded = this.numNeighbors - validGenes.size();
            Vector<Integer> additionalGenes = this.getAdditionalGenes(gene, additionalGenesNeeded, validGenes, mat);
            for (int i = 0; i < additionalGenes.size(); ++i) {
                validGenes.add(additionalGenes.get(i));
            }
        }
        return validGenes;
    }

    private Vector<Integer> getAdditionalGenes(int currentGene, int numGenesNeeded, Vector<Integer> alreadyPresentGenes, FloatMatrix mat) {
        Vector<Integer> additionalGenes = new Vector<Integer>();
        Vector<Integer> allGenes = new Vector<Integer>();
        Vector<Float> geneDistances = new Vector<Float>();
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            if (i == currentGene) continue;
            float currentDistance = ExperimentUtil.geneEuclidianDistance(mat, null, i, currentGene, this.factor);
            geneDistances.add(new Float(currentDistance));
            allGenes.add(new Integer(i));
        }
        float[] geneDistancesArray = new float[geneDistances.size()];
        for (int i = 0; i < geneDistances.size(); ++i) {
            float currentDist;
            geneDistancesArray[i] = currentDist = ((Float)geneDistances.get(i)).floatValue();
        }
        QSort sortGeneDistances = new QSort(geneDistancesArray);
        sortGeneDistances.getSorted();
        int[] sortedDistanceIndices = sortGeneDistances.getOrigIndx();
        int counter = 0;
        for (int i = 0; i < sortedDistanceIndices.length; ++i) {
            int currentIndex = sortedDistanceIndices[i];
            int currentNearestGene = (Integer)allGenes.get(currentIndex);
            if (this.belongsIn(alreadyPresentGenes, currentNearestGene)) continue;
            additionalGenes.add(new Integer(currentNearestGene));
            if (++counter >= numGenesNeeded) break;
        }
        return additionalGenes;
    }

    private boolean belongsIn(Vector<Integer> geneVector, int gene) {
        for (int i = 0; i < geneVector.size(); ++i) {
            int currentGene = geneVector.get(i);
            if (gene != currentGene) continue;
            return true;
        }
        return false;
    }

    private boolean hasAllExpts(int gene, FloatMatrix mat, Vector<Integer> validExpts) {
        for (int i = 0; i < validExpts.size(); ++i) {
            int expIndex = validExpts.get(i);
            if (!Float.isNaN(mat.A[gene][expIndex])) continue;
            return false;
        }
        return true;
    }
}

