/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;

public class RP
extends AbstractAlgorithm {
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    private int progress;
    private int totalProgressStep2;
    private FloatMatrix expMatrix;
    private FloatMatrix experimentData;
    private FloatMatrix dataGroupA;
    private FloatMatrix dataGroupB;
    private int[] groupAAss;
    private int[] groupBAss;
    private float alpha;
    private boolean stop = false;
    private int[] inGroupAssignments;
    private int[][] sigGenesArrays;
    double[] rankProductArrayDown;
    double[] rankProductArrayUp;
    private int numGenes;
    private int numExps;
    private float falseProp;
    private boolean drawSigTreesOnly;
    private int numPerms;
    private int falseNum;
    private int correctionMethod;
    private int hcl_function;
    private int upDown;
    private int testDesign;
    private boolean hcl_absolute;
    private boolean hcl_genes_ordered;
    private boolean hcl_samples_ordered;
    private boolean doUp;
    private boolean doDown;
    private float[] qValsDown;
    private float[] qValsUp;
    private float[] pValsDown;
    private float[] pValsUp;
    private AlgorithmEvent event;
    int validN;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        AlgorithmParameters map = data.getParams();
        this.testDesign = map.getInt("classes", 0);
        this.expMatrix = data.getMatrix("experiment");
        if (this.testDesign == 7 || this.testDesign == 8) {
            this.inGroupAssignments = data.getIntArray("group_assignments");
            int q = 0;
            for (int i2 = 0; i2 < this.inGroupAssignments.length; ++i2) {
                if (this.inGroupAssignments[i2] == 0) continue;
                ++q;
            }
            int[] groupAssignments = new int[q];
            q = 0;
            for (i = 0; i < this.inGroupAssignments.length; ++i) {
                if (this.inGroupAssignments[i] == 0) continue;
                groupAssignments[q] = i;
                ++q;
            }
            this.experimentData = this.expMatrix.getMatrix(0, this.expMatrix.getRowDimension() - 1, groupAssignments);
        }
        this.numPerms = map.getInt("numPerms", 0);
        this.upDown = map.getInt("UpOrDown", 0);
        this.doUp = true;
        this.doDown = true;
        if (this.upDown == 1) {
            this.doDown = false;
        }
        if (this.upDown == 2) {
            this.doUp = false;
        }
        if (this.testDesign == 9) {
            this.experimentData = this.expMatrix.getMatrix(0, this.expMatrix.getRowDimension() - 1, data.getIntArray("groupB_paired_assignments")).minus(this.expMatrix.getMatrix(0, this.expMatrix.getRowDimension() - 1, data.getIntArray("groupA_paired_assignments")));
        }
        if (this.testDesign == 8) {
            int i3;
            int r = 0;
            for (i3 = 0; i3 < this.inGroupAssignments.length; ++i3) {
                if (this.inGroupAssignments[i3] != 1) continue;
                ++r;
            }
            this.groupAAss = new int[r];
            r = 0;
            for (i3 = 0; i3 < this.inGroupAssignments.length; ++i3) {
                if (this.inGroupAssignments[i3] != 1) continue;
                this.groupAAss[r] = i3;
                ++r;
            }
            this.dataGroupA = this.expMatrix.getMatrix(0, this.expMatrix.getRowDimension() - 1, this.groupAAss);
            int s = 0;
            for (i = 0; i < this.inGroupAssignments.length; ++i) {
                if (this.inGroupAssignments[i] != 2) continue;
                ++s;
            }
            this.groupBAss = new int[s];
            s = 0;
            for (i = 0; i < this.inGroupAssignments.length; ++i) {
                if (this.inGroupAssignments[i] != 2) continue;
                this.groupBAss[s] = i;
                ++s;
            }
            this.dataGroupB = this.expMatrix.getMatrix(0, this.expMatrix.getRowDimension() - 1, this.groupBAss);
        }
        this.correctionMethod = map.getInt("correction-method");
        if (this.correctionMethod == 5) {
            this.falseNum = map.getInt("falseNum");
        }
        if (this.correctionMethod == 6) {
            this.falseProp = map.getFloat("falseProp");
        }
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        this.hcl_genes_ordered = map.getBoolean("hcl-genes-ordered", false);
        this.hcl_samples_ordered = map.getBoolean("hcl-samples-ordered", false);
        this.numGenes = this.experimentData.getRowDimension();
        this.rankProductArrayDown = new double[this.numGenes];
        this.rankProductArrayUp = new double[this.numGenes];
        this.numExps = this.expMatrix.getColumnDimension();
        this.alpha = map.getFloat("alpha");
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        if (hierarchical_tree) {
            this.drawSigTreesOnly = map.getBoolean("draw-sig-trees-only");
        }
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.progress = 0;
        this.event = null;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Permuting Random Data...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        if (this.testDesign == 7 || this.testDesign == 9) {
            this.runOneClassAlg();
        } else {
            this.runTwoClassAlg();
        }
        for (int i4 = 0; i4 < 3; ++i4) {
            if (this.sigGenesArrays[i4] != null) continue;
            this.sigGenesArrays[i4] = new int[0];
        }
        AlgorithmData result = new AlgorithmData();
        FloatMatrix means = this.getMeans(this.sigGenesArrays);
        FloatMatrix variances = this.getVariances(this.sigGenesArrays, means);
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i5 = 0; i5 < this.sigGenesArrays.length; ++i5) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.sigGenesArrays[i5];
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            if (this.drawSigTreesOnly) {
                if (i5 != 0 && i5 != 1) continue;
                node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
                this.event.setIntValue(i5 + 1);
                this.fireValueChanged(this.event);
                continue;
            }
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            this.event.setIntValue(i5 + 1);
            this.fireValueChanged(this.event);
        }
        if (this.testDesign == 8) {
            result.addMatrix("fold_change", this.getFoldChange());
        }
        result.addIntMatrix("sigGenesArrays", this.sigGenesArrays);
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", "1");
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        result.addMatrix("geneTimeMeansMatrix", this.getAllGeneTimeMeans());
        result.addMatrix("geneTimeSDsMatrix", this.getAllGeneTimeSDs());
        if (this.doDown) {
            result.addMatrix("pValuesDown", this.getPValuesDown());
            result.addMatrix("qValuesDown", this.getQValuesDown());
            result.addMatrix("RPValsDown", this.getRPValsDown());
        }
        if (this.doUp) {
            result.addMatrix("pValuesUp", this.getPValuesUp());
            result.addMatrix("qValuesUp", this.getQValuesUp());
            result.addMatrix("RPValsUp", this.getRPValsUp());
        }
        return result;
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.getSubExperiment(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            data.addParam("optimize-gene-ordering", String.valueOf(this.hcl_genes_ordered));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            data.addParam("optimize-sample-ordering", String.valueOf(this.hcl_samples_ordered));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getMeans(int[][] clusters) {
        if (this.upDown == 3) {
            FloatMatrix means = new FloatMatrix(clusters.length, this.numExps);
            for (int i = 0; i < clusters.length; ++i) {
                FloatMatrix mean = this.getMean(clusters[i]);
                means.A[i] = mean.A[0];
            }
            return means;
        }
        if (this.upDown == 2) {
            FloatMatrix means = new FloatMatrix(2, this.numExps);
            FloatMatrix mean = this.getMean(clusters[0]);
            means.A[0] = mean.A[0];
            mean = this.getMean(clusters[2]);
            means.A[1] = mean.A[0];
            return means;
        }
        if (this.upDown == 1) {
            FloatMatrix means = new FloatMatrix(2, this.numExps);
            FloatMatrix mean = this.getMean(clusters[1]);
            means.A[0] = mean.A[0];
            mean = this.getMean(clusters[2]);
            means.A[1] = mean.A[0];
            return means;
        }
        return null;
    }

    private FloatMatrix getMean(int[] cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.numExps);
        int n = cluster.length;
        int denom = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(Integer.valueOf(cluster[j]).intValue(), i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    private FloatMatrix getVariances(int[][] clustersinit, FloatMatrix means) {
        Object clusters = clustersinit;
        if (this.upDown == 2) {
            clusters = new int[2][];
            clusters[0] = clustersinit[0];
            clusters[1] = clustersinit[2];
        }
        if (this.upDown == 1) {
            clusters = new int[2][];
            clusters[0] = clustersinit[1];
            clusters[1] = clustersinit[2];
        }
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleVariance(int[] cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    private float getSampleNormalizedSum(int[] cluster, int column, float mean) {
        int size = cluster.length;
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(Integer.valueOf(cluster[i]).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float[] getGeneGroupMeans(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[1][];
        for (int i = 0; i < 1; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupMeans = new float[1];
        for (int i = 0; i < 1; ++i) {
            geneGroupMeans[i] = this.getMean(geneValuesByGroups[i]);
        }
        return geneGroupMeans;
    }

    private float[] getGeneGroupSDs(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[1][];
        for (int i = 0; i < 1; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupSDs = new float[1];
        for (int i = 0; i < 1; ++i) {
            geneGroupSDs[i] = this.getStdDev(geneValuesByGroups[i]);
        }
        return geneGroupSDs;
    }

    private float[] getGeneValuesForGroup(float[] geneValues, int group) {
        Vector<Float> groupValuesVector = new Vector<Float>();
        for (int i = 0; i < geneValues.length; ++i) {
            groupValuesVector.add(new Float(geneValues[i]));
        }
        float[] groupGeneValues = new float[groupValuesVector.size()];
        for (int i = 0; i < groupValuesVector.size(); ++i) {
            groupGeneValues[i] = ((Float)groupValuesVector.get(i)).floatValue();
        }
        return groupGeneValues;
    }

    private FloatMatrix getAllGeneTimeMeans() {
        FloatMatrix means = new FloatMatrix(this.numGenes, 1);
        for (int i = 0; i < means.getRowDimension(); ++i) {
            means.A[i] = this.getGeneGroupMeans(i);
        }
        return means;
    }

    private FloatMatrix getAllGeneTimeSDs() {
        FloatMatrix sds = new FloatMatrix(this.numGenes, 1);
        for (int i = 0; i < sds.getRowDimension(); ++i) {
            sds.A[i] = this.getGeneGroupSDs(i);
        }
        return sds;
    }

    private FloatMatrix getPValuesDown() {
        FloatMatrix pvals = new FloatMatrix(this.numGenes, 1);
        for (int i = 0; i < pvals.getRowDimension(); ++i) {
            pvals.A[i][0] = this.pValsDown[i];
        }
        return pvals;
    }

    private FloatMatrix getQValuesDown() {
        FloatMatrix pvals = new FloatMatrix(this.numGenes, 1);
        for (int i = 0; i < pvals.getRowDimension(); ++i) {
            pvals.A[i][0] = this.qValsDown[i];
        }
        return pvals;
    }

    private FloatMatrix getRPValsUp() {
        FloatMatrix rpvals = new FloatMatrix(this.numGenes, 1);
        for (int i = 0; i < rpvals.getRowDimension(); ++i) {
            Double db = new Double(this.rankProductArrayUp[i]);
            rpvals.A[i][0] = db.floatValue();
        }
        return rpvals;
    }

    private FloatMatrix getRPValsDown() {
        FloatMatrix rpvals = new FloatMatrix(this.numGenes, 1);
        for (int i = 0; i < rpvals.getRowDimension(); ++i) {
            Double db = new Double(this.rankProductArrayDown[i]);
            rpvals.A[i][0] = db.floatValue();
        }
        return rpvals;
    }

    private FloatMatrix getPValuesUp() {
        FloatMatrix pvals = new FloatMatrix(this.numGenes, 1);
        for (int i = 0; i < pvals.getRowDimension(); ++i) {
            pvals.A[i][0] = this.pValsUp[i];
        }
        return pvals;
    }

    private FloatMatrix getQValuesUp() {
        FloatMatrix pvals = new FloatMatrix(this.numGenes, 1);
        for (int i = 0; i < pvals.getRowDimension(); ++i) {
            pvals.A[i][0] = this.qValsUp[i];
        }
        return pvals;
    }

    private float getMean(float[] group) {
        float sum = 0.0f;
        int n = 0;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sum += group[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float mean = sum / (float)n;
        if (Float.isInfinite(mean)) {
            return Float.NaN;
        }
        return mean;
    }

    private float getStdDev(float[] group) {
        float mean = this.getMean(group);
        int n = 0;
        float sumSquares = 0.0f;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sumSquares = (float)((double)sumSquares + Math.pow(group[i] - mean, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float var = sumSquares / (float)(n - 1);
        if (Float.isInfinite(var)) {
            return Float.NaN;
        }
        return (float)Math.sqrt(var);
    }

    public void runOneClassAlg() {
        int i;
        int i2;
        int counters;
        int i3;
        int rankTotal;
        int i4;
        int c;
        int h;
        int j;
        int i5;
        double[][] adata = new double[this.experimentData.getColumnDimension()][this.experimentData.getRowDimension()];
        for (int i6 = 0; i6 < this.experimentData.getColumnDimension(); ++i6) {
            for (int j2 = 0; j2 < this.experimentData.getRowDimension(); ++j2) {
                adata[i6][j2] = this.experimentData.get(j2, i6);
            }
        }
        double[] rankArray = new double[adata[0].length];
        for (i5 = 0; i5 < rankArray.length; ++i5) {
            rankArray[i5] = i5;
        }
        for (i5 = 0; i5 < adata.length; ++i5) {
            ExperimentUtil.sort2(adata[i5], rankArray);
            for (int j3 = 0; j3 < adata[i5].length; ++j3) {
                adata[i5][j3] = (double)j3 + 1.0;
            }
            ExperimentUtil.sort2(rankArray, adata[i5]);
        }
        this.rankProductArrayDown = new double[rankArray.length];
        this.rankProductArrayUp = new double[rankArray.length];
        for (i5 = 0; i5 < this.rankProductArrayDown.length; ++i5) {
            int j4;
            double rankProductDown = 1.0;
            double rankProductUp = 1.0;
            if (this.doDown) {
                for (j4 = 0; j4 < adata.length; ++j4) {
                    rankProductDown *= adata[j4][i5];
                }
                this.rankProductArrayDown[i5] = Math.pow(rankProductDown, 1.0 / (double)adata.length);
                rankProductDown = 1.0;
            }
            if (!this.doUp) continue;
            for (j4 = 0; j4 < adata.length; ++j4) {
                rankProductUp *= (double)(adata[j4].length + 1) - adata[j4][i5];
            }
            this.rankProductArrayUp[i5] = Math.pow(rankProductUp, 1.0 / (double)adata.length);
            rankProductUp = 1.0;
        }
        double[][] rankProductMatrix = new double[this.numPerms][adata[0].length];
        for (int permutations = 0; permutations < this.numPerms && !this.stop; ++permutations) {
            int i7;
            this.updateProgressBar();
            int[][] intRanksMatrix = new int[adata.length][];
            int[][] permutedRanksMatrix = new int[adata.length][];
            for (i7 = 0; i7 < adata.length; ++i7) {
                intRanksMatrix[i7] = new int[adata[i7].length];
                permutedRanksMatrix[i7] = new int[adata[i7].length];
                for (int j5 = 0; j5 < adata[i7].length; ++j5) {
                    intRanksMatrix[i7][j5] = (int)adata[i7][j5] - 1;
                }
            }
            for (i7 = 0; i7 < adata.length; ++i7) {
                permutedRanksMatrix[i7] = RP.getPermutedValues(adata[i7].length, intRanksMatrix[i7]);
            }
            for (i7 = 0; i7 < rankProductMatrix[permutations].length; ++i7) {
                double permutedRankProduct = 1.0;
                for (j = 0; j < adata.length; ++j) {
                    permutedRankProduct *= (double)(permutedRanksMatrix[j][i7] + 1);
                }
                rankProductMatrix[permutations][i7] = Math.pow(permutedRankProduct, 1.0 / (double)adata.length);
                permutedRankProduct = 1.0;
            }
            Arrays.sort(rankProductMatrix[permutations]);
        }
        this.event.setDescription("Finding q-values");
        this.progress = 0;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Finding q-values...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        double[] expectedPDown = new double[adata[0].length];
        double[] expectedPUp = new double[adata[0].length];
        int totalC = 0;
        this.totalProgressStep2 = expectedPDown.length;
        if (this.doDown) {
            this.event = new AlgorithmEvent((Object)this, 1, 100, "Finding Down Regulated q-values...");
            this.event.setId(2);
            this.event.setIntValue(0);
            for (h = 0; h < expectedPDown.length; ++h) {
                totalC = 0;
                this.updateProgressBar2();
                for (int i8 = 0; i8 < rankProductMatrix.length; ++i8) {
                    c = -Arrays.binarySearch(rankProductMatrix[i8], this.rankProductArrayDown[h]) - 1;
                    if (c < 0) {
                        c = Arrays.binarySearch(rankProductMatrix[i8], this.rankProductArrayDown[h]);
                    }
                    totalC += c;
                }
                expectedPDown[h] = (double)totalC / (double)this.numPerms;
            }
        }
        if (this.doUp) {
            this.event = new AlgorithmEvent((Object)this, 1, 100, "Finding Up Regulated q-values...");
            this.progress = 0;
            this.event.setId(2);
            this.event.setIntValue(0);
            for (h = 0; h < expectedPUp.length; ++h) {
                totalC = 0;
                this.updateProgressBar2();
                for (int i9 = 0; i9 < rankProductMatrix.length; ++i9) {
                    c = -Arrays.binarySearch(rankProductMatrix[i9], this.rankProductArrayUp[h]) - 1;
                    if (c < 0) {
                        c = Arrays.binarySearch(rankProductMatrix[i9], this.rankProductArrayUp[h]);
                    }
                    totalC += c;
                }
                expectedPUp[h] = (double)totalC / (double)this.numPerms;
            }
        }
        this.sigGenesArrays = new int[3][];
        if (this.doDown) {
            double[] qValuesDown = new double[expectedPDown.length];
            int[] rankg = new int[expectedPDown.length];
            this.event = new AlgorithmEvent((Object)this, 1, 100, "Determining Down Regulated False Discovery Rate...");
            this.progress = 0;
            this.event.setId(2);
            this.event.setIntValue(0);
            double[] sortedPDown = new double[expectedPDown.length];
            for (i4 = 0; i4 < expectedPDown.length; ++i4) {
                sortedPDown[i4] = expectedPDown[i4];
            }
            Arrays.sort(sortedPDown);
            for (i4 = 0; i4 < qValuesDown.length && !this.stop; ++i4) {
                this.updateProgressBar2();
                rankg[i4] = rankTotal = Arrays.binarySearch(sortedPDown, expectedPDown[i4]) + 1;
            }
            for (i4 = 0; i4 < qValuesDown.length; ++i4) {
                qValuesDown[i4] = expectedPDown[i4] / (double)rankg[i4];
            }
            this.qValsDown = new float[qValuesDown.length];
            for (i4 = 0; i4 < this.qValsDown.length; ++i4) {
                this.qValsDown[i4] = (float)qValuesDown[i4];
            }
            this.pValsDown = new float[qValuesDown.length];
            for (i4 = 0; i4 < this.pValsDown.length; ++i4) {
                this.pValsDown[i4] = (float)expectedPDown[i4] / (float)this.numGenes;
            }
            int sigGenesDownCounter = 0;
            if (this.correctionMethod == 1) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(this.pValsDown[i3] <= this.alpha)) continue;
                    ++sigGenesDownCounter;
                }
            }
            if (this.correctionMethod == 6) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(this.qValsDown[i3] <= this.falseProp)) continue;
                    ++sigGenesDownCounter;
                }
            }
            if (this.correctionMethod == 5) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(expectedPDown[i3] <= (double)this.falseNum)) continue;
                    ++sigGenesDownCounter;
                }
            }
            this.sigGenesArrays[0] = new int[sigGenesDownCounter];
            counters = 0;
            if (this.correctionMethod == 1) {
                for (i2 = 0; i2 < rankg.length; ++i2) {
                    if (!(this.pValsDown[i2] <= this.alpha)) continue;
                    this.sigGenesArrays[0][counters] = i2;
                    ++counters;
                }
            }
            if (this.correctionMethod == 6) {
                for (i2 = 0; i2 < rankg.length; ++i2) {
                    if (!(qValuesDown[i2] <= (double)this.falseProp)) continue;
                    this.sigGenesArrays[0][counters] = i2;
                    ++counters;
                }
            }
            if (this.correctionMethod == 5) {
                for (i2 = 0; i2 < rankg.length; ++i2) {
                    if (!(expectedPDown[i2] <= (double)this.falseNum)) continue;
                    this.sigGenesArrays[0][counters] = i2;
                    ++counters;
                }
            }
        }
        if (this.doUp) {
            double[] qValuesUp = new double[expectedPUp.length];
            int[] rankg = new int[expectedPUp.length];
            this.event = new AlgorithmEvent((Object)this, 1, 100, "Determining Up Regulated False Discovery Rate...");
            this.progress = 0;
            this.event.setId(2);
            this.event.setIntValue(0);
            double[] sortedPUp = new double[expectedPUp.length];
            for (i4 = 0; i4 < expectedPUp.length; ++i4) {
                sortedPUp[i4] = expectedPUp[i4];
            }
            Arrays.sort(sortedPUp);
            for (i4 = 0; i4 < qValuesUp.length && !this.stop; ++i4) {
                this.updateProgressBar2();
                rankg[i4] = rankTotal = Arrays.binarySearch(sortedPUp, expectedPUp[i4]) + 1;
            }
            for (i4 = 0; i4 < qValuesUp.length; ++i4) {
                qValuesUp[i4] = expectedPUp[i4] / (double)rankg[i4];
            }
            this.qValsUp = new float[qValuesUp.length];
            for (i4 = 0; i4 < this.qValsUp.length; ++i4) {
                this.qValsUp[i4] = (float)qValuesUp[i4];
            }
            this.pValsUp = new float[qValuesUp.length];
            for (i4 = 0; i4 < this.pValsUp.length; ++i4) {
                this.pValsUp[i4] = (float)expectedPUp[i4] / (float)this.numGenes;
            }
            int sigGenesUpCounter = 0;
            if (this.correctionMethod == 1) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(this.pValsUp[i3] <= this.alpha)) continue;
                    ++sigGenesUpCounter;
                }
            }
            if (this.correctionMethod == 6) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(this.qValsUp[i3] <= this.falseProp)) continue;
                    ++sigGenesUpCounter;
                }
            }
            if (this.correctionMethod == 5) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(expectedPUp[i3] <= (double)this.falseNum)) continue;
                    ++sigGenesUpCounter;
                }
            }
            this.sigGenesArrays[1] = new int[sigGenesUpCounter];
            counters = 0;
            if (this.correctionMethod == 1) {
                for (i2 = 0; i2 < rankg.length; ++i2) {
                    if (!(this.pValsUp[i2] <= this.alpha)) continue;
                    this.sigGenesArrays[1][counters] = i2;
                    ++counters;
                }
            }
            if (this.correctionMethod == 6) {
                for (i2 = 0; i2 < rankg.length; ++i2) {
                    if (!(qValuesUp[i2] <= (double)this.falseProp)) continue;
                    this.sigGenesArrays[1][counters] = i2;
                    ++counters;
                }
            }
            if (this.correctionMethod == 5) {
                for (i2 = 0; i2 < rankg.length; ++i2) {
                    if (!(expectedPUp[i2] <= (double)this.falseNum)) continue;
                    this.sigGenesArrays[1][counters] = i2;
                    ++counters;
                }
            }
        }
        ArrayList<Integer> insigGenes = new ArrayList<Integer>();
        for (i = 0; i < rankArray.length; ++i) {
            boolean cont = false;
            if (this.doDown) {
                for (j = 0; j < this.sigGenesArrays[0].length; ++j) {
                    if (i != this.sigGenesArrays[0][j]) continue;
                    cont = true;
                }
            }
            if (this.doUp) {
                for (j = 0; j < this.sigGenesArrays[1].length; ++j) {
                    if (i != this.sigGenesArrays[1][j]) continue;
                    cont = true;
                }
            }
            if (cont) continue;
            insigGenes.add(i);
        }
        this.sigGenesArrays[2] = new int[insigGenes.size()];
        for (i = 0; i < this.sigGenesArrays[2].length; ++i) {
            this.sigGenesArrays[2][i] = (Integer)insigGenes.get(i);
        }
    }

    public void runTwoClassAlg() {
        int i;
        int i2;
        int i3;
        int i4;
        int numOfPairs = this.dataGroupA.getColumnDimension() * this.dataGroupB.getColumnDimension();
        int numGroupA = this.dataGroupA.getColumnDimension();
        int numGroupB = this.dataGroupB.getColumnDimension();
        double[][] adata = new double[numOfPairs][this.numGenes];
        int col = 0;
        for (int i5 = 0; i5 < numGroupA; ++i5) {
            for (int j = 0; j < numGroupB; ++j) {
                for (int k = 0; k < this.numGenes; ++k) {
                    adata[col][k] = this.dataGroupB.get(k, j) - this.dataGroupA.get(k, i5);
                }
                ++col;
            }
        }
        double[] rankArray = new double[this.numGenes];
        for (i4 = 0; i4 < rankArray.length; ++i4) {
            rankArray[i4] = i4;
        }
        for (i4 = 0; i4 < adata.length; ++i4) {
            ExperimentUtil.sort2(adata[i4], rankArray);
            for (int j = 0; j < adata[i4].length; ++j) {
                adata[i4][j] = (double)j + 1.0;
            }
            ExperimentUtil.sort2(rankArray, adata[i4]);
        }
        for (i4 = 0; i4 < this.numGenes; ++i4) {
            double[] rankProductDownArrayTemp = new double[numGroupA];
            for (int num = 0; num < numGroupA; ++num) {
                rankProductDownArrayTemp[num] = 1.0;
            }
            if (this.doDown) {
                int sampleNum = 0;
                for (int a = 0; a < numGroupA; ++a) {
                    for (int b = 0; b < numGroupB; ++b) {
                        rankProductDownArrayTemp[a] = rankProductDownArrayTemp[a] * adata[sampleNum][i4] / (double)this.numGenes;
                        ++sampleNum;
                    }
                    rankProductDownArrayTemp[a] = Math.pow(rankProductDownArrayTemp[a], 1.0f / (float)numGroupB);
                }
                double rankProductDownTemp = 1.0;
                for (int c = 0; c < rankProductDownArrayTemp.length; ++c) {
                    rankProductDownTemp = rankProductDownArrayTemp[c] * rankProductDownTemp;
                }
                this.rankProductArrayDown[i4] = (double)this.numGenes * Math.pow(rankProductDownTemp, 1.0f / (float)rankProductDownArrayTemp.length);
            }
            double[] rankProductUpArrayTemp = new double[numGroupA];
            for (int num = 0; num < numGroupA; ++num) {
                rankProductUpArrayTemp[num] = 1.0;
            }
            if (!this.doUp) continue;
            int sampleNum = 0;
            for (int a = 0; a < numGroupA; ++a) {
                for (int b = 0; b < numGroupB; ++b) {
                    rankProductUpArrayTemp[a] = rankProductUpArrayTemp[a] * ((double)(adata[sampleNum].length + 1) - adata[sampleNum][i4]) / (double)this.numGenes;
                    ++sampleNum;
                }
                rankProductUpArrayTemp[a] = Math.pow(rankProductUpArrayTemp[a], 1.0f / (float)numGroupB);
            }
            double rankProductUpTemp = 1.0;
            for (int c = 0; c < rankProductUpArrayTemp.length; ++c) {
                rankProductUpTemp = rankProductUpArrayTemp[c] * rankProductUpTemp;
            }
            this.rankProductArrayUp[i4] = (double)this.numGenes * Math.pow(rankProductUpTemp, 1.0f / (float)rankProductUpArrayTemp.length);
        }
        double[] trynewarray = new double[this.numGenes * this.numPerms];
        int ind = 0;
        for (int perm = 0; perm < this.numPerms && !this.stop; ++perm) {
            double[][] randPairs = new double[numOfPairs][this.numGenes];
            float[][] groupARand = new float[this.dataGroupA.getColumnDimension()][this.numGenes];
            float[][] groupBRand = new float[this.dataGroupB.getColumnDimension()][this.numGenes];
            this.updateProgressBar();
            FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix);
            groupARand = permutedMatrix.getMatrix((int)0, (int)(permutedMatrix.getRowDimension() - 1), (int[])this.groupAAss).A;
            groupBRand = permutedMatrix.getMatrix((int)0, (int)(permutedMatrix.getRowDimension() - 1), (int[])this.groupBAss).A;
            int x = 0;
            for (int i6 = 0; i6 < groupARand[0].length; ++i6) {
                for (int j = 0; j < groupBRand[0].length; ++j) {
                    for (int g = 0; g < this.numGenes; ++g) {
                        randPairs[x][g] = groupBRand[g][j] - groupARand[g][i6];
                    }
                    ++x;
                }
            }
            double[] order = new double[this.numGenes];
            for (i3 = 0; i3 < order.length; ++i3) {
                order[i3] = i3;
            }
            for (i3 = 0; i3 < numOfPairs; ++i3) {
                ExperimentUtil.sort2(randPairs[i3], order);
                for (int j = 0; j < this.numGenes; ++j) {
                    randPairs[i3][j] = (double)j + 1.0;
                }
                ExperimentUtil.sort2(order, randPairs[i3]);
            }
            for (i3 = 0; i3 < this.numGenes; ++i3) {
                double[] rankProductDownArrayTemp = new double[numGroupA];
                for (int num = 0; num < numGroupA; ++num) {
                    rankProductDownArrayTemp[num] = 1.0;
                }
                int sampleNum = 0;
                for (int a = 0; a < numGroupA; ++a) {
                    for (int b = 0; b < numGroupB; ++b) {
                        rankProductDownArrayTemp[a] = rankProductDownArrayTemp[a] * randPairs[sampleNum][i3] / (double)this.numGenes;
                        ++sampleNum;
                    }
                    rankProductDownArrayTemp[a] = Math.pow(rankProductDownArrayTemp[a], 1.0f / (float)numGroupB);
                }
                double rankProductDownTemp = 1.0;
                for (int c = 0; c < rankProductDownArrayTemp.length; ++c) {
                    rankProductDownTemp = rankProductDownArrayTemp[c] * rankProductDownTemp;
                }
                trynewarray[ind] = (double)this.numGenes * Math.pow(rankProductDownTemp, 1.0f / (float)rankProductDownArrayTemp.length);
                ++ind;
            }
        }
        Arrays.sort(trynewarray);
        this.event.setDescription("Finding q-values");
        this.progress = 0;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Finding q-values...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        double[] expectedPDown = new double[this.numGenes];
        double[] expectedPUp = new double[this.numGenes];
        this.totalProgressStep2 = expectedPDown.length;
        if (this.doDown) {
            this.event = new AlgorithmEvent((Object)this, 1, 100, "Finding Down Regulated q-values...");
            this.event.setId(2);
            this.event.setIntValue(0);
            for (int h = 0; h < this.numGenes; ++h) {
                this.updateProgressBar2();
                int c = -Arrays.binarySearch(trynewarray, this.rankProductArrayDown[h]) - 1;
                if (c < 0) {
                    c = Arrays.binarySearch(trynewarray, this.rankProductArrayDown[h]);
                }
                expectedPDown[h] = (double)c / (double)this.numPerms;
            }
        }
        if (this.doUp) {
            this.event = new AlgorithmEvent((Object)this, 1, 100, "Finding Up Regulated q-values...");
            this.progress = 0;
            this.event.setId(2);
            this.event.setIntValue(0);
            for (int h = 0; h < this.numGenes; ++h) {
                this.updateProgressBar2();
                int c = -Arrays.binarySearch(trynewarray, this.rankProductArrayUp[h]) - 1;
                if (c < 0) {
                    c = Arrays.binarySearch(trynewarray, this.rankProductArrayUp[h]);
                }
                expectedPUp[h] = (double)c / (double)this.numPerms;
            }
        }
        this.sigGenesArrays = new int[3][];
        if (this.doDown) {
            double[] qValuesDown = new double[this.numGenes];
            int[] rankg = new int[this.numGenes];
            this.event = new AlgorithmEvent((Object)this, 1, 100, "Determining Down Regulated False Discovery Rate...");
            this.progress = 0;
            this.event.setId(2);
            this.event.setIntValue(0);
            double[] sortedPDown = new double[this.numGenes];
            for (i2 = 0; i2 < this.numGenes; ++i2) {
                sortedPDown[i2] = expectedPDown[i2];
            }
            Arrays.sort(sortedPDown);
            i2 = 0;
            while (i2 < this.numGenes && !this.stop) {
                this.updateProgressBar2();
                rankg[i2] = -Arrays.binarySearch(sortedPDown, expectedPDown[i2] + 1.0E-6) - 1;
                if (rankg[i2] < 0) {
                    rankg[i2] = Arrays.binarySearch(sortedPDown, expectedPDown[i2] + 1.0E-6);
                }
                int n = i2++;
                rankg[n] = rankg[n] + 1;
            }
            for (i2 = 0; i2 < this.numGenes; ++i2) {
                qValuesDown[i2] = expectedPDown[i2] / (double)rankg[i2];
            }
            this.qValsDown = new float[this.numGenes];
            for (i2 = 0; i2 < this.qValsDown.length; ++i2) {
                this.qValsDown[i2] = (float)qValuesDown[i2];
            }
            this.pValsDown = new float[this.numGenes];
            for (i2 = 0; i2 < this.pValsDown.length; ++i2) {
                this.pValsDown[i2] = (float)expectedPDown[i2] / (float)this.numGenes;
            }
            int sigGenesDownCounter = 0;
            if (this.correctionMethod == 1) {
                for (int i7 = 0; i7 < rankg.length; ++i7) {
                    if (!(this.pValsDown[i7] <= this.alpha)) continue;
                    ++sigGenesDownCounter;
                }
            }
            if (this.correctionMethod == 6) {
                for (int i8 = 0; i8 < rankg.length; ++i8) {
                    if (!(this.qValsDown[i8] <= this.falseProp)) continue;
                    ++sigGenesDownCounter;
                }
            }
            if (this.correctionMethod == 5) {
                for (int i9 = 0; i9 < rankg.length; ++i9) {
                    if (!(expectedPDown[i9] <= (double)this.falseNum)) continue;
                    ++sigGenesDownCounter;
                }
            }
            this.sigGenesArrays[0] = new int[sigGenesDownCounter];
            int counters = 0;
            if (this.correctionMethod == 1) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(this.pValsDown[i3] <= this.alpha)) continue;
                    this.sigGenesArrays[0][counters] = i3;
                    ++counters;
                }
            }
            if (this.correctionMethod == 6) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(qValuesDown[i3] <= (double)this.falseProp)) continue;
                    this.sigGenesArrays[0][counters] = i3;
                    ++counters;
                }
            }
            if (this.correctionMethod == 5) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(expectedPDown[i3] <= (double)this.falseNum)) continue;
                    this.sigGenesArrays[0][counters] = i3;
                    ++counters;
                }
            }
        }
        if (this.doUp) {
            double[] qValuesUp = new double[expectedPUp.length];
            int[] rankg = new int[expectedPUp.length];
            this.event = new AlgorithmEvent((Object)this, 1, 100, "Determining Up Regulated False Discovery Rate...");
            this.progress = 0;
            this.event.setId(2);
            this.event.setIntValue(0);
            double[] sortedPUp = new double[expectedPUp.length];
            for (i2 = 0; i2 < expectedPUp.length; ++i2) {
                sortedPUp[i2] = expectedPUp[i2];
            }
            Arrays.sort(sortedPUp);
            i2 = 0;
            while (i2 < qValuesUp.length && !this.stop) {
                this.updateProgressBar2();
                rankg[i2] = -Arrays.binarySearch(sortedPUp, expectedPUp[i2] - 1.0E-6) - 1;
                if (rankg[i2] < 0) {
                    rankg[i2] = Arrays.binarySearch(sortedPUp, expectedPUp[i2] - 1.0E-6);
                }
                int n = i2++;
                rankg[n] = rankg[n] + 1;
            }
            for (i2 = 0; i2 < qValuesUp.length; ++i2) {
                qValuesUp[i2] = expectedPUp[i2] / (double)rankg[i2];
            }
            this.qValsUp = new float[qValuesUp.length];
            for (i2 = 0; i2 < this.qValsUp.length; ++i2) {
                this.qValsUp[i2] = (float)qValuesUp[i2];
            }
            this.pValsUp = new float[qValuesUp.length];
            for (i2 = 0; i2 < this.pValsUp.length; ++i2) {
                this.pValsUp[i2] = (float)expectedPUp[i2] / (float)this.numGenes;
            }
            int sigGenesUpCounter = 0;
            if (this.correctionMethod == 1) {
                for (int i10 = 0; i10 < rankg.length; ++i10) {
                    if (!(this.pValsUp[i10] <= this.alpha)) continue;
                    ++sigGenesUpCounter;
                }
            }
            if (this.correctionMethod == 6) {
                for (int i11 = 0; i11 < rankg.length; ++i11) {
                    if (!(this.qValsUp[i11] <= this.falseProp)) continue;
                    ++sigGenesUpCounter;
                }
            }
            if (this.correctionMethod == 5) {
                for (int i12 = 0; i12 < rankg.length; ++i12) {
                    if (!(expectedPUp[i12] <= (double)this.falseNum)) continue;
                    ++sigGenesUpCounter;
                }
            }
            this.sigGenesArrays[1] = new int[sigGenesUpCounter];
            int counters = 0;
            if (this.correctionMethod == 1) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(this.pValsUp[i3] <= this.alpha)) continue;
                    this.sigGenesArrays[1][counters] = i3;
                    ++counters;
                }
            }
            if (this.correctionMethod == 6) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(this.qValsUp[i3] <= this.falseProp)) continue;
                    this.sigGenesArrays[1][counters] = i3;
                    ++counters;
                }
            }
            if (this.correctionMethod == 5) {
                for (i3 = 0; i3 < rankg.length; ++i3) {
                    if (!(expectedPUp[i3] <= (double)this.falseNum)) continue;
                    this.sigGenesArrays[1][counters] = i3;
                    ++counters;
                }
            }
        }
        ArrayList<Integer> insigGenes = new ArrayList<Integer>();
        for (i = 0; i < rankArray.length; ++i) {
            int j;
            boolean cont = false;
            if (this.doDown) {
                for (j = 0; j < this.sigGenesArrays[0].length; ++j) {
                    if (i != this.sigGenesArrays[0][j]) continue;
                    cont = true;
                }
            }
            if (this.doUp) {
                for (j = 0; j < this.sigGenesArrays[1].length; ++j) {
                    if (i != this.sigGenesArrays[1][j]) continue;
                    cont = true;
                }
            }
            if (cont) continue;
            insigGenes.add(i);
        }
        this.sigGenesArrays[2] = new int[insigGenes.size()];
        for (i = 0; i < this.sigGenesArrays[2].length; ++i) {
            this.sigGenesArrays[2][i] = (Integer)insigGenes.get(i);
        }
    }

    protected FloatMatrix getPermutedMatrix(FloatMatrix inputMatrix) {
        int[] validArray = new int[this.numGenes];
        for (int j = 0; j < validArray.length; ++j) {
            validArray[j] = j;
        }
        FloatMatrix permutedMatrix = new FloatMatrix(inputMatrix.getRowDimension(), inputMatrix.getColumnDimension());
        for (int i = 0; i < inputMatrix.getColumnDimension(); ++i) {
            int[] permGenes = RP.getPermutedValues(this.numGenes, validArray);
            for (int j = 0; j < inputMatrix.getRowDimension(); ++j) {
                permutedMatrix.A[j][i] = inputMatrix.A[permGenes[j]][i];
            }
        }
        return permutedMatrix;
    }

    protected static int[] getPermutedValues(int arrayLength, int[] validArray) {
        int i;
        int[] permutedValues = new int[arrayLength];
        for (int i2 = 0; i2 < permutedValues.length; ++i2) {
            permutedValues[i2] = i2;
        }
        int[] permutedValidArray = new int[validArray.length];
        for (i = 0; i < validArray.length; ++i) {
            permutedValidArray[i] = validArray[i];
        }
        for (i = permutedValidArray.length; i > 1; --i) {
            Random generator2 = new Random();
            int randVal = generator2.nextInt(i - 1);
            int temp = permutedValidArray[randVal];
            permutedValidArray[randVal] = permutedValidArray[i - 1];
            permutedValidArray[i - 1] = temp;
        }
        for (i = 0; i < validArray.length; ++i) {
            permutedValues[validArray[i]] = permutedValidArray[i];
        }
        return permutedValues;
    }

    private void updateProgressBar() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / this.numPerms);
        this.fireValueChanged(this.event);
    }

    private void updateProgressBar2() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / this.totalProgressStep2);
        this.fireValueChanged(this.event);
    }

    private FloatMatrix getFoldChange() {
        FloatMatrix fm = new FloatMatrix(this.numGenes, 1);
        for (int g = 0; g < this.numGenes; ++g) {
            int i;
            float[] groupA = new float[this.dataGroupA.getColumnDimension()];
            float[] groupB = new float[this.dataGroupB.getColumnDimension()];
            for (i = 0; i < groupA.length; ++i) {
                groupA[i] = this.dataGroupA.get(g, i);
            }
            for (i = 0; i < groupB.length; ++i) {
                groupB[i] = this.dataGroupB.get(g, i);
            }
            Double db = Math.pow(2.0, this.getMean(groupA) - this.getMean(groupB));
            fm.A[g][0] = db.floatValue();
        }
        return fm;
    }

    public static void main(String[] args) {
        int[] array = new int[]{0, 1};
        for (int i = 0; i < array.length; ++i) {
            System.out.print(array[i] + "\t");
        }
        System.out.println(":" + array.length);
        int[] result = RP.getPermutedValues(array.length, array);
        for (int i = 0; i < result.length; ++i) {
            System.out.print(result[i] + "\t");
        }
    }
}

