/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Arrays;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.PermutationTest;
import org.tigr.microarray.mev.cluster.algorithm.impl.RelNetComparator;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.FloatArray;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntArray;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntSorter;
import org.tigr.util.FloatMatrix;

public class RN
extends AbstractAlgorithm {
    private static final int c_DecileCount = 10;
    public static final double LOG2 = Math.log(2.0);
    private Algorithm permAlgo;
    private boolean stop = false;
    private int number_of_samples;
    private FloatMatrix expMatrix;
    int validN;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        int nGenes;
        this.expMatrix = data.getMatrix("experiment");
        if (this.expMatrix == null) {
            return null;
        }
        AlgorithmParameters map = data.getParams();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        boolean use_permutation = map.getBoolean("use-permutation");
        float perm_threshold = 0.8f;
        if (use_permutation) {
            this.permAlgo = new PermutationTest();
            this.permAlgo.addAlgorithmListener((AlgorithmListener)new SubAlgoListener());
            AlgorithmData permResult = this.permAlgo.execute(data);
            perm_threshold = permResult.getParams().getFloat("threshold", perm_threshold);
        }
        int function = map.getInt("distance-function", 1);
        float factor = map.getFloat("distance-factor", 1.0f);
        boolean absolute = map.getBoolean("distance-absolute", true);
        float min_threshold = use_permutation ? perm_threshold : map.getFloat("min-threshold", 0.8f);
        float max_threshold = map.getFloat("max-threshold", 1.0f);
        boolean bFilterByEntropy = map.getBoolean("filter-by-entropy");
        float fltTopNPercent = map.getFloat("top-n-percent", 100.0f);
        if (fltTopNPercent < 0.0f || fltTopNPercent > 100.0f) {
            throw new AlgorithmException("Filter value is out of range (0, 100)%");
        }
        int filteredSize = nGenes = this.expMatrix.getRowDimension();
        int[] entropyIndices = new int[nGenes];
        for (int i2 = 0; i2 < entropyIndices.length; ++i2) {
            entropyIndices[i2] = i2;
        }
        if (bFilterByEntropy) {
            double[] entropyValues = new double[nGenes];
            for (int i3 = 0; i3 < entropyValues.length; ++i3) {
                entropyValues[i3] = this.getEntropy(this.expMatrix.A[i3]);
            }
            IntSorter.sort(entropyIndices, new RelNetComparator(entropyValues));
            filteredSize = (int)((float)nGenes * fltTopNPercent / 100.0f);
        }
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, 100, "Calculating Network");
        this.fireValueChanged(event);
        event.setId(2);
        int progress = 0;
        int links = 0;
        int sum = filteredSize * (filteredSize + 1) / 2;
        int step = sum / 100 + 1;
        IntArray[] indices = new IntArray[nGenes];
        FloatArray[] weights = new FloatArray[nGenes];
        for (int i4 = 0; i4 < indices.length; ++i4) {
            indices[i4] = new IntArray();
            indices[i4].add(i4);
            weights[i4] = new FloatArray();
            weights[i4].add(0.0f);
        }
        for (int nCurIndOuter = 0; nCurIndOuter < filteredSize; ++nCurIndOuter) {
            if (this.stop) {
                throw new AbortException();
            }
            ++progress;
            for (int nCurIndInner = nCurIndOuter + 1; nCurIndInner < filteredSize; ++nCurIndInner) {
                float value = ExperimentUtil.geneDistance(this.expMatrix, null, entropyIndices[nCurIndOuter], entropyIndices[nCurIndInner], function, factor, absolute);
                if ((value *= value) >= min_threshold && value <= max_threshold) {
                    ++links;
                    indices[entropyIndices[nCurIndOuter]].add(entropyIndices[nCurIndInner]);
                    indices[entropyIndices[nCurIndInner]].add(entropyIndices[nCurIndOuter]);
                    weights[entropyIndices[nCurIndOuter]].add(value);
                    weights[entropyIndices[nCurIndInner]].add(value);
                }
                if (++progress % step != 0) continue;
                event.setIntValue(progress / step);
                event.setDescription("Calculating Network (" + String.valueOf(links) + " links found)");
                this.fireValueChanged(event);
            }
        }
        AlgorithmData result = new AlgorithmData();
        Cluster cluster = new Cluster();
        NodeList clusterNodeList = cluster.getNodeList();
        clusterNodeList.ensureCapacity(nGenes);
        FloatMatrix means = this.getMeans(indices);
        result.addMatrix("means", means);
        result.addMatrix("variances", this.getVariances(indices, means));
        for (i = 0; i < nGenes; ++i) {
            clusterNodeList.addNode(new Node(indices[i].toArray()));
            indices[i] = null;
        }
        result.addCluster("cluster", cluster);
        cluster = new Cluster();
        clusterNodeList = cluster.getNodeList();
        clusterNodeList.ensureCapacity(nGenes);
        for (i = 0; i < nGenes; ++i) {
            clusterNodeList.addNode(new Node(RN.float2int(weights[i].toArray())));
            weights[i] = null;
        }
        result.addCluster("weights", cluster);
        result.addParam("links", String.valueOf(links));
        result.addParam("min_threshold", String.valueOf(min_threshold));
        return result;
    }

    public void abort() {
        this.stop = true;
        if (this.permAlgo != null) {
            this.permAlgo.abort();
        }
    }

    private static int[] float2int(float[] floats) {
        if (floats == null) {
            return null;
        }
        int[] ints = new int[floats.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = Float.floatToRawIntBits(floats[i]);
        }
        return ints;
    }

    private double getEntropy(float[] pVector) {
        double fltMin = Double.MAX_VALUE;
        double fltMax = -1.7976931348623157E308;
        int i = 0;
        int[] arrDeciles = new int[10];
        int iSize = pVector.length;
        int iValCount = 0;
        for (i = 0; i < iSize; ++i) {
            if (Double.isNaN(pVector[i])) continue;
            fltMin = Math.min(fltMin, (double)pVector[i]);
            fltMax = Math.max(fltMax, (double)pVector[i]);
            ++iValCount;
        }
        double fltStep = (fltMax - fltMin) / 10.0;
        if (fltStep == 0.0) {
            return -1.0 * Math.log(1.0) / LOG2;
        }
        if (fltMin == Double.MAX_VALUE) {
            return 0.0;
        }
        Arrays.fill(arrDeciles, 0);
        for (i = 0; i < iSize; ++i) {
            if (Double.isNaN(pVector[i])) continue;
            int iDecileInd = (int)Math.ceil(((double)pVector[i] - fltMin) / fltStep) - 1;
            if (iDecileInd < 0) {
                iDecileInd = 0;
            }
            int n = iDecileInd;
            arrDeciles[n] = arrDeciles[n] + 1;
        }
        if (iValCount == 0) {
            return 0.0;
        }
        double dblEntropy = 0.0;
        for (i = 0; i < 10; ++i) {
            if (arrDeciles[i] == 0) continue;
            double dblPx = (double)arrDeciles[i] / (double)iValCount;
            dblEntropy += dblPx * Math.log(dblPx) / LOG2;
        }
        return -dblEntropy;
    }

    private FloatMatrix getMeans(IntArray[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.number_of_samples);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getMean(IntArray cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.number_of_samples);
        int n = cluster.getSize();
        int denom = 0;
        for (int i = 0; i < this.number_of_samples; ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(cluster.get(j), i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    private FloatMatrix getVariances(IntArray[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleNormalizedSum(IntArray cluster, int column, float mean) {
        int size = cluster.getSize();
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(cluster.get(i), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float getSampleVariance(IntArray cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    class SubAlgoListener
    implements AlgorithmListener {
        SubAlgoListener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            RN.this.fireValueChanged(event);
        }
    }
}

