/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ProgressDialog;

public class QTC
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    ProgressDialog progress;
    private int number_of_genes;
    private int number_of_samples;
    boolean useAbsolute;
    float diameter;
    int minimumClusterSize;
    Vector allClusters = new Vector();
    private double xMax;
    private double xMin;
    private int clusterSize = Integer.MAX_VALUE;
    private boolean qtcGenes;
    private FloatMatrix expMatrix;
    private JackknifedMatrixBySpecifiedExp[] jacked;
    private float[][] proximity;
    private float adjustedDiameter;
    private int hcl_function;
    private boolean hcl_absolute;

    public synchronized AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 1);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.qtcGenes = map.getBoolean("qtc-cluster-genes");
        this.useAbsolute = map.getBoolean("use-absolute", false);
        this.diameter = map.getFloat("diameter", 0.2f);
        this.minimumClusterSize = map.getInt("min-cluster-size", 1);
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.expMatrix = data.getMatrix("experiment");
        this.number_of_genes = this.expMatrix.getRowDimension();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        JFrame dummyFrame = new JFrame();
        this.progress = new ProgressDialog(dummyFrame, "QTClust -- Progress", false, 6);
        JPanel progressPanel = this.progress.getLabelPanel();
        JPanel superPanel = new JPanel();
        superPanel.setLayout(new BorderLayout());
        JButton abortButton = new JButton("Abort");
        abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QTC.this.stop = true;
                QTC.this.progress.dismiss();
            }
        });
        superPanel.add((Component)progressPanel, "North");
        superPanel.add((Component)abortButton, "South");
        this.progress.setMainPanel(superPanel);
        AlgorithmData result = new AlgorithmData();
        if (this.stop) {
            result.addParam("aborted", "true");
            return result;
        }
        Vector[] clusters = this.calculate(this.useAbsolute, this.diameter, this.minimumClusterSize);
        if (this.stop) {
            result.addParam("aborted", "true");
            return result;
        }
        FloatMatrix means = this.getMeans(clusters);
        FloatMatrix variances = this.getVariances(clusters, means);
        AlgorithmEvent event = null;
        if (hierarchical_tree) {
            event = new AlgorithmEvent((Object)this, 1, clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(event);
            event.setIntValue(0);
            event.setId(2);
            this.fireValueChanged(event);
        }
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i = 0; i < clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.convert2int(clusters[i]);
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            event.setIntValue(i + 1);
            this.fireValueChanged(event);
        }
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", String.valueOf(clusters.length));
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        return result;
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.qtcGenes ? this.getSubExperiment(this.expMatrix, features) : this.getSubExperimentReducedCols(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (Integer)source.get(i);
        }
        return int_matrix;
    }

    private FloatMatrix getMeans(Vector[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.number_of_samples);
        for (int i = 0; i < clusters.length; ++i) {
            int n = clusters[i].size();
            for (int j = 0; j < this.number_of_samples; ++j) {
                float currentMean = 0.0f;
                int denom = 0;
                for (int k = 0; k < n; ++k) {
                    float value = this.expMatrix.get(((Integer)clusters[i].get(k)).intValue(), j);
                    if (Float.isNaN(value)) continue;
                    currentMean += value;
                    ++denom;
                }
                means.set(i, j, currentMean / (float)denom);
            }
        }
        return means;
    }

    private FloatMatrix getVariances(Vector[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                float mean = means.get(row, column);
                int validN = 0;
                int size = clusters[row].size();
                float sum = 0.0f;
                for (int i = 0; i < size; ++i) {
                    float value = this.expMatrix.get(((Integer)clusters[row].get(i)).intValue(), column);
                    if (Float.isNaN(value)) continue;
                    float diff = value - mean;
                    sum += diff * diff;
                    ++validN;
                }
                variances.set(row, column, (float)Math.sqrt(sum) / (float)(validN - 1));
            }
        }
        return variances;
    }

    public boolean isAborted() {
        return this.stop;
    }

    synchronized float getAdjustedDiameter() {
        if (this.function == 4 || this.function == 8) {
            return (float)((double)this.diameter * this.getMaximumDistance());
        }
        if (!this.useAbsolute && this.function == 1 || this.function == 9 || this.function == 10 || this.function == 11 || this.function == 6 || this.function == 2) {
            return 2.0f * this.diameter;
        }
        return this.diameter;
    }

    private double getMaximumDistance() {
        double maxDistance = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.number_of_genes; ++i) {
            for (int j = 0; j < this.number_of_genes; ++j) {
                double currentDistance;
                if (j == i || !(maxDistance < (currentDistance = this.getDistance(this.expMatrix, i, j)))) continue;
                maxDistance = currentDistance;
            }
        }
        return maxDistance;
    }

    private double getDistance(FloatMatrix expMatrix, int gene1, int gene2) {
        double distance = 0.0;
        if (this.function == 1) {
            distance = ExperimentUtil.genePearson(expMatrix, null, gene1, gene2, this.factor);
        } else if (this.function == 9) {
            distance = ExperimentUtil.geneSpearmanRank(expMatrix, null, gene1, gene2, this.factor);
        } else if (this.function == 10) {
            distance = ExperimentUtil.geneKendallsTau(expMatrix, null, gene1, gene2, this.factor);
        } else if (this.function == 2) {
            distance = ExperimentUtil.geneCosine(expMatrix, null, gene1, gene2, this.factor);
        } else if (this.function == 11) {
            distance = ExperimentUtil.geneMutualInformation(expMatrix, null, gene1, gene2, this.factor);
        } else if (this.function == 6) {
            distance = ExperimentUtil.genePearsonUncentered(expMatrix, null, gene1, gene2, this.factor);
        } else if (this.function == 7) {
            float temp = ExperimentUtil.genePearson(expMatrix, null, gene1, gene2, this.factor);
            distance = temp * temp;
        } else if (this.function == 4 || this.function == 8) {
            distance = ExperimentUtil.geneDistance(expMatrix, null, gene1, gene2, this.function, this.factor, this.useAbsolute);
        } else if (this.function == 3) {
            double x = ExperimentUtil.geneCovariance(expMatrix, null, gene1, gene2, this.factor);
            if (this.useAbsolute) {
                x = Math.abs(x);
            }
            distance = (this.xMax - x) / (this.xMax - this.xMin);
        } else if (this.function == 5) {
            double x = ExperimentUtil.geneDotProduct(expMatrix, null, gene1, gene2, this.factor);
            if (this.useAbsolute) {
                x = Math.abs(x);
            }
            distance = (this.xMax - x) / (this.xMax - this.xMin);
        }
        if (this.function == 1 || this.function == 9 || this.function == 10 || this.function == 2 || this.function == 11 || this.function == 6 || this.function == 7) {
            distance = this.useAbsolute ? 1.0 - Math.abs(distance) : 1.0 - distance;
        }
        return distance;
    }

    private double getMaxCovarOrDotProd() {
        double xMax = Double.NEGATIVE_INFINITY;
        double xCurrent = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.number_of_genes; ++i) {
            for (int j = 0; j < this.number_of_genes; ++j) {
                if (j == i) continue;
                if (this.function == 5) {
                    xCurrent = ExperimentUtil.geneDotProduct(this.expMatrix, null, i, j, this.factor);
                    if (this.useAbsolute) {
                        xCurrent = Math.abs(xCurrent);
                    }
                } else if (this.function == 3) {
                    xCurrent = ExperimentUtil.geneCovariance(this.expMatrix, null, i, j, this.factor);
                    if (this.useAbsolute) {
                        xCurrent = Math.abs(xCurrent);
                    }
                }
                if (!(xMax < xCurrent)) continue;
                xMax = xCurrent;
            }
        }
        return xMax;
    }

    private double getMinCovOrDotProd() {
        double xMin = Double.POSITIVE_INFINITY;
        double xCurrent = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.number_of_genes; ++i) {
            for (int j = 0; j < this.number_of_genes; ++j) {
                if (j == i) continue;
                if (this.function == 5) {
                    xCurrent = ExperimentUtil.geneDotProduct(this.expMatrix, null, i, j, this.factor);
                    if (this.useAbsolute) {
                        xCurrent = Math.abs(xCurrent);
                    }
                } else if (this.function == 3) {
                    xCurrent = ExperimentUtil.geneCovariance(this.expMatrix, null, i, j, this.factor);
                    if (this.useAbsolute) {
                        xCurrent = Math.abs(xCurrent);
                    }
                }
                if (!(xMin > xCurrent)) continue;
                xMin = xCurrent;
            }
        }
        return xMin;
    }

    public void setMinMaxCovOrDotProd() {
        this.xMax = this.getMaxCovarOrDotProd();
        this.xMin = this.getMinCovOrDotProd();
    }

    private Vector getAllClusters(Vector unassignedUniqueIDIndices) {
        if (this.stop) {
            return null;
        }
        do {
            Vector currentLargestCluster = this.getLargestCluster(unassignedUniqueIDIndices);
            this.allClusters.add(currentLargestCluster);
            int clusterSize = currentLargestCluster.size();
            this.progress.setMessage(4, "# of assigned genes: " + (this.number_of_genes - unassignedUniqueIDIndices.size()));
            this.progress.setMessage(5, "# of genes not yet assigned: " + unassignedUniqueIDIndices.size());
            this.progress.setMessage(2, "# of clusters formed: " + this.allClusters.size());
            this.progress.setMessage(3, "size of last cluster formed: " + currentLargestCluster.size());
            unassignedUniqueIDIndices.removeAll(currentLargestCluster);
            if (clusterSize >= this.minimumClusterSize) continue;
            currentLargestCluster.addAll(unassignedUniqueIDIndices);
            return this.allClusters;
        } while (unassignedUniqueIDIndices.size() != 0);
        this.allClusters.add(new Vector());
        return this.allClusters;
    }

    private Vector getClusterForAGene(Integer seedIndex, Vector candidateIndices) {
        Vector<Integer> cluster = new Vector<Integer>();
        cluster.add(seedIndex);
        Integer MostRecentAdditionI = seedIndex;
        int mostRecentAdditioni = seedIndex;
        float[] geneDiameterSoFar = new float[this.number_of_genes];
        for (int local = 0; local < candidateIndices.size(); ++local) {
            geneDiameterSoFar[((Integer)candidateIndices.get((int)local)).intValue()] = Float.NEGATIVE_INFINITY;
        }
        while (true) {
            int bestLocalIndex = -1;
            float bestDistance = Float.POSITIVE_INFINITY;
            int local = 0;
            while (local < candidateIndices.size()) {
                int i = (Integer)candidateIndices.get(local);
                geneDiameterSoFar[i] = Math.max(this.proximity[i][mostRecentAdditioni], geneDiameterSoFar[i]);
                if (geneDiameterSoFar[i] > this.adjustedDiameter) {
                    candidateIndices.remove(local);
                    continue;
                }
                if (geneDiameterSoFar[i] < bestDistance) {
                    bestDistance = geneDiameterSoFar[i];
                    bestLocalIndex = local;
                }
                ++local;
            }
            if (bestLocalIndex == -1) break;
            MostRecentAdditionI = (Integer)candidateIndices.remove(bestLocalIndex);
            mostRecentAdditioni = MostRecentAdditionI;
            cluster.add(MostRecentAdditionI);
        }
        return cluster;
    }

    private double getJackknifeDistance(int gene1, int gene2) {
        JackknifedMatrixBySpecifiedExp jackMatrix = null;
        double jackknifeDistance = Math.abs(this.getDistance(this.expMatrix, gene1, gene2));
        for (int i = 0; i < this.number_of_samples; ++i) {
            jackMatrix = this.jacked[i];
            double currentDistance = this.getDistance(jackMatrix, gene1, gene2);
            jackknifeDistance = this.useAbsolute ? Math.max(jackknifeDistance, Math.abs(currentDistance)) : Math.max(jackknifeDistance, currentDistance);
        }
        return jackknifeDistance;
    }

    private Vector getLargestCluster(Vector unassignedUIDIndices) {
        Vector<Vector> largestClusterTies = new Vector<Vector>();
        int largestClusterSize = 0;
        for (int i = 0; i < unassignedUIDIndices.size(); ++i) {
            Vector tempUnassigned = (Vector)unassignedUIDIndices.clone();
            Integer seedCandidate = (Integer)tempUnassigned.remove(i);
            Vector currentCluster = this.getClusterForAGene(seedCandidate, tempUnassigned);
            if (currentCluster.size() == largestClusterSize) {
                largestClusterTies.add(currentCluster);
                continue;
            }
            if (currentCluster.size() <= largestClusterSize) continue;
            largestClusterTies.clear();
            largestClusterTies.add(currentCluster);
            largestClusterSize = currentCluster.size();
        }
        int randCluster = (int)(Math.random() * (double)largestClusterTies.size());
        return (Vector)largestClusterTies.get(randCluster);
    }

    public void abort() {
        this.stop = true;
    }

    private Vector[] calculate(boolean useAbsolute, float diameter, int minimumClusterSize) throws AlgorithmException {
        int i;
        if (this.stop) {
            return null;
        }
        if (this.function == 3 || this.function == 5) {
            this.setMinMaxCovOrDotProd();
        }
        this.progress.setMessage(0, "<html><p>Distance: " + AbstractAlgorithm.getDistanceName((int)this.function) + "<p>Absolute? " + (useAbsolute ? "Yes" : "No") + "<p>Minimum cluster size: " + minimumClusterSize + "<p>Threshold diameter: " + diameter + "</html>");
        this.progress.setTimerLabel(1, "Running for ", " seconds.", 1000);
        this.progress.setMessage(2, "# of clusters formed: 0");
        this.progress.setMessage(3, "size of last cluster formed: 0");
        this.progress.setMessage(4, "# of assigned genes: 0");
        this.progress.setMessage(5, "# of genes not yet assigned: " + this.number_of_genes);
        this.progress.setVisible(true);
        if (this.stop) {
            return null;
        }
        this.adjustedDiameter = this.getAdjustedDiameter();
        this.jacked = new JackknifedMatrixBySpecifiedExp[this.number_of_samples];
        for (i = 0; i < this.jacked.length; ++i) {
            this.jacked[i] = new JackknifedMatrixBySpecifiedExp(this.expMatrix, i);
        }
        this.proximity = new float[this.number_of_genes][this.number_of_genes];
        for (i = 0; i < this.number_of_genes; ++i) {
            for (int j = 0; j <= i; ++j) {
                this.proximity[i][j] = (float)this.getJackknifeDistance(i, j);
                this.proximity[j][i] = this.proximity[i][j];
            }
        }
        this.jacked = null;
        Vector<Integer> allUniqueIDIndices = new Vector<Integer>();
        Vector clusterVector = new Vector();
        allUniqueIDIndices = new Vector();
        for (int i2 = 0; i2 < this.number_of_genes; ++i2) {
            allUniqueIDIndices.add(new Integer(i2));
        }
        if (this.stop) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        clusterVector = this.getAllClusters(allUniqueIDIndices);
        if (this.stop) {
            return null;
        }
        this.progress.dismiss();
        long calculationTime = System.currentTimeMillis() - startTime;
        Vector[] clusters = clusterVector.toArray(new Vector[clusterVector.size()]);
        return clusters;
    }

    private class JackknifedMatrixBySpecifiedExp
    extends FloatMatrix {
        FloatMatrix origMatrix;
        int removedExperiment;

        public JackknifedMatrixBySpecifiedExp(FloatMatrix origMatrix, int removedExperiment) {
            super(origMatrix.m, origMatrix.n - 1);
            this.origMatrix = origMatrix;
            this.removedExperiment = removedExperiment;
            for (int i = 0; i < this.m; ++i) {
                int jackMatrixExpIndex = 0;
                for (int j = 0; j < origMatrix.n; ++j) {
                    if (j == removedExperiment) continue;
                    this.A[i][jackMatrixExpIndex] = origMatrix.A[i][j];
                    ++jackMatrixExpIndex;
                }
            }
        }
    }
}

