/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Arrays;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.RelNetComparator;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntSorter;
import org.tigr.util.FloatMatrix;

public class PermutationTest
extends AbstractAlgorithm {
    private static final int c_DecileCount = 10;
    public static final double LOG2 = Math.log(2.0);
    public static final float MINVAL = 0.0f;
    public static final float MAXVAL = 1.0f;
    private boolean stop = false;
    private int[] m_arrMainHisto = null;
    private double[] m_arrAvgHisto = null;
    private int m_iHistoSize = 0;
    private int m_iPermutationSize = 0;
    private float m_fltHistoStep = 0.5f;
    private float m_fltMaxStatSignificant = 0.0f;

    private double getEntropy(float[] pVector) {
        double fltMin = Double.MAX_VALUE;
        double fltMax = -1.7976931348623157E308;
        int i = 0;
        int[] arrDeciles = new int[10];
        int iSize = pVector.length;
        int iValCount = 0;
        for (i = 0; i < iSize; ++i) {
            if (Double.isNaN(pVector[i])) continue;
            fltMin = Math.min(fltMin, (double)pVector[i]);
            fltMax = Math.max(fltMax, (double)pVector[i]);
            ++iValCount;
        }
        double fltStep = (fltMax - fltMin) / 10.0;
        if (fltStep == 0.0) {
            return -1.0 * Math.log(1.0) / LOG2;
        }
        if (fltMin == Double.MAX_VALUE) {
            return 0.0;
        }
        Arrays.fill(arrDeciles, 0);
        for (i = 0; i < iSize; ++i) {
            if (Double.isNaN(pVector[i])) continue;
            int iDecileInd = (int)Math.ceil(((double)pVector[i] - fltMin) / fltStep) - 1;
            if (iDecileInd < 0) {
                iDecileInd = 0;
            }
            int n = iDecileInd;
            arrDeciles[n] = arrDeciles[n] + 1;
        }
        if (iValCount == 0) {
            return 0.0;
        }
        double dblEntropy = 0.0;
        for (i = 0; i < 10; ++i) {
            if (arrDeciles[i] == 0) continue;
            double dblPx = (double)arrDeciles[i] / (double)iValCount;
            dblEntropy += dblPx * Math.log(dblPx) / LOG2;
        }
        return -dblEntropy;
    }

    private void Assert(int iFrom, int iTo, float fltVal) {
        int n = this.GetIndByVal(fltVal);
        this.m_arrMainHisto[n] = this.m_arrMainHisto[n] + 1;
    }

    private void AssertPermutted(int iPermutationNum, int iFrom, int iTo, float fltVal) {
        int n = this.GetIndByVal(fltVal);
        this.m_arrAvgHisto[n] = this.m_arrAvgHisto[n] + 1.0;
        this.m_fltMaxStatSignificant = Math.max(this.m_fltMaxStatSignificant, fltVal);
    }

    private int GetIndByVal(float fltVal) {
        int iDecileInd = (int)Math.ceil((fltVal - 0.0f) / this.m_fltHistoStep) - 1;
        if (iDecileInd < 0) {
            return 0;
        }
        return iDecileInd;
    }

    private void RandomPermute(FloatMatrix matr, int iRow) {
        int iFirstInd = 0;
        int iSecondInd = 0;
        int iPermCount = (int)(Math.random() * (double)matr.getColumnDimension() + 1.0);
        for (int i = 0; i < iPermCount; ++i) {
            while ((iFirstInd = (int)(Math.random() * (double)(matr.getColumnDimension() - 1))) == (iSecondInd = (int)(Math.random() * (double)(matr.getColumnDimension() - 1)))) {
            }
            float temp = matr.A[iRow][iFirstInd];
            matr.A[iRow][iFirstInd] = matr.A[iRow][iSecondInd];
            matr.A[iRow][iSecondInd] = temp;
        }
    }

    private void Run(int[] entropyIndices, FloatMatrix expMatrix, int function, float factor, boolean absolute) throws AlgorithmException {
        int filteredSize = entropyIndices.length;
        int progress = 0;
        boolean links = false;
        int sum = filteredSize * (filteredSize + 1) / 2;
        int step = sum / 100 + 1;
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, 100, "Calculating Histogram");
        this.fireValueChanged(event);
        event.setId(2);
        FloatMatrix temp = new FloatMatrix(1, expMatrix.getColumnDimension());
        for (int nCurIndOuter = 0; nCurIndOuter < filteredSize; ++nCurIndOuter) {
            if (this.stop) {
                throw new AbortException();
            }
            ++progress;
            float[] arrX = expMatrix.A[entropyIndices[nCurIndOuter]];
            float[] arrY = temp.A[0];
            for (int k = 0; k < arrY.length; ++k) {
                arrY[k] = arrX[k];
            }
            for (int nCurIndInner = nCurIndOuter + 1; nCurIndInner < filteredSize; ++nCurIndInner) {
                for (int i = 0; i < this.m_iPermutationSize; ++i) {
                    this.RandomPermute(temp, 0);
                    float value = ExperimentUtil.genePearson(temp, expMatrix, 0, entropyIndices[nCurIndInner], 1.0f);
                    value *= value;
                    this.AssertPermutted(i, entropyIndices[nCurIndOuter], entropyIndices[nCurIndInner], value);
                }
                if (++progress % step != 0) continue;
                event.setIntValue(progress / step);
                event.setDescription("Calculating permutation histogram ");
                this.fireValueChanged(event);
            }
        }
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        int nGenes;
        FloatMatrix expMatrix = data.getMatrix("experiment");
        if (expMatrix == null) {
            return null;
        }
        AlgorithmParameters map = data.getParams();
        this.m_iHistoSize = map.getInt("decile-count", 1000);
        this.m_iPermutationSize = map.getInt("permutation-count", 20);
        this.m_fltHistoStep = 1.0f / (float)this.m_iHistoSize;
        this.m_arrMainHisto = new int[this.m_iHistoSize];
        this.m_arrAvgHisto = new double[this.m_iHistoSize];
        int function = map.getInt("distance-function", 1);
        float factor = map.getFloat("distance-factor", 1.0f);
        boolean absolute = map.getBoolean("distance-absolute", true);
        int filteredSize = nGenes = expMatrix.getRowDimension();
        boolean bFilterByEntropy = map.getBoolean("filter-by-entropy");
        float fltTopNPercent = map.getFloat("top-n-percent", 100.0f);
        if (fltTopNPercent < 0.0f || fltTopNPercent > 100.0f) {
            throw new AlgorithmException("Filter value is out of range (0, 100)%");
        }
        int[] entropyIndices = new int[nGenes];
        for (int i2 = 0; i2 < entropyIndices.length; ++i2) {
            entropyIndices[i2] = i2;
        }
        if (bFilterByEntropy) {
            double[] entropyValues = new double[nGenes];
            for (i = 0; i < entropyValues.length; ++i) {
                entropyValues[i] = this.getEntropy(expMatrix.A[i]);
            }
            IntSorter.sort(entropyIndices, new RelNetComparator(entropyValues));
            filteredSize = (int)((float)nGenes * fltTopNPercent / 100.0f);
        }
        this.Run(entropyIndices, expMatrix, function, factor, absolute);
        float fltMinStatSignificantThreshold = this.m_fltMaxStatSignificant;
        if ((double)fltMinStatSignificantThreshold >= 1.0) {
            for (i = this.m_arrAvgHisto.length - 1; i > 0; --i) {
                if (!(this.m_arrAvgHisto[i] / (double)this.m_iPermutationSize >= 1.0)) continue;
                fltMinStatSignificantThreshold = (float)(i + 1) * this.m_fltHistoStep;
                if (!(fltMinStatSignificantThreshold > 1.0f)) break;
                fltMinStatSignificantThreshold = 1.0f;
                break;
            }
        }
        AlgorithmData result = new AlgorithmData();
        result.addParam("threshold", String.valueOf(fltMinStatSignificantThreshold));
        return result;
    }

    public void abort() {
        this.stop = true;
    }
}

