/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.TDistribution;
import java.util.Vector;
import javax.swing.JButton;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;

public class PavlidisTemplateMatching
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private int number_of_genes;
    private int number_of_samples;
    private FloatMatrix expMatrix;
    private FloatMatrix newMatrix;
    private long StartTime;
    private long CalculationTime;
    private boolean ptmGenes;
    private double[] pValues;
    private double[] rValues;
    boolean useAbsolute;
    boolean useR;
    boolean drawSigTreesOnly;
    JButton abortButton;
    Vector templateVector;
    FloatMatrix templateVectorMatrix;
    float[] geneTemplate;
    float threshold;
    int origNumGenes;
    int numSamples;
    private int hcl_function;
    private boolean hcl_absolute;
    int validN;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("distance-absolute", false);
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        this.ptmGenes = map.getBoolean("ptm-cluster-genes", true);
        this.threshold = map.getFloat("threshold", 0.8f);
        this.useAbsolute = map.getBoolean("use-absolute", false);
        this.useR = map.getBoolean("useR", false);
        this.templateVectorMatrix = data.getMatrix("templateVectorMatrix");
        this.templateVector = this.convertToVector(this.templateVectorMatrix);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        if (hierarchical_tree) {
            this.drawSigTreesOnly = map.getBoolean("draw-sig-trees-only");
        }
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.expMatrix = data.getMatrix("experiment");
        this.number_of_genes = this.expMatrix.getRowDimension();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        this.origNumGenes = this.expMatrix.getRowDimension();
        this.numSamples = this.expMatrix.getColumnDimension();
        this.geneTemplate = new float[this.templateVector.size()];
        this.pValues = new double[this.number_of_genes];
        this.rValues = new double[this.number_of_genes];
        for (int i = 0; i < this.templateVector.size(); ++i) {
            this.geneTemplate[i] = ((Float)this.templateVector.get(i)).floatValue();
        }
        Vector[] clusters = this.calculate();
        FloatMatrix means = this.getMeans(clusters);
        FloatMatrix variances = this.getVariances(clusters, means);
        AlgorithmEvent event = null;
        if (hierarchical_tree) {
            event = new AlgorithmEvent((Object)this, 1, clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(event);
            event.setIntValue(0);
            event.setId(2);
            this.fireValueChanged(event);
        }
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i = 0; i < clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.convert2int(clusters[i]);
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            if (this.drawSigTreesOnly) {
                if (i != 0) continue;
                node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
                event.setIntValue(i + 1);
                this.fireValueChanged(event);
                continue;
            }
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            event.setIntValue(i + 1);
            this.fireValueChanged(event);
        }
        FloatMatrix rValuesMatrix = new FloatMatrix(this.number_of_genes, 1);
        FloatMatrix pValuesMatrix = new FloatMatrix(this.number_of_genes, 1);
        for (int i = 0; i < this.pValues.length; ++i) {
            rValuesMatrix.A[i][0] = (float)this.rValues[i];
            pValuesMatrix.A[i][0] = (float)this.pValues[i];
        }
        AlgorithmData result = new AlgorithmData();
        result.addCluster("cluster", result_cluster);
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        result.addMatrix("rValuesMatrix", rValuesMatrix);
        result.addMatrix("pValuesMatrix", pValuesMatrix);
        return result;
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.ptmGenes ? this.getSubExperiment(this.expMatrix, features) : this.getSubExperimentReducedCols(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (Integer)source.get(i);
        }
        return int_matrix;
    }

    public void abort() {
        this.stop = true;
    }

    private Vector convertToVector(FloatMatrix tempMatrix) {
        Vector<Float> temp = new Vector<Float>();
        for (int i = 0; i < tempMatrix.A[0].length; ++i) {
            temp.add(new Float(tempMatrix.A[0][i]));
        }
        return temp;
    }

    public Vector itf(Vector integerVector) {
        Vector<Float> floatVector = new Vector<Float>();
        for (int i = 0; i < integerVector.size(); ++i) {
            floatVector.addElement(new Float(((Integer)integerVector.elementAt(i)).intValue()));
        }
        return floatVector;
    }

    Vector[] calculate() {
        Vector<Integer> allUniqueIDIndices = new Vector<Integer>();
        for (int i = 0; i < this.origNumGenes; ++i) {
            allUniqueIDIndices.add(new Integer(i));
        }
        Vector remainingGenes = (Vector)allUniqueIDIndices.clone();
        this.StartTime = System.currentTimeMillis();
        Vector similarGenes = this.findSimilarGenes();
        remainingGenes.removeAll(similarGenes);
        this.CalculationTime = System.currentTimeMillis() - this.StartTime;
        Vector[] clusters = new Vector[]{similarGenes, remainingGenes};
        return clusters;
    }

    FloatMatrix addTemplateToexpMatrix() {
        FloatMatrix newMatrix = new FloatMatrix(this.origNumGenes + 1, this.numSamples);
        for (int i = 0; i < this.origNumGenes; ++i) {
            for (int j = 0; j < this.numSamples; ++j) {
                newMatrix.A[i][j] = this.expMatrix.A[i][j];
            }
        }
        for (int k = 0; k < this.geneTemplate.length; ++k) {
            newMatrix.A[this.origNumGenes][k] = this.geneTemplate[k];
        }
        return newMatrix;
    }

    Vector findSimilarGenes() {
        int i;
        Vector similarGenes = new Vector();
        this.newMatrix = this.addTemplateToexpMatrix();
        Vector<Integer> allUniqueIDIndices = new Vector<Integer>();
        for (i = 0; i < this.origNumGenes; ++i) {
            allUniqueIDIndices.add(new Integer(i));
        }
        for (i = 0; i < this.origNumGenes; ++i) {
            double pearsonR;
            this.rValues[i] = pearsonR = (double)ExperimentUtil.genePearson(this.newMatrix, null, i, this.origNumGenes, this.factor);
            this.pValues[i] = this.getProb(pearsonR);
            if (this.useR) {
                if (this.useAbsolute) {
                    if (!((pearsonR = Math.abs(pearsonR)) >= (double)this.threshold)) continue;
                    similarGenes.add(allUniqueIDIndices.elementAt(i));
                    continue;
                }
                if (!(pearsonR >= (double)this.threshold)) continue;
                similarGenes.add(allUniqueIDIndices.elementAt(i));
                continue;
            }
            if (this.useAbsolute) {
                if (!(this.getProb(pearsonR) <= (double)this.threshold)) continue;
                similarGenes.add(allUniqueIDIndices.elementAt(i));
                continue;
            }
            if (!(pearsonR > 0.0) || !(this.getProb(pearsonR) <= (double)this.threshold)) continue;
            similarGenes.add(allUniqueIDIndices.elementAt(i));
        }
        return similarGenes;
    }

    double getProb(double pearsonR) {
        int df = this.geneTemplate.length - 2;
        TDistribution tDist = new TDistribution(df);
        double tValue = this.getTValue(Math.abs(pearsonR));
        double prob = 2.0 * (1.0 - tDist.cumulative(tValue));
        if (prob > 1.0) {
            prob = 1.0;
        }
        return prob;
    }

    double getTValue(double pearsonR) {
        int n = this.geneTemplate.length;
        double stdError = Math.sqrt((1.0 - pearsonR * pearsonR) / (double)(n - 2));
        double tValue = pearsonR / stdError;
        return tValue;
    }

    private FloatMatrix getMeans(Vector[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.number_of_samples);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getMean(Vector cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.number_of_samples);
        int n = cluster.size();
        int denom = 0;
        for (int i = 0; i < this.number_of_samples; ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(((Integer)cluster.get(j)).intValue(), i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    private FloatMatrix getVariances(Vector[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleNormalizedSum(Vector cluster, int column, float mean) {
        int size = cluster.size();
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(((Integer)cluster.get(i)).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float getSampleVariance(Vector cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }
}

