/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Arrays;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.util.FloatMatrix;
import org.tigr.util.Maths;
import org.tigr.util.QSort;

public class PCA
extends AbstractAlgorithm {
    private boolean stop = false;
    private int numNeighbors;
    private int numGenes;
    private int numExps;
    private float factor;
    private int mode;
    private int center;
    private int shortcut;
    private boolean useShortcut;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        int k;
        int j;
        FloatMatrix expMatrix = data.getMatrix("experiment");
        AlgorithmParameters map = data.getParams();
        int function = 3;
        this.factor = map.getFloat("distance-factor", 1.0f);
        boolean absolute = map.getBoolean("distance-absolute", false);
        this.mode = map.getInt("pca-mode", 0);
        this.shortcut = map.getInt("use-shortcut");
        this.useShortcut = false;
        if (this.shortcut == 0) {
            this.useShortcut = true;
        }
        this.numNeighbors = map.getInt("numNeighbors", 10);
        this.center = map.getInt("centering", 3);
        this.numGenes = expMatrix.getRowDimension();
        this.numExps = expMatrix.getColumnDimension();
        int numberOfGenes = expMatrix.getRowDimension();
        int numberOfSamples = expMatrix.getColumnDimension();
        FloatMatrix An = this.imputeKNearestMatrix(expMatrix, this.numNeighbors);
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 2, 0);
        int eventValue = 0;
        event.setIntValue(eventValue);
        event.setDescription("Calculate covariance matrix\n");
        this.fireValueChanged(event);
        FloatMatrix matrix = null;
        if (this.mode == 0) {
            matrix = An;
        }
        if (this.mode == 1 || this.useShortcut) {
            matrix = new FloatMatrix(numberOfSamples, numberOfSamples);
            for (int column = 0; column < numberOfSamples; ++column) {
                for (int row = 0; row < numberOfSamples; ++row) {
                    matrix.set(row, column, ExperimentUtil.distance(An, row, column, function, this.factor, absolute));
                }
            }
        }
        if (this.mode == 3 && !this.useShortcut) {
            matrix = new FloatMatrix(numberOfGenes, numberOfGenes);
            FloatMatrix AnTranspose = An.transpose();
            for (int column = 0; column < numberOfGenes; ++column) {
                for (int row = 0; row < numberOfGenes; ++row) {
                    matrix.set(row, column, ExperimentUtil.distance(AnTranspose, row, column, function, this.factor, absolute));
                }
            }
        }
        float[][] A = matrix.getArrayCopy();
        int m = matrix.getRowDimension();
        int n = matrix.getColumnDimension();
        int nu = Math.min(m, n);
        float[] s = new float[Math.min(m + 1, n)];
        int[] order = new int[Math.min(m + 1, n)];
        float[][] U = new float[m][nu];
        float[][] V = new float[n][n];
        float[] e = new float[n];
        float[] work = new float[m];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(m - 1, n);
        int nrt = Math.max(0, Math.min(n - 2, m));
        for (int i2 = 0; i2 < Math.min(m + 1, n); ++i2) {
            order[i2] = i2;
        }
        event.setIntValue(++eventValue);
        event.setDescription("Reducing A to bidiagonal form\n");
        this.fireValueChanged(event);
        int counter = 0;
        for (int k2 = 0; k2 < Math.max(nct, nrt); ++k2) {
            int i3;
            int i4;
            ++counter;
            if (k2 < nct) {
                s[k2] = 0.0f;
                for (i4 = k2; i4 < m; ++i4) {
                    s[k2] = Maths.hypot((float)s[k2], (float)A[i4][k2]);
                }
                if ((double)s[k2] != 0.0) {
                    if ((double)A[k2][k2] < 0.0) {
                        s[k2] = -s[k2];
                    }
                    for (i4 = k2; i4 < m; ++i4) {
                        float[] fArray = A[i4];
                        int n2 = k2;
                        fArray[n2] = fArray[n2] / s[k2];
                    }
                    float[] fArray = A[k2];
                    int n3 = k2;
                    fArray[n3] = (float)((double)fArray[n3] + 1.0);
                }
                s[k2] = -s[k2];
            }
            for (j = k2 + 1; j < n; ++j) {
                if (k2 < nct & (double)s[k2] != 0.0) {
                    float t = 0.0f;
                    for (i3 = k2; i3 < m; ++i3) {
                        t += A[i3][k2] * A[i3][j];
                    }
                    t = -t / A[k2][k2];
                    for (i3 = k2; i3 < m; ++i3) {
                        float[] fArray = A[i3];
                        int n4 = j;
                        fArray[n4] = fArray[n4] + t * A[i3][k2];
                    }
                }
                e[j] = A[k2][j];
            }
            if (wantu & k2 < nct) {
                for (i4 = k2; i4 < m; ++i4) {
                    U[i4][k2] = A[i4][k2];
                }
            }
            if (k2 >= nrt) continue;
            e[k2] = 0.0f;
            for (i4 = k2 + 1; i4 < n; ++i4) {
                e[k2] = Maths.hypot((float)e[k2], (float)e[i4]);
            }
            if ((double)e[k2] != 0.0) {
                if ((double)e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                i4 = k2 + 1;
                while (i4 < n) {
                    int n5 = i4++;
                    e[n5] = e[n5] / e[k2];
                }
                int n6 = k2 + 1;
                e[n6] = (float)((double)e[n6] + 1.0);
            }
            e[k2] = -e[k2];
            if (k2 + 1 < m & (double)e[k2] != 0.0) {
                for (i4 = k2 + 1; i4 < m; ++i4) {
                    work[i4] = 0.0f;
                }
                for (j = k2 + 1; j < n; ++j) {
                    for (int i5 = k2 + 1; i5 < m; ++i5) {
                        int n7 = i5;
                        work[n7] = work[n7] + e[j] * A[i5][j];
                    }
                }
                for (j = k2 + 1; j < n; ++j) {
                    float t = -e[j] / e[k2 + 1];
                    for (i3 = k2 + 1; i3 < m; ++i3) {
                        float[] fArray = A[i3];
                        int n8 = j;
                        fArray[n8] = fArray[n8] + t * work[i3];
                    }
                }
            }
            if (!wantv) continue;
            for (i4 = k2 + 1; i4 < n; ++i4) {
                V[i4][k2] = e[i4];
            }
        }
        int p = Math.min(n, m + 1);
        if (nct < n) {
            s[nct] = A[nct][nct];
        }
        if (m < p) {
            s[p - 1] = 0.0f;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0f;
        if (wantu) {
            event.setDescription("Generating Matrix U\n");
            event.setIntValue(++eventValue);
            this.fireValueChanged(event);
            for (j = nct; j < nu; ++j) {
                for (int i6 = 0; i6 < m; ++i6) {
                    U[i6][j] = 0.0f;
                }
                U[j][j] = 1.0f;
            }
            for (k = nct - 1; k >= 0; --k) {
                int i7;
                if ((double)s[k] != 0.0) {
                    for (int j2 = k + 1; j2 < nu; ++j2) {
                        float t = 0.0f;
                        for (i = k; i < m; ++i) {
                            t += U[i][k] * U[i][j2];
                        }
                        t = -t / U[k][k];
                        for (i = k; i < m; ++i) {
                            float[] fArray = U[i];
                            int n9 = j2;
                            fArray[n9] = fArray[n9] + t * U[i][k];
                        }
                    }
                    for (i7 = k; i7 < m; ++i7) {
                        U[i7][k] = -U[i7][k];
                    }
                    U[k][k] = 1.0f + U[k][k];
                    for (i7 = 0; i7 < k - 1; ++i7) {
                        U[i7][k] = 0.0f;
                    }
                    continue;
                }
                for (i7 = 0; i7 < m; ++i7) {
                    U[i7][k] = 0.0f;
                }
                U[k][k] = 1.0f;
            }
        }
        if (wantv) {
            event.setDescription("Generating Matrix V\n");
            event.setIntValue(++eventValue);
            this.fireValueChanged(event);
            for (k = n - 1; k >= 0; --k) {
                if (k < nrt & (double)e[k] != 0.0) {
                    for (int j3 = k + 1; j3 < nu; ++j3) {
                        float t = 0.0f;
                        for (i = k + 1; i < n; ++i) {
                            t += V[i][k] * V[i][j3];
                        }
                        t = -t / V[k + 1][k];
                        for (i = k + 1; i < n; ++i) {
                            float[] fArray = V[i];
                            int n10 = j3;
                            fArray[n10] = fArray[n10] + t * V[i][k];
                        }
                    }
                }
                for (int i8 = 0; i8 < n; ++i8) {
                    V[i8][k] = 0.0f;
                }
                V[k][k] = 1.0f;
            }
        }
        int pp = p - 1;
        int iter = 0;
        float eps = (float)Math.pow(2.0, -52.0);
        event.setDescription("Main iteration loop started...\n");
        event.setIntValue(++eventValue);
        this.fireValueChanged(event);
        counter = 0;
        block46: while (p > 0) {
            int kase;
            int k3;
            if (++counter == 240) {
                if (this.stop) {
                    throw new AbortException();
                }
                event.setDescription("Main iteration loop.\n");
                event.setIntValue(++eventValue);
                this.fireValueChanged(event);
                counter = 0;
            }
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= eps * (Math.abs(s[k3]) + Math.abs(s[k3 + 1])))) continue;
                e[k3] = 0.0f;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    float t = (float)((ks != p ? (double)Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? (double)Math.abs(e[ks - 1]) : 0.0));
                    if (!(Math.abs(s[ks]) <= eps * t)) continue;
                    s[ks] = 0.0f;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    float sn;
                    float cs;
                    float t;
                    float f = e[p - 2];
                    e[p - 2] = 0.0f;
                    for (int j4 = p - 2; j4 >= k3; --j4) {
                        t = Maths.hypot((float)s[j4], (float)f);
                        cs = s[j4] / t;
                        sn = f / t;
                        s[j4] = t;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        if (!wantv) continue;
                        for (int i9 = 0; i9 < n; ++i9) {
                            t = cs * V[i9][j4] + sn * V[i9][p - 1];
                            V[i9][p - 1] = -sn * V[i9][j4] + cs * V[i9][p - 1];
                            V[i9][j4] = t;
                        }
                    }
                    continue block46;
                }
                case 2: {
                    float sn;
                    float cs;
                    float t;
                    float f = e[k3 - 1];
                    e[k3 - 1] = 0.0f;
                    for (int j5 = k3; j5 < p; ++j5) {
                        t = Maths.hypot((float)s[j5], (float)f);
                        cs = s[j5] / t;
                        sn = f / t;
                        s[j5] = t;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        if (!wantu) continue;
                        for (int i10 = 0; i10 < m; ++i10) {
                            t = cs * U[i10][j5] + sn * U[i10][k3 - 1];
                            U[i10][k3 - 1] = -sn * U[i10][j5] + cs * U[i10][k3 - 1];
                            U[i10][j5] = t;
                        }
                    }
                    continue block46;
                }
                case 3: {
                    float scale = Math.max(Math.max(Math.max(Math.max(Math.abs(s[p - 1]), Math.abs(s[p - 2])), Math.abs(e[p - 2])), Math.abs(s[k3])), Math.abs(e[k3]));
                    float sp = s[p - 1] / scale;
                    float spm1 = s[p - 2] / scale;
                    float epm1 = e[p - 2] / scale;
                    float sk = s[k3] / scale;
                    float ek = e[k3] / scale;
                    float b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0f;
                    float c = sp * epm1 * (sp * epm1);
                    float shift = 0.0f;
                    if ((double)b != 0.0 | (double)c != 0.0) {
                        shift = (float)Math.sqrt(b * b + c);
                        if ((double)b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    float f = (sk + sp) * (sk - sp) + shift;
                    float g = sk * ek;
                    for (int j6 = k3; j6 < p - 1; ++j6) {
                        int i11;
                        float t = Maths.hypot((float)f, (float)g);
                        float cs = f / t;
                        float sn = g / t;
                        if (j6 != k3) {
                            e[j6 - 1] = t;
                        }
                        f = cs * s[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * s[j6];
                        g = sn * s[j6 + 1];
                        s[j6 + 1] = cs * s[j6 + 1];
                        if (wantv) {
                            for (i11 = 0; i11 < n; ++i11) {
                                t = cs * V[i11][j6] + sn * V[i11][j6 + 1];
                                V[i11][j6 + 1] = -sn * V[i11][j6] + cs * V[i11][j6 + 1];
                                V[i11][j6] = t;
                            }
                        }
                        t = Maths.hypot((float)f, (float)g);
                        cs = f / t;
                        sn = g / t;
                        s[j6] = t;
                        f = cs * e[j6] + sn * s[j6 + 1];
                        s[j6 + 1] = -sn * e[j6] + cs * s[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (!wantu || j6 >= m - 1) continue;
                        for (i11 = 0; i11 < m; ++i11) {
                            t = cs * U[i11][j6] + sn * U[i11][j6 + 1];
                            U[i11][j6 + 1] = -sn * U[i11][j6] + cs * U[i11][j6 + 1];
                            U[i11][j6] = t;
                        }
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if ((double)s[k3] <= 0.0) {
                        float f = s[k3] = (double)s[k3] < 0.0 ? -s[k3] : 0.0f;
                        if (wantv) {
                            for (int i12 = 0; i12 <= pp; ++i12) {
                                V[i12][k3] = -V[i12][k3];
                            }
                        }
                    }
                    while (k3 < pp && !(s[k3] >= s[k3 + 1])) {
                        int i13;
                        float t = s[k3];
                        s[k3] = s[k3 + 1];
                        s[k3 + 1] = t;
                        int Dummy = order[k3];
                        order[k3] = order[k3 + 1];
                        order[k3 + 1] = Dummy;
                        if (wantv && k3 < n - 1) {
                            for (i13 = 0; i13 < n; ++i13) {
                                t = V[i13][k3 + 1];
                                V[i13][k3 + 1] = V[i13][k3];
                                V[i13][k3] = t;
                            }
                        }
                        if (wantu && k3 < m - 1) {
                            for (i13 = 0; i13 < m; ++i13) {
                                t = U[i13][k3 + 1];
                                U[i13][k3 + 1] = U[i13][k3];
                                U[i13][k3] = t;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
        event.setDescription("End SVD calculation.\n");
        event.setIntValue(++eventValue);
        this.fireValueChanged(event);
        FloatMatrix T = new FloatMatrix(U, m, Math.min(m + 1, n));
        FloatMatrix Vm = new FloatMatrix(V, n, n);
        FloatMatrix S = new FloatMatrix(n, n);
        float[][] array = S.getArray();
        for (int i14 = 0; i14 < n; ++i14) {
            for (int j7 = 0; j7 < n; ++j7) {
                array[i14][j7] = 0.0f;
            }
            array[i14][i14] = s[i14];
        }
        AlgorithmData result = new AlgorithmData();
        switch (this.mode) {
            case 0: {
                break;
            }
            case 1: {
                result.addMatrix("U", An.times(T));
                break;
            }
            case 2: {
                result.addMatrix("U", An.transpose().times(T));
                break;
            }
            case 3: {
                if (!this.useShortcut) {
                    result.addMatrix("U", An.transpose().times(T));
                    break;
                }
                FloatMatrix Q = T.copy();
                FloatMatrix D = S.copy();
                int dim = D.getRowDimension();
                for (int i15 = 0; i15 < dim; ++i15) {
                    D.set(i15, i15, 1.0f / (float)Math.sqrt(D.get(i15, i15)));
                }
                T = An.times(Q.times(D));
                result.addMatrix("U", An.transpose().times(T));
                break;
            }
        }
        result.addMatrix("T", T);
        result.addMatrix("S", S);
        result.addMatrix("V", Vm);
        return result;
    }

    public void abort() {
        this.stop = true;
    }

    private FloatMatrix imputeKNearestMatrix(FloatMatrix inputMatrix, int k) throws AlgorithmException {
        int numRows = inputMatrix.getRowDimension();
        int numCols = inputMatrix.getColumnDimension();
        FloatMatrix resultMatrix = new FloatMatrix(numRows, numCols);
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        event.setDescription("Imputing missing values\n");
        this.fireValueChanged(event);
        event.setId(2);
        for (int i = 0; i < numRows; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            if (this.isMissingValues(inputMatrix, i)) {
                Vector<Integer> nonMissingExpts = new Vector<Integer>();
                for (int j = 0; j < numCols; ++j) {
                    if (Float.isNaN(inputMatrix.A[i][j])) continue;
                    nonMissingExpts.add(new Integer(j));
                }
                Vector geneSubset = this.getValidGenes(i, inputMatrix, nonMissingExpts);
                Vector kNearestGenes = this.getKNearestGenes(i, k, inputMatrix, geneSubset, nonMissingExpts);
                for (int j = 0; j < numCols; ++j) {
                    resultMatrix.A[i][j] = !Float.isNaN(inputMatrix.A[i][j]) ? inputMatrix.A[i][j] : this.getExptWeightedMean(i, j, kNearestGenes, inputMatrix);
                }
                continue;
            }
            for (int j = 0; j < numCols; ++j) {
                resultMatrix.A[i][j] = inputMatrix.A[i][j];
            }
        }
        resultMatrix = this.centerData(resultMatrix);
        return this.imputeRowAverageMatrix(resultMatrix);
    }

    private FloatMatrix imputeRowAverageMatrix(FloatMatrix inputMatrix) throws AlgorithmException {
        int numRows = inputMatrix.getRowDimension();
        int numCols = inputMatrix.getColumnDimension();
        FloatMatrix resultMatrix = new FloatMatrix(numRows, numCols);
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(event);
        event.setId(2);
        for (int i = 0; i < numRows; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            float[] currentRow = new float[numCols];
            float[] currentOrigRow = new float[numCols];
            for (int j = 0; j < numCols; ++j) {
                currentRow[j] = inputMatrix.A[i][j];
                currentOrigRow[j] = inputMatrix.A[i][j];
            }
            for (int k = 0; k < numCols; ++k) {
                if (!Float.isNaN(inputMatrix.A[i][k])) continue;
                currentRow[k] = this.getMean(currentOrigRow);
            }
            for (int l = 0; l < numCols; ++l) {
                resultMatrix.A[i][l] = currentRow[l];
            }
        }
        return resultMatrix;
    }

    private boolean isMissingValues(FloatMatrix mat, int row) {
        for (int i = 0; i < mat.getColumnDimension(); ++i) {
            if (!Float.isNaN(mat.A[row][i])) continue;
            return true;
        }
        return false;
    }

    private Vector getValidGenes(int gene, FloatMatrix mat, Vector validExpts) {
        Vector<Integer> validGenes = new Vector<Integer>();
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            if (!this.hasAllExpts(i, mat, validExpts) || gene == i) continue;
            validGenes.add(new Integer(i));
        }
        if (validGenes.size() < this.numNeighbors) {
            int additionalGenesNeeded = this.numNeighbors - validGenes.size();
            Vector additionalGenes = this.getAdditionalGenes(gene, additionalGenesNeeded, validGenes, mat);
            for (int i = 0; i < additionalGenes.size(); ++i) {
                validGenes.add((Integer)additionalGenes.get(i));
            }
        }
        return validGenes;
    }

    private Vector getAdditionalGenes(int currentGene, int numGenesNeeded, Vector alreadyPresentGenes, FloatMatrix mat) {
        Vector<Integer> additionalGenes = new Vector<Integer>();
        Vector<Integer> allGenes = new Vector<Integer>();
        Vector<Float> geneDistances = new Vector<Float>();
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            if (i == currentGene) continue;
            float currentDistance = ExperimentUtil.geneEuclidianDistance(mat, null, i, currentGene, this.factor);
            geneDistances.add(new Float(currentDistance));
            allGenes.add(new Integer(i));
        }
        float[] geneDistancesArray = new float[geneDistances.size()];
        for (int i = 0; i < geneDistances.size(); ++i) {
            float currentDist;
            geneDistancesArray[i] = currentDist = ((Float)geneDistances.get(i)).floatValue();
        }
        QSort sortGeneDistances = new QSort(geneDistancesArray);
        float[] sortedDistances = sortGeneDistances.getSorted();
        int[] sortedDistanceIndices = sortGeneDistances.getOrigIndx();
        int counter = 0;
        for (int i = 0; i < sortedDistanceIndices.length; ++i) {
            int currentIndex = sortedDistanceIndices[i];
            int currentNearestGene = (Integer)allGenes.get(currentIndex);
            if (this.belongsIn(alreadyPresentGenes, currentNearestGene)) continue;
            additionalGenes.add(new Integer(currentNearestGene));
            if (++counter >= numGenesNeeded) break;
        }
        return additionalGenes;
    }

    Vector getKNearestGenes(int gene, int k, FloatMatrix mat, Vector geneSubset, Vector nonMissingExpts) {
        Vector<Integer> allValidGenes = new Vector<Integer>();
        Vector<Integer> nearestGenes = new Vector<Integer>();
        Vector<Float> geneDistances = new Vector<Float>();
        for (int i = 0; i < geneSubset.size(); ++i) {
            int currentGene = (Integer)geneSubset.get(i);
            if (gene == currentGene) continue;
            float currentDistance = ExperimentUtil.geneEuclidianDistance(mat, null, gene, currentGene, this.factor);
            geneDistances.add(new Float(currentDistance));
            allValidGenes.add(new Integer(currentGene));
        }
        float[] geneDistancesArray = new float[geneDistances.size()];
        for (int i = 0; i < geneDistances.size(); ++i) {
            float currentDist;
            geneDistancesArray[i] = currentDist = ((Float)geneDistances.get(i)).floatValue();
        }
        QSort sortGeneDistances = new QSort(geneDistancesArray);
        float[] sortedDistances = sortGeneDistances.getSorted();
        int[] sortedDistanceIndices = sortGeneDistances.getOrigIndx();
        for (int i = 0; i < k; ++i) {
            int currentGeneIndex = sortedDistanceIndices[i];
            int currentNearestGene = (Integer)allValidGenes.get(currentGeneIndex);
            nearestGenes.add(new Integer(currentNearestGene));
        }
        return nearestGenes;
    }

    private float getExptWeightedMean(int gene, int expt, Vector geneVector, FloatMatrix mat) {
        float weightedMean = 0.0f;
        int validN = 0;
        float numerator = 0.0f;
        float[] recipNeighborDistances = new float[geneVector.size()];
        for (int i = 0; i < recipNeighborDistances.length; ++i) {
            int currentGene = (Integer)geneVector.get(i);
            if (!Float.isNaN(mat.A[currentGene][expt])) {
                float distance = ExperimentUtil.geneEuclidianDistance(mat, null, gene, currentGene, this.factor);
                if (distance == 0.0f) {
                    distance = Float.MIN_VALUE;
                }
                recipNeighborDistances[i] = 1.0f / distance;
                numerator += recipNeighborDistances[i] * mat.A[currentGene][expt];
                ++validN;
                continue;
            }
            recipNeighborDistances[i] = 0.0f;
        }
        float denominator = 0.0f;
        for (int i = 0; i < recipNeighborDistances.length; ++i) {
            denominator += recipNeighborDistances[i];
        }
        weightedMean = numerator / denominator;
        return weightedMean;
    }

    private float getMean(float[] row) {
        float mean = 0.0f;
        int validN = 0;
        for (int i = 0; i < row.length; ++i) {
            if (Float.isNaN(row[i])) continue;
            mean += row[i];
            ++validN;
        }
        if (validN == 0) {
            validN = 1;
        }
        return mean /= (float)validN;
    }

    private boolean hasAllExpts(int gene, FloatMatrix mat, Vector validExpts) {
        for (int i = 0; i < validExpts.size(); ++i) {
            int expIndex = (Integer)validExpts.get(i);
            if (!Float.isNaN(mat.A[gene][expIndex])) continue;
            return false;
        }
        return true;
    }

    private boolean belongsIn(Vector geneVector, int gene) {
        for (int i = 0; i < geneVector.size(); ++i) {
            int currentGene = (Integer)geneVector.get(i);
            if (gene != currentGene) continue;
            return true;
        }
        return false;
    }

    private FloatMatrix centerData(FloatMatrix expMatrix) {
        int k;
        float centerBy;
        int i;
        int colDim;
        int rowDim;
        if (this.center == 3) {
            return expMatrix;
        }
        if (this.mode == 3) {
            rowDim = expMatrix.getRowDimension();
            colDim = expMatrix.getColumnDimension();
            for (i = 0; i < rowDim; ++i) {
                centerBy = this.center == 1 ? this.computeMedian(expMatrix.A[i]) : this.computeMean(expMatrix.A[i]);
                k = 0;
                while (k < colDim) {
                    float[] fArray = expMatrix.A[i];
                    int n = k++;
                    fArray[n] = fArray[n] - centerBy;
                }
            }
        }
        if (this.mode == 1) {
            expMatrix = expMatrix.transpose();
            rowDim = expMatrix.getRowDimension();
            colDim = expMatrix.getColumnDimension();
            for (i = 0; i < rowDim; ++i) {
                centerBy = this.center == 1 ? this.computeMedian(expMatrix.A[i]) : this.computeMean(expMatrix.A[i]);
                k = 0;
                while (k < colDim) {
                    float[] fArray = expMatrix.A[i];
                    int n = k++;
                    fArray[n] = fArray[n] - centerBy;
                }
            }
            expMatrix = expMatrix.transpose();
        }
        return expMatrix;
    }

    private float computeMean(float[] array) {
        float toReturn = 0.0f;
        for (int i = 0; i < array.length; ++i) {
            toReturn += array[i];
        }
        return toReturn / (float)array.length;
    }

    private float computeMedian(float[] array) {
        float[] copy = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = array[i];
        }
        Arrays.sort(copy);
        int half = copy.length / 2;
        int remainder = copy.length % 2;
        if (remainder == 0) {
            return copy[half];
        }
        return copy[half];
    }
}

