/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.FDistribution;
import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class OneWayANOVA
extends AbstractAlgorithm {
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private boolean calculateAdjFDRPVals;
    private FloatMatrix expMatrix;
    private Vector[] clusters;
    private int k;
    private int numGenes;
    private int numExps;
    private int numGroups;
    private float alpha;
    private float falseProp;
    private boolean usePerms;
    private boolean drawSigTreesOnly;
    private int numPerms;
    private int falseNum;
    private int correctionMethod;
    int[] groupAssignments;
    private double[] origPVals;
    float currentP = 0.0f;
    int currentIndex = 0;
    double constant;
    AlgorithmEvent event;
    Vector fValuesVector = new Vector();
    Vector rawPValuesVector = new Vector();
    Vector adjPValuesVector = new Vector();
    Vector dfNumVector = new Vector();
    Vector dfDenomVector = new Vector();
    Vector ssGroupsVector = new Vector();
    Vector ssErrorVector = new Vector();
    private boolean[] isSig;
    private int hcl_function;
    private boolean hcl_absolute;
    private boolean useFastFDRApprox = true;
    int validN;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        int i2;
        this.groupAssignments = data.getIntArray("group-assignments");
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("distance-absolute", false);
        this.usePerms = map.getBoolean("usePerms", false);
        this.numPerms = map.getInt("numPerms", 0);
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        if (hierarchical_tree) {
            this.drawSigTreesOnly = map.getBoolean("draw-sig-trees-only");
        }
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.expMatrix = data.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.alpha = map.getFloat("alpha", 0.01f);
        this.correctionMethod = map.getInt("correction-method", 1);
        this.numGroups = map.getInt("numGroups", 3);
        this.calculateAdjFDRPVals = false;
        if (this.correctionMethod == 12) {
            this.falseNum = map.getInt("falseNum", 10);
        }
        if (this.correctionMethod == 13) {
            this.falseProp = map.getFloat("falseProp", 0.05f);
        }
        this.getFDfSSValues();
        if (this.correctionMethod == 12 || this.correctionMethod == 13) {
            int i3;
            this.rawPValuesVector = this.getRawPValuesFromFDist();
            this.origPVals = new double[this.rawPValuesVector.size()];
            for (i3 = 0; i3 < this.origPVals.length; ++i3) {
                this.origPVals[i3] = ((Float)this.rawPValuesVector.get(i3)).doubleValue();
            }
            this.adjPValuesVector = new Vector();
            for (i3 = 0; i3 < this.origPVals.length; ++i3) {
                this.adjPValuesVector.add(new Float(0.0f));
            }
        } else {
            this.rawPValuesVector = !this.usePerms ? this.getRawPValuesFromFDist() : this.getRawPValsFromPerms();
        }
        Vector clusterVector = new Vector();
        Vector<Integer> sigGenes = new Vector<Integer>();
        Vector<Integer> nonSigGenes = new Vector<Integer>();
        if (this.correctionMethod == 12 || this.correctionMethod == 13) {
            boolean[] isGeneSig = new boolean[1];
            isGeneSig = this.correctionMethod == 12 ? this.isGeneSigByFDRNum() : this.isGeneSigByFDRPropNew2();
            for (int i4 = 0; i4 < this.numGenes; ++i4) {
                if (isGeneSig[i4]) {
                    sigGenes.add(new Integer(i4));
                    continue;
                }
                nonSigGenes.add(new Integer(i4));
            }
        } else {
            this.adjPValuesVector = this.getAdjPVals(this.rawPValuesVector, this.correctionMethod);
            this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
            this.fireValueChanged(this.event);
            this.event.setId(2);
            for (int i5 = 0; i5 < this.numGenes; ++i5) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(i5);
                this.event.setDescription("Finding significant genes: Current gene = " + (i5 + 1));
                this.fireValueChanged(this.event);
                float currAdjP = ((Float)this.adjPValuesVector.get(i5)).floatValue();
                if (this.correctionMethod == 3) {
                    if (this.isSig[i5]) {
                        sigGenes.add(new Integer(i5));
                        continue;
                    }
                    nonSigGenes.add(new Integer(i5));
                    continue;
                }
                if (currAdjP <= this.alpha) {
                    sigGenes.add(new Integer(i5));
                    continue;
                }
                nonSigGenes.add(new Integer(i5));
            }
        }
        clusterVector.add(sigGenes);
        clusterVector.add(nonSigGenes);
        this.k = clusterVector.size();
        FloatMatrix fValuesMatrix = new FloatMatrix(this.fValuesVector.size(), 1);
        FloatMatrix rawPValuesMatrix = new FloatMatrix(this.rawPValuesVector.size(), 1);
        FloatMatrix adjPValuesMatrix = new FloatMatrix(this.adjPValuesVector.size(), 1);
        FloatMatrix dfNumMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix dfDenomMatrix = new FloatMatrix(this.numGenes, 1);
        for (i2 = 0; i2 < this.fValuesVector.size(); ++i2) {
            fValuesMatrix.A[i2][0] = ((Float)this.fValuesVector.get(i2)).floatValue();
        }
        for (i2 = 0; i2 < this.rawPValuesVector.size(); ++i2) {
            rawPValuesMatrix.A[i2][0] = ((Float)this.rawPValuesVector.get(i2)).floatValue();
            adjPValuesMatrix.A[i2][0] = ((Float)this.adjPValuesVector.get(i2)).floatValue();
        }
        for (i2 = 0; i2 < this.numGenes; ++i2) {
            dfNumMatrix.A[i2][0] = ((Integer)this.dfNumVector.get(i2)).floatValue();
            dfDenomMatrix.A[i2][0] = ((Integer)this.dfDenomVector.get(i2)).floatValue();
            if (dfNumMatrix.A[i2][0] <= 0.0f) {
                dfNumMatrix.A[i2][0] = Float.NaN;
            }
            if (!(dfDenomMatrix.A[i2][0] <= 0.0f)) continue;
            dfDenomMatrix.A[i2][0] = Float.NaN;
        }
        FloatMatrix ssGroupsMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix ssErrorMatrix = new FloatMatrix(this.numGenes, 1);
        for (i = 0; i < ssGroupsMatrix.getRowDimension(); ++i) {
            ssGroupsMatrix.A[i][0] = ((Double)this.ssGroupsVector.get(i)).floatValue();
            ssErrorMatrix.A[i][0] = ((Double)this.ssErrorVector.get(i)).floatValue();
        }
        this.clusters = new Vector[this.k];
        for (i = 0; i < this.k; ++i) {
            this.clusters[i] = (Vector)clusterVector.get(i);
        }
        FloatMatrix means = this.getMeans(this.clusters);
        FloatMatrix variances = this.getVariances(this.clusters, means);
        AlgorithmEvent event = null;
        if (hierarchical_tree) {
            event = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(event);
            event.setIntValue(0);
            event.setId(2);
            this.fireValueChanged(event);
        }
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i6 = 0; i6 < this.clusters.length; ++i6) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.convert2int(this.clusters[i6]);
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            if (this.drawSigTreesOnly) {
                if (i6 != 0) continue;
                node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
                event.setIntValue(i6 + 1);
                this.fireValueChanged(event);
                continue;
            }
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            event.setIntValue(i6 + 1);
            this.fireValueChanged(event);
        }
        AlgorithmData result = new AlgorithmData();
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        result.addMatrix("rawPValues", rawPValuesMatrix);
        result.addMatrix("adjPValues", adjPValuesMatrix);
        result.addMatrix("fValues", fValuesMatrix);
        result.addMatrix("dfNumMatrix", dfNumMatrix);
        result.addMatrix("dfDenomMatrix", dfDenomMatrix);
        result.addMatrix("ssGroupsMatrix", ssGroupsMatrix);
        result.addMatrix("ssErrorMatrix", ssErrorMatrix);
        result.addMatrix("geneGroupMeansMatrix", this.getAllGeneGroupMeans());
        result.addMatrix("geneGroupSDsMatrix", this.getAllGeneGroupSDs());
        return result;
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.getSubExperiment(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (Integer)source.get(i);
        }
        return int_matrix;
    }

    private FloatMatrix getMeans(Vector[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.numExps);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getMean(Vector cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.numExps);
        int n = cluster.size();
        int denom = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(((Integer)cluster.get(j)).intValue(), i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    private FloatMatrix getVariances(Vector[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleNormalizedSum(Vector cluster, int column, float mean) {
        int size = cluster.size();
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(((Integer)cluster.get(i)).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float getSampleVariance(Vector cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    private boolean[] isGeneSigByFDRPropNew2() throws AlgorithmException {
        double[] nonNanPVals = new double[this.origPVals.length];
        for (int i = 0; i < this.origPVals.length; ++i) {
            nonNanPVals[i] = Double.isNaN(this.origPVals[i]) ? Double.POSITIVE_INFINITY : this.origPVals[i];
        }
        QSort sortOrigPVals = new QSort(nonNanPVals, 1);
        double[] sortedOrigPVals = sortOrigPVals.getSortedDouble();
        int[] sortedIndices = sortOrigPVals.getOrigIndx();
        boolean[] isGeneSig = new boolean[this.numGenes];
        for (int i = 0; i < isGeneSig.length; ++i) {
            isGeneSig[i] = false;
        }
        double[] yKArray = this.getYKArray();
        if (sortedOrigPVals[0] >= yKArray[0]) {
            return isGeneSig;
        }
        isGeneSig[sortedIndices[0]] = true;
        if (this.useFastFDRApprox) {
            for (int i = 1; i < sortedOrigPVals.length; ++i) {
                int rGamma = (int)Math.floor((float)(i + 1) * this.falseProp);
                int rMinusOneGamma = (int)Math.floor((float)i * this.falseProp);
                double yKRGamma = yKArray[rGamma];
                if (rGamma <= rMinusOneGamma && !(sortedOrigPVals[i] < yKRGamma)) break;
                isGeneSig[sortedIndices[i]] = true;
            }
        }
        return isGeneSig;
    }

    private double[] getYKArray() throws AlgorithmException {
        AlgorithmEvent event2 = new AlgorithmEvent((Object)this, 1, this.numPerms);
        this.fireValueChanged(event2);
        event2.setId(2);
        int maxRGamma = (int)Math.floor((float)this.numGenes * this.falseProp);
        double[][] pValArray = new double[maxRGamma + 1][this.numPerms];
        Vector<Integer> validExpts = new Vector<Integer>();
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 0) continue;
            validExpts.add(new Integer(i));
        }
        int[] validArray = new int[validExpts.size()];
        for (int j = 0; j < validArray.length; ++j) {
            validArray[j] = (Integer)validExpts.get(j);
        }
        for (int i = 0; i < this.numPerms; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            event2.setIntValue(i);
            event2.setDescription("Permuting matrix: Current permutation = " + (i + 1));
            this.fireValueChanged(event2);
            int[] permutedExpts = this.getPermutedValues(this.numExps, validArray);
            FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
            float[] currPermFVals = this.getPermutedFVals(permutedMatrix);
            int[][] dfs = this.getDfs(permutedMatrix);
            double[] currPermPVals = this.getParametricPVals(currPermFVals, dfs[0], dfs[1]);
            for (int j = 0; j < currPermPVals.length; ++j) {
                if (!Double.isNaN(currPermPVals[j])) continue;
                currPermPVals[j] = Double.POSITIVE_INFINITY;
            }
            QSort sortCurrPVals = new QSort(currPermPVals, 1);
            double[] sortedCurrPVals = sortCurrPVals.getSortedDouble();
            for (int j = 0; j < pValArray.length; ++j) {
                pValArray[j][i] = sortedCurrPVals[j];
            }
        }
        double[] yKArray = new double[pValArray.length];
        for (int i = 0; i < pValArray.length; ++i) {
            int j;
            double[] currRow = new double[pValArray[i].length];
            for (j = 0; j < currRow.length; ++j) {
                currRow[j] = pValArray[i][j];
            }
            for (j = 0; j < currRow.length; ++j) {
                if (!Double.isNaN(currRow[j])) continue;
                currRow[j] = Double.POSITIVE_INFINITY;
            }
            QSort sortCurrRow = new QSort(currRow, 1);
            double[] sortedCurrRow = sortCurrRow.getSortedDouble();
            int selectedIndex = (int)Math.floor((float)sortedCurrRow.length * this.alpha) - 1;
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            yKArray[i] = sortedCurrRow[selectedIndex];
        }
        return yKArray;
    }

    private boolean[] isGeneSigByFDRNum() throws AlgorithmException {
        int i;
        double[] nonNanPVals = new double[this.origPVals.length];
        for (int i2 = 0; i2 < this.origPVals.length; ++i2) {
            nonNanPVals[i2] = Double.isNaN(this.origPVals[i2]) ? Double.POSITIVE_INFINITY : this.origPVals[i2];
        }
        QSort sortOrigPVals = new QSort(nonNanPVals, 1);
        double[] sortedOrigPVals = sortOrigPVals.getSortedDouble();
        int[] sortedIndices = sortOrigPVals.getOrigIndx();
        boolean[] isGeneSig = new boolean[this.numGenes];
        for (i = 0; i < isGeneSig.length; ++i) {
            isGeneSig[i] = false;
        }
        for (i = 0; i < this.falseNum; ++i) {
            isGeneSig[sortedIndices[i]] = true;
        }
        if (this.useFastFDRApprox) {
            double yK = this.getYConservative(this.alpha, this.falseNum);
            for (int i3 = this.falseNum; i3 < sortedOrigPVals.length && sortedOrigPVals[i3] < yK; ++i3) {
                isGeneSig[sortedIndices[i3]] = true;
            }
        } else {
            for (i = this.falseNum; i < this.origPVals.length; ++i) {
            }
        }
        return isGeneSig;
    }

    private double getYConservative(double alphaQuantile, int u) throws AlgorithmException {
        AlgorithmEvent event2 = new AlgorithmEvent((Object)this, 1, this.numPerms);
        this.fireValueChanged(event2);
        event2.setId(2);
        Vector<Double> uPlusOneSmallestPVector = new Vector<Double>();
        Vector<Integer> validExpts = new Vector<Integer>();
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 0) continue;
            validExpts.add(new Integer(i));
        }
        int[] validArray = new int[validExpts.size()];
        for (int j = 0; j < validArray.length; ++j) {
            validArray[j] = (Integer)validExpts.get(j);
        }
        for (int i = 0; i < this.numPerms; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(i);
            this.event.setDescription("Permuting matrix: Current permutation = " + (i + 1));
            this.fireValueChanged(this.event);
            int[] permutedExpts = this.getPermutedValues(this.numExps, validArray);
            FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
            float[] currPermFVals = this.getPermutedFVals(permutedMatrix);
            int[][] dfs = this.getDfs(permutedMatrix);
            double[] currPermPVals = this.getParametricPVals(currPermFVals, dfs[0], dfs[1]);
            for (int j = 0; j < currPermPVals.length; ++j) {
                if (!Double.isNaN(currPermPVals[j])) continue;
                currPermPVals[j] = Double.POSITIVE_INFINITY;
            }
            QSort sortCurrPVals = new QSort(currPermPVals, 1);
            double[] sortedCurrPVals = sortCurrPVals.getSortedDouble();
            uPlusOneSmallestPVector.add(new Double(sortedCurrPVals[u]));
        }
        double[] uPlusOneSmallestArray = new double[uPlusOneSmallestPVector.size()];
        for (int i = 0; i < uPlusOneSmallestPVector.size(); ++i) {
            uPlusOneSmallestArray[i] = (Double)uPlusOneSmallestPVector.get(i);
        }
        QSort sortUPlusOneArray = new QSort(uPlusOneSmallestArray, 1);
        double[] sortedUPlusOneArray = sortUPlusOneArray.getSortedDouble();
        int selectedIndex = (int)Math.floor((double)sortedUPlusOneArray.length * alphaQuantile) - 1;
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        return sortedUPlusOneArray[selectedIndex];
    }

    private int[][] getDfs(FloatMatrix permutedMatrix) {
        int[][] dfs = new int[2][this.numGenes];
        for (int gene = 0; gene < this.numGenes; ++gene) {
            dfs[0][gene] = this.getDfNum(gene, permutedMatrix);
            dfs[1][gene] = this.getDfDenom(gene, permutedMatrix);
        }
        return dfs;
    }

    private double[] getParametricPVals(float[] fVals, int[] dfNums, int[] dfDenoms) {
        double[] pVals = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            double currF = fVals[i];
            int currDfNum = dfNums[i];
            int currDfDenom = dfDenoms[i];
            if (Double.isNaN(currF) || currDfNum <= 0 || currDfDenom <= 0) {
                pVals[i] = Double.NaN;
                continue;
            }
            FDistribution fDist = new FDistribution((double)currDfNum, (double)currDfDenom);
            double cumulProb = fDist.cumulative(currF);
            double pValue = 1.0 - cumulProb;
            if (pValue > 1.0) {
                pValue = 1.0;
            }
            pVals[i] = pValue;
        }
        return pVals;
    }

    private void getFDfSSValues() throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        for (int gene = 0; gene < this.numGenes; ++gene) {
            float currentF = 0.0f;
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(gene);
            this.event.setDescription("Calculating F and df: Current gene = " + (gene + 1));
            this.fireValueChanged(this.event);
            float[] geneValues = new float[this.numExps];
            int n = 0;
            for (int i = 0; i < this.numExps; ++i) {
                geneValues[i] = this.expMatrix.A[gene][i];
                if (Float.isNaN(geneValues[i])) continue;
                ++n;
            }
            if (n == 0) {
                currentF = Float.NaN;
            }
            this.constant = this.getConstant(geneValues);
            double totalSS = this.getTotalSS(geneValues);
            double groupsSS = this.getGroupsSS(geneValues);
            double errorSS = totalSS - groupsSS;
            if (Double.isNaN(totalSS) || Double.isNaN(groupsSS) || Double.isNaN(errorSS)) {
                currentF = Float.NaN;
            }
            int groupsDF = this.getDfNum(gene);
            int errorDF = this.getDfDenom(gene);
            double groupsMS = groupsSS / (double)groupsDF;
            double errorMS = errorSS / (double)errorDF;
            if (!Float.isNaN(currentF)) {
                double fValue = groupsMS / errorMS;
                currentF = (float)fValue;
            }
            if (Float.isInfinite(currentF)) {
                currentF = Float.NaN;
            }
            this.fValuesVector.add(new Float(currentF));
            this.dfNumVector.add(new Integer(groupsDF));
            this.dfDenomVector.add(new Integer(errorDF));
            this.ssGroupsVector.add(new Double(groupsSS));
            this.ssErrorVector.add(new Double(errorSS));
        }
    }

    private Vector getRawPValuesFromFDist() {
        Vector<Float> rawPVals = new Vector<Float>();
        for (int i = 0; i < this.numGenes; ++i) {
            double currF = ((Float)this.fValuesVector.get(i)).doubleValue();
            int currDfNum = (Integer)this.dfNumVector.get(i);
            int currDfDenom = (Integer)this.dfDenomVector.get(i);
            if (Double.isNaN(currF) || currDfNum <= 0 || currDfDenom <= 0) {
                rawPVals.add(new Float(Float.NaN));
                continue;
            }
            FDistribution fDist = new FDistribution((double)currDfNum, (double)currDfDenom);
            double cumulProb = fDist.cumulative(currF);
            double pValue = 1.0 - cumulProb;
            if (pValue > 1.0) {
                pValue = 1.0;
            }
            rawPVals.add(new Float(pValue));
        }
        return rawPVals;
    }

    private Vector getRawPValsFromPerms() throws AlgorithmException {
        int i;
        this.event = new AlgorithmEvent((Object)this, 1, this.numPerms);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        float[] permPValues = new float[this.numGenes];
        for (int i2 = 0; i2 < this.numGenes; ++i2) {
            permPValues[i2] = 0.0f;
        }
        float[] origFValues = new float[this.fValuesVector.size()];
        for (int i3 = 0; i3 < this.fValuesVector.size(); ++i3) {
            origFValues[i3] = ((Float)this.fValuesVector.get(i3)).floatValue();
        }
        Vector<Integer> validExpts = new Vector<Integer>();
        for (int i4 = 0; i4 < this.groupAssignments.length; ++i4) {
            if (this.groupAssignments[i4] == 0) continue;
            validExpts.add(new Integer(i4));
        }
        int[] validArray = new int[validExpts.size()];
        for (int j = 0; j < validArray.length; ++j) {
            validArray[j] = (Integer)validExpts.get(j);
        }
        for (i = 0; i < this.numPerms; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(i);
            this.event.setDescription("Permuting matrix: Current permutation = " + (i + 1));
            this.fireValueChanged(this.event);
            int[] permutedExpts = this.getPermutedValues(this.numExps, validArray);
            FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
            float[] currPermFVals = this.getPermutedFVals(permutedMatrix);
            for (int j = 0; j < this.numGenes; ++j) {
                if (!(currPermFVals[j] > origFValues[j])) continue;
                int n = j;
                permPValues[n] = permPValues[n] + 1.0f;
            }
        }
        for (i = 0; i < this.numGenes; ++i) {
            permPValues[i] = Float.isNaN(origFValues[i]) ? Float.NaN : permPValues[i] / (float)this.numPerms;
        }
        Vector<Float> permPValsVector = new Vector<Float>();
        for (int i5 = 0; i5 < permPValues.length; ++i5) {
            permPValsVector.add(new Float(permPValues[i5]));
        }
        return permPValsVector;
    }

    private FloatMatrix getPermutedMatrix(FloatMatrix inputMatrix, int[] permExpts) {
        FloatMatrix permutedMatrix = new FloatMatrix(inputMatrix.getRowDimension(), inputMatrix.getColumnDimension());
        for (int i = 0; i < inputMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < inputMatrix.getColumnDimension(); ++j) {
                permutedMatrix.A[i][j] = inputMatrix.A[i][permExpts[j]];
            }
        }
        return permutedMatrix;
    }

    private float[] getPermutedFVals(FloatMatrix permMatrix) {
        float[] permFVals = new float[this.numGenes];
        for (int gene = 0; gene < this.numGenes; ++gene) {
            float currentF = 0.0f;
            float[] geneValues = new float[this.numExps];
            int n = 0;
            for (int i = 0; i < this.numExps; ++i) {
                geneValues[i] = permMatrix.A[gene][i];
                if (Float.isNaN(geneValues[i])) continue;
                ++n;
            }
            if (n == 0) {
                currentF = Float.NaN;
            }
            this.constant = this.getConstant(geneValues);
            double totalSS = this.getTotalSS(geneValues);
            double groupsSS = this.getGroupsSS(geneValues);
            double errorSS = totalSS - groupsSS;
            if (Double.isNaN(totalSS) || Double.isNaN(groupsSS) || Double.isNaN(errorSS)) {
                currentF = Float.NaN;
            }
            int groupsDF = this.getDfNum(gene, permMatrix);
            int errorDF = this.getDfDenom(gene, permMatrix);
            double groupsMS = groupsSS / (double)groupsDF;
            double errorMS = errorSS / (double)errorDF;
            if (!Float.isNaN(currentF)) {
                double fValue = groupsMS / errorMS;
                currentF = (float)fValue;
            }
            permFVals[gene] = currentF;
        }
        return permFVals;
    }

    private int[] getPermutedValues(int arrayLength, int[] validArray) {
        int i;
        int[] permutedValues = new int[arrayLength];
        for (int i2 = 0; i2 < permutedValues.length; ++i2) {
            permutedValues[i2] = i2;
        }
        int[] permutedValidArray = new int[validArray.length];
        for (i = 0; i < validArray.length; ++i) {
            permutedValidArray[i] = validArray[i];
        }
        for (i = permutedValidArray.length; i > 1; --i) {
            Random generator2 = new Random();
            int randVal = generator2.nextInt(i - 1);
            int temp = permutedValidArray[randVal];
            permutedValidArray[randVal] = permutedValidArray[i - 1];
            permutedValidArray[i - 1] = temp;
        }
        for (i = 0; i < validArray.length; ++i) {
            permutedValues[validArray[i]] = permutedValidArray[i];
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return permutedValues;
    }

    private Vector getAdjPVals(Vector rawPVals, int adjMethod) throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        Vector adjPVals = new Vector();
        if (adjMethod == 1) {
            adjPVals = (Vector)rawPVals.clone();
        }
        if (adjMethod == 2) {
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(i);
                this.event.setDescription("Computing adjusted p-values: Current gene = " + (i + 1));
                this.fireValueChanged(this.event);
                float currP = ((Float)rawPVals.get(i)).floatValue();
                float currAdjP = currP * (float)this.numGenes;
                if (currAdjP > 1.0f) {
                    currAdjP = 1.0f;
                }
                adjPVals.add(new Float(currAdjP));
            }
        }
        if (adjMethod == 3) {
            adjPVals = this.getAdjBonfPVals(rawPVals);
        }
        if (adjMethod == 9) {
            adjPVals = this.getMaxTPVals();
        }
        return adjPVals;
    }

    private Vector getMaxTPVals() throws AlgorithmException {
        int i;
        int i2;
        double[] origFValues = new double[this.numGenes];
        double[] descFValues = new double[this.numGenes];
        int[] descGeneIndices = new int[this.numGenes];
        double[] adjPValues = new double[this.numGenes];
        double[][] permutedRankedFValues = new double[this.numPerms][this.numGenes];
        double[][] uMatrix = new double[this.numGenes][this.numPerms];
        this.event = new AlgorithmEvent((Object)this, 1, this.numPerms);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        for (int i3 = 0; i3 < this.numGenes; ++i3) {
            origFValues[i3] = ((Float)this.fValuesVector.get(i3)).doubleValue();
        }
        QSort sortDescFValues = new QSort(origFValues, 2);
        descFValues = sortDescFValues.getSortedDouble();
        descGeneIndices = sortDescFValues.getOrigIndx();
        Vector<Integer> validExpts = new Vector<Integer>();
        for (int i4 = 0; i4 < this.groupAssignments.length; ++i4) {
            if (this.groupAssignments[i4] == 0) continue;
            validExpts.add(new Integer(i4));
        }
        int[] validArray = new int[validExpts.size()];
        for (int j = 0; j < validArray.length; ++j) {
            validArray[j] = (Integer)validExpts.get(j);
        }
        for (i2 = 0; i2 < this.numPerms; ++i2) {
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(i2);
            this.event.setDescription("Permuting matrix: Current permutation = " + (i2 + 1));
            this.fireValueChanged(this.event);
            int[] permutedExpts = this.getPermutedValues(this.numExps, validArray);
            FloatMatrix permutedMatrix = this.getPermutedMatrix(this.expMatrix, permutedExpts);
            float[] currPermFVals = this.getPermutedFVals(permutedMatrix);
            uMatrix[this.numGenes - 1][i2] = Double.isNaN(currPermFVals[descGeneIndices[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : (double)currPermFVals[descGeneIndices[this.numGenes - 1]];
            for (int j = this.numGenes - 2; j >= 0; --j) {
                uMatrix[j][i2] = Double.isNaN(currPermFVals[descGeneIndices[j]]) ? uMatrix[j + 1][i2] : Math.max(uMatrix[j + 1][i2], (double)currPermFVals[descGeneIndices[j]]);
            }
        }
        for (i2 = 0; i2 < this.numGenes; ++i2) {
            int pCounter = 0;
            for (int j = 0; j < this.numPerms; ++j) {
                if (!(uMatrix[i2][j] >= descFValues[i2])) continue;
                ++pCounter;
            }
            adjPValues[descGeneIndices[i2]] = (double)pCounter / (double)this.numPerms;
        }
        int NaNPCounter = 0;
        for (i = 0; i < this.numGenes; ++i) {
            if (!Double.isNaN(origFValues[i])) continue;
            adjPValues[i] = Double.NaN;
            ++NaNPCounter;
        }
        for (i = 1; i < this.numGenes - NaNPCounter; ++i) {
            adjPValues[descGeneIndices[i]] = Math.max(adjPValues[descGeneIndices[i]], adjPValues[descGeneIndices[i - 1]]);
        }
        Vector<Float> adPVector = new Vector<Float>();
        for (int i5 = 0; i5 < adjPValues.length; ++i5) {
            adPVector.add(new Float(adjPValues[i5]));
        }
        return adPVector;
    }

    private Vector getAdjBonfPVals(Vector rawPVals) {
        int i;
        int i2;
        float[] rawPValArray = new float[rawPVals.size()];
        this.isSig = new boolean[rawPValArray.length];
        for (i2 = 0; i2 < this.isSig.length; ++i2) {
            this.isSig[i2] = false;
        }
        for (i2 = 0; i2 < rawPValArray.length; ++i2) {
            rawPValArray[i2] = ((Float)rawPVals.get(i2)).floatValue();
        }
        float[] adjPValArray = new float[rawPValArray.length];
        QSort sortRawPs = new QSort(rawPValArray, 1);
        float[] sortedRawPVals = sortRawPs.getSorted();
        int[] origIndices = sortRawPs.getOrigIndx();
        int n = this.numGenes;
        adjPValArray[origIndices[0]] = sortedRawPVals[0] * (float)n;
        for (i = 1; i < this.numGenes; ++i) {
            if (sortedRawPVals[i - 1] < sortedRawPVals[i]) {
                --n;
            }
            if (n <= 0) {
                n = 1;
            }
            adjPValArray[origIndices[i]] = sortedRawPVals[i] * (float)n;
        }
        for (i = 0; i < adjPValArray.length; ++i) {
            if (!(adjPValArray[i] > 1.0f)) continue;
            adjPValArray[i] = 1.0f;
        }
        for (i = 0; i < origIndices.length && !((double)adjPValArray[origIndices[i]] > (double)this.alpha); ++i) {
            if (!((double)adjPValArray[origIndices[i]] <= (double)this.alpha)) continue;
            this.isSig[origIndices[i]] = true;
        }
        Vector<Float> adjBonPVals = new Vector<Float>();
        for (int i3 = 0; i3 < adjPValArray.length; ++i3) {
            adjBonPVals.add(new Float(adjPValArray[i3]));
        }
        return adjBonPVals;
    }

    private float[] getGene(int gene) {
        float[] currentGene = new float[this.expMatrix.getColumnDimension()];
        for (int i = 0; i < currentGene.length; ++i) {
            currentGene[i] = this.expMatrix.A[gene][i];
        }
        return currentGene;
    }

    private int getDfNum(int gene) {
        int n = 0;
        for (int i = 0; i < this.numExps; ++i) {
            if (Float.isNaN(this.expMatrix.A[gene][i]) || this.groupAssignments[i] == 0) continue;
            ++n;
        }
        if (n == 0) {
            return -1;
        }
        return this.numGroups - 1;
    }

    private int getDfDenom(int gene) {
        int n = 0;
        for (int i = 0; i < this.numExps; ++i) {
            if (Float.isNaN(this.expMatrix.A[gene][i]) || this.groupAssignments[i] == 0) continue;
            ++n;
        }
        if (n == 0) {
            return -1;
        }
        return n - this.numGroups;
    }

    private int getDfNum(int gene, FloatMatrix permMatrix) {
        int n = 0;
        for (int i = 0; i < this.numExps; ++i) {
            if (Float.isNaN(permMatrix.A[gene][i]) || this.groupAssignments[i] == 0) continue;
            ++n;
        }
        if (n == 0) {
            return -1;
        }
        return this.numGroups - 1;
    }

    private int getDfDenom(int gene, FloatMatrix permMatrix) {
        int n = 0;
        for (int i = 0; i < this.numExps; ++i) {
            if (Float.isNaN(permMatrix.A[gene][i]) || this.groupAssignments[i] == 0) continue;
            ++n;
        }
        if (n == 0) {
            return -1;
        }
        return n - this.numGroups;
    }

    private double getConstant(float[] geneValues) {
        double sum = 0.0;
        int n = 0;
        for (int i = 0; i < geneValues.length; ++i) {
            if (Float.isNaN(geneValues[i]) || this.groupAssignments[i] == 0) continue;
            sum += (double)geneValues[i];
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        double cons = Math.pow(sum, 2.0) / (double)n;
        return cons;
    }

    private double getTotalSS(float[] geneValues) {
        double ss = 0.0;
        int n = 0;
        for (int i = 0; i < geneValues.length; ++i) {
            if (Float.isNaN(geneValues[i]) || this.groupAssignments[i] == 0) continue;
            ss += Math.pow(geneValues[i], 2.0);
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        return ss -= this.constant;
    }

    private double getGroupsSS(float[] geneValues) {
        float[][] geneValuesByGroups = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        double[] avSquareArray = new double[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            avSquareArray[i] = this.getAvSquare(geneValuesByGroups[i]);
        }
        double ss = 0.0;
        for (int i = 0; i < this.numGroups; ++i) {
            ss += avSquareArray[i];
        }
        return ss - this.constant;
    }

    private float[] getGeneGroupMeans(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupMeans = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            geneGroupMeans[i] = this.getMean(geneValuesByGroups[i]);
        }
        return geneGroupMeans;
    }

    private float[] getGeneGroupSDs(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupSDs = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            geneGroupSDs[i] = this.getStdDev(geneValuesByGroups[i]);
        }
        return geneGroupSDs;
    }

    private float[] getGeneValuesForGroup(float[] geneValues, int group) {
        Vector<Float> groupValuesVector = new Vector<Float>();
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != group) continue;
            groupValuesVector.add(new Float(geneValues[i]));
        }
        float[] groupGeneValues = new float[groupValuesVector.size()];
        for (int i = 0; i < groupValuesVector.size(); ++i) {
            groupGeneValues[i] = ((Float)groupValuesVector.get(i)).floatValue();
        }
        return groupGeneValues;
    }

    private FloatMatrix getAllGeneGroupMeans() {
        FloatMatrix means = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < means.getRowDimension(); ++i) {
            means.A[i] = this.getGeneGroupMeans(i);
        }
        return means;
    }

    private FloatMatrix getAllGeneGroupSDs() {
        FloatMatrix sds = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < sds.getRowDimension(); ++i) {
            sds.A[i] = this.getGeneGroupSDs(i);
        }
        return sds;
    }

    private double getAvSquare(float[] values) {
        double ss = 0.0;
        double sum = 0.0;
        int n = 0;
        for (int i = 0; i < values.length; ++i) {
            if (Float.isNaN(values[i])) continue;
            sum += (double)values[i];
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        ss = Math.pow(sum, 2.0) / (double)n;
        return ss;
    }

    private float getMean(float[] group) {
        float sum = 0.0f;
        int n = 0;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sum += group[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float mean = sum / (float)n;
        if (Float.isInfinite(mean)) {
            return Float.NaN;
        }
        return mean;
    }

    private float getStdDev(float[] group) {
        float mean = this.getMean(group);
        int n = 0;
        float sumSquares = 0.0f;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sumSquares = (float)((double)sumSquares + Math.pow(group[i] - mean, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float var = sumSquares / (float)(n - 1);
        if (Float.isInfinite(var)) {
            return Float.NaN;
        }
        return (float)Math.sqrt(var);
    }
}

