/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.util.BootstrappedMatrixByExps;
import org.tigr.microarray.util.BootstrappedMatrixByGenes;
import org.tigr.microarray.util.JacknifedMatrixByExps;
import org.tigr.microarray.util.JacknifedMatrixByGenes;
import org.tigr.util.FloatMatrix;

public class NodeSupports
extends AbstractAlgorithm {
    public static final int NONE = 0;
    public static final int BOOT_EXPTS = 1;
    public static final int BOOT_GENES = 2;
    public static final int JACK_EXPTS = 3;
    public static final int JACK_GENES = 4;
    private boolean stop = false;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int k;
        HashSet origLeavesOfNodeN;
        int n;
        int[] resampArr2;
        int[] resampArr1;
        AlgorithmData resamp_algo_result;
        AlgorithmData resamp_algo_data;
        HCL resamp_algo;
        BootstrappedMatrixByExps resampMatrix;
        FloatMatrix resampExpMatrix;
        int i;
        int support;
        int denom;
        HashSet indexSetInResampledMatrix;
        int j;
        double[] supportPercentageArray;
        int[] denomArray;
        int[] supportArray;
        int numNodes;
        Vector childrenSetOfOrigTree;
        AlgorithmData sub_algo_result;
        AlgorithmParameters map = data.getParams();
        int function = map.getInt("distance-function", 4);
        float factor = map.getFloat("distance-factor", 1.0f);
        boolean absolute = map.getBoolean("distance-absolute", false);
        boolean drawGeneTree = map.getBoolean("drawGeneTree", true);
        boolean drawExptTree = map.getBoolean("drawExptTree", true);
        boolean optimizeGeneOrdering = map.getBoolean("optimize-gene-ordering");
        boolean optimizeSampleOrdering = map.getBoolean("optimize-sample-ordering");
        int method_linkage = map.getInt("method-linkage", 0);
        int geneTreeAnalysisOption = map.getInt("geneTreeAnalysisOption", 0);
        int exptTreeAnalysisOption = map.getInt("exptTreeAnalysisOption", 0);
        int geneTreeIterations = geneTreeAnalysisOption == 0 ? 0 : map.getInt("geneTreeIterations", 0);
        int exptTreeIterations = exptTreeAnalysisOption == 0 ? 0 : map.getInt("exptTreeIterations", 0);
        FloatMatrix expMatrix = data.getMatrix("experiment");
        this.printFloatMatrix(expMatrix);
        int number_of_genes = expMatrix.getRowDimension();
        int number_of_samples = expMatrix.getColumnDimension();
        HCL sub_algo = new HCL();
        AlgorithmData sub_algo_data = new AlgorithmData();
        sub_algo_data.addMatrix("experiment", expMatrix);
        sub_algo_data.addParam("distance-factor", String.valueOf(factor));
        sub_algo_data.addParam("distance-absolute", String.valueOf(absolute));
        sub_algo_data.addParam("hcl-distance-function", String.valueOf(function));
        sub_algo_data.addParam("method-linkage", String.valueOf(method_linkage));
        sub_algo_data.addParam("optimize-gene-ordering", String.valueOf(optimizeGeneOrdering));
        sub_algo_data.addParam("optimize-sample-ordering", String.valueOf(optimizeSampleOrdering));
        int iterations = drawGeneTree ? geneTreeIterations : exptTreeIterations;
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, iterations);
        this.fireValueChanged(event);
        event.setId(2);
        int[] child1Arr = null;
        int[] child2Arr = null;
        int[] nodeOrder = null;
        FloatMatrix height = null;
        Vector<Double> geneTreeSupportVector = new Vector<Double>();
        Vector<Double> exptTreeSupportVector = new Vector<Double>();
        if (drawExptTree) {
            sub_algo_data.addParam("calculate-genes", "false");
            sub_algo_result = sub_algo.execute(sub_algo_data);
            child1Arr = sub_algo_result.getIntArray("child-1-array");
            child2Arr = sub_algo_result.getIntArray("child-2-array");
            nodeOrder = sub_algo_result.getIntArray("node-order");
            height = sub_algo_result.getMatrix("height");
            sub_algo_data.addParam("optimize-gene-ordering", String.valueOf(optimizeGeneOrdering));
            sub_algo_data.addParam("optimize-sample-ordering", String.valueOf(optimizeSampleOrdering));
            this.printIntArray(child1Arr);
            this.printIntArray(child2Arr);
            this.printIntArray(nodeOrder);
            this.printFloatMatrix(height);
            childrenSetOfOrigTree = this.getAllSetsOfChildren(child1Arr, child2Arr);
            this.printVectorOfSets(childrenSetOfOrigTree);
            numNodes = childrenSetOfOrigTree.size();
            supportArray = new int[numNodes];
            denomArray = new int[numNodes];
            supportPercentageArray = new double[numNodes];
            for (j = 0; j < numNodes; ++j) {
                supportArray[j] = 0;
                denomArray[j] = 0;
            }
            indexSetInResampledMatrix = null;
            denom = 0;
            support = 0;
            for (i = 0; i < exptTreeIterations; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                event.setIntValue(i);
                event.setDescription("Sample Tree Resampling: iteration " + String.valueOf(i + 1));
                this.fireValueChanged(event);
                resampExpMatrix = null;
                if (exptTreeAnalysisOption == 1) {
                    resampMatrix = new BootstrappedMatrixByExps();
                    resampExpMatrix = resampMatrix.createResampExpMatrixObject(expMatrix);
                    indexSetInResampledMatrix = new HashSet(resampMatrix.resampledIndices);
                } else if (exptTreeAnalysisOption == 2) {
                    resampMatrix = new BootstrappedMatrixByGenes();
                    resampExpMatrix = resampMatrix.createResampExpMatrixObject(expMatrix);
                    indexSetInResampledMatrix = new HashSet(resampMatrix.resampledIndices);
                } else if (exptTreeAnalysisOption == 3) {
                    resampMatrix = new JacknifedMatrixByExps();
                    resampExpMatrix = resampMatrix.createResampExpMatrixObject(expMatrix);
                    indexSetInResampledMatrix = new HashSet(resampMatrix.resampledIndices);
                } else if (exptTreeAnalysisOption == 4) {
                    resampMatrix = new JacknifedMatrixByGenes();
                    resampExpMatrix = resampMatrix.createResampExpMatrixObject(expMatrix);
                    indexSetInResampledMatrix = new HashSet(resampMatrix.resampledIndices);
                }
                this.printFloatMatrix(resampExpMatrix);
                this.printHashSet(indexSetInResampledMatrix);
                resamp_algo = new HCL();
                resamp_algo_data = new AlgorithmData();
                resamp_algo_data.addMatrix("experiment", resampExpMatrix);
                resamp_algo_data.addParam("distance-factor", String.valueOf(factor));
                resamp_algo_data.addParam("distance-absolute", String.valueOf(absolute));
                resamp_algo_data.addParam("hcl-distance-function", String.valueOf(function));
                resamp_algo_data.addParam("method-linkage", String.valueOf(method_linkage));
                resamp_algo_data.addParam("calculate-genes", "false");
                resamp_algo_data.addParam("optimize-gene-ordering", String.valueOf(optimizeGeneOrdering));
                resamp_algo_data.addParam("optimize-sample-ordering", String.valueOf(optimizeSampleOrdering));
                resamp_algo_result = resamp_algo.execute(resamp_algo_data);
                resampArr1 = resamp_algo_result.getIntArray("child-1-array");
                resampArr2 = resamp_algo_result.getIntArray("child-2-array");
                this.printIntArray(resampArr1);
                this.printIntArray(resampArr2);
                Vector childrenSetOfResampTree = new Vector();
                childrenSetOfResampTree = this.getAllSetsOfChildren(resampArr1, resampArr2);
                this.printVectorOfSets(childrenSetOfResampTree);
                for (n = 0; n < numNodes; ++n) {
                    origLeavesOfNodeN = new HashSet();
                    origLeavesOfNodeN = (HashSet)childrenSetOfOrigTree.get(n);
                    this.printHashSet(origLeavesOfNodeN);
                    if (exptTreeAnalysisOption == 1 || exptTreeAnalysisOption == 3) {
                        if (indexSetInResampledMatrix.containsAll(origLeavesOfNodeN)) {
                            ++denom;
                            if (this.leafSetFound(origLeavesOfNodeN, childrenSetOfResampTree)) {
                                ++support;
                            }
                        }
                        int n2 = n;
                        supportArray[n2] = supportArray[n2] + support;
                        int n3 = n;
                        denomArray[n3] = denomArray[n3] + denom;
                        support = 0;
                        denom = 0;
                        continue;
                    }
                    if (exptTreeAnalysisOption != 2 && exptTreeAnalysisOption != 4) continue;
                    if (this.leafSetFound(origLeavesOfNodeN, childrenSetOfResampTree)) {
                        ++support;
                    }
                    int n4 = n;
                    supportArray[n4] = supportArray[n4] + support;
                    support = 0;
                }
            }
            if (exptTreeAnalysisOption == 1 || exptTreeAnalysisOption == 3) {
                for (k = 0; k < numNodes; ++k) {
                    supportPercentageArray[k] = denomArray[k] != 0 ? (double)(supportArray[k] * 100 / denomArray[k]) : -10.0;
                    exptTreeSupportVector.add(new Double(supportPercentageArray[k]));
                }
            } else if (exptTreeAnalysisOption == 2 || exptTreeAnalysisOption == 4) {
                for (k = 0; k < numNodes; ++k) {
                    supportPercentageArray[k] = supportArray[k] * 100 / exptTreeIterations;
                    exptTreeSupportVector.add(new Double(supportPercentageArray[k]));
                }
            }
        }
        if (drawGeneTree) {
            sub_algo_data.addParam("calculate-genes", "true");
            sub_algo_result = sub_algo.execute(sub_algo_data);
            child1Arr = sub_algo_result.getIntArray("child-1-array");
            child2Arr = sub_algo_result.getIntArray("child-2-array");
            nodeOrder = sub_algo_result.getIntArray("node-order");
            height = sub_algo_result.getMatrix("height");
            this.printIntArray(child1Arr);
            this.printIntArray(child2Arr);
            this.printIntArray(nodeOrder);
            this.printFloatMatrix(height);
            childrenSetOfOrigTree = this.getAllSetsOfChildren(child1Arr, child2Arr);
            this.printVectorOfSets(childrenSetOfOrigTree);
            numNodes = childrenSetOfOrigTree.size();
            supportArray = new int[numNodes];
            denomArray = new int[numNodes];
            supportPercentageArray = new double[numNodes];
            for (j = 0; j < numNodes; ++j) {
                supportArray[j] = 0;
                denomArray[j] = 0;
            }
            indexSetInResampledMatrix = null;
            denom = 0;
            support = 0;
            for (i = 0; i < geneTreeIterations; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                event.setIntValue(i);
                event.setDescription("Gene Tree Resampling: iteration " + String.valueOf(i + 1));
                this.fireValueChanged(event);
                resampExpMatrix = null;
                if (geneTreeAnalysisOption == 1) {
                    resampMatrix = new BootstrappedMatrixByExps();
                    resampExpMatrix = resampMatrix.createResampExpMatrixObject(expMatrix);
                    indexSetInResampledMatrix = new HashSet(resampMatrix.resampledIndices);
                } else if (geneTreeAnalysisOption == 2) {
                    resampMatrix = new BootstrappedMatrixByGenes();
                    resampExpMatrix = resampMatrix.createResampExpMatrixObject(expMatrix);
                    indexSetInResampledMatrix = new HashSet(resampMatrix.resampledIndices);
                } else if (geneTreeAnalysisOption == 3) {
                    resampMatrix = new JacknifedMatrixByExps();
                    resampExpMatrix = resampMatrix.createResampExpMatrixObject(expMatrix);
                    indexSetInResampledMatrix = new HashSet(resampMatrix.resampledIndices);
                } else if (geneTreeAnalysisOption == 4) {
                    resampMatrix = new JacknifedMatrixByGenes();
                    resampExpMatrix = resampMatrix.createResampExpMatrixObject(expMatrix);
                    indexSetInResampledMatrix = new HashSet(resampMatrix.resampledIndices);
                }
                this.printFloatMatrix(resampExpMatrix);
                this.printHashSet(indexSetInResampledMatrix);
                resamp_algo = new HCL();
                resamp_algo_data = new AlgorithmData();
                resamp_algo_data.addMatrix("experiment", resampExpMatrix);
                resamp_algo_data.addParam("distance-factor", String.valueOf(factor));
                resamp_algo_data.addParam("distance-absolute", String.valueOf(absolute));
                resamp_algo_data.addParam("hcl-distance-function", String.valueOf(function));
                resamp_algo_data.addParam("method-linkage", String.valueOf(method_linkage));
                resamp_algo_data.addParam("calculate-genes", "true");
                resamp_algo_data.addParam("optimize-gene-ordering", String.valueOf(optimizeGeneOrdering));
                resamp_algo_data.addParam("optimize-sample-ordering", String.valueOf(optimizeSampleOrdering));
                resamp_algo_result = resamp_algo.execute(resamp_algo_data);
                resampArr1 = resamp_algo_result.getIntArray("child-1-array");
                resampArr2 = resamp_algo_result.getIntArray("child-2-array");
                this.printIntArray(resampArr1);
                this.printIntArray(resampArr2);
                Vector childrenSetOfResampTree = new Vector();
                childrenSetOfResampTree = this.getAllSetsOfChildren(resampArr1, resampArr2);
                this.printVectorOfSets(childrenSetOfResampTree);
                for (n = 0; n < numNodes; ++n) {
                    origLeavesOfNodeN = new HashSet();
                    origLeavesOfNodeN = (HashSet)childrenSetOfOrigTree.get(n);
                    this.printHashSet(origLeavesOfNodeN);
                    if (geneTreeAnalysisOption == 2 || geneTreeAnalysisOption == 4) {
                        if (indexSetInResampledMatrix.containsAll(origLeavesOfNodeN)) {
                            ++denom;
                            if (this.leafSetFound(origLeavesOfNodeN, childrenSetOfResampTree)) {
                                ++support;
                            }
                        }
                        int n5 = n;
                        supportArray[n5] = supportArray[n5] + support;
                        int n6 = n;
                        denomArray[n6] = denomArray[n6] + denom;
                        support = 0;
                        denom = 0;
                        continue;
                    }
                    if (geneTreeAnalysisOption != 1 && geneTreeAnalysisOption != 3) continue;
                    if (this.leafSetFound(origLeavesOfNodeN, childrenSetOfResampTree)) {
                        ++support;
                    }
                    int n7 = n;
                    supportArray[n7] = supportArray[n7] + support;
                    support = 0;
                }
            }
            if (geneTreeAnalysisOption == 2 || geneTreeAnalysisOption == 4) {
                for (k = 0; k < numNodes; ++k) {
                    supportPercentageArray[k] = denomArray[k] != 0 ? (double)(supportArray[k] * 100 / denomArray[k]) : -10.0;
                    geneTreeSupportVector.add(new Double(supportPercentageArray[k]));
                }
            } else if (geneTreeAnalysisOption == 1 || geneTreeAnalysisOption == 3) {
                for (k = 0; k < numNodes; ++k) {
                    supportPercentageArray[k] = supportArray[k] * 100 / geneTreeIterations;
                    geneTreeSupportVector.add(new Double(supportPercentageArray[k]));
                }
            }
        }
        AlgorithmData result = new AlgorithmData();
        if (drawGeneTree) {
            FloatMatrix geneTreeSupportMatrix = new FloatMatrix(1, geneTreeSupportVector.size());
            for (int i2 = 0; i2 < geneTreeSupportVector.size(); ++i2) {
                geneTreeSupportMatrix.A[0][i2] = ((Double)geneTreeSupportVector.get(i2)).floatValue();
            }
            this.printFloatMatrix(geneTreeSupportMatrix);
            result.addMatrix("geneTreeSupportMatrix", geneTreeSupportMatrix);
        }
        if (drawExptTree) {
            FloatMatrix exptTreeSupportMatrix = new FloatMatrix(1, exptTreeSupportVector.size());
            for (int i3 = 0; i3 < exptTreeSupportVector.size(); ++i3) {
                exptTreeSupportMatrix.A[0][i3] = ((Double)exptTreeSupportVector.get(i3)).floatValue();
            }
            this.printFloatMatrix(exptTreeSupportMatrix);
            result.addMatrix("exptTreeSupportMatrix", exptTreeSupportMatrix);
        }
        result.addIntArray("orig-child-1-array", child1Arr);
        result.addIntArray("orig-child-2-array", child2Arr);
        result.addIntArray("orig-node-order", nodeOrder);
        result.addMatrix("orig-height", height);
        return result;
    }

    private void identifyChildren(int node, Vector v, int[] arr1, int[] arr2) {
        if (arr1[node] == -1) {
            return;
        }
        if (arr1[arr1[node]] == -1 && arr1[arr2[node]] == -1) {
            v.add(new Integer(arr1[node]));
            v.add(new Integer(arr2[node]));
            return;
        }
        if (arr1[arr1[node]] == -1 && arr1[arr2[node]] != -1) {
            v.add(new Integer(arr1[node]));
            this.identifyChildren(arr2[node], v, arr1, arr2);
            return;
        }
        if (arr1[arr1[node]] != -1 && arr1[arr2[node]] == -1) {
            this.identifyChildren(arr1[node], v, arr1, arr2);
            v.add(new Integer(arr2[node]));
            return;
        }
        if (arr1[arr1[node]] != -1 && arr1[arr2[node]] != -1) {
            this.identifyChildren(arr1[node], v, arr1, arr2);
            this.identifyChildren(arr2[node], v, arr1, arr2);
            return;
        }
    }

    private Vector getAllSetsOfChildren(int[] child1arr, int[] child2arr) {
        Vector allSetsOfChildren = new Vector();
        Vector childrenOfANode = new Vector();
        HashSet childrenSetOfANode = new HashSet();
        int nLeaves = child1arr.length / 2;
        for (int j = 0; j < nLeaves - 1; ++j) {
            if (this.stop) {
                return null;
            }
            this.identifyChildren(j + nLeaves, childrenOfANode, child1arr, child2arr);
            childrenSetOfANode = new HashSet(childrenOfANode);
            allSetsOfChildren.add(childrenSetOfANode);
            childrenOfANode = new Vector();
            childrenSetOfANode = new HashSet();
        }
        return allSetsOfChildren;
    }

    protected void printVectorOfSets(Vector v) {
    }

    protected void printHashSet(HashSet h) {
    }

    boolean leafSetFound(HashSet leavesAtANode, Vector leafSets) {
        boolean found = false;
        int n = leafSets.size();
        for (int i = 0; i < n; ++i) {
            HashSet leaves = new HashSet((Collection)leafSets.get(i));
            if (!leavesAtANode.equals(leaves)) continue;
            found = true;
            return found;
        }
        return found;
    }

    void printFloatMatrix(FloatMatrix matrix) {
    }

    void printIntArray(int[] array) {
    }
}

