/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Random;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.util.FloatMatrix;

public class NMF
extends AbstractAlgorithm {
    private static boolean standalone = false;
    private AlgorithmEvent event;
    float[][] connectivityMatrix;
    boolean stop = false;
    int r = 2;
    int numRuns = 10;
    int maxIterations = 10000;
    int numSamples;
    int numGenes;
    int checkFreq = 40;
    float[] costs = new float[this.numRuns];
    float[] costsIndex = new float[this.numRuns];
    float fractionDone;
    float fractionUnit;
    float cutoff = 10.0f;
    boolean divergence = true;
    boolean doSamples = true;
    boolean expScale = false;
    boolean adjustData = false;
    boolean doMax = false;
    long randomSeed = 33333L;
    long startTime;
    FloatMatrix expMatrix;
    FloatMatrix[] W = new FloatMatrix[this.numRuns];
    FloatMatrix[] H = new FloatMatrix[this.numRuns];
    int[][] clusters;
    private float tinyNumber = 1.0E-4f;
    static long timelast;
    long t1;
    long t2;
    long t3;
    long t4;
    long t5;
    long t6;
    long t7;
    long t8;
    ArrayList<Integer> leaves = new ArrayList();

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        AlgorithmParameters map = data.getParams();
        this.expMatrix = data.getMatrix("experiment");
        this.r = map.getInt("r-value");
        this.fractionDone = ((float)map.getInt("r-value") - (float)map.getInt("min- r-value")) / (1.0f + (float)map.getInt("max- r-value") - (float)map.getInt("min- r-value"));
        this.fractionUnit = 1.0f / (1.0f + (float)map.getInt("max- r-value") - (float)map.getInt("min- r-value"));
        this.numRuns = map.getInt("runs");
        this.maxIterations = map.getInt("iterations");
        this.divergence = map.getBoolean("divergence");
        this.doSamples = map.getBoolean("doSamples");
        this.expScale = map.getBoolean("expScale");
        this.doMax = map.getBoolean("doMax");
        this.checkFreq = map.getInt("checkFreq");
        this.cutoff = map.getFloat("cutoff");
        this.adjustData = map.getBoolean("adjustData");
        this.randomSeed = map.getLong("randomSeed");
        this.startTime = map.getLong("startTime");
        if (this.expMatrix == null) {
            throw new AlgorithmException("Input data is absent.");
        }
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Initializing...");
        this.fireValueChanged(this.event);
        this.W = new FloatMatrix[this.numRuns];
        this.H = new FloatMatrix[this.numRuns];
        this.costs = new float[this.numRuns];
        this.NMFMultiplicativeUpdate(this.dataPreProcessing(this.expMatrix.A));
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        if (this.stop) {
            throw new AbortException();
        }
        Node node = new Node();
        node.setValues(this.calculateHierarchicalTree());
        nodeList.addNode(node);
        this.clusters = this.getClusters(node);
        float cophen = this.getCopheneticCorrelation();
        AlgorithmData result = new AlgorithmData();
        result.addCluster("cluster", result_cluster);
        result.addIntMatrix("clusters", this.clusters);
        FloatMatrix means = this.getMeans(this.clusters);
        FloatMatrix variances = this.getMeans(this.clusters);
        result.addMatrix("connectivity-matrix", new FloatMatrix(this.connectivityMatrix));
        for (i = 0; i < this.numRuns; ++i) {
            result.addMatrix("W" + i, this.W[(int)this.costsIndex[i]]);
        }
        for (i = 0; i < this.numRuns; ++i) {
            result.addMatrix("H" + i, this.H[(int)this.costsIndex[i]]);
        }
        result.addMatrix("costs", new FloatMatrix(this.costs, this.costs.length));
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        result.addParam("cophen", String.valueOf(cophen));
        result.addParam("adjustData", String.valueOf(this.adjustData));
        return result;
    }

    private float getCopheneticCorrelation() {
        int j;
        int i;
        int j2;
        int i2;
        for (int i3 = 0; i3 < this.connectivityMatrix.length; ++i3) {
            for (int j3 = 0; j3 < this.connectivityMatrix[i3].length; ++j3) {
                this.connectivityMatrix[i3][j3] = 1.0f - this.connectivityMatrix[i3][j3];
            }
        }
        float[][] hclMatrix = new float[this.connectivityMatrix.length][this.connectivityMatrix.length];
        for (i2 = 0; i2 < hclMatrix.length; ++i2) {
            for (j2 = 0; j2 < hclMatrix[i2].length; ++j2) {
                hclMatrix[i2][j2] = 0.0f;
            }
        }
        for (i2 = 0; i2 < this.clusters.length; ++i2) {
            for (j2 = 0; j2 < this.clusters[i2].length; ++j2) {
                for (int k = 0; k < this.clusters[i2].length; ++k) {
                    hclMatrix[this.clusters[i2][j2]][this.clusters[i2][k]] = 1.0f;
                }
            }
        }
        float x = 0.0f;
        float t = 0.0f;
        float cTop = 0.0f;
        float cBottomL = 0.0f;
        float cBottomR = 0.0f;
        for (i = 0; i < hclMatrix.length; ++i) {
            for (j = 0; j < hclMatrix[i].length; ++j) {
                x += this.connectivityMatrix[i][j];
                t += hclMatrix[i][j];
            }
        }
        x /= (float)hclMatrix.length * (float)hclMatrix.length;
        t /= (float)hclMatrix.length * (float)hclMatrix.length;
        for (int j4 = 0; j4 < hclMatrix.length; ++j4) {
            for (int i4 = 0; i4 < j4; ++i4) {
                cTop += (this.connectivityMatrix[i4][j4] - x) * (hclMatrix[i4][j4] - t);
                cBottomL += (this.connectivityMatrix[i4][j4] - x) * (this.connectivityMatrix[i4][j4] - x);
                cBottomR += (hclMatrix[i4][j4] - t) * (hclMatrix[i4][j4] - t);
            }
        }
        for (i = 0; i < this.connectivityMatrix.length; ++i) {
            for (j = 0; j < this.connectivityMatrix[i].length; ++j) {
                this.connectivityMatrix[i][j] = 1.0f - this.connectivityMatrix[i][j];
            }
        }
        return cTop / (float)Math.sqrt(cBottomL * cBottomR);
    }

    protected FloatMatrix getMeans(int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.doSamples ? this.numSamples : this.numGenes);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    protected FloatMatrix getMean(int[] cluster) {
        FloatMatrix mean = new FloatMatrix(1, !this.doSamples ? this.numSamples : this.numGenes);
        float sum = 0.0f;
        for (int i = 0; i < (!this.doSamples ? this.numSamples : this.numGenes); ++i) {
            for (int j = 0; j < cluster.length; ++j) {
                if (this.doSamples) {
                    sum += this.expMatrix.get(i, cluster[j]);
                    continue;
                }
                sum += this.expMatrix.get(cluster[j], i);
            }
            mean.set(0, i, sum / (float)cluster.length);
        }
        return mean;
    }

    protected FloatMatrix getVariances(int[][] clusters, FloatMatrix means) {
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getVariance(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    protected FloatMatrix getVariance(int[] cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.numGenes);
        float sum = 0.0f;
        for (int i = 0; i < this.numGenes; ++i) {
            for (int j = 0; j < cluster.length; ++j) {
                if (this.doSamples) {
                    sum += this.expMatrix.get(i, cluster[j]);
                    continue;
                }
                sum += this.expMatrix.get(cluster[j], i);
            }
            mean.set(0, i, 0.0f);
        }
        return mean;
    }

    private int[][] getClusters(Node node) {
        int[][] clusters = new int[this.r][];
        HCLTreeData hcltd = this.getResult(node, 0);
        int[] child1 = hcltd.child_1_array;
        int[] child2 = hcltd.child_2_array;
        int index = 0;
        int i = 0;
        int cutoff = child1.length - this.r;
        while (index < this.r) {
            int node2;
            int node1 = child1[child1.length - 2 - i];
            if (node1 < cutoff) {
                this.leaves.clear();
                this.getLeavesFromNode(hcltd, node1);
                clusters[index] = new int[this.leaves.size()];
                for (int j = 0; j < clusters[index].length; ++j) {
                    clusters[index][j] = this.leaves.get(j);
                }
                ++index;
            }
            if ((node2 = child2[child1.length - 2 - i]) < cutoff) {
                this.leaves.clear();
                this.getLeavesFromNode(hcltd, node2);
                clusters[index] = new int[this.leaves.size()];
                for (int j = 0; j < clusters[index].length; ++j) {
                    clusters[index][j] = this.leaves.get(j);
                }
                ++index;
            }
            ++i;
        }
        return clusters;
    }

    private float[][] dataPreProcessing(float[][] datav) {
        int j;
        int i;
        float[][] v = new float[datav.length][];
        float expressionAverage = 0.0f;
        for (i = 0; i < v.length; ++i) {
            v[i] = new float[datav[i].length];
            for (j = 0; j < v[i].length; ++j) {
                v[i][j] = datav[i][j];
                if (v[i][j] < 0.0f || Float.isNaN(v[i][j])) {
                    this.adjustData = true;
                    continue;
                }
                expressionAverage += v[i][j];
            }
        }
        expressionAverage /= (float)v.length * (float)v[0].length;
        if (!this.adjustData) {
            return v;
        }
        if (this.expScale) {
            for (i = 0; i < v.length; ++i) {
                for (j = 0; j < v[0].length; ++j) {
                    if (Float.isNaN(v[i][j])) {
                        v[i][j] = 0.0f;
                    }
                    v[i][j] = (float)Math.exp(v[i][j]);
                }
            }
        } else {
            int j2;
            int i2;
            float minVal = Float.POSITIVE_INFINITY;
            for (i2 = 0; i2 < v.length; ++i2) {
                for (j2 = 0; j2 < v[0].length; ++j2) {
                    if (v[i2][j2] < minVal) {
                        minVal = v[i2][j2];
                        continue;
                    }
                    if (!Float.isNaN(v[i2][j2])) continue;
                    v[i2][j2] = expressionAverage;
                }
            }
            for (i2 = 0; i2 < v.length; ++i2) {
                for (j2 = 0; j2 < v[0].length; ++j2) {
                    v[i2][j2] = v[i2][j2] - minVal + this.tinyNumber;
                }
            }
        }
        return v;
    }

    private void NMFMultiplicativeUpdate(float[][] v) {
        int i;
        FloatMatrix V = new FloatMatrix(v);
        this.numGenes = v.length;
        this.numSamples = v[0].length;
        float[][] w = new float[this.numGenes][this.r];
        float[][] h = new float[this.r][this.numSamples];
        int sampsOrGenes = this.doSamples ? this.numSamples : this.numGenes;
        this.connectivityMatrix = new float[sampsOrGenes][sampsOrGenes];
        int totalTries = 0;
        Random random = new Random();
        if (this.randomSeed != -1L) {
            random.setSeed(this.randomSeed);
        }
        for (int runcount = 0; runcount < this.numRuns; ++runcount) {
            int i2;
            int[] classes;
            int j;
            int i3;
            this.fireValueChanged(this.event);
            if (this.stop) {
                return;
            }
            ++totalTries;
            for (i3 = 0; i3 < this.numGenes; ++i3) {
                for (j = 0; j < this.r; ++j) {
                    w[i3][j] = random.nextFloat() * 16.0f;
                }
            }
            for (i3 = 0; i3 < this.numSamples; ++i3) {
                for (j = 0; j < this.r; ++j) {
                    h[j][i3] = random.nextFloat();
                }
            }
            this.W[runcount] = new FloatMatrix(w);
            this.H[runcount] = new FloatMatrix(h);
            FloatMatrix Wt = this.W[runcount].transpose();
            FloatMatrix Ht = this.H[runcount].transpose();
            float previousCost = Float.POSITIVE_INFINITY;
            float cost = 0.0f;
            for (int iter = 0; iter < this.maxIterations; ++iter) {
                FloatMatrix WH;
                timelast = System.currentTimeMillis();
                this.updateProgressBar(iter, runcount);
                this.t1 += System.currentTimeMillis() - timelast;
                timelast = System.currentTimeMillis();
                if (!this.divergence) {
                    int j2;
                    int i4;
                    FloatMatrix WtV = Wt.times(V);
                    FloatMatrix WtWH = Wt.times(this.W[runcount]).times(this.H[runcount]);
                    float[][] h1 = new float[this.r][this.numSamples];
                    for (int i5 = 0; i5 < this.r; ++i5) {
                        for (int j3 = 0; j3 < this.numSamples; ++j3) {
                            h1[i5][j3] = this.H[runcount].get(i5, j3) * WtV.get(i5, j3) / WtWH.get(i5, j3);
                        }
                    }
                    this.H[runcount] = new FloatMatrix(h1);
                    FloatMatrix VHt = V.times(Ht);
                    FloatMatrix WHHt = this.W[runcount].times(this.H[runcount]).times(Ht);
                    for (i4 = 0; i4 < this.numGenes; ++i4) {
                        for (j2 = 0; j2 < this.r; ++j2) {
                            w[i4][j2] = this.W[runcount].get(i4, j2) * VHt.get(i4, j2) / WHHt.get(i4, j2);
                        }
                    }
                    this.W[runcount] = new FloatMatrix(w);
                    WH = this.W[runcount].times(this.H[runcount]);
                    cost = 0.0f;
                    for (i4 = 0; i4 < this.numGenes; ++i4) {
                        for (j2 = 0; j2 < this.numSamples; ++j2) {
                            cost += (float)Math.pow(V.A[i4][j2] - WH.A[i4][j2], 2.0);
                        }
                    }
                } else {
                    WH = this.W[runcount].times(this.H[runcount]);
                    this.t2 += System.currentTimeMillis() - timelast;
                    timelast = System.currentTimeMillis();
                    float[][] h1 = new float[this.r][this.numSamples];
                    for (int i6 = 0; i6 < this.r; ++i6) {
                        float sumk = 0.0f;
                        for (int k = 0; k < this.numGenes; ++k) {
                            sumk += this.W[runcount].get(k, i6);
                        }
                        this.t3 += System.currentTimeMillis() - timelast;
                        timelast = System.currentTimeMillis();
                        for (int j4 = 0; j4 < this.numSamples; ++j4) {
                            float sumi = 0.0f;
                            for (int k = 0; k < this.numGenes; ++k) {
                                sumi += this.W[runcount].get(k, i6) * V.get(k, j4) / WH.get(k, j4);
                            }
                            h1[i6][j4] = this.H[runcount].get(i6, j4) * sumi / sumk;
                        }
                    }
                    this.t4 += System.currentTimeMillis() - timelast;
                    timelast = System.currentTimeMillis();
                    this.H[runcount] = new FloatMatrix(h1);
                    WH = this.W[runcount].times(this.H[runcount]);
                    float[][] w1 = new float[this.numGenes][this.r];
                    for (int j5 = 0; j5 < this.r; ++j5) {
                        float sumk = 0.0f;
                        for (int k = 0; k < this.numSamples; ++k) {
                            sumk += this.H[runcount].get(j5, k);
                        }
                        for (int i7 = 0; i7 < this.numGenes; ++i7) {
                            float sumi = 0.0f;
                            for (int k = 0; k < this.numSamples; ++k) {
                                sumi += this.H[runcount].get(j5, k) * V.get(i7, k) / WH.get(i7, k);
                            }
                            w1[i7][j5] = this.W[runcount].get(i7, j5) * sumi / sumk;
                        }
                    }
                    this.t5 += System.currentTimeMillis() - timelast;
                    timelast = System.currentTimeMillis();
                    this.W[runcount] = new FloatMatrix(w1);
                    this.t6 += System.currentTimeMillis() - timelast;
                    timelast = System.currentTimeMillis();
                }
                if (this.doMax || iter % this.checkFreq != 0) continue;
                WH = this.W[runcount].times(this.H[runcount]);
                cost = this.getCost(V, WH);
                if (cost < 0.0f) {
                    return;
                }
                if (cost > previousCost - this.cutoff) break;
                previousCost = cost;
            }
            FloatMatrix WH = this.W[runcount].times(this.H[runcount]);
            this.costs[runcount] = cost = this.getCost(V, WH);
            if (this.doSamples) {
                classes = new int[this.numSamples];
                for (i2 = 0; i2 < this.numSamples; ++i2) {
                    float best = 0.0f;
                    for (int j6 = 0; j6 < this.r; ++j6) {
                        if (!(this.H[runcount].A[j6][i2] > best)) continue;
                        best = this.H[runcount].A[j6][i2];
                        classes[i2] = j6;
                    }
                }
                for (i2 = 0; i2 < this.numSamples; ++i2) {
                    for (int j7 = 0; j7 < this.numSamples; ++j7) {
                        if (classes[i2] != classes[j7]) continue;
                        float[] fArray = this.connectivityMatrix[i2];
                        int n = j7;
                        fArray[n] = fArray[n] + 1.0f;
                    }
                }
                continue;
            }
            classes = new int[this.numGenes];
            for (i2 = 0; i2 < this.numGenes; ++i2) {
                float best = 0.0f;
                for (int j8 = 0; j8 < this.r; ++j8) {
                    if (!(this.W[runcount].A[i2][j8] > best)) continue;
                    best = this.W[runcount].A[i2][j8];
                    classes[i2] = j8;
                }
            }
            for (i2 = 0; i2 < this.numGenes; ++i2) {
                for (int j9 = 0; j9 < this.numGenes; ++j9) {
                    if (classes[i2] != classes[j9]) continue;
                    float[] fArray = this.connectivityMatrix[i2];
                    int n = j9;
                    fArray[n] = fArray[n] + 1.0f;
                }
            }
        }
        this.costsIndex = new float[this.costs.length];
        for (i = 0; i < this.costsIndex.length; ++i) {
            this.costsIndex[i] = i;
        }
        ExperimentUtil.sort2(this.costs, this.costsIndex);
        for (i = 0; i < this.connectivityMatrix.length; ++i) {
            for (int j = 0; j < this.connectivityMatrix.length; ++j) {
                this.connectivityMatrix[i][j] = 1.0f - this.connectivityMatrix[i][j] / (float)this.numRuns;
            }
        }
    }

    private float getCost(FloatMatrix V, FloatMatrix WH) {
        float cost = 0.0f;
        for (int i = 0; i < this.numGenes; ++i) {
            for (int j = 0; j < this.numSamples; ++j) {
                float aij = V.A[i][j];
                float bij = WH.A[i][j];
                if (!Float.isNaN(cost += (float)((double)aij * Math.log(aij / bij) - (double)aij + (double)bij))) continue;
                System.out.println("cost is NaN");
                System.out.println("i " + i + "  j " + j);
                System.out.println("V.A[i][j] " + V.A[i][j]);
                System.out.println("WH.A[i][j] " + WH.A[i][j]);
                this.stop = true;
                return -1.0f;
            }
        }
        return cost;
    }

    public void updateProgressBar(int iter, int run) {
        if (standalone) {
            return;
        }
        this.event.setId(2);
        float fract = this.fractionDone + this.fractionUnit * ((float)run / (float)this.numRuns) + this.fractionUnit / (float)this.numRuns * (float)iter / (float)this.maxIterations;
        this.event.setIntValue((int)(100.0f * fract));
        int timeremaining = (int)((1.0f - fract) * ((float)(System.currentTimeMillis() - this.startTime) / fract / 1000.0f));
        String timeUnits = " seconds";
        if (timeremaining > 7200) {
            timeUnits = " hours";
            timeremaining = timeremaining / 3600 + 1;
        } else if (timeremaining > 90) {
            timeUnits = " minutes";
            timeremaining = timeremaining / 60 + 1;
        }
        String desc = "Evaluating " + this.r + " factors; \tRun: " + (run + 1) + " of " + this.numRuns + "; \tIteration: " + iter + "; \tTime remaining: " + timeremaining + timeUnits;
        this.event.setDescription(desc);
        this.fireValueChanged(this.event);
    }

    private void printMat(FloatMatrix fm) {
        System.out.println("start  " + fm);
        System.out.println("Dimensions: " + fm.getColumnDimension() + " X " + fm.getRowDimension());
        for (int i = 0; i < fm.getRowDimension(); ++i) {
            for (int j = 0; j < fm.getColumnDimension(); ++j) {
                System.out.print(fm.get(i, j) + "\t");
            }
            System.out.println();
        }
        System.out.println("end \n");
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private NodeValueList calculateHierarchicalTree() throws AlgorithmException {
        if (standalone) {
            return null;
        }
        this.event.setId(6);
        this.event.setDescription("Building Hierarchical Tree");
        this.fireValueChanged(this.event);
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        HCL hcl = new HCL();
        float[][] connMatForHCL = new float[this.connectivityMatrix.length][this.connectivityMatrix.length];
        for (int i = 0; i < this.connectivityMatrix.length; ++i) {
            for (int j = 0; j < this.connectivityMatrix[i].length; ++j) {
                connMatForHCL[i][j] = this.connectivityMatrix[i][j];
            }
        }
        data.addMatrix("experiment", new FloatMatrix(connMatForHCL));
        data.addParam("hcl-distance-function", String.valueOf(1));
        data.addParam("calculate-genes", String.valueOf(false));
        data.addParam("optimize-sample-ordering", String.valueOf(this.doSamples));
        AlgorithmData result = hcl.executeNMF(data, connMatForHCL);
        this.validate(result);
        this.addNodeValues(nodeList, result);
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    protected HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    private void getLeavesFromNode(HCLTreeData hcltd, int node) {
        if (node < (this.doSamples ? this.numSamples : this.numGenes)) {
            this.leaves.add(node);
            return;
        }
        if (hcltd.child_1_array[node] < (this.doSamples ? this.numSamples : this.numGenes)) {
            this.leaves.add(hcltd.child_1_array[node]);
        } else {
            this.getLeavesFromNode(hcltd, hcltd.child_1_array[node]);
        }
        if (hcltd.child_2_array[node] < (this.doSamples ? this.numSamples : this.numGenes)) {
            this.leaves.add(hcltd.child_2_array[node]);
        } else {
            this.getLeavesFromNode(hcltd, hcltd.child_2_array[node]);
        }
    }

    public static void main(String[] args) {
        timelast = System.currentTimeMillis();
        standalone = true;
        float[][] v1 = new float[][]{{16.0f, 32.0f, 72.0f, 40.0f}, {28.0f, 56.0f, 126.0f, 70.0f}, {4.0f, 8.0f, 18.0f, 10.0f}, {24.0f, 48.0f, 108.0f, 60.0f}};
        ArrayList<String> amounts = new ArrayList<String>();
        File file2 = new File("C://Users//Dan//workspace//MeV_4_4//data//BETR_5000_sample.txt");
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file2));
            while ((line = br.readLine()) != null) {
                amounts.add(line.trim());
            }
            br.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        float[][] v = new float[amounts.size()][];
        for (int i = 0; i < v.length; ++i) {
            String[] str = ((String)amounts.get(i)).split("\t");
            v[i] = new float[str.length];
            for (int j = 0; j < str.length; ++j) {
                v[i][j] = Float.parseFloat(str[j]);
            }
        }
        NMF nmf = new NMF();
        nmf.NMFMultiplicativeUpdate(nmf.dataPreProcessing(v));
        System.out.println(nmf.t1);
        System.out.println(nmf.t2);
        System.out.println(nmf.t3);
        System.out.println(nmf.t4);
        System.out.println(nmf.t5);
        System.out.println(nmf.t6);
        try {
            nmf.calculateHierarchicalTree();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

