/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import javax.swing.JOptionPane;
import org.rosuda.JRI.REXP;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.rhook.RHook;
import org.tigr.util.FloatMatrix;

public class MINET
extends AbstractAlgorithm {
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    private int progress;
    private FloatMatrix expMatrix;
    private FloatMatrix experimentData;
    private boolean stop = false;
    private int[] inGroupAssignments;
    private int numGenes;
    private int numExps;
    private boolean debug = false;
    private int testDesign;
    private String[] geneNames;
    private String[] sampleNames;
    private String methodName = null;
    private String estimatorName = null;
    private String discretizationName = null;
    private int bins = 0;
    protected FloatMatrix netAdjMatrix;
    protected String[] rowColIndices;
    private AlgorithmEvent event;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.geneNames = data.getStringArray("geneLabels");
        this.sampleNames = data.getStringArray("sampleLabels");
        this.methodName = map.getString("methodName");
        this.estimatorName = map.getString("estimatorName");
        this.discretizationName = map.getString("discretizationName");
        this.discretizationName = "equalwidth";
        this.bins = map.getInt("bins");
        this.testDesign = map.getInt("dataDesign");
        this.expMatrix = data.getMatrix("experiment");
        if (this.testDesign == 7) {
            int i;
            this.inGroupAssignments = data.getIntArray("group_assignments");
            int q = 0;
            for (int i2 = 0; i2 < this.inGroupAssignments.length; ++i2) {
                if (this.inGroupAssignments[i2] == 0) continue;
                ++q;
            }
            int[] groupAssignments = new int[q];
            q = 0;
            for (i = 0; i < this.inGroupAssignments.length; ++i) {
                if (this.inGroupAssignments[i] == 0) continue;
                groupAssignments[q] = i;
                ++q;
            }
            groupAssignments = new int[this.expMatrix.getColumnDimension()];
            for (i = 0; i < groupAssignments.length; ++i) {
                groupAssignments[i] = i;
            }
            System.out.println(this.expMatrix.getRowDimension() - 1 + ", " + groupAssignments.length);
            this.experimentData = this.expMatrix.getMatrix(0, this.expMatrix.getRowDimension() - 1, groupAssignments);
        }
        this.numGenes = this.experimentData.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.progress = 0;
        this.event = null;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Running MINET...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        this.runRAlg();
        AlgorithmData result = new AlgorithmData();
        result.addMatrix("network", this.netAdjMatrix);
        result.addStringArray("rowColIndices", this.rowColIndices);
        if (this.debug) {
            int i = 0;
            while ((double)i < 10.0) {
                int ii = i;
                while ((double)ii < 10.0) {
                    System.out.print(this.netAdjMatrix.get(i, ii) + ", ");
                    ++ii;
                }
                System.out.println();
                ++i;
            }
            System.out.println("Row Index ");
            for (i = 0; i < 10; ++i) {
                System.out.println("\tRow Index " + i + ": " + this.rowColIndices[i]);
            }
        }
        this.updateProgressBar();
        return result;
    }

    public void runRAlg() throws AbortException {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        try {
            if (RHook.startRSession() == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        this.updateProgressBar();
        try {
            if (RHook.getOS() == 3) {
                RHook.testPackage((String)"minet");
            } else {
                RHook.installModule((String)"minet");
            }
            RHook.log((String)"Starting R Algorithim");
            String rCmd = "library(infotheo)";
            RHook.evalR((String)rCmd);
            rCmd = "library(minet)";
            RHook.evalR((String)rCmd);
            rCmd = "data(syn.data)";
            RHook.evalR((String)rCmd);
            this.updateProgressBar();
            String fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "tmpfile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            String filePath = this.writeMatrixToFile(fileLoc, this.expMatrix, this.geneNames);
            RHook.createRDataMatrixFromFile((String)"y", (String)filePath, (boolean)true, (String[])this.sampleNames);
            this.updateProgressBar();
            rCmd = "t_y <- as.data.frame(t(y))";
            RHook.evalR((String)rCmd);
            rCmd = "res<-minet(t_y,\"" + this.methodName + "\",\"" + this.estimatorName + "\",\"" + this.discretizationName + "\"," + this.bins + ")";
            REXP res = RHook.evalR((String)rCmd);
            this.updateProgressBar();
            double[][] network = res.asMatrix();
            float[][] netadjmat = new float[network.length][network.length];
            for (int row = 0; row < network.length; ++row) {
                for (int cow = 0; cow < network.length; ++cow) {
                    netadjmat[row][cow] = (float)network[row][cow];
                }
            }
            this.netAdjMatrix = new FloatMatrix(netadjmat);
            res = RHook.evalR((String)"colnames(res)");
            this.rowColIndices = res.asStringArray();
            this.updateProgressBar();
            RHook.endRSession();
            this.removeTmps(filePath);
            this.updateProgressBar();
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
                throw new AbortException();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    protected FloatMatrix getPermutedMatrix(FloatMatrix inputMatrix) {
        int[] validArray = new int[this.numGenes];
        for (int j = 0; j < validArray.length; ++j) {
            validArray[j] = j;
        }
        FloatMatrix permutedMatrix = new FloatMatrix(inputMatrix.getRowDimension(), inputMatrix.getColumnDimension());
        for (int i = 0; i < inputMatrix.getColumnDimension(); ++i) {
            int[] permGenes = MINET.getPermutedValues(this.numGenes, validArray);
            for (int j = 0; j < inputMatrix.getRowDimension(); ++j) {
                permutedMatrix.A[j][i] = inputMatrix.A[permGenes[j]][i];
            }
        }
        return permutedMatrix;
    }

    protected static int[] getPermutedValues(int arrayLength, int[] validArray) {
        int i;
        int[] permutedValues = new int[arrayLength];
        for (int i2 = 0; i2 < permutedValues.length; ++i2) {
            permutedValues[i2] = i2;
        }
        int[] permutedValidArray = new int[validArray.length];
        for (i = 0; i < validArray.length; ++i) {
            permutedValidArray[i] = validArray[i];
        }
        for (i = permutedValidArray.length; i > 1; --i) {
            Random generator2 = new Random();
            int randVal = generator2.nextInt(i - 1);
            int temp = permutedValidArray[randVal];
            permutedValidArray[randVal] = permutedValidArray[i - 1];
            permutedValidArray[i - 1] = temp;
        }
        for (i = 0; i < validArray.length; ++i) {
            permutedValues[validArray[i]] = permutedValidArray[i];
        }
        return permutedValues;
    }

    private void updateProgressBar() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / 5);
        this.fireValueChanged(this.event);
    }

    private String writeMatrixToFile(String fileLoc, FloatMatrix fm, String[] rowNames) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
        int row = fm.getRowDimension();
        int col = fm.getColumnDimension();
        String srtVector = "";
        if (this.debug) {
            System.out.println("row, col, rowName " + row);
            System.out.println("row, col, rowName " + col);
            System.out.println("row, col, rowName " + rowNames[1]);
        }
        for (int iRow = 0; iRow < row; ++iRow) {
            srtVector = rowNames[iRow] + "\t";
            for (int jCol = 0; jCol < col; ++jCol) {
                srtVector = jCol == col - 1 ? srtVector + fm.get(iRow, jCol) + "\n" : srtVector + fm.get(iRow, jCol) + "\t";
            }
            out.write(srtVector);
            srtVector = "";
        }
        out.close();
        return fileLoc;
    }

    private void removeTmps(String fileName) {
        File f = new File(fileName);
        f.delete();
    }

    public void runR_AttractAlg() throws AbortException {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        try {
            if (RHook.startRSession() == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        try {
            String libPath = System.getenv("R_HOME");
            libPath = libPath.replace("\\", "/");
            libPath = libPath + "/library";
            String rCmd = ".libPaths('" + libPath + "')";
            System.out.println("libPath cmd " + rCmd);
            RHook.evalR((String)rCmd);
            rCmd = ".libPaths()";
            REXP rx = RHook.evalR((String)rCmd);
            System.out.println("Curr libPath " + rx.asStringArray()[0]);
            RHook.testPackage((String)"attract");
            String srcLoc = "C:/Projects/ATTRACT/Mev-Attract_Code/";
            rCmd = "loc='" + srcLoc + "'";
            RHook.evalR((String)rCmd);
            String scriptR = srcLoc + "MeV-RCode.R";
            rCmd = "source('" + scriptR + "')";
            RHook.evalR((String)rCmd);
            rCmd = "length(remove_these_genes)";
            rx = RHook.evalR((String)rCmd);
            int len = rx.asInt();
            RHook.endRSession();
            System.out.println("Length of vector remove.these.genes " + len);
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        int[] array = new int[]{0, 1};
        for (int i = 0; i < array.length; ++i) {
            System.out.print(array[i] + "\t");
        }
        System.out.println(":" + array.length);
        int[] result = MINET.getPermutedValues(array.length, array);
        for (int i = 0; i < result.length; ++i) {
            System.out.print(result[i] + "\t");
        }
    }
}

