/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Arrays;

public class LengthBiasPValues {
    private float[] sigGenes;
    private float[] probWeightFunction;
    private int[][] genesets;
    private float numSig;
    private float percentSig;
    private float[] sigPerGeneSet;
    private float[] expectedSigPerGeneSet;

    public LengthBiasPValues(float[] sig, float[] pwf, int[][] genesets) {
        this.sigGenes = sig;
        this.probWeightFunction = pwf;
        this.genesets = genesets;
        this.numSig = 0.0f;
        for (int i = 0; i < this.sigGenes.length; ++i) {
            this.numSig += this.sigGenes[i];
        }
        this.percentSig = this.numSig / (float)sig.length;
        if (this.probWeightFunction == null) {
            this.probWeightFunction = this.createFakePWF();
        }
        this.expectedSigPerGeneSet = this.calcExpectedSigPerGeneSet();
    }

    public float[] getExpectedSigPerGeneSet() {
        return this.expectedSigPerGeneSet;
    }

    public float[] getSigPerGeneSet() {
        return this.sigPerGeneSet;
    }

    private float[] calcExpectedSigPerGeneSet() {
        float[] expSigPer = new float[this.genesets.length];
        for (int i = 0; i < this.genesets.length; ++i) {
            float gsTot = 0.0f;
            for (int j = 0; j < this.genesets[i].length; ++j) {
                gsTot += this.probWeightFunction[this.genesets[i][j]];
            }
            expSigPer[i] = gsTot;
        }
        return expSigPer;
    }

    private float[] createFakePWF() {
        int numGenes = this.sigGenes.length;
        float[] pwf = new float[numGenes];
        for (int i = 0; i < numGenes; ++i) {
            pwf[i] = this.percentSig;
        }
        return pwf;
    }

    public float[] getPValuesForGeneSets(int numPerms) {
        int j;
        int i;
        int numGeneSets = this.genesets.length;
        float[][] permSigPerGeneset = new float[numGeneSets][numPerms];
        float[] permSig = new float[]{};
        for (i = 0; i < numPerms; ++i) {
            permSig = this.getPermSig(this.probWeightFunction);
            float[] sigPerGeneSet = this.getSigPerGeneSet(this.genesets, permSig);
            for (j = 0; j < numGeneSets; ++j) {
                permSigPerGeneset[j][i] = sigPerGeneSet[j];
            }
        }
        for (i = 0; i < numGeneSets; ++i) {
            Arrays.sort(permSigPerGeneset[i]);
        }
        this.sigPerGeneSet = this.getSigPerGeneSet(this.genesets, this.sigGenes);
        float[] geneSetPValues = new float[numGeneSets];
        for (int i2 = 0; i2 < numGeneSets; ++i2) {
            for (j = 0; j < permSigPerGeneset[i2].length && !(permSigPerGeneset[i2][permSigPerGeneset[i2].length - (j + 1)] < this.sigPerGeneSet[i2]); ++j) {
            }
            geneSetPValues[i2] = (float)j / (float)numPerms;
        }
        return geneSetPValues;
    }

    private float[] getPermSig(float[] pwf) {
        float[] permSig = new float[pwf.length];
        for (int i = 0; i < pwf.length; ++i) {
            if (Math.random() > (double)pwf[i]) continue;
            permSig[i] = 1.0f;
        }
        return permSig;
    }

    private int[] getPermSig2(float[] pwf, int sigGeneSize) {
        int[] permSig = new int[pwf.length];
        int i = 0;
        while (i < sigGeneSize) {
            int selected = (int)(Math.random() * (double)permSig.length);
            if (permSig[selected] == 1 || Math.random() > (double)pwf[selected]) continue;
            permSig[selected] = 1;
            ++i;
        }
        return permSig;
    }

    private float[] getSigPerGeneSet(int[][] genesets, float[] sig) {
        float[] sigPerGeneSet = new float[genesets.length];
        for (int i = 0; i < genesets.length; ++i) {
            for (int j = 0; j < genesets[i].length; ++j) {
                if (sig[genesets[i][j]] != 1.0f) continue;
                int n = i;
                sigPerGeneSet[n] = sigPerGeneSet[n] + 1.0f;
            }
        }
        return sigPerGeneSet;
    }

    public static void main(String[] args) {
        float[] sig = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        float[] pwf = new float[]{0.1f, 0.2f, 0.5f, 0.1f, 0.61f, 0.6f, 0.7f, 0.02f, 0.4f, 0.5f, 0.4f, 0.3f, 0.13f, 0.1f, 0.2f, 0.05f, 0.1f, 0.11f, 0.6f, 0.7f, 0.02f, 0.04f, 0.5f, 0.4f, 0.3f, 0.13f, 0.1f, 0.2f, 0.05f, 0.1f, 0.11f, 0.6f};
        int[][] genesets = new int[][]{{0, 1, 3, 5, 7, 9, 11}, {2, 4, 6, 8, 10, 12}, {13, 14, 15, 16}, {17, 18, 19, 20, 21, 22, 23, 24, 25, 26}, {27, 28, 29, 30, 31}};
        int numPerms = 100000;
        LengthBiasPValues obj = new LengthBiasPValues(sig, pwf, genesets);
        obj.getPValuesForGeneSets(numPerms);
        for (int i = 0; i < obj.sigPerGeneSet.length; ++i) {
            System.out.println(obj.sigPerGeneSet[i]);
        }
    }
}

