/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.Rengine;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.rhook.RHook;
import org.tigr.util.FloatMatrix;

public class LIMMA
extends AbstractAlgorithm {
    private int progress;
    private FloatMatrix expMatrix;
    private boolean stop = false;
    private int[] groupAssignments;
    private int[][] sigGenesArrays;
    private int[] mapping;
    private int[] mapping2;
    private String nameA;
    private String nameB;
    private int numGenes;
    private int numExps;
    private int numGroups;
    private int iteration;
    private int numAGroups;
    private int numBGroups;
    private float alpha;
    private boolean drawSigTreesOnly;
    private int hcl_function;
    private boolean hcl_absolute;
    private boolean hcl_genes_ordered;
    private boolean hcl_samples_ordered;
    private int dataDesign;
    private AlgorithmEvent event;
    private String[] geneNames;
    private String[] sampleNames;
    private float[][] lfc;
    private float[][] t;
    private float[][] logOdds;
    private float[][] pValues;
    private float[][] adjPvalues;
    private float[] fValues;
    int validN;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        AlgorithmParameters map = data.getParams();
        this.expMatrix = data.getMatrix("experiment");
        this.groupAssignments = data.getIntArray("group_assignments");
        this.dataDesign = map.getInt("dataDesign");
        this.alpha = map.getFloat("alpha");
        this.numGroups = map.getInt("numGroups");
        this.nameA = map.getString("nameA");
        this.nameB = map.getString("nameB");
        this.numAGroups = map.getInt("numAGroups");
        this.numBGroups = map.getInt("numBGroups");
        this.geneNames = data.getStringArray("geneLabels");
        this.sampleNames = data.getStringArray("sampleLabels");
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        this.hcl_genes_ordered = map.getBoolean("hcl-genes-ordered", false);
        this.hcl_samples_ordered = map.getBoolean("hcl-samples-ordered", false);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        if (hierarchical_tree) {
            this.drawSigTreesOnly = map.getBoolean("draw-sig-trees-only");
        }
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.mapping = new int[this.expMatrix.getRowDimension()];
        for (i = 0; i < this.mapping.length; ++i) {
            this.mapping[i] = i;
        }
        this.mapping2 = new int[this.expMatrix.getRowDimension()];
        for (i = 0; i < this.mapping2.length; ++i) {
            this.mapping2[i] = i;
        }
        this.progress = 0;
        this.event = null;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Calculating...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        this.runRAlg();
        if (this.stop) {
            throw new AbortException();
        }
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        AlgorithmData result = new AlgorithmData();
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i2 = 0; i2 < this.sigGenesArrays.length; ++i2) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.sigGenesArrays[i2];
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            if (this.drawSigTreesOnly) {
                if (i2 != 0) continue;
                node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
                this.event.setIntValue(i2 + 1);
                this.fireValueChanged(this.event);
                continue;
            }
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            this.event.setIntValue(i2 + 1);
            this.fireValueChanged(this.event);
        }
        int[][] sigReturn = new int[this.sigGenesArrays.length][];
        for (int i3 = 0; i3 < this.sigGenesArrays.length; ++i3) {
            sigReturn[i3] = new int[this.sigGenesArrays[i3].length];
            for (int j = 0; j < this.sigGenesArrays[i3].length; ++j) {
                sigReturn[i3][j] = this.mapping2[this.mapping[this.sigGenesArrays[i3][j]]];
            }
        }
        result.addIntMatrix("sigGenesArrays", (int[][])sigReturn);
        result.addParam("iterations", String.valueOf(this.iteration - 1));
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", "1");
        result.addMatrix("geneGroupMeansMatrix", this.getAllGeneGroupMeans());
        result.addMatrix("geneGroupSDsMatrix", this.getAllGeneGroupSDs());
        result.addMatrix("pValues", this.getPValues());
        result.addMatrix("adjPValues", this.getAdjPValues());
        result.addMatrix("lfc", this.getLogFoldChanges());
        result.addMatrix("logOdds", this.getLogOdds());
        result.addMatrix("tStat", this.getTStatistic());
        result.addMatrix("fValues", this.getFValues());
        return result;
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.getSubExperiment(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            data.addParam("optimize-gene-ordering", String.valueOf(this.hcl_genes_ordered));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            data.addParam("optimize-sample-ordering", String.valueOf(this.hcl_samples_ordered));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private float[] getGeneGroupMeans(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupMeans = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            geneGroupMeans[i] = this.getMean(geneValuesByGroups[i]);
        }
        return geneGroupMeans;
    }

    private float[] getGeneGroupSDs(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupSDs = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            geneGroupSDs[i] = this.getStdDev(geneValuesByGroups[i]);
        }
        return geneGroupSDs;
    }

    private float[] getGeneValuesForGroup(float[] geneValues, int group) {
        Vector<Float> groupValuesVector = new Vector<Float>();
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != group) continue;
            groupValuesVector.add(new Float(geneValues[i]));
        }
        float[] groupGeneValues = new float[groupValuesVector.size()];
        for (int i = 0; i < groupValuesVector.size(); ++i) {
            groupGeneValues[i] = ((Float)groupValuesVector.get(i)).floatValue();
        }
        return groupGeneValues;
    }

    private FloatMatrix getAllGeneGroupMeans() {
        FloatMatrix means = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < means.getRowDimension(); ++i) {
            means.A[i] = this.getGeneGroupMeans(i);
        }
        return means;
    }

    private FloatMatrix getAllGeneGroupSDs() {
        FloatMatrix sds = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < sds.getRowDimension(); ++i) {
            sds.A[i] = this.getGeneGroupSDs(i);
        }
        return sds;
    }

    private FloatMatrix getPValues() {
        FloatMatrix pvals = new FloatMatrix(this.numGenes, this.pValues.length);
        for (int i = 0; i < this.pValues.length; ++i) {
            for (int j = 0; j < this.mapping.length; ++j) {
                pvals.A[j][i] = this.pValues[i][j];
            }
        }
        return pvals;
    }

    private FloatMatrix getFValues() {
        FloatMatrix pvals = new FloatMatrix(this.numGenes, 1);
        for (int j = 0; j < this.mapping.length; ++j) {
            pvals.A[j][0] = this.fValues[j];
        }
        return pvals;
    }

    private FloatMatrix getAdjPValues() {
        FloatMatrix adjpvals = new FloatMatrix(this.numGenes, this.adjPvalues.length);
        for (int i = 0; i < this.adjPvalues.length; ++i) {
            for (int j = 0; j < this.mapping.length; ++j) {
                adjpvals.A[j][i] = this.adjPvalues[i][j];
            }
        }
        return adjpvals;
    }

    private FloatMatrix getLogFoldChanges() {
        FloatMatrix lfcs = new FloatMatrix(this.numGenes, this.lfc.length);
        for (int i = 0; i < this.lfc.length; ++i) {
            for (int j = 0; j < this.mapping.length; ++j) {
                lfcs.A[j][i] = this.lfc[i][j];
            }
        }
        return lfcs;
    }

    private FloatMatrix getLogOdds() {
        FloatMatrix lodds = new FloatMatrix(this.numGenes, this.logOdds.length);
        for (int i = 0; i < this.logOdds.length; ++i) {
            for (int j = 0; j < this.mapping.length; ++j) {
                lodds.A[j][i] = this.logOdds[i][j];
            }
        }
        return lodds;
    }

    private FloatMatrix getTStatistic() {
        FloatMatrix tstat = new FloatMatrix(this.numGenes, this.t.length);
        for (int i = 0; i < this.t.length; ++i) {
            for (int j = 0; j < this.mapping.length; ++j) {
                tstat.A[j][i] = this.t[i][j];
            }
        }
        return tstat;
    }

    private float getMean(float[] group) {
        float sum = 0.0f;
        int n = 0;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sum += group[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float mean = sum / (float)n;
        if (Float.isInfinite(mean)) {
            return Float.NaN;
        }
        return mean;
    }

    private float getStdDev(float[] group) {
        float mean = this.getMean(group);
        int n = 0;
        float sumSquares = 0.0f;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sumSquares = (float)((double)sumSquares + Math.pow(group[i] - mean, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float var = sumSquares / (float)(n - 1);
        if (Float.isInfinite(var)) {
            return Float.NaN;
        }
        return (float)Math.sqrt(var);
    }

    public void runRAlg() throws AbortException {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        try {
            Rengine re = RHook.startRSession();
            if (re == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        try {
            ArrayList<Integer> nonsig;
            String[] topTabString;
            int i;
            if (RHook.getOS() == 3 || RHook.getOS() == 1) {
                RHook.testPackage((String)"limma");
            } else {
                RHook.installModule((String)"limma");
            }
            RHook.log((String)("dataDesign = " + this.dataDesign));
            RHook.log((String)"Starting R Algorithim");
            String rCmd = "library(limma)";
            RHook.evalR((String)rCmd);
            int numProbes = this.expMatrix.getRowDimension();
            int numSamples = this.expMatrix.getColumnDimension();
            String fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "tmpfile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            String filePath = this.writeMatrixToFile(fileLoc, this.expMatrix, this.geneNames);
            RHook.createRDataMatrixFromFile((String)"y", (String)filePath, (boolean)true, (String[])this.sampleNames);
            int grp1 = numSamples % 2 == 0 ? numSamples / 2 : (numSamples - 1) / 2;
            int grp2 = numSamples - grp1;
            String design = "design <- cbind(Grp1=1,Grp2vs1=c(rep(0," + grp1 + "),rep(1," + grp2 + ")))";
            if (this.dataDesign == 4 || this.dataDesign == 5) {
                RHook.log((String)design);
                String ts = "TS <- c(";
                for (int i2 = 0; i2 < numSamples; ++i2) {
                    ts = ts + "\"" + this.nameA + ((this.groupAssignments[i2] - 1) / this.numBGroups + 1) + "." + this.nameB + ((this.groupAssignments[i2] - 1) % this.numBGroups + 1) + "\",";
                }
                ts = ts.substring(0, ts.length() - 1);
                ts = ts + ")";
                RHook.evalR((String)ts);
                String levels = "c(";
                for (i = 0; i < this.numAGroups; ++i) {
                    for (int j = 0; j < this.numBGroups; ++j) {
                        levels = levels + "\"" + this.nameA + (i + 1) + "." + this.nameB + (j + 1) + "\",";
                    }
                }
                levels = levels.substring(0, levels.length() - 1);
                levels = levels + "))";
                rCmd = "TS <-factor(TS, levels = " + levels;
                RHook.evalR((String)rCmd);
            }
            design = this.getStudyDesign();
            RHook.log((String)design);
            RHook.evalR((String)design);
            if (this.dataDesign == 3) {
                rCmd = "fit <- lmFit(y,design)";
                RHook.evalR((String)rCmd);
                rCmd = "contrast.matrix <- makeContrasts(";
                for (int i3 = 0; i3 < this.numGroups; ++i3) {
                    for (int j = i3 + 1; j < this.numGroups; ++j) {
                        rCmd = rCmd + "Grp" + (i3 + 1) + "-Grp" + (j + 1) + ",";
                    }
                }
                rCmd = rCmd + "levels = design)";
                RHook.evalR((String)rCmd);
                rCmd = "fit2 <- contrasts.fit(fit, contrast.matrix)";
                RHook.evalR((String)rCmd);
                rCmd = "fit2 <- eBayes(fit2)";
                RHook.evalR((String)rCmd);
            } else if (this.dataDesign == 4) {
                rCmd = "colnames(design) <-levels(TS)";
                RHook.evalR((String)rCmd);
                rCmd = "y <- y[,c(as.numeric(rownames(design)))]";
                RHook.evalR((String)rCmd);
                rCmd = "fit <- lmFit(y,design)";
                RHook.evalR((String)rCmd);
                rCmd = "cont.matrix <- makeContrasts(";
                rCmd = rCmd + "FactorA1.B1vsB2 = " + this.nameA + "1." + this.nameB + "1 - " + this.nameA + "1." + this.nameB + "2,";
                rCmd = rCmd + "FactorA2.B1vsB2 = " + this.nameA + "2." + this.nameB + "1 - " + this.nameA + "2." + this.nameB + "2,";
                rCmd = rCmd + "Diff = (" + this.nameA + "2." + this.nameB + "1 - " + this.nameA + "2." + this.nameB + "2) - (" + this.nameA + "1." + this.nameB + "1 - " + this.nameA + "1." + this.nameB + "2),levels = design)";
                RHook.evalR((String)rCmd);
                rCmd = "fit2 <- contrasts.fit(fit, cont.matrix)";
                RHook.evalR((String)rCmd);
                rCmd = "fit2 <- eBayes(fit2)";
                RHook.evalR((String)rCmd);
            } else if (this.dataDesign == 5) {
                int i4;
                rCmd = "colnames(design) <-levels(TS)";
                RHook.evalR((String)rCmd);
                rCmd = "y <- y[,c(as.numeric(rownames(design)))]";
                RHook.evalR((String)rCmd);
                rCmd = "fit <- lmFit(y,design)";
                RHook.evalR((String)rCmd);
                rCmd = "cont1.matrix <- makeContrasts(";
                for (i4 = 0; i4 < this.numGroups - 1; ++i4) {
                    rCmd = rCmd + "\"Condition1." + this.nameB + (i4 + 2) + "-" + "Condition1." + this.nameB + (i4 + 1) + "\",";
                }
                rCmd = rCmd + "levels = design)";
                RHook.evalR((String)rCmd);
                rCmd = "fit2a <- contrasts.fit(fit, cont1.matrix)";
                RHook.evalR((String)rCmd);
                rCmd = "fit2a <- eBayes(fit2a)";
                RHook.evalR((String)rCmd);
                rCmd = "cont2.matrix <- makeContrasts(";
                for (i4 = 0; i4 < this.numGroups - 1; ++i4) {
                    rCmd = rCmd + "\"Condition2." + this.nameB + (i4 + 2) + "-" + "Condition2." + this.nameB + (i4 + 1) + "\",";
                }
                rCmd = rCmd + "levels = design)";
                RHook.evalR((String)rCmd);
                rCmd = "fit2b <- contrasts.fit(fit, cont2.matrix)";
                RHook.evalR((String)rCmd);
                rCmd = "fit2b <- eBayes(fit2b)";
                RHook.evalR((String)rCmd);
                rCmd = "cont3.matrix <- makeContrasts(";
                for (i4 = 0; i4 < this.numGroups - 1; ++i4) {
                    rCmd = rCmd + "Dif" + i4 + " = (Condition1." + this.nameB + (i4 + 2) + "-" + "Condition1." + this.nameB + (i4 + 1) + ") - " + "(Condition2." + this.nameB + (i4 + 2) + "-" + "Condition2." + this.nameB + (i4 + 1) + "),";
                }
                rCmd = rCmd + "levels = design)";
                RHook.evalR((String)rCmd);
                rCmd = "fit2c <- contrasts.fit(fit, cont3.matrix)";
                RHook.evalR((String)rCmd);
                rCmd = "fit2c <- eBayes(fit2c)";
                RHook.evalR((String)rCmd);
            } else {
                rCmd = "fit <- lmFit(y,design)";
                RHook.evalR((String)rCmd);
                rCmd = "fit <- eBayes(fit)";
                RHook.evalR((String)rCmd);
            }
            switch (this.dataDesign) {
                case 1: {
                    topTabString = new String[]{"res0 <- toptable(fit,number=" + numProbes + ",genelist=fit$genes,adjust.method='fdr',sort.by='B',p.value=1,lfc=0)"};
                    this.sigGenesArrays = new int[2][];
                    break;
                }
                case 2: {
                    topTabString = new String[]{"res0 <- toptable(fit, coef = 2, number=" + numProbes + ",genelist=fit$genes,adjust.method='fdr',sort.by='B',p.value=1,lfc=0)"};
                    this.sigGenesArrays = new int[2][];
                    break;
                }
                case 3: {
                    int i5;
                    int ttCases = 0;
                    for (i5 = 0; i5 < this.numGroups; ++i5) {
                        ttCases += i5;
                    }
                    topTabString = new String[ttCases];
                    for (i5 = 0; i5 < ttCases; ++i5) {
                        topTabString[i5] = "res" + i5 + " <- toptable(fit2,coef=" + (i5 + 1) + ",number=" + numProbes + ",genelist=fit$genes,adjust.method='fdr',sort.by='B',p.value=1,lfc=0)";
                    }
                    this.sigGenesArrays = new int[topTabString.length * 2 + 2][];
                    break;
                }
                case 4: {
                    topTabString = new String[3];
                    for (i = 0; i < 3; ++i) {
                        topTabString[i] = "res" + i + " <- toptable(fit2,coef=" + (i + 1) + ",number=" + numProbes + ",genelist=fit$genes,adjust.method='fdr',sort.by='B',p.value=1,lfc=0)";
                    }
                    this.sigGenesArrays = new int[topTabString.length * 2 + 2][];
                    break;
                }
                case 5: {
                    topTabString = new String[2 * (this.numGroups - 1)];
                    for (i = 0; i < this.numGroups - 1; ++i) {
                        topTabString[i] = "res" + i + " <- toptable(fit2a,coef=" + (i + 1) + ",number=" + numProbes + ",genelist=fit$genes,adjust.method='fdr',sort.by='B',p.value=1,lfc=0)";
                    }
                    for (i = this.numGroups - 1; i < 2 * (this.numGroups - 1); ++i) {
                        topTabString[i] = "res" + i + " <- toptable(fit2b,coef=" + (i - this.numGroups + 2) + ",number=" + numProbes + ",genelist=fit$genes,adjust.method='fdr',sort.by='B',p.value=1,lfc=0)";
                    }
                    this.sigGenesArrays = new int[topTabString.length * 2 + 6][];
                    break;
                }
                default: {
                    topTabString = new String[]{"default"};
                    this.sigGenesArrays = new int[topTabString.length * 2 + 2][];
                }
            }
            int grpPairs = topTabString.length;
            this.lfc = new float[grpPairs][numProbes];
            this.t = new float[grpPairs][numProbes];
            this.logOdds = new float[grpPairs][numProbes];
            this.pValues = new float[grpPairs][numProbes];
            this.adjPvalues = new float[grpPairs][numProbes];
            this.fValues = new float[numProbes];
            for (int interax = 0; interax < grpPairs; ++interax) {
                int i6;
                int i7;
                RHook.evalR((String)topTabString[interax]);
                rCmd = "as.numeric(rownames(res" + interax + "))-1";
                REXP x = RHook.evalR((String)rCmd);
                double[] rowIndices = x.asDoubleArray();
                rCmd = "res" + interax + "$ID";
                x = RHook.evalR((String)rCmd);
                String[] sigGenes = x.asStringArray();
                rCmd = "res" + interax + "$logFC";
                x = RHook.evalR((String)rCmd);
                double[] tmp = x.asDoubleArray();
                for (i7 = 0; i7 < tmp.length; ++i7) {
                    this.lfc[interax][(int)rowIndices[i7]] = (float)tmp[i7];
                }
                rCmd = "res" + interax + "$t";
                x = RHook.evalR((String)rCmd);
                tmp = x.asDoubleArray();
                for (i7 = 0; i7 < tmp.length; ++i7) {
                    this.t[interax][(int)rowIndices[i7]] = (float)tmp[i7];
                }
                rCmd = "res" + interax + "$P.Value";
                x = RHook.evalR((String)rCmd);
                tmp = x.asDoubleArray();
                for (i7 = 0; i7 < tmp.length; ++i7) {
                    this.pValues[interax][(int)rowIndices[i7]] = (float)tmp[i7];
                }
                rCmd = "res" + interax + "$adj.P.Val";
                x = RHook.evalR((String)rCmd);
                tmp = x.asDoubleArray();
                for (i7 = 0; i7 < tmp.length; ++i7) {
                    this.adjPvalues[interax][(int)rowIndices[i7]] = (float)tmp[i7];
                }
                rCmd = "res" + interax + "$B";
                x = RHook.evalR((String)rCmd);
                tmp = x.asDoubleArray();
                for (i7 = 0; i7 < tmp.length; ++i7) {
                    this.logOdds[interax][(int)rowIndices[i7]] = (float)tmp[i7];
                }
                this.updateProgressBar();
                ArrayList<Integer> sig = new ArrayList<Integer>();
                ArrayList<Integer> nonsig2 = new ArrayList<Integer>();
                for (i6 = 0; i6 < this.adjPvalues[interax].length; ++i6) {
                    if (this.adjPvalues[interax][i6] <= this.alpha) {
                        sig.add(new Integer(i6));
                        continue;
                    }
                    nonsig2.add(new Integer(i6));
                }
                this.sigGenesArrays[interax * 2] = new int[sig.size()];
                this.sigGenesArrays[interax * 2 + 1] = new int[numProbes - sig.size()];
                for (i6 = 0; i6 < this.sigGenesArrays[interax * 2].length; ++i6) {
                    this.sigGenesArrays[interax * 2][i6] = (Integer)sig.get(i6);
                }
                for (i6 = 0; i6 < this.sigGenesArrays[interax * 2 + 1].length; ++i6) {
                    this.sigGenesArrays[interax * 2 + 1][i6] = (Integer)nonsig2.get(i6);
                }
            }
            if (this.dataDesign == 3 || this.dataDesign == 4) {
                int i8;
                rCmd = "fit2$F.p.value";
                REXP x = RHook.evalR((String)rCmd);
                double[] tmp = x.asDoubleArray();
                for (int i9 = 0; i9 < tmp.length; ++i9) {
                    this.fValues[i9] = (float)tmp[i9];
                }
                ArrayList<Integer> sig = new ArrayList<Integer>();
                nonsig = new ArrayList<Integer>();
                for (i8 = 0; i8 < this.fValues.length; ++i8) {
                    if (this.fValues[i8] <= this.alpha) {
                        sig.add(new Integer(i8));
                        continue;
                    }
                    nonsig.add(new Integer(i8));
                }
                this.sigGenesArrays[grpPairs * 2] = new int[sig.size()];
                this.sigGenesArrays[grpPairs * 2 + 1] = new int[nonsig.size()];
                for (i8 = 0; i8 < this.sigGenesArrays[grpPairs * 2].length; ++i8) {
                    this.sigGenesArrays[grpPairs * 2][i8] = (Integer)sig.get(i8);
                }
                for (i8 = 0; i8 < this.sigGenesArrays[grpPairs * 2 + 1].length; ++i8) {
                    this.sigGenesArrays[grpPairs * 2 + 1][i8] = (Integer)nonsig.get(i8);
                }
            }
            if (this.dataDesign == 5) {
                int i10;
                rCmd = "fit2a$F.p.value";
                REXP x = RHook.evalR((String)rCmd);
                double[] tmp = x.asDoubleArray();
                for (int i11 = 0; i11 < tmp.length; ++i11) {
                    this.fValues[i11] = (float)tmp[i11];
                }
                ArrayList<Integer> sig = new ArrayList<Integer>();
                nonsig = new ArrayList();
                for (i10 = 0; i10 < this.fValues.length; ++i10) {
                    if (this.fValues[i10] <= this.alpha) {
                        sig.add(new Integer(i10));
                        continue;
                    }
                    nonsig.add(new Integer(i10));
                }
                this.sigGenesArrays[grpPairs * 2 + 0] = new int[sig.size()];
                this.sigGenesArrays[grpPairs * 2 + 1] = new int[nonsig.size()];
                for (i10 = 0; i10 < this.sigGenesArrays[grpPairs * 2 + 0].length; ++i10) {
                    this.sigGenesArrays[grpPairs * 2 + 0][i10] = (Integer)sig.get(i10);
                }
                for (i10 = 0; i10 < this.sigGenesArrays[grpPairs * 2 + 1].length; ++i10) {
                    this.sigGenesArrays[grpPairs * 2 + 1][i10] = (Integer)nonsig.get(i10);
                }
                rCmd = "fit2b$F.p.value";
                x = RHook.evalR((String)rCmd);
                tmp = x.asDoubleArray();
                for (i10 = 0; i10 < tmp.length; ++i10) {
                    this.fValues[i10] = (float)tmp[i10];
                }
                sig = new ArrayList();
                nonsig = new ArrayList();
                for (i10 = 0; i10 < this.fValues.length; ++i10) {
                    if (this.fValues[i10] <= this.alpha) {
                        sig.add(new Integer(i10));
                        continue;
                    }
                    nonsig.add(new Integer(i10));
                }
                this.sigGenesArrays[grpPairs * 2 + 2] = new int[sig.size()];
                this.sigGenesArrays[grpPairs * 2 + 3] = new int[nonsig.size()];
                for (i10 = 0; i10 < this.sigGenesArrays[grpPairs * 2 + 2].length; ++i10) {
                    this.sigGenesArrays[grpPairs * 2 + 2][i10] = (Integer)sig.get(i10);
                }
                for (i10 = 0; i10 < this.sigGenesArrays[grpPairs * 2 + 3].length; ++i10) {
                    this.sigGenesArrays[grpPairs * 2 + 3][i10] = (Integer)nonsig.get(i10);
                }
                rCmd = "fit2c$F.p.value";
                x = RHook.evalR((String)rCmd);
                tmp = x.asDoubleArray();
                for (i10 = 0; i10 < tmp.length; ++i10) {
                    this.fValues[i10] = (float)tmp[i10];
                }
                sig = new ArrayList();
                nonsig = new ArrayList();
                for (i10 = 0; i10 < this.fValues.length; ++i10) {
                    if (this.fValues[i10] <= this.alpha) {
                        sig.add(new Integer(i10));
                        continue;
                    }
                    nonsig.add(new Integer(i10));
                }
                this.sigGenesArrays[grpPairs * 2 + 4] = new int[sig.size()];
                this.sigGenesArrays[grpPairs * 2 + 5] = new int[nonsig.size()];
                for (i10 = 0; i10 < this.sigGenesArrays[grpPairs * 2 + 4].length; ++i10) {
                    this.sigGenesArrays[grpPairs * 2 + 4][i10] = (Integer)sig.get(i10);
                }
                for (i10 = 0; i10 < this.sigGenesArrays[grpPairs * 2 + 5].length; ++i10) {
                    this.sigGenesArrays[grpPairs * 2 + 5][i10] = (Integer)nonsig.get(i10);
                }
            }
            RHook.endRSession();
            this.removeTmps(filePath);
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
                throw new AbortException();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private String writeMatrixToFile(String fileLoc, FloatMatrix fm, String[] rowNames) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
            int row = fm.getRowDimension();
            int col = fm.getColumnDimension();
            String srtVector = "";
            for (int iRow = 0; iRow < row; ++iRow) {
                srtVector = rowNames[iRow] + "\t";
                for (int jCol = 0; jCol < col; ++jCol) {
                    srtVector = jCol == col - 1 ? srtVector + fm.get(iRow, jCol) + "\n" : srtVector + fm.get(iRow, jCol) + "\t";
                }
                out.write(srtVector);
                srtVector = "";
            }
            out.close();
        }
        catch (IOException e) {
            return null;
        }
        return fileLoc;
    }

    private String getStudyDesign() {
        switch (this.dataDesign) {
            case 1: {
                return this.getOneClassDesign();
            }
            case 2: {
                return this.getTwoClassDesign();
            }
            case 3: {
                return this.getMultiClassDesign();
            }
            case 4: {
                return this.getTwoFactorDesign();
            }
            case 5: {
                return this.getTimeCourseDesign();
            }
        }
        return "";
    }

    private String getOneClassDesign() {
        String str = "design <- c(";
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            str = str + Integer.toString(this.groupAssignments[i]);
            if (i >= this.groupAssignments.length - 1) continue;
            str = str + ", ";
        }
        str = str + ")";
        return str;
    }

    private String getTwoClassDesign() {
        String grp1 = "";
        String grp2 = "";
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                grp1 = grp1 + "1";
                grp2 = grp2 + "0";
            } else if (this.groupAssignments[i] == 2) {
                grp1 = grp1 + "1";
                grp2 = grp2 + "1";
            } else {
                grp1 = grp1 + "0";
                grp2 = grp2 + "0";
            }
            if (i >= this.groupAssignments.length - 1) continue;
            grp1 = grp1 + ", ";
            grp2 = grp2 + ", ";
        }
        String str = "design <- cbind(Grp1=c(" + grp1 + "),Grp2=c(" + grp2 + "))";
        return str;
    }

    private String getMultiClassDesign() {
        int i;
        String[] grpArray = new String[this.numGroups];
        for (i = 0; i < this.numGroups; ++i) {
            grpArray[i] = "";
        }
        for (i = 0; i < this.groupAssignments.length; ++i) {
            int j;
            for (j = 0; j < this.numGroups; ++j) {
                grpArray[j] = this.groupAssignments[i] == j + 1 ? grpArray[j] + "1" : grpArray[j] + "0";
            }
            if (i >= this.groupAssignments.length - 1) continue;
            for (j = 0; j < this.numGroups; ++j) {
                grpArray[j] = grpArray[j] + ", ";
            }
        }
        String str = "design <- cbind(";
        for (int i2 = 0; i2 < this.numGroups; ++i2) {
            str = str + "Grp" + (i2 + 1) + "=c(" + grpArray[i2] + ")";
            if (i2 >= this.numGroups - 1) continue;
            str = str + ", ";
        }
        str = str + ")";
        return str;
    }

    private String getTwoFactorDesign() {
        String str = "design <- model.matrix(~0 + TS)";
        return str;
    }

    private String getTimeCourseDesign() {
        String str = "design <- model.matrix(~0 + TS)";
        return str;
    }

    public void updateProgressBar() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / (this.progress + 7));
    }

    private void removeTmps(String fileName) {
        File f = new File(fileName);
        f.delete();
    }
}

