/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Hashtable;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class LEM
extends AbstractAlgorithm {
    private int[] sortedStart;
    private int[] sortedEnd;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int index;
        int[] origIndices = data.getIntArray("original-indices");
        int[] idataIndices = data.getIntArray("idata-indices");
        FloatMatrix fm = data.getMatrix("expression-matrix");
        String[] locusArray = data.getStringArray("locus-array");
        int[] start = data.getIntArray("start-array");
        int[] end = data.getIntArray("end-array");
        Vector<String> lociV = new Vector<String>();
        int missingDataCount = 0;
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 3, 0, "Building and Validating Locus Vector\n");
        this.fireValueChanged(event);
        Hashtable<String, Vector<Integer>> table = new Hashtable<String, Vector<Integer>>(locusArray.length);
        Hashtable<String, Vector<Integer>> locusToStartArrayTable = new Hashtable<String, Vector<Integer>>(locusArray.length);
        for (int i = 0; i < locusArray.length; ++i) {
            if (locusArray[i].equals("") || start[i] == -1 || end[i] == -1) {
                ++missingDataCount;
                continue;
            }
            Vector<Integer> v = (Vector<Integer>)table.get(locusArray[i]);
            if (v == null) {
                v = new Vector<Integer>();
                table.put(locusArray[i], v);
                lociV.add(locusArray[i]);
            }
            v.add(new Integer(idataIndices[origIndices[i]]));
            Vector<Integer> indicesV = (Vector<Integer>)locusToStartArrayTable.get(locusArray[i]);
            if (indicesV == null) {
                indicesV = new Vector<Integer>();
                locusToStartArrayTable.put(locusArray[i], indicesV);
            }
            indicesV.add(new Integer(i));
        }
        float[] minCoord = new float[lociV.size()];
        int[] direction = new int[lociV.size()];
        event = new AlgorithmEvent((Object)this, 3, 0, "Determining Loci Read Polarity\n");
        this.fireValueChanged(event);
        for (int i = 0; i < minCoord.length; ++i) {
            index = (Integer)((Vector)locusToStartArrayTable.get(lociV.get(i))).get(0);
            if (start[index] < end[index]) {
                minCoord[i] = start[index];
                direction[i] = 1;
                continue;
            }
            minCoord[i] = end[index];
            direction[i] = -1;
        }
        event = new AlgorithmEvent((Object)this, 3, 0, "Sorting Loci on Location\n");
        this.fireValueChanged(event);
        QSort qsort = new QSort(minCoord);
        int[] sortedIndices = qsort.getOrigIndx();
        float[] sortedCoords = qsort.getSorted();
        int[] sortedDirection = new int[direction.length];
        for (int i = 0; i < direction.length; ++i) {
            sortedDirection[i] = direction[sortedIndices[i]];
        }
        int[][] replicates = new int[minCoord.length][];
        int numCol = fm.getColumnDimension();
        FloatMatrix condensedMatrix = new FloatMatrix(minCoord.length, numCol);
        this.sortedStart = new int[replicates.length];
        this.sortedEnd = new int[replicates.length];
        int[] sortedIDataIndices = new int[replicates.length];
        String[] sortedLociNames = new String[sortedIndices.length];
        event = new AlgorithmEvent((Object)this, 3, 0, "Logging Spot to Locus Mapping and... \n ...Locus Mean Expression Calculation\n");
        this.fireValueChanged(event);
        for (int i = 0; i < replicates.length; ++i) {
            int j;
            int m;
            sortedLociNames[i] = (String)lociV.get(sortedIndices[i]);
            Vector repIDataVector = (Vector)table.get(sortedLociNames[i]);
            int[] array = new int[repIDataVector.size()];
            for (m = 0; m < array.length; ++m) {
                array[m] = (Integer)repIDataVector.get(m);
            }
            replicates[i] = array;
            sortedIDataIndices[i] = replicates[i][0];
            Vector repVector = (Vector)locusToStartArrayTable.get(sortedLociNames[i]);
            array = new int[repVector.size()];
            for (m = 0; m < array.length; ++m) {
                array[m] = origIndices[(Integer)repVector.get(m)];
            }
            int[] validN = new int[numCol];
            float[] sumExp = new float[numCol];
            for (j = 0; j < array.length; ++j) {
                for (int k = 0; k < numCol; ++k) {
                    if (Float.isNaN(fm.A[array[j]][k])) continue;
                    int n = k;
                    validN[n] = validN[n] + 1;
                    int n2 = k;
                    sumExp[n2] = sumExp[n2] + fm.A[array[j]][k];
                }
            }
            for (j = 0; j < numCol; ++j) {
                if (validN[j] > 0) {
                    int n = j;
                    sumExp[n] = sumExp[n] / (float)validN[j];
                    continue;
                }
                sumExp[j] = Float.NaN;
            }
            condensedMatrix.A[i] = sumExp;
            index = (Integer)((Vector)locusToStartArrayTable.get(sortedLociNames[i])).get(0);
            this.sortedStart[i] = Math.min(start[index], end[index]);
            this.sortedEnd[i] = Math.max(start[index], end[index]);
        }
        int[] strata = this.getStrataArray();
        data.addStringArray("sorted-loci-names", sortedLociNames);
        data.addIntMatrix("replication-indices-matrix", (int[][])replicates);
        data.addMatrix("condensed-matrix", condensedMatrix);
        data.addIntArray("sorted-idata-indices", sortedIDataIndices);
        data.addIntArray("sorted-start", this.sortedStart);
        data.addIntArray("sorted-end", this.sortedEnd);
        data.addIntArray("direction-array", sortedDirection);
        data.addIntArray("strata-array", strata);
        data.addParam("missing-data-count", String.valueOf(missingDataCount));
        return data;
    }

    private boolean haveOverLap(int currX, int otherX) {
        return this.sortedStart[currX] >= this.sortedStart[otherX] && this.sortedStart[currX] <= this.sortedEnd[otherX] || this.sortedEnd[currX] <= this.sortedEnd[otherX] && this.sortedEnd[currX] >= this.sortedEnd[otherX] || this.sortedStart[otherX] >= this.sortedStart[currX] && this.sortedStart[otherX] <= this.sortedEnd[currX];
    }

    private Vector getOverLapIndicesFromPrevious(int currIndex) {
        if (currIndex == 0) {
            return null;
        }
        Vector<Integer> v = new Vector<Integer>();
        for (int i = currIndex - 1; i >= 0; --i) {
            if (!this.haveOverLap(currIndex, i)) continue;
            v.add(new Integer(i));
        }
        return v;
    }

    private int getStrata(int currIndex, int[] strata) {
        Vector v = this.getOverLapIndicesFromPrevious(currIndex);
        if (v == null || v.size() == 0) {
            return 0;
        }
        if (v.size() == 1) {
            int index = (Integer)v.get(0);
            if (strata[index] > 0) {
                return 0;
            }
            return strata[index] + 1;
        }
        Vector<Integer> setStrata = new Vector<Integer>();
        for (int i = 0; i < v.size(); ++i) {
            int index = (Integer)v.get(i);
            setStrata.add(new Integer(strata[index]));
        }
        int strataValue = 0;
        while (setStrata.contains(new Integer(strataValue))) {
            ++strataValue;
        }
        return strataValue;
    }

    private int[] getStrataArray() {
        int[] strata = new int[this.sortedStart.length];
        for (int i = 0; i < strata.length; ++i) {
            strata[i] = this.getStrata(i, strata);
        }
        return strata;
    }

    public void abort() {
    }
}

