/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class KNNClassify
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private FloatMatrix expMatrix;
    private Vector[] clusters;
    private Vector[] filteredClassifiersByClass;
    private int k;
    private int numRows;
    private int numCols;
    private int usedNumNeibs;
    private boolean validate;
    private boolean classifyGenes;
    private boolean useVarianceFilter;
    private boolean useCorrelFilter;
    private int numClasses;
    private int numVarFilteredVectors;
    private int numNeighbors;
    private int numPerms;
    private int postVarClassSetSize;
    private int postVarDataSetSize;
    private int postCorrDataSetSize;
    private int origDataSetSize;
    private int origClassSetSize;
    private double correlPValue;
    private int[] classIndices;
    private int[] classes;
    private Vector rowsInAnalysis;
    private Vector filteredClassifierSet;
    private Vector filteredClasses;
    private int hcl_function;
    private boolean hcl_absolute;
    int validN;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        int i2;
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("distance-absolute", false);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        this.expMatrix = data.getMatrix("experiment");
        this.numRows = this.expMatrix.getRowDimension();
        this.numCols = this.expMatrix.getColumnDimension();
        this.validate = map.getBoolean("validate", false);
        if (!this.validate) {
            int i3;
            int currClass;
            int i4;
            int i5;
            int i6;
            this.classifyGenes = map.getBoolean("classifyGenes", true);
            this.useVarianceFilter = map.getBoolean("useVarianceFilter", false);
            this.useCorrelFilter = map.getBoolean("useCorrelFilter", false);
            if (this.useCorrelFilter) {
                this.correlPValue = map.getFloat("correlPValue", 0.01f);
                this.numPerms = map.getInt("numPerms", 1000);
            }
            this.numClasses = map.getInt("numClasses", 5);
            this.numNeighbors = map.getInt("numNeighbors", 3);
            this.classIndices = data.getIntArray("classIndices");
            this.classes = data.getIntArray("classes");
            this.numVarFilteredVectors = map.getInt("numVarFilteredVectors", this.numRows);
            AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numRows);
            this.fireValueChanged(event);
            event.setId(2);
            this.rowsInAnalysis = new Vector();
            for (i6 = 0; i6 < this.numRows; ++i6) {
                this.rowsInAnalysis.add(new Integer(i6));
            }
            this.filteredClassifierSet = new Vector();
            this.filteredClasses = new Vector();
            for (i6 = 0; i6 < this.classIndices.length; ++i6) {
                this.filteredClassifierSet.add(new Integer(this.classIndices[i6]));
                this.filteredClasses.add(new Integer(this.classes[i6]));
            }
            this.origDataSetSize = this.rowsInAnalysis.size();
            this.origClassSetSize = this.filteredClassifierSet.size();
            if (this.useVarianceFilter) {
                double[] variances = new double[this.rowsInAnalysis.size()];
                for (int i7 = 0; i7 < variances.length; ++i7) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event.setIntValue(i7);
                    event.setDescription("Calculating variance of element = " + (i7 + 1));
                    this.fireValueChanged(event);
                    variances[i7] = this.getVar(i7);
                }
                QSort sortVariances = new QSort(variances);
                int[] sortedIndices = sortVariances.getOrigIndx();
                int[] sortDesc = this.reverse(sortedIndices);
                this.rowsInAnalysis = new Vector();
                for (i5 = 0; i5 < this.numVarFilteredVectors; ++i5) {
                    this.rowsInAnalysis.add(new Integer(sortDesc[i5]));
                }
                this.filteredClassifierSet = new Vector();
                this.filteredClasses = new Vector();
                for (i5 = 0; i5 < this.classIndices.length; ++i5) {
                    if (!this.isFoundInVector(this.classIndices[i5], this.rowsInAnalysis)) continue;
                    this.filteredClassifierSet.add(new Integer(this.classIndices[i5]));
                    this.filteredClasses.add(new Integer(this.classes[i5]));
                }
            }
            for (int i8 = 0; i8 < this.classIndices.length; ++i8) {
                if (!this.isFoundInVector(this.classIndices[i8], this.rowsInAnalysis)) continue;
                this.rowsInAnalysis.remove(new Integer(this.classIndices[i8]));
            }
            this.postVarDataSetSize = this.rowsInAnalysis.size();
            this.postVarClassSetSize = this.filteredClassifierSet.size();
            AlgorithmEvent event2 = new AlgorithmEvent((Object)this, 1, this.rowsInAnalysis.size());
            this.fireValueChanged(event2);
            event2.setId(2);
            if (this.useCorrelFilter) {
                int i9;
                Vector<Integer> correlFilteredRows = new Vector<Integer>();
                for (i9 = 0; i9 < this.rowsInAnalysis.size(); ++i9) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event2.setIntValue(i9);
                    event2.setDescription("Applying correlation filter: element " + (i9 + 1));
                    this.fireValueChanged(event2);
                    int currentRow = (Integer)this.rowsInAnalysis.get(i9);
                    Random rnd1 = new Random();
                    if (!this.passesCorrelationFilter(currentRow, this.filteredClassifierSet, this.correlPValue, this.numPerms, rnd1.nextLong())) continue;
                    correlFilteredRows.add(new Integer(currentRow));
                }
                this.rowsInAnalysis = new Vector();
                for (i9 = 0; i9 < correlFilteredRows.size(); ++i9) {
                    this.rowsInAnalysis.add((Integer)correlFilteredRows.get(i9));
                }
            }
            this.postCorrDataSetSize = this.rowsInAnalysis.size();
            Vector[] classSets = new Vector[this.numClasses + 1];
            for (i4 = 0; i4 < classSets.length; ++i4) {
                classSets[i4] = new Vector();
            }
            this.filteredClassifiersByClass = new Vector[this.numClasses + 1];
            for (i4 = 0; i4 < this.numClasses + 1; ++i4) {
                this.filteredClassifiersByClass[i4] = new Vector();
            }
            for (i4 = 0; i4 < this.filteredClassifierSet.size(); ++i4) {
                int currClassifier = (Integer)this.filteredClassifierSet.get(i4);
                currClass = (Integer)this.filteredClasses.get(i4);
                this.filteredClassifiersByClass[currClass].add(new Integer(currClassifier));
            }
            for (i4 = 0; i4 < this.rowsInAnalysis.size(); ++i4) {
                int currRow = (Integer)this.rowsInAnalysis.get(i4);
                currClass = this.getClassification(currRow, this.numNeighbors);
                classSets[currClass].add(new Integer(currRow));
            }
            for (i4 = 0; i4 < this.numRows; ++i4) {
                if (this.rowsInAnalysis.contains(new Integer(i4)) || this.filteredClassifierSet.contains(new Integer(i4))) continue;
                classSets[0].add(new Integer(i4));
            }
            Vector[] unusedClassifiers = new Vector[this.numClasses + 1];
            Vector[] usedClassifiers = new Vector[this.numClasses + 1];
            for (i5 = 1; i5 < unusedClassifiers.length; ++i5) {
                unusedClassifiers[i5] = new Vector();
                usedClassifiers[i5] = new Vector();
            }
            for (i5 = 0; i5 < this.classIndices.length; ++i5) {
                if (!this.isFoundInVector(this.classIndices[i5], this.filteredClassifierSet)) {
                    unusedClassifiers[this.classes[i5]].add(new Integer(this.classIndices[i5]));
                    continue;
                }
                usedClassifiers[this.classes[i5]].add(new Integer(this.classIndices[i5]));
            }
            Vector[] usedPlusClassified = new Vector[this.numClasses + 1];
            for (i3 = 1; i3 < usedPlusClassified.length; ++i3) {
                int j;
                usedPlusClassified[i3] = new Vector();
                for (j = 0; j < usedClassifiers[i3].size(); ++j) {
                    usedPlusClassified[i3].add((Integer)usedClassifiers[i3].get(j));
                }
                for (j = 0; j < classSets[i3].size(); ++j) {
                    usedPlusClassified[i3].add((Integer)classSets[i3].get(j));
                }
            }
            this.clusters = new Vector[this.numClasses * 4 + 1];
            for (i3 = 1; i3 <= this.numClasses; ++i3) {
                this.clusters[i3 - 1] = usedClassifiers[i3];
                this.clusters[i3 - 1 + this.numClasses] = unusedClassifiers[i3];
                this.clusters[i3 - 1 + 2 * this.numClasses] = classSets[i3];
                this.clusters[i3 - 1 + 3 * this.numClasses] = usedPlusClassified[i3];
            }
            this.clusters[this.numClasses * 4] = classSets[0];
            int[][] crossValidationStats = this.getCrossValidationStats();
            int[] numberCorrectlyClassifiedByClass = crossValidationStats[0];
            int[] numberIncorrectlyClassifiedByClass = crossValidationStats[1];
            int[] origNumInFiltTrgSetByClass = new int[this.numClasses + 1];
            for (int i10 = 0; i10 < origNumInFiltTrgSetByClass.length; ++i10) {
                origNumInFiltTrgSetByClass[i10] = this.filteredClassifiersByClass[i10].size();
            }
            FloatMatrix means = this.getMeans(this.clusters);
            FloatMatrix variances = this.getVariances(this.clusters, means);
            AlgorithmEvent event3 = null;
            if (hierarchical_tree) {
                event3 = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
                this.fireValueChanged(event3);
                event3.setIntValue(0);
                event3.setId(2);
                this.fireValueChanged(event3);
            }
            Cluster result_cluster = new Cluster();
            NodeList nodeList = result_cluster.getNodeList();
            for (int i11 = 0; i11 < this.clusters.length; ++i11) {
                if (this.stop) {
                    throw new AbortException();
                }
                int[] features = this.convert2int(this.clusters[i11]);
                Node node = new Node(features);
                nodeList.addNode(node);
                if (!hierarchical_tree) continue;
                node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
                event.setIntValue(i11 + 1);
                this.fireValueChanged(event);
            }
            AlgorithmData result = new AlgorithmData();
            result.addParam("usedNumNeibs", String.valueOf(this.usedNumNeibs));
            result.addParam("origDataSetSize", String.valueOf(this.origDataSetSize));
            result.addParam("origClassSetSize", String.valueOf(this.origClassSetSize));
            if (this.useVarianceFilter) {
                result.addParam("postVarDataSetSize", String.valueOf(this.postVarDataSetSize));
                result.addParam("postVarClassSetSize", String.valueOf(this.postVarClassSetSize));
            }
            if (this.useCorrelFilter) {
                result.addParam("postCorrDataSetSize", String.valueOf(this.postCorrDataSetSize));
            }
            result.addIntArray("origNumInFiltTrgSetByClass", origNumInFiltTrgSetByClass);
            result.addIntArray("numberCorrectlyClassifiedByClass", numberCorrectlyClassifiedByClass);
            result.addIntArray("numberIncorrectlyClassifiedByClass", numberIncorrectlyClassifiedByClass);
            result.addCluster("cluster", result_cluster);
            result.addMatrix("clusters_means", means);
            result.addMatrix("clusters_variances", variances);
            return result;
        }
        this.classifyGenes = map.getBoolean("classifyGenes", true);
        this.useCorrelFilter = map.getBoolean("useCorrelFilter", false);
        if (this.useCorrelFilter) {
            this.correlPValue = map.getFloat("correlPValue", 0.01f);
            this.numPerms = map.getInt("numPerms", 1000);
        }
        this.numClasses = map.getInt("numClasses", 5);
        this.numNeighbors = map.getInt("numNeighbors", 3);
        this.classIndices = data.getIntArray("classIndices");
        this.classes = data.getIntArray("classes");
        this.filteredClassifierSet = new Vector();
        this.filteredClasses = new Vector();
        for (i2 = 0; i2 < this.classIndices.length; ++i2) {
            this.filteredClassifierSet.add(new Integer(this.classIndices[i2]));
            this.filteredClasses.add(new Integer(this.classes[i2]));
        }
        this.origClassSetSize = this.filteredClassifierSet.size();
        this.filteredClassifiersByClass = new Vector[this.numClasses + 1];
        for (i2 = 0; i2 < this.numClasses + 1; ++i2) {
            this.filteredClassifiersByClass[i2] = new Vector();
        }
        for (i2 = 0; i2 < this.filteredClassifierSet.size(); ++i2) {
            int currClassifier = (Integer)this.filteredClassifierSet.get(i2);
            int currClass = (Integer)this.filteredClasses.get(i2);
            this.filteredClassifiersByClass[currClass].add(new Integer(currClassifier));
        }
        int[][] crossValidationStats = this.getCrossValidationStats();
        int[] numberCorrectlyClassifiedByClass = crossValidationStats[0];
        int[] numberIncorrectlyClassifiedByClass = crossValidationStats[1];
        int[] origNumInFiltTrgSetByClass = new int[this.numClasses + 1];
        for (int i12 = 0; i12 < origNumInFiltTrgSetByClass.length; ++i12) {
            origNumInFiltTrgSetByClass[i12] = this.filteredClassifiersByClass[i12].size();
        }
        Vector<Integer> nonTrainingRows = new Vector<Integer>();
        for (i = 0; i < this.numRows; ++i) {
            nonTrainingRows.add(new Integer(i));
        }
        nonTrainingRows.removeAll(this.filteredClassifierSet);
        this.clusters = new Vector[this.numClasses + 1];
        this.clusters[0] = nonTrainingRows;
        for (i = 1; i < this.numClasses + 1; ++i) {
            this.clusters[i] = this.filteredClassifiersByClass[i];
        }
        FloatMatrix means = this.getMeans(this.clusters);
        FloatMatrix variances = this.getVariances(this.clusters, means);
        AlgorithmEvent event3 = null;
        if (hierarchical_tree) {
            event3 = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(event3);
            event3.setIntValue(0);
            event3.setId(2);
            this.fireValueChanged(event3);
        }
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numRows);
        this.fireValueChanged(event);
        event.setId(2);
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i13 = 0; i13 < this.clusters.length; ++i13) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.convert2int(this.clusters[i13]);
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            event.setIntValue(i13 + 1);
            this.fireValueChanged(event);
        }
        AlgorithmData result = new AlgorithmData();
        result.addParam("usedNumNeibs", String.valueOf(this.usedNumNeibs));
        result.addIntArray("origNumInFiltTrgSetByClass", origNumInFiltTrgSetByClass);
        result.addIntArray("numberCorrectlyClassifiedByClass", numberCorrectlyClassifiedByClass);
        result.addIntArray("numberIncorrectlyClassifiedByClass", numberIncorrectlyClassifiedByClass);
        result.addCluster("cluster", result_cluster);
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        return result;
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.classifyGenes ? this.getSubExperiment(this.expMatrix, features) : this.getSubExperimentReducedCols(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (Integer)source.get(i);
        }
        return int_matrix;
    }

    public void abort() {
        this.stop = true;
    }

    private FloatMatrix getMeans(Vector[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.numCols);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getMean(Vector cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.numCols);
        int n = cluster.size();
        int denom = 0;
        for (int i = 0; i < this.numCols; ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(((Integer)cluster.get(j)).intValue(), i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    private FloatMatrix getVariances(Vector[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleNormalizedSum(Vector cluster, int column, float mean) {
        int size = cluster.size();
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(((Integer)cluster.get(i)).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float getSampleVariance(Vector cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    private int getClassification(int row, int numNeibs) {
        int[] classCounts = new int[this.numClasses + 1];
        for (int i = 0; i < classCounts.length; ++i) {
            classCounts[i] = 0;
        }
        float[] distances = new float[this.filteredClassifierSet.size()];
        int numNeibsUsed = numNeibs <= this.filteredClassifierSet.size() ? numNeibs : this.filteredClassifierSet.size();
        this.usedNumNeibs = numNeibsUsed;
        for (int i = 0; i < this.filteredClassifierSet.size(); ++i) {
            float currDist;
            int currentClassifier = (Integer)this.filteredClassifierSet.get(i);
            distances[i] = currDist = ExperimentUtil.geneEuclidianDistance(this.expMatrix, null, row, currentClassifier, this.factor);
        }
        QSort sortDistances = new QSort(distances);
        int[] sortedDistIndices = sortDistances.getOrigIndx();
        for (int i = 0; i < numNeibsUsed; ++i) {
            int currClassifierIndex = sortedDistIndices[i];
            int currClass = (Integer)this.filteredClasses.get(currClassifierIndex);
            classCounts[currClass] = classCounts[currClass] + 1;
        }
        int maxCount = 0;
        for (int i = 1; i < classCounts.length; ++i) {
            maxCount = Math.max(maxCount, classCounts[i]);
        }
        int numMaxCountEncountered = 0;
        int assignedClass = 0;
        for (int i = 1; i < classCounts.length; ++i) {
            if (maxCount != classCounts[i]) continue;
            ++numMaxCountEncountered;
            assignedClass = i;
        }
        if (numMaxCountEncountered == 1) {
            return assignedClass;
        }
        return 0;
    }

    private int getClassificationForCrossValid(int row, int numNeibs, Vector reducedClassifierSet, Vector reducedClasses) {
        int[] classCounts = new int[this.numClasses + 1];
        for (int i = 0; i < classCounts.length; ++i) {
            classCounts[i] = 0;
        }
        float[] distances = new float[reducedClassifierSet.size()];
        int numNeibsUsed = numNeibs <= reducedClassifierSet.size() ? numNeibs : reducedClassifierSet.size();
        this.usedNumNeibs = numNeibsUsed;
        for (int i = 0; i < reducedClassifierSet.size(); ++i) {
            float currDist;
            int currentClassifier = (Integer)reducedClassifierSet.get(i);
            distances[i] = currDist = ExperimentUtil.geneEuclidianDistance(this.expMatrix, null, row, currentClassifier, this.factor);
        }
        QSort sortDistances = new QSort(distances);
        int[] sortedDistIndices = sortDistances.getOrigIndx();
        for (int i = 0; i < numNeibsUsed; ++i) {
            int currClassifierIndex = sortedDistIndices[i];
            int currClass = (Integer)reducedClasses.get(currClassifierIndex);
            classCounts[currClass] = classCounts[currClass] + 1;
        }
        int maxCount = 0;
        for (int i = 1; i < classCounts.length; ++i) {
            maxCount = Math.max(maxCount, classCounts[i]);
        }
        int numMaxCountEncountered = 0;
        int assignedClass = 0;
        for (int i = 1; i < classCounts.length; ++i) {
            if (maxCount != classCounts[i]) continue;
            ++numMaxCountEncountered;
            assignedClass = i;
        }
        if (numMaxCountEncountered == 1) {
            return assignedClass;
        }
        return 0;
    }

    private int[][] getCrossValidationStats() throws AlgorithmException {
        int[] numCorrectlyClassifiedByClass = new int[this.numClasses + 1];
        int[] numIncorrectlyClassifiedByClass = new int[this.numClasses + 1];
        for (int i = 0; i < numCorrectlyClassifiedByClass.length; ++i) {
            numCorrectlyClassifiedByClass[i] = 0;
            numIncorrectlyClassifiedByClass[i] = 0;
        }
        AlgorithmEvent algEvent = new AlgorithmEvent((Object)this, 1, this.filteredClassifierSet.size());
        this.fireValueChanged(algEvent);
        algEvent.setId(2);
        for (int i = 0; i < this.filteredClassifierSet.size(); ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            algEvent.setIntValue(i);
            algEvent.setDescription("Cross-validation: testing classifier " + (i + 1));
            this.fireValueChanged(algEvent);
            Vector reducedFilteredClassifierSet = (Vector)this.filteredClassifierSet.clone();
            reducedFilteredClassifierSet.remove(i);
            Vector reducedFilteredClasses = (Vector)this.filteredClasses.clone();
            reducedFilteredClasses.remove(i);
            int rowToClassify = (Integer)this.filteredClassifierSet.get(i);
            if (!this.useCorrelFilter) {
                int currClass = this.getClassificationForCrossValid(rowToClassify, this.numNeighbors, reducedFilteredClassifierSet, reducedFilteredClasses);
                if (this.filteredClassifiersByClass[currClass].contains(new Integer(rowToClassify))) {
                    int n = currClass;
                    numCorrectlyClassifiedByClass[n] = numCorrectlyClassifiedByClass[n] + 1;
                    continue;
                }
                int n = currClass;
                numIncorrectlyClassifiedByClass[n] = numIncorrectlyClassifiedByClass[n] + 1;
                continue;
            }
            Random rnd1 = new Random();
            if (!this.passesCorrelationFilter(rowToClassify, reducedFilteredClassifierSet, this.correlPValue, this.numPerms, rnd1.nextLong())) continue;
            int currClass = this.getClassificationForCrossValid(rowToClassify, this.numNeighbors, reducedFilteredClassifierSet, reducedFilteredClasses);
            if (this.filteredClassifiersByClass[currClass].contains(new Integer(rowToClassify))) {
                int n = currClass;
                numCorrectlyClassifiedByClass[n] = numCorrectlyClassifiedByClass[n] + 1;
                continue;
            }
            int n = currClass;
            numIncorrectlyClassifiedByClass[n] = numIncorrectlyClassifiedByClass[n] + 1;
        }
        int[][] crossValidationStats = new int[][]{numCorrectlyClassifiedByClass, numIncorrectlyClassifiedByClass};
        return crossValidationStats;
    }

    private boolean passesCorrelationFilter(int row, Vector classifiers, double thresholdP, int permutations, long seed) {
        int i;
        boolean passes = false;
        double rMax = this.getRMax(row, classifiers);
        float[] currentRow = new float[this.numCols];
        int timesExceeded = 0;
        long[] seedsArray = new long[permutations];
        Random rand = new Random(seed);
        for (i = 0; i < seedsArray.length; ++i) {
            seedsArray[i] = rand.nextLong();
        }
        for (i = 0; i < permutations; ++i) {
            for (int j = 0; j < currentRow.length; ++j) {
                currentRow[j] = this.expMatrix.A[row][j];
            }
            float[] permutedRow = this.getPermutedValues(row, seedsArray[i]);
            double permRMax = this.getPermRMax(permutedRow, classifiers);
            if (!(permRMax > rMax)) continue;
            ++timesExceeded;
        }
        double permPValue = (double)timesExceeded / (double)permutations;
        passes = permPValue <= thresholdP;
        return passes;
    }

    private double getPermRMax(float[] rowValues, Vector classifiers) {
        double permRMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < classifiers.size(); ++i) {
            int currRow = (Integer)classifiers.get(i);
            float[] currentRowValues = this.getRowValues(currRow);
            double currentR = this.getCorr(rowValues, currentRowValues);
            permRMax = Math.max(permRMax, currentR);
        }
        return permRMax;
    }

    private double getCorr(float[] arrX, float[] arrY) {
        int nArrSize = arrX.length;
        double dblXY = 0.0;
        double dblX = 0.0;
        double dblXX = 0.0;
        double dblY = 0.0;
        double dblYY = 0.0;
        int iValidValCount = 0;
        for (int i = 0; i < nArrSize; ++i) {
            double v_1 = arrX[i];
            double v_2 = arrY[i];
            if (Double.isNaN(v_1) || Double.isNaN(v_2)) continue;
            ++iValidValCount;
            dblXY += v_1 * v_2;
            dblXX += v_1 * v_1;
            dblYY += v_2 * v_2;
            dblX += v_1;
            dblY += v_2;
        }
        if (iValidValCount == 0) {
            return 0.0;
        }
        boolean nonFlat = false;
        for (int j = 1; j < nArrSize; ++j) {
            if (Float.isNaN(arrX[j]) || Float.isNaN(arrY[j])) continue;
            if (arrX[j] != arrX[j - 1]) {
                nonFlat = true;
                break;
            }
            if (arrY[j] == arrY[j - 1]) continue;
            nonFlat = true;
            break;
        }
        if (!nonFlat) {
            return 1.0;
        }
        double dblAvgX = dblX / (double)iValidValCount;
        double dblAvgY = dblY / (double)iValidValCount;
        double dblUpper = dblXY - dblX * dblAvgY - dblAvgX * dblY + dblAvgX * dblAvgY * (double)iValidValCount;
        double p1 = dblXX - dblAvgX * dblX * 2.0 + dblAvgX * dblAvgX * (double)iValidValCount;
        double p2 = dblYY - dblAvgY * dblY * 2.0 + dblAvgY * dblAvgY * (double)iValidValCount;
        double dblLower = p1 * p2;
        return dblUpper / (Math.sqrt(dblLower) + Double.MIN_VALUE) * (double)this.factor;
    }

    private float[] getRowValues(int row) {
        float[] rowValues = new float[this.numCols];
        for (int i = 0; i < rowValues.length; ++i) {
            rowValues[i] = this.expMatrix.A[row][i];
        }
        return rowValues;
    }

    private float[] getPermutedValues(int row, long seed) {
        float[] rowValues = new float[this.numCols];
        float[] permutedRowValues = new float[this.numCols];
        for (int i = 0; i < rowValues.length; ++i) {
            rowValues[i] = this.expMatrix.A[row][i];
        }
        Random generator2 = new Random(seed);
        for (int i = rowValues.length; i > 1; --i) {
            int randVal = generator2.nextInt(i - 1);
            float temp = rowValues[randVal];
            rowValues[randVal] = rowValues[i - 1];
            rowValues[i - 1] = temp;
        }
        return rowValues;
    }

    private double getRMax(int row, Vector classifiers) {
        double rMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < classifiers.size(); ++i) {
            int currRow = (Integer)classifiers.get(i);
            double currentR = ExperimentUtil.genePearson(this.expMatrix, null, currRow, row, this.factor);
            rMax = Math.max(rMax, currentR);
        }
        return rMax;
    }

    private boolean isFoundInVector(int element, Vector vect) {
        boolean found = false;
        for (int i = 0; i < vect.size(); ++i) {
            if (element != (Integer)vect.get(i)) continue;
            found = true;
            break;
        }
        return found;
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    private double getVar(int row) {
        float[] rowValues = new float[this.numCols];
        for (int i = 0; i < rowValues.length; ++i) {
            rowValues[i] = this.expMatrix.A[row][i];
        }
        return this.getVar(rowValues);
    }

    private double getVar(float[] rowValues) {
        float mean = this.getMean(rowValues);
        int n = 0;
        float sumSquares = 0.0f;
        for (int i = 0; i < rowValues.length; ++i) {
            if (Float.isNaN(rowValues[i])) continue;
            sumSquares = (float)((double)sumSquares + Math.pow(rowValues[i] - mean, 2.0));
            ++n;
        }
        if (n < 2) {
            return Double.NaN;
        }
        float var = sumSquares / (float)(n - 1);
        if (Float.isInfinite(var)) {
            return Double.NaN;
        }
        return var;
    }

    private float getMean(float[] group) {
        float sum = 0.0f;
        int n = 0;
        int z = 0;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sum += group[i];
            ++n;
            ++z;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float mean = sum / (float)n;
        if (Float.isInfinite(mean)) {
            return Float.NaN;
        }
        return mean;
    }
}

