/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.HashSet;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.algorithm.impl.KMC;
import org.tigr.util.FloatMatrix;

public class KMCSupport
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private Vector clusterVector = new Vector();
    boolean[] assigned;
    private Vector[] clusters;
    private boolean kmcGenes;
    private int numGenes;
    private int numSamples;
    private int numReps;
    private int k;
    private float thresholdPercent;
    private short[][] geneMatrix;
    private int userK;
    private FloatMatrix expMatrix;
    private int iterations;
    private boolean converged;
    private boolean unassignedExists;
    private boolean calculateMeans;
    HashSet unassignedGeneSet = new HashSet();
    private int hcl_function;
    private boolean hcl_absolute;
    int validN;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("distance-absolute", false);
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        this.iterations = map.getInt("number-of-iterations", 50);
        this.kmcGenes = map.getBoolean("kmc-cluster-genes", true);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.expMatrix = data.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numSamples = this.expMatrix.getColumnDimension();
        this.numReps = map.getInt("number-of-repetitions", 0);
        this.thresholdPercent = map.getFloat("threshold-percent", 80.0f);
        this.userK = map.getInt("number-of-desired-clusters", 5);
        this.calculateMeans = map.getBoolean("calculate-means", true);
        this.geneMatrix = new short[this.numGenes][];
        this.assigned = new boolean[this.numGenes];
        this.unassignedExists = false;
        for (i = 0; i < this.numGenes; ++i) {
            this.assigned[i] = false;
        }
        for (i = 1; i < this.numGenes; ++i) {
            this.geneMatrix[i] = new short[i];
            for (int j = 0; j < this.geneMatrix[i].length; ++j) {
                this.geneMatrix[i][j] = 0;
            }
        }
        this.populateGeneMatrix();
        this.createClusters();
        this.k = this.clusterVector.size();
        this.clusters = new Vector[this.k];
        for (i = 0; i < this.k; ++i) {
            this.clusters[i] = (Vector)this.clusterVector.get(i);
        }
        FloatMatrix means = this.getMeans(this.clusters);
        FloatMatrix variances = this.getVariances(this.clusters, means);
        AlgorithmEvent event = null;
        if (hierarchical_tree) {
            event = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(event);
            event.setIntValue(0);
            event.setId(2);
            this.fireValueChanged(event);
        }
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i2 = 0; i2 < this.clusters.length; ++i2) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.convert2int(this.clusters[i2]);
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            event.setIntValue(i2 + 1);
            this.fireValueChanged(event);
        }
        AlgorithmData result = new AlgorithmData();
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        result.addParam("unassigned-genes-exist", String.valueOf(this.unassignedExists));
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        return result;
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.kmcGenes ? this.getSubExperiment(this.expMatrix, features) : this.getSubExperimentReducedCols(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (Integer)source.get(i);
        }
        return int_matrix;
    }

    private FloatMatrix getMeans(Vector[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.numSamples);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getMean(Vector cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.numSamples);
        int n = cluster.size();
        for (int i = 0; i < this.numSamples; ++i) {
            float currentMean = 0.0f;
            int denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(((Integer)cluster.get(j)).intValue(), i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    private FloatMatrix getVariances(Vector[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleNormalizedSum(Vector cluster, int column, float mean) {
        int size = cluster.size();
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(((Integer)cluster.get(i)).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float getSampleVariance(Vector cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    void populateGeneMatrix() throws AlgorithmException {
        KMC sub_algo = new KMC();
        AlgorithmData sub_algo_data = new AlgorithmData();
        sub_algo_data.addMatrix("experiment", this.expMatrix);
        sub_algo_data.addParam("distance-factor", String.valueOf(this.factor));
        sub_algo_data.addParam("distance-absolute", String.valueOf(this.absolute));
        sub_algo_data.addParam("distance-function", String.valueOf(this.function));
        sub_algo_data.addParam("number-of-iterations", String.valueOf(this.iterations));
        sub_algo_data.addParam("number-of-clusters", String.valueOf(this.userK));
        sub_algo_data.addParam("calculate-means", String.valueOf(this.calculateMeans));
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numReps);
        this.fireValueChanged(event);
        event.setId(2);
        for (int i = 0; i < this.numReps; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            event.setIntValue(i);
            event.setDescription("Current repetition = " + (i + 1));
            this.fireValueChanged(event);
            AlgorithmData sub_algo_result = sub_algo.execute(sub_algo_data);
            Cluster sub_algo_clusters = sub_algo_result.getCluster("cluster");
            int[][] myKMCClusters = this.getClusterArray(sub_algo_clusters);
            for (int j = 1; j < this.numGenes; ++j) {
                for (int k = 0; k < j; ++k) {
                    if (!this.occurInSameCluster(j, k, myKMCClusters)) continue;
                    this.geneMatrix[j][k] = (short)(this.geneMatrix[j][k] + 1);
                }
            }
        }
    }

    private int[][] getClusterArray(Cluster clusters) {
        NodeList nodeList = clusters.getNodeList();
        int number_of_clusters = nodeList.getSize();
        int[][] cArray = new int[number_of_clusters][];
        for (int j = 0; j < number_of_clusters; ++j) {
            int[] cluster = nodeList.getNode(j).getFeaturesIndexes();
            cArray[j] = new int[cluster.length];
            for (int i = 0; i < cluster.length; ++i) {
                cArray[j][i] = cluster[i];
            }
        }
        return cArray;
    }

    boolean occurInSameCluster(int gene1, int gene2, int[][] clustArr) {
        boolean occurs = false;
        for (int i = 0; i < clustArr.length; ++i) {
            int[] currCluster = clustArr[i];
            if (!this.isFound(gene1, currCluster) || !this.isFound(gene2, currCluster)) continue;
            return true;
        }
        return occurs;
    }

    void createClusters() throws AlgorithmException {
        Vector currentClust;
        int i;
        block0: for (int currentGene = 1; currentGene < this.numGenes; ++currentGene) {
            for (int comparisonGene = 0; comparisonGene < currentGene; ++comparisonGene) {
                if (!((float)this.geneMatrix[currentGene][comparisonGene] / (float)this.numReps * 100.0f >= this.thresholdPercent)) continue;
                if (this.assigned[comparisonGene]) {
                    this.addToCluster(currentGene, comparisonGene);
                    this.assigned[currentGene] = true;
                    continue block0;
                }
                Vector<Integer> currentCluster = new Vector<Integer>();
                currentCluster.add(new Integer(currentGene));
                currentCluster.add(new Integer(comparisonGene));
                this.clusterVector.add(currentCluster);
                this.assigned[currentGene] = true;
                this.assigned[comparisonGene] = true;
                continue block0;
            }
        }
        for (int i2 = 0; i2 < this.assigned.length; ++i2) {
            if (this.assigned[i2]) continue;
            this.unassignedGeneSet.add(new Integer(i2));
        }
        Vector<Vector> workingClusterVector = new Vector<Vector>();
        for (i = 0; i < this.clusterVector.size(); ++i) {
            currentClust = (Vector)this.clusterVector.get(i);
            Vector weededOutCluster = this.weedOutLowerThanThreshGenes(currentClust);
            if (weededOutCluster.size() <= 0) continue;
            workingClusterVector.add(weededOutCluster);
        }
        this.clusterVector = workingClusterVector;
        if (this.unassignedGeneSet.size() > 0) {
            for (i = 0; i < this.clusterVector.size(); ++i) {
                currentClust = (Vector)this.clusterVector.get(i);
                Vector recheckedCluster = this.recheckWithUnassigned(currentClust);
                this.clusterVector.set(i, recheckedCluster);
            }
        }
        if (this.unassignedGeneSet.size() > 0) {
            this.unassignedExists = true;
            Vector unassignedVector = new Vector(this.unassignedGeneSet);
            this.clusterVector.add(unassignedVector);
        }
        for (int k = 0; k < this.numGenes; ++k) {
            int found = 0;
            for (int l = 0; l < this.clusterVector.size(); ++l) {
                if (!this.isFound(k, (Vector)this.clusterVector.get(l))) continue;
                ++found;
            }
            if (found > 1) {
                System.out.println("Warning: UniqueID[" + k + "] is found in " + found + "clusters");
            }
            this.errorCheck1(k);
            this.errorCheck2(k);
        }
    }

    private Vector weedOutLowerThanThreshGenes(Vector geneCluster) {
        HashSet<Integer> weededOutGenes = new HashSet<Integer>();
        for (int i = 0; i < geneCluster.size() - 1; ++i) {
            int currentGene = (Integer)geneCluster.get(i);
            for (int j = i + 1; j < geneCluster.size(); ++j) {
                int gene = (Integer)geneCluster.get(j);
                if (currentGene > gene) {
                    if (!((float)this.geneMatrix[currentGene][gene] / (float)this.numReps * 100.0f < this.thresholdPercent)) continue;
                    this.unassignedGeneSet.add(new Integer(currentGene));
                    this.unassignedGeneSet.add(new Integer(gene));
                    weededOutGenes.add(new Integer(currentGene));
                    weededOutGenes.add(new Integer(gene));
                    continue;
                }
                if (currentGene >= gene || !((float)this.geneMatrix[gene][currentGene] / (float)this.numReps * 100.0f < this.thresholdPercent)) continue;
                this.unassignedGeneSet.add(new Integer(currentGene));
                this.unassignedGeneSet.add(new Integer(gene));
                weededOutGenes.add(new Integer(currentGene));
                weededOutGenes.add(new Integer(gene));
            }
        }
        geneCluster.removeAll(weededOutGenes);
        return geneCluster;
    }

    private Vector recheckWithUnassigned(Vector geneCluster) {
        Vector localUnassignedVect = new Vector(this.unassignedGeneSet);
        for (int i = 0; i < localUnassignedVect.size(); ++i) {
            int unassignedGene = (Integer)localUnassignedVect.get(i);
            if (!this.belongsInCluster(unassignedGene, geneCluster)) continue;
            geneCluster.add(new Integer(unassignedGene));
            this.unassignedGeneSet.remove(new Integer(unassignedGene));
        }
        return geneCluster;
    }

    private boolean belongsInCluster(int gene, Vector geneCluster) {
        boolean belongs = true;
        for (int i = 0; i < geneCluster.size(); ++i) {
            int currentGene = (Integer)geneCluster.get(i);
            if (gene == currentGene) {
                belongs = true;
                break;
            }
            if (gene > currentGene) {
                if (!((float)this.geneMatrix[gene][currentGene] / (float)this.numReps * 100.0f < this.thresholdPercent)) continue;
                belongs = false;
                break;
            }
            if (gene >= currentGene || !((float)this.geneMatrix[currentGene][gene] / (float)this.numReps * 100.0f < this.thresholdPercent)) continue;
            belongs = false;
            break;
        }
        return belongs;
    }

    void addToCluster(int geneToBeAdded, int geneInTargetCluster) {
        for (int i = 0; i < this.clusterVector.size(); ++i) {
            Vector currentCluster = (Vector)this.clusterVector.get(i);
            if (!this.isFound(geneInTargetCluster, currentCluster)) continue;
            currentCluster.add(new Integer(geneToBeAdded));
            this.clusterVector.set(i, currentCluster);
            break;
        }
    }

    boolean isFound(int gene, Vector clustVect) {
        boolean found = false;
        for (int i = 0; i < clustVect.size(); ++i) {
            if (gene != (Integer)clustVect.get(i)) continue;
            return true;
        }
        return found;
    }

    boolean isFound(int gene, int[] clustArr) {
        boolean found = false;
        for (int i = 0; i < clustArr.length; ++i) {
            if (gene != clustArr[i]) continue;
            return true;
        }
        return found;
    }

    public boolean unassignedGenesExist() {
        return this.unassignedExists;
    }

    void errorCheck1(int gene) {
        boolean error1 = false;
        if (gene == 0) {
            if (!this.assigned[gene]) {
                for (int i = 1; i < this.numGenes; ++i) {
                    if (!((float)this.geneMatrix[i][0] / (float)this.numReps * 100.0f >= this.thresholdPercent)) continue;
                    error1 = true;
                    break;
                }
            }
        } else if (!this.assigned[gene]) {
            for (int i = 0; i < gene; ++i) {
                if (!((float)this.geneMatrix[gene][i] / (float)this.numReps * 100.0f >= this.thresholdPercent)) continue;
                error1 = true;
                break;
            }
        }
        if (error1) {
            System.out.println("Warning: UniqueID[" + gene + "] not assigned even though it equals or exceeds the threshold % for at least one entry");
        }
    }

    void errorCheck2(int gene) {
        boolean error2 = false;
        Vector<Integer> foundInClusters = new Vector<Integer>();
        for (int j = 0; j < this.clusterVector.size(); ++j) {
            if (!this.isFound(gene, (Vector)this.clusterVector.get(j))) continue;
            foundInClusters.add(new Integer(j));
        }
        block1: for (int i = 0; i < foundInClusters.size(); ++i) {
            int clusterNumber = (Integer)foundInClusters.get(i);
            Vector currClust = (Vector)this.clusterVector.get(clusterNumber);
            for (int l = 0; l < currClust.size(); ++l) {
                int currGene = (Integer)currClust.get(l);
                if (currGene == gene) continue;
                if (currGene > gene) {
                    if (!((float)this.geneMatrix[currGene][gene] / (float)this.numReps * 100.0f < this.thresholdPercent)) continue;
                    error2 = true;
                    if (this.unassignedExists && clusterNumber == this.clusterVector.size() - 1) break block1;
                    System.out.println("Warning: UniqueID[" + gene + "] got assigned to cluster" + clusterNumber + " where its 'affinity' to at least one gene is less than the threshold %");
                    System.out.println("geneMatrix[" + currGene + "][" + gene + "] = " + this.geneMatrix[currGene][gene]);
                    break block1;
                }
                if (!((float)this.geneMatrix[gene][currGene] / (float)this.numReps * 100.0f < this.thresholdPercent)) continue;
                error2 = true;
                if (this.unassignedExists && clusterNumber == this.clusterVector.size() - 1) break block1;
                System.out.println("Warning: UniqueID[" + gene + "] got assigned to cluster" + clusterNumber + " where its 'affinity' to at least one gene is less than the threshold %");
                System.out.println("geneMatrix[" + gene + "][" + currGene + "] = " + this.geneMatrix[gene][currGene]);
                break block1;
            }
        }
    }

    public Vector itf(Vector integerVector) {
        Vector<Float> floatVector = new Vector<Float>();
        for (int i = 0; i < integerVector.size(); ++i) {
            floatVector.addElement(new Float(((Integer)integerVector.elementAt(i)).intValue()));
        }
        return floatVector;
    }

    public void abort() {
        this.stop = true;
    }
}

