/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.awt.Window;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.FloatMatrix;

public class HCL
extends AbstractAlgorithm {
    private boolean stop = false;
    private boolean nmf = false;
    int i;
    int n;
    private int parentless;
    private double TreeHeight;
    private int Assigned;
    private int OptProgress;
    private float[][] nmfSimMat;
    private FloatMatrix expMatrix;
    float[] Min;
    int[] MinIndex;
    float[][] SimilarityMatrix;
    boolean genes;
    boolean optimizeOrdering;
    int function;
    float factor;
    boolean absolute;
    private AlgorithmEvent event;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData executeNMF(AlgorithmData data, float[][] simMat) throws AlgorithmException {
        this.nmf = true;
        this.nmfSimMat = simMat;
        return this.execute(data);
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        this.expMatrix = data.getMatrix("experiment");
        if (this.expMatrix == null) {
            throw new AlgorithmException("Input data is absent.");
        }
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("hcl-distance-function", 4);
        this.absolute = map.getBoolean("hcl-distance-absolute", false);
        this.genes = map.getBoolean("calculate-genes", true);
        this.optimizeOrdering = map.getBoolean("optimize-sample-ordering", false);
        if (this.genes) {
            this.optimizeOrdering = map.getBoolean("optimize-gene-ordering", false);
        }
        int method = map.getInt("method-linkage", 0);
        this.n = this.genes ? this.expMatrix.getRowDimension() : this.expMatrix.getColumnDimension();
        int two_n = 2 * this.n;
        this.Assigned = this.n;
        this.parentless = this.n;
        this.TreeHeight = 0.0;
        double MaxCorrelation = 0.0;
        float[] Height = new float[two_n];
        int[] Parent = new int[two_n];
        int[] Child1 = new int[two_n];
        int[] Child2 = new int[two_n];
        int[] NodeHeight = new int[two_n];
        int[] NodeOrder = new int[this.n];
        int[] NumberOfChildren = new int[two_n];
        int[][] LeavesUnder = new int[two_n][];
        for (i = 0; i < two_n; ++i) {
            Height[i] = 0.0f;
            Parent[i] = -1;
            Child1[i] = -1;
            Child2[i] = -1;
            NodeHeight[i] = 0;
        }
        for (i = 0; i < this.n; ++i) {
            NodeOrder[i] = -1;
            NumberOfChildren[i] = 1;
        }
        int memoryAssess = ExperimentUtil.javaHCLMemoryAssess(this.n, this.optimizeOrdering);
        if (memoryAssess == 0) {
            this.stop = false;
        }
        if (memoryAssess == 1) {
            this.stop = true;
        }
        if (memoryAssess == 2) {
            this.stop = true;
            HelpWindow.launchBrowser((Window)new JFrame(), (String)"Java Out of Memory Error");
        }
        this.SimilarityMatrix = new float[this.n][];
        if (this.optimizeOrdering && !this.stop) {
            this.SimilarityMatrix = new float[this.n][this.n];
        }
        this.Min = new float[this.n];
        this.MinIndex = new int[this.n];
        int UNITS = 200;
        this.event = new AlgorithmEvent((Object)this, 1, 200, "Creating similarity matrix");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        int CurrentProgress = 0;
        int OldCurrentProgress = 0;
        double Factor = 200.0 / (double)this.n;
        if (!this.nmf) {
            this.factor = 1.0f;
            ExecutorService pool = Executors.newFixedThreadPool(8);
            this.i = 1;
            while (this.i < this.n) {
                final int iFinal = this.i++;
                Runnable runnable1 = new Runnable(){

                    @Override
                    public void run() {
                        HCL.this.fillSimMatRow(iFinal);
                    }
                };
                Thread thread1 = new Thread(runnable1);
                pool.execute(thread1);
            }
            try {
                System.out.println("awaiting termination...");
                System.out.println(Thread.activeCount());
                pool.shutdown();
                try {
                    pool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println(Thread.activeCount());
                System.out.println("terminated.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.SimilarityMatrix = this.nmfSimMat;
            this.i = 1;
            while (this.i < this.n) {
                for (int j = 0; j < this.i; ++j) {
                    if (!(this.SimilarityMatrix[this.i][j] < this.Min[this.i])) continue;
                    this.Min[this.i] = this.SimilarityMatrix[this.i][j];
                    this.MinIndex[this.i] = j;
                }
                ++this.i;
            }
        }
        if (this.stop) {
            throw new AbortException();
        }
        this.event = new AlgorithmEvent((Object)this, 1, 200, "Calculating tree");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        long CalculatedNodes = 0L;
        CurrentProgress = 0;
        OldCurrentProgress = 0;
        Factor = 200.0 / (double)this.n;
        int NodeCounter = 0;
        double MaxDistance = 0.0;
        double MinDistance = Double.POSITIVE_INFINITY;
        MaxCorrelation = Double.POSITIVE_INFINITY;
        double MinCorrelation = Double.POSITIVE_INFINITY;
        int[] owner = new int[this.n];
        this.i = 0;
        while (this.i < this.n) {
            owner[this.i] = this.i;
            ++this.i;
        }
        while (this.parentless > 1) {
            int p;
            int k;
            if (this.stop) {
                throw new AbortException();
            }
            CurrentProgress = (int)((double)(CalculatedNodes + 1L) * Factor);
            if (CurrentProgress > OldCurrentProgress) {
                this.event.setIntValue(CurrentProgress);
                this.fireValueChanged(this.event);
                OldCurrentProgress = CurrentProgress;
            }
            ++CalculatedNodes;
            double close_d = Double.POSITIVE_INFINITY;
            double test_d = Double.POSITIVE_INFINITY;
            int test_i = -2;
            int test_j = -2;
            int close_i = -2;
            int close_j = -2;
            this.i = 1;
            while (this.i < this.n) {
                if (owner[this.i] != -1 && (double)this.Min[this.i] < test_d) {
                    test_d = this.Min[this.i];
                    test_i = this.i;
                    test_j = this.MinIndex[this.i];
                }
                ++this.i;
            }
            this.i = close_i;
            int j = close_j;
            this.i = test_i;
            j = test_j;
            double height_k = close_d = test_d;
            if (Math.abs(close_d) > 0.0 && Math.abs(close_d) < MinDistance) {
                MinDistance = Math.abs(close_d);
            }
            if (close_d != 1.0 && close_d < MaxCorrelation) {
                MaxCorrelation = close_d;
            }
            if (close_d > MaxCorrelation && close_d < MinCorrelation) {
                MinCorrelation = close_d;
            }
            if (close_d > MaxDistance) {
                MaxDistance = close_d;
            }
            try {
                if (owner[this.i] >= this.n && (double)Height[owner[this.i]] > height_k) {
                    k = owner[this.i];
                    this.AssertParentage(Parent, NumberOfChildren, Child1, Child2, owner[j], k);
                } else if (owner[j] >= this.n && (double)Height[owner[j]] > height_k) {
                    k = owner[j];
                    this.AssertParentage(Parent, NumberOfChildren, Child1, Child2, owner[this.i], k);
                } else {
                    k = this.NewNode(Height, height_k);
                    this.AssertParentage(Parent, NumberOfChildren, Child1, Child2, owner[this.i], k);
                    this.AssertParentage(Parent, NumberOfChildren, Child1, Child2, owner[j], k);
                }
                NodeOrder[NodeCounter] = k;
                NodeHeight[k] = Math.max(NodeHeight[Child1[k]] + 1, NodeHeight[Child2[k]] + 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.fireValueChanged(new AlgorithmEvent((Object)this, 4, 0, "Error: " + e.toString() + " - Height(" + String.valueOf(height_k) + "," + ")"));
                k = 0;
            }
            ++NodeCounter;
            owner[this.i] = k;
            owner[j] = -1;
            if (method == -1) {
                for (p = 0; p < j; ++p) {
                    if (owner[p] == -1) continue;
                    this.SimilarityMatrix[this.i][p] = Math.min(this.SimilarityMatrix[this.i][p], this.SimilarityMatrix[j][p]);
                }
                for (p = j + 1; p < this.i; ++p) {
                    if (owner[p] == -1) continue;
                    this.SimilarityMatrix[this.i][p] = Math.min(this.SimilarityMatrix[this.i][p], this.SimilarityMatrix[p][j]);
                }
                for (p = this.i + 1; p < this.n; ++p) {
                    if (owner[p] == -1) continue;
                    this.SimilarityMatrix[p][this.i] = Math.min(this.SimilarityMatrix[p][this.i], this.SimilarityMatrix[p][j]);
                }
            } else if (method == 1) {
                for (p = 0; p < j; ++p) {
                    if (owner[p] == -1) continue;
                    this.SimilarityMatrix[this.i][p] = Math.max(this.SimilarityMatrix[this.i][p], this.SimilarityMatrix[j][p]);
                }
                for (p = j + 1; p < this.i; ++p) {
                    if (owner[p] == -1) continue;
                    this.SimilarityMatrix[this.i][p] = Math.max(this.SimilarityMatrix[this.i][p], this.SimilarityMatrix[p][j]);
                }
                for (p = this.i + 1; p < this.n; ++p) {
                    if (owner[p] == -1) continue;
                    this.SimilarityMatrix[p][this.i] = Math.max(this.SimilarityMatrix[p][this.i], this.SimilarityMatrix[p][j]);
                }
            } else if (method == 2) {
                for (p = 0; p < j; ++p) {
                    if (owner[p] == -1) continue;
                    this.SimilarityMatrix[this.i][p] = (float)((double)(this.SimilarityMatrix[this.i][p] * (float)NumberOfChildren[owner[this.i]] + this.SimilarityMatrix[j][p] * (float)NumberOfChildren[owner[j]]) / (2.0 * (double)Math.min(NumberOfChildren[owner[this.i]], NumberOfChildren[owner[j]])));
                }
                for (p = j + 1; p < this.i; ++p) {
                    if (owner[p] == -1) continue;
                    this.SimilarityMatrix[this.i][p] = (float)((double)(this.SimilarityMatrix[this.i][p] * (float)NumberOfChildren[owner[this.i]] + this.SimilarityMatrix[p][j] * (float)NumberOfChildren[owner[j]]) / (2.0 * (double)Math.min(NumberOfChildren[owner[this.i]], NumberOfChildren[owner[j]])));
                }
                for (p = this.i + 1; p < this.n; ++p) {
                    if (owner[p] == -1) continue;
                    this.SimilarityMatrix[p][this.i] = (float)((double)(this.SimilarityMatrix[p][this.i] * (float)NumberOfChildren[owner[this.i]] + this.SimilarityMatrix[p][j] * (float)NumberOfChildren[owner[j]]) / (2.0 * (double)Math.min(NumberOfChildren[owner[this.i]], NumberOfChildren[owner[j]])));
                }
            } else if (method == 0) {
                for (p = 0; p < j; ++p) {
                    if (owner[p] == -1) continue;
                    this.SimilarityMatrix[this.i][p] = (float)((double)(this.SimilarityMatrix[this.i][p] + this.SimilarityMatrix[j][p]) / 2.0);
                }
                for (p = j + 1; p < this.i; ++p) {
                    if (owner[p] == -1) continue;
                    this.SimilarityMatrix[this.i][p] = (float)((double)(this.SimilarityMatrix[this.i][p] + this.SimilarityMatrix[p][j]) / 2.0);
                }
                for (p = this.i + 1; p < this.n; ++p) {
                    try {
                        if (owner[p] == -1) continue;
                        this.SimilarityMatrix[p][this.i] = (float)((double)(this.SimilarityMatrix[p][this.i] + this.SimilarityMatrix[p][j]) / 2.0);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            for (p = j; p < this.n; ++p) {
                if (owner[p] == -1 || this.MinIndex[p] != j && this.MinIndex[p] != this.i) continue;
                this.Min[p] = Float.POSITIVE_INFINITY;
                for (int l = 0; l < p; ++l) {
                    if (owner[l] == -1 || !(this.SimilarityMatrix[p][l] < this.Min[p])) continue;
                    this.Min[p] = this.SimilarityMatrix[p][l];
                    this.MinIndex[p] = l;
                }
            }
        }
        if (this.optimizeOrdering && this.n > 1) {
            int reset;
            int leavesInit;
            for (leavesInit = this.n; leavesInit < 2 * this.n - 1; ++leavesInit) {
                LeavesUnder[leavesInit] = new int[NumberOfChildren[leavesInit]];
            }
            for (leavesInit = 0; leavesInit < this.n; ++leavesInit) {
                LeavesUnder[leavesInit] = new int[1];
                LeavesUnder[leavesInit][0] = leavesInit;
            }
            this.MakeLeavesUnderMatrix(2 * this.n - 2, Child1, Child2, this.n, LeavesUnder, NumberOfChildren);
            float[][] OptimalSum = new float[this.n][this.n];
            float bestMatch = Float.POSITIVE_INFINITY;
            int bestU = 0;
            int bestW = 0;
            this.OptProgress = 0;
            AlgorithmEvent optevent = null;
            optevent = new AlgorithmEvent((Object)this, 1, this.n * this.n / 2, "Optimizing Leaf Order");
            this.fireValueChanged(optevent);
            optevent.setId(2);
            optevent.setIntValue(0);
            this.fireValueChanged(optevent);
            for (reset = 0; reset < this.n; ++reset) {
                Child1[reset] = reset;
                Child2[reset] = reset;
            }
            this.MakeOptimalSumMatrix(Child1, Child2, NumberOfChildren, LeavesUnder, OptimalSum, this.SimilarityMatrix, this.n, 2 * this.n - 2, optevent);
            for (reset = 0; reset < this.n; ++reset) {
                Child1[reset] = -1;
                Child2[reset] = -1;
            }
            if (!this.stop) {
                for (int u = 0; u < NumberOfChildren[Child1[two_n - 2]]; ++u) {
                    for (int w = 0; w < NumberOfChildren[Child2[two_n - 2]]; ++w) {
                        float match = OptimalSum[LeavesUnder[Child1[two_n - 2]][u]][LeavesUnder[Child2[two_n - 2]][w]];
                        if (!(match < bestMatch)) continue;
                        bestMatch = match;
                        bestU = LeavesUnder[Child1[two_n - 2]][u];
                        bestW = LeavesUnder[Child2[two_n - 2]][w];
                    }
                }
                this.OptimizeLeafOrder(two_n - 2, NumberOfChildren, LeavesUnder, Child1, Child2, OptimalSum, bestU, bestW, this.n);
            }
        }
        AlgorithmData result = new AlgorithmData();
        result.addIntArray("child-1-array", Child1);
        result.addIntArray("child-2-array", Child2);
        result.addIntArray("node-order", NodeOrder);
        result.addMatrix("height", new FloatMatrix(Height, Height.length));
        result.addParam("function", String.valueOf(this.function));
        return result;
    }

    private void fillSimMatRow(int i) {
        if (!this.optimizeOrdering) {
            this.SimilarityMatrix[i] = new float[i];
        }
        this.Min[i] = Float.POSITIVE_INFINITY;
        for (int j = 0; j < i; ++j) {
            this.SimilarityMatrix[i][j] = this.genes ? ExperimentUtil.geneDistance(this.expMatrix, null, i, j, this.function, this.factor, this.absolute) : ExperimentUtil.distance(this.expMatrix, i, j, this.function, this.factor, this.absolute);
            if (this.optimizeOrdering) {
                this.SimilarityMatrix[j][i] = this.SimilarityMatrix[i][j];
            }
            if (!(this.SimilarityMatrix[i][j] < this.Min[i])) continue;
            this.Min[i] = this.SimilarityMatrix[i][j];
            this.MinIndex[i] = j;
        }
        this.event.setIntValue((int)((double)i * 200.0 / (double)this.n));
        this.fireValueChanged(this.event);
    }

    public void AssertParentage(int[] Parent, int[] NumberOfChildren, int[] Child1, int[] Child2, int child, int paren) {
        try {
            if (Parent[child] == -1) {
                Parent[child] = paren;
                --this.parentless;
                Child2[paren] = Child1[paren];
                Child1[paren] = child;
                int n = paren;
                NumberOfChildren[n] = NumberOfChildren[n] + NumberOfChildren[child];
            }
        }
        catch (Exception e) {
            this.fireValueChanged(new AlgorithmEvent((Object)this, 4, 0, "Error: " + e.toString() + " - AssertParentage(" + String.valueOf(child) + "," + String.valueOf(paren) + ")"));
        }
    }

    public int NewNode(float[] Height, double h) {
        Height[this.Assigned] = (float)h;
        if (h > this.TreeHeight) {
            this.TreeHeight = h;
        }
        ++this.parentless;
        return this.Assigned++;
    }

    public void MakeLeavesUnderMatrix(int node, int[] Child1, int[] Child2, int n, int[][] LeavesUnder, int[] NumberOfChildren) {
        int i;
        if (Child1[node] >= n) {
            this.MakeLeavesUnderMatrix(Child1[node], Child1, Child2, n, LeavesUnder, NumberOfChildren);
            for (i = 0; i < NumberOfChildren[Child1[node]]; ++i) {
                LeavesUnder[node][i] = LeavesUnder[Child1[node]][i];
            }
        }
        if (Child1[node] < n) {
            LeavesUnder[node][0] = Child1[node];
        }
        if (Child2[node] >= n) {
            this.MakeLeavesUnderMatrix(Child2[node], Child1, Child2, n, LeavesUnder, NumberOfChildren);
            for (i = 0; i < NumberOfChildren[Child2[node]]; ++i) {
                LeavesUnder[node][i + NumberOfChildren[Child1[node]]] = LeavesUnder[Child2[node]][i];
            }
        }
        if (Child2[node] < n) {
            LeavesUnder[node][NumberOfChildren[Child1[node]]] = Child2[node];
        }
    }

    public void MakeOptimalSumMatrix(int[] Child1, int[] Child2, int[] NumberOfChildren, int[][] LeavesUnder, float[][] OptimalSum, float[][] SimilarityMatrix, int n, int node, AlgorithmEvent optevent) {
        if (this.stop) {
            return;
        }
        if (node >= n) {
            if (NumberOfChildren[node] == 2) {
                OptimalSum[LeavesUnder[node][0]][LeavesUnder[node][1]] = SimilarityMatrix[LeavesUnder[node][0]][LeavesUnder[node][1]];
                OptimalSum[LeavesUnder[node][1]][LeavesUnder[node][0]] = SimilarityMatrix[LeavesUnder[node][0]][LeavesUnder[node][1]];
            } else {
                this.MakeOptimalSumMatrix(Child1, Child2, NumberOfChildren, LeavesUnder, OptimalSum, SimilarityMatrix, n, Child1[node], optevent);
                this.MakeOptimalSumMatrix(Child1, Child2, NumberOfChildren, LeavesUnder, OptimalSum, SimilarityMatrix, n, Child2[node], optevent);
                int unode = -1;
                int wnode = -1;
                int mnode = -1;
                int knode = -1;
                for (int arrangement = 0; arrangement < 4; ++arrangement) {
                    int align;
                    int ranker;
                    if (arrangement == 0) {
                        unode = Child1[Child1[node]];
                        wnode = Child2[Child2[node]];
                        mnode = Child2[Child1[node]];
                        knode = Child1[Child2[node]];
                    }
                    if (arrangement == 1) {
                        unode = Child1[Child1[node]];
                        wnode = Child1[Child2[node]];
                        mnode = Child2[Child1[node]];
                        knode = Child2[Child2[node]];
                    }
                    if (arrangement == 2) {
                        unode = Child2[Child1[node]];
                        wnode = Child2[Child2[node]];
                        mnode = Child1[Child1[node]];
                        knode = Child1[Child2[node]];
                    }
                    if (arrangement == 3) {
                        unode = Child2[Child1[node]];
                        wnode = Child1[Child2[node]];
                        mnode = Child1[Child1[node]];
                        knode = Child2[Child2[node]];
                    }
                    float[][] rankedU = new float[NumberOfChildren[unode]][NumberOfChildren[mnode]];
                    float[][] rankedW = new float[NumberOfChildren[wnode]][NumberOfChildren[knode]];
                    int[][] leafRankingOrderU = new int[NumberOfChildren[unode]][NumberOfChildren[mnode]];
                    int[][] leafRankingOrderW = new int[NumberOfChildren[wnode]][NumberOfChildren[knode]];
                    for (int u = 0; u < NumberOfChildren[unode]; ++u) {
                        for (ranker = 0; ranker < NumberOfChildren[mnode]; ++ranker) {
                            rankedU[u][ranker] = OptimalSum[LeavesUnder[unode][u]][LeavesUnder[mnode][ranker]];
                        }
                        Arrays.sort(rankedU[u]);
                        for (align = 0; align < NumberOfChildren[mnode]; ++align) {
                            leafRankingOrderU[u][align] = LeavesUnder[mnode][Arrays.binarySearch(rankedU[u], OptimalSum[LeavesUnder[unode][u]][LeavesUnder[mnode][align]])];
                        }
                    }
                    for (int w = 0; w < NumberOfChildren[wnode]; ++w) {
                        for (ranker = 0; ranker < NumberOfChildren[knode]; ++ranker) {
                            rankedW[w][ranker] = OptimalSum[LeavesUnder[wnode][w]][LeavesUnder[knode][ranker]];
                        }
                        Arrays.sort(rankedW[w]);
                        for (align = 0; align < NumberOfChildren[knode]; ++align) {
                            leafRankingOrderW[w][align] = LeavesUnder[knode][Arrays.binarySearch(rankedW[w], OptimalSum[LeavesUnder[wnode][w]][LeavesUnder[knode][align]])];
                        }
                    }
                    this.fillOptSumMatrix(NumberOfChildren, rankedU, rankedW, SimilarityMatrix, leafRankingOrderU, leafRankingOrderW, OptimalSum, LeavesUnder, unode, mnode, knode, wnode, optevent);
                }
            }
        }
    }

    public void fillOptSumMatrix(int[] NumberOfChildren, float[][] rankedU, float[][] rankedW, float[][] SimilarityMatrix, int[][] leafRankingOrderU, int[][] leafRankingOrderW, float[][] OptimalSum, int[][] LeavesUnder, int unode, int mnode, int knode, int wnode, AlgorithmEvent optevent) {
        float currentMin = Float.POSITIVE_INFINITY;
        float currentC = Float.POSITIVE_INFINITY;
        float bestC = Float.POSITIVE_INFINITY;
        for (int m = 0; m < NumberOfChildren[mnode]; ++m) {
            for (int k = 0; k < NumberOfChildren[knode]; ++k) {
                currentC = SimilarityMatrix[LeavesUnder[mnode][m]][LeavesUnder[knode][k]];
                if (!(bestC > currentC)) continue;
                bestC = currentC;
            }
        }
        for (int u = 0; u < NumberOfChildren[unode]; ++u) {
            for (int w = 0; w < NumberOfChildren[wnode]; ++w) {
                if (this.stop) {
                    return;
                }
                for (int m = 0; m < NumberOfChildren[mnode] && !(rankedU[u][m] + rankedW[w][0] + bestC >= currentMin); ++m) {
                    for (int k = 0; k < NumberOfChildren[knode] && !(rankedU[u][m] + rankedW[w][k] + bestC >= currentMin); ++k) {
                        if (!(rankedU[u][m] + rankedW[w][k] + SimilarityMatrix[leafRankingOrderU[u][m]][leafRankingOrderW[w][k]] < currentMin)) continue;
                        currentMin = rankedU[u][m] + rankedW[w][k] + SimilarityMatrix[leafRankingOrderU[u][m]][leafRankingOrderW[w][k]];
                    }
                }
                OptimalSum[LeavesUnder[unode][u]][LeavesUnder[wnode][w]] = currentMin;
                OptimalSum[LeavesUnder[wnode][w]][LeavesUnder[unode][u]] = currentMin;
                currentMin = Float.POSITIVE_INFINITY;
                ++this.OptProgress;
                optevent.setIntValue(this.OptProgress);
                this.fireValueChanged(optevent);
            }
        }
    }

    private void OptimizeLeafOrder(int node, int[] NumberOfChildren, int[][] LeavesUnder, int[] Child1, int[] Child2, float[][] OptimalSum, int bestU, int bestW, int n) {
        float bestMatch = Float.POSITIVE_INFINITY;
        int bestM = -1;
        int bestK = -1;
        int leftInnerChildren = 1;
        int rightInnerChildren = 1;
        int innerLeftLeaf = bestU;
        int innerRightLeaf = bestW;
        float bestRight = 0.0f;
        float bestLeft = 0.0f;
        this.rotateNodes(NumberOfChildren, Child1, Child2, bestU, bestW, node, n, LeavesUnder);
        if (Child1[node] >= n) {
            leftInnerChildren = NumberOfChildren[Child2[Child1[node]]];
        }
        if (Child2[node] >= n) {
            rightInnerChildren = NumberOfChildren[Child1[Child2[node]]];
        }
        for (int m = 0; m < leftInnerChildren; ++m) {
            for (int k = 0; k < rightInnerChildren; ++k) {
                float match;
                if (Child1[node] >= n) {
                    bestLeft = OptimalSum[bestU][LeavesUnder[Child2[Child1[node]]][m]];
                    innerLeftLeaf = LeavesUnder[Child2[Child1[node]]][m];
                }
                if (Child2[node] >= n) {
                    bestRight = OptimalSum[bestW][LeavesUnder[Child1[Child2[node]]][k]];
                    innerRightLeaf = LeavesUnder[Child1[Child2[node]]][k];
                }
                if (!((match = bestLeft + bestRight + OptimalSum[innerLeftLeaf][innerRightLeaf]) < bestMatch)) continue;
                bestMatch = match;
                bestM = innerLeftLeaf;
                bestK = innerRightLeaf;
            }
        }
        if (Child1[node] >= n) {
            this.OptimizeLeafOrder(Child1[node], NumberOfChildren, LeavesUnder, Child1, Child2, OptimalSum, bestU, bestM, n);
        }
        if (Child2[node] >= n) {
            this.OptimizeLeafOrder(Child2[node], NumberOfChildren, LeavesUnder, Child1, Child2, OptimalSum, bestK, bestW, n);
        }
    }

    private void rotateNodes(int[] NumberOfChildren, int[] Child1, int[] Child2, int bestU, int bestW, int node, int n, int[][] LeavesUnder) {
        int intermediate;
        int u;
        for (u = 0; u < NumberOfChildren[Child2[node]]; ++u) {
            if (bestU != LeavesUnder[Child2[node]][u]) continue;
            intermediate = Child1[node];
            Child1[node] = Child2[node];
            Child2[node] = intermediate;
        }
        if (Child1[node] >= n) {
            for (u = 0; u < NumberOfChildren[Child2[Child1[node]]]; ++u) {
                if (bestU != LeavesUnder[Child2[Child1[node]]][u]) continue;
                intermediate = Child1[Child1[node]];
                Child1[Child1[node]] = Child2[Child1[node]];
                Child2[Child1[node]] = intermediate;
            }
        }
        if (Child2[node] >= n) {
            for (u = 0; u < NumberOfChildren[Child1[Child2[node]]]; ++u) {
                if (bestW != LeavesUnder[Child1[Child2[node]]][u]) continue;
                intermediate = Child2[Child2[node]];
                Child2[Child2[node]] = Child1[Child2[node]];
                Child1[Child2[node]] = intermediate;
            }
        }
    }
}

