/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import Jama.SingularValueDecomposition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.util.Adjustment;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ProgressDialog;

public class GSH
extends AbstractAlgorithm {
    private long StartTime;
    private long CalculationTime;
    private JLabel StatusLabel;
    private int CurrentCluster;
    private int CreatedCluster;
    private GSCluster[] clusters;
    private GSCluster[] resultClusters;
    private boolean gshGenes;
    private int m;
    private int n;
    private int k;
    private int fakedMatrix;
    private int swapTime;
    private int matrixSize;
    private int geneAssaigned = 0;
    private int validN;
    private Matrix dataMatrix;
    private Matrix workingMatrix;
    private SingularValueDecomposition SVD;
    private EigenvalueDecomposition EVD;
    private double[][] values;
    private Matrix eigenVector;
    private double[] prinCom;
    private double[] currentGene;
    private GSCluster unassigned;
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    ProgressDialog PD;
    private int number_of_genes;
    private int number_of_samples;
    private FloatMatrix expMatrix;
    private int hcl_function;
    private boolean hcl_absolute;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int number_of_clusters;
        int number_of_swap;
        int number_of_fakedMatrix;
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("distance-absolute", false);
        this.gshGenes = map.getBoolean("gsh-cluster-genes", true);
        this.fakedMatrix = number_of_fakedMatrix = map.getInt("number-of-fakedMatrix", 20);
        this.swapTime = number_of_swap = map.getInt("number-of-swap", 5);
        this.k = number_of_clusters = map.getInt("number-of-clusters", 5);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        this.expMatrix = data.getMatrix("experiment");
        this.n = this.number_of_genes = this.expMatrix.getRowDimension();
        this.m = this.number_of_samples = this.expMatrix.getColumnDimension();
        this.values = new double[this.n][this.m];
        this.prinCom = new double[this.m];
        JFrame dummyFrame = new JFrame();
        this.PD = this.gshGenes ? new ProgressDialog(dummyFrame, "Gene Shaving -- Progress", false, 6) : new ProgressDialog(dummyFrame, "Sample Shaving -- Progress", false, 6);
        JPanel progressPanel = this.PD.getLabelPanel();
        JPanel superPanel = new JPanel();
        superPanel.setLayout(new BorderLayout());
        JButton abortButton = new JButton(" Cancel ");
        abortButton.setBorder(BorderFactory.createBevelBorder(0));
        abortButton.setFocusPainted(false);
        abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GSH.this.stop = true;
                GSH.this.PD.dismiss();
            }
        });
        superPanel.add((Component)progressPanel, "Center");
        superPanel.add((Component)abortButton, "South");
        this.PD.setMainPanel(superPanel);
        this.PD.setSize(450, 200);
        this.calculate();
        FloatMatrix means = this.getMeans(this.clusters);
        FloatMatrix variances = this.getVariances(this.clusters, means);
        AlgorithmEvent event = null;
        if (hierarchical_tree) {
            event = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(event);
            event.setIntValue(0);
            event.setId(2);
            this.fireValueChanged(event);
        }
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.convert2int(this.clusters[i]);
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            event.setIntValue(i + 1);
            this.fireValueChanged(event);
        }
        AlgorithmData result = new AlgorithmData();
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        result.addMatrix("clusters-means", means);
        result.addMatrix("clusters-variances", variances);
        return result;
    }

    public void getMatrix() {
        int j;
        int i;
        double[][] temp = new double[this.n][this.m];
        for (i = 0; i < this.n; ++i) {
            for (j = 0; j < this.m; ++j) {
                temp[i][j] = this.expMatrix.A[i][j];
            }
        }
        Adjustment.meanCenterSpots((FloatMatrix)this.expMatrix);
        for (i = 0; i < this.n; ++i) {
            for (j = 0; j < this.m; ++j) {
                this.values[i][j] = this.expMatrix.A[i][j];
                this.expMatrix.A[i][j] = (float)temp[i][j];
            }
        }
        this.dataMatrix = new Matrix(this.values);
    }

    public void calculate() {
        int j;
        int i;
        this.PD.setMessage(0, "Distance: " + AbstractAlgorithm.getDistanceName((int)this.function));
        this.PD.setMessage(1, "Clusters to be created: " + this.k);
        this.PD.setMessage(2, "0 clusters created.");
        this.PD.setMessage(3, this.geneAssaigned + " genes have been assigned to clusters.");
        this.PD.setMessage(4, this.n - this.geneAssaigned + " genes left to be assigned to clusters.");
        this.PD.setTimerLabel(5, "Running for ", " seconds.", 1000);
        this.PD.setVisible(true);
        this.getMatrix();
        this.CreatedCluster = 0;
        this.resultClusters = new GSCluster[this.k + 1];
        this.resultClusters[this.k] = new GSCluster();
        for (i = 0; i < this.n; ++i) {
            this.resultClusters[this.k].add(new Integer(i));
        }
        while (this.CreatedCluster < this.k) {
            int i2;
            this.CurrentCluster = 0;
            this.unassigned = new GSCluster();
            for (i = 0; i < this.n; ++i) {
                this.unassigned.add(new Integer(i));
            }
            int iter = this.getIteration();
            this.clusters = new GSCluster[iter];
            for (i2 = 0; i2 < this.clusters.length; ++i2) {
                this.clusters[i2] = new GSCluster();
            }
            for (i2 = 0; i2 < iter; ++i2) {
                this.matrixSize = this.unassigned.size();
                double[] scores = new double[this.matrixSize];
                int[] indexs = new int[this.matrixSize];
                for (int r = 0; r < this.matrixSize; ++r) {
                    indexs[r] = (Integer)this.unassigned.elementAt(r);
                }
                this.workingMatrix = this.dataMatrix.getMatrix(indexs, 0, this.m - 1);
                this.getPrincipleComponent();
                for (int j2 = 0; j2 < this.matrixSize; ++j2) {
                    this.currentGene = this.getGene(j2);
                    scores[j2] = this.getInnerProduct(this.prinCom, this.currentGene);
                }
                this.shaveGene(scores);
                ++this.CurrentCluster;
            }
            int maxIndex = 0;
            double maxGap = 0.0;
            for (int i3 = 0; i3 < this.clusters.length; ++i3) {
                this.workingMatrix = (Matrix)this.dataMatrix.clone();
                double currentGap = this.getDk(this.clusters[i3]) - this.getD_k(this.clusters[i3]);
                if (!(currentGap > maxGap)) continue;
                maxGap = currentGap;
                maxIndex = i3;
            }
            this.resultClusters[this.CreatedCluster] = (GSCluster)this.clusters[maxIndex].clone();
            this.geneAssaigned += this.resultClusters[this.CreatedCluster].size();
            this.PD.setMessage(2, this.CreatedCluster + 1 + " clusters created.");
            if (this.gshGenes) {
                this.PD.setMessage(3, this.geneAssaigned + " genes have been assigned to clusters.");
                this.PD.setMessage(4, this.n - this.geneAssaigned + " genes left to be assigned to clusters.");
            } else {
                this.PD.setMessage(3, this.geneAssaigned + " experiments have been assigned to clusters.");
                this.PD.setMessage(4, this.n - this.geneAssaigned + " experiments left to be assigned to clusters.");
            }
            this.updateMatrix();
            ++this.CreatedCluster;
        }
        for (i = 0; i < this.resultClusters.length - 1; ++i) {
            for (j = 0; j < this.resultClusters[i].size(); ++j) {
                try {
                    this.resultClusters[this.k].removeElement(this.resultClusters[i].elementAt(j));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Exception when removing elements");
                }
            }
        }
        for (i = 0; i < this.resultClusters.length; ++i) {
            for (j = 0; j < this.resultClusters[i].size(); ++j) {
            }
        }
        this.clusters = this.resultClusters;
        this.PD.dismiss();
    }

    public void abort() {
        this.stop = true;
    }

    public void getPrincipleComponent() {
        double[][] EV = new double[1][this.matrixSize];
        this.EVD = this.workingMatrix.times(this.workingMatrix.transpose()).eig();
        Matrix D = this.EVD.getD();
        Matrix U = this.EVD.getV();
        for (int i = 0; i < this.matrixSize; ++i) {
            EV[0][i] = U.get(i, 0);
        }
        this.eigenVector = new Matrix(EV);
        Matrix PC = this.eigenVector.times(this.workingMatrix);
        for (int i = 0; i < this.m; ++i) {
            this.prinCom[i] = PC.get(0, i);
        }
    }

    public int getIteration() {
        int count = 0;
        int totalGenes = this.n;
        while (totalGenes > 1) {
            totalGenes -= Math.max((int)((double)totalGenes * 0.1), 1);
            ++count;
        }
        return count;
    }

    public double getInnerProduct(double[] x, double[] y) {
        int count = 0;
        double add = 0.0;
        if (x.length != y.length) {
            System.out.println("Vector has different number of elements!");
        } else {
            count = x.length;
        }
        for (int i = 0; i < count; ++i) {
            add += x[i] * y[i];
        }
        return add;
    }

    public double[] getGene(int row) {
        double[] aGene = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            aGene[i] = this.workingMatrix.get(row, i);
        }
        return aGene;
    }

    public void shaveGene(double[] scores) {
        int j;
        int cutNo = Math.max((int)((double)this.unassigned.size() * 0.1), 1);
        int[] cutIndex = new int[cutNo];
        Integer spaceHolder = new Integer(-1);
        for (j = 0; j < cutNo; ++j) {
            double minValue = scores[0];
            int minIndex = 0;
            for (int i = 0; i < this.matrixSize; ++i) {
                if (!(minValue > scores[i])) continue;
                minValue = scores[i];
                minIndex = i;
            }
            cutIndex[j] = minIndex;
            scores[minIndex] = Double.MAX_VALUE;
        }
        for (j = 0; j < cutNo; ++j) {
            this.clusters[this.CurrentCluster].add((Integer)this.unassigned.elementAt(cutIndex[j]));
            this.unassigned.setElementAt(spaceHolder, cutIndex[j]);
        }
        for (j = 0; j < cutNo; ++j) {
            this.unassigned.removeElement(spaceHolder);
        }
    }

    public double getDk(GSCluster gs) {
        int i;
        float x_a = 0.0f;
        float v_b = 0.0f;
        double v_w = 0.0;
        FloatMatrix Ave = gs.getAveGene();
        for (i = 0; i < this.m; ++i) {
            x_a += Ave.get(0, i);
        }
        x_a /= (float)this.m;
        for (i = 0; i < this.m; ++i) {
            v_b = (float)((double)v_b + Math.pow(Ave.get(0, i) - x_a, 2.0));
        }
        v_b /= (float)this.m;
        for (i = 0; i < this.m; ++i) {
            for (int j = 0; j < gs.size(); ++j) {
                double value = this.workingMatrix.get(((Integer)gs.get(j)).intValue(), i);
                v_w += Math.pow(value - (double)Ave.get(0, i), 2.0);
            }
        }
        double R2 = (double)v_b / (v_w /= (double)(this.m * gs.size())) / (1.0 + (double)v_b / v_w);
        return R2;
    }

    public double getD_k(GSCluster gs) {
        double R_2 = 0.0;
        for (int iter = 0; iter < this.fakedMatrix; ++iter) {
            this.getPermutedMatrix();
            R_2 += this.getDk(gs);
        }
        return R_2 /= (double)this.fakedMatrix;
    }

    public void getPermutedMatrix() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.swapTime; ++j) {
                Random MyRandom = new Random();
                int gene1 = (int)Math.floor(MyRandom.nextFloat() * (float)this.m);
                gene1 = Math.min(gene1, this.m - 1);
                double temp = this.workingMatrix.get(i, gene1);
                int gene2 = (int)Math.floor(MyRandom.nextFloat() * (float)this.m);
                gene2 = Math.min(gene2, this.m - 1);
                this.workingMatrix.set(i, gene1, this.workingMatrix.get(i, gene2));
                this.workingMatrix.set(i, gene2, temp);
            }
        }
    }

    public void updateMatrix() {
        double[][] AveGene = new double[1][this.m];
        FloatMatrix AG = this.resultClusters[this.CreatedCluster].getAveGene();
        for (int i = 0; i < this.m; ++i) {
            AveGene[0][i] = AG.get(0, i);
        }
        Matrix AveG = new Matrix(AveGene);
        Matrix I = Matrix.identity((int)this.m, (int)this.m);
        Matrix Projector = I.minus(AveG.transpose().times(AveG));
        this.dataMatrix = this.dataMatrix.times(Projector);
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.gshGenes ? this.getSubExperiment(this.expMatrix, features) : this.getSubExperimentReducedCols(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (Integer)source.get(i);
        }
        return int_matrix;
    }

    private FloatMatrix getMeans(GSCluster[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.number_of_samples);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = clusters[i].getMean();
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getVariances(GSCluster[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleNormalizedSum(GSCluster cluster, int column, float mean) {
        int size = cluster.size();
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(((Integer)cluster.get(i)).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float getSampleVariance(GSCluster cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    private class GSCluster
    extends Vector {
        private FloatMatrix AveGene;
        private FloatMatrix mean;

        public GSCluster() {
            this.AveGene = new FloatMatrix(1, GSH.this.m);
            this.mean = new FloatMatrix(1, GSH.this.m);
        }

        public FloatMatrix getAveGene() {
            int n = this.size();
            for (int i = 0; i < GSH.this.m; ++i) {
                double CurrentMean = 0.0;
                for (int j = 0; j < n; ++j) {
                    float Value = (float)GSH.this.workingMatrix.get(((Integer)this.get(j)).intValue(), i);
                    if (Float.isNaN(Value)) continue;
                    CurrentMean += (double)Value;
                }
                this.AveGene.set(0, i, (float)(CurrentMean / (double)n));
            }
            return this.AveGene;
        }

        public Vector fGenes() {
            Vector<Float> floatVector = new Vector<Float>();
            for (int i = 0; i < this.size(); ++i) {
                floatVector.addElement(new Float(((Integer)this.elementAt(i)).intValue()));
            }
            return floatVector;
        }

        public void calculateMean() {
            int n = this.size();
            for (int i = 0; i < GSH.this.number_of_samples; ++i) {
                float currentMean = 0.0f;
                int denom = 0;
                for (int j = 0; j < n; ++j) {
                    float value = GSH.this.expMatrix.get(((Integer)this.get(j)).intValue(), i);
                    if (Float.isNaN(value)) continue;
                    currentMean += value;
                    ++denom;
                }
                this.mean.set(0, i, currentMean / (float)denom);
            }
        }

        public FloatMatrix getMean() {
            this.calculateMean();
            return this.mean;
        }
    }
}

