/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.Rengine;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.LengthBiasPValues;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.EaseAlgorithmData;
import org.tigr.rhook.RHook;
import org.tigr.util.FloatMatrix;

public class GOSEQ
extends AbstractAlgorithm {
    private FloatMatrix expMatrix;
    private boolean stop = false;
    private boolean isGO;
    private static int MSigDBFile = 1;
    private int binSize = 10;
    private int numGenes;
    private int numExps;
    private int numGroups;
    private int iteration;
    private int progress;
    private int binCount;
    private int numPerms;
    private int geneSetOrigin;
    private int[] transcriptLengths;
    private int[] binIndex;
    private int[] diffGeneCluster;
    private int[] groupAssignments;
    private int[][] geneLists;
    private float[] diffGenesCollapsed;
    private float[] transcriptLengthsCollapsed;
    private float[] diffExpressedPerBin;
    private float[] aveLengthPerBin;
    private float[] pwfByBin;
    private float[] expSigPerGeneSet;
    private float[] sigPerGeneSet;
    private float[] genesetPValues;
    private float[] pwf;
    private AlgorithmEvent event;
    private String[] geneSetFilePaths;
    private String[] geneListsNames;
    private String[] geneNames;
    private String[] collapsedGeneNames;
    private String[] categoryNames;
    ArrayList<String> geneNameAL = new ArrayList();

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.numPerms = map.getInt("numPerms");
        this.binSize = map.getInt("numGenesPerBin");
        this.isGO = map.getBoolean("isGO");
        this.expMatrix = data.getMatrix("experiment");
        this.diffGeneCluster = data.getIntArray("diffGeneCluster");
        this.geneSetFilePaths = data.getStringArray("geneSetFilePaths");
        this.geneSetOrigin = map.getInt("geneSetOrigin", 0);
        this.geneNames = data.getStringArray("geneLabels");
        if (this.isGO) {
            this.geneLists = ((EaseAlgorithmData)data).getClusterMatrix();
            this.geneListsNames = new String[((EaseAlgorithmData)data).getResultMatrix().length];
            for (int i = 0; i < this.geneListsNames.length; ++i) {
                this.geneListsNames[i] = ((EaseAlgorithmData)data).getResultMatrix()[i][2];
            }
        }
        this.categoryNames = new String[4];
        this.categoryNames[0] = "Null";
        this.categoryNames[1] = "GO Biological Process";
        this.categoryNames[2] = "GO Cellular Component";
        this.categoryNames[3] = "GO Molecular Function";
        this.transcriptLengths = data.getIntArray("transcriptLengths");
        this.progress = 0;
        this.event = null;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Calculating...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.runAlgorithm();
        if (this.stop) {
            throw new AbortException();
        }
        Cluster result_cluster = new Cluster();
        FloatMatrix returnMatrix = new FloatMatrix(this.genesetPValues.length, 2);
        for (int i = 0; i < this.genesetPValues.length; ++i) {
            returnMatrix.A[i][0] = this.geneLists[i].length;
            returnMatrix.A[i][1] = this.genesetPValues[i];
        }
        FloatMatrix pwfM = new FloatMatrix(1, this.pwf.length);
        pwfM.A[0] = this.pwf;
        FloatMatrix pwfM2 = new FloatMatrix(3, this.aveLengthPerBin.length);
        pwfM2.A[0] = this.aveLengthPerBin;
        pwfM2.A[1] = this.diffExpressedPerBin;
        pwfM2.A[2] = this.pwfByBin;
        FloatMatrix sigPerGS_FM = new FloatMatrix(2, this.expSigPerGeneSet.length);
        sigPerGS_FM.A[0] = this.expSigPerGeneSet;
        sigPerGS_FM.A[1] = this.sigPerGeneSet;
        data.addParam("iterations", String.valueOf(this.iteration - 1));
        data.addCluster("cluster", result_cluster);
        data.addParam("number-of-clusters", "1");
        data.addMatrix("geneGroupMeansMatrix", this.getAllGeneGroupMeans());
        data.addMatrix("geneGroupSDsMatrix", this.getAllGeneGroupSDs());
        data.addMatrix("resultsMatrix", returnMatrix);
        data.addMatrix("pwf", pwfM);
        data.addStringArray("gene-list-names", this.geneListsNames);
        data.addMatrix("pwfM2", pwfM2);
        data.addMatrix("geneSetSigs", sigPerGS_FM);
        data.addStringArray("category-names", this.categoryNames);
        data.addIntMatrix("gene-lists", this.geneLists);
        return data;
    }

    private int[] convertTranscriptLengthToBinIndex(int[] transcriptLengths2) {
        int i;
        float[] sumOfLengthOfGene = new float[this.geneNameAL.size()];
        float[] countOfGene = new float[this.geneNameAL.size()];
        for (i = 0; i < transcriptLengths2.length; ++i) {
            int mapped = this.geneNameAL.indexOf(this.geneNames[i]);
            if (mapped == -1) continue;
            int n = mapped;
            countOfGene[n] = countOfGene[n] + 1.0f;
            sumOfLengthOfGene[mapped] = sumOfLengthOfGene[mapped] + (float)transcriptLengths2[i];
        }
        this.transcriptLengthsCollapsed = new float[this.geneNameAL.size()];
        for (i = 0; i < this.transcriptLengthsCollapsed.length; ++i) {
            this.transcriptLengthsCollapsed[i] = sumOfLengthOfGene[i] / countOfGene[i];
        }
        double[] indices = new double[this.transcriptLengthsCollapsed.length];
        for (int i2 = 0; i2 < indices.length; ++i2) {
            indices[i2] = i2;
        }
        double[] lengths = new double[this.transcriptLengthsCollapsed.length];
        for (int i3 = 0; i3 < lengths.length; ++i3) {
            lengths[i3] = this.transcriptLengthsCollapsed[i3];
        }
        double[] bins = new double[this.transcriptLengthsCollapsed.length];
        for (int i4 = 0; i4 < bins.length; ++i4) {
            bins[i4] = i4 / this.binSize;
        }
        ExperimentUtil.sort2(lengths, indices);
        ExperimentUtil.sort2(indices, bins);
        int[] rtrn = new int[bins.length];
        for (int i5 = 0; i5 < rtrn.length; ++i5) {
            rtrn[i5] = (int)bins[i5];
        }
        return rtrn;
    }

    public static void main(String[] args) {
        GOSEQ gs = new GOSEQ();
        gs.binSize = 2;
        gs.getBinDetails();
        for (int i = 0; i < gs.binCount; ++i) {
            System.out.println(gs.aveLengthPerBin[i]);
            System.out.println(gs.diffExpressedPerBin[i]);
        }
    }

    private void runAlgorithm() {
        this.collapseProbesAndRemoveNaNs();
        if (!this.isGO && !this.populateGeneListMatrix(this.geneSetFilePaths)) {
            this.stop = true;
            return;
        }
        this.diffGenesCollapsed = this.reformatDiffGenes(this.diffGeneCluster);
        this.binIndex = this.convertTranscriptLengthToBinIndex(this.transcriptLengths);
        this.getBinDetails();
        try {
            this.runRAlg();
        }
        catch (AbortException e) {
            e.printStackTrace();
        }
        LengthBiasPValues lbpv = new LengthBiasPValues(this.diffGenesCollapsed, this.pwf, this.geneLists);
        this.genesetPValues = lbpv.getPValuesForGeneSets(this.numPerms);
        this.expSigPerGeneSet = lbpv.getExpectedSigPerGeneSet();
        this.sigPerGeneSet = lbpv.getSigPerGeneSet();
    }

    private boolean populateGeneListMatrix(String[] geneSetFilePaths) {
        int titleIndex = this.geneSetOrigin == MSigDBFile ? 0 : 1;
        ArrayList al = new ArrayList();
        ArrayList<String> namesal = new ArrayList<String>();
        try {
            int i;
            for (int fileIndex = 0; fileIndex < geneSetFilePaths.length; ++fileIndex) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(geneSetFilePaths[fileIndex]));
                while ((line = br.readLine()) != null) {
                    line.trim();
                    String[] genes = line.split("\t");
                    if (genes.length < 3) continue;
                    al.add(new ArrayList());
                    boolean first = true;
                    for (int i2 = 2; i2 < genes.length; ++i2) {
                        if (!this.geneNameAL.contains(genes[i2])) continue;
                        ((ArrayList)al.get(al.size() - 1)).add(this.geneNameAL.indexOf(genes[i2]));
                        first = false;
                    }
                    if (first) {
                        al.remove(al.size() - 1);
                        continue;
                    }
                    namesal.add(genes[titleIndex]);
                }
                br.close();
            }
            this.geneLists = new int[al.size()][];
            this.geneListsNames = new String[namesal.size()];
            for (i = 0; i < al.size(); ++i) {
                this.geneLists[i] = new int[((ArrayList)al.get(i)).size()];
                for (int j = 0; j < ((ArrayList)al.get(i)).size(); ++j) {
                    this.geneLists[i][j] = (Integer)((ArrayList)al.get(i)).get(j);
                }
            }
            for (i = 0; i < namesal.size(); ++i) {
                this.geneListsNames[i] = (String)namesal.get(i);
            }
            return this.geneLists.length != 0 && this.geneListsNames.length != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private float[] reformatDiffGenes(int[] diffGeneCluster) {
        int i;
        int[] diffGenes = new int[this.numGenes];
        for (i = 0; i < diffGenes.length; ++i) {
            diffGenes[i] = 0;
        }
        for (i = 0; i < diffGeneCluster.length; ++i) {
            diffGenes[diffGeneCluster[i]] = 1;
        }
        float[] numProbesPerGeneSymbol = new float[this.geneNameAL.size()];
        float[] numSigProbesPerGeneSymbol = new float[this.geneNameAL.size()];
        for (int i2 = 0; i2 < diffGenes.length; ++i2) {
            int mapped = this.geneNameAL.indexOf(this.geneNames[i2]);
            if (mapped == -1) continue;
            int n = mapped;
            numProbesPerGeneSymbol[n] = numProbesPerGeneSymbol[n] + 1.0f;
            numSigProbesPerGeneSymbol[mapped] = numSigProbesPerGeneSymbol[mapped] + (float)diffGenes[i2];
        }
        float[] diffGenesCollapsed = new float[this.geneNameAL.size()];
        for (int i3 = 0; i3 < diffGenesCollapsed.length; ++i3) {
            diffGenesCollapsed[i3] = numSigProbesPerGeneSymbol[i3] / numProbesPerGeneSymbol[i3];
        }
        return diffGenesCollapsed;
    }

    private void collapseProbesAndRemoveNaNs() {
        int j;
        this.geneNameAL = new ArrayList();
        ArrayList<Integer> indicesMap = new ArrayList<Integer>();
        for (int i = 0; i < this.expMatrix.getRowDimension(); ++i) {
            boolean hasNaNs = false;
            for (j = 0; j < this.expMatrix.getColumnDimension(); ++j) {
                if (!Float.isNaN(this.expMatrix.A[i][j])) continue;
                hasNaNs = true;
                break;
            }
            if (hasNaNs || this.geneNameAL.contains(this.geneNames[i])) continue;
            this.geneNameAL.add(this.geneNames[i]);
            indicesMap.add(i);
        }
        this.collapsedGeneNames = new String[indicesMap.size()];
        float[][] tempCollapsed = new float[indicesMap.size()][this.expMatrix.A[0].length];
        for (int i = 0; i < indicesMap.size(); ++i) {
            this.collapsedGeneNames[i] = this.geneNames[(Integer)indicesMap.get(i)].equals("NA") ? "Unknown" : this.geneNames[(Integer)indicesMap.get(i)];
            for (j = 0; j < this.expMatrix.A[i].length; ++j) {
                tempCollapsed[i][j] = this.expMatrix.A[(Integer)indicesMap.get(i)][j];
            }
        }
    }

    private float[] getGeneGroupMeans(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupMeans = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            geneGroupMeans[i] = this.getMean(geneValuesByGroups[i]);
        }
        return geneGroupMeans;
    }

    private float[] getGeneGroupSDs(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupSDs = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            geneGroupSDs[i] = this.getStdDev(geneValuesByGroups[i]);
        }
        return geneGroupSDs;
    }

    private float[] getGeneValuesForGroup(float[] geneValues, int group) {
        Vector<Float> groupValuesVector = new Vector<Float>();
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != group) continue;
            groupValuesVector.add(new Float(geneValues[i]));
        }
        float[] groupGeneValues = new float[groupValuesVector.size()];
        for (int i = 0; i < groupValuesVector.size(); ++i) {
            groupGeneValues[i] = ((Float)groupValuesVector.get(i)).floatValue();
        }
        return groupGeneValues;
    }

    private FloatMatrix getAllGeneGroupMeans() {
        FloatMatrix means = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < means.getRowDimension(); ++i) {
            means.A[i] = this.getGeneGroupMeans(i);
        }
        return means;
    }

    private FloatMatrix getAllGeneGroupSDs() {
        FloatMatrix sds = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < sds.getRowDimension(); ++i) {
            sds.A[i] = this.getGeneGroupSDs(i);
        }
        return sds;
    }

    private float getMean(float[] group) {
        float sum = 0.0f;
        int n = 0;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sum += group[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float mean = sum / (float)n;
        if (Float.isInfinite(mean)) {
            return Float.NaN;
        }
        return mean;
    }

    private float getStdDev(float[] group) {
        float mean = this.getMean(group);
        int n = 0;
        float sumSquares = 0.0f;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sumSquares = (float)((double)sumSquares + Math.pow(group[i] - mean, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float var = sumSquares / (float)(n - 1);
        if (Float.isInfinite(var)) {
            return Float.NaN;
        }
        return (float)Math.sqrt(var);
    }

    public void runRAlg() throws AbortException {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        try {
            Rengine re = RHook.startRSession();
            if (re == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        try {
            int i;
            if (RHook.getOS() == 3 || RHook.getOS() == 1) {
                RHook.testPackage((String)"goseq");
            } else {
                RHook.installModule((String)"mgcv");
            }
            RHook.log((String)"Starting R Algorithim");
            String rCmd = "library(mgcv)";
            RHook.evalR((String)rCmd);
            String fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "tmpfile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            String rCmdx = "x <- c(";
            String rCmdy = "y <- c(";
            for (int i2 = 0; i2 < this.binCount; ++i2) {
                rCmdx = rCmdx + this.aveLengthPerBin[i2];
                rCmdy = rCmdy + this.diffExpressedPerBin[i2];
                if (i2 >= this.binCount - 1) continue;
                rCmdx = rCmdx + ",";
                rCmdy = rCmdy + ",";
            }
            rCmdx = rCmdx + ")";
            rCmdy = rCmdy + ")";
            RHook.evalR((String)rCmdx);
            RHook.evalR((String)rCmdy);
            RHook.evalR((String)"dat<-data.frame(x=x,y=y)");
            RHook.evalR((String)"f.ug<-gam(y~s(x,bs='cr'))");
            RHook.evalR((String)"sm<-smoothCon(s(x,bs='cr'),dat,knots=NULL)[[1]]");
            RHook.evalR((String)"F<-mono.con(sm$xp)");
            RHook.evalR((String)"G<-list(X=sm$X,C=matrix(0,0,0),sp=f.ug$sp,p=sm$xp,y=y,w=y*0+1)");
            RHook.evalR((String)"G$Ain<-F$A");
            RHook.evalR((String)"G$bin<-F$b");
            RHook.evalR((String)"G$S<-sm$S");
            RHook.evalR((String)"G$off<-0");
            RHook.evalR((String)"p<-pcls(G)");
            RHook.evalR((String)"fv<-Predict.matrix(sm,data.frame(x=x))%*%p");
            REXP e = RHook.evalR((String)"fv");
            double[][] matrix = e.asMatrix();
            this.pwf = new float[this.diffGenesCollapsed.length];
            for (i = 0; i < this.pwf.length; ++i) {
                this.pwf[i] = Math.max(0.0f, (float)matrix[this.binIndex[i]][0]);
            }
            this.pwfByBin = new float[matrix.length];
            for (i = 0; i < matrix.length; ++i) {
                this.pwfByBin[i] = (float)matrix[i][0];
            }
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
                throw new AbortException();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void getBinDetails() {
        this.binCount = (this.diffGenesCollapsed.length - 1) / this.binSize + 1;
        this.diffExpressedPerBin = new float[this.binCount];
        this.aveLengthPerBin = new float[this.binCount];
        for (int i = 0; i < this.binCount; ++i) {
            int numGenesInBin = 0;
            int numSigGenesInBin = 0;
            int totalLengthInBin = 0;
            for (int j = 0; j < this.diffGenesCollapsed.length; ++j) {
                if (this.binIndex[j] != i) continue;
                ++numGenesInBin;
                totalLengthInBin += (int)this.transcriptLengthsCollapsed[j];
                if (this.diffGenesCollapsed[j] != 1.0f) continue;
                ++numSigGenesInBin;
            }
            this.aveLengthPerBin[i] = (float)totalLengthInBin / (float)numGenesInBin;
            this.diffExpressedPerBin[i] = (float)numSigGenesInBin / (float)numGenesInBin;
        }
    }

    public void updateProgressBar() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / (this.progress + 7));
    }
}

