/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.Rengine;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.rhook.RHook;
import org.tigr.util.FloatMatrix;

public class GLOBANC
extends AbstractAlgorithm {
    private FloatMatrix expMatrix;
    private FloatMatrix collapsedExpMatrix;
    float[][] resultMatrix;
    private boolean stop = false;
    private int dataDesign;
    private int numGenes;
    private int numExps;
    private int numGroups;
    private int iteration;
    private int numBGroups;
    private int numPerms;
    private int progress;
    private int geneSetOrigin;
    private int[] groupAssignments;
    private int[] mapping;
    private int[] mapping2;
    private int[][] geneLists;
    private String[] geneNames;
    private String[] sampleNames;
    private String[] geneSetFilePath;
    private String[] collapsedGeneNames;
    private String[] geneListsNames;
    ArrayList<String> geneNameAL;
    private static int MSigDBFile = 1;
    private AlgorithmEvent event;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        AlgorithmParameters map = data.getParams();
        this.expMatrix = data.getMatrix("experiment");
        this.groupAssignments = data.getIntArray("group_assignments");
        this.dataDesign = map.getInt("dataDesign");
        this.numGroups = map.getInt("numGroups");
        this.numBGroups = map.getInt("numBGroups");
        this.numPerms = map.getInt("numPerms");
        this.geneNames = data.getStringArray("geneLabels");
        this.sampleNames = data.getStringArray("sampleLabels");
        this.geneSetFilePath = data.getStringArray("geneSetFilePaths");
        this.geneSetOrigin = map.getInt("geneSetOrigin", 0);
        this.mapping = new int[this.expMatrix.getRowDimension()];
        for (i = 0; i < this.mapping.length; ++i) {
            this.mapping[i] = i;
        }
        this.mapping2 = new int[this.expMatrix.getRowDimension()];
        for (i = 0; i < this.mapping2.length; ++i) {
            this.mapping2[i] = i;
        }
        this.progress = 0;
        this.event = null;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Calculating...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        this.runRAlg();
        if (this.stop) {
            throw new AbortException();
        }
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        AlgorithmData result = new AlgorithmData();
        Cluster result_cluster = new Cluster();
        int[][] sigReturn = new int[this.geneLists.length][];
        for (int i2 = 0; i2 < this.geneLists.length; ++i2) {
            sigReturn[i2] = new int[this.geneLists[i2].length];
            for (int j = 0; j < this.geneLists[i2].length; ++j) {
                sigReturn[i2][j] = this.mapping2[this.mapping[this.geneLists[i2][j]]];
            }
        }
        result.addIntMatrix("geneListsMatrix", (int[][])sigReturn);
        result.addStringArray("gene-list-names", this.geneListsNames);
        result.addParam("iterations", String.valueOf(this.iteration - 1));
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", "1");
        result.addMatrix("result-matrix", new FloatMatrix(this.resultMatrix));
        result.addMatrix("geneGroupMeansMatrix", this.getAllGeneGroupMeans());
        result.addMatrix("geneGroupSDsMatrix", this.getAllGeneGroupSDs());
        return result;
    }

    private float[] getGeneGroupMeans(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupMeans = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            geneGroupMeans[i] = this.getMean(geneValuesByGroups[i]);
        }
        return geneGroupMeans;
    }

    private float[] getGeneGroupSDs(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupSDs = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            geneGroupSDs[i] = this.getStdDev(geneValuesByGroups[i]);
        }
        return geneGroupSDs;
    }

    private float[] getGeneValuesForGroup(float[] geneValues, int group) {
        Vector<Float> groupValuesVector = new Vector<Float>();
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != group) continue;
            groupValuesVector.add(new Float(geneValues[i]));
        }
        float[] groupGeneValues = new float[groupValuesVector.size()];
        for (int i = 0; i < groupValuesVector.size(); ++i) {
            groupGeneValues[i] = ((Float)groupValuesVector.get(i)).floatValue();
        }
        return groupGeneValues;
    }

    private FloatMatrix getAllGeneGroupMeans() {
        FloatMatrix means = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < means.getRowDimension(); ++i) {
            means.A[i] = this.getGeneGroupMeans(i);
        }
        return means;
    }

    private FloatMatrix getAllGeneGroupSDs() {
        FloatMatrix sds = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < sds.getRowDimension(); ++i) {
            sds.A[i] = this.getGeneGroupSDs(i);
        }
        return sds;
    }

    private float getMean(float[] group) {
        float sum = 0.0f;
        int n = 0;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sum += group[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float mean = sum / (float)n;
        if (Float.isInfinite(mean)) {
            return Float.NaN;
        }
        return mean;
    }

    private float getStdDev(float[] group) {
        float mean = this.getMean(group);
        int n = 0;
        float sumSquares = 0.0f;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sumSquares = (float)((double)sumSquares + Math.pow(group[i] - mean, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float var = sumSquares / (float)(n - 1);
        if (Float.isInfinite(var)) {
            return Float.NaN;
        }
        return (float)Math.sqrt(var);
    }

    public void runRAlg() throws AbortException {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        try {
            Rengine re = RHook.startRSession();
            if (re == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        try {
            int i;
            if (RHook.getOS() == 3 || RHook.getOS() == 1) {
                RHook.testPackage((String)"globalanc");
            } else {
                RHook.installModule((String)"GlobalAncova");
            }
            RHook.log((String)("dataDesign = " + this.dataDesign));
            RHook.log((String)"Starting R Algorithim");
            String rCmd = "library(GlobalAncova)";
            RHook.evalR((String)rCmd);
            int numSamples = this.expMatrix.getColumnDimension();
            String fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "tmpfile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            this.collapseProbesAndRemoveNaNs();
            String filePath = this.writeMatrixToFile(fileLoc, this.collapsedExpMatrix, this.collapsedGeneNames);
            RHook.createRDataMatrixFromFile((String)"y", (String)filePath, (boolean)true, (String[])this.sampleNames);
            String phenoData = "phenodata <-data.frame(cbind(Sample=1:" + numSamples + "), cbind(full=c(";
            for (i = 0; i < numSamples; ++i) {
                phenoData = phenoData + ((this.groupAssignments[i] - 1) / this.numBGroups + 1) + ",";
            }
            phenoData = phenoData.substring(0, phenoData.length() - 1);
            phenoData = phenoData + ")), cbind(grade = rep(1," + numSamples + ")),cbind(reduced=c(";
            for (i = 0; i < numSamples; ++i) {
                phenoData = phenoData + ((this.groupAssignments[i] - 1) % this.numBGroups + 1) + ",";
            }
            phenoData = phenoData.substring(0, phenoData.length() - 1);
            phenoData = phenoData + ")))";
            RHook.evalR((String)phenoData);
            String[] geneset = this.getPathwaysCMD_fast();
            if (geneset == null) {
                this.stop = true;
                JOptionPane.showMessageDialog(null, "The gene annotation you have selected does not match the annotation in the gene sets.", "No Matching Annotation", 0);
                throw new AbortException();
            }
            RHook.evalR((String)("source('" + geneset[0] + "')"));
            RHook.evalR((String)("source('" + geneset[1] + "')"));
            REXP e = RHook.evalR((String)"ls()");
            String[] objs = e.asStringArray();
            String runGA = "GA.obj <-GlobalAncova(xx = y, formula.full = ~full + reduced, formula.red = ~reduced, model.dat = phenodata, test.genes=genesvector, method='both', perm = " + this.numPerms + ")";
            RHook.evalR((String)runGA);
            REXP x = RHook.evalR((String)"GA.obj");
            double[][] matrix = x.asMatrix();
            this.resultMatrix = new float[matrix.length][matrix[0].length];
            for (int i2 = 0; i2 < matrix.length; ++i2) {
                for (int j = 0; j < matrix[i2].length; ++j) {
                    this.resultMatrix[i2][j] = (float)matrix[i2][j];
                }
            }
            RHook.endRSession();
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private String[] getPathwaysCMD_fast() {
        int titleIndex = this.geneSetOrigin == MSigDBFile ? 0 : 1;
        String[] cmd = new String[2];
        String genesFile = System.getProperty("user.dir") + System.getProperty("file.separator") + "genesfile.R";
        String namesFile = System.getProperty("user.dir") + System.getProperty("file.separator") + "namesfile.R";
        cmd[0] = genesFile.replace("\\", "/");
        cmd[1] = namesFile.replace("\\", "/");
        try {
            int i;
            PrintWriter genesout = new PrintWriter(new BufferedWriter(new FileWriter(genesFile)));
            PrintWriter namesout = new PrintWriter(new BufferedWriter(new FileWriter(namesFile)));
            String comma = "";
            genesout.write("genesvector <- list(");
            namesout.write("names(genesvector) <- c(");
            ArrayList al = new ArrayList();
            ArrayList<String> namesal = new ArrayList<String>();
            for (int fileIndex = 0; fileIndex < this.geneSetFilePath.length; ++fileIndex) {
                BufferedReader br = new BufferedReader(new FileReader(this.geneSetFilePath[fileIndex]));
                String line = br.readLine();
                while (line != null) {
                    line.trim();
                    String[] genes = line.split("\t");
                    if (genes.length < 3) continue;
                    al.add(new ArrayList());
                    String tmp = comma + "c(";
                    boolean first = true;
                    for (int i2 = 2; i2 < genes.length; ++i2) {
                        if (!this.geneNameAL.contains(genes[i2])) continue;
                        ((ArrayList)al.get(al.size() - 1)).add(this.geneNameAL.indexOf(genes[i2]));
                        if (tmp != null) {
                            genesout.write(tmp);
                            tmp = null;
                        }
                        genesout.write((first ? "" : ",") + "'" + genes[i2] + "'");
                        first = false;
                    }
                    if (first) {
                        al.remove(al.size() - 1);
                        line = br.readLine();
                        continue;
                    }
                    line = br.readLine();
                    if (line == null && fileIndex == this.geneSetFilePath.length - 1) {
                        genesout.write(")");
                        namesout.write(comma + "'" + genes[titleIndex].replace("'", "") + "'");
                    } else {
                        genesout.write(")");
                        namesout.write(comma + "'" + genes[titleIndex].replace("'", "") + "'");
                    }
                    comma = ",";
                    namesal.add(genes[titleIndex]);
                }
                br.close();
            }
            if (al.size() == 0) {
                return null;
            }
            genesout.write(")");
            namesout.write(")");
            this.geneLists = new int[al.size()][];
            this.geneListsNames = new String[namesal.size()];
            for (i = 0; i < al.size(); ++i) {
                this.geneLists[i] = new int[((ArrayList)al.get(i)).size()];
                for (int j = 0; j < ((ArrayList)al.get(i)).size(); ++j) {
                    this.geneLists[i][j] = (Integer)((ArrayList)al.get(i)).get(j);
                }
            }
            for (i = 0; i < namesal.size(); ++i) {
                this.geneListsNames[i] = (String)namesal.get(i);
            }
            genesout.flush();
            genesout.close();
            namesout.flush();
            namesout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmd;
    }

    private String[] getPathwaysCMD() {
        int titleIndex = this.geneSetOrigin == MSigDBFile ? 0 : 1;
        String[] cmd = new String[]{"genesvector <- list(", "names(genesvector) <- c("};
        ArrayList al = new ArrayList();
        ArrayList<String> namesal = new ArrayList<String>();
        try {
            int i;
            for (int fileIndex = 0; fileIndex < this.geneSetFilePath.length; ++fileIndex) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(this.geneSetFilePath[fileIndex]));
                while ((line = br.readLine()) != null) {
                    line.trim();
                    String[] genes = line.split("\t");
                    if (genes.length < 3) continue;
                    al.add(new ArrayList());
                    cmd[0] = cmd[0] + "c(";
                    boolean first = true;
                    for (int i2 = 2; i2 < genes.length; ++i2) {
                        if (!this.geneNameAL.contains(genes[i2])) continue;
                        ((ArrayList)al.get(al.size() - 1)).add(this.geneNameAL.indexOf(genes[i2]));
                        cmd[0] = cmd[0] + (first ? "" : ",") + "'" + genes[i2] + "'";
                        first = false;
                    }
                    if (first) {
                        cmd[0] = cmd[0].substring(0, cmd[0].length() - 2);
                        al.remove(al.size() - 1);
                        continue;
                    }
                    cmd[0] = cmd[0] + "),";
                    cmd[1] = cmd[1] + "'" + genes[titleIndex].replace("'", "") + "',";
                    namesal.add(genes[titleIndex]);
                }
                br.close();
            }
            cmd[0] = cmd[0].substring(0, cmd[0].length() - 1) + ")";
            cmd[1] = cmd[1].substring(0, cmd[1].length() - 1) + ")";
            this.geneLists = new int[al.size()][];
            this.geneListsNames = new String[namesal.size()];
            for (i = 0; i < al.size(); ++i) {
                this.geneLists[i] = new int[((ArrayList)al.get(i)).size()];
                for (int j = 0; j < ((ArrayList)al.get(i)).size(); ++j) {
                    this.geneLists[i][j] = (Integer)((ArrayList)al.get(i)).get(j);
                }
            }
            for (i = 0; i < namesal.size(); ++i) {
                this.geneListsNames[i] = (String)namesal.get(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmd;
    }

    private void collapseProbesAndRemoveNaNs() {
        int j;
        this.geneNameAL = new ArrayList();
        ArrayList<Integer> indicesMap = new ArrayList<Integer>();
        for (int i = 0; i < this.expMatrix.getRowDimension(); ++i) {
            boolean hasNaNs = false;
            for (j = 0; j < this.expMatrix.getColumnDimension(); ++j) {
                if (!Float.isNaN(this.expMatrix.A[i][j])) continue;
                hasNaNs = true;
                break;
            }
            if (hasNaNs || this.geneNameAL.contains(this.geneNames[i])) continue;
            this.geneNameAL.add(this.geneNames[i]);
            indicesMap.add(i);
        }
        this.collapsedGeneNames = new String[indicesMap.size()];
        float[][] tempCollapsed = new float[indicesMap.size()][this.expMatrix.A[0].length];
        for (int i = 0; i < indicesMap.size(); ++i) {
            this.collapsedGeneNames[i] = this.geneNames[(Integer)indicesMap.get(i)].equals("NA") ? "Unknown" : this.geneNames[(Integer)indicesMap.get(i)];
            for (j = 0; j < this.expMatrix.A[i].length; ++j) {
                tempCollapsed[i][j] = this.expMatrix.A[(Integer)indicesMap.get(i)][j];
            }
        }
        this.collapsedExpMatrix = new FloatMatrix(tempCollapsed);
    }

    private String writeMatrixToFile(String fileLoc, FloatMatrix fm, String[] rowNames) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
            int row = fm.getRowDimension();
            int col = fm.getColumnDimension();
            String srtVector = "";
            for (int iRow = 0; iRow < row; ++iRow) {
                srtVector = rowNames[iRow] + "\t";
                for (int jCol = 0; jCol < col; ++jCol) {
                    srtVector = jCol == col - 1 ? srtVector + fm.get(iRow, jCol) + "\n" : srtVector + fm.get(iRow, jCol) + "\t";
                }
                out.write(srtVector);
                srtVector = "";
            }
            out.close();
        }
        catch (IOException e) {
            return null;
        }
        return fileLoc;
    }

    public void updateProgressBar() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / (this.progress + 7));
    }

    private void removeTmps(String fileName) {
        File f = new File(fileName);
        f.delete();
    }
}

