/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import javax.swing.JFrame;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ProgressDialog;

public class GDM
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private FloatMatrix expMatrix;
    private FloatMatrix geneDistanceMatrix;
    private FloatMatrix rawMatrix;
    private int num_samples;
    private int num_genes;
    private boolean pearson = false;
    private long StartTime;
    private long CalculationTime;
    private boolean Stop;
    private int DistanceFunction;
    private ProgressDialog PD;
    private double zeroValue;
    private float maxDist;
    private float minDist;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("distance-absolute", false);
        this.expMatrix = data.getMatrix("experiment");
        if (this.expMatrix == null) {
            throw new AlgorithmException("Input data is absent.");
        }
        this.num_genes = this.expMatrix.getRowDimension();
        this.num_samples = this.expMatrix.getColumnDimension();
        this.geneDistanceMatrix = new FloatMatrix(this.num_genes, this.num_genes);
        this.rawMatrix = new FloatMatrix(this.num_genes, this.num_genes);
        JFrame dummyFrame = new JFrame();
        this.PD = new ProgressDialog(dummyFrame, "Gene Distance Matrix Progression", false, 4);
        this.generateDistanceMatrix();
        AlgorithmData result = new AlgorithmData();
        result.addMatrix("gdMatrix", this.geneDistanceMatrix);
        result.addMatrix("rawMatrix", this.rawMatrix);
        result.addParam("maxDist", String.valueOf(this.maxDist));
        result.addParam("minDist", String.valueOf(this.minDist));
        result.addParam("num_genes", String.valueOf(this.num_genes));
        return result;
    }

    public void abort() {
        this.stop = true;
    }

    synchronized float getRawDistance(int g1, int g2) {
        float result = Float.NaN;
        switch (this.function) {
            case 1: {
                result = ExperimentUtil.genePearson(this.expMatrix, null, g1, g2, this.factor);
                break;
            }
            case 2: {
                result = ExperimentUtil.geneCosine(this.expMatrix, null, g1, g2, this.factor);
                break;
            }
            case 3: {
                result = ExperimentUtil.geneCovariance(this.expMatrix, null, g1, g2, this.factor);
                break;
            }
            case 4: {
                result = ExperimentUtil.geneEuclidianDistance(this.expMatrix, null, g1, g2, this.factor);
                break;
            }
            case 5: {
                result = ExperimentUtil.geneDotProduct(this.expMatrix, null, g1, g2, this.factor);
                break;
            }
            case 6: {
                result = ExperimentUtil.genePearsonUncentered(this.expMatrix, null, g1, g2, this.factor);
                break;
            }
            case 7: {
                result = (float)Math.pow(ExperimentUtil.genePearsonUncentered(this.expMatrix, null, g1, g2, this.factor), 2.0) * this.factor;
                break;
            }
            case 8: {
                result = ExperimentUtil.geneManhattan(this.expMatrix, null, g1, g2, this.factor);
                break;
            }
            case 9: {
                result = ExperimentUtil.geneSpearmanRank(this.expMatrix, null, g1, g2, this.factor);
                break;
            }
            case 10: {
                result = ExperimentUtil.geneKendallsTau(this.expMatrix, null, g1, g2, this.factor);
                break;
            }
            case 11: {
                result = ExperimentUtil.geneMutualInformation(this.expMatrix, null, g1, g2, this.factor);
                break;
            }
        }
        if (this.absolute) {
            result = Math.abs(result);
        }
        return result;
    }

    synchronized float getScaledDistance(int g1, int g2, float max, float min) {
        float val = Float.NaN;
        float rawval = this.rawMatrix.get(g1, g2);
        if (Float.isNaN(rawval)) {
            return rawval;
        }
        switch (this.function) {
            case 4: 
            case 8: {
                val = rawval / max;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                if (!this.absolute) {
                    val = (1.0f - rawval) / 2.0f;
                    break;
                }
                val = 1.0f - Math.abs(rawval);
                break;
            }
            case 7: {
                float pearson = !this.absolute ? (1.0f - rawval) / 2.0f : 1.0f - Math.abs(rawval);
                val = 1.0f - pearson * pearson;
                break;
            }
            case 3: 
            case 5: {
                float tmp;
                if (!this.absolute) {
                    tmp = (max - rawval) / (max - min);
                } else {
                    max = Math.abs(min) > Math.abs(max) ? Math.abs(min) : Math.abs(max);
                    tmp = Math.abs(rawval) / max;
                }
                val = 1.0f - tmp;
                break;
            }
        }
        return val;
    }

    synchronized void generateDistanceMatrix() throws AbortException {
        int j;
        int i;
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, 100, "Construct Distance Matrix");
        this.fireValueChanged(event);
        event.setId(2);
        int progress = 0;
        int sum = this.num_genes * this.num_genes;
        int step = sum / 100 + 1;
        int nan = 0;
        this.maxDist = this.minDist = (float)0;
        float minraw = this.minDist;
        float maxraw = this.minDist;
        for (i = 0; i < this.num_genes; ++i) {
            ++progress;
            for (j = i + 1; j < this.num_genes; ++j) {
                if (this.stop) {
                    throw new AbortException();
                }
                float rawdist = this.getRawDistance(i, j);
                if (Float.isNaN(rawdist)) continue;
                maxraw = Math.max(maxraw, rawdist);
                minraw = Math.min(minraw, rawdist);
                if (rawdist == 0.0f && i != j) {
                    int k;
                    int cols = this.expMatrix.getColumnDimension();
                    for (k = 0; k < cols && (Float.isNaN(this.expMatrix.get(i, k)) || Float.isNaN(this.expMatrix.get(j, k))); ++k) {
                    }
                    if (k == cols) {
                        rawdist = Float.NaN;
                        ++nan;
                    }
                }
                this.rawMatrix.set(i, j, rawdist);
                this.rawMatrix.set(j, i, rawdist);
                if (++progress % step != 0) continue;
                event.setIntValue(progress / step);
                event.setDescription("Construct Distance Matrix");
                this.fireValueChanged(event);
            }
        }
        for (i = 0; i < this.num_genes; ++i) {
            ++progress;
            for (j = i + 1; j < this.num_genes; ++j) {
                if (this.stop) {
                    throw new AbortException();
                }
                float dist = this.getScaledDistance(i, j, maxraw, minraw);
                this.maxDist = Math.max(this.maxDist, dist);
                this.minDist = Math.min(this.minDist, dist);
                this.geneDistanceMatrix.set(i, j, dist);
                this.geneDistanceMatrix.set(j, i, dist);
                if (++progress % step != 0) continue;
                event.setIntValue(progress / step);
                event.setDescription("Construct Distance Matrix");
                this.fireValueChanged(event);
            }
        }
        this.minDist = 0.0f;
        this.maxDist = 1.0f;
    }
}

