/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.CastClust;
import org.tigr.microarray.mev.cluster.algorithm.impl.KMC;
import org.tigr.util.FloatMatrix;

public class FOM
extends AbstractAlgorithm {
    private boolean stop = false;
    private boolean clusterGenes;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmEvent event;
        AlgorithmParameters map = data.getParams();
        int function = map.getInt("distance-function", 4);
        float factor = map.getFloat("distance-factor", 1.0f);
        boolean absolute = map.getBoolean("distance-absolute", false);
        this.clusterGenes = map.getBoolean("cluster-genes", true);
        int fomIterations = map.getInt("fom-iterations", 1);
        int method = map.getInt("method", 2);
        float interval = map.getFloat("interval", 0.1f);
        int iterations = map.getInt("iterations", 50);
        int maxNumClusters = map.getInt("number-of-clusters", 20);
        boolean average = map.getBoolean("average", true);
        boolean calculateMeans = map.getBoolean("calculate-means", true);
        FloatMatrix expMatrix = data.getMatrix("experiment");
        int number_of_genes = expMatrix.getRowDimension();
        int number_of_samples = expMatrix.getColumnDimension();
        AbstractAlgorithm sub_algo = null;
        sub_algo = method == 2 ? new KMC() : new CastClust(true);
        AlgorithmData sub_algo_data = new AlgorithmData();
        sub_algo_data.addMatrix("experiment", expMatrix);
        sub_algo_data.addParam("distance-factor", String.valueOf(factor));
        sub_algo_data.addParam("distance-absolute", String.valueOf(absolute));
        sub_algo_data.addParam("distance-function", String.valueOf(function));
        sub_algo_data.addParam("number-of-iterations", String.valueOf(iterations));
        sub_algo_data.addParam("calculate-means", String.valueOf(calculateMeans));
        AlgorithmData sub_algo_result = null;
        Cluster sub_algo_clusters = new Cluster();
        float[] fom_values = null;
        FloatMatrix fomResults = null;
        int times = 0;
        int[] numOfCastClusters = new int[1];
        if (method == 2) {
            event = new AlgorithmEvent((Object)this, 1, maxNumClusters);
            this.fireValueChanged(event);
            event.setId(2);
            sub_algo_data.addParam("kmc-cluster-genes", String.valueOf(this.clusterGenes));
            fom_values = new float[maxNumClusters];
            fomResults = new FloatMatrix(fomIterations, maxNumClusters);
            for (int fomi = 0; fomi < fomIterations; ++fomi) {
                event.setDescription("Calculating FOMs for FOM iteration " + String.valueOf(fomi + 1) + " of " + String.valueOf(fomIterations) + " iterations.");
                this.fireValueChanged(event);
                for (int i = 0; i < maxNumClusters; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    event.setIntValue(i);
                    this.fireValueChanged(event);
                    sub_algo_data.addParam("number-of-clusters", String.valueOf(i + 1));
                    sub_algo_result = sub_algo.execute(sub_algo_data);
                    sub_algo_clusters = sub_algo_result.getCluster("cluster");
                    fomResults.set(fomi, i, (float)this.getFOM(expMatrix, sub_algo_clusters, number_of_genes, number_of_samples));
                }
            }
        } else {
            times = (int)(1.0f / interval);
            event = new AlgorithmEvent((Object)this, 1, times);
            this.fireValueChanged(event);
            event.setId(2);
            sub_algo_data.addParam("cast-cluster-genes", String.valueOf(this.clusterGenes));
            numOfCastClusters = new int[times];
            float threshold = 0.0f;
            fom_values = new float[times];
            for (int i = 0; i < times; ++i) {
                if ((threshold += interval) > 1.0f) {
                    threshold = 1.0f;
                }
                if (this.stop) {
                    throw new AbortException();
                }
                event.setIntValue(i);
                event.setDescription("calculating for threshold of " + String.valueOf(threshold));
                this.fireValueChanged(event);
                sub_algo_data.addParam("threshold", String.valueOf(threshold));
                sub_algo_result = sub_algo.execute(sub_algo_data);
                sub_algo_clusters = sub_algo_result.getCluster("cluster");
                fom_values[i] = (float)this.getFOM(expMatrix, sub_algo_clusters, number_of_genes, number_of_samples);
                numOfCastClusters[i] = sub_algo_clusters.getNodeList().getSize();
            }
        }
        AlgorithmData result = new AlgorithmData();
        if (method == 2) {
            result.addMatrix("fom-matrix", fomResults);
        } else {
            result.addMatrix("fom-values", new FloatMatrix(fom_values, 1));
        }
        result.addIntArray("numOfCastClusters", numOfCastClusters);
        return result;
    }

    public double getFOM(FloatMatrix expMatrix, Cluster clusters, int number_of_genes, int number_of_samples) {
        float value;
        int[] cluster;
        int n = 0;
        NodeList nodeList = clusters.getNodeList();
        int number_of_clusters = nodeList.getSize();
        double[][] means = new double[number_of_samples][number_of_clusters];
        for (int i = 0; i < number_of_samples; ++i) {
            for (int j = 0; j < number_of_clusters; ++j) {
                means[i][j] = 0.0;
                cluster = nodeList.getNode(j).getFeaturesIndexes();
                n = 0;
                for (int p = 0; p < cluster.length; ++p) {
                    value = expMatrix.get(cluster[p], i);
                    if (Float.isNaN(value)) continue;
                    double[] dArray = means[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + (double)value;
                    ++n;
                }
                if (n > 0) {
                    double[] dArray = means[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] / (double)n;
                    continue;
                }
                means[i][j] = 0.0;
            }
        }
        double[] tFOM = new double[number_of_samples];
        double factor = 1.0;
        for (int i = 0; i < number_of_samples; ++i) {
            tFOM[i] = 0.0;
            for (int j = 0; j < number_of_clusters; ++j) {
                cluster = nodeList.getNode(j).getFeaturesIndexes();
                for (int p = 0; p < cluster.length; ++p) {
                    value = expMatrix.get(cluster[p], i);
                    if (Float.isNaN(value)) continue;
                    int n4 = i;
                    tFOM[n4] = tFOM[n4] + Math.pow((double)value - means[i][j], 2.0);
                }
            }
            tFOM[i] = Math.sqrt(tFOM[i] / (double)number_of_genes);
        }
        double fom_value = 0.0;
        for (int i = 0; i < number_of_samples; ++i) {
            fom_value += tFOM[i];
        }
        return fom_value;
    }

    public void abort() {
        this.stop = true;
    }
}

