/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.rosuda.JRI.REXP;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.rhook.RHook;
import org.tigr.util.FloatMatrix;

public class EDGER
extends AbstractAlgorithm {
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    private int progress;
    private int[][] countMatrix;
    private boolean stop = false;
    private int[] groupAssignments;
    private int[] librarySize;
    private int[] transcriptLen;
    private int numGenes;
    private int numExps;
    private boolean debug = false;
    private int testDesign;
    private String[] geneNames;
    private String[] sampleNames;
    private String methodName = null;
    String[] rownames;
    float[][] resultMatrix;
    private AlgorithmEvent event;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.geneNames = data.getStringArray("geneLabels");
        this.sampleNames = data.getStringArray("sampleLabels");
        this.librarySize = data.getIntArray("libSize");
        this.transcriptLen = data.getIntArray("transcriptLen");
        this.groupAssignments = data.getIntArray("group_assignments");
        this.methodName = map.getString("methodName");
        this.testDesign = map.getInt("dataDesign");
        this.countMatrix = data.getIntMatrix("experiment");
        this.numGenes = map.getInt("numGenes");
        this.numExps = map.getInt("numExps");
        this.progress = 0;
        this.event = null;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Running edgeR...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        this.runRAlg();
        AlgorithmData result = new AlgorithmData();
        result.addStringArray("rownames", this.rownames);
        System.out.println("resultMatrix: " + this.resultMatrix[0].length);
        result.addMatrix("result", new FloatMatrix(this.resultMatrix));
        this.updateProgressBar();
        return result;
    }

    public void runRAlg() throws AbortException {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        try {
            if (RHook.startRSession() == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        this.updateProgressBar();
        try {
            if (RHook.getOS() == 3 || RHook.getOS() == 1) {
                RHook.testPackage((String)"edger");
            } else {
                RHook.installModule((String)"edgeR");
            }
            RHook.log((String)"Starting R Algorithim");
            String rCmd = "library(edgeR)";
            RHook.evalR((String)rCmd);
            this.updateProgressBar();
            String fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "tmpfile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            String filePath = this.writeMatrixToFile(fileLoc, this.countMatrix, this.geneNames, this.transcriptLen);
            rCmd = "raw.data <- read.delim('" + filePath + "', header=TRUE)";
            RHook.evalR((String)rCmd);
            this.updateProgressBar();
            int grp1 = 0;
            int grp2 = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    ++grp1;
                }
                if (this.groupAssignments[i] != 2) continue;
                ++grp2;
            }
            int cols = this.numExps + 1;
            rCmd = "d <- raw.data[, 2:" + cols + "]";
            RHook.evalR((String)rCmd);
            rCmd = "rownames(d) <- raw.data[, 1]";
            RHook.evalR((String)rCmd);
            rCmd = "group <- c(rep(1," + grp1 + "), rep(2," + grp2 + "))";
            RHook.evalR((String)rCmd);
            rCmd = "d <- DGEList(counts = d, group = group)";
            RHook.evalR((String)rCmd);
            rCmd = "names(d)";
            RHook.evalR((String)rCmd);
            rCmd = "d <- estimateCommonDisp(d)";
            RHook.evalR((String)rCmd);
            if (this.methodName.equalsIgnoreCase("Common dispersion")) {
                rCmd = "de <- exactTest(d)";
                RHook.evalR((String)rCmd);
            } else {
                rCmd = "d <- estimateTagwiseDisp(d, prior.n = 10, grid.length = 500)";
                RHook.evalR((String)rCmd);
                rCmd = "de <- exactTest(d, common.disp = FALSE)";
                RHook.evalR((String)rCmd);
            }
            rCmd = "res <- topTags(de, n=" + this.numGenes + ")$table";
            REXP res = RHook.evalR((String)rCmd);
            this.updateProgressBar();
            res = RHook.evalR((String)"rownames(res)");
            this.rownames = res.asStringArray();
            this.resultMatrix = new float[4][this.rownames.length];
            res = RHook.evalR((String)"res$logConc");
            double[] _tmp = res.asDoubleArray();
            System.out.println("res$logConc length " + _tmp.length);
            this.resultMatrix[0] = this.doubletoFloat(_tmp);
            res = RHook.evalR((String)"res$logFC");
            _tmp = res.asDoubleArray();
            this.resultMatrix[1] = this.doubletoFloat(_tmp);
            res = RHook.evalR((String)"res$PValue");
            _tmp = res.asDoubleArray();
            this.resultMatrix[2] = this.doubletoFloat(_tmp);
            res = RHook.evalR((String)"res$FDR");
            _tmp = res.asDoubleArray();
            this.resultMatrix[3] = this.doubletoFloat(_tmp);
            this.updateProgressBar();
            RHook.endRSession();
            this.removeTmps(filePath);
            this.updateProgressBar();
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
                e.printStackTrace();
                throw new AlgorithmException(e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private float[] doubletoFloat(double[] _tmp) {
        float[] tmp = new float[_tmp.length];
        for (int i = 0; i < _tmp.length; ++i) {
            tmp[i] = (float)_tmp[i];
        }
        return tmp;
    }

    private void updateProgressBar() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / 5);
        this.fireValueChanged(this.event);
    }

    private String writeMatrixToFile(String fileLoc, int[][] fm, String[] rowNames, int[] transLen) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
        int row = this.numGenes;
        int col = this.numExps;
        String srtVector = "";
        if (this.debug) {
            System.out.println("row, col, rowName " + row);
            System.out.println("row, col, rowName " + col);
            System.out.println("row, col, rowName " + rowNames[1]);
        }
        srtVector = "Index\t";
        for (int iSam = 0; iSam < this.sampleNames.length; ++iSam) {
            srtVector = iSam == col - 1 ? srtVector + this.sampleNames[iSam] + "\n" : srtVector + this.sampleNames[iSam] + "\t";
        }
        out.write(srtVector);
        srtVector = "";
        for (int iRow = 0; iRow < row; ++iRow) {
            srtVector = rowNames[iRow] + "\t";
            for (int jCol = 0; jCol < col; ++jCol) {
                srtVector = jCol == col - 1 ? srtVector + fm[iRow][jCol] + "\n" : srtVector + fm[iRow][jCol] + "\t";
            }
            out.write(srtVector);
            srtVector = "";
        }
        out.close();
        return fileLoc;
    }

    private void removeTmps(String fileName) {
        File f = new File(fileName);
        f.delete();
    }

    public void runR_AttractAlg() throws AbortException {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        try {
            if (RHook.startRSession() == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        try {
            String libPath = System.getenv("R_HOME");
            libPath = libPath.replace("\\", "/");
            libPath = libPath + "/library";
            String rCmd = ".libPaths('" + libPath + "')";
            System.out.println("libPath cmd " + rCmd);
            RHook.evalR((String)rCmd);
            rCmd = ".libPaths()";
            REXP rx = RHook.evalR((String)rCmd);
            System.out.println("Curr libPath " + rx.asStringArray()[0]);
            RHook.testPackage((String)"attract");
            String srcLoc = "C:/Projects/ATTRACT/Mev-Attract_Code/";
            rCmd = "loc='" + srcLoc + "'";
            RHook.evalR((String)rCmd);
            String scriptR = srcLoc + "MeV-RCode.R";
            rCmd = "source('" + scriptR + "')";
            RHook.evalR((String)rCmd);
            rCmd = "length(remove_these_genes)";
            rx = RHook.evalR((String)rCmd);
            int len = rx.asInt();
            RHook.endRSession();
            System.out.println("Length of vector remove.these.genes " + len);
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        int[] array = new int[]{0, 1};
        for (int i = 0; i < array.length; ++i) {
            System.out.print(array[i] + "\t");
        }
        System.out.println(":" + array.length);
    }
}

