/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.rosuda.JRI.REXP;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.rhook.RHook;
import org.tigr.util.FloatMatrix;

public class DESEQ
extends AbstractAlgorithm {
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    private int progress;
    private int[][] countMatrix;
    private boolean stop = false;
    private int[] groupAssignments;
    private int[] librarySize;
    boolean calcLibSize = true;
    private int numGenes;
    private int numExps;
    private boolean debug = false;
    private int testDesign;
    private String[] geneNames;
    private String[] sampleNames;
    private String methodName = null;
    String[] rownames;
    float[][] resultMatrix;
    private AlgorithmEvent event;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.geneNames = data.getStringArray("geneLabels");
        this.sampleNames = data.getStringArray("sampleLabels");
        this.librarySize = data.getIntArray("libSize");
        this.groupAssignments = data.getIntArray("group_assignments");
        this.methodName = map.getString("methodName");
        this.testDesign = map.getInt("dataDesign");
        this.countMatrix = data.getIntMatrix("experiment");
        this.numGenes = map.getInt("numGenes");
        this.numExps = map.getInt("numExps");
        this.progress = 0;
        this.event = null;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Running DESeq...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        this.runRAlg();
        AlgorithmData result = new AlgorithmData();
        result.addStringArray("rownames", this.rownames);
        System.out.println("resultMatrix: " + this.resultMatrix[0].length);
        result.addMatrix("result", new FloatMatrix(this.resultMatrix));
        this.updateProgressBar();
        return result;
    }

    public void runRAlg() throws AbortException {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        try {
            if (RHook.startRSession() == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        this.updateProgressBar();
        try {
            int i;
            if (RHook.getOS() == 3 || RHook.getOS() == 1) {
                RHook.testPackage((String)"deseq");
            } else {
                RHook.installModule((String)"DESeq");
            }
            RHook.log((String)"Starting R Algorithim");
            String rCmd = "library(DESeq)";
            RHook.evalR((String)rCmd);
            String fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "tmpfile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            String filePath = this.writeMatrixToFile(fileLoc, this.countMatrix, this.geneNames, this.sampleNames);
            rCmd = "countsTable <- read.delim('" + filePath + "', header=TRUE, stringsAsFactors=TRUE)";
            RHook.evalR((String)rCmd);
            this.updateProgressBar();
            int grp1 = 0;
            int grp2 = 0;
            for (i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    ++grp1;
                }
                if (this.groupAssignments[i] != 2) continue;
                ++grp2;
            }
            rCmd = "rownames( countsTable ) <- countsTable$gene";
            RHook.evalR((String)rCmd);
            rCmd = "countsTable <- countsTable[ , -1 ]";
            RHook.evalR((String)rCmd);
            rCmd = "conds <- c(rep(1," + grp1 + "), rep(2," + grp2 + "))";
            RHook.evalR((String)rCmd);
            rCmd = "cds <- newCountDataSet( countsTable, conds )";
            RHook.evalR((String)rCmd);
            if (this.calcLibSize) {
                rCmd = "libsizes <- c(";
                for (i = 0; i < this.sampleNames.length - 1; ++i) {
                    rCmd = rCmd + this.sampleNames[i] + "=" + this.librarySize[i] + ",";
                }
                rCmd = rCmd + this.sampleNames[this.sampleNames.length - 1] + "=" + this.librarySize[this.sampleNames.length - 1] + ")";
                RHook.evalR((String)rCmd);
                rCmd = "sizeFactors(cds) <- libsizes";
                RHook.evalR((String)rCmd);
            } else {
                rCmd = "cds <- estimateSizeFactors( cds )";
                RHook.evalR((String)rCmd);
            }
            rCmd = "cds <- estimateVarianceFunctions( cds )";
            RHook.evalR((String)rCmd);
            this.updateProgressBar();
            rCmd = "res <- nbinomTest( cds, 1, 2 )";
            RHook.evalR((String)rCmd);
            this.updateProgressBar();
            REXP res = RHook.evalR((String)"res$id");
            this.rownames = res.asStringArray();
            this.resultMatrix = new float[7][this.rownames.length];
            res = RHook.evalR((String)"res$foldChange");
            double[] _tmp = res.asDoubleArray();
            this.resultMatrix[0] = this.doubletoFloat(_tmp);
            res = RHook.evalR((String)"res$log2FoldChange");
            _tmp = res.asDoubleArray();
            this.resultMatrix[1] = this.doubletoFloat(_tmp);
            res = RHook.evalR((String)"res$pval");
            _tmp = res.asDoubleArray();
            this.resultMatrix[2] = this.doubletoFloat(_tmp);
            res = RHook.evalR((String)"res$padj");
            _tmp = res.asDoubleArray();
            this.resultMatrix[3] = this.doubletoFloat(_tmp);
            res = RHook.evalR((String)"res$baseMean");
            _tmp = res.asDoubleArray();
            this.resultMatrix[4] = this.doubletoFloat(_tmp);
            res = RHook.evalR((String)"res$baseMeanA");
            _tmp = res.asDoubleArray();
            this.resultMatrix[5] = this.doubletoFloat(_tmp);
            res = RHook.evalR((String)"res$baseMeanB");
            _tmp = res.asDoubleArray();
            this.resultMatrix[6] = this.doubletoFloat(_tmp);
            this.updateProgressBar();
            RHook.endRSession();
            this.removeTmps(filePath);
            this.updateProgressBar();
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
                throw new AbortException();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private float[] doubletoFloat(double[] _tmp) {
        float[] tmp = new float[_tmp.length];
        for (int i = 0; i < _tmp.length; ++i) {
            tmp[i] = (float)_tmp[i];
        }
        return tmp;
    }

    private void updateProgressBar() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / 5);
        this.fireValueChanged(this.event);
    }

    private String writeMatrixToFile(String fileLoc, int[][] fm, String[] rowNames, String[] samples) throws IOException {
        int iRow;
        BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
        int row = this.numGenes;
        int col = this.numExps;
        String srtVector = "gene\t";
        if (this.debug) {
            System.out.println("row, col, rowName " + row);
            System.out.println("row, col, rowName " + col);
            System.out.println("row, col, rowName " + rowNames[1]);
        }
        for (iRow = 0; iRow < samples.length - 1; ++iRow) {
            srtVector = srtVector + samples[iRow] + "\t";
        }
        out.write(srtVector + samples[samples.length - 1] + "\n");
        srtVector = "";
        for (iRow = 0; iRow < row; ++iRow) {
            srtVector = rowNames[iRow] + "\t";
            for (int jCol = 0; jCol < col; ++jCol) {
                srtVector = jCol == col - 1 ? srtVector + fm[iRow][jCol] + "\n" : srtVector + fm[iRow][jCol] + "\t";
            }
            out.write(srtVector);
            srtVector = "";
        }
        out.close();
        return fileLoc;
    }

    private void removeTmps(String fileName) {
        File f = new File(fileName);
        f.delete();
    }

    public static void main(String[] args) {
        int[] array = new int[]{0, 1};
        for (int i = 0; i < array.length; ++i) {
            System.out.print(array[i] + "\t");
        }
        System.out.println(":" + array.length);
    }
}

