/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.rhook.RHook;
import org.tigr.util.FloatMatrix;

public class DEGSEQ
extends AbstractAlgorithm {
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    private int progress;
    private int[][] countMatrix;
    private boolean stop = false;
    private int[] groupAssignments;
    private String grp1ColIndStr;
    private String grp2ColIndStr;
    private int grp1;
    private int grp2;
    private int[] librarySize;
    boolean calcLibSize = true;
    private int numGenes;
    private int numExps;
    private boolean debug = false;
    private int testDesign;
    private String[] geneNames;
    private String[] sampleNames;
    private String methodName = null;
    String[] rownames;
    float[][] resultMatrix;
    private AlgorithmEvent event;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.geneNames = data.getStringArray("geneLabels");
        this.sampleNames = data.getStringArray("sampleLabels");
        this.librarySize = data.getIntArray("libSize");
        this.groupAssignments = data.getIntArray("group_assignments");
        this.grp1ColIndStr = map.getString("grp1ColIndStr");
        this.grp2ColIndStr = map.getString("grp2ColIndStr");
        this.grp1 = map.getInt("grp1") + 1;
        this.grp2 = map.getInt("grp2") + 1;
        this.methodName = map.getString("infMethod");
        this.testDesign = map.getInt("dataDesign");
        this.countMatrix = data.getIntMatrix("experiment");
        this.numGenes = map.getInt("numGenes");
        this.numExps = map.getInt("numExps");
        this.progress = 0;
        this.event = null;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Running DESeq...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        this.runRAlg();
        AlgorithmData result = new AlgorithmData();
        result.addStringArray("rownames", this.rownames);
        System.out.println("resultMatrix: " + this.resultMatrix[0].length);
        result.addMatrix("result", new FloatMatrix(this.resultMatrix));
        this.updateProgressBar();
        return result;
    }

    public void runRAlg() throws AbortException {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        try {
            if (RHook.startRSession() == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        this.updateProgressBar();
        try {
            if (RHook.getOS() == 3 || RHook.getOS() == 1) {
                RHook.testPackage((String)"degseq");
            } else {
                RHook.installModule((String)"DEGseq");
            }
            RHook.log((String)"Starting R Algorithim");
            String rCmd = "library(DEGseq)";
            RHook.evalR((String)rCmd);
            String geneExpFile = System.getProperty("user.dir") + System.getProperty("file.separator") + "geneExpFile.txt";
            geneExpFile = geneExpFile.replace("\\", "/");
            String filePath = this.writeMatrixToFile(geneExpFile, this.countMatrix, this.geneNames, this.sampleNames);
            String outDir = System.getProperty("user.dir");
            outDir = outDir.replace("\\", "/");
            rCmd = "geneExpMatrix1 <- readGeneExp(file='" + geneExpFile + "', geneCol=1, " + "valCol=c(" + this.grp1ColIndStr + "))";
            RHook.evalR((String)rCmd);
            rCmd = "geneExpMatrix2 <- readGeneExp(file='" + geneExpFile + "', geneCol=1, " + "valCol=c(" + this.grp2ColIndStr + "))";
            RHook.evalR((String)rCmd);
            this.updateProgressBar();
            rCmd = this.methodName.equals("LRT") || this.methodName.equals("FET") || this.methodName.equals("MARS") ? "DEGexp(geneExpMatrix1=geneExpMatrix1, geneCol1=1, expCol1=c(seq(from=2,to=" + this.grp1 + ")), " + "groupLabel1='Grp1'," + "geneExpMatrix2=geneExpMatrix2, " + "geneCol2=1, " + "expCol2=c(seq(from=2,to=" + this.grp2 + ")), " + "groupLabel2='Grp2'," + "method='" + this.methodName + "', " + "outputDir='" + outDir + "')" : "DEGexp(geneExpMatrix1=geneExpMatrix1, geneCol1=1, expCol1=c(2), groupLabel1='Grp1',geneExpMatrix2=geneExpMatrix2, geneCol2=1, expCol2=c(2), groupLabel2='Grp2',method='" + this.methodName + "', " + "replicateExpMatrix1=geneExpMatrix1, " + "geneColR1=1, " + "expColR1=c(seq(from=3,to=" + this.grp1 + ")), " + "replicateExpMatrix2=geneExpMatrix2, " + "geneColR2=1, " + "expColR2=c(seq(from=3,to=" + this.grp2 + ")), " + "outputDir='" + outDir + "')";
            RHook.evalR((String)rCmd);
            this.updateProgressBar();
            String resFile = this.processResults(outDir);
            this.updateProgressBar();
            RHook.endRSession();
            this.removeTmps(filePath);
            this.removeTmps(resFile);
            this.updateProgressBar();
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
                throw new AbortException();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private float[] doubletoFloat(double[] _tmp) {
        float[] tmp = new float[_tmp.length];
        for (int i = 0; i < _tmp.length; ++i) {
            tmp[i] = (float)_tmp[i];
        }
        return tmp;
    }

    private void updateProgressBar() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / 5);
        this.fireValueChanged(this.event);
    }

    private String writeMatrixToFile(String fileLoc, int[][] fm, String[] rowNames, String[] samples) throws IOException {
        int iRow;
        BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
        int row = this.numGenes;
        int col = this.numExps;
        String srtVector = "gene\t";
        if (this.debug) {
            System.out.println("row, col, rowName " + row);
            System.out.println("row, col, rowName " + col);
            System.out.println("row, col, rowName " + rowNames[1]);
        }
        for (iRow = 0; iRow < samples.length - 1; ++iRow) {
            srtVector = srtVector + samples[iRow] + "\t";
        }
        out.write(srtVector + samples[samples.length - 1] + "\n");
        srtVector = "";
        for (iRow = 0; iRow < row; ++iRow) {
            srtVector = rowNames[iRow] + "\t";
            for (int jCol = 0; jCol < col; ++jCol) {
                srtVector = jCol == col - 1 ? srtVector + fm[iRow][jCol] + "\n" : srtVector + fm[iRow][jCol] + "\t";
            }
            out.write(srtVector);
            srtVector = "";
        }
        out.close();
        return fileLoc;
    }

    private String processResults(String outDir) throws IOException {
        String currentLine;
        String outFile = outDir + "/output_score.txt";
        this.rownames = new String[this.countMatrix.length];
        this.resultMatrix = new float[this.rownames.length][6];
        int col = 0;
        int counter = 0;
        BufferedReader reader = new BufferedReader(new FileReader(outFile));
        StringSplitter ss = new StringSplitter('\t');
        reader.readLine();
        while ((currentLine = reader.readLine()) != null) {
            ss.init(currentLine);
            col = 0;
            for (int token = 0; token < ss.countTokens(); ++token) {
                if (token == 0) {
                    this.rownames[counter] = ss.nextToken();
                    continue;
                }
                if (token == 1 || token == 2 || token == 9) {
                    ss.nextToken();
                    continue;
                }
                this.resultMatrix[counter][col++] = ss.nextFloatToken(Float.NaN);
            }
            ++counter;
        }
        reader.close();
        return outFile;
    }

    private void removeTmps(String fileName) {
        File f;
        if (fileName != null && (f = new File(fileName)).exists()) {
            f.delete();
        }
    }

    public static void main(String[] args) {
        int[] array = new int[]{0, 1};
        for (int i = 0; i < array.length; ++i) {
            System.out.print(array[i] + "\t");
        }
        System.out.println(":" + array.length);
    }
}

