/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.TDistribution;
import Jama.Matrix;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.util.FloatMatrix;

public class DAM
extends AbstractAlgorithm {
    private boolean stop = false;
    private Matrix expMatrix;
    private Matrix expMatrixTranspose;
    private Matrix responseMatrix;
    private Matrix testDataMatrix;
    private Matrix trainingMatrix;
    private int numberOfGenes = 0;
    private int numberOfSamples = 0;
    private int numberOfClasses = 0;
    private int kValue = 0;
    private int[] trainingIndices;
    private int[] testIndices;
    private int[] classes;
    private int whichAlgorithm = 0;
    private boolean isPDA = true;
    private boolean preSelectGenes = true;
    private boolean performLOOCV = true;
    private double alpha = 0.05;
    private int numberOfSelectedGenes = 0;
    private int[] geneRank;
    private int highestGeneRank;
    private Vector[] selectedGeneIndices;
    private int[] usedGeneIndices;
    private int[] unusedGeneIndices;
    private final int used = 0;
    private final int unused = 1;
    private Vector[][] reducedGeneSetForA2;
    private Vector[] reducedGeneSet;
    private Vector[] clusters;
    private Vector[] classified;
    private Matrix classExpSumMatrix;
    private int[] classSampleArray;
    private Matrix geneComponentMatrix;
    private Matrix[] beta;
    private Matrix[] A_Matrix;
    private Matrix[] C_Matrix;
    private double[] cValues;
    private boolean[] singularMatrix;
    int denominator = 0;
    int validN;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        FloatMatrix matrix3D;
        int[] features;
        int i;
        int i2;
        this.expMatrix = this.getJamaMatrix(data.getMatrix("experiment"));
        this.expMatrixTranspose = this.expMatrix.transpose();
        this.numberOfGenes = this.expMatrix.getRowDimension();
        this.numberOfSamples = this.expMatrix.getColumnDimension();
        AlgorithmParameters map = data.getParams();
        int function = map.getInt("distance-function", 3);
        float factor = map.getFloat("distance-factor", 1.0f);
        boolean absolute = map.getBoolean("distance-absolute", false);
        int mode = map.getInt("dam-mode", 0);
        this.preSelectGenes = map.getBoolean("preSelectionGenes", false);
        this.whichAlgorithm = map.getInt("algorithmSelection", 0);
        this.isPDA = map.getBoolean("isPDA", true);
        this.preSelectGenes = map.getBoolean("preSelectGenes", true);
        this.numberOfClasses = map.getInt("numberOfClasses", 3);
        this.kValue = map.getInt("kValue", 3);
        this.alpha = map.getFloat("alpha", 0.05f);
        this.singularMatrix = new boolean[this.numberOfSamples];
        this.trainingIndices = data.getIntArray("trainingIndices");
        this.classes = data.getIntArray("classes");
        this.testIndices = data.getIntArray("testIndices");
        this.responseMatrix = new Matrix(this.numberOfSamples, this.numberOfClasses);
        for (int row = 0; row < this.numberOfSamples; ++row) {
            for (int column = 0; column < this.numberOfClasses; ++column) {
                this.responseMatrix.set(row, column, 0.0);
            }
        }
        for (int i3 = 0; i3 < this.trainingIndices.length; ++i3) {
            this.responseMatrix.set(this.trainingIndices[i3], this.classes[i3] - 1, 1.0);
        }
        if (this.trainingIndices.length > 0) {
            this.trainingMatrix = new Matrix(this.numberOfGenes, this.trainingIndices.length);
            this.trainingMatrix = this.expMatrix.getMatrix(0, this.numberOfGenes - 1, this.trainingIndices);
        }
        if (this.testIndices.length > 0) {
            this.testDataMatrix = new Matrix(this.numberOfGenes, this.testIndices.length);
            this.testDataMatrix = this.expMatrix.getMatrix(0, this.numberOfGenes - 1, this.testIndices);
        }
        this.classExpSumMatrix = new Matrix(this.numberOfGenes, this.numberOfClasses);
        this.classExpSumMatrix = this.expMatrix.times(this.responseMatrix);
        this.classSampleArray = new int[this.numberOfClasses];
        for (int classId = 0; classId < this.numberOfClasses; ++classId) {
            for (int sample = 0; sample < this.numberOfSamples; ++sample) {
                int n = classId;
                this.classSampleArray[n] = (int)((double)this.classSampleArray[n] + this.responseMatrix.get(sample, classId));
            }
        }
        this.geneRank = new int[this.numberOfGenes];
        this.reducedGeneSet = new Vector[2];
        this.reducedGeneSet[0] = new Vector();
        this.reducedGeneSet[1] = new Vector();
        this.reducedGeneSetForA2 = new Vector[this.numberOfSamples][2];
        for (int leaveOutSample = 0; leaveOutSample < this.numberOfSamples; ++leaveOutSample) {
            this.reducedGeneSetForA2[leaveOutSample][0] = new Vector();
            this.reducedGeneSetForA2[leaveOutSample][1] = new Vector();
        }
        Matrix probFunction = new Matrix(this.numberOfSamples, this.numberOfClasses);
        Matrix[] beta = new Matrix[this.numberOfClasses];
        Vector[] classifiers = new Vector[this.numberOfClasses + 1];
        this.classified = new Vector[this.numberOfClasses + 1];
        Vector[] classifierPlusClassified = new Vector[this.numberOfClasses + 1];
        for (i2 = 0; i2 < this.numberOfClasses + 1; ++i2) {
            classifiers[i2] = new Vector();
            this.classified[i2] = new Vector();
            classifierPlusClassified[i2] = new Vector();
        }
        switch (this.whichAlgorithm) {
            case 0: {
                probFunction = this.A0Algorithm(this.expMatrix);
                break;
            }
            case 1: {
                probFunction = this.A1Algorithm(this.expMatrix);
                break;
            }
            case 2: {
                probFunction = this.A2Algorithm(this.expMatrix);
                break;
            }
            case 3: {
                probFunction = this.initialClassification(this.expMatrix);
                break;
            }
            default: {
                this.A0Algorithm(this.expMatrix);
            }
        }
        if (probFunction == null) {
            throw new AbortException();
        }
        for (i2 = 0; i2 < this.trainingIndices.length; ++i2) {
            classifiers[this.classes[i2]].add(new Integer(this.trainingIndices[i2]));
        }
        if (this.whichAlgorithm == 3) {
            int j;
            for (i2 = 0; i2 < classifiers.length; ++i2) {
                for (j = 0; j < classifiers[i2].size(); ++j) {
                    classifierPlusClassified[i2].add(classifiers[i2].get(j));
                }
            }
            for (i2 = 0; i2 < this.classified.length; ++i2) {
                for (j = 0; j < this.classified[i2].size(); ++j) {
                    classifierPlusClassified[i2].add(this.classified[i2].get(j));
                }
            }
        }
        this.clusters = new Vector[this.numberOfClasses * 3];
        for (i2 = 1; i2 <= this.numberOfClasses; ++i2) {
            this.clusters[i2 - 1] = classifiers[i2];
            this.clusters[i2 - 1 + this.numberOfClasses] = this.classified[i2];
            this.clusters[i2 - 1 + this.numberOfClasses * 2] = classifierPlusClassified[i2];
        }
        Matrix means = this.getMeans(this.clusters);
        Matrix variances = this.getVariances(this.clusters, means);
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            features = this.convert2int(this.clusters[i]);
            Node node = new Node(features);
            nodeList.addNode(node);
        }
        if (this.whichAlgorithm == 2) {
            this.usedGeneIndices = new int[this.reducedGeneSetForA2[0][0].size()];
            this.unusedGeneIndices = new int[this.reducedGeneSetForA2[0][1].size()];
            for (i = 0; i < this.usedGeneIndices.length; ++i) {
                this.usedGeneIndices[i] = (Integer)this.reducedGeneSetForA2[0][0].get(i);
            }
            for (i = 0; i < this.unusedGeneIndices.length; ++i) {
                this.unusedGeneIndices[i] = (Integer)this.reducedGeneSetForA2[0][1].get(i);
            }
        } else {
            this.usedGeneIndices = new int[this.reducedGeneSet[0].size()];
            this.unusedGeneIndices = new int[this.reducedGeneSet[1].size()];
            for (i = 0; i < this.usedGeneIndices.length; ++i) {
                this.usedGeneIndices[i] = (Integer)this.reducedGeneSet[0].get(i);
            }
            for (i = 0; i < this.unusedGeneIndices.length; ++i) {
                this.unusedGeneIndices[i] = (Integer)this.reducedGeneSet[1].get(i);
            }
        }
        int rowDim = means.getRowDimension();
        Cluster gene_cluster = new Cluster();
        nodeList = gene_cluster.getNodeList();
        for (int i4 = 0; i4 < this.reducedGeneSet.length; ++i4) {
            if (this.stop) {
                throw new AbortException();
            }
            features = this.convert2int(this.reducedGeneSet[i4]);
            Node node = new Node(features);
            nodeList.addNode(node);
        }
        Matrix means_used = this.getMeansForGenes(this.reducedGeneSet);
        Matrix variances_used = this.getVariancesForGenes(this.reducedGeneSet, means_used);
        Matrix means_unused = this.getMeansForGenes(this.reducedGeneSet);
        Matrix variances_unused = this.getVariancesForGenes(this.reducedGeneSet, means_used);
        AlgorithmData result = new AlgorithmData();
        result.addParam("numberOfGenes", String.valueOf(this.numberOfGenes));
        result.addMatrix("probFunction", this.getFloatMatrix(probFunction));
        FloatMatrix tempMatrix = this.getFloatMatrix(this.geneComponentMatrix).transpose();
        if (tempMatrix.getColumnDimension() == 2) {
            matrix3D = new FloatMatrix(tempMatrix.getRowDimension(), 3);
            matrix3D.setMatrix(0, tempMatrix.getRowDimension() - 1, 0, tempMatrix.getColumnDimension() - 1, tempMatrix);
            for (int i5 = 0; i5 < tempMatrix.getRowDimension(); ++i5) {
                matrix3D.set(i5, 2, 0.0f);
            }
        } else {
            matrix3D = tempMatrix;
        }
        result.addMatrix("matrix3D", matrix3D);
        result.addCluster("cluster", result_cluster);
        result.addCluster("geneCluster", gene_cluster);
        result.addMatrix("clusters_means", this.getFloatMatrix(means));
        result.addMatrix("clusters_variances", this.getFloatMatrix(variances));
        result.addMatrix("clusters_means_used", this.getFloatMatrix(means_used));
        result.addMatrix("clusters_variances_used", this.getFloatMatrix(variances_used));
        result.addMatrix("clusters_means_unused", this.getFloatMatrix(means_unused));
        result.addMatrix("clusters_variances_unused", this.getFloatMatrix(variances_unused));
        result.addIntArray("usedGeneIndices", this.usedGeneIndices);
        result.addIntArray("unusedGeneIndices", this.unusedGeneIndices);
        return result;
    }

    private Matrix extractResult(Matrix pMatrix) {
        Matrix newMatrix = new Matrix(this.numberOfSamples, this.numberOfClasses);
        int rows = pMatrix.getRowDimension();
        int cols = pMatrix.getColumnDimension();
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < cols; ++column) {
                newMatrix.set(row, column, 0.0);
            }
        }
        double[][] array = pMatrix.getArray();
        int classID = 0;
        for (int row = 0; row < rows; ++row) {
            classID = this.getClassID(array[row]);
            newMatrix.set(row, classID, 1.0);
        }
        return newMatrix;
    }

    private int getClassID(double[] probs) {
        int hasMax = 0;
        double max = 0.0;
        double currMax = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            currMax = Math.max(max, probs[i]);
            if (!(currMax > max)) continue;
            hasMax = i;
            max = currMax;
        }
        return hasMax;
    }

    public Vector[] geneSelection(Matrix expMatrix) {
        int gene;
        double tValue = 0.0;
        double meanSquareError = 0.0;
        int numOfGenes = expMatrix.getRowDimension();
        int numOfSamples = expMatrix.getColumnDimension();
        double[][] criticalScores = new double[this.numberOfClasses][this.numberOfClasses];
        double[][] meanDifferences = new double[this.numberOfClasses][this.numberOfClasses];
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "Gene Screening\n");
        this.fireValueChanged(event);
        event.setId(2);
        TDistribution testT = new TDistribution(numOfSamples - (this.numberOfClasses + 1));
        tValue = -testT.inverse(this.alpha / 2.0);
        double tValue1 = this.getTValue(numOfSamples - (this.numberOfClasses + 1), this.alpha);
        if (tValue < -1.0) {
            return null;
        }
        meanSquareError = this.getSampleVariance(expMatrix, this.getSampleMeans(expMatrix));
        for (gene = 0; gene < numOfGenes; ++gene) {
            for (int class1 = 0; class1 < this.numberOfClasses; ++class1) {
                for (int class2 = class1 + 1; class2 < this.numberOfClasses; ++class2) {
                    criticalScores[class1][class2] = tValue * Math.sqrt(meanSquareError * (1.0 / (double)this.classSampleArray[class1] + 1.0 / (double)this.classSampleArray[class2]));
                    meanDifferences[class1][class2] = Math.abs(this.classExpSumMatrix.get(gene, class1) / (double)this.classSampleArray[class1] - this.classExpSumMatrix.get(gene, class2) / (double)this.classSampleArray[class2]);
                    if (!(meanDifferences[class1][class2] > criticalScores[class1][class2])) continue;
                    int n = gene;
                    this.geneRank[n] = this.geneRank[n] + 1;
                }
            }
        }
        this.highestGeneRank = 0;
        for (gene = 0; gene < numOfGenes; ++gene) {
            if (this.geneRank[gene] <= this.highestGeneRank) continue;
            this.highestGeneRank = this.geneRank[gene];
        }
        Vector[] geneIndices = new Vector[this.highestGeneRank + 1];
        for (int rank = 0; rank < this.highestGeneRank + 1; ++rank) {
            geneIndices[rank] = new Vector();
            for (int gene2 = 0; gene2 < numOfGenes; ++gene2) {
                if (this.geneRank[gene2] != rank) continue;
                geneIndices[rank].add(new Integer(gene2));
                if (rank <= 0) continue;
                geneIndices[0].remove(new Integer(gene2));
            }
        }
        return geneIndices;
    }

    public Matrix[] mleAlgorithm(Matrix compMatrix, Matrix compResponseMatrix) throws AlgorithmException {
        int j;
        int i;
        int numOfGenes = compMatrix.getRowDimension();
        int numOfSamples = compMatrix.getColumnDimension();
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "MLE Algorithm \n");
        this.fireValueChanged(event);
        event.setId(2);
        Matrix[] X = new Matrix[numOfSamples];
        for (int i2 = 0; i2 < numOfSamples; ++i2) {
            X[i2] = new Matrix(numOfGenes + 1, 1);
            X[i2].set(0, 0, 1.0);
            X[i2].setMatrix(1, numOfGenes, 0, 0, compMatrix.getMatrix(0, numOfGenes - 1, i2, i2));
        }
        Matrix X_Matrix = new Matrix(numOfGenes + 1, numOfSamples);
        for (int i3 = 0; i3 < numOfSamples; ++i3) {
            X_Matrix.set(0, i3, 1.0);
        }
        X_Matrix.setMatrix(1, numOfGenes, 0, numOfSamples - 1, compMatrix);
        Matrix beta_Matrix = new Matrix(this.numberOfClasses * (numOfGenes + 1), 1);
        Matrix new_beta_Matrix = new Matrix(this.numberOfClasses * (numOfGenes + 1), 1);
        Matrix[] oldBeta = new Matrix[this.numberOfClasses];
        Matrix[] newBeta = new Matrix[this.numberOfClasses];
        for (int k = 0; k < this.numberOfClasses; ++k) {
            oldBeta[k] = new Matrix(numOfGenes + 1, 1);
            newBeta[k] = new Matrix(numOfGenes + 1, 1);
        }
        Matrix P_Matrix = new Matrix(numOfSamples, this.numberOfClasses);
        Matrix S_Matrix = new Matrix(this.numberOfClasses * (numOfGenes + 1), 1);
        Matrix[][] W_Matrices = new Matrix[this.numberOfClasses][this.numberOfClasses];
        for (int i4 = 0; i4 < this.numberOfClasses; ++i4) {
            for (int j2 = 0; j2 < this.numberOfClasses; ++j2) {
                W_Matrices[i4][j2] = new Matrix(numOfSamples, numOfSamples);
            }
        }
        Matrix I_Matrix = new Matrix(this.numberOfClasses * (numOfGenes + 1), this.numberOfClasses * (numOfGenes + 1));
        Matrix[][] I = new Matrix[this.numberOfClasses][this.numberOfClasses];
        for (i = 0; i < this.numberOfClasses; ++i) {
            for (j = 0; j < this.numberOfClasses; ++j) {
                I[i][j] = new Matrix(numOfGenes + 1, numOfGenes + 1);
            }
        }
        for (int k = 0; k < this.numberOfClasses; ++k) {
            for (int row = 0; row < numOfGenes + 1; ++row) {
                oldBeta[k].set(row, 0, (double)0.1f);
                newBeta[k].set(row, 0, (double)0.1f);
            }
        }
        for (i = 0; i < this.numberOfClasses; ++i) {
            for (j = 0; j < numOfGenes + 1; ++j) {
                beta_Matrix.set(i * j, 0, oldBeta[i].get(j, 0));
                new_beta_Matrix.set(i * j, 0, oldBeta[i].get(j, 0));
            }
        }
        Matrix Z_Matrix = compResponseMatrix.getMatrix(0, numOfSamples - 1, 0, this.numberOfClasses - 1);
        double g = 0.0;
        double c = 0.0;
        double localSum = 0.0;
        for (int iteration = 0; iteration < 40; ++iteration) {
            int i5;
            int k;
            oldBeta = newBeta;
            for (int i6 = 0; i6 < numOfSamples; ++i6) {
                for (int j3 = 0; j3 < this.numberOfClasses; ++j3) {
                    localSum += Math.exp(X[i6].transpose().times(oldBeta[j3]).get(0, 0));
                }
                c = Math.log(1.0 + localSum);
                for (k = 0; k < this.numberOfClasses; ++k) {
                    g = X[i6].transpose().times(oldBeta[k]).get(0, 0);
                    P_Matrix.set(i6, k, Math.exp(g - c));
                }
                localSum = 0.0;
            }
            Matrix[] sum = new Matrix[this.numberOfClasses];
            for (k = 0; k < this.numberOfClasses; ++k) {
                sum[k] = new Matrix(numOfGenes + 1, 1);
                for (int i7 = 0; i7 < numOfSamples; ++i7) {
                    sum[k] = sum[k].plus(X[i7].times(Z_Matrix.get(i7, k) - P_Matrix.get(i7, k)));
                }
            }
            for (k = 0; k < this.numberOfClasses; ++k) {
                S_Matrix.setMatrix(k * (numOfGenes + 1), (k + 1) * (numOfGenes + 1) - 1, 0, 0, sum[k]);
            }
            for (i5 = 0; i5 < this.numberOfClasses; ++i5) {
                for (int j4 = 0; j4 < this.numberOfClasses; ++j4) {
                    int k2;
                    if (i5 == j4) {
                        for (k2 = 0; k2 < numOfSamples; ++k2) {
                            W_Matrices[i5][j4].set(k2, k2, P_Matrix.get(k2, i5) * (1.0 - P_Matrix.get(k2, i5)));
                        }
                        continue;
                    }
                    for (k2 = 0; k2 < numOfSamples; ++k2) {
                        W_Matrices[i5][j4].set(k2, k2, P_Matrix.get(k2, i5) * P_Matrix.get(k2, j4));
                    }
                }
            }
            for (int k1 = 0; k1 < this.numberOfClasses; ++k1) {
                for (int k2 = 0; k2 < this.numberOfClasses; ++k2) {
                    I[k1][k2] = k1 == k2 ? X_Matrix.times(W_Matrices[k1][k2]).times(X_Matrix.transpose()) : X_Matrix.times(W_Matrices[k1][k2]).times(X_Matrix.transpose()).uminus();
                }
            }
            for (int row = 0; row < this.numberOfClasses; ++row) {
                for (int column = 0; column < this.numberOfClasses; ++column) {
                    I_Matrix.setMatrix(row * (numOfGenes + 1), (row + 1) * (numOfGenes + 1) - 1, column * (numOfGenes + 1), (column + 1) * (numOfGenes + 1) - 1, I[row][column]);
                }
            }
            for (i5 = 0; i5 < this.numberOfClasses; ++i5) {
                try {
                    Matrix inverseMatrix = I_Matrix.inverse();
                    newBeta[i5] = oldBeta[i5].plus(I_Matrix.inverse().times(S_Matrix).getMatrix(i5 * (numOfGenes + 1), (i5 + 1) * (numOfGenes + 1) - 1, 0, 0));
                    continue;
                }
                catch (RuntimeException ex) {
                    JOptionPane.showMessageDialog(null, "MLE Algorithm: Information Matrix is Singular", "Alert", 2);
                    throw new AlgorithmException("MLE Algorithm: Singular Matrix");
                }
            }
        }
        return newBeta;
    }

    public double[] pdaAlgorithm(Matrix testMatrix) {
        int numOfGenes = testMatrix.getRowDimension();
        int numOfTestSamples = testMatrix.getColumnDimension();
        Matrix X_Matrix = new Matrix(numOfGenes + 1, numOfTestSamples);
        for (int i = 0; i < numOfTestSamples; ++i) {
            X_Matrix.set(0, i, 1.0);
        }
        X_Matrix.setMatrix(1, numOfGenes, 0, numOfTestSamples - 1, testMatrix);
        double[] probFunction = new double[this.numberOfClasses];
        for (int classId = 0; classId < this.numberOfClasses; ++classId) {
            probFunction[classId] = X_Matrix.transpose().times(this.beta[classId]).get(0, 0);
        }
        return probFunction;
    }

    public int calculateQDAParameters(Matrix compMatrix, Matrix responseMatrix) throws AlgorithmException {
        int classId;
        int numOfGenes = compMatrix.getRowDimension();
        int numOfSamples = compMatrix.getColumnDimension();
        Matrix[] subCompMatrix = new Matrix[this.numberOfClasses];
        int[] numOfSamplesInClass = new int[this.numberOfClasses];
        for (int classId2 = 0; classId2 < this.numberOfClasses; ++classId2) {
            numOfSamplesInClass[classId2] = 0;
            for (int i = 0; i < numOfSamples; ++i) {
                int n = classId2;
                numOfSamplesInClass[n] = (int)((double)numOfSamplesInClass[n] + responseMatrix.get(i, classId2));
            }
            int k = numOfSamplesInClass[classId2];
            int[] classIndices = new int[k];
            int j = 0;
            for (int i = 0; i < numOfSamples; ++i) {
                if (responseMatrix.get(i, classId2) != 1.0) continue;
                classIndices[j] = i;
                ++j;
            }
            subCompMatrix[classId2] = new Matrix(numOfGenes, numOfSamplesInClass[classId2]);
            subCompMatrix[classId2] = compMatrix.getMatrix(0, numOfGenes - 1, classIndices);
        }
        Matrix[] means = new Matrix[this.numberOfClasses];
        for (int classId3 = 0; classId3 < this.numberOfClasses; ++classId3) {
            means[classId3] = new Matrix(1, numOfGenes);
        }
        Matrix[] covarianceMatrix = new Matrix[this.numberOfClasses];
        for (int classId4 = 0; classId4 < this.numberOfClasses; ++classId4) {
            covarianceMatrix[classId4] = new Matrix(numOfGenes, numOfGenes);
        }
        Matrix[] covInverseMatrix = new Matrix[this.numberOfClasses];
        for (int classId5 = 0; classId5 < this.numberOfClasses; ++classId5) {
            covInverseMatrix[classId5] = new Matrix(numOfGenes, numOfGenes);
        }
        double[] probability = new double[this.numberOfClasses];
        double[] sumVector = new double[numOfSamples];
        this.A_Matrix = new Matrix[this.numberOfClasses];
        this.C_Matrix = new Matrix[this.numberOfClasses];
        for (int classId6 = 0; classId6 < this.numberOfClasses; ++classId6) {
            this.C_Matrix[classId6] = new Matrix(numOfGenes, 1);
        }
        this.cValues = new double[this.numberOfClasses];
        int responseSum = 0;
        for (int classId7 = 0; classId7 < this.numberOfClasses; ++classId7) {
            responseSum = 0;
            for (int sample = 0; sample < numOfSamples; ++sample) {
                responseSum = (int)((double)responseSum + responseMatrix.get(sample, classId7));
            }
            probability[classId7] = (double)responseSum / (double)numOfSamples;
        }
        double geneSumInOneClass = 0.0;
        for (int classId8 = 0; classId8 < this.numberOfClasses; ++classId8) {
            for (int gene = 0; gene < numOfGenes; ++gene) {
                geneSumInOneClass = 0.0;
                for (int sample = 0; sample < subCompMatrix[classId8].getColumnDimension(); ++sample) {
                    geneSumInOneClass += subCompMatrix[classId8].get(gene, sample);
                }
                means[classId8].set(0, gene, geneSumInOneClass / (double)subCompMatrix[classId8].getColumnDimension());
            }
        }
        double[][] tempDouble = new double[numOfGenes][numOfGenes];
        Matrix tempMatrix = new Matrix(numOfGenes, numOfGenes);
        for (classId = 0; classId < this.numberOfClasses; ++classId) {
            covarianceMatrix[classId] = this.getCovarianceMatrix(subCompMatrix[classId], means[classId]);
            double[][] tempArray = covarianceMatrix[classId].getArray();
            for (int i = 0; i < numOfGenes; ++i) {
                for (int j = 0; j < numOfGenes; ++j) {
                    tempMatrix.set(i, j, (double)((int)(tempArray[i][j] * 1000000.0)) / 1000000.0);
                }
            }
            if (Math.abs(tempMatrix.det()) < 1.0E-10) {
                JOptionPane.showMessageDialog(null, "QDA Algorithm: Covariance Matrix is Singular", "Alert", 2);
                throw new AlgorithmException("QDA Algorithm: Singular Matrix");
            }
            covInverseMatrix[classId] = tempMatrix.inverse();
        }
        for (classId = 0; classId < this.numberOfClasses; ++classId) {
            this.A_Matrix[classId] = new Matrix(numOfGenes, numOfGenes);
            this.A_Matrix[classId] = covInverseMatrix[classId].times(-0.5);
        }
        for (classId = 0; classId < this.numberOfClasses; ++classId) {
            this.C_Matrix[classId] = covInverseMatrix[classId].times(means[classId].transpose());
        }
        for (classId = 0; classId < this.numberOfClasses; ++classId) {
            this.cValues[classId] = Math.log(probability[classId]);
            int n = classId;
            this.cValues[n] = this.cValues[n] - Math.log(tempMatrix.det()) * 0.5;
            int n2 = classId;
            this.cValues[n2] = this.cValues[n2] - means[classId].times(this.C_Matrix[classId]).get(0, 0) * 0.5;
        }
        return 1;
    }

    public double[] qdaAlgorithm(Matrix testMatrix) {
        Matrix Q_Matrix = new Matrix(this.numberOfClasses, 1);
        Matrix temp = new Matrix(1, 1);
        for (int classId = 0; classId < this.numberOfClasses; ++classId) {
            temp = testMatrix.transpose().times(this.A_Matrix[classId]).times(testMatrix);
            temp = temp.plus(this.C_Matrix[classId].transpose().times(testMatrix));
            Q_Matrix.set(classId, 0, temp.get(0, 0) + this.cValues[classId]);
        }
        double sum = 0.0;
        for (int classId = 0; classId < this.numberOfClasses; ++classId) {
            sum += Math.exp(Q_Matrix.get(classId, 0));
        }
        double[] probFunction = new double[this.numberOfClasses];
        for (int classId = 0; classId < this.numberOfClasses; ++classId) {
            probFunction[classId] = Math.exp(Q_Matrix.get(classId, 0)) / sum;
        }
        return probFunction;
    }

    public Matrix mplsAlgorithm(Matrix trainingMatrix, Matrix trainingResponseMatrix, Matrix testMatrix) {
        int row;
        double tempVariance;
        double tempMean;
        int column;
        Matrix[] matrix_X = new Matrix[this.kValue + 1];
        Matrix[] matrix_Y = new Matrix[this.kValue + 1];
        Matrix[] matrix_T = new Matrix[this.kValue];
        int numOfGenes = trainingMatrix.getRowDimension();
        int numOfTrainingSamples = trainingMatrix.getColumnDimension();
        int numOfTestSamples = testMatrix.getColumnDimension();
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.kValue, "Dimension Reduction (MPLS)\n");
        this.fireValueChanged(event);
        event.setId(2);
        for (int k = 0; k < this.kValue + 1; ++k) {
            matrix_X[k] = new Matrix(numOfGenes, numOfTrainingSamples);
            matrix_Y[k] = new Matrix(numOfTrainingSamples, this.numberOfClasses);
            if (k >= this.kValue) continue;
            matrix_T[k] = new Matrix(numOfGenes, numOfTestSamples);
        }
        Matrix training_means_X = this.getSampleMeans(trainingMatrix);
        Matrix training_variances_X = this.getSampleVariances(trainingMatrix, training_means_X);
        for (column = 0; column < numOfTrainingSamples; ++column) {
            tempMean = training_means_X.get(0, column);
            tempVariance = training_variances_X.get(0, column);
            for (row = 0; row < numOfGenes; ++row) {
                matrix_X[0].set(row, column, (trainingMatrix.get(row, column) - tempMean) / tempVariance);
            }
        }
        Matrix training_means_Y = this.getSampleMeans(trainingResponseMatrix);
        Matrix training_variances_Y = this.getSampleVariances(trainingResponseMatrix, training_means_Y);
        for (column = 0; column < this.numberOfClasses; ++column) {
            tempMean = training_means_Y.get(0, column);
            tempVariance = training_variances_Y.get(0, column);
            for (row = 0; row < numOfTrainingSamples; ++row) {
                matrix_Y[0].set(row, column, (trainingResponseMatrix.get(row, column) - tempMean) / tempVariance);
            }
        }
        Matrix test_means_X = this.getSampleMeans(testMatrix);
        Matrix test_variances_X = this.getSampleVariances(testMatrix, test_means_X);
        for (column = 0; column < numOfTestSamples; ++column) {
            tempMean = test_means_X.get(0, column);
            tempVariance = test_variances_X.get(0, column);
            for (row = 0; row < numOfGenes; ++row) {
                matrix_T[0].set(row, column, (testMatrix.get(row, column) - tempMean) / tempVariance);
            }
        }
        double e = 1.0E-12;
        Matrix u = new Matrix(numOfTrainingSamples, 1);
        double uu = 0.0;
        Matrix w = new Matrix(numOfGenes, 1);
        Matrix[] wk = new Matrix[this.kValue];
        for (int i = 0; i < this.kValue; ++i) {
            wk[i] = new Matrix(numOfGenes, 1);
        }
        Matrix w_prep = new Matrix(numOfGenes, 1);
        for (int i = 0; i < numOfGenes; ++i) {
            w_prep.set(i, 0, 0.0);
        }
        Matrix t = new Matrix(numOfTrainingSamples, 1);
        double tt = 0.0;
        double cc = 0.0;
        double ww = 0.0;
        double pp = 0.0;
        Matrix c = new Matrix(this.numberOfClasses, 1);
        Matrix[] tk = new Matrix[this.kValue];
        Matrix[] ck = new Matrix[this.kValue];
        Matrix[] pk = new Matrix[this.kValue];
        double[] bk = new double[this.kValue];
        for (int i = 0; i < this.kValue; ++i) {
            tk[i] = new Matrix(numOfTrainingSamples, 1);
            ck[i] = new Matrix(this.numberOfClasses, 1);
            pk[i] = new Matrix(numOfGenes, 1);
            bk[i] = 0.0;
        }
        double cp = 1.0;
        for (int k = 0; k < this.kValue; ++k) {
            int row2;
            for (int row3 = 0; row3 < numOfTrainingSamples; ++row3) {
                u.set(row3, 0, matrix_Y[k].get(row3, 0));
            }
            uu = u.transpose().times(u).get(0, 0);
            int loop = 0;
            double delta = 1.0;
            while (delta > e && loop < 1000) {
                ++loop;
                w = matrix_X[k].times(u);
                for (row2 = 0; row2 < numOfGenes; ++row2) {
                    w.set(row2, 0, w.get(row2, 0) / uu);
                }
                ww = Math.sqrt(w.transpose().times(w).get(0, 0));
                for (row2 = 0; row2 < numOfGenes; ++row2) {
                    w.set(row2, 0, w.get(row2, 0) / ww);
                }
                t = matrix_X[k].transpose().times(w);
                tt = t.transpose().times(t).get(0, 0);
                c = matrix_Y[k].transpose().times(t);
                for (row2 = 0; row2 < this.numberOfClasses; ++row2) {
                    c.set(row2, 0, c.get(row2, 0) / tt);
                }
                cc = Math.sqrt(c.transpose().times(c).get(0, 0));
                for (row2 = 0; row2 < this.numberOfClasses; ++row2) {
                    c.set(row2, 0, c.get(row2, 0) / cc);
                }
                u = matrix_Y[k].times(c);
                if (loop > 1) {
                    delta = w.minus(w_prep).transpose().times(w.minus(w_prep)).get(0, 0);
                }
                for (int i = 0; i < numOfGenes; ++i) {
                    w_prep.set(i, 0, w.get(i, 0));
                }
            }
            ck[k] = c;
            pk[k] = matrix_X[k].times(t);
            for (row2 = 0; row2 < numOfGenes; ++row2) {
                pk[k].set(row2, 0, pk[k].get(row2, 0) / tt);
            }
            cp = Math.sqrt(pk[k].transpose().times(pk[k]).get(0, 0));
            for (row2 = 0; row2 < numOfGenes; ++row2) {
                pk[k].set(row2, 0, pk[k].get(row2, 0) / cp);
            }
            tk[k] = t;
            wk[k] = w;
            bk[k] = u.transpose().times(t).get(0, 0) / tt;
            if (k < this.kValue) {
                matrix_X[k + 1] = matrix_X[k].minus(tk[k].times(pk[k].transpose()).transpose());
                matrix_Y[k + 1] = matrix_Y[k].minus(tk[k].times(ck[k].transpose()).times(bk[k]));
            }
            event.setIntValue(k);
            event.setDescription("Calculating Component # " + (k + 1) + "\n");
            this.fireValueChanged(event);
        }
        Matrix[] tMatrix = new Matrix[this.kValue];
        for (int i = 0; i < this.kValue; ++i) {
            tMatrix[i] = new Matrix(numOfTestSamples, 1);
        }
        tMatrix[0] = matrix_T[0].transpose().times(wk[0]);
        for (int k = 1; k < this.kValue; ++k) {
            matrix_T[k] = matrix_T[k - 1].minus(tMatrix[k - 1].times(pk[k - 1].transpose()).transpose());
            tMatrix[k] = matrix_T[k].transpose().times(wk[k]);
        }
        Matrix geneCompMatrix = new Matrix(this.kValue, numOfTestSamples);
        for (int gene = 0; gene < this.kValue; ++gene) {
            for (int sample = 0; sample < numOfTestSamples; ++sample) {
                geneCompMatrix.set(gene, sample, tMatrix[gene].get(sample, 0));
            }
        }
        return geneCompMatrix;
    }

    public Matrix initialClassification(Matrix expMatrix) throws AlgorithmException {
        int testSample;
        int testSampleId;
        Matrix selectedExpMatrix;
        Matrix selectedTrainingMatrix;
        int i;
        double[][] probFunction = new double[this.numberOfSamples][this.numberOfClasses];
        int numOfSelectedGenes = 1;
        double[] selectedGenesArray = new double[this.numberOfGenes];
        int numOfTrainingSamples = this.trainingMatrix.getColumnDimension();
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "Initial Classification\n");
        this.fireValueChanged(event);
        event.setId(2);
        if (this.preSelectGenes && expMatrix.getRowDimension() > this.kValue) {
            int gene;
            this.selectedGeneIndices = this.geneSelection(this.trainingMatrix);
            if (this.selectedGeneIndices == null) {
                return null;
            }
            if (this.highestGeneRank > 1) {
                numOfSelectedGenes = this.selectedGeneIndices[this.highestGeneRank - 1].size() + this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 1) {
                numOfSelectedGenes = this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 0) {
                numOfSelectedGenes = this.selectedGeneIndices[0].size();
            }
            for (i = 0; i < this.selectedGeneIndices[this.highestGeneRank].size(); ++i) {
                this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank].get(i));
            }
            if (this.highestGeneRank > 1) {
                for (i = 0; i < this.selectedGeneIndices[this.highestGeneRank - 1].size(); ++i) {
                    this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank - 1].get(i));
                }
            }
            boolean j = false;
            for (int i2 = 0; i2 < this.numberOfGenes; ++i2) {
                if (this.isFoundInVector(i2, this.reducedGeneSet[0])) continue;
                this.reducedGeneSet[1].add(new Integer(i2));
            }
            for (gene = 0; gene < this.numberOfGenes; ++gene) {
                selectedGenesArray[gene] = this.isFoundInVector(gene, this.selectedGeneIndices[this.highestGeneRank]) || this.isFoundInVector(gene, this.selectedGeneIndices[this.highestGeneRank - 1]) ? 1.0 : 0.0;
            }
            selectedTrainingMatrix = new Matrix(numOfSelectedGenes, numOfTrainingSamples);
            selectedExpMatrix = new Matrix(numOfSelectedGenes, this.numberOfSamples);
            gene = 0;
            for (int selected = 0; selected < numOfSelectedGenes; ++selected) {
                if (selectedGenesArray[gene] == 1.0) {
                    int sample;
                    for (sample = 0; sample < numOfTrainingSamples; ++sample) {
                        selectedTrainingMatrix.set(selected, sample, this.trainingMatrix.get(gene, sample));
                    }
                    for (sample = 0; sample < this.numberOfSamples; ++sample) {
                        selectedExpMatrix.set(selected, sample, expMatrix.get(gene, sample));
                    }
                }
                ++gene;
            }
        } else {
            for (i = 0; i < this.numberOfGenes; ++i) {
                this.reducedGeneSet[0].add(new Integer(i));
            }
            selectedTrainingMatrix = new Matrix(this.numberOfGenes, numOfTrainingSamples);
            selectedTrainingMatrix = this.trainingMatrix;
            selectedExpMatrix = new Matrix(this.numberOfGenes, this.numberOfSamples);
            selectedExpMatrix = expMatrix;
        }
        Matrix trainingRespMatrix = new Matrix(numOfTrainingSamples, this.numberOfClasses);
        trainingRespMatrix = this.responseMatrix.getMatrix(this.trainingIndices, 0, this.numberOfClasses - 1);
        Matrix geneCompMatrix = selectedExpMatrix.getRowDimension() == this.kValue ? selectedExpMatrix : this.mplsAlgorithm(selectedTrainingMatrix, trainingRespMatrix, selectedExpMatrix);
        this.geneComponentMatrix = geneCompMatrix;
        Matrix trainingCompMatrix = geneCompMatrix.getMatrix(0, geneCompMatrix.getRowDimension() - 1, this.trainingIndices);
        if (this.isPDA) {
            try {
                this.beta = this.mleAlgorithm(trainingCompMatrix, trainingRespMatrix);
            }
            catch (AlgorithmException ex) {
                throw new AbortException();
            }
        }
        try {
            this.calculateQDAParameters(trainingCompMatrix, trainingRespMatrix);
        }
        catch (AlgorithmException ex) {
            throw new AbortException();
        }
        int numOfGenes = geneCompMatrix.getRowDimension();
        int numOfTestSamples = geneCompMatrix.getColumnDimension();
        int[] columnList = new int[numOfTestSamples - 1];
        Matrix testMatrix = new Matrix(numOfGenes, 1);
        for (testSampleId = 0; testSampleId < this.testIndices.length; ++testSampleId) {
            testSample = this.testIndices[testSampleId];
            testMatrix = geneCompMatrix.getMatrix(0, numOfGenes - 1, testSample, testSample);
            probFunction[testSample] = this.isPDA ? this.pdaAlgorithm(testMatrix) : this.qdaAlgorithm(testMatrix);
        }
        for (testSampleId = 0; testSampleId < this.testIndices.length; ++testSampleId) {
            testSample = this.testIndices[testSampleId];
        }
        double max = 0.0;
        int maxClassId = 0;
        for (int testSampleId2 = 0; testSampleId2 < this.testIndices.length; ++testSampleId2) {
            testSample = this.testIndices[testSampleId2];
            maxClassId = 0;
            if (!Double.isNaN(probFunction[testSample][0])) {
                max = probFunction[testSample][0];
                maxClassId = 1;
                for (int classId = 0; classId < this.numberOfClasses; ++classId) {
                    if (!Double.isNaN(probFunction[testSample][classId])) {
                        if (!(probFunction[testSample][classId] > max)) continue;
                        max = probFunction[testSample][classId];
                        maxClassId = classId + 1;
                        continue;
                    }
                    maxClassId = 0;
                    classId = this.numberOfClasses;
                }
            } else {
                maxClassId = 0;
            }
            this.classified[maxClassId].add(new Integer(testSample));
        }
        return new Matrix(probFunction);
    }

    public Matrix A0Algorithm(Matrix expMatrix) throws AlgorithmException {
        Matrix selectedExpMatrix;
        int i;
        double[][] probFunction = new double[this.numberOfSamples][this.numberOfClasses];
        int numOfSelectedGenes = 1;
        double[] selectedGenesArray = new double[this.numberOfGenes];
        int numOfTrainingSamples = this.trainingMatrix.getColumnDimension();
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "Classification Algorithm : A0\n");
        this.fireValueChanged(event);
        event.setId(2);
        if (this.preSelectGenes && expMatrix.getRowDimension() > this.kValue) {
            int gene;
            this.selectedGeneIndices = this.geneSelection(expMatrix);
            if (this.selectedGeneIndices == null) {
                return null;
            }
            if (this.highestGeneRank > 1) {
                numOfSelectedGenes = this.selectedGeneIndices[this.highestGeneRank - 1].size() + this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 1) {
                numOfSelectedGenes = this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 0) {
                numOfSelectedGenes = this.selectedGeneIndices[0].size();
            }
            for (i = 0; i < this.selectedGeneIndices[this.highestGeneRank].size(); ++i) {
                this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank].get(i));
            }
            if (this.highestGeneRank > 1) {
                for (i = 0; i < this.selectedGeneIndices[this.highestGeneRank - 1].size(); ++i) {
                    this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank - 1].get(i));
                }
            }
            boolean j = false;
            for (int i2 = 0; i2 < this.numberOfGenes; ++i2) {
                if (this.isFoundInVector(i2, this.reducedGeneSet[0])) continue;
                this.reducedGeneSet[1].add(new Integer(i2));
            }
            for (gene = 0; gene < this.numberOfGenes; ++gene) {
                selectedGenesArray[gene] = this.isFoundInVector(gene, this.selectedGeneIndices[this.highestGeneRank]) || this.isFoundInVector(gene, this.selectedGeneIndices[this.highestGeneRank - 1]) ? 1.0 : 0.0;
            }
            selectedExpMatrix = new Matrix(numOfSelectedGenes, this.numberOfSamples);
            gene = 0;
            for (int selected = 0; selected < numOfSelectedGenes; ++selected) {
                if (selectedGenesArray[gene] == 1.0) {
                    for (int sample = 0; sample < this.numberOfSamples; ++sample) {
                        selectedExpMatrix.set(selected, sample, expMatrix.get(gene, sample));
                    }
                }
                ++gene;
            }
        } else {
            for (i = 0; i < this.numberOfGenes; ++i) {
                this.reducedGeneSet[0].add(new Integer(i));
            }
            selectedExpMatrix = new Matrix(this.numberOfGenes, this.numberOfSamples);
            selectedExpMatrix = expMatrix;
        }
        Matrix geneCompMatrix = selectedExpMatrix.getRowDimension() == this.kValue ? selectedExpMatrix : this.mplsAlgorithm(selectedExpMatrix, this.responseMatrix, selectedExpMatrix);
        this.geneComponentMatrix = geneCompMatrix;
        if (this.performLOOCV) {
            int numOfGenes = geneCompMatrix.getRowDimension();
            int numOfTestSamples = geneCompMatrix.getColumnDimension();
            int[] columnList = new int[numOfTestSamples - 1];
            Matrix testMatrix = new Matrix(numOfGenes, 1);
            Matrix subGeneCompMatrix = new Matrix(numOfGenes, numOfTestSamples - 1);
            Matrix subResponseMatrix = new Matrix(numOfTestSamples - 1, this.numberOfClasses);
            for (int leaveOutSample = 0; leaveOutSample < numOfTestSamples; ++leaveOutSample) {
                this.singularMatrix[leaveOutSample] = false;
                for (int sample = 0; sample < numOfTestSamples; ++sample) {
                    if (sample < leaveOutSample) {
                        columnList[sample] = sample;
                        continue;
                    }
                    if (sample <= leaveOutSample) continue;
                    columnList[sample - 1] = sample;
                }
                subGeneCompMatrix = geneCompMatrix.getMatrix(0, numOfGenes - 1, columnList);
                subResponseMatrix = this.responseMatrix.getMatrix(columnList, 0, this.numberOfClasses - 1);
                testMatrix = geneCompMatrix.getMatrix(0, numOfGenes - 1, leaveOutSample, leaveOutSample);
                if (this.isPDA) {
                    try {
                        this.beta = this.mleAlgorithm(subGeneCompMatrix, subResponseMatrix);
                    }
                    catch (AlgorithmException ex) {
                        this.singularMatrix[leaveOutSample] = true;
                        continue;
                    }
                    probFunction[leaveOutSample] = this.pdaAlgorithm(testMatrix);
                    continue;
                }
                try {
                    this.calculateQDAParameters(subGeneCompMatrix, subResponseMatrix);
                }
                catch (AlgorithmException ex) {
                    this.singularMatrix[leaveOutSample] = true;
                    continue;
                }
                probFunction[leaveOutSample] = this.qdaAlgorithm(testMatrix);
            }
            double max = 0.0;
            int maxClassId = 0;
            for (int leaveOutSample = 0; leaveOutSample < numOfTestSamples; ++leaveOutSample) {
                if (this.singularMatrix[leaveOutSample]) continue;
                max = probFunction[leaveOutSample][0];
                maxClassId = 0;
                if (!Double.isNaN(probFunction[leaveOutSample][0])) {
                    max = probFunction[leaveOutSample][0];
                    maxClassId = 1;
                    for (int classId = 0; classId < this.numberOfClasses; ++classId) {
                        if (!Double.isNaN(probFunction[leaveOutSample][classId])) {
                            if (!(probFunction[leaveOutSample][classId] > max)) continue;
                            max = probFunction[leaveOutSample][classId];
                            maxClassId = classId + 1;
                            continue;
                        }
                        maxClassId = 0;
                        classId = this.numberOfClasses;
                    }
                } else {
                    maxClassId = 0;
                }
                this.classified[maxClassId].add(new Integer(leaveOutSample));
            }
        }
        return new Matrix(probFunction);
    }

    public Matrix A1Algorithm(Matrix expMatrix) throws AlgorithmException {
        int sample;
        Matrix selectedExpMatrix;
        int gene;
        int i;
        double[][] probFunction = new double[this.numberOfSamples][this.numberOfClasses];
        double[] selectedGenesArray = new double[this.numberOfGenes];
        int numOfSelectedGenes = 1;
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "Classification Algorithm : A1\n");
        this.fireValueChanged(event);
        event.setId(2);
        if (this.preSelectGenes && expMatrix.getRowDimension() > this.kValue) {
            this.selectedGeneIndices = this.geneSelection(expMatrix);
            if (this.selectedGeneIndices == null) {
                return null;
            }
            if (this.highestGeneRank > 1) {
                numOfSelectedGenes = this.selectedGeneIndices[this.highestGeneRank - 1].size() + this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 1) {
                numOfSelectedGenes = this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 0) {
                numOfSelectedGenes = this.selectedGeneIndices[0].size();
            }
            for (i = 0; i < this.selectedGeneIndices[this.highestGeneRank].size(); ++i) {
                this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank].get(i));
            }
            if (this.highestGeneRank > 1) {
                for (i = 0; i < this.selectedGeneIndices[this.highestGeneRank - 1].size(); ++i) {
                    this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank - 1].get(i));
                }
            }
            boolean j = false;
            for (int i2 = 0; i2 < this.numberOfGenes; ++i2) {
                if (this.isFoundInVector(i2, this.reducedGeneSet[0])) continue;
                this.reducedGeneSet[1].add(new Integer(i2));
            }
            for (gene = 0; gene < this.numberOfGenes; ++gene) {
                selectedGenesArray[gene] = this.isFoundInVector(gene, this.selectedGeneIndices[this.highestGeneRank]) || this.isFoundInVector(gene, this.selectedGeneIndices[this.highestGeneRank - 1]) ? 1.0 : 0.0;
            }
            selectedExpMatrix = new Matrix(numOfSelectedGenes, this.numberOfSamples);
            gene = 0;
            for (int selected = 0; selected < numOfSelectedGenes; ++selected) {
                if (selectedGenesArray[gene] == 1.0) {
                    for (sample = 0; sample < this.numberOfSamples; ++sample) {
                        selectedExpMatrix.set(selected, sample, expMatrix.get(gene, sample));
                    }
                }
                ++gene;
            }
        } else {
            for (i = 0; i < this.numberOfGenes; ++i) {
                this.reducedGeneSet[0].add(new Integer(i));
            }
            selectedExpMatrix = new Matrix(this.numberOfGenes, this.numberOfSamples);
            selectedExpMatrix = expMatrix;
        }
        for (int leaveOutSample = 0; leaveOutSample < this.numberOfSamples; ++leaveOutSample) {
            this.singularMatrix[leaveOutSample] = false;
            gene = 0;
            int[] columnList = new int[this.numberOfSamples - 1];
            for (sample = 0; sample < this.numberOfSamples; ++sample) {
                if (sample < leaveOutSample) {
                    columnList[sample] = sample;
                    continue;
                }
                if (sample <= leaveOutSample) continue;
                columnList[sample - 1] = sample;
            }
            Matrix subSelectedExpMatrix = selectedExpMatrix.getMatrix(0, numOfSelectedGenes - 1, columnList);
            Matrix subResponseMatrix = this.responseMatrix.getMatrix(columnList, 0, this.numberOfClasses - 1);
            Matrix geneCompMatrix = selectedExpMatrix.getRowDimension() == this.kValue ? selectedExpMatrix : this.mplsAlgorithm(subSelectedExpMatrix, subResponseMatrix, selectedExpMatrix);
            this.geneComponentMatrix = geneCompMatrix;
            int numOfGenes = geneCompMatrix.getRowDimension();
            Matrix testMatrix = new Matrix(numOfGenes, 1);
            testMatrix = geneCompMatrix.getMatrix(0, numOfGenes - 1, leaveOutSample, leaveOutSample);
            Matrix subGeneCompMatrix = new Matrix(numOfGenes, this.numberOfSamples - 1);
            subGeneCompMatrix = geneCompMatrix.getMatrix(0, numOfGenes - 1, columnList);
            if (this.isPDA) {
                try {
                    this.beta = this.mleAlgorithm(subGeneCompMatrix, subResponseMatrix);
                }
                catch (AlgorithmException ex) {
                    this.singularMatrix[leaveOutSample] = true;
                    continue;
                }
                probFunction[leaveOutSample] = this.pdaAlgorithm(testMatrix);
                continue;
            }
            try {
                this.calculateQDAParameters(subGeneCompMatrix, subResponseMatrix);
            }
            catch (AlgorithmException ex) {
                this.singularMatrix[leaveOutSample] = true;
                continue;
            }
            probFunction[leaveOutSample] = this.qdaAlgorithm(testMatrix);
        }
        double max = 0.0;
        int maxClassId = 0;
        for (int leaveOutSample = 0; leaveOutSample < this.numberOfSamples; ++leaveOutSample) {
            if (this.singularMatrix[leaveOutSample]) continue;
            max = probFunction[leaveOutSample][0];
            maxClassId = 0;
            if (!Double.isNaN(probFunction[leaveOutSample][0])) {
                max = probFunction[leaveOutSample][0];
                maxClassId = 1;
                for (int classId = 0; classId < this.numberOfClasses; ++classId) {
                    if (!Double.isNaN(probFunction[leaveOutSample][classId])) {
                        if (!(probFunction[leaveOutSample][classId] > max)) continue;
                        max = probFunction[leaveOutSample][classId];
                        maxClassId = classId + 1;
                        continue;
                    }
                    maxClassId = 0;
                    classId = this.numberOfClasses;
                }
            } else {
                maxClassId = 0;
            }
            this.classified[maxClassId].add(new Integer(leaveOutSample));
        }
        return new Matrix(probFunction);
    }

    public Matrix A2Algorithm(Matrix expMatrix) throws AlgorithmException {
        double[][] probFunction = new double[this.numberOfSamples][this.numberOfClasses];
        double[] selectedGenesArray = new double[this.numberOfGenes];
        int numOfSelectedGenes = 1;
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "Classification Algorithm : A2\n");
        this.fireValueChanged(event);
        event.setId(2);
        for (int leaveOutSample = 0; leaveOutSample < this.numberOfSamples; ++leaveOutSample) {
            Matrix selectedExpMatrix;
            int i;
            this.singularMatrix[leaveOutSample] = false;
            int[] columnList = new int[this.numberOfSamples - 1];
            for (int sample = 0; sample < this.numberOfSamples; ++sample) {
                if (sample < leaveOutSample) {
                    columnList[sample] = sample;
                    continue;
                }
                if (sample <= leaveOutSample) continue;
                columnList[sample - 1] = sample;
            }
            Matrix subExpMatrix = expMatrix.getMatrix(0, this.numberOfGenes - 1, columnList);
            Matrix subResponseMatrix = this.responseMatrix.getMatrix(columnList, 0, this.numberOfClasses - 1);
            if (this.preSelectGenes && expMatrix.getRowDimension() > this.kValue) {
                int gene;
                this.selectedGeneIndices = this.geneSelection(subExpMatrix);
                if (this.selectedGeneIndices == null) {
                    return null;
                }
                if (this.highestGeneRank > 1) {
                    numOfSelectedGenes = this.selectedGeneIndices[this.highestGeneRank - 1].size() + this.selectedGeneIndices[this.highestGeneRank].size();
                } else if (this.highestGeneRank == 1) {
                    numOfSelectedGenes = this.selectedGeneIndices[this.highestGeneRank].size();
                } else if (this.highestGeneRank == 0) {
                    numOfSelectedGenes = this.selectedGeneIndices[0].size();
                }
                for (i = 0; i < this.selectedGeneIndices[this.highestGeneRank].size(); ++i) {
                    this.reducedGeneSetForA2[leaveOutSample][0].add(this.selectedGeneIndices[this.highestGeneRank].get(i));
                }
                if (this.highestGeneRank > 1) {
                    for (i = 0; i < this.selectedGeneIndices[this.highestGeneRank - 1].size(); ++i) {
                        this.reducedGeneSetForA2[leaveOutSample][0].add(this.selectedGeneIndices[this.highestGeneRank - 1].get(i));
                    }
                }
                boolean j = false;
                for (int i2 = 0; i2 < this.numberOfGenes; ++i2) {
                    if (this.isFoundInVector(i2, this.reducedGeneSetForA2[leaveOutSample][0])) continue;
                    this.reducedGeneSetForA2[leaveOutSample][1].add(new Integer(i2));
                }
                for (gene = 0; gene < this.numberOfGenes; ++gene) {
                    selectedGenesArray[gene] = this.isFoundInVector(gene, this.selectedGeneIndices[this.highestGeneRank]) || this.highestGeneRank > 0 && this.isFoundInVector(gene, this.selectedGeneIndices[this.highestGeneRank - 1]) ? 1.0 : 0.0;
                }
                selectedExpMatrix = new Matrix(numOfSelectedGenes, this.numberOfSamples);
                gene = 0;
                for (int selected = 0; selected < numOfSelectedGenes; ++selected) {
                    if (selectedGenesArray[gene] == 1.0) {
                        for (int sample = 0; sample < this.numberOfSamples; ++sample) {
                            selectedExpMatrix.set(selected, sample, expMatrix.get(gene, sample));
                        }
                    }
                    ++gene;
                }
            } else {
                for (i = 0; i < this.numberOfGenes; ++i) {
                    this.reducedGeneSetForA2[leaveOutSample][0].add(new Integer(i));
                }
                selectedExpMatrix = new Matrix(this.numberOfGenes, this.numberOfSamples);
                selectedExpMatrix = expMatrix;
            }
            Matrix subSelectedExpMatrix = new Matrix(numOfSelectedGenes, this.numberOfSamples - 1);
            subSelectedExpMatrix = selectedExpMatrix.getMatrix(0, numOfSelectedGenes - 1, columnList);
            Matrix geneCompMatrix = selectedExpMatrix.getRowDimension() == this.kValue ? selectedExpMatrix : this.mplsAlgorithm(subSelectedExpMatrix, subResponseMatrix, selectedExpMatrix);
            this.geneComponentMatrix = geneCompMatrix;
            int numOfGenes = geneCompMatrix.getRowDimension();
            Matrix testMatrix = new Matrix(numOfGenes, 1);
            testMatrix = geneCompMatrix.getMatrix(0, numOfGenes - 1, leaveOutSample, leaveOutSample);
            Matrix subGeneCompMatrix = new Matrix(numOfGenes, this.numberOfSamples - 1);
            subGeneCompMatrix = geneCompMatrix.getMatrix(0, numOfGenes - 1, columnList);
            if (this.isPDA) {
                try {
                    this.beta = this.mleAlgorithm(subGeneCompMatrix, subResponseMatrix);
                }
                catch (AlgorithmException ex) {
                    this.singularMatrix[leaveOutSample] = true;
                    continue;
                }
                probFunction[leaveOutSample] = this.pdaAlgorithm(testMatrix);
                continue;
            }
            try {
                this.calculateQDAParameters(subGeneCompMatrix, subResponseMatrix);
            }
            catch (AlgorithmException ex) {
                this.singularMatrix[leaveOutSample] = true;
                continue;
            }
            probFunction[leaveOutSample] = this.qdaAlgorithm(testMatrix);
        }
        double max = 0.0;
        int maxClassId = 0;
        for (int leaveOutSample = 0; leaveOutSample < this.numberOfSamples; ++leaveOutSample) {
            if (this.singularMatrix[leaveOutSample]) continue;
            max = probFunction[leaveOutSample][0];
            maxClassId = 0;
            if (!Double.isNaN(probFunction[leaveOutSample][0])) {
                max = probFunction[leaveOutSample][0];
                maxClassId = 1;
                for (int classId = 0; classId < this.numberOfClasses; ++classId) {
                    if (!Double.isNaN(probFunction[leaveOutSample][classId])) {
                        if (!(probFunction[leaveOutSample][classId] > max)) continue;
                        max = probFunction[leaveOutSample][classId];
                        maxClassId = classId + 1;
                        continue;
                    }
                    maxClassId = 0;
                    classId = this.numberOfClasses;
                }
            } else {
                maxClassId = 0;
            }
            this.classified[maxClassId].add(new Integer(leaveOutSample));
        }
        return new Matrix(probFunction);
    }

    public double getTValue(int degreeOfFreedom, double alpha) {
        double[][] ttbl = new double[][]{{1.0, 6.314, 12.706, 31.821, 63.657, 636.619}, {2.0, 2.92, 4.303, 6.965, 9.925, 31.598}, {3.0, 2.353, 3.182, 4.541, 5.841, 12.941}, {4.0, 2.132, 2.776, 3.747, 4.604, 8.61}, {5.0, 2.015, 2.571, 3.365, 4.032, 6.859}, {6.0, 1.943, 2.447, 3.143, 3.707, 5.959}, {7.0, 1.895, 2.365, 2.998, 3.499, 5.405}, {8.0, 1.86, 2.306, 2.896, 3.355, 5.041}, {9.0, 1.833, 2.262, 2.821, 3.25, 4.781}, {10.0, 1.812, 2.228, 2.764, 3.169, 4.587}, {11.0, 1.796, 2.201, 2.718, 3.106, 4.437}, {12.0, 1.782, 2.179, 2.681, 3.055, 4.318}, {13.0, 1.771, 2.16, 2.65, 3.012, 4.221}, {14.0, 1.761, 2.145, 2.624, 2.997, 4.14}, {15.0, 1.753, 2.131, 2.602, 2.947, 4.073}, {16.0, 1.746, 2.12, 2.583, 2.921, 4.015}, {17.0, 1.74, 2.11, 2.567, 2.898, 3.965}, {18.0, 1.734, 2.101, 2.552, 2.878, 3.922}, {19.0, 1.729, 2.093, 2.539, 2.861, 3.883}, {20.0, 1.725, 2.086, 2.528, 2.845, 3.85}, {21.0, 1.721, 2.08, 2.518, 2.831, 3.819}, {22.0, 1.717, 2.074, 2.508, 2.819, 3.792}, {23.0, 1.714, 2.069, 2.5, 2.807, 3.767}, {24.0, 1.711, 2.064, 2.492, 2.797, 3.745}, {25.0, 1.708, 2.06, 2.485, 2.787, 3.725}, {26.0, 1.706, 2.056, 2.479, 2.779, 3.707}, {27.0, 1.703, 2.052, 2.473, 2.771, 3.69}, {28.0, 1.701, 2.048, 2.467, 2.763, 3.674}, {29.0, 1.699, 2.045, 2.462, 2.756, 3.659}, {30.0, 1.697, 2.042, 2.457, 2.75, 3.646}, {40.0, 1.684, 2.021, 2.423, 2.704, 3.551}, {60.0, 1.671, 2.0, 2.39, 2.66, 3.46}, {120.0, 1.658, 1.98, 2.358, 2.617, 3.373}, {1000.0, 1.645, 1.96, 2.326, 2.576, 3.291}};
        int row = 0;
        int column = 0;
        double error = 1.0E-5;
        if (Math.abs(alpha - 0.1) < error) {
            column = 1;
        } else if (Math.abs(alpha - 0.05) < error) {
            column = 2;
        } else if (Math.abs(alpha - 0.02) < error) {
            column = 3;
        } else if (Math.abs(alpha - 0.01) < error) {
            column = 4;
        } else if (Math.abs(alpha - 0.001) < error) {
            column = 5;
        } else {
            return -2.0;
        }
        if (degreeOfFreedom <= 0) {
            return -2.0;
        }
        if (degreeOfFreedom <= 30) {
            row = degreeOfFreedom - 1;
        } else if (degreeOfFreedom > 30 && degreeOfFreedom < 40) {
            row = 29;
        } else if (degreeOfFreedom >= 40 && degreeOfFreedom < 60) {
            row = 30;
        } else if (degreeOfFreedom >= 60 && degreeOfFreedom < 120) {
            row = 31;
        } else if (degreeOfFreedom >= 120 && degreeOfFreedom < 1000) {
            row = 32;
        } else if (degreeOfFreedom >= 1000) {
            row = 33;
        } else if (degreeOfFreedom <= 0) {
            // empty if block
        }
        return ttbl[row][column];
    }

    private Matrix getSampleMeans(Matrix expMatrix) {
        int numOfColumns = expMatrix.getColumnDimension();
        int numOfRows = expMatrix.getRowDimension();
        Matrix means = new Matrix(1, numOfColumns);
        double currentSum = 0.0;
        double currentMean = 0.0;
        int denominator = 0;
        for (int column = 0; column < numOfColumns; ++column) {
            currentSum = 0.0;
            denominator = 0;
            for (int row = 0; row < numOfRows; ++row) {
                double value = expMatrix.get(row, column);
                if (Double.isNaN(value)) continue;
                currentSum += value;
                ++denominator;
            }
            currentMean = currentSum / (double)denominator;
            means.set(0, column, currentMean);
        }
        return means;
    }

    private Matrix getSampleVariances(Matrix expMatrix, Matrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        Matrix variances = new Matrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(expMatrix, means));
            }
        }
        return variances;
    }

    private double getSampleNormalizedSum(Matrix expMatrix, Matrix means) {
        double sum = 0.0;
        double value = 0.0;
        int numOfGenes = expMatrix.getRowDimension();
        int numOfSamples = expMatrix.getColumnDimension();
        for (int sample = 0; sample < numOfSamples; ++sample) {
            double mean = means.get(0, sample);
            for (int row = 0; row < numOfGenes; ++row) {
                value = expMatrix.get(row, sample);
                if (Double.isNaN(value)) continue;
                sum += Math.pow(value - mean, 2.0);
                ++this.denominator;
            }
        }
        return sum;
    }

    private double getSampleVariance(Matrix expMatrix, Matrix means) {
        int denominator = 0;
        double sum = 0.0;
        double value = 0.0;
        int numOfSamples = expMatrix.getColumnDimension();
        int numOfGenes = expMatrix.getRowDimension();
        for (int sample = 0; sample < numOfSamples; ++sample) {
            double mean = means.get(0, sample);
            for (int row = 0; row < numOfGenes; ++row) {
                value = expMatrix.get(row, sample);
                if (Double.isNaN(value)) continue;
                sum += Math.pow(value - mean, 2.0);
                ++denominator;
            }
        }
        return Math.sqrt(sum / (double)(denominator - 1));
    }

    private Matrix getCovarianceMatrix(Matrix expMatrix, Matrix means) {
        int rows = expMatrix.getRowDimension();
        int columns = expMatrix.getColumnDimension();
        Matrix[] X = new Matrix[columns];
        for (int column = 0; column < columns; ++column) {
            X[column] = new Matrix(1, rows);
            X[column] = expMatrix.getMatrix(0, rows - 1, column, column).transpose();
        }
        Matrix covariance = new Matrix(rows, rows);
        for (int column = 0; column < columns; ++column) {
            covariance = covariance.plus(X[column].minus(means).transpose().times(X[column].minus(means)));
        }
        covariance = covariance.times(1.0 / (double)(columns - 1));
        return covariance;
    }

    private double getGroupMean(double[] group) {
        double sum = 0.0;
        int n = 0;
        for (int i = 0; i < group.length; ++i) {
            if (Double.isNaN(group[i])) continue;
            sum += group[i];
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        double mean = sum / (double)n;
        if (Double.isInfinite(mean)) {
            return Double.NaN;
        }
        return mean;
    }

    private boolean isFoundInVector(int element, Vector vect) {
        boolean found = false;
        for (int i = 0; i < vect.size(); ++i) {
            if (element != (Integer)vect.get(i)) continue;
            found = true;
            break;
        }
        return found;
    }

    public Matrix getJamaMatrix(FloatMatrix floatMatrix) {
        int rows = floatMatrix.getRowDimension();
        int columns = floatMatrix.getColumnDimension();
        double[][] values = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                values[i][j] = floatMatrix.A[i][j];
            }
        }
        Matrix jamaMatrix = new Matrix(values);
        return jamaMatrix;
    }

    public FloatMatrix getFloatMatrix(Matrix doubleMatrix) {
        int rows = doubleMatrix.getRowDimension();
        int columns = doubleMatrix.getColumnDimension();
        float[][] values = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                values[i][j] = (float)doubleMatrix.getArray()[i][j];
            }
        }
        FloatMatrix floatMatrix = new FloatMatrix(values);
        return floatMatrix;
    }

    private Matrix getMeansForGenes(Vector[] clusters) {
        Matrix means = new Matrix(clusters.length, this.numberOfSamples);
        for (int i = 0; i < clusters.length; ++i) {
            Matrix mean = this.getMeanForGenes(clusters[i]);
            means.setMatrix(i, i, 0, this.numberOfSamples - 1, mean);
        }
        return means;
    }

    private Matrix getMeanForGenes(Vector cluster) {
        Matrix mean = new Matrix(1, this.numberOfSamples);
        int n = cluster.size();
        int denom = 0;
        for (int i = 0; i < this.numberOfSamples; ++i) {
            double currentMean = 0.0;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                double value = this.expMatrix.get(((Integer)cluster.get(j)).intValue(), i);
                if (Double.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (double)denom);
        }
        return mean;
    }

    private Matrix getVariancesForGenes(Vector[] clusters, Matrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        Matrix variances = new Matrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getClusterVarianceForGenes(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private double getSampleNormalizedSumForGenes(Vector cluster, int column, double mean) {
        int size = cluster.size();
        double sum = 0.0;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            double value = this.expMatrix.get(((Integer)cluster.get(i)).intValue(), column);
            if (Double.isNaN(value)) continue;
            sum += Math.pow(value - mean, 2.0);
            ++this.validN;
        }
        return sum;
    }

    private double getClusterVarianceForGenes(Vector cluster, int column, double mean) {
        return Math.sqrt(this.getSampleNormalizedSumForGenes(cluster, column, mean) / (double)(this.validN - 1));
    }

    private Matrix getMeans(Vector[] clusters) {
        Matrix means = new Matrix(clusters.length, this.numberOfGenes);
        for (int i = 0; i < clusters.length; ++i) {
            Matrix mean = this.getMean(clusters[i]);
            means.setMatrix(i, i, 0, this.numberOfGenes - 1, mean);
        }
        return means;
    }

    private Matrix getMean(Vector cluster) {
        Matrix mean = new Matrix(1, this.numberOfGenes);
        int n = cluster.size();
        int denom = 0;
        for (int i = 0; i < this.numberOfGenes; ++i) {
            double currentMean = 0.0;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                double value = this.expMatrixTranspose.get(((Integer)cluster.get(j)).intValue(), i);
                if (Double.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (double)denom);
        }
        return mean;
    }

    private Matrix getVariances(Vector[] clusters, Matrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        Matrix variances = new Matrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getClusterVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private double getSampleNormalizedSum(Vector cluster, int column, double mean) {
        int size = cluster.size();
        double sum = 0.0;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            double value = this.expMatrixTranspose.get(((Integer)cluster.get(i)).intValue(), column);
            if (Double.isNaN(value)) continue;
            sum += Math.pow(value - mean, 2.0);
            ++this.validN;
        }
        return sum;
    }

    private double getClusterVariance(Vector cluster, int column, double mean) {
        return Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (double)(this.validN - 1));
    }

    private int[] convert2int(Vector source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (Integer)source.get(i);
        }
        return int_matrix;
    }

    private void printMatrix(Matrix matrix) {
        DecimalFormat df = new DecimalFormat("####.000000");
        for (int row = 0; row < matrix.getRowDimension(); ++row) {
            for (int column = 0; column < matrix.getColumnDimension(); ++column) {
                System.out.print(df.format(matrix.get(row, column)) + "  ");
            }
            System.out.println(" ");
        }
        System.out.println(" ");
        System.out.println(" ");
    }

    private void printMatrix(FloatMatrix matrix) {
        DecimalFormat df = new DecimalFormat("####.000000");
        for (int row = 0; row < matrix.getRowDimension(); ++row) {
            for (int column = 0; column < matrix.getColumnDimension(); ++column) {
                System.out.print(df.format(matrix.get(row, column)) + "  ");
            }
            System.out.println(" ");
        }
        System.out.println(" ");
        System.out.println(" ");
    }

    public void abort() {
        this.stop = true;
    }
}

