/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ProgressDialog;

public class CastClust
extends AbstractAlgorithm {
    private boolean stop = false;
    public boolean runInside = false;
    private int function;
    private float factor;
    private boolean absolute;
    private boolean castGenes;
    private FloatMatrix expMatrix;
    private FloatMatrix SimMatrix;
    private CTCluster unassigned;
    private CTCluster openCluster;
    private int CurrentCluster;
    private int m;
    private int n;
    private int maxGene;
    private int minGene;
    private float maxA;
    private float minA;
    private int maxIndex;
    private int minIndex;
    public int clusterCount;
    private boolean changesOccur;
    private boolean pearson = false;
    public float threshold = 0.5f;
    private long StartTime;
    private long CalculationTime;
    private boolean Stop;
    private int DistanceFunction;
    private ProgressDialog PD;
    private double zeroValue;
    private int hcl_function;
    private boolean hcl_absolute;
    int validN;

    public CastClust() {
    }

    public CastClust(boolean runInside) {
        this.runInside = runInside;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        this.clusterCount = 0;
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("distance-absolute", false);
        this.threshold = map.getFloat("threshold", 0.5f);
        this.castGenes = map.getBoolean("cast-cluster-genes", true);
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.expMatrix = data.getMatrix("experiment");
        this.n = this.expMatrix.getRowDimension();
        this.m = this.expMatrix.getColumnDimension();
        this.SimMatrix = new FloatMatrix(this.n, this.n);
        JFrame dummyFrame = new JFrame();
        this.PD = new ProgressDialog(dummyFrame, "CAST Progression", false, 4);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.PD.setSize(450, 255);
        this.PD.setLocation((screenDim.width - this.PD.getWidth()) / 2, (screenDim.height - this.PD.getHeight()) / 2);
        JButton abortButton = new JButton(" Cancel ");
        abortButton.setBorder(BorderFactory.createBevelBorder(0));
        abortButton.setFocusPainted(false);
        abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CastClust.this.stop = true;
                CastClust.this.PD.dismiss();
            }
        });
        JPanel progressPanel = this.PD.getLabelPanel();
        JPanel superPanel = new JPanel();
        superPanel.setLayout(new BorderLayout());
        superPanel.add((Component)progressPanel, "Center");
        superPanel.add((Component)abortButton, "South");
        this.PD.setMainPanel(superPanel);
        CTCluster[] clusters = this.calculate(this.runInside);
        for (int i = 0; i < clusters.length; ++i) {
            if (clusters[i] != null) continue;
            System.out.println("Null Cluster: " + i);
        }
        FloatMatrix means = this.getMeans(clusters);
        FloatMatrix variances = this.getVariances(clusters, means);
        AlgorithmEvent event = null;
        if (hierarchical_tree) {
            event = new AlgorithmEvent((Object)this, 1, clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(event);
            event.setIntValue(0);
            event.setId(2);
            this.fireValueChanged(event);
        }
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i = 0; i < clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.convert2int(clusters[i].genes);
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            event.setIntValue(i + 1);
            this.fireValueChanged(event);
        }
        AlgorithmData result = new AlgorithmData();
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", String.valueOf(clusters.length));
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        return result;
    }

    public void abort() {
        this.stop = true;
    }

    CTCluster[] calculate(boolean runInside) {
        int i;
        int i2;
        this.StartTime = System.currentTimeMillis();
        if (!runInside) {
            this.PD.setMessage(0, this.clusterCount + " clusters created.");
            if (this.castGenes) {
                this.PD.setMessage(1, "0 genes have been assigned to clusters.");
                this.PD.setMessage(2, this.n + " genes left to be assigned to clusters.");
            } else {
                this.PD.setMessage(1, "0 experiments have been assigned to clusters.");
                this.PD.setMessage(2, this.n + " experiments left to be assigned to clusters.");
            }
            this.PD.setTimerLabel(3, "Running for ", " seconds.", 1000);
            this.PD.setVisible(true);
        }
        this.getSimMatrix();
        CTCluster[] clusters = new CTCluster[this.n];
        this.unassigned = new CTCluster();
        for (i2 = 0; i2 < this.n; ++i2) {
            this.unassigned.add(i2);
        }
        while (this.unassigned.count != 0) {
            this.openCluster = new CTCluster();
            for (i2 = 0; i2 < this.unassigned.count; ++i2) {
                this.unassigned.affinity.set(i2, new Float(0.0f));
            }
            do {
                this.changesOccur = false;
                while (this.getMaxAffinityGene() && this.maxA >= this.threshold * (float)this.openCluster.count) {
                    this.unassigned.move(this.maxIndex, this.openCluster);
                    for (i = 0; i < this.unassigned.count; ++i) {
                        float theFloat = ((Float)this.unassigned.affinity.elementAt(i)).floatValue();
                        this.unassigned.affinity.setElementAt(new Float(theFloat += this.SimMatrix.get(((Integer)this.unassigned.genes.elementAt(i)).intValue(), this.maxGene)), i);
                    }
                    for (i = 0; i < this.openCluster.count; ++i) {
                        float theFloat = ((Float)this.openCluster.affinity.elementAt(i)).floatValue();
                        this.openCluster.affinity.setElementAt(new Float(theFloat += this.SimMatrix.get(((Integer)this.openCluster.genes.elementAt(i)).intValue(), this.maxGene)), i);
                    }
                    this.changesOccur = true;
                    this.getMaxAffinityGene();
                }
                if ((double)this.minA == this.zeroValue) continue;
                while (this.getMinAffinityGene() && this.minA < this.threshold * (float)this.openCluster.count) {
                    this.openCluster.move(this.minIndex, this.unassigned);
                    for (i = 0; i < this.unassigned.count; ++i) {
                        float theFloat = ((Float)this.unassigned.affinity.elementAt(i)).floatValue();
                        this.unassigned.affinity.setElementAt(new Float(theFloat -= this.SimMatrix.get(((Integer)this.unassigned.genes.elementAt(i)).intValue(), this.minGene)), i);
                    }
                    for (i = 0; i < this.openCluster.count; ++i) {
                        float theFloat = ((Float)this.openCluster.affinity.elementAt(i)).floatValue();
                        this.openCluster.affinity.setElementAt(new Float(theFloat -= this.SimMatrix.get(((Integer)this.openCluster.genes.elementAt(i)).intValue(), this.minGene)), i);
                    }
                    this.changesOccur = true;
                    this.getMinAffinityGene();
                }
            } while (this.changesOccur);
            if (!runInside) {
                this.PD.setMessage(0, this.clusterCount + " clusters created.");
                if (this.castGenes) {
                    this.PD.setMessage(1, this.n - this.unassigned.count + " genes have been assigned to clusters.");
                    this.PD.setMessage(2, this.unassigned.count + " genes left to be assigned to clusters.");
                } else {
                    this.PD.setMessage(1, this.n - this.unassigned.count + " experiments have been assigned to clusters.");
                    this.PD.setMessage(2, this.unassigned.count + " experiments left to be assigned to clusters.");
                }
            }
            if (this.clusterCount < this.n) {
                clusters[this.clusterCount++] = this.openCluster;
            }
            this.openCluster = null;
        }
        if (!runInside) {
            this.PD.dismiss();
        }
        CTCluster[] trueClusters = new CTCluster[this.clusterCount];
        for (i = 0; i < this.clusterCount; ++i) {
            trueClusters[i] = clusters[i];
        }
        this.CalculationTime = System.currentTimeMillis() - this.StartTime;
        return trueClusters;
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.castGenes ? this.getSubExperiment(this.expMatrix, features) : this.getSubExperimentReducedCols(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (Integer)source.get(i);
        }
        return int_matrix;
    }

    synchronized float getDistance(int gene1, int gene2) {
        double distance = 0.0;
        if (this.function == 0 || this.function == 2 || this.function == 3 || this.function == 4 || this.function == 5 || this.function == 8 || this.function == 9 || this.function == 10 || this.function == 11) {
            distance = ExperimentUtil.geneDistance(this.expMatrix, null, gene1, gene2, 4, this.factor, this.absolute);
        } else if (this.function == 1 || this.function == 6 || this.function == 7) {
            distance = this.absolute ? (double)Math.abs(ExperimentUtil.geneDistance(this.expMatrix, null, gene1, gene2, 1, this.factor, this.absolute)) : (double)ExperimentUtil.geneDistance(this.expMatrix, null, gene1, gene2, 1, this.factor, this.absolute);
        }
        return (float)distance;
    }

    synchronized void getSimMatrix() {
        float maxSim = 0.0f;
        if (this.function == 1 || this.function == 6 || this.function == 7) {
            this.pearson = true;
        }
        this.zeroValue = this.absolute ? 0.0 : 0.5;
        if (this.pearson) {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    float sim = this.getDistance(i, j);
                    sim = !this.absolute ? (float)(1.0 - ((double)sim + 1.0) / 2.0) : (float)(((double)sim + 1.0) / 2.0);
                    this.SimMatrix.set(i, j, sim);
                }
            }
        } else {
            float sim;
            int j;
            int i;
            for (i = 0; i < this.n; ++i) {
                for (j = 0; j < this.n; ++j) {
                    sim = this.getDistance(i, j);
                    if (!(sim > maxSim)) continue;
                    maxSim = sim;
                }
            }
            for (i = 0; i < this.n; ++i) {
                for (j = 0; j < this.n; ++j) {
                    sim = this.getDistance(i, j);
                    sim = 1.0f - sim / maxSim;
                    this.SimMatrix.set(i, j, sim);
                }
            }
        }
    }

    protected boolean getMaxAffinityGene() {
        if (this.unassigned.count == 0) {
            return false;
        }
        this.maxIndex = 0;
        this.maxA = ((Float)this.unassigned.affinity.elementAt(0)).floatValue();
        for (int i = 1; i < this.unassigned.count; ++i) {
            if (!(((Float)this.unassigned.affinity.elementAt(i)).floatValue() > this.maxA)) continue;
            this.maxA = ((Float)this.unassigned.affinity.elementAt(i)).floatValue();
            this.maxIndex = i;
        }
        this.maxGene = (Integer)this.unassigned.genes.elementAt(this.maxIndex);
        return true;
    }

    protected boolean getMinAffinityGene() {
        if (this.openCluster.count == 0) {
            return false;
        }
        this.minIndex = 0;
        this.minA = ((Float)this.openCluster.affinity.elementAt(0)).floatValue();
        for (int i = 1; i < this.openCluster.count; ++i) {
            if (!(((Float)this.openCluster.affinity.elementAt(i)).floatValue() < this.minA)) continue;
            this.minA = ((Float)this.openCluster.affinity.elementAt(i)).floatValue();
            this.minIndex = i;
        }
        this.minGene = (Integer)this.openCluster.genes.elementAt(this.minIndex);
        return true;
    }

    private FloatMatrix getMeans(CTCluster[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.m);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = clusters[i].getMean();
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getVariances(CTCluster[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleNormalizedSum(CTCluster cluster, int column, float mean) {
        int size = cluster.genes.size();
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(((Integer)cluster.genes.get(i)).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float getSampleVariance(CTCluster cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    private class CTCluster {
        int count = 0;
        Vector genes = new Vector();
        Vector affinity = new Vector();

        public Vector fGenes() {
            Vector<Float> floatVector = new Vector<Float>();
            for (int i = 0; i < this.genes.size(); ++i) {
                floatVector.addElement(new Float(((Integer)this.genes.elementAt(i)).intValue()));
            }
            return floatVector;
        }

        public void add(int g) {
            this.add(g, 0.0f);
        }

        public void add(int g, float a) {
            this.genes.add(this.count, new Integer(g));
            this.affinity.add(this.count, new Float(a));
            ++this.count;
        }

        public void remove(int g) {
            int index = -1;
            for (int i = 1; i <= this.count; ++i) {
                if ((Integer)this.genes.elementAt(i) != g) continue;
                index = i;
                break;
            }
            if (index == -1) {
                System.err.println("cluster doesn't contain " + g);
                System.exit(1);
            }
            this.removeIndex(index);
        }

        public void removeIndex(int index) {
            this.genes.remove(index);
            this.affinity.remove(index);
            --this.count;
        }

        public void move(int index, CTCluster c) {
            c.add((Integer)this.genes.elementAt(index), ((Float)this.affinity.elementAt(index)).floatValue());
            this.removeIndex(index);
        }

        protected FloatMatrix getMean() {
            FloatMatrix mean = new FloatMatrix(1, CastClust.this.m);
            int k = this.genes.size();
            for (int i = 0; i < CastClust.this.m; ++i) {
                float currentMean = 0.0f;
                int denom = 0;
                for (int j = 0; j < k; ++j) {
                    float value = CastClust.this.expMatrix.get(((Integer)this.genes.get(j)).intValue(), i);
                    if (Float.isNaN(value)) continue;
                    currentMean += value;
                    ++denom;
                }
                mean.set(0, i, currentMean / (float)denom);
            }
            return mean;
        }
    }
}

