/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class COA
extends AbstractAlgorithm {
    private boolean stop = false;
    public FloatMatrix Org;
    private int numNeighbors;
    private float factor = 1.0f;
    public Matrix N;
    public double[] R;
    public double[] C;
    public double N_Sum = 0.0;
    public double[][] P;
    public Matrix X;
    public Matrix Xt;
    public Matrix DcRoot;
    public Matrix Dr;
    public Matrix B;
    public Matrix geneUMatrix;
    public Matrix exptUMatrix;
    public FloatMatrix gene;
    public FloatMatrix expt;
    public double[] G_Sums;
    public Matrix G;
    private int numGenes;
    private int numExps;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.numNeighbors = map.getInt("numNeighbors", 10);
        this.Org = data.getMatrix("experiment");
        this.numGenes = this.Org.getRowDimension();
        this.numExps = this.Org.getColumnDimension();
        AlgorithmData result = this.Analysis(this.Org);
        return result;
    }

    public Matrix diagonal(double[] A) {
        int i;
        System.out.println("Entered diagonal method");
        Matrix D = new Matrix(A.length, A.length);
        System.out.println("Created diagonal matrix");
        for (i = 0; i < D.getRowDimension(); ++i) {
            for (int j = 0; j < D.getColumnDimension(); ++j) {
                D.set(i, j, 0.0);
            }
        }
        for (i = 0; i < D.getRowDimension(); ++i) {
            D.set(i, i, Math.sqrt(A[i]));
        }
        return D;
    }

    public Matrix diagonalRoot(double[] A) {
        int i;
        Matrix D = new Matrix(A.length, A.length);
        for (i = 0; i < D.getRowDimension(); ++i) {
            for (int j = 0; j < D.getColumnDimension(); ++j) {
                D.set(i, j, 0.0);
            }
        }
        for (i = 0; i < D.getRowDimension(); ++i) {
            D.set(i, i, A[i]);
        }
        return D;
    }

    public double mean(double[] p) {
        double sum = 0.0;
        for (int i = 0; i < p.length; ++i) {
            sum += p[i];
        }
        return sum / (double)p.length;
    }

    private FloatMatrix imputeKNearestMatrix(FloatMatrix inputMatrix, int k) throws AlgorithmException {
        int numRows = inputMatrix.getRowDimension();
        int numCols = inputMatrix.getColumnDimension();
        FloatMatrix resultMatrix = new FloatMatrix(numRows, numCols);
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        event.setDescription("Imputing missing values");
        this.fireValueChanged(event);
        event.setId(2);
        for (int i = 0; i < numRows; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            if (this.isMissingValues(inputMatrix, i)) {
                Vector<Integer> nonMissingExpts = new Vector<Integer>();
                for (int j = 0; j < numCols; ++j) {
                    if (Float.isNaN(inputMatrix.A[i][j])) continue;
                    nonMissingExpts.add(new Integer(j));
                }
                Vector geneSubset = this.getValidGenes(i, inputMatrix, nonMissingExpts);
                Vector kNearestGenes = this.getKNearestGenes(i, k, inputMatrix, geneSubset, nonMissingExpts);
                for (int j = 0; j < numCols; ++j) {
                    resultMatrix.A[i][j] = !Float.isNaN(inputMatrix.A[i][j]) ? inputMatrix.A[i][j] : this.getExptWeightedMean(i, j, kNearestGenes, inputMatrix);
                }
                continue;
            }
            for (int j = 0; j < numCols; ++j) {
                resultMatrix.A[i][j] = inputMatrix.A[i][j];
            }
        }
        return this.imputeRowAverageMatrix(resultMatrix);
    }

    private FloatMatrix imputeRowAverageMatrix(FloatMatrix inputMatrix) throws AlgorithmException {
        int numRows = inputMatrix.getRowDimension();
        int numCols = inputMatrix.getColumnDimension();
        FloatMatrix resultMatrix = new FloatMatrix(numRows, numCols);
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(event);
        event.setId(2);
        for (int i = 0; i < numRows; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            float[] currentRow = new float[numCols];
            float[] currentOrigRow = new float[numCols];
            for (int j = 0; j < numCols; ++j) {
                currentRow[j] = inputMatrix.A[i][j];
                currentOrigRow[j] = inputMatrix.A[i][j];
            }
            for (int k = 0; k < numCols; ++k) {
                if (!Float.isNaN(inputMatrix.A[i][k])) continue;
                currentRow[k] = this.getMean(currentOrigRow);
            }
            for (int l = 0; l < numCols; ++l) {
                resultMatrix.A[i][l] = currentRow[l];
            }
        }
        return resultMatrix;
    }

    private boolean isMissingValues(FloatMatrix mat, int row) {
        for (int i = 0; i < mat.getColumnDimension(); ++i) {
            if (!Float.isNaN(mat.A[row][i])) continue;
            return true;
        }
        return false;
    }

    private Vector getValidGenes(int gene, FloatMatrix mat, Vector validExpts) {
        Vector<Integer> validGenes = new Vector<Integer>();
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            if (!this.hasAllExpts(i, mat, validExpts) || gene == i) continue;
            validGenes.add(new Integer(i));
        }
        if (validGenes.size() < this.numNeighbors) {
            int additionalGenesNeeded = this.numNeighbors - validGenes.size();
            Vector additionalGenes = this.getAdditionalGenes(gene, additionalGenesNeeded, validGenes, mat);
            for (int i = 0; i < additionalGenes.size(); ++i) {
                validGenes.add((Integer)additionalGenes.get(i));
            }
        }
        return validGenes;
    }

    private Vector getAdditionalGenes(int currentGene, int numGenesNeeded, Vector alreadyPresentGenes, FloatMatrix mat) {
        Vector<Integer> additionalGenes = new Vector<Integer>();
        Vector<Integer> allGenes = new Vector<Integer>();
        Vector<Float> geneDistances = new Vector<Float>();
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            if (i == currentGene) continue;
            float currentDistance = ExperimentUtil.geneEuclidianDistance(mat, null, i, currentGene, this.factor);
            geneDistances.add(new Float(currentDistance));
            allGenes.add(new Integer(i));
        }
        float[] geneDistancesArray = new float[geneDistances.size()];
        for (int i = 0; i < geneDistances.size(); ++i) {
            float currentDist;
            geneDistancesArray[i] = currentDist = ((Float)geneDistances.get(i)).floatValue();
        }
        QSort sortGeneDistances = new QSort(geneDistancesArray);
        float[] sortedDistances = sortGeneDistances.getSorted();
        int[] sortedDistanceIndices = sortGeneDistances.getOrigIndx();
        int counter = 0;
        for (int i = 0; i < sortedDistanceIndices.length; ++i) {
            int currentIndex = sortedDistanceIndices[i];
            int currentNearestGene = (Integer)allGenes.get(currentIndex);
            if (this.belongsIn(alreadyPresentGenes, currentNearestGene)) continue;
            additionalGenes.add(new Integer(currentNearestGene));
            if (++counter >= numGenesNeeded) break;
        }
        return additionalGenes;
    }

    public void groups(int[][] selections, int numGroups) {
        int i;
        this.G = new Matrix(this.N.getRowDimension(), numGroups);
        this.G_Sums = new double[numGroups];
        for (i = 0; i < numGroups; ++i) {
            int j;
            double[][] sub = this.N.getMatrix(0, this.N.getRowDimension() - 1, selections[i]).getArrayCopy();
            for (j = 0; j < this.G.getRowDimension(); ++j) {
                this.G.set(j, i, this.mean(sub[j]));
            }
            for (j = 0; j < selections[i].length; ++j) {
                int n = i;
                this.G_Sums[n] = this.G_Sums[n] + this.C[selections[i][j]];
            }
        }
        System.out.println("G:");
        for (i = 0; i < this.G.getRowDimension(); ++i) {
            for (int j = 0; j < this.G.getColumnDimension(); ++j) {
                System.out.println("i: " + i + " , j: " + j + " , " + this.G.get(i, j));
            }
        }
        System.out.println();
        System.out.println("G_Sums:");
        for (i = 0; i < this.G_Sums.length; ++i) {
            System.out.println("i: " + i + " , " + this.G_Sums[i]);
        }
        System.out.println();
    }

    public AlgorithmData Analysis(FloatMatrix input) throws AlgorithmException {
        double currVal;
        int j;
        int i;
        int x;
        int i2;
        int j2;
        int i3;
        input = this.imputeKNearestMatrix(input, this.numNeighbors);
        this.N = new Matrix(input.getRowDimension(), input.getColumnDimension());
        boolean negFound = false;
        block0: for (i3 = 0; i3 < input.getRowDimension() && !negFound; ++i3) {
            for (j2 = 0; j2 < input.getColumnDimension(); ++j2) {
                if (!(input.get(i3, j2) < 0.0f)) continue;
                negFound = true;
                continue block0;
            }
        }
        if (negFound) {
            float min = Float.POSITIVE_INFINITY;
            for (int i4 = 0; i4 < input.getRowDimension(); ++i4) {
                for (int j3 = 0; j3 < input.getColumnDimension(); ++j3) {
                    min = Math.min(min, input.get(i4, j3));
                }
            }
            double additionFactor = -1.0 * (double)min;
            for (int i5 = 0; i5 < input.getRowDimension(); ++i5) {
                for (int j4 = 0; j4 < input.getColumnDimension(); ++j4) {
                    this.N.set(i5, j4, (double)input.get(i5, j4) + additionFactor);
                }
            }
        } else {
            for (i3 = 0; i3 < input.getRowDimension(); ++i3) {
                for (j2 = 0; j2 < input.getColumnDimension(); ++j2) {
                    this.N.set(i3, j2, (double)input.get(i3, j2));
                }
            }
        }
        for (i2 = 0; i2 < this.N.getRowDimension(); ++i2) {
            for (int j5 = 0; j5 < this.N.getColumnDimension(); ++j5) {
                this.N_Sum += this.N.get(i2, j5);
            }
        }
        this.R = new double[this.N.getRowDimension()];
        for (i2 = 0; i2 < this.N.getRowDimension(); ++i2) {
            double N_iSum = 0.0;
            for (x = 0; x < this.N.getColumnDimension(); ++x) {
                N_iSum += this.N.get(i2, x);
            }
            this.R[i2] = N_iSum / this.N_Sum;
        }
        this.C = new double[this.N.getColumnDimension()];
        for (int j6 = 0; j6 < this.N.getColumnDimension(); ++j6) {
            double N_jSum = 0.0;
            for (x = 0; x < this.N.getRowDimension(); ++x) {
                N_jSum += this.N.get(x, j6);
            }
            this.C[j6] = N_jSum / this.N_Sum;
        }
        this.P = new double[this.N.getRowDimension()][this.N.getColumnDimension()];
        this.X = new Matrix(this.N.getRowDimension(), this.N.getColumnDimension());
        for (i2 = 0; i2 < this.N.getRowDimension(); ++i2) {
            for (int j7 = 0; j7 < this.N.getColumnDimension(); ++j7) {
                this.P[i2][j7] = this.N.get(i2, j7) / this.N_Sum;
                double xValue = (this.P[i2][j7] - this.R[i2] * this.C[j7]) / Math.sqrt(this.R[i2] * this.C[j7]);
                this.X.set(i2, j7, xValue);
            }
        }
        SingularValueDecomposition svd = new SingularValueDecomposition(this.X);
        Matrix U = svd.getU();
        Matrix Lambda = svd.getS();
        Matrix V = svd.getV();
        this.geneUMatrix = U.times(Lambda);
        this.exptUMatrix = V.times(Lambda);
        for (i = 0; i < this.geneUMatrix.getRowDimension(); ++i) {
            for (j = 0; j < this.geneUMatrix.getColumnDimension(); ++j) {
                currVal = this.geneUMatrix.get(i, j);
                this.geneUMatrix.set(i, j, currVal / Math.sqrt(this.R[i]));
            }
        }
        for (i = 0; i < this.exptUMatrix.getRowDimension(); ++i) {
            for (j = 0; j < this.exptUMatrix.getColumnDimension(); ++j) {
                currVal = this.exptUMatrix.get(i, j);
                this.exptUMatrix.set(i, j, currVal / Math.sqrt(this.C[i]));
            }
        }
        this.gene = new FloatMatrix(this.geneUMatrix.getRowDimension(), this.geneUMatrix.getColumnDimension());
        for (i = 0; i < this.gene.getRowDimension(); ++i) {
            for (j = 0; j < this.gene.getColumnDimension(); ++j) {
                this.gene.set(i, j, (float)this.geneUMatrix.get(i, j));
            }
        }
        this.expt = new FloatMatrix(this.exptUMatrix.getRowDimension(), this.exptUMatrix.getColumnDimension());
        for (i = 0; i < this.expt.getRowDimension(); ++i) {
            for (j = 0; j < this.expt.getColumnDimension(); ++j) {
                this.expt.set(i, j, (float)this.exptUMatrix.get(i, j));
            }
        }
        FloatMatrix lambdaValues = new FloatMatrix(Lambda.getRowDimension(), 1);
        for (int i6 = 0; i6 < Lambda.getRowDimension(); ++i6) {
            lambdaValues.set(i6, 0, (float)Lambda.get(i6, i6));
        }
        AlgorithmData result = new AlgorithmData();
        result.addMatrix("gene", this.gene);
        result.addMatrix("expt", this.expt);
        result.addMatrix("lambdaValues", lambdaValues);
        return result;
    }

    Vector getKNearestGenes(int gene, int k, FloatMatrix mat, Vector geneSubset, Vector nonMissingExpts) {
        Vector<Integer> allValidGenes = new Vector<Integer>();
        Vector<Integer> nearestGenes = new Vector<Integer>();
        Vector<Float> geneDistances = new Vector<Float>();
        for (int i = 0; i < geneSubset.size(); ++i) {
            int currentGene = (Integer)geneSubset.get(i);
            if (gene == currentGene) continue;
            float currentDistance = ExperimentUtil.geneEuclidianDistance(mat, null, gene, currentGene, this.factor);
            geneDistances.add(new Float(currentDistance));
            allValidGenes.add(new Integer(currentGene));
        }
        float[] geneDistancesArray = new float[geneDistances.size()];
        for (int i = 0; i < geneDistances.size(); ++i) {
            float currentDist;
            geneDistancesArray[i] = currentDist = ((Float)geneDistances.get(i)).floatValue();
        }
        QSort sortGeneDistances = new QSort(geneDistancesArray);
        float[] sortedDistances = sortGeneDistances.getSorted();
        int[] sortedDistanceIndices = sortGeneDistances.getOrigIndx();
        for (int i = 0; i < k; ++i) {
            int currentGeneIndex = sortedDistanceIndices[i];
            int currentNearestGene = (Integer)allValidGenes.get(currentGeneIndex);
            nearestGenes.add(new Integer(currentNearestGene));
        }
        return nearestGenes;
    }

    private float getExptWeightedMean(int gene, int expt, Vector geneVector, FloatMatrix mat) {
        float weightedMean = 0.0f;
        int validN = 0;
        float numerator = 0.0f;
        float[] recipNeighborDistances = new float[geneVector.size()];
        for (int i = 0; i < recipNeighborDistances.length; ++i) {
            int currentGene = (Integer)geneVector.get(i);
            if (!Float.isNaN(mat.A[currentGene][expt])) {
                float distance = ExperimentUtil.geneEuclidianDistance(mat, null, gene, currentGene, this.factor);
                if (distance == 0.0f) {
                    distance = Float.MIN_VALUE;
                }
                recipNeighborDistances[i] = 1.0f / distance;
                numerator += recipNeighborDistances[i] * mat.A[currentGene][expt];
                ++validN;
                continue;
            }
            recipNeighborDistances[i] = 0.0f;
        }
        float denominator = 0.0f;
        for (int i = 0; i < recipNeighborDistances.length; ++i) {
            denominator += recipNeighborDistances[i];
        }
        weightedMean = numerator / denominator;
        return weightedMean;
    }

    private float getMean(float[] row) {
        float mean = 0.0f;
        int validN = 0;
        for (int i = 0; i < row.length; ++i) {
            if (Float.isNaN(row[i])) continue;
            mean += row[i];
            ++validN;
        }
        if (validN == 0) {
            validN = 1;
        }
        return mean /= (float)validN;
    }

    private boolean hasAllExpts(int gene, FloatMatrix mat, Vector validExpts) {
        for (int i = 0; i < validExpts.size(); ++i) {
            int expIndex = (Integer)validExpts.get(i);
            if (!Float.isNaN(mat.A[gene][expIndex])) continue;
            return false;
        }
        return true;
    }

    private boolean belongsIn(Vector geneVector, int gene) {
        for (int i = 0; i < geneVector.size(); ++i) {
            int currentGene = (Integer)geneVector.get(i);
            if (gene != currentGene) continue;
            return true;
        }
        return false;
    }
}

