/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.rosuda.JRI.Rengine;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.GraphViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ResultDataTable;
import org.tigr.rhook.RHook;
import org.tigr.util.FloatMatrix;

public class CLVALID
extends AbstractAlgorithm {
    private int progress;
    private FloatMatrix expMatrix;
    private boolean stop = false;
    private AlgorithmEvent event;
    private String[] geneNames;
    private String[] sampleNames;
    private boolean isInternalV;
    private boolean isStabilityV;
    private boolean isBiologicalV;
    private boolean isClusterGenes;
    private int lowClusterRange;
    private int highClusterRange;
    private double[] measuresIntern;
    private double[] measuresStab;
    private double[] measuresBio;
    private String[] methodsArray;
    private String linkageMethod;
    private String distanceMetric;
    private String bioCAnnotation;
    private HashMap<String, Object> optimalScoresIntern = new HashMap();
    private HashMap<String, Object> optimalScoresStab = new HashMap();
    private HashMap<String, Object> optimalScoresBio = new HashMap();
    private int[] subCluster;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        this.expMatrix = data.getMatrix("experiment");
        this.geneNames = data.getStringArray("geneLabels");
        this.sampleNames = data.getStringArray("sampleLabels");
        this.methodsArray = data.getStringArray("methodsArray");
        this.subCluster = data.getIntArray("subCluster");
        AlgorithmParameters map = data.getParams();
        this.isClusterGenes = map.getBoolean("cluster-genes");
        this.isInternalV = map.getBoolean("internal-validation");
        this.isStabilityV = map.getBoolean("stability-validation");
        this.isBiologicalV = map.getBoolean("biological-validation");
        this.lowClusterRange = map.getInt("cluster-range-low");
        this.highClusterRange = map.getInt("cluster-range-high");
        this.linkageMethod = map.getString("validation-linkage");
        this.distanceMetric = map.getString("validation-distance");
        this.bioCAnnotation = map.getString("bioC-annotation");
        this.progress = 0;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Calculating...");
        this.fireValueChanged(this.event);
        this.event.setId(3);
        this.event.setDescription("description");
        this.fireValueChanged(this.event);
        this.event.setId(5);
        this.event.setDescription("description");
        this.fireValueChanged(this.event);
        this.event.setId(4);
        this.event.setDescription("description");
        this.fireValueChanged(this.event);
        this.runRAlg();
        if (this.stop) {
            throw new AbortException();
        }
        data.addResultNode("validation-node", this.createResultNode());
        return data;
    }

    private DefaultMutableTreeNode createResultNode() {
        int i;
        double[][][] dataMatrices;
        int numMeasures;
        String[] measures;
        DefaultMutableTreeNode ivNode;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Validation");
        int numClusters = this.highClusterRange - this.lowClusterRange + 1;
        int numMethods = this.methodsArray.length;
        if (this.isInternalV) {
            ivNode = new DefaultMutableTreeNode("Internal Validation");
            measures = new String[]{"Connectivity", "Silhouette Width", "Dunn Index"};
            numMeasures = measures.length;
            dataMatrices = this.createDataMatrices(this.measuresIntern, numClusters, numMeasures, numMethods);
            ivNode.add(new DefaultMutableTreeNode(new LeafInfo("Optimal Cluster Scores", (IViewer)new ResultDataTable(this.optimalScoresIntern, measures))));
            for (i = 0; i < measures.length; ++i) {
                ivNode.add(new DefaultMutableTreeNode(new LeafInfo(measures[i], (IViewer)new GraphViewer("Internal Validation", dataMatrices[i], this.methodsArray, "Number of Clusters", "Cluster ", measures[i], "", this.lowClusterRange))));
            }
            node.add(ivNode);
        }
        if (this.isStabilityV) {
            ivNode = new DefaultMutableTreeNode("Stability Validation");
            measures = new String[]{"Avg. Proportion Non-Overlap", "Avg. Distance", "Avg. Distance Between Means", "Figure of Merit"};
            numMeasures = measures.length;
            dataMatrices = this.createDataMatrices(this.measuresStab, numClusters, numMeasures, numMethods);
            ivNode.add(new DefaultMutableTreeNode(new LeafInfo("Optimal Cluster Scores", (IViewer)new ResultDataTable(this.optimalScoresStab, measures))));
            for (i = 0; i < measures.length; ++i) {
                ivNode.add(new DefaultMutableTreeNode(new LeafInfo(measures[i], (IViewer)new GraphViewer("Stability Validation", dataMatrices[i], this.methodsArray, "Number of Clusters", "Cluster ", measures[i], "", this.lowClusterRange))));
            }
            node.add(ivNode);
        }
        if (this.isBiologicalV) {
            ivNode = new DefaultMutableTreeNode("Biological Validation");
            measures = new String[]{"Biological Homogeneity Index", "Biological Stability Index"};
            numMeasures = measures.length;
            dataMatrices = this.createDataMatrices(this.measuresBio, numClusters, numMeasures, numMethods);
            ivNode.add(new DefaultMutableTreeNode(new LeafInfo("Optimal Cluster Scores", (IViewer)new ResultDataTable(this.optimalScoresBio, measures))));
            for (i = 0; i < measures.length; ++i) {
                ivNode.add(new DefaultMutableTreeNode(new LeafInfo(measures[i], (IViewer)new GraphViewer("Biological Validation", dataMatrices[i], this.methodsArray, "Number of Clusters", "Cluster ", measures[i], "", this.lowClusterRange))));
            }
            node.add(ivNode);
        }
        return node;
    }

    private double[][][] createDataMatrices(double[] measures, int numClusters, int numMeasures, int numMethods) {
        if (measures.length != numClusters * numMeasures * numMethods) {
            return null;
        }
        int index = 0;
        double[][][] res = new double[numMeasures][numMethods][numClusters];
        for (int i = 0; i < numMethods; ++i) {
            for (int j = 0; j < numClusters; ++j) {
                for (int k = 0; k < numMeasures; ++k) {
                    res[k][i][j] = measures[index];
                    ++index;
                }
            }
        }
        return res;
    }

    public void runRAlg() throws AbortException {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        try {
            Rengine re = RHook.startRSession();
            if (re == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            throw new AbortException();
        }
        try {
            int numRows;
            String filePath;
            RHook.testPackage((String)"clvalid");
            RHook.log((String)"Starting R Algorithim");
            String rCmd = "library(clValid)";
            RHook.evalR((String)rCmd);
            rCmd = "zz <- file('all.Rout', open='wt')";
            RHook.evalR((String)rCmd);
            rCmd = "sink(zz)";
            RHook.evalR((String)rCmd);
            rCmd = "sink(zz, type='message')";
            RHook.evalR((String)rCmd);
            String fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "tmpfile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            if (this.isClusterGenes) {
                filePath = this.writeMatrixToFile(fileLoc, this.expMatrix, this.geneNames, this.subCluster);
                RHook.createRDataMatrixFromFile((String)"y", (String)filePath, (boolean)true, (String[])this.sampleNames);
                numRows = this.geneNames.length;
            } else {
                filePath = this.writeMatrixToFile(fileLoc, this.expMatrix.transpose(), this.sampleNames, this.subCluster);
                RHook.createRDataMatrixFromFile((String)"y", (String)filePath, (boolean)true, (String[])this.geneNames);
                numRows = this.sampleNames.length;
            }
            String methodsString = this.getMethodsString();
            try {
                if (this.isInternalV) {
                    this.measuresIntern = this.runRScriptValidationStep(methodsString, this.optimalScoresIntern, "internal", this.measuresIntern, numRows);
                }
                if (this.isStabilityV) {
                    this.measuresStab = this.runRScriptValidationStep(methodsString, this.optimalScoresStab, "stability", this.measuresStab, numRows);
                }
                if (this.isBiologicalV) {
                    this.runRScriptBioValidationStep(methodsString, numRows);
                }
            }
            catch (Exception e) {
                if (numRows > 9999) {
                    JOptionPane.showMessageDialog(null, "Error running CLVALID.\nTry reducing the size of your dataset or running the analysis with a smaller cluster.", "REngine", 0);
                }
                throw new AbortException();
            }
            rCmd = "sink()";
            RHook.endRSession();
            this.removeTmps(filePath);
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
                throw new AbortException();
            }
            catch (Exception e1) {
                throw new AbortException();
            }
        }
    }

    private void runRScriptBioValidationStep(String methodsString, int numRows) throws Exception {
        String rCmd = "source('http://www.bioconductor.org/biocLite.R')";
        RHook.evalR((String)rCmd);
        rCmd = "biocLite('" + this.bioCAnnotation + "')";
        RHook.evalR((String)rCmd);
        rCmd = "library(" + this.bioCAnnotation + ")";
        RHook.evalR((String)rCmd);
        rCmd = "if(require('Biobase') && require('annotate') && require('GO.db') && require('" + this.bioCAnnotation + "')) {" + "bio2 <- clValid(y, " + this.lowClusterRange + ":" + this.highClusterRange + ", clMethods=c(" + methodsString + "), metric = '" + this.distanceMetric + "', method = '" + this.linkageMethod + "', validation='biological', annotation='" + this.bioCAnnotation + "',GOcategory='all', maxitems=" + numRows + ")}";
        RHook.evalR((String)rCmd);
        rCmd = "optimalScores(bio2)";
        RHook.evalR((String)rCmd);
        rCmd = "bio2@measures";
        this.measuresBio = RHook.evalR((String)rCmd).asDoubleArray();
        this.optimalScoresBio = new HashMap();
        rCmd = "as.matrix(optimalScores(bio2)[1])";
        this.optimalScoresBio.put("scores", RHook.evalR((String)rCmd).asDoubleArray());
        rCmd = "as.matrix(optimalScores(bio2)[2])";
        this.optimalScoresBio.put("method", RHook.evalR((String)rCmd).asStringArray());
        rCmd = "as.matrix(optimalScores(bio2)[3])";
        this.optimalScoresBio.put("clusters", RHook.evalR((String)rCmd).asStringArray());
        this.optimalScoresBio.put("numMeasures", 2);
    }

    private double[] runRScriptValidationStep(String methodsString, HashMap<String, Object> optimalScores, String validationType, double[] measuresIntern, int numRows) throws Exception {
        String rCmd = "results <- clValid(y, " + this.lowClusterRange + ":" + this.highClusterRange + ", clMethods=c(" + methodsString + "), metric = '" + this.distanceMetric + "', method = '" + this.linkageMethod + "',  validation='" + validationType + "', maxitems=" + numRows + ")";
        String tryCatchBlock = "        tryCatch({" + rCmd + "}, error=function(e) {" + "   print(e)" + "\t}) ";
        RHook.evalR((String)tryCatchBlock);
        rCmd = "summary(results)";
        RHook.evalR((String)rCmd);
        rCmd = "results@measures";
        measuresIntern = RHook.evalR((String)rCmd).asDoubleArray();
        rCmd = "as.matrix(optimalScores(results)[1])";
        optimalScores.put("scores", RHook.evalR((String)rCmd).asDoubleArray());
        rCmd = "as.matrix(optimalScores(results)[2])";
        optimalScores.put("method", RHook.evalR((String)rCmd).asStringArray());
        rCmd = "as.matrix(optimalScores(results)[3])";
        optimalScores.put("clusters", RHook.evalR((String)rCmd).asStringArray());
        optimalScores.put("numMeasures", 3);
        return measuresIntern;
    }

    private String getMethodsString() {
        String methodsString = "";
        for (int i = 0; i < this.methodsArray.length; ++i) {
            methodsString = methodsString + "'" + this.methodsArray[i] + "',";
        }
        if (methodsString.length() > 0) {
            methodsString = methodsString.substring(0, methodsString.length() - 1);
        }
        return methodsString;
    }

    private String writeMatrixToFile(String fileLoc, FloatMatrix fm, String[] rowNames, int[] subCluster) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
            int row = fm.getRowDimension();
            int col = fm.getColumnDimension();
            String srtVector = "";
            if (subCluster == null) {
                for (int iRow = 0; iRow < row; ++iRow) {
                    srtVector = rowNames[iRow] + "\t";
                    for (int jCol = 0; jCol < col; ++jCol) {
                        srtVector = jCol == col - 1 ? srtVector + fm.get(iRow, jCol) + "\n" : srtVector + fm.get(iRow, jCol) + "\t";
                    }
                    out.write(srtVector);
                    srtVector = "";
                }
            } else {
                for (int iRow = 0; iRow < subCluster.length; ++iRow) {
                    srtVector = rowNames[subCluster[iRow]] + "\t";
                    for (int jCol = 0; jCol < col; ++jCol) {
                        srtVector = jCol == col - 1 ? srtVector + fm.get(subCluster[iRow], jCol) + "\n" : srtVector + fm.get(subCluster[iRow], jCol) + "\t";
                    }
                    out.write(srtVector);
                    srtVector = "";
                }
            }
            out.close();
        }
        catch (IOException e) {
            return null;
        }
        return fileLoc;
    }

    public void updateProgressBar() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / (this.progress + 7));
    }

    private void removeTmps(String fileName) {
        File f = new File(fileName);
        f.delete();
    }
}

