/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.util.FloatMatrix;

public class BETR
extends AbstractAlgorithm {
    private int progress;
    private FloatMatrix expMatrix;
    private FloatMatrix filteredExpMatrix;
    private boolean stop = false;
    private int[] timeAssignments;
    private int[] conditionAssignments;
    private int[][] conditionsMatrix;
    private int[][] sigGenesArrays = new int[2][];
    private int[] errorGenesArray = new int[0];
    private int[] errorGenesArray2 = new int[0];
    private int[] mapping;
    private int[] mapping2;
    private int numGenes;
    private int numExps;
    private int numTimePoints;
    private int iteration;
    private boolean drawSigTreesOnly;
    private int hcl_function;
    private boolean hcl_absolute;
    private boolean hcl_genes_ordered;
    private boolean hcl_samples_ordered;
    private int dataDesign;
    private AlgorithmEvent event;
    int validN;
    private static float[] lanczos = new float[]{1.0f, 57.156235f, -59.59796f, 14.136098f, -0.49191383f, 3.399465E-5f, 4.652363E-5f, -9.8374476E-5f, 1.580887E-4f, -2.1026444E-4f, 2.1743962E-4f, -1.643181E-4f, 8.441822E-5f, -2.6190839E-5f, 3.6899182E-6f};
    private static final float HALF_LOG_2_PI = 0.5f * (float)Math.log(Math.PI * 2);
    private int numTreatReps = 3;
    private int numConReps = 3;
    private float p = 0.05f;
    private float alpha;
    private float[] I;
    private FloatMatrix[] varianceError;
    private FloatMatrix[] varianceMean;
    private FloatMatrix[] Shmg;
    private FloatMatrix[] Sheg;
    private Experiment XTreat = new Experiment(null, null, null);
    private Experiment XControl = new Experiment(null, null, null);
    private Experiment XTreatAverage = new Experiment(null, null, null);
    private Experiment XControlAverage = new Experiment(null, null, null);
    private Experiment Y = new Experiment(null, null, null);

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        int i2;
        this.expMatrix = data.getMatrix("experiment");
        this.mapping = new int[this.expMatrix.getRowDimension()];
        for (i2 = 0; i2 < this.mapping.length; ++i2) {
            this.mapping[i2] = i2;
        }
        this.mapping2 = new int[this.expMatrix.getRowDimension()];
        for (i2 = 0; i2 < this.mapping2.length; ++i2) {
            this.mapping2[i2] = i2;
        }
        this.timeAssignments = data.getIntArray("time_assignments");
        this.conditionAssignments = data.getIntArray("condition_assignments");
        AlgorithmParameters map = data.getParams();
        this.dataDesign = map.getInt("dataDesign");
        this.conditionsMatrix = data.getIntMatrix("conditions-matrix");
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        this.hcl_genes_ordered = map.getBoolean("hcl-genes-ordered", false);
        this.hcl_samples_ordered = map.getBoolean("hcl-samples-ordered", false);
        this.numTimePoints = map.getInt("numTimePoints");
        if (this.dataDesign == 1) {
            --this.numTimePoints;
        }
        this.alpha = map.getFloat("alpha-value");
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        if (hierarchical_tree) {
            this.drawSigTreesOnly = map.getBoolean("draw-sig-trees-only");
        }
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.progress = 0;
        this.event = null;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Initializing...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        this.initializeExperiments();
        this.runAlg();
        if (this.stop) {
            throw new AbortException();
        }
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        if (this.dataDesign == 1) {
            ++this.numTimePoints;
        }
        FloatMatrix means = this.getMeans(this.sigGenesArrays);
        FloatMatrix variances = this.getVariances(this.sigGenesArrays, means);
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i3 = 0; i3 < this.sigGenesArrays.length; ++i3) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.sigGenesArrays[i3];
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            if (this.drawSigTreesOnly) {
                if (i3 != 0) continue;
                node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
                this.event.setIntValue(i3 + 1);
                this.fireValueChanged(this.event);
                continue;
            }
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            this.event.setIntValue(i3 + 1);
            this.fireValueChanged(this.event);
        }
        int[][] sigReturn = new int[this.sigGenesArrays.length][];
        for (int i4 = 0; i4 < this.sigGenesArrays.length; ++i4) {
            sigReturn[i4] = new int[this.sigGenesArrays[i4].length];
            for (int j = 0; j < this.sigGenesArrays[i4].length; ++j) {
                sigReturn[i4][j] = this.mapping2[this.mapping[this.sigGenesArrays[i4][j]]];
            }
        }
        ArrayList<Integer> tmpal = new ArrayList<Integer>();
        for (i = 0; i < this.errorGenesArray.length; ++i) {
            if (tmpal.contains(this.mapping2[this.errorGenesArray[i]])) continue;
            tmpal.add(this.mapping2[this.errorGenesArray[i]]);
        }
        for (i = 0; i < this.errorGenesArray2.length; ++i) {
            if (tmpal.contains(this.errorGenesArray2[i])) continue;
            tmpal.add(this.errorGenesArray2[i]);
        }
        int[] errReturn = new int[tmpal.size()];
        for (int i5 = 0; i5 < errReturn.length; ++i5) {
            errReturn[i5] = (Integer)tmpal.get(i5);
        }
        AlgorithmData result = new AlgorithmData();
        result.addIntMatrix("sigGenesArrays", (int[][])sigReturn);
        result.addParam("error-length", String.valueOf(this.errorGenesArray.length + this.errorGenesArray2.length));
        result.addParam("iterations", String.valueOf(this.iteration - 1));
        result.addIntArray("error-genes", errReturn);
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", "1");
        result.addMatrix("clusters_means", means);
        result.addMatrix("clusters_variances", variances);
        result.addMatrix("geneTimeMeansMatrix", this.getAllGeneTimeMeans());
        result.addMatrix("geneTimeSDsMatrix", this.getAllGeneTimeSDs());
        if (this.dataDesign == 2) {
            result.addMatrix("geneConditionMeansMatrix", this.getAllGeneConditionMeans());
            result.addMatrix("geneConditionSDsMatrix", this.getAllGeneConditionSDs());
        }
        result.addMatrix("pValues", this.getPValues());
        return result;
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.getSubExperiment(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            data.addParam("optimize-gene-ordering", String.valueOf(this.hcl_genes_ordered));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            data.addParam("optimize-sample-ordering", String.valueOf(this.hcl_samples_ordered));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getMeans(int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.numExps);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getMean(int[] cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.numExps);
        int n = cluster.length;
        int denom = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(Integer.valueOf(cluster[j]).intValue(), i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    private FloatMatrix getVariances(int[][] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleVariance(int[] cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    private float getSampleNormalizedSum(int[] cluster, int column, float mean) {
        int size = cluster.length;
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(Integer.valueOf(cluster[i]).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float[] getGeneGroupMeans(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numTimePoints][];
        for (int i = 0; i < this.numTimePoints; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupMeans = new float[this.numTimePoints];
        for (int i = 0; i < this.numTimePoints; ++i) {
            geneGroupMeans[i] = this.getMean(geneValuesByGroups[i]);
        }
        return geneGroupMeans;
    }

    private float[] getGeneConditionMeans(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByCondition = new float[2][];
        for (int i = 0; i < 2; ++i) {
            geneValuesByCondition[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupMeans = new float[2];
        for (int i = 0; i < 2; ++i) {
            geneGroupMeans[i] = this.getMean(geneValuesByCondition[i]);
        }
        return geneGroupMeans;
    }

    private float[] getGeneGroupSDs(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numTimePoints][];
        for (int i = 0; i < this.numTimePoints; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupSDs = new float[this.numTimePoints];
        for (int i = 0; i < this.numTimePoints; ++i) {
            geneGroupSDs[i] = this.getStdDev(geneValuesByGroups[i]);
        }
        return geneGroupSDs;
    }

    private float[] getGeneConditionSDs(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[2][];
        for (int i = 0; i < 2; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForCondition(geneValues, i + 1);
        }
        float[] geneGroupSDs = new float[2];
        for (int i = 0; i < 2; ++i) {
            geneGroupSDs[i] = this.getStdDev(geneValuesByGroups[i]);
        }
        return geneGroupSDs;
    }

    private float[] getGeneValuesForGroup(float[] geneValues, int group) {
        Vector<Float> groupValuesVector = new Vector<Float>();
        for (int i = 0; i < this.timeAssignments.length; ++i) {
            if (this.timeAssignments[i] != group) continue;
            groupValuesVector.add(new Float(geneValues[i]));
        }
        float[] groupGeneValues = new float[groupValuesVector.size()];
        for (int i = 0; i < groupValuesVector.size(); ++i) {
            groupGeneValues[i] = ((Float)groupValuesVector.get(i)).floatValue();
        }
        return groupGeneValues;
    }

    private float[] getGeneValuesForCondition(float[] geneValues, int condition) {
        Vector<Float> groupValuesVector = new Vector<Float>();
        for (int i = 0; i < this.conditionAssignments.length; ++i) {
            if (this.conditionAssignments[i] != condition) continue;
            groupValuesVector.add(new Float(geneValues[i]));
        }
        float[] groupGeneValues = new float[groupValuesVector.size()];
        for (int i = 0; i < groupValuesVector.size(); ++i) {
            groupGeneValues[i] = ((Float)groupValuesVector.get(i)).floatValue();
        }
        return groupGeneValues;
    }

    private FloatMatrix getAllGeneTimeMeans() {
        FloatMatrix means = new FloatMatrix(this.numGenes, this.numTimePoints);
        for (int i = 0; i < means.getRowDimension(); ++i) {
            means.A[i] = this.getGeneGroupMeans(i);
        }
        return means;
    }

    private FloatMatrix getAllGeneConditionMeans() {
        FloatMatrix means = new FloatMatrix(this.numGenes, 2);
        for (int i = 0; i < means.getRowDimension(); ++i) {
            means.A[i] = this.getGeneConditionMeans(i);
        }
        return means;
    }

    private FloatMatrix getAllGeneTimeSDs() {
        FloatMatrix sds = new FloatMatrix(this.numGenes, this.numTimePoints);
        for (int i = 0; i < sds.getRowDimension(); ++i) {
            sds.A[i] = this.getGeneGroupSDs(i);
        }
        return sds;
    }

    private FloatMatrix getAllGeneConditionSDs() {
        FloatMatrix sds = new FloatMatrix(this.numGenes, 2);
        for (int i = 0; i < sds.getRowDimension(); ++i) {
            sds.A[i] = this.getGeneConditionSDs(i);
        }
        return sds;
    }

    private FloatMatrix getPValues() {
        FloatMatrix pvals = new FloatMatrix(this.numGenes, 1);
        for (int i = 0; i < this.mapping.length; ++i) {
            pvals.A[this.mapping2[this.mapping[i]]][0] = 1.0f - this.I[i];
        }
        return pvals;
    }

    private float getMean(float[] group) {
        float sum = 0.0f;
        int n = 0;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sum += group[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float mean = sum / (float)n;
        if (Float.isInfinite(mean)) {
            return Float.NaN;
        }
        return mean;
    }

    private float getStdDev(float[] group) {
        float mean = this.getMean(group);
        int n = 0;
        float sumSquares = 0.0f;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sumSquares = (float)((double)sumSquares + Math.pow(group[i] - mean, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float var = sumSquares / (float)(n - 1);
        if (Float.isInfinite(var)) {
            return Float.NaN;
        }
        return (float)Math.sqrt(var);
    }

    public void initializeExperiments() {
        int k;
        int totals;
        int i;
        float value;
        int k2;
        int j;
        FloatMatrix XTreatAve;
        this.filteredExpMatrix = this.expMatrix.getMatrix(this.mapping2, 0, this.expMatrix.getColumnDimension() - 1).getMatrix(this.mapping, 0, this.expMatrix.getColumnDimension() - 1);
        this.numGenes = this.filteredExpMatrix.getRowDimension();
        this.numExps = this.filteredExpMatrix.getColumnDimension();
        if (this.dataDesign == 1) {
            XTreatAve = new FloatMatrix(this.numGenes, this.numTimePoints);
            for (int i2 = 0; i2 < this.numTimePoints; ++i2) {
                for (j = 0; j < this.numGenes; ++j) {
                    float s = 0.0f;
                    int totals2 = 0;
                    for (k2 = 0; k2 < this.timeAssignments.length; ++k2) {
                        if (this.timeAssignments[k2] - 1 != i2 + 1 || Float.isNaN(value = this.filteredExpMatrix.get(j, k2))) continue;
                        s += value;
                        ++totals2;
                    }
                    XTreatAve.set(j, i2, s / (float)totals2);
                }
            }
            FloatMatrix XControlAve = new FloatMatrix(this.numGenes, this.numTimePoints);
            for (i = 0; i < this.numTimePoints; ++i) {
                for (int j2 = 0; j2 < this.numGenes; ++j2) {
                    float s = 0.0f;
                    totals = 0;
                    for (k = 0; k < this.timeAssignments.length; ++k) {
                        float value2;
                        if (this.timeAssignments[k] - 1 != 0 || Float.isNaN(value2 = this.filteredExpMatrix.get(j2, k))) continue;
                        s += value2;
                        ++totals;
                    }
                    XControlAve.set(j2, i, s / (float)totals);
                }
            }
            this.XTreatAverage.fillMatrix(XTreatAve);
            this.XControlAverage.fillMatrix(XControlAve);
            this.Y.fillMatrix(XTreatAve.minus(XControlAve));
        }
        if (this.dataDesign == 3) {
            XTreatAve = new FloatMatrix(this.numGenes, this.numTimePoints);
            for (int i3 = 0; i3 < this.numTimePoints; ++i3) {
                for (j = 0; j < this.numGenes; ++j) {
                    float s = 0.0f;
                    int totals3 = 0;
                    for (k2 = 0; k2 < this.timeAssignments.length; ++k2) {
                        if (this.timeAssignments[k2] - 1 != i3 || Float.isNaN(value = this.filteredExpMatrix.get(j, k2))) continue;
                        s += value;
                        ++totals3;
                    }
                    XTreatAve.set(j, i3, s / (float)totals3);
                }
            }
            this.Y.fillMatrix(XTreatAve);
        }
        if (this.dataDesign == 2) {
            this.XTreat.fillMatrix(this.filteredExpMatrix.getMatrix(0, this.numGenes - 1, this.conditionsMatrix[0]));
            this.XControl.fillMatrix(this.filteredExpMatrix.getMatrix(0, this.numGenes - 1, this.conditionsMatrix[1]));
            XTreatAve = new FloatMatrix(this.numGenes, this.numTimePoints);
            for (int i4 = 0; i4 < this.numTimePoints; ++i4) {
                for (j = 0; j < this.numGenes; ++j) {
                    float s = 0.0f;
                    int totals4 = 0;
                    for (k2 = 0; k2 < this.timeAssignments.length; ++k2) {
                        float value3;
                        if (this.timeAssignments[k2] - 1 != i4 || this.conditionAssignments[k2] - 1 != 0 || Float.isNaN(value3 = this.filteredExpMatrix.get(j, k2))) continue;
                        s += value3;
                        ++totals4;
                    }
                    XTreatAve.set(j, i4, s / (float)totals4);
                }
            }
            FloatMatrix XControlAve = new FloatMatrix(this.numGenes, this.numTimePoints);
            for (i = 0; i < this.numTimePoints; ++i) {
                for (int j3 = 0; j3 < this.numGenes; ++j3) {
                    float s = 0.0f;
                    totals = 0;
                    for (k = 0; k < this.timeAssignments.length; ++k) {
                        float value4;
                        if (this.timeAssignments[k] - 1 != i || this.conditionAssignments[k] - 1 != 1 || Float.isNaN(value4 = this.filteredExpMatrix.get(j3, k))) continue;
                        s += value4;
                        ++totals;
                    }
                    XControlAve.set(j3, i, s / (float)totals);
                }
            }
            this.XTreatAverage.fillMatrix(XTreatAve);
            this.XControlAverage.fillMatrix(XControlAve);
            this.Y.fillMatrix(XTreatAve.minus(XControlAve));
        }
    }

    public void runAlg() {
        int i;
        int i2;
        int i3;
        if (this.mapping.length < 2) {
            this.stop = true;
            JOptionPane.showMessageDialog(null, "Not enough valid genes", "Error", 2);
        }
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(10);
        this.fireValueChanged(this.event);
        float seg = 0.0f;
        this.varianceError = new FloatMatrix[this.numGenes];
        this.varianceMean = new FloatMatrix[this.numGenes];
        this.Sheg = new FloatMatrix[this.numGenes];
        this.Shmg = new FloatMatrix[this.numGenes];
        boolean foundBadData = false;
        ArrayList<Integer> badData = new ArrayList<Integer>();
        for (int i4 = 0; i4 < this.numGenes; ++i4) {
            int ii;
            this.varianceError[i4] = new FloatMatrix(this.numTimePoints, this.numTimePoints);
            this.varianceMean[i4] = new FloatMatrix(this.numTimePoints, this.numTimePoints);
            for (ii = 0; ii < this.numTimePoints + 1; ++ii) {
                for (int sample = 0; sample < this.numExps; ++sample) {
                    float value;
                    if (this.timeAssignments[sample] - 1 != ii || Float.isNaN(value = this.filteredExpMatrix.get(i4, sample))) continue;
                    if (this.dataDesign == 1) {
                        seg = this.timeAssignments[sample] - 1 == 0 ? (seg += (float)Math.pow(this.filteredExpMatrix.get(i4, sample) - this.XControlAverage.get(i4, ii), 2.0)) : (seg += (float)Math.pow(this.filteredExpMatrix.get(i4, sample) - this.XTreatAverage.get(i4, ii - 1), 2.0));
                    }
                    if (this.dataDesign == 2) {
                        if (this.conditionAssignments[sample] == 1) {
                            seg += (float)Math.pow(this.filteredExpMatrix.get(i4, sample) - this.XTreatAverage.get(i4, ii), 2.0);
                        }
                        if (this.conditionAssignments[sample] == 2) {
                            seg += (float)Math.pow(this.filteredExpMatrix.get(i4, sample) - this.XControlAverage.get(i4, ii), 2.0);
                        }
                    }
                    if (this.dataDesign != 3) continue;
                    seg += (float)Math.pow(this.filteredExpMatrix.get(i4, sample) - this.Y.get(i4, ii), 2.0);
                }
            }
            for (ii = 0; ii < this.numTimePoints; ++ii) {
                for (int iii = 0; iii < this.numTimePoints; ++iii) {
                    this.varianceMean[i4].set(ii, iii, this.Y.get(i4, ii) * this.Y.get(i4, iii));
                    if (Float.isNaN(this.Y.get(i4, ii) * this.Y.get(i4, iii))) {
                        badData.add(i4);
                        foundBadData = true;
                    }
                    this.varianceError[i4].set(ii, iii, 0.0f);
                }
            }
            if (this.dataDesign == 1) {
                seg /= (float)((this.numTimePoints + 1) * (this.numTreatReps - 1));
            }
            if (this.dataDesign == 2) {
                seg /= (float)(this.numTimePoints * (2 * (this.numTreatReps - 1)));
            }
            if (this.dataDesign == 3) {
                seg /= (float)(this.numTimePoints * (this.numTreatReps - 1));
            }
            if (seg == 0.0f) {
                badData.add(i4);
                foundBadData = true;
            }
            for (ii = 0; ii < this.numTimePoints; ++ii) {
                this.varianceError[i4].set(ii, ii, seg);
            }
            seg = 0.0f;
        }
        if (foundBadData) {
            int i5;
            Object[] options = new String[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(null, "The data you are running contains groups of NaNs.\nTo remove these genes and restart the analysis, click 'Continue'", "Warning", 1, 2, null, options, options[0]) == 1) {
                this.stop = true;
            }
            if (this.stop) {
                return;
            }
            ArrayList<Integer> map = new ArrayList<Integer>();
            for (i5 = 0; i5 < this.numGenes; ++i5) {
                map.add(i5);
            }
            map.removeAll(badData);
            this.mapping2 = new int[map.size()];
            this.mapping = new int[this.mapping2.length];
            for (i5 = 0; i5 < map.size(); ++i5) {
                this.mapping2[i5] = (Integer)map.get(i5);
                this.mapping[i5] = i5;
            }
            this.errorGenesArray2 = new int[badData.size()];
            for (i5 = 0; i5 < this.errorGenesArray2.length; ++i5) {
                this.errorGenesArray2[i5] = (Integer)badData.get(i5);
            }
            this.initializeExperiments();
            this.runAlg();
            return;
        }
        if (this.stop) {
            return;
        }
        FloatMatrix SeBar = new FloatMatrix(this.numTimePoints, this.numTimePoints);
        float sume = 0.0f;
        for (int ii = 0; ii < this.numTimePoints; ++ii) {
            for (int iii = 0; iii < this.numTimePoints; ++iii) {
                for (int i6 = 0; i6 < this.numGenes; ++i6) {
                    sume += this.varianceError[i6].get(ii, iii);
                }
                SeBar.set(ii, iii, sume / (float)this.numGenes);
                sume = 0.0f;
            }
        }
        float totalnue = 0.0f;
        float totalmti = 0.0f;
        float ebar = 0.0f;
        float[] eg = new float[this.numGenes];
        float dg = 0.0f;
        if (this.dataDesign == 1) {
            dg = (this.numTreatReps - 1) * (this.numTimePoints + 1);
        }
        if (this.dataDesign == 2) {
            dg = 2 * (this.numTreatReps - 1) * this.numTimePoints;
        }
        if (this.dataDesign == 3) {
            dg = (this.numTreatReps - 1) * this.numTimePoints;
        }
        for (i3 = 0; i3 < this.numGenes; ++i3) {
            eg[i3] = (float)(Math.log(this.varianceError[i3].get(0, 0)) - (double)BETR.diGamma(dg / 2.0f) + Math.log(dg / 2.0f));
        }
        for (i3 = 0; i3 < this.numGenes; ++i3) {
            ebar += eg[i3];
        }
        ebar /= (float)this.numGenes;
        for (i3 = 0; i3 < this.numGenes; ++i3) {
            totalmti = totalmti + (float)Math.pow(eg[i3] - ebar, 2.0) * (float)this.numGenes / (float)(this.numGenes - 1) - BETR.triGamma(dg / 2.0f);
        }
        float d0 = 2.0f * this.trigammaInverse(totalmti / (float)this.numGenes);
        float s0 = (float)Math.exp((double)(ebar + BETR.diGamma(d0 / 2.0f)) - Math.log(d0 / 2.0f));
        float[] segtilde = new float[this.numGenes];
        for (i2 = 0; i2 < this.numGenes; ++i2) {
            segtilde[i2] = (d0 * s0 + dg * this.varianceError[i2].get(0, 0)) / (d0 + dg);
        }
        this.updateProgressBar();
        this.fireValueChanged(this.event);
        for (i2 = 0; i2 < this.numGenes; ++i2) {
            this.Sheg[i2] = new FloatMatrix(this.numTimePoints, this.numTimePoints);
            for (int j = 0; j < this.numTimePoints; ++j) {
                this.Sheg[i2].set(j, j, segtilde[i2]);
            }
        }
        for (int t = 0; t < this.numTimePoints; ++t) {
            totalnue += d0;
        }
        float[] f0mvnd = new float[this.numGenes];
        for (int i7 = 0; i7 < this.numGenes; ++i7) {
            FloatMatrix Yg = new FloatMatrix(this.numTimePoints, 1);
            for (int yi = 0; yi < this.numTimePoints; ++yi) {
                Yg.set(yi, 0, this.Y.get(i7, yi));
            }
            f0mvnd[i7] = this.multivariateNormalFunction(this.Sheg[i7].times((float)(this.numConReps + this.numTreatReps) / (float)(this.numConReps * this.numTreatReps)), Yg);
        }
        ArrayList<Integer> diffGenes = new ArrayList<Integer>();
        ArrayList<Integer> nonDiffGenes = new ArrayList<Integer>();
        ArrayList<Integer> errorGenes = new ArrayList<Integer>();
        diffGenes.add(1);
        ArrayList diffGenesOld = new ArrayList();
        this.iteration = 1;
        while (true) {
            int i8;
            int i9;
            int k;
            this.event.setDescription("Running Shrinkage Loop. Iteration #" + this.iteration);
            this.updateProgressBar();
            this.fireValueChanged(this.event);
            ++this.iteration;
            FloatMatrix SBar = new FloatMatrix(this.numTimePoints, this.numTimePoints);
            float sum = 0.0f;
            for (int ii = 0; ii < this.numTimePoints; ++ii) {
                for (int iii = 0; iii < this.numTimePoints; ++iii) {
                    for (int i10 = 0; i10 < diffGenes.size(); ++i10) {
                        sum += this.varianceMean[(Integer)diffGenes.get(i10)].get(ii, iii);
                    }
                    SBar.set(ii, iii, sum / (float)diffGenes.size());
                    sum = 0.0f;
                }
            }
            float totalnu = 0.0f;
            float[] d0t = new float[this.numTimePoints];
            for (k = 0; k < this.numTimePoints; ++k) {
                this.updateProgressBar();
                this.fireValueChanged(this.event);
                float totalmtim = 0.0f;
                float ebarm = 0.0f;
                for (int i11 = 0; i11 < diffGenes.size(); ++i11) {
                    ebarm += this.varianceMean[i11].get(k, k);
                }
                ebarm /= (float)diffGenes.size();
                float dgm = 0.0f;
                if (this.dataDesign == 1) {
                    dgm = (this.numTreatReps - 1) * (this.numTimePoints + 1);
                }
                if (this.dataDesign == 2) {
                    dgm = 2 * (this.numTreatReps - 1) * this.numTimePoints;
                }
                if (this.dataDesign == 3) {
                    dgm = (this.numTreatReps - 1) * this.numTimePoints;
                }
                float[] egm = new float[diffGenes.size()];
                for (i9 = 0; i9 < diffGenes.size(); ++i9) {
                    egm[i9] = (float)(Math.log(this.varianceMean[i9].get(k, k)) - (double)BETR.diGamma(dgm / 2.0f) + Math.log(dgm / 2.0f));
                }
                for (i9 = 0; i9 < diffGenes.size(); ++i9) {
                    ebarm += egm[i9];
                }
                ebarm /= (float)this.numGenes;
                for (i9 = 0; i9 < diffGenes.size(); ++i9) {
                    totalmtim = totalmtim + (float)Math.pow(egm[i9] - ebarm, 2.0) * (float)diffGenes.size() / (float)(diffGenes.size() - 1) - BETR.triGamma(dgm / 2.0f);
                }
                d0t[k] = 2.0f * this.trigammaInverse(totalmtim / (float)diffGenes.size());
            }
            for (k = 0; k < this.numTimePoints; ++k) {
                totalnu += d0t[k];
            }
            float nu = totalnu / (float)this.numTimePoints;
            float tempnu = Math.max(nu, (float)(this.numTimePoints + 6));
            FloatMatrix lambda = SBar.times((tempnu - (float)this.numTimePoints - 1.0f) / tempnu);
            for (int i12 = 0; i12 < this.numGenes; ++i12) {
                this.Shmg[i12] = this.varianceMean[i12].plus(lambda.times(nu)).times(1.0f / (1.0f + nu));
            }
            float[] f1mvnd = new float[this.numGenes];
            FloatMatrix Yg = new FloatMatrix(this.numTimePoints, 1);
            for (i9 = 0; i9 < this.numGenes; ++i9) {
                for (int yi = 0; yi < this.numTimePoints; ++yi) {
                    Yg.set(yi, 0, this.Y.get(i9, yi));
                }
                f1mvnd[i9] = this.multivariateNormalFunction(this.Shmg[i9].plus(this.Sheg[i9].times((float)(this.numConReps + this.numTreatReps) / (float)(this.numConReps * this.numTreatReps))), Yg);
            }
            for (int yi = 0; yi < this.numTimePoints; ++yi) {
                Yg.set(yi, 0, this.Y.get(0, yi));
            }
            this.I = new float[this.numGenes];
            for (i9 = 0; i9 < this.numGenes; ++i9) {
                this.I[i9] = f1mvnd[i9] * this.p / (f0mvnd[i9] * (1.0f - this.p) + f1mvnd[i9] * this.p);
            }
            diffGenes.clear();
            nonDiffGenes.clear();
            errorGenes.clear();
            boolean founderror = false;
            for (int i13 = 0; i13 < this.numGenes; ++i13) {
                if (1.0f - this.I[i13] < this.alpha) {
                    diffGenes.add(i13);
                    continue;
                }
                if (Float.isNaN(this.I[i13])) {
                    errorGenes.add(i13);
                    founderror = true;
                    continue;
                }
                nonDiffGenes.add(i13);
            }
            if (founderror) {
                int i14;
                Object[] options = new String[]{"Continue", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "The data you are running contains invalid data.\nTo remove the invalid genes and re-run the analysis, click 'Continue'", "Warning", 1, 2, null, options, options[0]) == 1) {
                    this.stop = true;
                }
                if (this.stop) {
                    return;
                }
                ArrayList<Integer> map = new ArrayList<Integer>();
                for (i14 = 0; i14 < this.numGenes; ++i14) {
                    map.add(i14);
                }
                map.removeAll(errorGenes);
                this.mapping = new int[map.size()];
                for (i14 = 0; i14 < map.size(); ++i14) {
                    this.mapping[i14] = (Integer)map.get(i14);
                }
                this.errorGenesArray = new int[errorGenes.size()];
                for (i14 = 0; i14 < this.errorGenesArray.length; ++i14) {
                    this.errorGenesArray[i14] = (Integer)errorGenes.get(i14);
                }
                this.initializeExperiments();
                this.runAlg();
                return;
            }
            boolean sameresult = false;
            if (diffGenes.size() == diffGenesOld.size()) {
                for (i8 = 0; i8 < diffGenes.size(); ++i8) {
                    sameresult = true;
                    if (((Integer)diffGenes.get(i8)).equals(diffGenesOld.get(i8))) continue;
                    sameresult = false;
                    break;
                }
            }
            if (diffGenes.size() == 0 || sameresult || this.stop) break;
            diffGenesOld.clear();
            for (i8 = 0; i8 < diffGenes.size(); ++i8) {
                diffGenesOld.add(diffGenes.get(i8));
            }
            this.p = Math.max((float)diffGenesOld.size() / (float)this.numGenes, 1.0f / (float)this.numGenes);
        }
        this.sigGenesArrays[0] = new int[diffGenes.size()];
        this.sigGenesArrays[1] = new int[nonDiffGenes.size()];
        for (i = 0; i < this.sigGenesArrays[0].length; ++i) {
            this.sigGenesArrays[0][i] = (Integer)diffGenes.get(i);
        }
        for (i = 0; i < this.sigGenesArrays[1].length; ++i) {
            this.sigGenesArrays[1][i] = (Integer)nonDiffGenes.get(i);
        }
    }

    public void updateProgressBar() {
        ++this.progress;
        this.event.setId(2);
        this.event.setIntValue(100 * this.progress / (this.progress + 7));
    }

    public float multivariateNormalFunction(FloatMatrix coMat, FloatMatrix Yg) {
        return (float)(1.0 / Math.pow(Math.PI * 2, Yg.getRowDimension() / 2) * Math.pow(coMat.det(), -0.5) * Math.exp(Yg.transpose().times(coMat.inverse().times(Yg)).get(0, 0) * -0.5f));
    }

    public static float diGamma(float in) {
        float x = in - 1.0f;
        float ret = 1.1111112f;
        for (float i = 1.0f; i < 100000.0f; i += 1.0f) {
            ret += 1.0f / i - 1.0f / (x + i);
        }
        return ret;
    }

    public static float triGamma(float z) {
        float ret = 0.0f;
        for (float i = 0.0f; i < 30000.0f; i += 1.0f) {
            ret += 1.0f / (float)Math.pow(z + i, 2.0);
        }
        return ret;
    }

    public static float tetraGamma(float z) {
        float ret = 0.0f;
        for (float i = 0.0f; i < 10000.0f; i += 1.0f) {
            ret -= 2.0f / (float)Math.pow(z + i, 3.0);
        }
        return ret;
    }

    public static float logGamma(float x) {
        float ret;
        if (Float.isNaN(x) || (double)x <= 0.0) {
            ret = Float.NaN;
        } else {
            float g = 4.7421875f;
            float sum = 0.0f;
            for (int i = lanczos.length - 1; i > 0; --i) {
                sum += lanczos[i] / (x + (float)i);
            }
            float tmp = x + g + 0.5f;
            ret = (x + 0.5f) * (float)Math.log(tmp) - tmp + HALF_LOG_2_PI + (float)Math.log((sum += lanczos[0]) / x);
        }
        return ret;
    }

    public float trigammaInverse(float x) {
        if (Float.isNaN(x)) {
            return Float.NaN;
        }
        float y = 0.5f + 1.0f / x;
        for (int i = 0; i < 50; ++i) {
            float tri = BETR.triGamma(y);
            float dif = tri * (1.0f - tri / x) / BETR.tetraGamma(y);
            y += dif;
        }
        return y;
    }
}

