/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.Rengine;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.rhook.RHook;
import org.tigr.util.FloatMatrix;

public class ATTRACT
extends AbstractAlgorithm {
    private FloatMatrix expMatrix;
    private boolean stop = false;
    private int[] groupAssignments;
    private int[][] keggGenesSynArrays;
    private int[][] keggGenesCorArrays;
    private int numGenes;
    private int numExps;
    private int numGroups;
    private int iteration;
    private float alpha;
    private boolean drawSigTreesOnly;
    private int hcl_function;
    private boolean hcl_absolute;
    private boolean hcl_genes_ordered;
    private boolean hcl_samples_ordered;
    private AlgorithmEvent event;
    private String[] sampleNames;
    private String[] probeIDs;
    private Object[][] synResultMatrix;
    float[] sortedMapping;
    int validN;
    private String chipTypeName;
    private String[] resultColumns;
    private int resultMatrixColumns;
    private String[] nodeTitlesSyn;
    private String[] nodeTitlesCor;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        this.expMatrix = data.getMatrix("experiment");
        this.groupAssignments = data.getIntArray("group_assignments");
        this.alpha = map.getFloat("alpha");
        this.numGroups = map.getInt("numGroups");
        this.chipTypeName = map.getString("chipName", "hgu133plus2.db");
        this.probeIDs = data.getStringArray("probeIDs");
        this.sampleNames = data.getStringArray("sampleLabels");
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        this.hcl_genes_ordered = map.getBoolean("hcl-genes-ordered", false);
        this.hcl_samples_ordered = map.getBoolean("hcl-samples-ordered", false);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        if (hierarchical_tree) {
            this.drawSigTreesOnly = map.getBoolean("draw-sig-trees-only");
        }
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.event = null;
        this.event = new AlgorithmEvent((Object)this, 1, 100, "Calculating...");
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.event.setIntValue(0);
        this.fireValueChanged(this.event);
        this.runRAlg();
        if (this.stop) {
            throw new AbortException();
        }
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        AlgorithmData result = new AlgorithmData();
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i = 0; i < this.keggGenesSynArrays.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.keggGenesSynArrays[i];
            Node node = new Node(features);
            nodeList.addNode(node);
            if (!hierarchical_tree) continue;
            if (this.drawSigTreesOnly) {
                if (i != 0) continue;
                node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
                this.event.setIntValue(i + 1);
                this.fireValueChanged(this.event);
                continue;
            }
            node.setValues(this.calculateHierarchicalTree(features, method_linkage, calculate_genes, calculate_experiments));
            this.event.setIntValue(i + 1);
            this.fireValueChanged(this.event);
        }
        result.addIntMatrix("keggSynArrays", this.keggGenesSynArrays);
        result.addIntMatrix("keggCorArrays", this.keggGenesCorArrays);
        result.addParam("iterations", String.valueOf(this.iteration - 1));
        result.addCluster("cluster", result_cluster);
        result.addParam("number-of-clusters", "1");
        result.addObjectMatrix("synResultMatrix", this.synResultMatrix);
        result.addStringArray("resultColumns", this.resultColumns);
        result.addStringArray("nodeTitlesSyn", this.nodeTitlesSyn);
        result.addStringArray("nodeTitlesCor", this.nodeTitlesCor);
        result.addMatrix("clusters_means", this.getMeans(this.keggGenesSynArrays));
        result.addMatrix("clusters_variances", this.getVariances(this.keggGenesSynArrays, this.getMeans(this.keggGenesSynArrays)));
        result.addMatrix("geneGroupMeansMatrix", this.getAllGeneGroupMeans());
        result.addMatrix("geneGroupSDsMatrix", this.getAllGeneGroupSDs());
        return result;
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.getSubExperiment(this.expMatrix, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        data.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            data.addParam("optimize-gene-ordering", String.valueOf(this.hcl_genes_ordered));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            data.addParam("optimize-sample-ordering", String.valueOf(this.hcl_samples_ordered));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getMeans(int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.numExps);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getMean(int[] cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.numExps);
        int n = cluster.length;
        int denom = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.expMatrix.get(Integer.valueOf(cluster[j]).intValue(), i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    private FloatMatrix getVariances(int[][] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleVariance(int[] cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    private float getSampleNormalizedSum(int[] cluster, int column, float mean) {
        int size = cluster.length;
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(Integer.valueOf(cluster[i]).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float[] getGeneGroupMeans(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupMeans = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            geneGroupMeans[i] = this.getMean(geneValuesByGroups[i]);
        }
        return geneGroupMeans;
    }

    private float[] getGeneGroupSDs(int gene) {
        float[] geneValues = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            geneValues[i] = this.expMatrix.A[gene][i];
        }
        float[][] geneValuesByGroups = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            geneValuesByGroups[i] = this.getGeneValuesForGroup(geneValues, i + 1);
        }
        float[] geneGroupSDs = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            geneGroupSDs[i] = this.getStdDev(geneValuesByGroups[i]);
        }
        return geneGroupSDs;
    }

    private float[] getGeneValuesForGroup(float[] geneValues, int group) {
        Vector<Float> groupValuesVector = new Vector<Float>();
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != group) continue;
            groupValuesVector.add(new Float(geneValues[i]));
        }
        float[] groupGeneValues = new float[groupValuesVector.size()];
        for (int i = 0; i < groupValuesVector.size(); ++i) {
            groupGeneValues[i] = ((Float)groupValuesVector.get(i)).floatValue();
        }
        return groupGeneValues;
    }

    private FloatMatrix getAllGeneGroupMeans() {
        FloatMatrix means = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < means.getRowDimension(); ++i) {
            means.A[i] = this.getGeneGroupMeans(i);
        }
        return means;
    }

    private FloatMatrix getAllGeneGroupSDs() {
        FloatMatrix sds = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < sds.getRowDimension(); ++i) {
            sds.A[i] = this.getGeneGroupSDs(i);
        }
        return sds;
    }

    private float getMean(float[] group) {
        float sum = 0.0f;
        int n = 0;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sum += group[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float mean = sum / (float)n;
        if (Float.isInfinite(mean)) {
            return Float.NaN;
        }
        return mean;
    }

    private float getStdDev(float[] group) {
        float mean = this.getMean(group);
        int n = 0;
        float sumSquares = 0.0f;
        for (int i = 0; i < group.length; ++i) {
            if (Float.isNaN(group[i])) continue;
            sumSquares = (float)((double)sumSquares + Math.pow(group[i] - mean, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float var = sumSquares / (float)(n - 1);
        if (Float.isInfinite(var)) {
            return Float.NaN;
        }
        return (float)Math.sqrt(var);
    }

    public void runRAlg() throws AbortException {
        this.event.setDescription("Creating R Engine...");
        this.fireValueChanged(this.event);
        try {
            Rengine re = RHook.startRSession();
            if (re == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        this.event.setDescription("Loading packages...");
        this.fireValueChanged(this.event);
        try {
            int j;
            int i;
            int i2;
            int i3;
            RHook.testPackage((String)"attract");
            RHook.log((String)"Starting R Algorithim");
            String rCmd = "library(attract)";
            RHook.evalR((String)rCmd);
            rCmd = "source('http://www.bioconductor.org/biocLite.R')";
            RHook.evalR((String)rCmd);
            rCmd = "biocLite('" + this.chipTypeName + "')";
            RHook.evalR((String)rCmd);
            rCmd = "library(" + this.chipTypeName + ")";
            RHook.evalR((String)rCmd);
            this.event.setDescription("Generating script and running Attract module...");
            this.fireValueChanged(this.event);
            String fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "tmpfile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            String filePath = this.writeMatrixToFile(fileLoc, this.expMatrix, this.probeIDs);
            RHook.createRDataFrameFromFile((String)"y", (String)filePath, (boolean)true, (String[])this.sampleNames);
            rCmd = "sampleAssignments <- c(";
            for (i3 = 0; i3 < this.sampleNames.length; ++i3) {
                rCmd = rCmd + "'group" + this.groupAssignments[i3] + "',";
            }
            rCmd = rCmd.substring(0, rCmd.length() - 1) + ")";
            RHook.evalR((String)rCmd);
            rCmd = "chipname <- c(";
            for (i3 = 0; i3 < this.sampleNames.length; ++i3) {
                rCmd = rCmd + "'" + this.sampleNames[i3] + "',";
            }
            rCmd = rCmd.substring(0, rCmd.length() - 1) + ")";
            RHook.evalR((String)rCmd);
            rCmd = "sample.info = data.frame(chipname = chipname, grps = sampleAssignments)";
            RHook.evalR((String)rCmd);
            rCmd = "eset<-new('ExpressionSet')";
            RHook.evalR((String)rCmd);
            rCmd = "eset@assayData<-new.env()";
            RHook.evalR((String)rCmd);
            rCmd = "assign('exprs', y, eset@assayData)";
            RHook.evalR((String)rCmd);
            rCmd = "p.eset<-new('AnnotatedDataFrame', data=sample.info)";
            RHook.evalR((String)rCmd);
            rCmd = "eset@phenoData<-p.eset";
            RHook.evalR((String)rCmd);
            rCmd = "attract_out <- findAttractors(eset, colnames(pData(eset))[2], annotation = '" + this.chipTypeName + "')";
            RHook.evalR((String)rCmd);
            rCmd = "removeTheseGenes<-removeFlatGenes(eset, colnames(pData(eset))[2], contrasts=NULL, limma.cutoff=" + this.alpha + ")";
            RHook.evalR((String)rCmd);
            rCmd = "keepTheseGenes<-setdiff(featureNames(eset), removeTheseGenes)";
            RHook.evalR((String)rCmd);
            rCmd = "as.matrix(attract_out@rankedPathways[1])";
            REXP x = RHook.evalR((String)rCmd);
            String[] keggIDs = x.asStringArray();
            int keggGroupCount = keggIDs.length;
            rCmd = "as.matrix(attract_out@rankedPathways[2])";
            x = RHook.evalR((String)rCmd);
            String[] keggNames = x.asStringArray();
            rCmd = "as.matrix(attract_out@rankedPathways[3])";
            x = RHook.evalR((String)rCmd);
            double[] keggPValues = x.asDoubleArray();
            rCmd = "as.matrix(attract_out@rankedPathways[4])";
            x = RHook.evalR((String)rCmd);
            double[] keggNumGenes = x.asDoubleArray();
            this.resultMatrixColumns = 6;
            this.synResultMatrix = new Object[this.resultMatrixColumns + this.sampleNames.length][];
            this.synResultMatrix[0] = keggIDs;
            this.synResultMatrix[1] = keggNames;
            this.synResultMatrix[2] = new Object[keggGroupCount];
            this.synResultMatrix[3] = new Object[keggGroupCount];
            this.synResultMatrix[4] = new Object[keggGroupCount];
            this.synResultMatrix[5] = new Object[keggGroupCount];
            for (i2 = this.resultMatrixColumns; i2 < this.synResultMatrix.length; ++i2) {
                this.synResultMatrix[i2] = new Object[keggGroupCount];
            }
            for (i2 = 0; i2 < keggGroupCount; ++i2) {
                this.synResultMatrix[2][i2] = keggPValues[i2];
                this.synResultMatrix[3][i2] = keggNumGenes[i2];
                this.synResultMatrix[4][i2] = 0;
                this.synResultMatrix[5][i2] = 0;
            }
            this.resultColumns = new String[this.resultMatrixColumns + this.sampleNames.length];
            this.resultColumns[0] = "KEGG ID";
            this.resultColumns[1] = "KEGG Name";
            this.resultColumns[2] = "Adjusted p-value";
            this.resultColumns[3] = "Number of detected genes";
            this.resultColumns[4] = "Number of Synexpression groups";
            this.resultColumns[5] = "Number of Correlated Partners groups";
            for (i2 = 0; i2 < this.sampleNames.length; ++i2) {
                this.resultColumns[i2 + this.resultMatrixColumns] = this.sampleNames[i2];
            }
            this.fireValueChanged(this.event);
            rCmd = "zz <- file('all.Rout', open='wt')";
            RHook.evalR((String)rCmd);
            rCmd = "sink(zz)";
            RHook.evalR((String)rCmd);
            rCmd = "sink(zz, type='message')";
            RHook.evalR((String)rCmd);
            Object[] probeIDclone = (String[])this.probeIDs.clone();
            this.sortedMapping = new float[probeIDclone.length];
            for (int i4 = 0; i4 < this.sortedMapping.length; ++i4) {
                this.sortedMapping[i4] = i4;
            }
            ExperimentUtil.sort3((String[])probeIDclone, this.sortedMapping);
            ArrayList<int[]> keggGenesSynArraysList = new ArrayList<int[]>();
            ArrayList<String> nodeTitlesSynList = new ArrayList<String>();
            ArrayList<int[]> keggGenesCorArraysList = new ArrayList<int[]>();
            ArrayList<String> nodeTitlesCorList = new ArrayList<String>();
            for (int keggIndex = 0; keggIndex < keggGroupCount; ++keggIndex) {
                int groupIndex;
                int percent = (int)((float)keggIndex * 100.0f / (float)keggGroupCount);
                this.event.setDescription("Gathering results... (" + percent + "%)");
                this.fireValueChanged(this.event);
                x = null;
                rCmd = "synExpression" + keggIndex + "<-findSynexprs('" + keggIDs[keggIndex] + "', attract_out, removeTheseGenes)";
                RHook.evalR((String)rCmd);
                rCmd = "length(synExpression" + keggIndex + "@groups)";
                x = RHook.evalR((String)rCmd);
                int lengthSyn = x == null ? 0 : x.asInt();
                String[][] passSynGenes = null;
                String[][] passCorGenes = null;
                if (lengthSyn != 0) {
                    int groupIndex2;
                    rCmd = "corPartners" + keggIndex + "<-findCorrPartners(synExpression" + keggIndex + ", eset, removeTheseGenes)";
                    RHook.evalR((String)rCmd);
                    rCmd = "length(corPartners" + keggIndex + "@groups)";
                    x = RHook.evalR((String)rCmd);
                    int lengthCor = x == null ? 0 : x.asInt();
                    this.synResultMatrix[4][keggIndex] = lengthSyn;
                    this.synResultMatrix[5][keggIndex] = lengthCor;
                    passSynGenes = new String[lengthSyn][];
                    passCorGenes = new String[lengthCor][];
                    for (groupIndex2 = 0; groupIndex2 < lengthSyn; ++groupIndex2) {
                        rCmd = "asMatrixSyn" + keggIndex + "<-t(as.matrix(unlist(synExpression" + keggIndex + "@groups[[" + (groupIndex2 + 1) + "]]), nrow=length((synExpression" + keggIndex + "@groups[[1]])), ncol=length(unlist(synExpression" + keggIndex + "@groups[[1]])), byrow=true))";
                        RHook.evalR((String)rCmd);
                        rCmd = "asVectorSyn" + keggIndex + "<-as.vector(asMatrixSyn" + keggIndex + ")";
                        RHook.evalR((String)rCmd);
                        rCmd = "asVectorSyn" + keggIndex;
                        x = RHook.evalR((String)rCmd);
                        try {
                            passSynGenes[groupIndex2] = x.asStringArray();
                            continue;
                        }
                        catch (Exception e) {
                            passSynGenes[groupIndex2] = new String[0];
                            System.out.println("error in pathway " + (keggIndex + 1));
                        }
                    }
                    for (groupIndex2 = 0; groupIndex2 < lengthCor; ++groupIndex2) {
                        rCmd = "asMatrixCor" + keggIndex + "<-t(as.matrix(unlist(corPartners" + keggIndex + "@groups[[" + (groupIndex2 + 1) + "]]), nrow=length((corPartners" + keggIndex + "@groups[[1]])), ncol=length(unlist(corPartners" + keggIndex + "@groups[[1]])), byrow=true))";
                        RHook.evalR((String)rCmd);
                        rCmd = "asVectorCor" + keggIndex + "<-as.vector(asMatrixCor" + keggIndex + ")";
                        RHook.evalR((String)rCmd);
                        rCmd = "asVectorCor" + keggIndex;
                        x = RHook.evalR((String)rCmd);
                        try {
                            passCorGenes[groupIndex2] = x.asStringArray();
                            continue;
                        }
                        catch (Exception e) {
                            passCorGenes[groupIndex2] = new String[0];
                            System.out.println("error in pathway " + (keggIndex + 1));
                        }
                    }
                    rCmd = "synExpression" + keggIndex + "@profiles";
                    x = RHook.evalR((String)rCmd);
                    try {
                        if (x != null && x.asMatrix() != null) {
                            double[][] synMatrix = x.asMatrix();
                            for (int i5 = 0; i5 < synMatrix[0].length; ++i5) {
                                this.synResultMatrix[i5 + this.resultMatrixColumns][keggIndex] = synMatrix[0][i5];
                            }
                        }
                        rCmd = "corPartners" + keggIndex + "@profiles";
                        x = RHook.evalR((String)rCmd);
                    }
                    catch (Exception e) {
                        System.out.println("Error in kegg pathway #" + keggIndex);
                    }
                }
                if (passSynGenes == null) {
                    passSynGenes = new String[0][0];
                }
                if (passCorGenes == null) {
                    passCorGenes = new String[0][0];
                }
                for (groupIndex = 0; groupIndex < passSynGenes.length; ++groupIndex) {
                    int[] genesInGroup = new int[passSynGenes[groupIndex].length];
                    for (int i6 = 0; i6 < genesInGroup.length; ++i6) {
                        try {
                            genesInGroup[i6] = (int)this.sortedMapping[Arrays.binarySearch(probeIDclone, passSynGenes[groupIndex][i6])];
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println("gene not found in Probes: " + passSynGenes[groupIndex][i6] + ", " + i6);
                            e.printStackTrace();
                        }
                    }
                    keggGenesSynArraysList.add(genesInGroup);
                    nodeTitlesSynList.add((String)this.synResultMatrix[1][keggIndex] + ", (Group " + (groupIndex + 1) + ")");
                }
                for (groupIndex = 0; groupIndex < passCorGenes.length; ++groupIndex) {
                    int[] genesInGroup = new int[passCorGenes[groupIndex].length];
                    for (int i7 = 0; i7 < genesInGroup.length; ++i7) {
                        try {
                            genesInGroup[i7] = (int)this.sortedMapping[Arrays.binarySearch(probeIDclone, passCorGenes[groupIndex][i7])];
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println("gene not found in Probes: " + passCorGenes[groupIndex][i7] + ", " + i7);
                            e.printStackTrace();
                        }
                    }
                    keggGenesCorArraysList.add(genesInGroup);
                    nodeTitlesCorList.add((String)this.synResultMatrix[1][keggIndex] + ", (Group " + (groupIndex + 1) + ")");
                }
            }
            this.keggGenesSynArrays = new int[keggGenesSynArraysList.size()][];
            this.nodeTitlesSyn = new String[this.keggGenesSynArrays.length];
            for (i = 0; i < this.keggGenesSynArrays.length; ++i) {
                this.keggGenesSynArrays[i] = new int[((int[])keggGenesSynArraysList.get(i)).length];
                for (j = 0; j < this.keggGenesSynArrays[i].length; ++j) {
                    this.keggGenesSynArrays[i][j] = ((int[])keggGenesSynArraysList.get(i))[j];
                }
                this.nodeTitlesSyn[i] = (String)nodeTitlesSynList.get(i);
            }
            this.keggGenesCorArrays = new int[keggGenesCorArraysList.size()][];
            this.nodeTitlesCor = new String[this.keggGenesCorArrays.length];
            for (i = 0; i < this.keggGenesCorArrays.length; ++i) {
                this.keggGenesCorArrays[i] = new int[((int[])keggGenesCorArraysList.get(i)).length];
                for (j = 0; j < this.keggGenesCorArrays[i].length; ++j) {
                    this.keggGenesCorArrays[i][j] = ((int[])keggGenesCorArraysList.get(i))[j];
                }
                this.nodeTitlesCor[i] = (String)nodeTitlesCorList.get(i);
            }
            this.event.setDescription("Generating viewers...");
            this.fireValueChanged(this.event);
            rCmd = "sink()";
            RHook.evalR((String)rCmd);
            RHook.endRSession();
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
                throw new AbortException();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private String writeMatrixToFile(String fileLoc, FloatMatrix fm, String[] rowNames) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
            int row = fm.getRowDimension();
            int col = fm.getColumnDimension();
            String srtVector = "";
            for (int iRow = 0; iRow < row; ++iRow) {
                srtVector = rowNames[iRow] + "\t";
                for (int jCol = 0; jCol < col; ++jCol) {
                    srtVector = jCol == col - 1 ? srtVector + fm.get(iRow, jCol) + "\n" : srtVector + fm.get(iRow, jCol) + "\t";
                }
                out.write(srtVector);
                srtVector = "";
            }
            out.close();
        }
        catch (IOException e) {
            return null;
        }
        return fileLoc;
    }

    public void updateProgressBar() {
    }

    private void removeTmps(String fileName) {
        File f = new File(fileName);
        f.delete();
    }
}

