/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers.ktree;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.CubicCurve2D;
import java.util.Vector;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNode;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNodeRenderer;

public class Ktree
extends JPanel {
    protected ITreeNode[][] nodes;
    protected ITreeNode root;
    protected int xMargin = 15;
    protected int yMargin = 15;
    protected int maxWidth = 0;
    protected int interNodeHeight = 40;
    protected int interNodeWidth = 15;
    protected boolean nodeSelected = false;
    protected boolean isStraitConnector = false;
    Vector selectedPathNodes;
    ITreeNode selectedNode;
    public ITreeNode nodeUnderMouse;
    boolean isNodeSelected;

    public Ktree(ITreeNode root) {
        this.nodes = new ITreeNode[1][1];
        this.nodes[0][0] = root;
        this.root = root;
        this.selectedPathNodes = new Vector();
        this.init();
    }

    public Ktree(ITreeNode[][] data) {
        this.nodes = data;
        this.root = this.nodes[0][0];
        this.selectedPathNodes = new Vector();
        this.init();
    }

    public Ktree(Vector[] data) {
        this.init();
        this.selectedPathNodes = new Vector();
    }

    protected void init() {
        this.setBackground(Color.white);
        this.updateSize();
    }

    public boolean addNode(ITreeNode[] parentNodes, ITreeNode childNodetoAdd, int levl) {
        return true;
    }

    public boolean deleteNode(ITreeNode node) {
        return true;
    }

    public void setNodes(ITreeNode[][] newNodes) {
        this.nodes = newNodes;
    }

    protected void minimizeBranchingOverlap() {
    }

    public ITreeNode getRoot() {
        return this.root;
    }

    public int getMaxLevelWidth() {
        int max = -1;
        for (int i = 0; i < this.nodes.length; ++i) {
            max = Math.max(max, this.nodes[i].length);
        }
        this.maxWidth = max;
        return max;
    }

    public Vector getSelectedPathNodes() {
        return this.selectedPathNodes;
    }

    public int getTreePixelWidth() {
        int levelWidth = this.getMaxLevelWidth();
        int treeWidth = 2 * this.xMargin + levelWidth * (this.interNodeWidth + this.nodes[0][0].getWidth()) - this.interNodeWidth;
        return treeWidth;
    }

    public int getTreePixelHeight() {
        int levelHeight = this.nodes.length;
        int treeHeight = 2 * this.xMargin + levelHeight * (this.interNodeHeight + this.nodes[0][0].getHeight()) - this.interNodeHeight;
        return treeHeight;
    }

    public void setStraightConnectorStyle(boolean isStraitConn) {
        this.isStraitConnector = isStraitConn;
    }

    public void setInterNodeHeight(int height) {
        this.interNodeHeight = height;
    }

    public void setInterNodeWidth(int width) {
        this.interNodeWidth = width;
    }

    public void setSelectedNode(ITreeNode node) {
        this.selectedNode = node;
        this.isNodeSelected = true;
    }

    public void setSelectionPaths(Vector nodes) {
        this.selectedPathNodes = nodes;
    }

    public void clearSelection() {
        this.isNodeSelected = false;
        this.selectedPathNodes = new Vector();
    }

    public boolean checkSelection(int x, int y, int selectionPolarity) {
        this.selectedNode = this.getSelectedNode(x, y);
        if (this.selectedNode == null) {
            this.clearSelection();
            return false;
        }
        this.isNodeSelected = true;
        this.setSelectionPaths(this.getPathNodes(this.selectedNode, selectionPolarity));
        return true;
    }

    public ITreeNode getSelectedNode() {
        return this.selectedNode;
    }

    protected ITreeNode getSelectedNode(int x, int y) {
        ITreeNode node = null;
        int level = (y - this.yMargin) / (this.interNodeHeight + this.nodes[0][0].getHeight());
        if (level < 0 || level >= this.nodes.length) {
            return null;
        }
        for (int i = 0; i < this.nodes[level].length; ++i) {
            if (!this.nodes[level][i].contains(x, y)) continue;
            node = this.nodes[level][i];
            break;
        }
        return node;
    }

    public ITreeNode getNodeUnder(int x, int y) {
        ITreeNode node = null;
        int level = (y - this.yMargin) / (this.interNodeHeight + this.nodes[0][0].getHeight());
        if (level < 0 || level >= this.nodes.length) {
            return null;
        }
        for (int i = 0; i < this.nodes[level].length; ++i) {
            if (!this.nodes[level][i].contains(x, y)) continue;
            node = this.nodes[level][i];
            break;
        }
        return node;
    }

    public Vector getPathNodes(ITreeNode node, int polarity) {
        if (polarity == 0) {
            Vector<ITreeNode> ancestors = new Vector<ITreeNode>();
            Vector successors = new Vector();
            ancestors.addElement(node);
            node.getAncestors(ancestors);
            node.getSuccessors(successors);
            for (int i = 0; i < successors.size(); ++i) {
                ancestors.addElement((ITreeNode)successors.elementAt(i));
            }
            return ancestors;
        }
        if (polarity == 1) {
            Vector<ITreeNode> ancestors = new Vector<ITreeNode>();
            ancestors.addElement(node);
            node.getAncestors(ancestors);
            return ancestors;
        }
        if (polarity == 2) {
            Vector<ITreeNode> successors = new Vector<ITreeNode>();
            successors.addElement(node);
            node.getSuccessors(successors);
            return successors;
        }
        return new Vector();
    }

    public void updateSize() {
        int width = this.getTreePixelWidth();
        int height = this.getTreePixelHeight();
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(width, height);
    }

    public void updateSize(int bufferX, int bufferY) {
        int width = this.getTreePixelWidth();
        int height = this.getTreePixelHeight();
        this.setPreferredSize(new Dimension(width + bufferX, height + bufferY));
        this.setSize(width + bufferX, height + bufferY);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int nodeWidth = this.root.getWidth();
        int nodeHeight = this.root.getHeight();
        int maxLevelWidth = this.maxWidth * (nodeWidth + this.interNodeWidth) - this.interNodeWidth;
        int currX = this.xMargin + (maxLevelWidth - nodeWidth) / 2;
        int currY = this.yMargin;
        boolean selected = false;
        if (this.selectedNode != null && this.selectedNode == this.nodes[0][0]) {
            ((ITreeNodeRenderer)((Object)this.nodes[0][0])).renderNode(g2, currX, currY, 1);
        } else if (this.selectedPathNodes.contains(this.nodes[0][0])) {
            ((ITreeNodeRenderer)((Object)this.nodes[0][0])).renderNode(g2, currX, currY, 2);
        } else if (this.selectedNode != null) {
            ((ITreeNodeRenderer)((Object)this.nodes[0][0])).renderNode(g2, currX, currY, 3);
        } else {
            ((ITreeNodeRenderer)((Object)this.nodes[0][0])).renderNode(g2, currX, currY, 0);
        }
        for (int i = 1; i < this.nodes.length; ++i) {
            currY += nodeHeight + this.interNodeHeight;
            int levelWidth = this.nodes[i].length * (nodeWidth + this.interNodeWidth) - this.interNodeWidth;
            currX = this.xMargin + (maxLevelWidth - levelWidth) / 2;
            for (int j = 0; j < this.nodes[i].length; ++j) {
                if (this.selectedNode != null && this.selectedNode == this.nodes[i][j]) {
                    ((ITreeNodeRenderer)((Object)this.nodes[i][j])).renderNode(g2, currX, currY, 1);
                } else if (this.selectedPathNodes.contains(this.nodes[i][j])) {
                    ((ITreeNodeRenderer)((Object)this.nodes[i][j])).renderNode(g2, currX, currY, 2);
                } else if (this.selectedNode != null) {
                    ((ITreeNodeRenderer)((Object)this.nodes[i][j])).renderNode(g2, currX, currY, 3);
                } else {
                    ((ITreeNodeRenderer)((Object)this.nodes[i][j])).renderNode(g2, currX, currY, 0);
                }
                currX += nodeWidth + this.interNodeWidth;
            }
        }
        this.renderConnectors(g);
        if (this.nodeUnderMouse != null) {
            ((ITreeNodeRenderer)((Object)this.nodeUnderMouse)).renderVerboseTip(g2);
        }
    }

    protected void renderConnectors(Graphics g) {
        boolean selected = false;
        Color origColor = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        Composite composite = g2.getComposite();
        for (int i = 0; i < this.nodes.length; ++i) {
            ITreeNode currNode;
            ITreeNode[] children;
            for (int j = 0; j < this.nodes[i].length && (children = (currNode = this.nodes[i][j]).getChildren()) != null; ++j) {
                Point start = currNode.getBottomAnchorPoint();
                for (int k = 0; k < children.length; ++k) {
                    selected = false;
                    if (this.selectedPathNodes.contains(currNode) && this.selectedPathNodes.contains(children[k])) {
                        selected = true;
                        g.setColor(Color.blue);
                    } else if (this.selectedPathNodes.size() != 0) {
                        AlphaComposite alphaComp = AlphaComposite.getInstance(3, 0.3f);
                        g2.setComposite(alphaComp);
                    }
                    Point finish = children[k].getTopAnchorPoint();
                    if (!this.isStraitConnector) {
                        CubicCurve2D.Double conn = new CubicCurve2D.Double(start.x, start.y, start.x, start.y + 15, finish.x, finish.y - 15, finish.x, finish.y);
                        g2.draw(conn);
                        if (selected) {
                            conn = new CubicCurve2D.Double(start.x + 1, start.y, start.x + 1, start.y + 16, finish.x + 1, finish.y - 16, finish.x + 1, finish.y);
                            g2.draw(conn);
                        }
                    } else {
                        g.drawLine(start.x, start.y, finish.x, finish.y);
                        if (selected) {
                            g.drawLine(start.x + 1, start.y, finish.x + 1, finish.y);
                        }
                    }
                    if (selected) {
                        g.setColor(origColor);
                    }
                    g2.setComposite(composite);
                }
            }
        }
    }
}

