/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers.ktree;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNode;

public class KNodeImpl
implements ITreeNode,
Serializable {
    protected int x = 0;
    protected int y = 0;
    protected int w = 0;
    protected int h = 0;
    protected Point location;
    protected boolean verboseRendering = true;
    protected ITreeNode[] children;
    protected ITreeNode[] parents;
    protected int level;

    public KNodeImpl() {
        this.children = new ITreeNode[0];
        this.parents = new ITreeNode[0];
    }

    public KNodeImpl(int xLoc, int yLoc) {
        this.location = new Point(xLoc, yLoc);
        this.x = xLoc;
        this.y = yLoc;
        this.children = new ITreeNode[0];
        this.parents = new ITreeNode[0];
    }

    @Override
    public boolean contains(int xLoc, int yLoc) {
        return xLoc >= this.x && xLoc <= this.x + this.w && yLoc > this.y && yLoc <= this.y + this.h;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public Point getTopAnchorPoint() {
        return new Point(this.x + this.w / 2, this.y);
    }

    @Override
    public Point getBottomAnchorPoint() {
        return new Point(this.x + this.w / 2, this.y + this.h);
    }

    @Override
    public ITreeNode[] getParents() {
        return this.parents;
    }

    @Override
    public ITreeNode[] getChildren() {
        return this.children;
    }

    @Override
    public Point getLocation() {
        return this.location;
    }

    @Override
    public int getNodeHeight() {
        return this.level;
    }

    public boolean isVerboseRendering() {
        return this.verboseRendering;
    }

    @Override
    public boolean addChild(ITreeNode child) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != child) continue;
            return false;
        }
        ITreeNode[] newNodes = new ITreeNode[this.children.length + 1];
        System.arraycopy(this.children, 0, newNodes, 0, this.children.length);
        newNodes[newNodes.length - 1] = child;
        this.children = newNodes;
        return true;
    }

    @Override
    public boolean addParent(ITreeNode parent) {
        for (int i = 0; i < this.parents.length; ++i) {
            if (this.parents[i] != parent) continue;
            return false;
        }
        ITreeNode[] newNodes = new ITreeNode[this.parents.length + 1];
        System.arraycopy(this.parents, 0, newNodes, 0, this.parents.length);
        newNodes[newNodes.length - 1] = parent;
        this.parents = newNodes;
        return true;
    }

    public void clearChildren() {
        this.children = new ITreeNode[0];
    }

    public void clearParents() {
        this.parents = new ITreeNode[0];
    }

    public void setParents(Vector parentVector) {
        this.parents = new ITreeNode[parentVector.size()];
        for (int i = 0; i < this.parents.length; ++i) {
            this.parents[i] = (ITreeNode)parentVector.elementAt(i);
        }
    }

    public void setChildren(Vector childVector) {
        this.children = new ITreeNode[childVector.size()];
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i] = (ITreeNode)childVector.elementAt(i);
        }
    }

    @Override
    public int getMaxPathLengthToRoot() {
        int maxPathLength = 0;
        if (this.parents == null) {
            return 0;
        }
        for (int i = 0; i < this.parents.length; ++i) {
            maxPathLength = Math.max(maxPathLength, this.parents[i].getMaxPathLengthToRoot());
        }
        return maxPathLength + 1;
    }

    @Override
    public int getMinPathLengthToRoot() {
        int minPathLength = Integer.MAX_VALUE;
        if (this.parents == null) {
            return 0;
        }
        for (int i = 0; i < this.parents.length; ++i) {
            minPathLength = Math.min(minPathLength, this.parents[i].getMinPathLengthToRoot());
        }
        return minPathLength;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.w, this.h);
    }

    @Override
    public int getWidth() {
        return this.w;
    }

    @Override
    public int getHeight() {
        return this.h;
    }

    @Override
    public boolean hasChildren() {
        return this.children.length > 0;
    }

    @Override
    public boolean hasParents() {
        return this.parents.length > 0;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void getAncestors(Vector ancAccumulator) {
        int i;
        if (this.parents.length == 0) {
            return;
        }
        for (i = 0; i < this.parents.length; ++i) {
            if (ancAccumulator.contains(this.parents[i])) continue;
            ancAccumulator.addElement(this.parents[i]);
        }
        for (i = 0; i < this.parents.length; ++i) {
            this.parents[i].getAncestors(ancAccumulator);
        }
    }

    @Override
    public void getSuccessors(Vector sucAccumulator) {
        int i;
        if (this.children.length == 0) {
            return;
        }
        for (i = 0; i < this.children.length; ++i) {
            if (sucAccumulator.contains(this.children[i])) continue;
            sucAccumulator.addElement(this.children[i]);
        }
        for (i = 0; i < this.children.length; ++i) {
            this.children[i].getSuccessors(sucAccumulator);
        }
    }

    @Override
    public boolean contains(Rectangle rect) {
        return rect.contains(this.x, this.y, this.w, this.h);
    }
}

