/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class VennDiagramViewer
extends JPanel
implements IViewer {
    private int[][] clusters = new int[3][];
    private int[][] regionIndices = new int[7][];
    private String[] clusterNames = new String[3];
    private Color[] clusterColors = new Color[3];
    private boolean[] circleSelected = new boolean[]{false, false, false};
    private int[] posInfluence = new int[]{0, 0, 0};
    private int[] negInfluence = new int[]{0, 0, 0};
    private boolean[] regionSelected = new boolean[]{false, false, false, false, false, false, false, false};
    private Experiment experiment;
    private IFramework framework;
    private int totalElements;
    private int exptID = 0;
    private int zoom = 3;
    private float pval = 2.0f;
    private int clusterCount = 3;
    private int[] intersects;
    Color unselected = new Color(200, 200, 255);
    Color selectedRegion = new Color(170, 170, 255);
    private boolean showHighlights = true;
    private Font values_font;
    private Font class_font;
    private Font pval_font;
    private Circle[] circles = new Circle[3];
    private static final Font ERROR_FONT = new Font("monospaced", 1, 20);
    protected JPopupMenu popup;
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String ZOOM_IN = "zoom-in";
    protected static final String ZOOM_OUT = "zoom-out";
    protected static final String HIGHLIGHT_CIRCLES = "highlight-circles";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    public static final String BROADCAST_MATRIX_GAGGLE_CMD = "broadcast-matrix-to-gaggle";
    public static final String BROADCAST_NAMELIST_GAGGLE_CMD = "broadcast-namelist-to-gaggle";

    public VennDiagramViewer(IFramework fm, boolean sampleVD, Cluster[] clusterArray) {
        this.setClusters(clusterArray);
        this.framework = fm;
        this.experiment = this.framework.getData().getExperiment();
        this.totalElements = sampleVD ? this.experiment.getNumberOfSamples() : this.experiment.getNumberOfGenes();
        this.init();
    }

    public VennDiagramViewer(int[][] clusterArray) {
        this(clusterArray, null, null);
    }

    public VennDiagramViewer(int[][] clusterArray, String[] clusterNames) {
        this(clusterArray, clusterNames, null);
    }

    public VennDiagramViewer(int[][] clusterArray, String[] clusterNames, Color[] clusterColors) {
        this(clusterArray, clusterNames, clusterColors, 25);
    }

    public VennDiagramViewer(int[][] clusterArray, String[] clusterNames, Color[] clusterColors, int totalEls) {
        this.setClusters(clusterArray, clusterNames, clusterColors);
        this.totalElements = totalEls;
        this.init();
    }

    private void init() {
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.refreshData();
    }

    public void setClusters(Cluster[] clusterArray) {
        if (clusterArray == null) {
            this.clusterCount = 1;
            return;
        }
        this.clusterCount = Math.min(Math.max(1, clusterArray.length), 4);
        if (this.clusterCount == 1 || this.clusterCount == 4) {
            return;
        }
        this.circles[2] = new Circle();
        for (int i = 0; i < this.clusterCount; ++i) {
            this.clusters[i] = clusterArray[i].getIndices();
            this.clusterColors[i] = clusterArray[i].getClusterColor();
            this.clusterNames[i] = clusterArray[i].getClusterLabel();
            if (this.clusterNames[i].length() < 1) {
                this.clusterNames[i] = "(Cluster " + (i + 1) + ")";
            }
            this.circles[i] = new Circle();
            this.circles[i].setTag(this.clusterNames[i]);
        }
        this.refreshData();
    }

    public void setClusters(int[][] clusterArray, String[] names, Color[] colors) {
        if (clusterArray == null) {
            this.clusterCount = 1;
            return;
        }
        this.clusterCount = Math.min(Math.max(1, clusterArray.length), 4);
        if (this.clusterCount == 1 || this.clusterCount == 4) {
            return;
        }
        this.circles[2] = new Circle();
        for (int i = 0; i < this.clusterCount; ++i) {
            this.clusters[i] = clusterArray[i];
            this.clusterColors[i] = colors == null ? Color.black : colors[i];
            this.clusterNames[i] = names == null ? "Cluster " + (i + 1) : names[i];
            this.circles[i] = new Circle();
            this.circles[i].setTag(this.clusterNames[i]);
        }
        this.refreshData();
    }

    private void setTwoClusterPValue() {
        this.pval = (float)VennDiagramViewer.cumulativeBinomialDistributionFunction(this.totalElements, this.intersects[0], this.clusters[0].length, this.clusters[1].length);
    }

    private void find2ClusterInfluences() {
        this.posInfluence[0] = 0;
        this.posInfluence[1] = 0;
        this.negInfluence[0] = 0;
        this.negInfluence[1] = 0;
        if (this.regionSelected[0] && this.regionSelected[1] && this.regionSelected[2]) {
            this.posInfluence[0] = 4;
            this.posInfluence[1] = 4;
            this.negInfluence[0] = 0;
            this.negInfluence[1] = 0;
        }
        if (this.regionSelected[0] && this.regionSelected[1] && !this.regionSelected[2]) {
            this.posInfluence[0] = 4;
            this.posInfluence[1] = 0;
            this.negInfluence[0] = 0;
            this.negInfluence[1] = 0;
        }
        if (this.regionSelected[0] && !this.regionSelected[1] && this.regionSelected[2]) {
            this.posInfluence[0] = 0;
            this.posInfluence[1] = 4;
            this.negInfluence[0] = 0;
            this.negInfluence[1] = 0;
        }
        if (!this.regionSelected[0] && this.regionSelected[1] && this.regionSelected[2]) {
            this.posInfluence[0] = 4;
            this.posInfluence[1] = 4;
            this.negInfluence[0] = -4;
            this.negInfluence[1] = -4;
        }
        if (this.regionSelected[0] && !this.regionSelected[1] && !this.regionSelected[2]) {
            this.posInfluence[0] = 2;
            this.posInfluence[1] = 2;
            this.negInfluence[0] = 0;
            this.negInfluence[1] = 0;
        }
        if (!this.regionSelected[0] && this.regionSelected[1] && !this.regionSelected[2]) {
            this.posInfluence[0] = 2;
            this.posInfluence[1] = 0;
            this.negInfluence[0] = 0;
            this.negInfluence[1] = -2;
        }
        if (!this.regionSelected[0] && !this.regionSelected[1] && this.regionSelected[2]) {
            this.posInfluence[0] = 0;
            this.posInfluence[1] = 2;
            this.negInfluence[0] = -2;
            this.negInfluence[1] = 0;
        }
        if (!(this.regionSelected[0] || this.regionSelected[1] || this.regionSelected[2])) {
            this.posInfluence[0] = 0;
            this.posInfluence[1] = 0;
            this.negInfluence[0] = 0;
            this.negInfluence[1] = 0;
        }
    }

    private void find3ClusterInfluences() {
        this.posInfluence[0] = 0;
        this.posInfluence[1] = 0;
        this.posInfluence[2] = 0;
        this.negInfluence[0] = 0;
        this.negInfluence[1] = 0;
        this.negInfluence[2] = 0;
        if (this.regionSelected[0] && !this.regionSelected[1]) {
            this.posInfluence[2] = this.posInfluence[2] + 1;
        }
        if (this.regionSelected[0] && !this.regionSelected[2]) {
            this.posInfluence[1] = this.posInfluence[1] + 1;
        }
        if (this.regionSelected[0] && !this.regionSelected[3]) {
            this.posInfluence[0] = this.posInfluence[0] + 1;
        }
        if (this.regionSelected[1] && !this.regionSelected[4]) {
            this.posInfluence[1] = this.posInfluence[1] + 1;
        }
        if (this.regionSelected[1] && !this.regionSelected[5]) {
            this.posInfluence[0] = this.posInfluence[0] + 1;
        }
        if (this.regionSelected[2] && !this.regionSelected[4]) {
            this.posInfluence[2] = this.posInfluence[2] + 1;
        }
        if (this.regionSelected[2] && !this.regionSelected[6]) {
            this.posInfluence[0] = this.posInfluence[0] + 1;
        }
        if (this.regionSelected[3] && !this.regionSelected[5]) {
            this.posInfluence[2] = this.posInfluence[2] + 1;
        }
        if (this.regionSelected[3] && !this.regionSelected[6]) {
            this.posInfluence[1] = this.posInfluence[1] + 1;
        }
        if (this.regionSelected[4]) {
            this.posInfluence[0] = this.posInfluence[0] + 1;
        }
        if (this.regionSelected[5]) {
            this.posInfluence[1] = this.posInfluence[1] + 1;
        }
        if (this.regionSelected[6]) {
            this.posInfluence[2] = this.posInfluence[2] + 1;
        }
        if (this.regionSelected[1] && !this.regionSelected[0]) {
            this.negInfluence[2] = this.negInfluence[2] - 1;
        }
        if (this.regionSelected[2] && !this.regionSelected[0]) {
            this.negInfluence[1] = this.negInfluence[1] - 1;
        }
        if (this.regionSelected[3] && !this.regionSelected[0]) {
            this.negInfluence[0] = this.negInfluence[0] - 1;
        }
        if (this.regionSelected[4] && !this.regionSelected[1]) {
            this.negInfluence[1] = this.negInfluence[1] - 1;
        }
        if (this.regionSelected[5] && !this.regionSelected[1]) {
            this.negInfluence[0] = this.negInfluence[0] - 1;
        }
        if (this.regionSelected[4] && !this.regionSelected[2]) {
            this.negInfluence[2] = this.negInfluence[2] - 1;
        }
        if (this.regionSelected[6] && !this.regionSelected[2]) {
            this.negInfluence[0] = this.negInfluence[0] - 1;
        }
        if (this.regionSelected[5] && !this.regionSelected[3]) {
            this.negInfluence[2] = this.negInfluence[2] - 1;
        }
        if (this.regionSelected[6] && !this.regionSelected[3]) {
            this.negInfluence[1] = this.negInfluence[1] - 1;
        }
    }

    private int[] getThreeClusterOverlap(int[][] clusters) {
        int i;
        ArrayList<Integer> clusterA = new ArrayList<Integer>();
        for (int i2 = 0; i2 < clusters[0].length; ++i2) {
            clusterA.add(clusters[0][i2]);
        }
        ArrayList<Integer> clusterB = new ArrayList<Integer>();
        for (int i3 = 0; i3 < clusters[1].length; ++i3) {
            clusterB.add(clusters[1][i3]);
        }
        ArrayList<Integer> clusterC = new ArrayList<Integer>();
        for (int i4 = 0; i4 < clusters[2].length; ++i4) {
            clusterC.add(clusters[2][i4]);
        }
        ArrayList[] indices = new ArrayList[7];
        for (int i5 = 0; i5 < 7; ++i5) {
            indices[i5] = new ArrayList();
        }
        int[] overlaps = new int[8];
        for (i = 0; i < this.totalElements; ++i) {
            boolean a = false;
            boolean b = false;
            boolean c = false;
            if (clusterA.contains(i)) {
                a = true;
            }
            if (clusterB.contains(i)) {
                b = true;
            }
            if (clusterC.contains(i)) {
                c = true;
            }
            if (a & b & c) {
                overlaps[0] = overlaps[0] + 1;
                indices[0].add(i);
            }
            if (a & b & !c) {
                overlaps[1] = overlaps[1] + 1;
                indices[1].add(i);
            }
            if (a & !b & c) {
                overlaps[2] = overlaps[2] + 1;
                indices[2].add(i);
            }
            if (!a & b & c) {
                overlaps[3] = overlaps[3] + 1;
                indices[3].add(i);
            }
            if (a & !b & !c) {
                overlaps[4] = overlaps[4] + 1;
                indices[4].add(i);
            }
            if (!a & b & !c) {
                overlaps[5] = overlaps[5] + 1;
                indices[5].add(i);
            }
            if (!a & !b & c) {
                overlaps[6] = overlaps[6] + 1;
                indices[6].add(i);
            }
            if (!(!a & !b & !c)) continue;
            overlaps[7] = overlaps[7] + 1;
        }
        for (i = 0; i < 7; ++i) {
            this.regionIndices[i] = new int[indices[i].size()];
            for (int j = 0; j < indices[i].size(); ++j) {
                this.regionIndices[i][j] = (Integer)indices[i].get(j);
            }
        }
        return overlaps;
    }

    private int[] getTwoClusterOverlap(int[][] clusters) {
        int i;
        ArrayList<Integer> clusterA = new ArrayList<Integer>();
        for (int i2 = 0; i2 < clusters[0].length; ++i2) {
            clusterA.add(clusters[0][i2]);
        }
        ArrayList<Integer> clusterB = new ArrayList<Integer>();
        for (int i3 = 0; i3 < clusters[1].length; ++i3) {
            clusterB.add(clusters[1][i3]);
        }
        ArrayList[] indices = new ArrayList[7];
        for (int i4 = 0; i4 < 7; ++i4) {
            indices[i4] = new ArrayList();
        }
        int[] overlaps = new int[4];
        for (i = 0; i < this.totalElements; ++i) {
            boolean a = false;
            boolean b = false;
            if (clusterA.contains(i)) {
                a = true;
            }
            if (clusterB.contains(i)) {
                b = true;
            }
            if (a & b) {
                overlaps[0] = overlaps[0] + 1;
                indices[0].add(i);
            }
            if (a & !b) {
                overlaps[1] = overlaps[1] + 1;
                indices[1].add(i);
            }
            if (!a & b) {
                overlaps[2] = overlaps[2] + 1;
                indices[2].add(i);
            }
            if (!(!a & !b)) continue;
            overlaps[3] = overlaps[3] + 1;
            indices[3].add(i);
        }
        for (i = 0; i < 7; ++i) {
            this.regionIndices[i] = new int[indices[i].size()];
            for (int j = 0; j < indices[i].size(); ++j) {
                this.regionIndices[i][j] = (Integer)indices[i].get(j);
            }
        }
        return overlaps;
    }

    private void refreshData() {
        for (int i = 0; i < 7; ++i) {
            this.regionSelected[i] = false;
        }
        if (this.clusterCount == 3) {
            this.intersects = this.getThreeClusterOverlap(this.clusters);
            this.find3ClusterInfluences();
        } else if (this.clusterCount == 2) {
            this.intersects = this.getTwoClusterOverlap(this.clusters);
            this.setTwoClusterPValue();
            this.find2ClusterInfluences();
        } else {
            return;
        }
        this.setBackground(Color.white);
        this.values_font = new Font("Courier", 1, 18);
        this.class_font = new Font("Courier", 1, 24);
        this.pval_font = new Font("Courier", 1, 12);
        this.setCircles();
    }

    private void setCircles() {
        int circleWidth = 60;
        int xloc = 25;
        int yloc = 12;
        this.circles[0].x = this.zoom * xloc;
        this.circles[0].y = this.zoom * yloc;
        this.circles[1].x = this.zoom * (xloc + circleWidth / 2);
        this.circles[1].y = this.zoom * yloc;
        this.circles[2].x = this.zoom * (xloc + circleWidth / 4);
        this.circles[2].y = (int)((float)this.zoom * ((float)yloc + (float)circleWidth * 0.433013f));
        this.circles[0].diameter = this.zoom * circleWidth;
        this.circles[1].diameter = this.zoom * circleWidth;
        this.circles[2].diameter = this.zoom * circleWidth;
        this.circles[0].label_x = this.zoom * xloc;
        this.circles[0].label_y = this.zoom * (yloc - 3);
        this.circles[1].label_x = this.zoom * (xloc + 5 * circleWidth / 4);
        this.circles[1].label_y = this.zoom * (yloc - 3);
        this.circles[2].label_x = this.zoom * (xloc + circleWidth / 2);
        this.circles[2].label_y = this.zoom * (yloc + 5 * circleWidth / 3);
        this.circles[0].center_x = (this.circles[0].x + (this.circles[0].x + this.circles[0].diameter)) / 2;
        this.circles[0].center_y = (this.circles[0].y + (this.circles[0].y + this.circles[0].diameter)) / 2;
        this.circles[1].center_x = (this.circles[1].x + (this.circles[1].x + this.circles[1].diameter)) / 2;
        this.circles[1].center_y = (this.circles[1].y + (this.circles[1].y + this.circles[1].diameter)) / 2;
        this.circles[2].center_x = (this.circles[2].x + (this.circles[2].x + this.circles[2].diameter)) / 2;
        this.circles[2].center_y = (this.circles[2].y + (this.circles[2].y + this.circles[2].diameter)) / 2;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.clusterCount == 4) {
            g.setColor(new Color(0, 0, 128));
            g.setFont(ERROR_FONT);
            g.drawString("Too Many Clusters", 10, 30);
            return;
        }
        if (this.clusterCount == 1) {
            g.setColor(new Color(0, 0, 128));
            g.setFont(ERROR_FONT);
            g.drawString("Select 2 or 3 Clusters", 10, 30);
            return;
        }
        if (this.clusterCount == 3) {
            if (this.showHighlights) {
                this.draw3ClusterSelectedArcs(g);
            }
            this.draw3ClusterSelectedRegions(g);
        } else {
            if (this.showHighlights) {
                this.draw2ClusterSelectedArcs(g);
            }
            this.draw2ClusterSelectedRegions(g);
        }
        this.drawOutlines(g);
        this.drawValues(g);
    }

    private void draw2ClusterSelectedArcs(Graphics g) {
        g.setColor(Color.white);
        int arcwidth = 6;
        g.fillArc(this.circles[0].x - arcwidth / 2 * this.zoom, this.circles[0].y - arcwidth / 2 * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, 60, 240);
        g.fillArc(this.circles[1].x - arcwidth / 2 * this.zoom, this.circles[1].y - arcwidth / 2 * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, 240, 240);
        if (this.posInfluence[0] > 0) {
            g.setColor(this.getPosArcColor(this.posInfluence[0]));
            g.fillArc(this.circles[0].x - arcwidth / 2 * this.zoom, this.circles[0].y - arcwidth / 2 * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, 60, 240);
        }
        if (this.posInfluence[1] > 0) {
            g.setColor(this.getPosArcColor(this.posInfluence[1]));
            g.fillArc(this.circles[1].x - arcwidth / 2 * this.zoom, this.circles[1].y - arcwidth / 2 * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, 240, 240);
        }
        if (this.negInfluence[0] < 0) {
            g.setColor(this.getNegArcColor(this.negInfluence[0]));
            g.fillArc(this.circles[0].x - arcwidth / 2 * this.zoom, this.circles[0].y - arcwidth / 2 * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, 60, 240);
        }
        if (this.negInfluence[1] < 0) {
            g.setColor(this.getNegArcColor(this.negInfluence[0]));
            g.fillArc(this.circles[1].x - arcwidth / 2 * this.zoom, this.circles[1].y - arcwidth / 2 * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, 240, 240);
        }
        if (this.negInfluence[0] < 0 && this.posInfluence[0] > 0) {
            g.setColor(Color.gray);
            g.fillArc(this.circles[0].x - arcwidth / 2 * this.zoom, this.circles[0].y - arcwidth / 2 * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, 60, 240);
        }
        if (this.negInfluence[1] < 0 && this.posInfluence[1] > 0) {
            g.setColor(Color.gray);
            g.fillArc(this.circles[1].x - arcwidth / 2 * this.zoom, this.circles[1].y - arcwidth / 2 * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, 240, 240);
        }
    }

    private void draw3ClusterSelectedArcs(Graphics g) {
        g.setColor(Color.white);
        int arcwidth = 6;
        g.fillArc(this.circles[0].x - arcwidth / 2 * this.zoom, this.circles[0].y - arcwidth / 2 * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, 60, 180);
        g.fillArc(this.circles[1].x - arcwidth / 2 * this.zoom, this.circles[1].y - arcwidth / 2 * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, 300, 180);
        g.fillArc(this.circles[2].x - arcwidth / 2 * this.zoom, this.circles[2].y - arcwidth / 2 * this.zoom, this.circles[2].diameter + arcwidth * this.zoom, this.circles[2].diameter + arcwidth * this.zoom, 180, 180);
        if (this.posInfluence[0] > 0) {
            g.setColor(this.getPosArcColor(this.posInfluence[0]));
            g.fillArc(this.circles[0].x - arcwidth / 2 * this.zoom, this.circles[0].y - arcwidth / 2 * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, 60, 180);
        }
        if (this.posInfluence[1] > 0) {
            g.setColor(this.getPosArcColor(this.posInfluence[1]));
            g.fillArc(this.circles[1].x - arcwidth / 2 * this.zoom, this.circles[1].y - arcwidth / 2 * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, 300, 180);
        }
        if (this.posInfluence[2] > 0) {
            g.setColor(this.getPosArcColor(this.posInfluence[2]));
            g.fillArc(this.circles[2].x - arcwidth / 2 * this.zoom, this.circles[2].y - arcwidth / 2 * this.zoom, this.circles[2].diameter + arcwidth * this.zoom, this.circles[2].diameter + arcwidth * this.zoom, 180, 180);
        }
        if (this.negInfluence[0] < 0) {
            g.setColor(this.getNegArcColor(this.negInfluence[0]));
            g.fillArc(this.circles[0].x - arcwidth / 2 * this.zoom, this.circles[0].y - arcwidth / 2 * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, 60, 180);
        }
        if (this.negInfluence[1] < 0) {
            g.setColor(this.getNegArcColor(this.negInfluence[1]));
            g.fillArc(this.circles[1].x - arcwidth / 2 * this.zoom, this.circles[1].y - arcwidth / 2 * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, 300, 180);
        }
        if (this.negInfluence[2] < 0) {
            g.setColor(this.getNegArcColor(this.negInfluence[2]));
            g.fillArc(this.circles[2].x - arcwidth / 2 * this.zoom, this.circles[2].y - arcwidth / 2 * this.zoom, this.circles[2].diameter + arcwidth * this.zoom, this.circles[2].diameter + arcwidth * this.zoom, 180, 180);
        }
        if (this.negInfluence[0] < 0 && this.posInfluence[0] > 0) {
            g.setColor(Color.gray);
            g.fillArc(this.circles[0].x - arcwidth / 2 * this.zoom, this.circles[0].y - arcwidth / 2 * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, this.circles[0].diameter + arcwidth * this.zoom, 60, 180);
        }
        if (this.negInfluence[1] < 0 && this.posInfluence[1] > 0) {
            g.setColor(Color.gray);
            g.fillArc(this.circles[1].x - arcwidth / 2 * this.zoom, this.circles[1].y - arcwidth / 2 * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, this.circles[1].diameter + arcwidth * this.zoom, 300, 180);
        }
        if (this.negInfluence[2] < 0 && this.posInfluence[2] > 0) {
            g.setColor(Color.gray);
            g.fillArc(this.circles[2].x - arcwidth / 2 * this.zoom, this.circles[2].y - arcwidth / 2 * this.zoom, this.circles[2].diameter + arcwidth * this.zoom, this.circles[2].diameter + arcwidth * this.zoom, 180, 180);
        }
    }

    private Color getPosArcColor(int influence) {
        return new Color(255, 255 - 63 * influence, 255 - 63 * influence);
    }

    private Color getNegArcColor(int influence) {
        return new Color(255 + 63 * influence, 255 + 63 * influence, 255);
    }

    private void draw2ClusterSelectedRegions(Graphics g) {
        g.setColor(this.regionSelected[1] ? this.selectedRegion : this.unselected);
        g.fillOval(this.circles[0].x, this.circles[0].y, this.circles[0].diameter, this.circles[0].diameter);
        g.setColor(this.regionSelected[2] ? this.selectedRegion : this.unselected);
        g.fillOval(this.circles[1].x, this.circles[1].y, this.circles[1].diameter, this.circles[1].diameter);
        g.setColor(this.regionSelected[0] ? this.selectedRegion : this.unselected);
        g.fillArc(this.circles[0].x, this.circles[0].y, this.circles[0].diameter, this.circles[0].diameter, 300, 120);
        g.fillArc(this.circles[1].x, this.circles[1].y, this.circles[1].diameter, this.circles[1].diameter, 120, 120);
    }

    private void draw3ClusterSelectedRegions(Graphics g) {
        g.setColor(this.regionSelected[4] ? this.selectedRegion : this.unselected);
        g.fillOval(this.circles[0].x, this.circles[0].y, this.circles[0].diameter, this.circles[0].diameter);
        g.setColor(this.regionSelected[5] ? this.selectedRegion : this.unselected);
        g.fillOval(this.circles[1].x, this.circles[1].y, this.circles[1].diameter, this.circles[1].diameter);
        if (this.clusterCount == 3) {
            g.setColor(this.regionSelected[6] ? this.selectedRegion : this.unselected);
            g.fillOval(this.circles[2].x, this.circles[2].y, this.circles[2].diameter, this.circles[2].diameter);
        }
        g.setColor(this.regionSelected[1] ? this.selectedRegion : this.unselected);
        g.fillArc(this.circles[0].x, this.circles[0].y, this.circles[0].diameter, this.circles[0].diameter, 300, 120);
        g.fillArc(this.circles[1].x, this.circles[1].y, this.circles[1].diameter, this.circles[1].diameter, 120, 120);
        g.setColor(this.regionSelected[3] ? this.selectedRegion : this.unselected);
        g.fillArc(this.circles[1].x, this.circles[1].y, this.circles[1].diameter, this.circles[1].diameter, 180, 120);
        g.fillArc(this.circles[2].x, this.circles[2].y, this.circles[2].diameter, this.circles[2].diameter, 0, 120);
        g.setColor(this.regionSelected[2] ? this.selectedRegion : this.unselected);
        g.fillArc(this.circles[0].x, this.circles[0].y, this.circles[0].diameter, this.circles[0].diameter, 240, 120);
        g.fillArc(this.circles[2].x, this.circles[2].y, this.circles[2].diameter, this.circles[2].diameter, 60, 120);
        g.setColor(this.regionSelected[0] ? this.selectedRegion : this.unselected);
        g.fillArc(this.circles[0].x, this.circles[0].y, this.circles[0].diameter, this.circles[0].diameter, 300, 60);
        g.fillArc(this.circles[1].x, this.circles[1].y, this.circles[1].diameter, this.circles[1].diameter, 180, 60);
        g.fillArc(this.circles[2].x, this.circles[2].y, this.circles[2].diameter, this.circles[2].diameter, 60, 60);
    }

    private void drawOutlines(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(Color.black);
        g2.setStroke(new BasicStroke(4.0f));
        g2.drawOval(this.circles[0].x, this.circles[0].y, this.circles[0].diameter, this.circles[0].diameter);
        g2.drawOval(this.circles[1].x, this.circles[1].y, this.circles[1].diameter, this.circles[1].diameter);
        if (this.clusterCount == 3) {
            g2.drawOval(this.circles[2].x, this.circles[2].y, this.circles[2].diameter, this.circles[2].diameter);
        }
        g2.setFont(this.class_font);
        g2.setColor(this.clusterColors[0]);
        g2.drawString(this.circles[0].label, this.circles[0].label_x - this.getGraphics().getFontMetrics().stringWidth(this.circles[0].label) / 2, this.circles[0].label_y);
        g2.setColor(this.clusterColors[1]);
        g2.drawString(this.circles[1].label, this.circles[1].label_x - this.getGraphics().getFontMetrics().stringWidth(this.circles[1].label) / 2, this.circles[1].label_y);
        if (this.clusterCount == 3) {
            g2.setColor(this.clusterColors[2]);
            g2.drawString(this.circles[2].label, this.circles[2].label_x - this.getGraphics().getFontMetrics().stringWidth(this.circles[2].label) / 2, this.circles[2].label_y);
        }
    }

    private void drawValues(Graphics g) {
        int i;
        int[][] coordinates;
        g.setColor(Color.black);
        g.setFont(this.values_font);
        if (this.clusterCount == 3) {
            coordinates = this.get3ClusterValueCoordinates();
            for (i = 0; i < 8; ++i) {
                g.drawString(Integer.toString(this.intersects[i]), coordinates[0][i], coordinates[1][i]);
            }
        }
        if (this.clusterCount == 2) {
            coordinates = this.get2ClusterValueCoordinates();
            for (i = 0; i < 4; ++i) {
                g.drawString(Integer.toString(this.intersects[i]), coordinates[0][i] - this.getGraphics().getFontMetrics().stringWidth(Integer.toString(this.intersects[i])) / 2, coordinates[1][i] + 6);
            }
            this.pval = (float)Math.round(10000.0f * this.pval) / 10000.0f;
            int maxlength = Float.toString(this.pval).length();
            String pvalstring = (double)this.pval < 1.0E-4 ? "p-value < .0001" : "p-value = " + Float.toString(this.pval).substring(0, Math.min(6, maxlength));
            g.setColor(Color.blue);
            g.setFont(this.pval_font);
            g.drawString(pvalstring, coordinates[0][3] - 25, coordinates[1][3] + 25);
        }
    }

    private int[][] get3ClusterValueCoordinates() {
        int[][] vals = new int[2][8];
        vals[0][0] = this.zoom * 66;
        vals[1][0] = this.zoom * 51;
        vals[0][1] = this.zoom * 66;
        vals[1][1] = this.zoom * 31;
        vals[0][2] = this.zoom * 48;
        vals[1][2] = this.zoom * 60;
        vals[0][3] = this.zoom * 87;
        vals[1][3] = this.zoom * 60;
        vals[0][4] = this.zoom * 40;
        vals[1][4] = this.zoom * 32;
        vals[0][5] = this.zoom * 95;
        vals[1][5] = this.zoom * 32;
        vals[0][6] = this.zoom * 66;
        vals[1][6] = this.zoom * 83;
        vals[0][7] = this.zoom * 125;
        vals[1][7] = this.zoom * 61;
        return vals;
    }

    private int[][] get2ClusterValueCoordinates() {
        int[][] vals = new int[2][4];
        vals[0][0] = this.circles[0].center_x + this.circles[0].diameter / 4;
        vals[1][0] = this.circles[0].center_y;
        vals[0][1] = this.circles[0].center_x - this.circles[0].diameter / 4;
        vals[1][1] = this.circles[0].center_y;
        vals[0][2] = this.circles[1].center_x + this.circles[0].diameter / 4;
        vals[1][2] = this.circles[0].center_y;
        vals[0][3] = this.circles[0].center_x + this.circles[0].diameter / 4;
        vals[1][3] = this.circles[0].center_y + 3 * this.circles[0].diameter / 4;
        return vals;
    }

    private static double cumulativeBinomialDistributionFunction(int total, int intersect, int cl1, int cl2) {
        double value = 0.0;
        for (int i = 0; i < intersect; ++i) {
            value += VennDiagramViewer.binomialDistributionFunction(i, cl2, (double)cl1 / (double)total);
        }
        return 1.0 - value;
    }

    private static double binomialDistributionFunction(int k, int n, double p) {
        double value = 1.0;
        int max = Math.max(k, n - k);
        double whichp = max == k ? p : 1.0 - p;
        for (int i = n; i > max; --i) {
            value *= (double)i;
            value *= 1.0 - whichp;
            value /= (double)(i - max);
        }
        return value *= Math.pow(whichp, max);
    }

    @Override
    public JComponent getContentComponent() {
        return this;
    }

    @Override
    public JComponent getHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    @Override
    public void onSelected(IFramework framework) {
    }

    @Override
    public void onDataChanged(IData data) {
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
    }

    @Override
    public void onDeselected() {
    }

    @Override
    public void onClosed() {
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    @Override
    public int[][] getClusters() {
        return this.clusters;
    }

    @Override
    public Experiment getExperiment() {
        return this.experiment;
    }

    @Override
    public int getViewerType() {
        return -1;
    }

    @Override
    public void setExperiment(Experiment e) {
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void setExperimentID(int id) {
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, ClusterWrapper.wrapClusters((int[][])this.clusters)});
    }

    public int getRegion(int x, int y) {
        boolean circleC;
        boolean circleB;
        boolean circleA;
        if (this.clusterCount == 2) {
            circleA = this.circles[0].pointInCircle(x, y);
            if (circleA & (circleB = this.circles[1].pointInCircle(x, y))) {
                return 0;
            }
            if (circleA & !circleB) {
                return 1;
            }
            if (!circleA & circleB) {
                return 2;
            }
            if (!circleA & !circleB) {
                return 7;
            }
        }
        if ((circleA = this.circles[0].pointInCircle(x, y)) & (circleB = this.circles[1].pointInCircle(x, y)) & (circleC = this.circles[2].pointInCircle(x, y))) {
            return 0;
        }
        if (circleA & circleB & !circleC) {
            return 1;
        }
        if (circleA & !circleB & circleC) {
            return 2;
        }
        if (!circleA & circleB & circleC) {
            return 3;
        }
        if (circleA & !circleB & !circleC) {
            return 4;
        }
        if (!circleA & circleB & !circleC) {
            return 5;
        }
        if (!circleA & !circleB & circleC) {
            return 6;
        }
        return 7;
    }

    private void clearSelections() {
        int i;
        for (i = 0; i < this.regionSelected.length; ++i) {
            this.regionSelected[i] = false;
        }
        for (i = 0; i < this.circleSelected.length; ++i) {
            this.circleSelected[i] = false;
        }
    }

    protected JPopupMenu createJPopupMenu(ActionListener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Zoom In", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(ZOOM_IN);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Zoom Out", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(ZOOM_OUT);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Store Selected Cluster", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem(this.showHighlights ? "Hide Selected Circles Highlights" : "Show Selected Circles Highlights", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(HIGHLIGHT_CIRCLES);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private int[] getSelectedIndices() {
        ArrayList<Integer> indicesAL = new ArrayList<Integer>();
        for (int i = 0; i < 7; ++i) {
            if (!this.regionSelected[i]) continue;
            for (int j = 0; j < this.regionIndices[i].length; ++j) {
                indicesAL.add(this.regionIndices[i][j]);
            }
        }
        int[] indices = new int[indicesAL.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)indicesAL.get(i);
        }
        return indices;
    }

    private void storeCluster() {
        try {
            this.framework.storeCluster(this.getSelectedIndices(), this.experiment, 0);
        }
        catch (Exception e) {
            int[] a = this.getSelectedIndices();
            for (int i = 0; i < a.length; ++i) {
                System.out.print(a[i] + "\t");
            }
        }
    }

    private void setHighlightCircles() {
        this.showHighlights = !this.showHighlights;
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.repaint();
    }

    public static void main(String[] args) {
        JDialog jp3 = new JDialog();
        JDialog jp2 = new JDialog();
        int[][] clusters3 = new int[][]{{1, 2, 3, 5, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19}, {1, 2, 3, 5, 7, 8, 12}, {1, 2, 3, 4, 7, 11}};
        int[][] clusters2 = new int[][]{{1, 2, 3, 5, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19}, {1, 2, 3, 5, 7, 8, 12}};
        String[] clnames = new String[]{"Joe", "Moe", "Snow"};
        VennDiagramViewer vdv3 = new VennDiagramViewer(clusters3, clnames);
        VennDiagramViewer vdv2 = new VennDiagramViewer(clusters2, clnames);
        jp2.add(vdv2);
        jp2.setBackground(Color.white);
        jp2.setModal(true);
        jp2.setAlwaysOnTop(true);
        jp2.setSize(459, 450);
        jp3.add(vdv3);
        jp3.setBackground(Color.white);
        jp3.setModal(true);
        jp3.setAlwaysOnTop(true);
        jp3.setSize(459, 450);
        jp3.setVisible(true);
        jp2.setVisible(true);
        System.exit(0);
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener,
    ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(VennDiagramViewer.ZOOM_IN)) {
                VennDiagramViewer.this.zoom++;
                VennDiagramViewer.this.refreshData();
                VennDiagramViewer.this.repaint();
            }
            if (command.equals(VennDiagramViewer.ZOOM_OUT)) {
                VennDiagramViewer.this.zoom--;
                VennDiagramViewer.this.zoom = Math.max(1, VennDiagramViewer.this.zoom);
                VennDiagramViewer.this.refreshData();
                VennDiagramViewer.this.repaint();
            }
            if (command.equals(VennDiagramViewer.SAVE_CLUSTER_CMD)) {
                VennDiagramViewer.this.storeCluster();
            }
            if (command.equals(VennDiagramViewer.HIGHLIGHT_CIRCLES)) {
                VennDiagramViewer.this.setHighlightCircles();
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
            if (event.isPopupTrigger()) {
                return;
            }
            if (VennDiagramViewer.this.getRegion(event.getX(), event.getY()) == 7) {
                VennDiagramViewer.this.clearSelections();
                VennDiagramViewer.this.refreshData();
                VennDiagramViewer.this.repaint();
                return;
            }
            if (VennDiagramViewer.this.circles[0].pointInCircle(event.getX(), event.getY())) {
                boolean bl = ((VennDiagramViewer)VennDiagramViewer.this).circleSelected[0] = !VennDiagramViewer.this.circleSelected[0];
            }
            if (VennDiagramViewer.this.circles[1].pointInCircle(event.getX(), event.getY())) {
                boolean bl = ((VennDiagramViewer)VennDiagramViewer.this).circleSelected[1] = !VennDiagramViewer.this.circleSelected[1];
            }
            if (VennDiagramViewer.this.circles[2].pointInCircle(event.getX(), event.getY())) {
                boolean bl = ((VennDiagramViewer)VennDiagramViewer.this).circleSelected[2] = !VennDiagramViewer.this.circleSelected[2];
            }
            if (VennDiagramViewer.this.clusterCount == 3) {
                ((VennDiagramViewer)VennDiagramViewer.this).regionSelected[VennDiagramViewer.this.getRegion((int)event.getX(), (int)event.getY())] = !VennDiagramViewer.this.regionSelected[VennDiagramViewer.this.getRegion(event.getX(), event.getY())];
                ((VennDiagramViewer)VennDiagramViewer.this).circleSelected[0] = VennDiagramViewer.this.regionSelected[0] || VennDiagramViewer.this.regionSelected[1] || VennDiagramViewer.this.regionSelected[2] || VennDiagramViewer.this.regionSelected[4];
                ((VennDiagramViewer)VennDiagramViewer.this).circleSelected[1] = VennDiagramViewer.this.regionSelected[0] || VennDiagramViewer.this.regionSelected[1] || VennDiagramViewer.this.regionSelected[3] || VennDiagramViewer.this.regionSelected[5];
                ((VennDiagramViewer)VennDiagramViewer.this).circleSelected[2] = VennDiagramViewer.this.regionSelected[0] || VennDiagramViewer.this.regionSelected[2] || VennDiagramViewer.this.regionSelected[3] || VennDiagramViewer.this.regionSelected[6];
                VennDiagramViewer.this.find3ClusterInfluences();
            }
            if (VennDiagramViewer.this.clusterCount == 2) {
                ((VennDiagramViewer)VennDiagramViewer.this).regionSelected[VennDiagramViewer.this.getRegion((int)event.getX(), (int)event.getY())] = !VennDiagramViewer.this.regionSelected[VennDiagramViewer.this.getRegion(event.getX(), event.getY())];
                ((VennDiagramViewer)VennDiagramViewer.this).circleSelected[0] = VennDiagramViewer.this.regionSelected[0] || VennDiagramViewer.this.regionSelected[1] || VennDiagramViewer.this.regionSelected[2] || VennDiagramViewer.this.regionSelected[4];
                ((VennDiagramViewer)VennDiagramViewer.this).circleSelected[1] = VennDiagramViewer.this.regionSelected[0] || VennDiagramViewer.this.regionSelected[1] || VennDiagramViewer.this.regionSelected[3] || VennDiagramViewer.this.regionSelected[5];
                ((VennDiagramViewer)VennDiagramViewer.this).circleSelected[2] = false;
                VennDiagramViewer.this.find2ClusterInfluences();
            }
            VennDiagramViewer.this.repaint();
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                VennDiagramViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
                VennDiagramViewer.this.repaint();
            }
        }
    }

    private class Circle {
        int x;
        int y;
        int diameter;
        int label_x;
        int label_y;
        int center_x;
        int center_y;
        String label;

        private Circle() {
            this.label = "no label";
        }

        private Circle(String tag) {
            this.label = tag;
        }

        void setTag(String tag) {
            this.label = tag;
        }

        boolean pointInCircle(int x, int y) {
            return (x - this.center_x) * (x - this.center_x) + (y - this.center_y) * (y - this.center_y) - this.diameter / 2 * this.diameter / 2 <= 0;
        }
    }
}

