/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.annotation.AnnoAttributeObj;
import org.tigr.microarray.mev.annotation.InsufficientArgumentsException;
import org.tigr.microarray.mev.annotation.PublicURL;
import org.tigr.microarray.mev.annotation.URLNotFoundException;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;

public class TableViewer
extends JPanel
implements IViewer {
    protected static final String BROADCAST_MATRIX_GAGGLE_CMD = "broadcast-matrix-to-gaggle";
    protected static final String BROADCAST_NAMELIST_GAGGLE_CMD = "broadcast-namelist-to-gaggle";
    protected JTable table;
    protected TableModel model;
    protected JScrollPane pane;
    protected IFramework framework;
    private int exptID = 0;
    protected Object[][] data;
    protected String[] headerNames;

    public TableViewer() {
    }

    public TableViewer(String[] headerNames, Object[][] data) {
        this.data = data;
        this.headerNames = headerNames;
        this.model = new DefaultViewerTableModel(headerNames, data);
        this.table = new JTable(this.model);
        ((DefaultViewerTableModel)this.model).setColumnRenderers(this.table);
        this.table.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        this.pane = new JScrollPane(this.table);
        this.pane.setHorizontalScrollBarPolicy(32);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.headerNames, this.data});
    }

    @Override
    public void setExperiment(Experiment e) {
    }

    public void setTableModel(TableModel model) {
        this.model = model;
        this.table.setModel(model);
    }

    public JTable getTable() {
        return this.table;
    }

    public TableModel getTableModel() {
        return this.table.getModel();
    }

    public JTableHeader getTableHeader() {
        return this.table.getTableHeader();
    }

    public void setNumerical(int columnIndex, boolean setting) {
        if (this.model instanceof DefaultViewerTableModel) {
            ((DefaultViewerTableModel)this.model).setNumerical(columnIndex, setting);
        }
    }

    public int getSelectedRow() {
        int index = this.table.getSelectedRow();
        index = index < 0 ? -1 : ((DefaultViewerTableModel)this.model).getRow(index);
        return index;
    }

    public static void main(String[] args) {
        String[] headers = new String[]{"Gene", "GenBank #", "Common Name"};
        Object[][] data = new Object[3][3];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                data[i][j] = i == 1 ? "1000" : Integer.toString(i * j + j);
            }
        }
        TableViewer tv = new TableViewer(headers, data);
        tv.setNumerical(0, true);
        tv.setNumerical(1, true);
        tv.setNumerical(2, false);
        JFrame frame = new JFrame();
        frame.getContentPane().add(tv);
        frame.setSize(100, 100);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    @Override
    public JComponent getContentComponent() {
        return this.table;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.table.getTableHeader();
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public void onClosed() {
    }

    @Override
    public void onDataChanged(IData data) {
    }

    @Override
    public void onDeselected() {
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    @Override
    public int[][] getClusters() {
        return null;
    }

    @Override
    public Experiment getExperiment() {
        return null;
    }

    @Override
    public int getViewerType() {
        return -1;
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void setExperimentID(int id) {
        this.exptID = id;
    }

    public class TableHeaderMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getModifiers() == 16 && evt.getClickCount() > 1 && TableViewer.this.model instanceof DefaultViewerTableModel) {
                JTableHeader header = (JTableHeader)evt.getSource();
                int tableCol = header.columnAtPoint(evt.getPoint());
                int modelCol = TableViewer.this.table.convertColumnIndexToModel(tableCol);
                ((DefaultViewerTableModel)TableViewer.this.model).sort(modelCol);
            }
        }
    }

    public class CellRenderer
    extends DefaultTableCellRenderer {
        JPanel colorPanel = new JPanel();
        JLabel label;
        JTextArea textArea = new JTextArea();
        LinkComponent linkComponent = new LinkComponent();

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean param, boolean param3, int row, int col) {
            if (obj instanceof Color) {
                this.colorPanel.setBackground((Color)obj);
                return this.colorPanel;
            }
            if (obj instanceof JLabel) {
                this.label = (JLabel)obj;
                this.label.setOpaque(true);
                this.label.setFont(new Font("Arial", 0, 12));
                this.label.setBackground(new Color(225, 225, 225));
                this.label.setForeground(Color.black);
                this.label.setHorizontalAlignment(0);
                if (TableViewer.this.table.isRowSelected(row)) {
                    this.label.setBackground(TableViewer.this.table.getSelectionBackground());
                }
                return this.label;
            }
            if (obj instanceof JTextArea) {
                this.textArea = (JTextArea)obj;
                if (TableViewer.this.table.isRowSelected(row)) {
                    this.textArea.setBackground(TableViewer.this.table.getSelectionBackground());
                }
                return this.textArea;
            }
            if (obj instanceof AnnoAttributeObj) {
                try {
                    String url = PublicURL.getURL((String)((AnnoAttributeObj)obj).getAttribName(), (String[])new String[]{((AnnoAttributeObj)obj).getAttributeAt(0).toString()});
                    this.linkComponent.setLink(url, obj.toString());
                }
                catch (URLNotFoundException unfe) {
                    this.linkComponent.setLink("http://www.tm4.org/", "test");
                }
                catch (InsufficientArgumentsException iae) {
                    this.linkComponent.setLink("http://www.tm4.org/", "test");
                }
                return this.linkComponent;
            }
            if (obj != null) {
                this.textArea.setText(obj.toString());
            } else {
                this.textArea.setText("null");
            }
            if (TableViewer.this.table.isRowSelected(row)) {
                this.textArea.setBackground(TableViewer.this.table.getSelectionBackground());
            } else {
                this.textArea.setBackground(TableViewer.this.table.getBackground());
            }
            return this.textArea;
        }
    }

    public class LinkComponent
    extends JEditorPane {
        public LinkComponent() {
            this.setEditable(false);
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hle) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                        // empty if block
                    }
                }
            });
        }

        public void setLink(String url, String linktext) {
            this.setText("<a href=\"" + url + "\">" + linktext + "</a>");
        }
    }

    public class DefaultViewerTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] tableData;
        boolean[] numerical;
        Row[] rows;
        int colToSort = 0;
        boolean ascending = false;

        public DefaultViewerTableModel(String[] headerNames, Object[][] data) {
            this.columnNames = headerNames;
            this.tableData = data;
            this.numerical = new boolean[headerNames.length];
            this.rows = new Row[data.length];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
        }

        public void setColumnRenderers(JTable table) {
            CellRenderer c = new CellRenderer();
            for (int vColIndex = 0; vColIndex < table.getColumnCount(); ++vColIndex) {
                TableColumn col = table.getColumnModel().getColumn(vColIndex);
                col.setCellRenderer(c);
            }
        }

        public void setNumerical(int col, boolean numericalBool) {
            if (col > -1 && col < this.numerical.length) {
                this.numerical[col] = numericalBool;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.tableData == null) {
                return 0;
            }
            return this.tableData.length;
        }

        @Override
        public Object getValueAt(int param, int param1) {
            if (this.tableData != null && param < this.tableData.length && param1 < this.tableData[param].length) {
                return this.tableData[this.rows[param].index][param1];
            }
            return null;
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        private boolean isNumerical(int col) {
            return this.numerical[col];
        }

        public void sort(int col) {
            this.ascending = !this.ascending;
            this.colToSort = col;
            Arrays.sort(this.rows);
            this.fireTableDataChanged();
        }

        public int getRow(int tableRow) {
            return this.rows[tableRow].index;
        }

        private class Row
        implements Comparable,
        Serializable {
            public int index;
            private String myString;
            private String otherString;

            private Row() {
            }

            public int compareTo(Object other) {
                if (DefaultViewerTableModel.this.ascending) {
                    return this.compareToOther(other);
                }
                return this.compareToOther(other) * -1;
            }

            public int compareToOther(Object other) {
                Row otherRow = (Row)other;
                Object myObject = DefaultViewerTableModel.this.tableData[this.index][DefaultViewerTableModel.this.colToSort];
                Object otherObject = DefaultViewerTableModel.this.tableData[otherRow.index][DefaultViewerTableModel.this.colToSort];
                if (myObject instanceof Comparable) {
                    if (DefaultViewerTableModel.this.isNumerical(DefaultViewerTableModel.this.colToSort) && myObject instanceof String) {
                        Float myFloat = new Float((String)myObject);
                        Float otherFloat = new Float((String)otherObject);
                        return myFloat.compareTo(otherFloat);
                    }
                    return ((Comparable)myObject).compareTo(otherObject);
                }
                if (myObject instanceof JLabel) {
                    this.myString = ((JLabel)myObject).getText();
                    this.otherString = ((JLabel)otherObject).getText();
                    return this.myString.compareTo(this.otherString);
                }
                return this.index - otherRow.index;
            }
        }
    }
}

