/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.QSort;

public class ResultDataTable
implements IViewer {
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String STORE_SELECTED_ROWS_CMD = "store-selected-rows-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    protected static final String LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD = "launch-new-session-with-sel-rows-cmd";
    protected static final String SEARCH_CMD = "search-cmd";
    protected static final String CLEAR_ALL_CMD = "clear-all-cmd";
    protected static final String COPY_CMD = "copy-cells";
    protected static final String SELECT_ALL_CMD = "select-all-cmd";
    protected static final String SORT_ORIG_ORDER_CMD = "sort-orig-order-cmd";
    protected static final String BROADCAST_MATRIX_GAGGLE_CMD = "broadcast-matrix-to-gaggle";
    protected static final String BROADCAST_SELECTED_MATRIX_GAGGLE_CMD = "broadcast-selected-matrix-to-gaggle";
    protected static final String BROADCAST_NAMELIST_GAGGLE_CMD = "broadcast-namelist-to-gaggle";
    public static final String BROADCAST_MATRIX_GENOME_BROWSER_CMD = "broadcast-matrix-to-genome-browser";
    public static final int INTEGER_TYPE = 10;
    public static final int FLOAT_TYPE = 11;
    public static final int DOUBLE_TYPE = 12;
    public static final int STRING_TYPE = 13;
    public static final int BOOLEAN_TYPE = 14;
    private JComponent header;
    private JPopupMenu popup;
    private Object[][] data;
    private int[] indices;
    private int[] sortedIndices;
    private String[] columnTitles;
    private boolean[] sortedAscending;
    private JTable clusterTable;
    private ClusterTableModel clusterModel;
    private int exptID = 0;

    public ResultDataTable(Object[][] data, String[] auxTitles) {
        this.data = data;
        this.indices = new int[data.length];
        this.sortedIndices = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.indices[i] = i;
            this.sortedIndices[i] = i;
        }
        this.columnTitles = auxTitles;
        this.clusterModel = new ClusterTableModel();
        this.clusterTable = new JTable(this.clusterModel);
        this.clusterTable.setCellSelectionEnabled(true);
        TableColumn column = null;
        for (int i = 0; i < this.clusterModel.getColumnCount(); ++i) {
            column = this.clusterTable.getColumnModel().getColumn(i);
            column.setMinWidth(30);
        }
        this.sortedAscending = new boolean[this.clusterModel.getColumnCount()];
        for (int j = 0; j < this.sortedAscending.length; ++j) {
            this.sortedAscending[j] = false;
        }
        this.addMouseListenerToHeaderInTable(this.clusterTable);
        this.header = this.clusterTable.getTableHeader();
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.clusterTable.addMouseListener(listener);
    }

    public ResultDataTable(double[][] ds, String[] measures) {
        this(ResultDataTable.convertDMtoOM(ds), measures);
    }

    public ResultDataTable(HashMap optimalScores, String[] measures) {
        this(ResultDataTable.getObjectFromHashMap(optimalScores, measures), ResultDataTable.geCLVALIDTitles());
    }

    private static String[] geCLVALIDTitles() {
        String[] titles = new String[]{"", "Score", "Method", "Clusters"};
        return titles;
    }

    private static Object[][] getObjectFromHashMap(HashMap optimalScores, String[] measures) {
        Object[][] data = new Object[measures.length][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new Object[4];
            data[i][0] = measures[i];
            data[i][1] = ((double[])optimalScores.get("scores"))[i];
            data[i][2] = ((String[])optimalScores.get("method"))[i];
            data[i][3] = ((String[])optimalScores.get("clusters"))[i];
        }
        return data;
    }

    private static Object[][] convertDMtoOM(double[][] ds) {
        Object[][] ob = new Object[ds.length][];
        for (int i = 0; i < ds.length; ++i) {
            ob[i] = new Object[ds[i].length];
            for (int j = 0; j < ds[i].length; ++j) {
                ob[i][j] = ds[i][j];
            }
        }
        return ob;
    }

    public JTable getTable() {
        return this.clusterTable;
    }

    @Override
    public Expression getExpression() {
        return null;
    }

    protected String[] getAuxTitles() {
        return this.columnTitles;
    }

    @Override
    public void setExperiment(Experiment e) {
        this.exptID = e.getId();
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void setExperimentID(int id) {
        this.exptID = id;
    }

    @Override
    public JComponent getContentComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.gray);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        constraints.anchor = 11;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.clusterTable, constraints);
        panel.add(this.clusterTable);
        return panel;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    @Override
    public JComponent getHeaderComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.header, constraints);
        panel.add(this.header);
        return panel;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public void onClosed() {
    }

    @Override
    public void onDataChanged(IData data) {
    }

    @Override
    public void onDeselected() {
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
    }

    @Override
    public void onSelected(IFramework framework) {
    }

    public void setClusterIndex(int clusterIndex) {
    }

    public int getClusterIndex() {
        return 0;
    }

    public int[] getCluster() {
        return this.indices;
    }

    @Override
    public int[][] getClusters() {
        int[][] cls = new int[][]{this.indices};
        return cls;
    }

    public int[] getSortedCluster() {
        return this.sortedIndices;
    }

    protected int getProbe(int row) {
        return this.indices[row];
    }

    @Override
    public Experiment getExperiment() {
        return null;
    }

    public IData getData() {
        return null;
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(true);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int controlPressed = e.getModifiers() & 2;
                    boolean originalOrder = controlPressed != 0;
                    ResultDataTable.this.sortByColumn(column, !ResultDataTable.this.sortedAscending[column], originalOrder);
                    boolean bl = ((ResultDataTable)ResultDataTable.this).sortedAscending[column] = !ResultDataTable.this.sortedAscending[column];
                    if (originalOrder) {
                        for (int i = 0; i < ResultDataTable.this.clusterModel.getColumnCount(); ++i) {
                            ((ResultDataTable)ResultDataTable.this).sortedAscending[i] = false;
                        }
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void sortByColumn(int column, boolean ascending, boolean originalOrder) {
        if (originalOrder) {
            for (int i = 0; i < this.getSortedCluster().length; ++i) {
                this.sortedIndices[i] = this.getCluster()[i];
            }
            this.clusterTable.repaint();
            this.clusterTable.clearSelection();
            return;
        }
        int[] sortedArray = new int[this.getCluster().length];
        int obType = ResultDataTable.getObjectType(this.data[0][column]);
        if (obType == 12 || obType == 11 || obType == 10) {
            double[] origArray = new double[this.getCluster().length];
            for (int i = 0; i < origArray.length; ++i) {
                if (obType == 12) {
                    origArray[i] = (Double)this.data[this.getCluster()[i]][column];
                    continue;
                }
                if (obType == 11) {
                    origArray[i] = ((Float)this.data[this.getCluster()[i]][column]).doubleValue();
                    continue;
                }
                if (obType != 10) continue;
                origArray[i] = ((Integer)this.data[this.getCluster()[i]][column]).doubleValue();
            }
            QSort sortArray = new QSort(origArray);
            int[] sortedPrimaryIndices = sortArray.getOrigIndx();
            for (int i = 0; i < sortedPrimaryIndices.length; ++i) {
                sortedArray[i] = this.getCluster()[sortedPrimaryIndices[i]];
            }
        } else if (obType == 13) {
            int i;
            Object[] sortFields = new SortableField[this.getCluster().length];
            for (i = 0; i < sortFields.length; ++i) {
                int currIndex = this.getCluster()[i];
                String currField = (String)this.data[this.getCluster()[i]][column];
                sortFields[i] = new SortableField(currIndex, currField);
            }
            Arrays.sort(sortFields);
            for (i = 0; i < sortFields.length; ++i) {
                sortedArray[i] = ((SortableField)sortFields[i]).getIndex();
            }
        }
        if (!ascending) {
            sortedArray = this.reverse(sortedArray);
        }
        for (int i = 0; i < this.getSortedCluster().length; ++i) {
            this.sortedIndices[i] = sortedArray[i];
        }
        this.clusterTable.repaint();
        this.clusterTable.removeRowSelectionInterval(0, this.clusterTable.getRowCount() - 1);
    }

    private static int getObjectType(Object obj) {
        int obType = -1;
        if (obj instanceof Boolean) {
            return 14;
        }
        if (obj instanceof Double) {
            return 12;
        }
        if (obj instanceof Float) {
            return 11;
        }
        if (obj instanceof Integer) {
            return 10;
        }
        if (obj instanceof String) {
            return 13;
        }
        return obType;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    public void launchNewSession() {
    }

    public void launchNewSessionWithSelectedRows() {
    }

    public void copyCells() {
        TransferHandler th = this.clusterTable.getTransferHandler();
        if (th != null) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            th.exportToClipboard(this.clusterTable, cb, 1);
        }
    }

    public void sortInOrigOrder() {
        int i;
        for (i = 0; i < this.getSortedCluster().length; ++i) {
            this.sortedIndices[i] = this.getCluster()[i];
        }
        this.clusterTable.repaint();
        this.clusterTable.clearSelection();
        for (i = 0; i < this.clusterModel.getColumnCount(); ++i) {
            this.sortedAscending[i] = false;
        }
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        menu.addSeparator();
        JMenuItem menuItem = new JMenuItem("Search...", GUIFactory.getIcon((String)"ClusterInformationResult.gif"));
        menuItem.setActionCommand(SEARCH_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Copy", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(COPY_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Select all rows...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(SELECT_ALL_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Clear all selections...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(CLEAR_ALL_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Sort table in original order...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(SORT_ORIG_ORDER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
    }

    @Override
    public int getViewerType() {
        return -1;
    }

    protected void broadcastClusterGaggle() {
    }

    protected void broadcastSelectedClusterGaggle() {
    }

    protected void broadcastNamelistGaggle() {
    }

    public void broadcastGeneClusterToGenomeBrowser() {
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (!(command.equals(ResultDataTable.LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD) || command.equals(ResultDataTable.SEARCH_CMD) || command.equals(ResultDataTable.CLEAR_ALL_CMD))) {
                if (command.equals(ResultDataTable.COPY_CMD)) {
                    ResultDataTable.this.copyCells();
                } else if (command.equals(ResultDataTable.SELECT_ALL_CMD)) {
                    ResultDataTable.this.clusterTable.selectAll();
                } else if (command.equals(ResultDataTable.SORT_ORIG_ORDER_CMD)) {
                    ResultDataTable.this.sortInOrigOrder();
                } else if (command.equals(ResultDataTable.BROADCAST_MATRIX_GAGGLE_CMD) || command.equals(ResultDataTable.BROADCAST_SELECTED_MATRIX_GAGGLE_CMD) || command.equals(ResultDataTable.BROADCAST_NAMELIST_GAGGLE_CMD) || command.equals(ResultDataTable.BROADCAST_MATRIX_GENOME_BROWSER_CMD)) {
                    // empty if block
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || ResultDataTable.this.getCluster() == null || ResultDataTable.this.getCluster().length == 0) {
                return;
            }
            ResultDataTable.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int index, String field) {
            this.index = index;
            this.field = field;
        }

        public int compareTo(Object other) {
            SortableField otherField = (SortableField)other;
            return this.field.compareTo(otherField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class ClusterTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        String[] columnNames;
        boolean hasAnnotation = true;

        public ClusterTableModel() {
            this.columnNames = new String[ResultDataTable.this.columnTitles.length];
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columnNames[i] = ResultDataTable.this.columnTitles[i];
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return ResultDataTable.this.getCluster().length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return String.valueOf(ResultDataTable.this.data[ResultDataTable.this.getSortedCluster()[row]][col]);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

