/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.util.QSort;

public class KMGraphViewer
extends JPanel
implements IViewer {
    KMGraph viewer;
    float minX;
    float maxX;
    float minY;
    float maxY;
    boolean firstView = true;
    DecimalFormat format;
    Vector<float[]> timeses = new Vector();
    Vector<boolean[]> statuses;
    Vector<Color> colors;
    String eventAnnLabel;
    Vector<Vector<Float>> timesIn;
    Vector<Vector<Boolean>> statusIn;

    public KMGraphViewer(Vector<Vector<Float>> timesIn, Vector<Color> colors, String eventAnnLabel) {
        this.eventAnnLabel = eventAnnLabel;
        this.colors = colors;
        this.statuses = null;
        this.timesIn = timesIn;
        try {
            this.timeses = new Vector();
            float[][] datapoints = new float[2][timesIn.get(0).size()];
            for (int i = 0; i < datapoints[0].length; ++i) {
                datapoints[0][i] = timesIn.get(0).get(i).floatValue();
                datapoints[1][i] = timesIn.get(1).get(i).floatValue();
            }
            this.timeses.add(datapoints[0]);
            this.initializeViewer();
            this.enterGraphData(datapoints, Color.black);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public KMGraphViewer(Vector<Vector<Float>> timesIn, Vector<Vector<Boolean>> statusIn, Vector<Color> colors, String eventAnnLabel) {
        int i;
        this.statuses = new Vector();
        this.timesIn = timesIn;
        this.statusIn = statusIn;
        this.eventAnnLabel = eventAnnLabel;
        for (i = 0; i < timesIn.size(); ++i) {
            Vector<Float> thisfloatList = timesIn.get(i);
            Vector<Boolean> thisstatusList = statusIn.get(i);
            this.timeses.add(i, new float[thisfloatList.size()]);
            this.statuses.add(i, new boolean[thisstatusList.size()]);
            for (int j = 0; j < thisfloatList.size(); ++j) {
                this.timeses.get((int)i)[j] = thisfloatList.get(j).floatValue();
                this.statuses.get((int)i)[j] = thisstatusList.get(j);
            }
        }
        this.colors = colors;
        this.initializeViewer();
        assert (this.statuses.size() == this.timeses.size());
        for (i = 0; i < this.timeses.size(); ++i) {
            QSort qs = new QSort(this.timeses.get(i));
            float[] sortedTimes = qs.getSorted();
            int[] originalIndex = qs.getOrigIndx();
            this.enterGraphData(originalIndex, sortedTimes, this.statuses.get(i), colors.get(i));
        }
    }

    @Override
    public Expression getExpression() {
        if (this.statuses == null) {
            Expression e = new Expression(this, this.getClass(), "new", new Object[]{this.timesIn, this.colors, this.eventAnnLabel});
            System.out.println(e.toString());
            return e;
        }
        return new Expression(this, this.getClass(), "new", new Object[]{this.timesIn, this.statusIn, this.colors, this.eventAnnLabel});
    }

    private void initializeViewer() {
        this.minX = this.findMinDistance(this.timeses);
        this.maxX = this.findMaxDistance(this.timeses);
        this.minY = 0.0f;
        this.maxY = 1.0f;
        this.viewer = new KMGraph();
        this.viewer.setYAxisValue(this.minX);
        this.viewer.setXAxisValue(this.minY);
        this.viewer.setShowCoordinates(true);
    }

    private float findMinDistance(Vector<float[]> timeses) {
        float min = Float.POSITIVE_INFINITY;
        for (int j = 0; j < timeses.size(); ++j) {
            float[] alltimes = timeses.get(j);
            for (int i = 0; i < alltimes.length; ++i) {
                min = Math.min(min, alltimes[i]);
            }
        }
        return min;
    }

    private float findMaxDistance(Vector<float[]> timeses) {
        float max = 0.0f;
        for (int j = 0; j < timeses.size(); ++j) {
            float[] alltimes = timeses.get(j);
            for (int i = 0; i < alltimes.length; ++i) {
                max = Math.max(max, alltimes[i]);
            }
        }
        return max;
    }

    private void enterGraphData(float[][] datapoints, Color color) {
        int i;
        int numEvents = datapoints[0].length;
        float lastX = 0.0f;
        float lastY = 1.0f;
        for (i = 0; i < numEvents; ++i) {
            float thisX = datapoints[0][i];
            float thisY = datapoints[1][i];
            this.viewer.addGraphElement((GraphElement)new GraphLine((double)lastX, (double)lastY, (double)lastX, (double)thisY, color));
            this.viewer.addGraphElement((GraphElement)new GraphLine((double)lastX, (double)thisY, (double)thisX, (double)thisY, color));
            lastX = thisX;
            lastY = thisY;
        }
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(2);
        for (i = 0; i <= 10; ++i) {
            if (this.minX >= 0.0f) {
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)((this.maxX - this.minX) / 10.0f * (float)i), 5, Color.black, 0, 0, String.valueOf(this.format.format((this.maxX - this.minX) / 10.0f * (float)i)), Color.black));
            } else {
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)(this.minX + (this.maxX - this.minX) / 10.0f * (float)i), 5, Color.black, 0, 0, String.valueOf(this.format.format(this.minX + (this.maxX - this.minX) / 10.0f * (float)i)), Color.black));
            }
            String temp = NumberFormat.getInstance().format(this.maxY / 10.0f * (float)i);
            this.viewer.addGraphElement((GraphElement)new GraphTick((double)((float)i / 10.0f), 5, Color.black, 1, 0, temp, Color.black));
        }
    }

    private void enterGraphData(int[] originalIndex, float[] sortedTimes, boolean[] status, Color color) {
        int i;
        int numEvents = sortedTimes.length;
        float cumulativeProb = 1.0f;
        int numberAtRisk = numEvents;
        if (numEvents > 1) {
            this.viewer.addGraphElement((GraphElement)new GraphLine((double)this.minX, (double)this.maxY, (double)sortedTimes[0], (double)this.maxY, color));
        }
        for (i = 0; i < numEvents; ++i) {
            if (status[originalIndex[i]]) {
                this.viewer.addGraphElement((GraphElement)new GraphLine((double)sortedTimes[i], (double)cumulativeProb + 0.01, (double)sortedTimes[i], (double)cumulativeProb - 0.01, color));
            } else {
                float dailyProb = (float)(numberAtRisk - 1) / (float)numberAtRisk;
                float oldProb = cumulativeProb;
                this.viewer.addGraphElement((GraphElement)new GraphLine((double)sortedTimes[i], (double)oldProb, (double)sortedTimes[i], (double)(cumulativeProb *= dailyProb), color));
            }
            --numberAtRisk;
            if (i >= numEvents - 1) continue;
            this.viewer.addGraphElement((GraphElement)new GraphLine((double)sortedTimes[i], (double)cumulativeProb, (double)sortedTimes[i + 1], (double)cumulativeProb, color));
        }
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(2);
        for (i = 0; i <= 10; ++i) {
            if (this.minX >= 0.0f) {
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)((this.maxX - this.minX) / 10.0f * (float)i), 5, Color.black, 0, 0, String.valueOf(this.format.format((this.maxX - this.minX) / 10.0f * (float)i)), Color.black));
            } else {
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)(this.minX + (this.maxX - this.minX) / 10.0f * (float)i), 5, Color.black, 0, 0, String.valueOf(this.format.format(this.minX + (this.maxX - this.minX) / 10.0f * (float)i)), Color.black));
            }
            String temp = NumberFormat.getInstance().format(this.maxY / 10.0f * (float)i);
            this.viewer.addGraphElement((GraphElement)new GraphTick((double)((float)i / 10.0f), 5, Color.black, 1, 0, temp, Color.black));
        }
    }

    private void printGraphData() {
        for (int i = 0; i < this.timeses.size(); ++i) {
            QSort qs = new QSort(this.timeses.get(i));
            float[] sortedTimes = qs.getSorted();
            int[] originalIndex = qs.getOrigIndx();
            boolean[] statuses = this.statuses.get(i);
            int numEvents = sortedTimes.length;
            float cumulativeProb = 1.0f;
            int numberAtRisk = numEvents;
            System.out.println("n.risk\tsurvival\tdailyrisk");
            for (int j = 0; j < numEvents; ++j) {
                if (!statuses[originalIndex[j]]) {
                    float dailyProb = (float)(numberAtRisk - 1) / (float)numberAtRisk;
                    float oldProb = cumulativeProb;
                    System.out.println(numberAtRisk + "\t" + (cumulativeProb *= dailyProb) + "\t" + dailyProb);
                }
                --numberAtRisk;
            }
        }
    }

    private void onSaveGraphData() {
        JFileChooser chooser = new JFileChooser(TMEV.getDataPath());
        if (chooser.showSaveDialog(this) == 0) {
            try {
                PrintWriter bw = new PrintWriter(new FileWriter(chooser.getSelectedFile()));
                for (int i = 0; i < this.timeses.size(); ++i) {
                    QSort qs = new QSort(this.timeses.get(i));
                    float[] sortedTimes = qs.getSorted();
                    int[] originalIndex = qs.getOrigIndx();
                    boolean[] statuses = this.statuses.get(i);
                    int numEvents = sortedTimes.length;
                    float cumulativeProb = 1.0f;
                    int numberAtRisk = numEvents;
                    System.out.println("n.risk\tsurvival\tdailyrisk");
                    for (int j = 0; j < numEvents; ++j) {
                        if (!statuses[originalIndex[j]]) {
                            float dailyProb = (float)(numberAtRisk - 1) / (float)numberAtRisk;
                            float oldProb = cumulativeProb;
                            System.out.println(numberAtRisk + "\t" + (cumulativeProb *= dailyProb) + "\t" + dailyProb);
                        }
                        --numberAtRisk;
                    }
                }
                bw.flush();
                bw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    @Override
    public void onDeselected() {
    }

    @Override
    public void onDataChanged(IData data) {
    }

    @Override
    public void onClosed() {
    }

    @Override
    public JComponent getContentComponent() {
        return this.viewer;
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    @Override
    public void onSelected(IFramework framework) {
        if (this.firstView && this.viewer.isVisible()) {
            Graphics g = this.viewer.getGraphics();
            FontMetrics metrics = g.getFontMetrics(new Font("SansSerif", 1, 10));
            int preX = metrics.stringWidth(String.valueOf(this.format.format(this.maxX)));
            int preY = metrics.stringWidth(String.valueOf(this.format.format(this.maxY)));
            metrics = g.getFontMetrics(new Font("SansSerif", 1, 12));
            this.viewer.setPreXSpacing((preY += metrics.getHeight()) + 10);
            this.viewer.setPostYSpacing((preX += metrics.getHeight()) + 20);
            this.firstView = false;
        }
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
    }

    @Override
    public JComponent getHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public void setViewer(KMGraph val) {
        this.viewer = val;
    }

    public GraphViewer getViewer() {
        return this.viewer;
    }

    @Override
    public int[][] getClusters() {
        return null;
    }

    @Override
    public Experiment getExperiment() {
        return null;
    }

    @Override
    public void setExperiment(Experiment e) {
    }

    @Override
    public int getExperimentID() {
        return 0;
    }

    @Override
    public void setExperimentID(int id) {
    }

    @Override
    public int getViewerType() {
        return -1;
    }

    public class KMGraph
    extends GraphViewer {
        public KMGraph() {
            super(null, (int)KMGraphViewer.this.minX, (int)KMGraphViewer.this.maxX, (int)KMGraphViewer.this.minY, (int)KMGraphViewer.this.maxY, (double)KMGraphViewer.this.minX, (double)KMGraphViewer.this.maxX, (double)KMGraphViewer.this.minY, (double)KMGraphViewer.this.maxY, 50, 50, 50, 50, "Survival over Time", "Time (" + KMGraphViewer.this.eventAnnLabel + ")", "Survival Likelihood");
            JMenuItem dataOutputItem = new JMenuItem("Output Graph Data");
            dataOutputItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    KMGraphViewer.this.printGraphData();
                    KMGraphViewer.this.onSaveGraphData();
                }
            });
            this.popup.addSeparator();
            this.popup.add(dataOutputItem);
        }
    }
}

