/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.TMEV;

public class GenomeBrowserWebstart {
    public static Process runtimeProc;

    public static void onWebstartGenomeBrowser(String organism) {
        String jnlpContent = GenomeBrowserWebstart.createGenomeBrowserJNLP(organism);
        try {
            File jnlpFile = File.createTempFile("genome_browser_launch", ".jnlp");
            BufferedWriter out = new BufferedWriter(new FileWriter(jnlpFile));
            out.write(jnlpContent);
            out.close();
            GenomeBrowserWebstart.startGenomeBrowser(jnlpFile.getAbsolutePath());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(new JFrame(), "Error creating jnlp file", "Cytoscape will not launch", 0);
        }
    }

    private static void startGenomeBrowser(String jnlpURI) {
        String command = System.getProperty("java.home");
        command = System.getProperty("os.name").toLowerCase().contains("win") ? command + File.separator + "bin" + File.separator + "javaws \"" + jnlpURI + "\"" : command + File.separator + "bin" + File.separator + "javaws " + jnlpURI;
        try {
            runtimeProc = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(new JFrame(), "Error launching Cytoscape", "Webstart Could not launch properly", 0);
            e.printStackTrace();
        }
    }

    private static String createGenomeBrowserJNLP(String organism) {
        String xml = "";
        String args = "    <argument>-d</argument>\n    <argument>http://gaggle.systemsbiology.net/projects/halo/2007-04/genomebrowser/data/halo_tiling.hbgb</argument>\n";
        try {
            String thisLine;
            InputStream in = TMEV.class.getClassLoader().getResourceAsStream("org/tigr/microarray/mev/cluster/gui/helpers/genomebrowser_jnlp_template.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((thisLine = br.readLine()) != null) {
                xml = xml + thisLine + "\n";
            }
            xml = xml.replaceFirst("@args@", args);
        }
        catch (IOException ioe) {
            ShowThrowableDialog.show((Frame)new JFrame(), (String)"Could not launch Genome Browser", (boolean)true, (int)64, (Throwable)ioe, (String)"Could not launch the Genome Browser. Please try launching it manually.");
        }
        catch (NullPointerException npe) {
            ShowThrowableDialog.show((Frame)new JFrame(), (String)"Could not launch Genome Browser", (boolean)true, (int)64, (Throwable)npe, (String)"Could not launch the Genome Browser. Please try launching it manually.");
        }
        return xml;
    }

    public static boolean isCompleteChrLocation(String chrlocation) {
        if (chrlocation.startsWith("chrNA")) {
            return false;
        }
        return Pattern.matches("^chr\\w{1,2}:\\d+-\\d+$", chrlocation);
    }
}

