/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.util.BrowserLauncher;
import org.tigr.util.StringSplitter;

public class GSEAURLLinkDialog
extends AlgorithmDialog {
    File file;
    JComboBox annotationFieldsBox;
    JComboBox urlTypesBox;
    String[] urlTemplates;
    String[] urlKeys;
    IData data;
    Experiment experiment;
    int row;
    private int[] lastSelectedIndices;
    boolean okPressed = false;
    String annotationKey;
    boolean hasAnnotationKey = false;
    String colName;

    public GSEAURLLinkDialog(JFrame parent, boolean modal, String annotationKey, int row, String colName, File file) {
        super(parent, "Link annotation to URL", modal);
        this.file = file;
        this.row = row;
        this.colName = colName;
        this.lastSelectedIndices = ExperimentUtil.lastSelectedAnnotationIndices;
        this.hasAnnotationKey = true;
        this.annotationKey = annotationKey;
        this.setBounds(0, 0, 500, 300);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        this.populateFields();
        this.annotationFieldsBox.setSelectedIndex(0);
        this.urlTypesBox.setSelectedIndex(0);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        JPanel topPanel = new JPanel();
        topPanel.setBackground(Color.white);
        topPanel.setBorder(new TitledBorder("Select annotation to link out from"));
        GridBagLayout grid1 = new GridBagLayout();
        topPanel.setLayout(grid1);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        grid1.setConstraints(this.annotationFieldsBox, constraints);
        topPanel.add(this.annotationFieldsBox);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBackground(Color.white);
        bottomPanel.setBorder(new TitledBorder("Select internet resource to link to"));
        GridBagLayout grid2 = new GridBagLayout();
        bottomPanel.setLayout(grid2);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        grid2.setConstraints(this.urlTypesBox, constraints);
        bottomPanel.add(this.urlTypesBox);
        constraints.fill = 1;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 50);
        gridbag.setConstraints(topPanel, constraints);
        pane.add(topPanel);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 50);
        gridbag.setConstraints(bottomPanel, constraints);
        pane.add(bottomPanel);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    private void populateFields() {
        Vector annotFieldsVector = new Vector();
        Vector<String> urlKeysVector = new Vector<String>();
        Vector<String> urlTemplateVector = new Vector<String>();
        Vector<String> urlDescriptionVector = new Vector<String>();
        try {
            int i;
            FileReader fr = new FileReader(this.file);
            BufferedReader buff = new BufferedReader(fr);
            StringSplitter st = new StringSplitter('\t');
            boolean eof = false;
            while (!eof) {
                String line = buff.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                st.init(line);
                urlKeysVector.add(st.nextToken());
                urlTemplateVector.add(st.nextToken());
                urlDescriptionVector.add(st.nextToken());
            }
            buff.close();
            String[] urlDescriptions = new String[urlDescriptionVector.size()];
            for (i = 0; i < urlDescriptions.length; ++i) {
                urlDescriptions[i] = (String)urlDescriptionVector.get(i);
            }
            this.urlTypesBox = new JComboBox<String>(urlDescriptions);
            this.annotationFieldsBox = new JComboBox<String>(new String[]{this.colName});
            this.urlTemplates = new String[urlTemplateVector.size()];
            this.urlKeys = new String[urlKeysVector.size()];
            for (i = 0; i < this.urlTemplates.length; ++i) {
                this.urlTemplates[i] = (String)urlTemplateVector.get(i);
            }
            for (i = 0; i < this.urlKeys.length; ++i) {
                this.urlKeys[i] = (String)urlKeysVector.get(i);
            }
        }
        catch (FileNotFoundException fne) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not find \"annotation_URLs.txt\" file.", "Error", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Incompatible \"annotation_URLs.txt\" file. Possible issues: extra newline characters, too many or too few tabs per line", "Error", 0);
        }
    }

    private void launchBrowser(String annotationKey) {
        try {
            String urlToUse = this.getCurrentURL(annotationKey);
            BrowserLauncher.openURL((String)urlToUse);
        }
        catch (IOException ie) {
            JOptionPane.showMessageDialog(new JFrame(), ie.toString(), "Error", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Browser could not be launched! Possible problem: the annotation format may not be appropriate for this URL type!", "Error", 0);
        }
    }

    private String getCurrentURL(String annKey) {
        int fieldIndex = this.annotationFieldsBox.getSelectedIndex();
        int urlTemplateIndex = this.urlTypesBox.getSelectedIndex();
        String currentURLTemplate = this.urlTemplates[urlTemplateIndex];
        String currentURLKey = this.urlKeys[urlTemplateIndex];
        String urlToUse = "";
        String currentAnnotationString = annKey;
        if (currentURLKey.equals("UniGene")) {
            String[] splitAnnotation = currentAnnotationString.split("\\.");
            String s1 = currentURLTemplate.replaceAll("FIELD1", splitAnnotation[1]);
            urlToUse = s1.replaceAll("FIELD2", splitAnnotation[0]);
        } else {
            urlToUse = currentURLTemplate.replaceAll("FIELD1", currentAnnotationString);
        }
        return urlToUse;
    }

    public int[] getLastSelectedIndices() {
        return this.lastSelectedIndices;
    }

    public void setLastSelectedIndices() {
        this.lastSelectedIndices[0] = this.annotationFieldsBox.getSelectedIndex();
        this.lastSelectedIndices[1] = this.urlTypesBox.getSelectedIndex();
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                GSEAURLLinkDialog.this.okPressed = true;
                GSEAURLLinkDialog.this.setLastSelectedIndices();
                ExperimentUtil.lastSelectedAnnotationIndices = GSEAURLLinkDialog.this.getLastSelectedIndices();
                GSEAURLLinkDialog.this.launchBrowser(GSEAURLLinkDialog.this.annotationKey);
                GSEAURLLinkDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                GSEAURLLinkDialog.this.annotationFieldsBox.setSelectedIndex(0);
                GSEAURLLinkDialog.this.urlTypesBox.setSelectedIndex(0);
                GSEAURLLinkDialog.this.setLastSelectedIndices();
                ExperimentUtil.lastSelectedAnnotationIndices = GSEAURLLinkDialog.this.getLastSelectedIndices();
            } else if (command.equals("cancel-command")) {
                GSEAURLLinkDialog.this.okPressed = false;
                GSEAURLLinkDialog.this.dispose();
            } else if (command.equals("info-command")) {
                // empty if block
            }
        }
    }
}

