/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.AnnotationURLLinkDialog;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.microarray.mev.cluster.gui.impl.clvalid.CLVALIDGUI;
import org.tigr.util.BrowserLauncher;
import org.tigr.util.StringSplitter;

public class ExperimentUtil {
    public static final int INTEGER_TYPE = 10;
    public static final int FLOAT_TYPE = 11;
    public static final int DOUBLE_TYPE = 12;
    public static final int STRING_TYPE = 13;
    public static final int BOOLEAN_TYPE = 14;
    public static int[] lastSelectedAnnotationIndices = new int[]{0, 0};

    public static void saveExperiment(Frame frame, Experiment experiment, IData data) throws Exception {
        ExperimentUtil.saveExperiment(frame, experiment, data, ExperimentUtil.createDefaultRows(experiment.getNumberOfGenes()));
    }

    public static void saveExperiment(Frame frame, IData data, int[] rows) throws Exception {
        ExperimentUtil.saveExperiment(frame, data.getExperiment(), data, rows);
    }

    public static void saveExperiment(Frame frame, Experiment experiment, IData data, int[] rows) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveCluster(file, experiment, data, rows);
        }
    }

    public static void saveExperiment(Frame frame, Experiment experiment, IData data, int[][] clusters) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            String path = file.getPath();
            int extIndex = path.lastIndexOf(".txt");
            if (extIndex > 0) {
                path = path.substring(0, extIndex);
                file = new File(path);
            }
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null || clusters[i].length == 0) continue;
                File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                ExperimentUtil.saveCluster(aFile, experiment, data, clusters[i]);
            }
        }
    }

    public static void saveAllGeneClustersWithAux(Frame frame, Experiment experiment, IData data, int[][] clusters, String[] auxTitles, Object[][] auxData) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null || clusters[i].length == 0) continue;
                File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                ExperimentUtil.saveGeneClusterWithAux(aFile, experiment, data, clusters[i], auxTitles, auxData);
            }
        }
    }

    protected static void saveGeneClusterWithAux(File file, Experiment experiment, IData data, int[] rows, String[] auxTitles, Object[][] auxData) throws Exception {
        int i;
        int i2;
        int[] typeArray = ExperimentUtil.getTypes(auxData);
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        if (fieldNames == null) {
            return;
        }
        out.print("Original row");
        out.print("\t");
        for (i2 = 0; i2 < fieldNames.length; ++i2) {
            out.print(fieldNames[i2]);
            if (i2 >= fieldNames.length - 1) continue;
            out.print("\t");
        }
        for (i2 = 0; i2 < auxTitles.length; ++i2) {
            out.print("\t" + auxTitles[i2]);
        }
        for (i2 = 0; i2 < experiment.getNumberOfSamples(); ++i2) {
            out.print("\t");
            out.print(data.getSampleAnnotation(i2, "Default Slide Name"));
        }
        out.print("\n");
        Vector sampleFieldNames = data.getSampleAnnotationFieldNames();
        for (i = 1; i < sampleFieldNames.size(); ++i) {
            String val = new String();
            for (int k = 0; k < fieldNames.length + auxTitles.length; ++k) {
                val = val + "\t";
            }
            String key = (String)sampleFieldNames.elementAt(i);
            val = val + key + "\t";
            for (int j = 0; j < data.getFeaturesCount(); ++j) {
                val = val + data.getSampleAnnotation(j, key);
                val = j != data.getFeaturesCount() - 1 ? val + "\t" : val + "\n";
            }
            out.print(val);
        }
        for (i = 0; i < rows.length; ++i) {
            int j;
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(rows[i]) + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(rows[i]), k));
                if (k >= fieldNames.length - 1) continue;
                out.print("\t");
            }
            for (j = 0; j < auxData[0].length; ++j) {
                out.print("\t");
                ExperimentUtil.printDataType(out, auxData[rows[i]][j], typeArray[j]);
            }
            for (j = 0; j < experiment.getNumberOfSamples(); ++j) {
                out.print("\t");
                out.print(Float.toString(experiment.get(rows[i], j)));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    protected static File getFile(Frame frame) {
        String dataPath = TMEV.getDataPath();
        File pathFile = TMEV.getFile((String)"data/");
        if (dataPath != null) {
            pathFile = new File(dataPath);
            if (!pathFile.exists()) {
                pathFile = TMEV.getFile((String)"data/");
            }
        } else {
            System.out.println("null data path");
        }
        File file = null;
        JFileChooser fc = new JFileChooser(pathFile);
        fc.addChoosableFileFilter(new ExpressionFileFilter());
        fc.setFileView(new ExpressionFileView());
        int ret = fc.showSaveDialog(frame);
        if (ret == 0) {
            file = fc.getSelectedFile();
            while (file.exists()) {
                JOptionPane pane = new JOptionPane("File exists. Overwrite?");
                Object[] options = new String[]{"Ok", "Cancel"};
                pane.setOptions(options);
                JDialog dialog = pane.createDialog(new JFrame(), "File Overwrite Warning.");
                dialog.setVisible(true);
                if (pane.getValue().equals("Ok")) {
                    System.out.println("Ok");
                    return file;
                }
                System.out.println("not ok");
                fc.showSaveDialog(frame);
                file = fc.getSelectedFile();
            }
        } else {
            return null;
        }
        String fileName = file.getName();
        int extIndex = fileName.lastIndexOf(".");
        if (extIndex < 0 || fileName.length() - 1 - extIndex != 3) {
            file = new File(file.getPath() + ".txt");
        }
        TMEV.setDataPath((String)file.getParent());
        return file;
    }

    protected static String formatDataPath(String dataPath) {
        if (dataPath == null) {
            return " ";
        }
        String renderedSep = "/";
        String renderedPath = new String();
        String sep = System.getProperty("file.separator");
        StringTokenizer stok = new StringTokenizer(dataPath, sep);
        String newDataPath = new String();
        while (stok.hasMoreTokens() && stok.countTokens() > 1) {
            String str = stok.nextToken();
            renderedPath = renderedPath + str + renderedSep;
            newDataPath = newDataPath + str + sep;
        }
        return renderedPath;
    }

    public static void saveGeneCluster(Frame frame, IData data, int[] rows) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveGeneCluster(file, data, rows);
        }
    }

    protected static void saveGeneCluster(File file, IData data, int[] rows) throws Exception {
        int i;
        int i2;
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        if (fieldNames == null) {
            return;
        }
        out.print("Original row");
        out.print("\t");
        for (i2 = 0; i2 < fieldNames.length; ++i2) {
            out.print(fieldNames[i2]);
            if (i2 >= fieldNames.length - 1) continue;
            out.print("\t");
        }
        for (i2 = 0; i2 < data.getFeaturesCount(); ++i2) {
            out.print("\t");
            out.print(data.getSampleAnnotation(i2, "Default Slide Name"));
        }
        out.print("\n");
        Vector sampleFieldNames = data.getSampleAnnotationFieldNames();
        for (i = 1; i < sampleFieldNames.size(); ++i) {
            String val = new String();
            for (int k = 0; k < fieldNames.length; ++k) {
                val = val + "\t";
            }
            String key = (String)sampleFieldNames.elementAt(i);
            val = val + key + "\t";
            for (int j = 0; j < data.getFeaturesCount(); ++j) {
                val = val + data.getSampleAnnotation(j, key);
                val = j != data.getFeaturesCount() - 1 ? val + "\t" : val + "\n";
            }
            out.print(val);
        }
        for (i = 0; i < rows.length; ++i) {
            out.print(Integer.toString(rows[i] + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAttribute(rows[i], k));
                if (k >= fieldNames.length - 1) continue;
                out.print("\t");
            }
            for (int j = 0; j < data.getFeaturesCount(); ++j) {
                out.print("\t");
                out.print(Float.toString(data.getRatio(j, rows[i], 1)));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    public static void performValidation(AlgorithmData data) throws AlgorithmException {
        try {
            CLVALIDGUI clv = new CLVALIDGUI();
            clv.execute(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AlgorithmException("Error running Cluster Validation");
        }
    }

    public static void saveGeneClusterWithAux(Frame frame, Experiment experiment, IData data, int[] rows, String[] auxTitles, Object[][] auxData) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveGeneClusterWithAux(file, experiment, data, rows, auxTitles, auxData);
        }
    }

    protected static void saveCluster(File file, Experiment experiment, IData data, int[] rows) throws Exception {
        int i;
        int i2;
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getAllFilledAnnotationFields();
        if (fieldNames == null) {
            return;
        }
        out.print("Original row");
        out.print("\t");
        for (i2 = 0; i2 < fieldNames.length; ++i2) {
            out.print(fieldNames[i2]);
            if (i2 >= fieldNames.length - 1) continue;
            out.print("\t");
        }
        for (i2 = 0; i2 < experiment.getNumberOfSamples(); ++i2) {
            out.print("\t");
            out.print(data.getSampleAnnotation(i2, "Default Slide Name"));
        }
        out.print("\n");
        Vector sampleFieldNames = data.getSampleAnnotationFieldNames();
        for (i = 1; i < sampleFieldNames.size(); ++i) {
            String val = new String();
            for (int k = 0; k < fieldNames.length; ++k) {
                val = val + "\t";
            }
            String key = (String)sampleFieldNames.elementAt(i);
            val = val + key + "\t";
            for (int j = 0; j < data.getFeaturesCount(); ++j) {
                val = val + data.getSampleAnnotation(j, key);
                val = j != data.getFeaturesCount() - 1 ? val + "\t" : val + "\n";
            }
            out.print(val);
        }
        for (i = 0; i < rows.length; ++i) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(rows[i]) + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAnnotation(experiment.getGeneIndexMappedToData(rows[i]), fieldNames[k])[0]);
                if (k >= fieldNames.length - 1) continue;
                out.print("\t");
            }
            for (int j = 0; j < experiment.getNumberOfSamples(); ++j) {
                out.print("\t");
                out.print(Float.toString(experiment.get(rows[i], j)));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    public static void saveExperimentCluster(Frame frame, Experiment experiment, IData data, int[] rows) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveExperimentCluster(file, experiment, data, rows);
        }
    }

    public static void saveAllExperimentClusters(Frame frame, Experiment experiment, IData data, int[][] clusters) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null || clusters[i].length == 0) continue;
                File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                ExperimentUtil.saveExperimentCluster(aFile, experiment, data, clusters[i]);
            }
        }
    }

    public static void saveAllExperimentClustersWithAux(Frame frame, Experiment experiment, IData data, int[][] clusters, String[] auxTitles, Object[][] auxData) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null || clusters[i].length == 0) continue;
                File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                ExperimentUtil.saveExperimentClusterWithAux(aFile, experiment, data, clusters[i], auxTitles, auxData);
            }
        }
    }

    public static void saveExperimentClusterWithAux(Frame frame, Experiment experiment, IData data, int[] rows, String[] auxTitles, Object[][] auxData) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveExperimentClusterWithAux(file, experiment, data, rows, auxTitles, auxData);
        }
    }

    protected static void saveExperimentClusterWithAux(File file, Experiment experiment, IData data, int[] experiments, String[] auxTitles, Object[][] auxData) throws Exception {
        int i;
        int i2;
        int[] typeArray = ExperimentUtil.getTypes(auxData);
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        int numberOfGenes = experiment.getNumberOfGenes();
        out.print("Original row");
        out.print("\t");
        for (i2 = 0; i2 < fieldNames.length; ++i2) {
            out.print(fieldNames[i2]);
            if (i2 >= fieldNames.length - 1) continue;
            out.print("\t");
        }
        for (i2 = 0; i2 < experiments.length; ++i2) {
            out.print("\t");
            out.print(data.getSampleAnnotation(experiment.getSampleIndex(experiments[i2]), "Default Slide Name"));
        }
        out.print("\n");
        Vector sampleFieldNames = data.getSampleAnnotationFieldNames();
        for (i = 1; i < sampleFieldNames.size(); ++i) {
            String val = new String();
            for (int k = 0; k < fieldNames.length; ++k) {
                val = val + "\t";
            }
            String key = (String)sampleFieldNames.elementAt(i);
            val = val + key + "\t";
            for (int j = 0; j < experiments.length; ++j) {
                val = val + data.getSampleAnnotation(experiment.getSampleIndex(experiments[j]), key);
                val = j != experiments.length - 1 ? val + "\t" : val + "\n";
            }
            out.print(val);
        }
        for (i = 0; i < auxTitles.length; ++i) {
            out.print(auxTitles[i] + "\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print("\t");
            }
            for (int j = 0; j < experiments.length; ++j) {
                ExperimentUtil.printDataType(out, auxData[experiments[j]][i], typeArray[i]);
                if (j >= experiments.length - 1) continue;
                out.print("\t");
            }
            out.print("\n");
        }
        for (i = 0; i < numberOfGenes; ++i) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(i) + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(i), k));
                if (k >= fieldNames.length - 1) continue;
                out.print("\t");
            }
            for (int j = 0; j < experiments.length; ++j) {
                out.print("\t");
                out.print(Float.toString(experiment.get(i, experiment.getSampleIndex(experiments[j]))));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    protected static void saveExperimentCluster(File file, Experiment experiment, IData data, int[] experiments) throws Exception {
        int i;
        int i2;
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        int numberOfGenes = experiment.getNumberOfGenes();
        out.print("Original row");
        out.print("\t");
        for (i2 = 0; i2 < fieldNames.length; ++i2) {
            out.print(fieldNames[i2]);
            if (i2 >= fieldNames.length - 1) continue;
            out.print("\t");
        }
        for (i2 = 0; i2 < experiments.length; ++i2) {
            out.print("\t");
            out.print(data.getSampleAnnotation(experiment.getSampleIndex(experiments[i2]), "Default Slide Name"));
        }
        out.print("\n");
        Vector sampleFieldNames = data.getSampleAnnotationFieldNames();
        for (i = 1; i < sampleFieldNames.size(); ++i) {
            String val = new String();
            for (int k = 0; k < fieldNames.length; ++k) {
                val = val + "\t";
            }
            String key = (String)sampleFieldNames.elementAt(i);
            val = val + key + "\t";
            for (int j = 0; j < experiments.length; ++j) {
                val = val + data.getSampleAnnotation(experiment.getSampleIndex(experiments[j]), key);
                val = j != experiments.length - 1 ? val + "\t" : val + "\n";
            }
            out.print(val);
        }
        for (i = 0; i < numberOfGenes; ++i) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(i) + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(i), k));
                if (k >= fieldNames.length - 1) continue;
                out.print("\t");
            }
            for (int j = 0; j < experiments.length; ++j) {
                out.print("\t");
                out.print(Float.toString(experiment.get(i, experiment.getSampleIndex(experiments[j]))));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    public static void linkToURL(JFrame frame, Experiment experiment, IData data, int row) {
        try {
            File file = TMEV.getConfigurationFile((String)"annotation_URLs.txt");
            AnnotationURLLinkDialog aDialog = new AnnotationURLLinkDialog(frame, false, experiment, data, row, file);
            aDialog.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not link to URL! Make sure \"annotation_URLs.txt\" file in \"config\" directory is in correct format", "Error", 0);
        }
    }

    public static void linkToURL(JFrame frame, Experiment experiment, IData data, int row, int[] lastSelectedIndices) {
        try {
            File file = TMEV.getConfigurationFile((String)"annotation_URLs.txt");
            System.out.println("Found annotation file");
            AnnotationURLLinkDialog aDialog = new AnnotationURLLinkDialog(frame, false, experiment, data, row, file, lastSelectedIndices);
            aDialog.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not link to URL! Make sure \"annotation_URLs.txt\" file in \"config\" directory is in correct format", "Error", 0);
        }
    }

    public static void linkToURL(JFrame frame, Experiment experiment, IData data, int row, String annotationKey, int[] lastSelectedIndices) {
        try {
            File file = TMEV.getConfigurationFile((String)"annotation_URLs.txt");
            if (annotationKey.equalsIgnoreCase("Stored Color")) {
                JOptionPane.showMessageDialog(new JFrame(), "Cannot link stored color to an URL. Pick a different field to link from", "Error", 0);
            } else {
                String[] fieldNames = data.getFieldNames();
                int currFieldIndex = -1;
                for (int i = 0; i < fieldNames.length; ++i) {
                    if (!annotationKey.equalsIgnoreCase(fieldNames[i])) continue;
                    currFieldIndex = i;
                    break;
                }
                String[][] annotationFields = ExperimentUtil.getAnnotationFieldsFromFile(file);
                String[] urlTemplates = annotationFields[0];
                String[] urlKeys = annotationFields[1];
                if (ExperimentUtil.isFound(annotationKey, urlKeys)) {
                    int currKeyIndex = -1;
                    for (int i = 0; i < urlKeys.length; ++i) {
                        if (!annotationKey.equalsIgnoreCase(urlKeys[i])) continue;
                        currKeyIndex = i;
                        break;
                    }
                    String currURLTemplate = urlTemplates[currKeyIndex];
                    String currentAnnotationString = data.getElementAttribute(row, currFieldIndex);
                    String currentURL = ExperimentUtil.getCurrentURL(annotationKey, currentAnnotationString, currURLTemplate);
                    try {
                        BrowserLauncher.openURL((String)currentURL);
                    }
                    catch (IOException ie) {
                        JOptionPane.showMessageDialog(new JFrame(), ie.toString(), "Error", 0);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(new JFrame(), "Browser could not be launched! Possible problem: the annotation format may not be appropriate for this URL type!", "Error", 0);
                    }
                } else {
                    int[] indicesToUse = new int[]{currFieldIndex, lastSelectedIndices[1]};
                    AnnotationURLLinkDialog aDialog = new AnnotationURLLinkDialog(frame, false, experiment, data, row, file, indicesToUse);
                    aDialog.setVisible(true);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not open browser! Possible problems: bad URL, or \"annotation_URLs.txt\" file in \"config\" directory is not in correct format", "Error", 0);
        }
    }

    protected static String getCurrentURL(String currKey, String currAnn, String currTemplate) {
        String urlToUse = "";
        if (currKey.equalsIgnoreCase("UniGene")) {
            String[] splitAnnotation = currAnn.split("\\.");
            String s1 = currTemplate.replaceAll("FIELD1", splitAnnotation[1]);
            urlToUse = s1.replaceAll("FIELD2", splitAnnotation[0]);
        } else {
            urlToUse = currTemplate.replaceAll("FIELD1", currAnn);
        }
        return urlToUse;
    }

    protected static boolean isFound(String annKey, String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            if (!annKey.equalsIgnoreCase(keys[i])) continue;
            return true;
        }
        return false;
    }

    protected static String[][] getAnnotationFieldsFromFile(File file) {
        String[][] annFields = new String[2][];
        Vector annotFieldsVector = new Vector();
        Vector<String> urlKeysVector = new Vector<String>();
        Vector<String> urlTemplateVector = new Vector<String>();
        try {
            int i;
            FileReader fr = new FileReader(file);
            BufferedReader buff = new BufferedReader(fr);
            StringSplitter st = new StringSplitter('\t');
            boolean eof = false;
            while (!eof) {
                String line = buff.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                st.init(line);
                urlKeysVector.add(st.nextToken());
                urlTemplateVector.add(st.nextToken());
            }
            buff.close();
            String[] urlTemplates = new String[urlTemplateVector.size()];
            String[] urlKeys = new String[urlKeysVector.size()];
            for (i = 0; i < urlTemplates.length; ++i) {
                urlTemplates[i] = (String)urlTemplateVector.get(i);
            }
            for (i = 0; i < urlKeys.length; ++i) {
                urlKeys[i] = (String)urlKeysVector.get(i);
            }
            annFields[0] = urlTemplates;
            annFields[1] = urlKeys;
        }
        catch (FileNotFoundException fne) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not find \"annotation_URLs.txt\" file in \"config\" directory", "Error", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Incompatible \"annotation_URLs.txt\" file in \"config\" directory! Possible issues: extra newline characters, too many or too few tabs per line", "Error", 0);
        }
        return annFields;
    }

    protected static int[] createDefaultRows(int genes) {
        int[] rows = new int[genes];
        for (int i = 0; i < genes; ++i) {
            rows[i] = i;
        }
        return rows;
    }

    protected static void printDataType(PrintWriter out, Object obj, int dataType) {
        switch (dataType) {
            case 14: {
                out.print((Boolean)obj);
                break;
            }
            case 12: {
                out.print((Double)obj);
                break;
            }
            case 11: {
                out.print(((Float)obj).floatValue());
                break;
            }
            case 10: {
                out.print((Integer)obj);
                break;
            }
            case 13: {
                out.print((String)obj);
                break;
            }
            default: {
                out.print(obj);
            }
        }
    }

    protected static int[] getTypes(Object[][] objData) {
        int[] types = new int[objData[0].length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ExperimentUtil.getObjectType(objData[0][i]);
        }
        return types;
    }

    protected static int getObjectType(Object obj) {
        int obType = -1;
        if (obj instanceof Boolean) {
            return 14;
        }
        if (obj instanceof Double) {
            return 12;
        }
        if (obj instanceof Float) {
            return 11;
        }
        if (obj instanceof Integer) {
            return 10;
        }
        if (obj instanceof String) {
            return 13;
        }
        return obType;
    }
}

