/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.IExperimentHeader;

public class ExperimentHeader
extends JPanel
implements IExperimentHeader {
    private static final int RECT_HEIGHT = 15;
    private static final int COLOR_BAR_HEIGHT = 15;
    private Experiment experiment;
    private IData data;
    private int[] samplesOrder;
    private int[][] clusters;
    private ArrayList<Color> storedGeneColors = new ArrayList();
    private ArrayList<Color> storedSampleColors = new ArrayList();
    private ArrayList<Color> savedSampleColorOrder = new ArrayList();
    private int compactedColorBarHeight = 0;
    private int clusterIndex;
    private int elementWidth;
    private boolean isAntiAliasing = true;
    private boolean isCompact = false;
    public boolean isShowRects = true;
    private boolean enableMoveable = true;
    private float maxValue = 3.0f;
    private float minValue = -3.0f;
    private float midValue = 0.0f;
    private Insets insets = new Insets(0, 10, 0, 0);
    private BufferedImage negColorImage;
    private BufferedImage posColorImage;
    private int activeCluster = 0;
    private int maxSampleLabelLength = 0;
    private static int[] ColorOverlaps = new int[1000000];
    private boolean mouseOnMap = false;
    private int mouseRow = 0;
    private int mouseColumn = 0;
    private int clickedRow = 0;
    private int clickedColumn = 0;
    public boolean clickedCell = false;
    private boolean isDrag = false;
    private boolean headerDrag = false;
    private boolean isSampleDrag = false;
    private boolean isShift = false;
    private boolean isShiftMove = false;
    private int sampleDragColumn = 0;
    private int headerDragRow = 0;
    private int dragColumn = 0;
    private int dragRow = 0;
    private int startColumn = 0;
    private int startShift = 0;
    private int endShift = 0;
    private int startRow = 0;
    private int labelLength = 0;
    private int startShiftMove = 0;
    private int endShiftMove = 0;
    private int headerWidth = 0;
    public boolean clusterViewerClicked = false;
    public int clusterViewerClickedColumn = 0;
    private boolean useDoubleGradient = true;
    private String userFont = "monospaced";
    private int userFontSize;

    public void setExperiment(Experiment e) {
        this.experiment = e;
    }

    public void setIData(IData d) {
        this.data = d;
    }

    public ExperimentHeader(Experiment experiment, int[][] clusters) {
        this(experiment, clusters, null);
    }

    public ExperimentHeader(Experiment experiment, int[][] clusters, int[] samplesOrder) {
        this.experiment = experiment;
        this.clusters = clusters;
        this.setSamplesOrder(samplesOrder == null ? ExperimentHeader.createSamplesOrder(experiment) : samplesOrder);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public ExperimentHeader(Experiment experiment, int[][] clusters, int[] samplesOrder, ArrayList<Color> storedGeneColors) {
        this.experiment = experiment;
        this.clusters = clusters;
        this.storedGeneColors = storedGeneColors;
        this.setSamplesOrder(samplesOrder == null ? ExperimentHeader.createSamplesOrder(experiment) : samplesOrder);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    @Override
    public JComponent getContentComponent() {
        return this;
    }

    private static int[] createSamplesOrder(Experiment experiment) {
        int[] order = new int[experiment.getNumberOfSamples()];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        return order;
    }

    public int[] getSamplesOrder() {
        return this.samplesOrder;
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    @Override
    public void setData(IData data) {
        this.data = data;
    }

    public IData getData() {
        return this.data;
    }

    public void setValues(float minValue, float midValue, float maxValue) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.midValue = midValue;
    }

    @Override
    public void setValues(float minValue, float maxValue) {
        this.maxValue = maxValue;
        this.minValue = minValue;
    }

    public void setDrag(boolean setting, int dragColumn, int dragRow) {
        this.isDrag = setting;
        this.dragColumn = dragColumn;
        this.dragRow = dragRow;
    }

    public void setCompactClusters(boolean value) {
        if (value == this.isCompact) {
            return;
        }
        if (value) {
            this.savedSampleColorOrder.clear();
            for (int i = 0; i < this.storedSampleColors.size(); ++i) {
                this.savedSampleColorOrder.add(this.storedSampleColors.get(i));
            }
            this.storedSampleColors.clear();
        } else {
            this.storedSampleColors.clear();
            this.clearColorOverlaps();
            for (int i = 0; i < this.savedSampleColorOrder.size(); ++i) {
                this.storedSampleColors.add(this.savedSampleColorOrder.get(i));
            }
        }
        this.isCompact = value;
    }

    public void clearStoredSampleColors() {
        this.storedSampleColors.clear();
    }

    private void clearColorOverlaps() {
        for (int i = 0; i < ColorOverlaps.length; ++i) {
            ExperimentHeader.ColorOverlaps[i] = i;
        }
    }

    @Override
    public void setNegAndPosColorImages(BufferedImage neg, BufferedImage pos) {
        this.negColorImage = neg;
        this.posColorImage = pos;
    }

    public void setStoredColors(ArrayList<Color> storedColors) {
        this.storedGeneColors = storedColors;
    }

    public void setClusters(int[][] mat) {
        this.clusters = new int[mat.length][mat[0].length];
        for (int i = 0; i < mat.length; ++i) {
            for (int j = 0; j < mat[i].length; ++j) {
                this.clusters[i][j] = mat[i][j];
            }
        }
        this.repaint();
        this.updateUI();
    }

    @Override
    public void setUseDoubleGradient(boolean useDouble) {
        this.useDoubleGradient = useDouble;
    }

    @Override
    public void setAntiAliasing(boolean isAntiAliasing) {
        this.isAntiAliasing = isAntiAliasing;
    }

    @Override
    public void setLeftInset(int leftMargin) {
        this.insets.left = leftMargin;
    }

    @Override
    public void setClusterIndex(int index) {
        this.clusterIndex = index;
    }

    private int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    private int getColorBarHeight() {
        for (int sample = 0; sample < this.getSamplesOrder().length; ++sample) {
            if (this.data.getExperimentColor(this.experiment.getSampleIndex(this.getSamplesOrder()[sample])) == null) continue;
            return 15;
        }
        return 0;
    }

    private void setElementWidth(int width) {
        this.elementWidth = width;
        if (this.userFontSize == 0) {
            if (width > 16) {
                width = 16;
            }
        } else if (this.userFontSize != -1) {
            width = this.userFontSize;
        }
        this.setFont(new Font(this.userFont, 0, width));
    }

    public void drawClusterHeaderRectsAt(int column, Color color, boolean cluster) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        int side = 0;
        int inset = 0;
        if (cluster) {
            inset = 4;
        }
        g.setColor(color);
        if (column > this.experiment.getNumberOfSamples() - 1) {
            side = 10;
        }
        if (column > this.experiment.getNumberOfSamples() - 1 && this.isCompact) {
            return;
        }
        if (!this.isCompact) {
            g.drawRect(column * this.elementWidth + this.insets.left + inset, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth, 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4 + side);
        }
        if (this.isCompact) {
            g.drawRect(column * this.elementWidth + this.insets.left + inset, this.getSize().height - (15 * this.compactedColorBarHeight + this.maxSampleLabelLength + 7), this.elementWidth - 1, 15 * this.compactedColorBarHeight + this.maxSampleLabelLength + 4 + side);
        }
    }

    @Override
    public void updateSizes(int useless, int setElementWidth) {
        if (this.data == null) {
            return;
        }
        this.setElementWidth(setElementWidth);
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics hfm = g.getFontMetrics();
        int maxHeight = 0;
        int contentWidth = 0;
        int size = this.experiment.getNumberOfSamples();
        for (int feature = 0; feature < size; ++feature) {
            String name = this.data.getSampleName(this.experiment.getSampleIndex(feature));
            maxHeight = Math.max(maxHeight, hfm.stringWidth(name));
        }
        contentWidth = (this.experiment.getNumberOfSamples() + this.storedGeneColors.size()) * this.elementWidth + this.insets.left + 4;
        this.maxSampleLabelLength = maxHeight;
        maxHeight += 15 + hfm.getHeight() + 10;
        if (!this.isCompact) {
            maxHeight += this.getColorBarHeight() * this.storedSampleColors.size();
            this.labelLength = 0;
            for (int feature = 0; feature < this.storedSampleColors.size(); ++feature) {
                String sampleLabel = this.data.getClusterLabel(feature, false);
                if (sampleLabel == null) continue;
                this.labelLength = Math.max(this.labelLength, hfm.stringWidth(sampleLabel));
            }
            contentWidth = contentWidth + this.labelLength + 10;
            if (this.labelLength < 60) {
                contentWidth += 70;
            }
        }
        if (this.isCompact) {
            int maxSpacesOver = -1;
            for (int i = 0; i < this.storedSampleColors.size(); ++i) {
                if (ColorOverlaps[i] <= maxSpacesOver) continue;
                maxSpacesOver = ColorOverlaps[i];
            }
            this.compactedColorBarHeight = maxSpacesOver + 1;
            this.setSize(this.headerWidth, maxHeight += this.getColorBarHeight() * (maxSpacesOver + 1));
            this.setPreferredSize(new Dimension(this.headerWidth, maxHeight));
            this.drawHeader(g);
            return;
        }
        this.setSize(this.headerWidth, maxHeight);
        this.setPreferredSize(new Dimension(this.headerWidth, maxHeight));
        this.drawHeader(g);
    }

    public void setHeaderWidth(int hw) {
        this.headerWidth = hw;
    }

    @Override
    public void paint(Graphics g1D) {
        super.paint(g1D);
        if (this.data == null || this.getCluster().length < 1) {
            return;
        }
        Graphics2D g = (Graphics2D)g1D;
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawHeader(g);
    }

    private void drawHeader(Graphics2D g) {
        String clusterName;
        int index;
        int cluster;
        int numberOfClusters;
        int samples = this.experiment.getNumberOfSamples();
        if (samples == 0) {
            return;
        }
        int width = samples * this.elementWidth;
        if (this.useDoubleGradient) {
            g.drawImage(this.negColorImage, this.insets.left, 0, (int)((float)width / 2.0f), 15, null);
            g.drawImage(this.posColorImage, (int)((float)width / 2.0f + (float)this.insets.left), 0, (int)((double)width / 2.0), 15, null);
        } else {
            g.drawImage(this.posColorImage, this.insets.left, 0, width, 15, null);
        }
        FontMetrics hfm = g.getFontMetrics();
        int descent = hfm.getDescent();
        int fHeight = hfm.getHeight();
        g.setColor(Color.black);
        g.drawString(String.valueOf(this.minValue), this.insets.left, 15 + fHeight);
        int textWidth = hfm.stringWidth(String.valueOf(this.midValue));
        if (this.useDoubleGradient) {
            g.drawString(String.valueOf(this.midValue), (int)((float)width / 2.0f) - textWidth / 2 + this.insets.left, 15 + fHeight);
        }
        textWidth = hfm.stringWidth(String.valueOf(this.maxValue));
        g.drawString(String.valueOf(this.maxValue), width - textWidth + this.insets.left, 15 + fHeight);
        int h = -this.getSize().height + 5;
        boolean hasColorBar = false;
        if (this.getColorBarHeight() > 0) {
            if (this.isCompact) {
                h += 15 * this.compactedColorBarHeight;
            }
            if (!this.isCompact) {
                h += 15 * this.storedSampleColors.size();
            }
            hasColorBar = true;
        }
        g.rotate(-1.5707963267948966);
        for (int sample = 0; sample < samples; ++sample) {
            String name = this.data.getSampleName(this.experiment.getSampleIndex(this.getSamplesOrder()[sample]));
            g.drawString(name, h, descent + this.elementWidth * sample + this.elementWidth / 2 + this.insets.left);
        }
        g.rotate(1.5707963267948966);
        int visibleClusters = 0;
        if (this.storedGeneColors != null && !this.isCompact) {
            g.rotate(-1.5707963267948966);
            numberOfClusters = this.storedGeneColors.size();
            for (cluster = 0; cluster < numberOfClusters && (index = this.data.getVisibleCluster(this.storedGeneColors.get(cluster), true)) != 0; ++cluster) {
                clusterName = this.data.getClusterLabel(index, true);
                if (clusterName != null) {
                    g.drawString(clusterName, h, descent + this.elementWidth * (samples + cluster) + this.elementWidth / 2 + this.insets.left + 5);
                }
                ++visibleClusters;
            }
            g.rotate(1.5707963267948966);
        }
        if (this.storedSampleColors != null && !this.isCompact) {
            numberOfClusters = this.storedSampleColors.size();
            for (cluster = 0; cluster < numberOfClusters; ++cluster) {
                index = this.data.getVisibleCluster(this.storedSampleColors.get(cluster), false);
                if (index == -1 || (clusterName = this.data.getClusterLabel(index, false)) == null) continue;
                g.drawString(clusterName, this.elementWidth * (samples + visibleClusters) + this.insets.left + 10, -h + 15 * (numberOfClusters - cluster));
            }
        }
        int spacesOver = 0;
        if (hasColorBar) {
            int sscLength = this.storedSampleColors.size();
            for (int sample = 0; sample < samples; ++sample) {
                Color[] colors = this.data.getSampleColorArray(this.experiment.getSampleIndex(this.getSamplesOrder()[sample]));
                if (colors == null) continue;
                for (int clusters = 0; clusters < colors.length; ++clusters) {
                    if (colors[clusters] == null) continue;
                    if (this.storedSampleColors.contains(colors[clusters])) {
                        this.activeCluster = this.storedSampleColors.indexOf(colors[clusters]);
                    } else {
                        this.storedSampleColors.add(colors[clusters]);
                        ExperimentHeader.ColorOverlaps[this.activeCluster] = this.activeCluster = this.storedSampleColors.size() - 1;
                        boolean compact = false;
                        if (this.isCompact) {
                            compact = true;
                        }
                        while (compact) {
                            for (int i = 0; i < this.storedSampleColors.size(); ++i) {
                                boolean allClear = true;
                                for (int j = 0; j < this.storedSampleColors.size(); ++j) {
                                    if (ColorOverlaps[j] != i) continue;
                                    if (this.data.isColorOverlap(this.experiment.getSampleIndex(this.getSamplesOrder()[sample]), colors[clusters], this.storedSampleColors.get(j), false)) {
                                        allClear = false;
                                        break;
                                    }
                                    allClear = true;
                                }
                                if (!allClear) continue;
                                ExperimentHeader.ColorOverlaps[this.activeCluster] = i;
                                compact = true;
                                break;
                            }
                            if (!compact) continue;
                        }
                    }
                    spacesOver = ColorOverlaps[this.activeCluster];
                    g.setColor(colors[clusters]);
                    if (sscLength != this.storedSampleColors.size()) {
                        g.setColor(Color.white);
                    }
                    g.fillRect(sample * this.elementWidth + this.insets.left, this.getSize().height - 15 * (1 + spacesOver) - 2, this.elementWidth, 15);
                }
            }
            int sizeTest = this.getSize().width;
            if (sscLength != this.storedSampleColors.size()) {
                this.updateSizes(this.getSize().width, this.elementWidth);
            }
            if (sizeTest != this.getSize().width) {
                this.repaint();
            }
        }
        if (this.mouseOnMap && this.isShowRects) {
            if (this.mouseColumn != this.clickedColumn) {
                this.drawClusterHeaderRectsAt(this.mouseColumn, Color.gray, false);
            }
            if (this.mouseRow != this.clickedRow) {
                this.drawHorizontalRect(this.mouseRow, Color.gray);
            }
        }
        this.mouseOnMap = false;
        if (this.clickedCell) {
            g.setColor(Color.red);
            if (!this.isCompact) {
                g.drawRect(this.insets.left, this.getHeight() - 15 * (this.storedSampleColors.size() - this.clickedRow) - 3, this.elementWidth * this.experiment.getNumberOfSamples() + 5 + this.elementWidth * this.storedGeneColors.size() + 5 + this.labelLength + 2, 15);
                g.drawRect(this.clickedColumn * this.elementWidth + this.insets.left, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth, 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4);
            }
        }
        if (this.clusterViewerClicked && !this.isCompact) {
            g.setColor(Color.red);
            g.drawRect(this.clusterViewerClickedColumn * this.elementWidth + this.insets.left + 4, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth, 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4 + 10);
        }
        if (this.isDrag) {
            g.setColor(Color.blue);
            if (!this.isCompact) {
                g.drawRect(this.dragColumn * this.elementWidth + this.insets.left + 4, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth, 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4 + 10);
            }
            if (this.isCompact) {
                g.drawRect(this.dragColumn * this.elementWidth + this.insets.left + 4, this.getSize().height - (15 * this.compactedColorBarHeight + this.maxSampleLabelLength + 7), this.elementWidth, 15 * this.compactedColorBarHeight + this.maxSampleLabelLength + 4 + 10);
            }
        }
        if (this.headerDrag) {
            g.setColor(Color.blue);
            if (!this.isCompact) {
                g.drawRect(this.insets.left, this.getHeight() - 15 * (this.storedSampleColors.size() - this.headerDragRow) - 3, this.elementWidth * this.experiment.getNumberOfSamples() + 5 + this.elementWidth * this.storedGeneColors.size() + 5 + this.labelLength + 2, 15);
            }
            if (this.isCompact) {
                g.drawRect(this.insets.left, this.getHeight() - 15 * (this.compactedColorBarHeight - this.headerDragRow) - 3, this.elementWidth * this.experiment.getNumberOfSamples(), 15);
            }
        }
        if (this.isSampleDrag) {
            g.setColor(Color.blue);
            g.drawRect(this.sampleDragColumn * this.elementWidth + this.insets.left, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth, 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4 + 10);
        }
        if (this.isShift) {
            g.setColor(new Color(175, 175, 175, 100));
            if (this.startShift < this.endShift) {
                g.fillRect(this.startShift * this.elementWidth + this.insets.left, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth * (this.endShift - this.startShift + 1), 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4 + 10);
            }
            if (this.startShift > this.endShift) {
                g.fillRect(this.endShift * this.elementWidth + this.insets.left, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth * (this.startShift - this.endShift + 1), 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4 + 10);
            }
            if (this.startShift == this.endShift) {
                g.fillRect(this.startShift * this.elementWidth + this.insets.left, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth, 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4 + 10);
            }
        }
        if (this.isShiftMove) {
            g.setColor(Color.blue);
            int move = this.startShiftMove - this.endShiftMove;
            g.drawRect((Math.min(this.startShift, this.endShift) - move) * this.elementWidth + this.insets.left, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth * (Math.abs(this.endShift - this.startShift) + 1), 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4 + 10);
        }
    }

    private void drawHorizontalRect(int row, Color color) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        g.setColor(color);
        if (!this.isCompact) {
            g.drawRect(this.insets.left, this.getHeight() - 15 * (this.storedSampleColors.size() - row) - 3, this.elementWidth * this.experiment.getNumberOfSamples() + 5 + this.elementWidth * this.storedGeneColors.size() + 5 + this.labelLength + 2, 15);
        }
    }

    private int findColumn(int targetx) {
        int xSize = this.experiment.getNumberOfSamples() * this.elementWidth;
        if (targetx < this.insets.left) {
            return -1;
        }
        if (targetx > xSize + this.insets.left) {
            return -1;
        }
        return (targetx - this.insets.left) / this.elementWidth;
    }

    private int findRow(int targety) {
        int length = 0;
        if (!this.isCompact) {
            length = this.getSize().height - this.getColorBarHeight() * this.storedSampleColors.size();
        }
        if (this.isCompact) {
            length = this.getSize().height - this.compactedColorBarHeight * this.getColorBarHeight();
        }
        if (targety >= this.getSize().height || targety < length) {
            return -1;
        }
        return (targety - length) / 15;
    }

    private boolean isLegalPosition(int row, int column) {
        return this.isLegalRow(row) && this.isLegalColumn(column);
    }

    private boolean isLegalColumn(int column) {
        return column >= 0 && column <= this.experiment.getNumberOfSamples() - 1;
    }

    private boolean isLegalRow(int row) {
        if (row < 0 || row > this.storedSampleColors.size()) {
            return false;
        }
        return !this.isCompact || row >= 0 && row <= this.compactedColorBarHeight;
    }

    public void setSamplesOrder(int[] samplesOrder) {
        this.samplesOrder = samplesOrder;
    }

    public void setEnableMoveable(boolean enableMoveable) {
        this.enableMoveable = enableMoveable;
    }

    public void setUserFont(String font) {
        this.userFont = font;
    }

    public void setUserFontSize(int userFontSize) {
        this.userFontSize = userFontSize;
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private int oldRow = -1;
        private int oldColumn = -1;

        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            int column = ExperimentHeader.this.findColumn(event.getX());
            if (SwingUtilities.isRightMouseButton(event) || column == -1) {
                ExperimentHeader.this.isShiftMove = false;
                ExperimentHeader.this.isSampleDrag = false;
                return;
            }
            int row = ExperimentHeader.this.findRow(event.getY());
            if (!ExperimentHeader.this.isLegalPosition(row, column)) {
                return;
            }
            if (row == ExperimentHeader.this.clickedRow && column == ExperimentHeader.this.clickedColumn) {
                ExperimentHeader.this.clickedCell = false;
                return;
            }
            ExperimentHeader.this.clickedRow = row;
            ExperimentHeader.this.clickedColumn = column;
            ExperimentHeader.this.clickedCell = true;
            ExperimentHeader.this.drawClusterHeaderRectsAt(ExperimentHeader.this.clickedColumn, Color.red, false);
            ExperimentHeader.this.drawHorizontalRect(ExperimentHeader.this.clickedRow, Color.red);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            ExperimentHeader.this.mouseOnMap = false;
            ExperimentHeader.this.repaint();
            if (ExperimentHeader.this.clickedCell && !ExperimentHeader.this.isCompact) {
                ExperimentHeader.this.drawClusterHeaderRectsAt(ExperimentHeader.this.clickedColumn, Color.red, false);
                ExperimentHeader.this.drawHorizontalRect(ExperimentHeader.this.clickedRow, Color.red);
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (!ExperimentHeader.this.isShowRects) {
                return;
            }
            if (ExperimentHeader.this.experiment.getNumberOfSamples() == 0 || event.isShiftDown()) {
                return;
            }
            int column = ExperimentHeader.this.findColumn(event.getX());
            int row = ExperimentHeader.this.findRow(event.getY());
            Graphics g = null;
            g = ExperimentHeader.this.getGraphics();
            if (!ExperimentHeader.this.isLegalPosition(row, column)) {
                ExperimentHeader.this.repaint();
                if (ExperimentHeader.this.clickedCell && !ExperimentHeader.this.isCompact) {
                    ExperimentHeader.this.drawClusterHeaderRectsAt(ExperimentHeader.this.clickedColumn, Color.red, false);
                    ExperimentHeader.this.drawHorizontalRect(ExperimentHeader.this.clickedRow, Color.red);
                }
                return;
            }
            if (this.isCurrentPosition(row, column)) {
                if (ExperimentHeader.this.isLegalPosition(row, column)) {
                    ExperimentHeader.this.drawClusterHeaderRectsAt(this.oldColumn, Color.gray, false);
                    ExperimentHeader.this.drawHorizontalRect(row, Color.gray);
                }
                if (ExperimentHeader.this.clickedCell && !ExperimentHeader.this.isCompact) {
                    ExperimentHeader.this.drawClusterHeaderRectsAt(ExperimentHeader.this.clickedColumn, Color.red, false);
                    ExperimentHeader.this.drawHorizontalRect(ExperimentHeader.this.clickedRow, Color.red);
                }
                return;
            }
            if (!this.isCurrentPosition(row, column) && ExperimentHeader.this.isLegalPosition(row, column)) {
                ExperimentHeader.this.mouseOnMap = true;
                ExperimentHeader.this.mouseRow = row;
                ExperimentHeader.this.mouseColumn = column;
                ExperimentHeader.this.repaint();
                ExperimentHeader.this.drawClusterHeaderRectsAt(this.oldColumn, Color.gray, false);
                if (ExperimentHeader.this.clickedCell && !ExperimentHeader.this.isCompact) {
                    ExperimentHeader.this.drawClusterHeaderRectsAt(ExperimentHeader.this.clickedColumn, Color.red, false);
                    ExperimentHeader.this.drawHorizontalRect(ExperimentHeader.this.clickedRow, Color.red);
                }
            }
            this.setOldPosition(row, column);
            if (g != null) {
                g.dispose();
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            ExperimentHeader.this.repaint();
            if (SwingUtilities.isRightMouseButton(event)) {
                ExperimentHeader.this.isShiftMove = false;
                ExperimentHeader.this.isSampleDrag = false;
                return;
            }
            if (event.isShiftDown()) {
                ExperimentHeader.this.isSampleDrag = false;
                return;
            }
            int column = ExperimentHeader.this.findColumn(event.getX());
            int row = ExperimentHeader.this.findRow(event.getY());
            if (column == -1) {
                ExperimentHeader.this.isShiftMove = false;
                ExperimentHeader.this.isSampleDrag = false;
                return;
            }
            if (ExperimentHeader.this.isShift && ExperimentHeader.this.enableMoveable) {
                ExperimentHeader.this.isShiftMove = true;
                ExperimentHeader.this.endShiftMove = column;
                if (ExperimentHeader.this.startShiftMove - ExperimentHeader.this.endShiftMove > Math.min(ExperimentHeader.this.startShift, ExperimentHeader.this.endShift)) {
                    ExperimentHeader.this.endShiftMove = ExperimentHeader.this.startShiftMove - Math.min(ExperimentHeader.this.startShift, ExperimentHeader.this.endShift);
                }
                if (ExperimentHeader.this.endShiftMove - ExperimentHeader.this.startShiftMove > ExperimentHeader.this.experiment.getNumberOfSamples() - Math.max(ExperimentHeader.this.startShift, ExperimentHeader.this.endShift) - 1) {
                    ExperimentHeader.this.endShiftMove = ExperimentHeader.this.startShiftMove + ExperimentHeader.this.experiment.getNumberOfSamples() - Math.max(ExperimentHeader.this.startShift, ExperimentHeader.this.endShift) - 1;
                }
                return;
            }
            ExperimentHeader.this.sampleDragColumn = column;
            ExperimentHeader.this.isSampleDrag = true;
            if (!ExperimentHeader.this.enableMoveable) {
                ExperimentHeader.this.isShiftMove = false;
                ExperimentHeader.this.isSampleDrag = false;
            }
            if (!ExperimentHeader.this.isLegalPosition(row, column)) {
                ExperimentHeader.this.headerDrag = false;
                return;
            }
            if (!ExperimentHeader.this.headerDrag) {
                return;
            }
            ExperimentHeader.this.headerDragRow = row;
            if (column >= ExperimentHeader.this.experiment.getNumberOfSamples()) {
                ExperimentHeader.this.headerDrag = false;
                ExperimentHeader.this.isSampleDrag = false;
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            ExperimentHeader.this.startColumn = ExperimentHeader.this.findColumn(event.getX());
            if (SwingUtilities.isRightMouseButton(event) || ExperimentHeader.this.startColumn == -1) {
                ExperimentHeader.this.isShiftMove = false;
                ExperimentHeader.this.isSampleDrag = false;
                return;
            }
            ExperimentHeader.this.sampleDragColumn = ExperimentHeader.this.startColumn;
            ExperimentHeader.this.startRow = ExperimentHeader.this.findRow(event.getY());
            if (event.isShiftDown()) {
                if (!ExperimentHeader.this.isShift) {
                    ExperimentHeader.this.startShift = ExperimentHeader.this.startColumn;
                }
                ExperimentHeader.this.endShift = ExperimentHeader.this.startColumn;
                ExperimentHeader.this.isShift = true;
            } else if (ExperimentHeader.this.isShift && ExperimentHeader.this.startColumn >= Math.min(ExperimentHeader.this.startShift, ExperimentHeader.this.endShift) && ExperimentHeader.this.startColumn <= Math.max(ExperimentHeader.this.startShift, ExperimentHeader.this.endShift)) {
                ExperimentHeader.this.startShiftMove = ExperimentHeader.this.startColumn;
            } else {
                ExperimentHeader.this.isShift = false;
                ExperimentHeader.this.isShiftMove = false;
            }
            if (!ExperimentHeader.this.isLegalPosition(ExperimentHeader.this.startRow, ExperimentHeader.this.startColumn)) {
                return;
            }
            ExperimentHeader.this.headerDrag = true;
            ExperimentHeader.this.headerDragRow = ExperimentHeader.this.startRow;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            int endColumn = ExperimentHeader.this.findColumn(event.getX());
            if (SwingUtilities.isRightMouseButton(event) || endColumn == -1) {
                ExperimentHeader.this.isShiftMove = false;
                ExperimentHeader.this.isSampleDrag = false;
                return;
            }
            if (ExperimentHeader.this.isShiftMove) {
                int i;
                int lowerShift = Math.min(ExperimentHeader.this.endShift, ExperimentHeader.this.startShift);
                int upperShift = Math.max(ExperimentHeader.this.endShift, ExperimentHeader.this.startShift);
                int numMovedSamples = upperShift - lowerShift + 1;
                int numSpacesMoved = ExperimentHeader.this.endShiftMove - ExperimentHeader.this.startShiftMove;
                int[] samplesMoved = new int[numMovedSamples];
                for (int i2 = 0; i2 < samplesMoved.length; ++i2) {
                    samplesMoved[i2] = ExperimentHeader.this.getSamplesOrder()[lowerShift + i2];
                }
                ArrayList<Integer> tempSamplesOrder = new ArrayList<Integer>();
                for (i = 0; i < ExperimentHeader.this.getSamplesOrder().length; ++i) {
                    tempSamplesOrder.add(ExperimentHeader.this.getSamplesOrder()[i]);
                }
                for (i = 0; i < numMovedSamples; ++i) {
                    tempSamplesOrder.remove(lowerShift);
                }
                for (i = 0; i < numMovedSamples; ++i) {
                    tempSamplesOrder.add(lowerShift + numSpacesMoved + i, samplesMoved[i]);
                }
                for (i = 0; i < ExperimentHeader.this.getSamplesOrder().length; ++i) {
                    ExperimentHeader.this.getSamplesOrder()[i] = (Integer)tempSamplesOrder.get(i);
                }
                ExperimentHeader.this.isShiftMove = false;
                ExperimentHeader.this.isShift = false;
                return;
            }
            if (ExperimentHeader.this.isSampleDrag) {
                int i;
                int startSample;
                if (endColumn > ExperimentHeader.this.startColumn) {
                    startSample = ExperimentHeader.this.getSamplesOrder()[ExperimentHeader.this.startColumn];
                    for (i = 0; i < endColumn - ExperimentHeader.this.startColumn; ++i) {
                        ExperimentHeader.this.getSamplesOrder()[((ExperimentHeader)ExperimentHeader.this).startColumn + i] = ExperimentHeader.this.getSamplesOrder()[ExperimentHeader.this.startColumn + i + 1];
                    }
                    ExperimentHeader.this.getSamplesOrder()[endColumn] = startSample;
                    ExperimentHeader.this.repaint();
                }
                if (endColumn < ExperimentHeader.this.startColumn) {
                    startSample = ExperimentHeader.this.getSamplesOrder()[ExperimentHeader.this.startColumn];
                    for (i = 0; i < ExperimentHeader.this.startColumn - endColumn; ++i) {
                        ExperimentHeader.this.getSamplesOrder()[((ExperimentHeader)ExperimentHeader.this).startColumn - i] = ExperimentHeader.this.getSamplesOrder()[ExperimentHeader.this.startColumn - (i + 1)];
                    }
                    ExperimentHeader.this.getSamplesOrder()[endColumn] = startSample;
                    ExperimentHeader.this.repaint();
                }
            }
            ExperimentHeader.this.isSampleDrag = false;
            if (!ExperimentHeader.this.headerDrag) {
                return;
            }
            ExperimentHeader.this.headerDrag = false;
            int endRow = ExperimentHeader.this.findRow(event.getY());
            if (!ExperimentHeader.this.isLegalPosition(ExperimentHeader.this.startRow, ExperimentHeader.this.startColumn)) {
                return;
            }
            if (!ExperimentHeader.this.isCompact) {
                Color inter = (Color)ExperimentHeader.this.storedSampleColors.get(ExperimentHeader.this.storedSampleColors.size() - 1 - ExperimentHeader.this.startRow);
                ExperimentHeader.this.storedSampleColors.remove(ExperimentHeader.this.storedSampleColors.size() - 1 - ExperimentHeader.this.startRow);
                ExperimentHeader.this.storedSampleColors.add(ExperimentHeader.this.storedSampleColors.size() - endRow, inter);
                ExperimentHeader.this.repaint();
            } else {
                for (int j = 0; j < ExperimentHeader.this.storedSampleColors.size(); ++j) {
                    if (ColorOverlaps[j] == ExperimentHeader.this.compactedColorBarHeight - 1 - ExperimentHeader.this.startRow) {
                        ColorOverlaps[j] = -1;
                    }
                    if (ColorOverlaps[j] == ExperimentHeader.this.compactedColorBarHeight - 1 - endRow) {
                        ColorOverlaps[j] = ExperimentHeader.this.compactedColorBarHeight - 1 - ExperimentHeader.this.startRow;
                    }
                    if (ColorOverlaps[j] != -1) continue;
                    ColorOverlaps[j] = ExperimentHeader.this.compactedColorBarHeight - 1 - endRow;
                }
                ExperimentHeader.this.repaint();
            }
        }

        private void setOldPosition(int row, int column) {
            this.oldColumn = column;
            this.oldRow = row;
        }

        private boolean isCurrentPosition(int row, int column) {
            return row == this.oldRow && column == this.oldColumn;
        }
    }
}

