/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class ExperimentClusterViewer
extends JPanel
implements IViewer {
    private static final float INITIAL_MAX_VALUE = 3.0f;
    private static final float INITIAL_MIN_VALUE = -3.0f;
    private static final String NO_EXPERIMENT_STR = "No Experiments in Cluster!";
    private static final Font ERROR_FONT = new Font("monospaced", 1, 20);
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String AUTO_STORE_GENE_CLUSTERS_CMD = "auto-store-gene-cluster-cmd";
    protected static final String AUTO_STORE_SAMPLE_CLUSTERS_CMD = "auto-store-sample-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    public static final String BROADCAST_MATRIX_GAGGLE_CMD = "broadcast-matrix-to-gaggle";
    public static final String BROADCAST_NAMELIST_GAGGLE_CMD = "broadcast-namelist-to-gaggle";
    public static final String BROADCAST_MATRIX_GENOME_BROWSER_CMD = "broadcast-matrix-to-genome-browser";
    private ExperimentClusterHeader header;
    private Experiment experiment;
    private IFramework framework;
    private IData data;
    private int clusterIndex;
    private int[][] clusters;
    public int[] genesOrder;
    private Dimension elementSize = new Dimension(20, 5);
    private int labelIndex = -1;
    private boolean isAntiAliasing = true;
    private boolean isDrawBorders = true;
    private boolean isDrawAnnotations = true;
    public static Color missingColor = new Color(128, 128, 128);
    public static Color maskColor = new Color(255, 255, 255, 128);
    private float maxValue = 3.0f;
    private float minValue = -3.0f;
    private float midValue = 0.0f;
    private int firstSelectedRow = -1;
    private int lastSelectedRow = -1;
    private int firstSelectedColumn = -1;
    private int lastSelectedColumn = -1;
    public BufferedImage posColorImage = this.createGradientImage(Color.black, Color.red);
    public BufferedImage negColorImage = this.createGradientImage(Color.green, Color.black);
    private int annotationWidth;
    private Insets insets = new Insets(0, 10, 0, 0);
    private boolean hasCentroid = false;
    private float[][] centroids;
    private int contentWidth;
    private boolean showClusters = true;
    private boolean haveColorBar = false;
    private boolean useDoubleGradient = true;
    private int exptID = 0;
    private static ArrayList<Color> storedGeneColors = new ArrayList();
    public static ArrayList<Color> savedGeneColorOrder = new ArrayList();
    private int activeCluster = 0;
    private static int[] ColorOverlaps = new int[100000];
    private boolean isCompact = false;
    private boolean isAutoArrangeColors = true;
    private boolean isShowRects = true;
    private int colorWidth = 0;
    private int maxColorWidth = 0;
    boolean mouseOnMap = false;
    int mouseRow = 0;
    int mouseColumn = 0;
    private boolean clickedCell = false;
    private int clickedColumn = 0;
    private int clickedRow = 0;
    private boolean inDrag = false;
    private int dragRow = 0;
    private int dragColumn = 0;
    private JPopupMenu popup;
    private String userFont;
    private int userFontSize;

    public ExperimentClusterViewer(Experiment experiment, int[][] clusters) {
        this(experiment, clusters, true);
    }

    public ExperimentClusterViewer(IFramework framework) {
        this(framework.getData().getExperiment(), null);
        this.framework = framework;
        this.onSelected(framework);
    }

    public ExperimentClusterViewer(Experiment experiment, int[][] clusters, boolean drawAnnotations) {
        this(experiment, clusters, null, drawAnnotations);
    }

    public ExperimentClusterViewer(Experiment experiment, int[][] clusters, int[] genesOrder, boolean drawAnnotations) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.clusters = clusters == null ? ExperimentClusterViewer.defSamplesOrder(experiment.getNumberOfSamples()) : clusters;
        this.genesOrder = genesOrder == null ? ExperimentClusterViewer.defGenesOrder(experiment.getNumberOfGenes()) : genesOrder;
        this.isDrawAnnotations = drawAnnotations;
        this.header = new ExperimentClusterHeader(this.experiment, this.clusters, storedGeneColors);
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        PopupListener popupListener = new PopupListener();
        this.popup = this.createJPopupMenu(popupListener);
        this.getContentComponent().addMouseListener(popupListener);
        this.getHeaderComponent().addMouseListener(popupListener);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, ClusterWrapper.wrapClusters((int[][])this.clusters), ClusterWrapper.wrapClusters((int[][])new int[][]{this.genesOrder}), new Boolean(this.isDrawAnnotations), new Integer(this.insets.left)});
    }

    public ExperimentClusterViewer(Experiment experiment, int[][] clusters, int[] genesOrder, Boolean drawAnnotations, Integer offset) {
        this(experiment, clusters, genesOrder, (boolean)drawAnnotations, (int)offset);
    }

    public ExperimentClusterViewer(Experiment experiment, ClusterWrapper clusters, ClusterWrapper genesOrder, Boolean drawAnnotations, Integer offset) {
        this(experiment, clusters.getClusters(), genesOrder.getClusters()[0], (boolean)drawAnnotations, (int)offset);
    }

    public ExperimentClusterViewer(Experiment experiment, int[][] clusters, int[] genesOrder, boolean drawAnnotations, int offset) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.clusters = clusters == null ? ExperimentClusterViewer.defSamplesOrder(experiment.getNumberOfSamples()) : clusters;
        this.genesOrder = genesOrder == null ? ExperimentClusterViewer.defGenesOrder(experiment.getNumberOfGenes()) : genesOrder;
        this.insets.left = offset;
        this.isDrawAnnotations = drawAnnotations;
        this.header = new ExperimentClusterHeader(this.experiment, this.clusters, storedGeneColors);
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setLeftInset(offset);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        PopupListener popupListener = new PopupListener();
        this.popup = this.createJPopupMenu(popupListener);
        this.getContentComponent().addMouseListener(popupListener);
        this.getHeaderComponent().addMouseListener(popupListener);
    }

    public ExperimentClusterViewer(Experiment experiment, int[][] clusters, String centroidName, Vector vector) {
        this(experiment, clusters, centroidName, ExperimentClusterViewer.getCentroidArray(clusters, vector));
    }

    public ExperimentClusterViewer(Experiment experiment, int[][] clusters, String centroidName, float[][] centroids) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.clusters = clusters == null ? ExperimentClusterViewer.defSamplesOrder(experiment.getNumberOfSamples()) : clusters;
        this.genesOrder = this.genesOrder == null ? ExperimentClusterViewer.defGenesOrder(experiment.getNumberOfGenes()) : this.genesOrder;
        this.insets.left = 10;
        this.isDrawAnnotations = true;
        if (centroidName != null) {
            this.hasCentroid = true;
            this.centroids = centroids;
        }
        this.header = new ExperimentClusterHeader(this.experiment, this.clusters, centroidName, storedGeneColors);
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        PopupListener popupListener = new PopupListener();
        this.popup = this.createJPopupMenu(popupListener);
        this.getContentComponent().addMouseListener(popupListener);
        this.getHeaderComponent().addMouseListener(popupListener);
    }

    @Override
    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
        this.header.setExperiment(e);
    }

    private static int[][] defSamplesOrder(int size) {
        int[][] order = new int[1][size];
        for (int i = 0; i < order[0].length; ++i) {
            order[0][i] = i;
        }
        return order;
    }

    private static int[] defGenesOrder(int size) {
        int[] order = new int[size];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        return order;
    }

    private static float[][] getCentroidArray(int[][] clusters, Vector vector) {
        int len = vector.size();
        float[][] array = new float[clusters.length][len];
        for (int i = 0; i < clusters.length; ++i) {
            for (int j = 0; j < len; ++j) {
                array[i][j] = ((Float)vector.elementAt(j)).floatValue();
            }
        }
        return array;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    @Override
    public JComponent getContentComponent() {
        return this;
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public Color getMissingColor() {
        return missingColor;
    }

    public int getCurrentNumberOfExperiments() {
        return this.getClusters()[this.clusterIndex].length;
    }

    public void selectRows(int start, int end) {
        this.firstSelectedRow = start;
        this.lastSelectedRow = end;
        this.repaint();
    }

    public void selectColumns(int start, int end) {
        this.firstSelectedColumn = start;
        this.lastSelectedColumn = end;
        this.repaint();
    }

    @Override
    public void onSelected(IFramework framework) {
        this.header.clusterViewerClicked = false;
        this.header.clickedCell = false;
        this.clickedCell = false;
        this.framework = framework;
        this.data = framework.getData();
        IDisplayMenu menu = framework.getDisplayMenu();
        this.setUserFont(menu.getUserFont());
        this.header.setUserFont(menu.getUserFont());
        this.setUserFontSize(menu.getUserFontSize());
        this.header.setUserFontSize(menu.getUserFontSize());
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        Integer userObject = (Integer)framework.getUserObject();
        this.setClusterIndex(userObject == null ? 0 : userObject);
        this.header.setClusterIndex(this.clusterIndex);
        this.labelIndex = menu.getLabelIndex();
        this.maxValue = menu.getMaxRatioScale();
        this.minValue = menu.getMinRatioScale();
        this.midValue = menu.getMidRatioValue();
        this.setElementSize(menu.getElementSize());
        this.setAntialiasing(menu.isAntiAliasing());
        this.setDrawBorders(menu.isDrawingBorder());
        this.setCompactClusters(menu.isCompactClusters());
        this.setAutoArrangeColors(menu.isAutoArrangeColors());
        this.setShowRects(menu.isShowRects());
        this.header.isShowRects = this.isShowRects;
        this.header.setCompactClusters(menu.isCompactClusters());
        if (this.isAutoArrangeColors || this.isCompact) {
            storedGeneColors.clear();
            this.header.clearStoredSampleColors();
        }
        this.haveColorBar = this.showClusters ? this.areProbesColored() : false;
        this.updateSize();
        this.maxValue = menu.getMaxRatioScale();
        this.minValue = menu.getMinRatioScale();
        this.midValue = menu.getMidRatioValue();
        this.posColorImage = menu.getPositiveGradientImage();
        this.negColorImage = menu.getNegativeGradientImage();
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        this.header.setValues(this.minValue, this.midValue, this.maxValue);
        this.header.setData(this.data);
        this.header.setValues(this.minValue, this.midValue, this.maxValue);
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
        this.header.repaint();
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
        this.header.clusterViewerClicked = false;
        this.header.clickedCell = false;
        this.clickedCell = false;
        boolean isCompactChanged = this.isCompact;
        boolean isAutoArrangeChanged = this.isAutoArrangeColors;
        this.setUserFont(menu.getUserFont());
        this.header.setUserFont(menu.getUserFont());
        this.setUserFontSize(menu.getUserFontSize());
        this.header.setUserFontSize(menu.getUserFontSize());
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        this.setDrawBorders(menu.isDrawingBorder());
        this.setCompactClusters(menu.isCompactClusters());
        this.setAutoArrangeColors(menu.isAutoArrangeColors());
        this.setShowRects(menu.isShowRects());
        this.header.isShowRects = this.isShowRects;
        this.header.setCompactClusters(menu.isCompactClusters());
        if (!this.isAutoArrangeColors == isAutoArrangeChanged || this.isAutoArrangeColors) {
            storedGeneColors.clear();
            this.header.clearStoredSampleColors();
        }
        this.maxValue = menu.getMaxRatioScale();
        this.minValue = menu.getMinRatioScale();
        this.midValue = menu.getMidRatioValue();
        this.header.setValues(this.minValue, this.midValue, this.maxValue);
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
        this.updateSize();
        this.posColorImage = menu.getPositiveGradientImage();
        this.negColorImage = menu.getNegativeGradientImage();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        if (this.elementSize.equals(menu.getElementSize()) && this.labelIndex == menu.getLabelIndex() && this.isAntiAliasing == menu.isAntiAliasing()) {
            return;
        }
        this.setElementSize(menu.getElementSize());
        this.setAntialiasing(menu.isAntiAliasing());
        this.labelIndex = menu.getLabelIndex();
        this.updateSize();
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
        this.onSelected(this.framework);
    }

    private void setUserFontSize(int userFontSize) {
        this.userFontSize = userFontSize;
    }

    private void setUserFont(String userFont) {
        this.userFont = userFont;
    }

    @Override
    public void onDataChanged(IData data) {
        this.data = data;
        this.header.setData(data);
        this.haveColorBar = this.showClusters ? this.areProbesColored() : false;
        this.updateSize();
    }

    @Override
    public void onDeselected() {
    }

    @Override
    public void onClosed() {
    }

    public void setClusterIndex(int clusterIndex) {
        this.clusterIndex = clusterIndex;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    @Override
    public int[][] getClusters() {
        return this.clusters;
    }

    protected boolean areProbesColored() {
        int[] indices = this.genesOrder;
        for (int i = 0; i < indices.length; ++i) {
            if (this.data.getProbeColor(this.getMultipleArrayDataRow(i)) == null) continue;
            return true;
        }
        return false;
    }

    private int getMultipleArrayDataRow(int clusterArrayRow) {
        return this.experiment.getGeneIndexMappedToData(this.genesOrder[clusterArrayRow]);
    }

    private int getExperimentRow(int row) {
        return this.genesOrder[row];
    }

    private int getColumn(int column) {
        return this.clusters[this.clusterIndex][column];
    }

    @Override
    public Experiment getExperiment() {
        return this.experiment;
    }

    protected IData getData() {
        return this.data;
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            this.framework.removeCluster(this.getCluster(), this.experiment, 1);
        }
    }

    public void storeCluster() {
        this.framework.storeCluster(this.getCluster(), this.experiment, 1);
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
        this.onDataChanged(this.data);
    }

    public Color setHCLClusterColor(int[] clusterIndices, Color color, boolean isGeneHCLCluster) {
        Color clusterColor = null;
        clusterColor = isGeneHCLCluster ? this.framework.storeCluster(clusterIndices, this.experiment, 0) : this.framework.storeCluster(clusterIndices, this.experiment, 1);
        this.selectColumns(-1, -1);
        this.selectRows(-1, -1);
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
        this.header.repaint();
        this.repaint();
        return clusterColor;
    }

    private int[] getIDataRowIndices(int[] expIndices) {
        int[] dataIndices = new int[expIndices.length];
        for (int i = 0; i < expIndices.length; ++i) {
            dataIndices[i] = this.getMultipleArrayDataRow(i);
        }
        return dataIndices;
    }

    public void autoStoreClusters(int clusterType, int index) {
        this.framework.autoStoreClusters(clusterType, index);
    }

    private void setAutoArrangeColors(boolean value) {
        this.isAutoArrangeColors = value;
    }

    public void saveClusters(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveAllExperimentClusters(frame, this.getExperiment(), this.getData(), this.getClusters());
    }

    public void saveCluster(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperimentCluster(frame, this.getExperiment(), this.getData(), this.getCluster());
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getCluster(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    private void setElementSize(Dimension elementSize) {
        this.elementSize = new Dimension(elementSize);
    }

    private void setAntialiasing(boolean value) {
        this.isAntiAliasing = value;
    }

    private void setDrawBorders(boolean value) {
        this.isDrawBorders = value;
    }

    private void setCompactClusters(boolean value) {
        if (value == this.isCompact) {
            return;
        }
        if (value) {
            savedGeneColorOrder.clear();
            for (int i = 0; i < storedGeneColors.size(); ++i) {
                savedGeneColorOrder.add(storedGeneColors.get(i));
            }
            storedGeneColors.clear();
        } else {
            storedGeneColors.clear();
            this.clearColorOverlaps();
            for (int i = 0; i < savedGeneColorOrder.size(); ++i) {
                storedGeneColors.add(savedGeneColorOrder.get(i));
            }
        }
        this.isCompact = value;
    }

    private void clearColorOverlaps() {
        for (int i = 0; i < ColorOverlaps.length; ++i) {
            ExperimentClusterViewer.ColorOverlaps[i] = i;
        }
    }

    public void setClusters(int[][] mat) {
        this.clusters = new int[mat.length][mat[0].length];
        for (int i = 0; i < mat.length; ++i) {
            for (int j = 0; j < mat[i].length; ++j) {
                this.clusters[i][j] = mat[i][j];
            }
        }
        this.repaint();
        this.updateUI();
    }

    private void setShowRects(boolean value) {
        this.isShowRects = !value;
        this.header.isShowRects = !value;
    }

    public BufferedImage createGradientImage(Color color1, Color color2) {
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics = image.createGraphics();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 255.0f, 0.0f, color2);
        graphics.setPaint(gp);
        graphics.drawRect(0, 0, 255, 1);
        return image;
    }

    private void updateSize() {
        if (this.clusters == null || this.getCluster().length == 0) {
            this.setFont(ERROR_FONT);
            Graphics2D g = (Graphics2D)this.getGraphics();
            FontMetrics metrics = g.getFontMetrics();
            int width = metrics.stringWidth(NO_EXPERIMENT_STR) + 10;
            int height = metrics.getHeight() + 30;
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
            return;
        }
        this.setFont(new Font(this.userFont, 0, this.elementSize.height));
        Graphics2D g = (Graphics2D)this.getGraphics();
        int width = this.elementSize.width * this.getCluster().length + 1 + this.insets.left;
        if (this.isDrawAnnotations) {
            this.annotationWidth = this.getMaxWidth(g);
            width += 20 + this.annotationWidth;
        }
        if (this.hasCentroid) {
            width += this.elementSize.width + 5;
        }
        if (this.maxColorWidth < this.colorWidth) {
            this.maxColorWidth = this.colorWidth;
        }
        if (this.haveColorBar) {
            width += this.colorWidth * this.elementSize.width + 10;
            if (this.colorWidth == 0) {
                width += this.elementSize.width + 10;
            }
        }
        int height = this.elementSize.height * this.genesOrder.length + 1;
        this.contentWidth = width;
        if (this.header.getSize().width > width) {
            this.setSize(this.header.getSize().width, height);
            this.setPreferredSize(new Dimension(this.header.getSize().width, height));
        } else {
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
            this.header.fixHeaderWidth(this.getSize().width);
        }
        if (this.isCompact) {
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
        }
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    private int getMaxWidth(Graphics2D g) {
        if (g == null || this.data == null || this.getCluster() == null) {
            return 0;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        int max = 0;
        for (int i = 0; i < this.genesOrder.length; ++i) {
            String str = this.data.getElementAttribute(this.getMultipleArrayDataRow(i), this.labelIndex);
            max = Math.max(max, fm.stringWidth(str));
        }
        return max;
    }

    private Color getColor(float value) {
        int rgb;
        if (Float.isNaN(value)) {
            return missingColor;
        }
        if (this.useDoubleGradient) {
            float maximum = value < this.midValue ? this.minValue : this.maxValue;
            int colorIndex = (int)(255.0f * (value - this.midValue) / (maximum - this.midValue));
            if (colorIndex < 0) {
                colorIndex = -colorIndex;
            }
            colorIndex = colorIndex > 255 ? 255 : colorIndex;
            rgb = value < this.midValue ? this.negColorImage.getRGB(255 - colorIndex, 0) : this.posColorImage.getRGB(colorIndex, 0);
        } else {
            float span = this.maxValue - this.minValue;
            int colorIndex = value <= this.minValue ? 0 : (value >= this.maxValue ? 255 : (int)((value - this.minValue) / span * 255.0f));
            rgb = this.posColorImage.getRGB(colorIndex, 0);
        }
        return new Color(rgb);
    }

    public ArrayList getStoredColors() {
        return storedGeneColors;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.header.setStoredColors(storedGeneColors);
        this.header.repaint();
        if (this.data == null) {
            return;
        }
        int oldWidth = this.colorWidth;
        if (this.elementSize.getHeight() < 1.0) {
            return;
        }
        int samples = this.getCluster().length;
        if (this.clusters == null || this.getCluster().length == 0) {
            g.setColor(new Color(0, 0, 128));
            g.setFont(ERROR_FONT);
            g.drawString(NO_EXPERIMENT_STR, 10, 30);
            return;
        }
        Rectangle bounds = g.getClipBounds();
        int top = this.getTopIndex(bounds.y);
        int bottom = this.getBottomIndex(bounds.y + bounds.height, this.genesOrder.length);
        int left = this.getLeftIndex(bounds.x);
        int right = this.getRightIndex(bounds.x + bounds.width, samples);
        if (this.hasCentroid) {
            for (int row = top; row < bottom; ++row) {
                this.fillCentroidRectAt(g, row);
            }
        }
        for (int column = left; column < right; ++column) {
            for (int row = top; row < bottom; ++row) {
                this.fillRectAt(g, row, column);
            }
        }
        Color initColor = g.getColor();
        int expWidth = samples * this.elementSize.width + 5;
        int spacesOver = 0;
        if (this.haveColorBar) {
            for (int row = top; row < bottom; ++row) {
                Color[] colors = this.data.getGeneColorArray(this.getMultipleArrayDataRow(row));
                if (colors == null) continue;
                for (int clusters = 0; clusters < colors.length; ++clusters) {
                    if (colors[clusters] == null) continue;
                    if (storedGeneColors.contains(colors[clusters])) {
                        this.activeCluster = storedGeneColors.indexOf(colors[clusters]);
                    } else {
                        storedGeneColors.add(colors[clusters]);
                        ExperimentClusterViewer.ColorOverlaps[this.activeCluster] = this.activeCluster = storedGeneColors.size() - 1;
                        boolean foundit = false;
                        if (!this.isCompact) {
                            foundit = true;
                        }
                        while (!foundit) {
                            for (int i = 0; i < storedGeneColors.size(); ++i) {
                                boolean allClear = true;
                                for (int j = 0; j < storedGeneColors.size(); ++j) {
                                    if (ColorOverlaps[j] != i) continue;
                                    if (this.data.isColorOverlap(this.getMultipleArrayDataRow(row), colors[clusters], storedGeneColors.get(j), true)) {
                                        allClear = false;
                                        break;
                                    }
                                    allClear = true;
                                }
                                if (!allClear) continue;
                                ExperimentClusterViewer.ColorOverlaps[this.activeCluster] = i;
                                foundit = true;
                                break;
                            }
                            if (!foundit) continue;
                        }
                    }
                    spacesOver = ColorOverlaps[this.activeCluster];
                    expWidth = samples * this.elementSize.width + 5 + this.elementSize.width * spacesOver;
                    if (this.hasCentroid) {
                        expWidth += this.elementSize.width + 5;
                    }
                    this.fillClusterRectAt(g, row, expWidth, colors[clusters]);
                }
            }
        }
        g.setColor(initColor);
        if (this.isDrawAnnotations) {
            if (this.isAntiAliasing) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (right >= samples) {
                g.setColor(Color.black);
                int uniqX = this.elementSize.width * samples + 10;
                if (this.hasCentroid) {
                    uniqX += this.elementSize.width + 5;
                }
                if (this.haveColorBar && !this.isCompact) {
                    uniqX += this.elementSize.width * storedGeneColors.size();
                    this.colorWidth = storedGeneColors.size();
                }
                if (this.isCompact) {
                    int maxSpacesOver = -1;
                    for (int i = 0; i < storedGeneColors.size(); ++i) {
                        if (ColorOverlaps[i] <= maxSpacesOver) continue;
                        maxSpacesOver = ColorOverlaps[i];
                    }
                    this.colorWidth = maxSpacesOver + 1;
                    uniqX += this.elementSize.width * (maxSpacesOver + 1);
                }
                String[] annot = new String[]{""};
                for (int row = top; row < bottom; ++row) {
                    if (this.labelIndex >= 0) {
                        annot = this.data.getElementAnnotation(this.getMultipleArrayDataRow(row), this.data.getFieldNames()[this.labelIndex]);
                    }
                    int annY = (row + 1) * this.elementSize.height;
                    g.drawString(annot[0], uniqX + this.insets.left, annY);
                }
            }
        }
        if (this.mouseOnMap) {
            this.drawRectAt(g, this.mouseRow, this.mouseColumn, Color.white);
            if (this.haveColorBar && this.isShowRects) {
                this.drawClusterRectsAt(g, this.mouseRow, this.mouseColumn, Color.gray);
            }
        }
        this.mouseOnMap = false;
        if (this.clickedCell) {
            g.setColor(Color.red);
            if (!this.isCompact) {
                this.drawClusterRectsAt(g, this.clickedRow, this.clickedColumn, Color.red);
            }
        }
        if (this.inDrag) {
            g.setColor(Color.blue);
            g.drawRect(this.dragColumn * this.elementSize.width + this.insets.left + 5 - 1, -1, this.elementSize.width, this.elementSize.height * this.experiment.getNumberOfGenes() + 1);
            this.header.drawClusterHeaderRectsAt(this.dragColumn, Color.blue, true);
        }
        if (this.colorWidth != oldWidth) {
            this.updateSize();
        }
    }

    private void fillRectAt(Graphics g, int row, int column) {
        if (column > this.getCluster().length - 1) {
            return;
        }
        int x = column * this.elementSize.width + this.insets.left;
        int y = row * this.elementSize.height;
        if (this.hasCentroid) {
            x += this.elementSize.width + 5;
        }
        boolean mask = this.firstSelectedRow >= 0 && this.lastSelectedRow >= 0 && (row < this.firstSelectedRow || row > this.lastSelectedRow);
        mask = mask || this.firstSelectedColumn >= 0 && this.lastSelectedColumn >= 0 && (column < this.firstSelectedColumn || column > this.lastSelectedColumn);
        g.setColor(this.getColor(this.experiment.get(this.getExperimentRow(row), this.getColumn(column))));
        g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
        if (mask) {
            g.setColor(maskColor);
            g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
        }
        if (this.isDrawBorders) {
            g.setColor(Color.black);
            g.drawRect(x, y, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void fillCentroidRectAt(Graphics g, int row) {
        int x = this.insets.left;
        int y = row * this.elementSize.height;
        boolean mask = this.firstSelectedRow >= 0 && this.lastSelectedRow >= 0 && (row < this.firstSelectedRow || row > this.lastSelectedRow);
        g.setColor(this.getColor(this.centroids[this.clusterIndex][row]));
        g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
        if (mask) {
            g.setColor(maskColor);
            g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
        }
        if (this.isDrawBorders) {
            g.setColor(Color.black);
            g.drawRect(x, y, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void fillClusterRectAt(Graphics g, int row, int xLoc, Color color) {
        if (color == null) {
            color = Color.white;
        }
        g.setColor(color);
        g.fillRect(xLoc + this.insets.left, row * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height);
    }

    private void drawRectAt(Graphics g, int row, int column, Color color) {
        if (column >= this.getCluster().length) {
            return;
        }
        g.setColor(color);
        if (!this.hasCentroid) {
            g.drawRect(column * this.elementSize.width + this.insets.left, row * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
        } else {
            g.drawRect(column * this.elementSize.width + this.insets.left + this.elementSize.width + 5, row * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void drawClusterRectsAt(Graphics g, int row, int column, Color color) {
        int centroidOffset = 0;
        if (this.hasCentroid) {
            centroidOffset = this.elementSize.width + 5;
        }
        g.setColor(color);
        if (column >= this.getCluster().length) {
            g.drawRect(this.getCluster().length * this.elementSize.width + this.insets.left + 5 - 1 + centroidOffset, row * this.elementSize.height - 1, this.elementSize.width * this.colorWidth + this.annotationWidth + 8, this.elementSize.height + 1);
            if (this.isCompact) {
                return;
            }
            g.drawRect(column * this.elementSize.width + this.insets.left + 5 - 1, -1, this.elementSize.width, this.elementSize.height * this.experiment.getNumberOfGenes() + 1);
            this.header.drawClusterHeaderRectsAt(column, color, true);
        } else {
            g.drawRect(this.getCluster().length * this.elementSize.width + this.insets.left + 5 - 1 + centroidOffset, row * this.elementSize.height - 1, this.elementSize.width * this.colorWidth + this.annotationWidth + 8, this.elementSize.height + 1);
            this.header.drawClusterHeaderRectsAt(column, color, false);
        }
    }

    protected boolean haveClusterColor() {
        int samples = this.getCluster().length;
        for (int i = 0; i < samples; ++i) {
            if (this.data.getExperimentColor(this.getColumn(i)) == null) continue;
            return true;
        }
        return false;
    }

    private int getTopIndex(int top) {
        if (top < 0) {
            return 0;
        }
        return top / this.elementSize.height;
    }

    private int getLeftIndex(int left) {
        if (left < this.insets.left) {
            return 0;
        }
        if (!this.hasCentroid) {
            return (left - this.insets.left) / this.elementSize.width;
        }
        if (left < this.insets.left + this.elementSize.width + 5) {
            return 0;
        }
        return (left - this.insets.left - this.elementSize.width - 5) / this.elementSize.width;
    }

    private int getRightIndex(int right, int limit) {
        if (right < 0) {
            return 0;
        }
        int result = 0;
        result = !this.hasCentroid ? right / this.elementSize.width + 1 : (right - (this.insets.left + this.elementSize.width + 5)) / this.elementSize.width + 1;
        return result > limit ? limit : result;
    }

    private int getBottomIndex(int bottom, int limit) {
        if (bottom < 0) {
            return 0;
        }
        int result = bottom / this.elementSize.height + 1;
        return result > limit ? limit : result;
    }

    private int findColumn(int targetx) {
        int xSize = this.getCluster().length * this.elementSize.width;
        if (this.hasCentroid) {
            if (targetx >= (xSize += this.elementSize.width + 5) + this.insets.left || targetx < this.insets.left + this.elementSize.width + 5) {
                return -1;
            }
            return (targetx - this.insets.left - this.elementSize.width - 5) / this.elementSize.width;
        }
        if (targetx >= xSize + this.insets.left + this.elementSize.width * this.colorWidth + 10 || targetx < this.insets.left) {
            return -1;
        }
        if (targetx >= xSize + this.insets.left && targetx < xSize + this.insets.left + this.elementSize.width * this.colorWidth + 10) {
            return (targetx - this.insets.left - 5) / this.elementSize.width;
        }
        return (targetx - this.insets.left) / this.elementSize.width;
    }

    private int findRow(int targety) {
        int ySize = this.genesOrder.length * this.elementSize.height;
        if (targety >= ySize || targety < 0) {
            return -1;
        }
        return targety / this.elementSize.height;
    }

    private boolean isLegalPosition(int row, int column) {
        return this.isLegalRow(row) && this.isLegalColumn(column);
    }

    private boolean isLegalColumn(int column) {
        return column >= 0 && column <= this.getCluster().length - 1 + this.colorWidth;
    }

    private boolean isLegalRow(int row) {
        return row >= 0 && row <= this.genesOrder.length - 1;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Store cluster", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Store clusters by gene annotation", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(AUTO_STORE_GENE_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Store clusters by sample annotation", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(AUTO_STORE_SAMPLE_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon((String)"lanuch_new_mav.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon((String)"delete16.gif"));
        menuItem.setActionCommand(SET_DEF_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Broadcast Matrix to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_MATRIX_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Gene List to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_NAMELIST_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Matrix to Genome Browser", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_MATRIX_GENOME_BROWSER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    public void broadcastClusterGaggle() {
        this.framework.broadcastGeneCluster(this.getExperiment(), null, this.getCluster());
    }

    public void broadcastNamelistGaggle() {
        this.framework.broadcastNamelist(this.getExperiment(), this.getExperiment().getRows());
    }

    public void setFramework(IFramework framework) {
        this.framework = framework;
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    @Override
    public int getViewerType() {
        return 1;
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void setExperimentID(int id) {
        this.exptID = id;
    }

    protected JPopupMenu createJPopupMenu(PopupListener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveClusters(frame);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveCluster(frame);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    public void broadcastGeneClusterToGenomeBrowser() {
        this.framework.broadcastGeneClusterToGenomeBrowser(this.getExperiment(), this.getCluster(), null);
    }

    protected void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color newColor = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (newColor != null) {
            this.setClusterColor(newColor);
        }
    }

    protected void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    private class PopupListener
    extends MouseAdapter
    implements ActionListener {
        private PopupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(ExperimentClusterViewer.SAVE_CLUSTER_CMD)) {
                ExperimentClusterViewer.this.onSaveCluster();
            } else if (command.equals(ExperimentClusterViewer.SAVE_ALL_CLUSTERS_CMD)) {
                ExperimentClusterViewer.this.onSaveClusters();
            } else if (command.equals(ExperimentClusterViewer.STORE_CLUSTER_CMD)) {
                ExperimentClusterViewer.this.storeCluster();
            } else if (command.equals(ExperimentClusterViewer.AUTO_STORE_GENE_CLUSTERS_CMD)) {
                ExperimentClusterViewer.this.autoStoreClusters(0, ExperimentClusterViewer.this.labelIndex);
            } else if (command.equals(ExperimentClusterViewer.AUTO_STORE_SAMPLE_CLUSTERS_CMD)) {
                ExperimentClusterViewer.this.autoStoreClusters(1, 0);
            } else if (command.equals(ExperimentClusterViewer.SET_DEF_COLOR_CMD)) {
                ExperimentClusterViewer.this.onSetDefaultColor();
            } else if (command.equals(ExperimentClusterViewer.LAUNCH_NEW_SESSION_CMD)) {
                ExperimentClusterViewer.this.launchNewSession();
            } else if (command.equals(ExperimentClusterViewer.BROADCAST_MATRIX_GAGGLE_CMD)) {
                ExperimentClusterViewer.this.broadcastClusterGaggle();
            } else if (command.equals(ExperimentClusterViewer.BROADCAST_NAMELIST_GAGGLE_CMD)) {
                ExperimentClusterViewer.this.broadcastNamelistGaggle();
            } else if (command.equals(ExperimentClusterViewer.BROADCAST_MATRIX_GENOME_BROWSER_CMD)) {
                System.out.println("Sending command to broadcast to genome browser? ");
                ExperimentClusterViewer.this.broadcastGeneClusterToGenomeBrowser();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || ExperimentClusterViewer.this.getCluster() == null || ExperimentClusterViewer.this.getCluster().length == 0) {
                return;
            }
            ExperimentClusterViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private String oldStatusText = "";
        private int oldRow = -1;
        private int oldColumn = -1;
        private int startColumn = 0;
        private int startRow = 0;

        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            int column = ExperimentClusterViewer.this.findColumn(event.getX());
            int row = ExperimentClusterViewer.this.findRow(event.getY());
            if (!ExperimentClusterViewer.this.isLegalPosition(row, column)) {
                return;
            }
            if (column > ExperimentClusterViewer.this.getCluster().length - 1) {
                if (row == ExperimentClusterViewer.this.clickedRow && column == ExperimentClusterViewer.this.clickedColumn) {
                    ExperimentClusterViewer.this.clickedCell = !ExperimentClusterViewer.this.clickedCell;
                    ((ExperimentClusterViewer)ExperimentClusterViewer.this).header.clusterViewerClicked = ExperimentClusterViewer.this.clickedCell;
                    return;
                }
                ExperimentClusterViewer.this.clickedRow = row;
                ExperimentClusterViewer.this.clickedColumn = column;
                ExperimentClusterViewer.this.clickedCell = true;
                ((ExperimentClusterViewer)ExperimentClusterViewer.this).header.clusterViewerClickedColumn = column;
                ((ExperimentClusterViewer)ExperimentClusterViewer.this).header.clusterViewerClicked = true;
                if (ExperimentClusterViewer.this.isCompact) {
                    ExperimentClusterViewer.this.clickedCell = false;
                    ((ExperimentClusterViewer)ExperimentClusterViewer.this).header.clusterViewerClicked = false;
                }
                ExperimentClusterViewer.this.repaint();
                return;
            }
            if (!event.isShiftDown()) {
                ExperimentClusterViewer.this.framework.displaySlideElementInfo(ExperimentClusterViewer.this.experiment.getSampleIndex(ExperimentClusterViewer.this.getColumn(column)), ExperimentClusterViewer.this.getMultipleArrayDataRow(row));
                return;
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (ExperimentClusterViewer.this.experiment.getNumberOfSamples() == 0 || event.isShiftDown()) {
                return;
            }
            int column = ExperimentClusterViewer.this.findColumn(event.getX());
            int row = ExperimentClusterViewer.this.findRow(event.getY());
            Graphics g = null;
            g = ExperimentClusterViewer.this.getGraphics();
            if (this.isCurrentPosition(row, column)) {
                if (ExperimentClusterViewer.this.isLegalPosition(row, column) && ExperimentClusterViewer.this.isShowRects) {
                    ExperimentClusterViewer.this.drawClusterRectsAt(g, this.oldRow, this.oldColumn, Color.gray);
                }
                return;
            }
            if (!this.isCurrentPosition(row, column) && ExperimentClusterViewer.this.isLegalPosition(row, column)) {
                ExperimentClusterViewer.this.mouseOnMap = true;
                ExperimentClusterViewer.this.mouseRow = row;
                ExperimentClusterViewer.this.mouseColumn = column;
                ExperimentClusterViewer.this.repaint();
            }
            if (ExperimentClusterViewer.this.isLegalPosition(row, column) && column < ExperimentClusterViewer.this.getCluster().length - 1) {
                ExperimentClusterViewer.this.drawRectAt(g, row, column, Color.white);
                if (ExperimentClusterViewer.this.isShowRects) {
                    ExperimentClusterViewer.this.drawClusterRectsAt(g, row, column, Color.gray);
                }
                ExperimentClusterViewer.this.framework.setStatusText("Gene: " + ExperimentClusterViewer.this.data.getUniqueId(ExperimentClusterViewer.this.getMultipleArrayDataRow(row)) + " Sample: " + ExperimentClusterViewer.this.data.getSampleName(ExperimentClusterViewer.this.experiment.getSampleIndex(ExperimentClusterViewer.this.getColumn(column))) + " Value: " + ExperimentClusterViewer.this.experiment.get(ExperimentClusterViewer.this.getExperimentRow(row), ExperimentClusterViewer.this.getColumn(column)));
            } else {
                ExperimentClusterViewer.this.repaint();
                ExperimentClusterViewer.this.framework.setStatusText(this.oldStatusText);
            }
            if (ExperimentClusterViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                g = g != null ? g : ExperimentClusterViewer.this.getGraphics();
                ExperimentClusterViewer.this.fillRectAt(g, this.oldRow, this.oldColumn);
            }
            this.setOldPosition(row, column);
            if (g != null) {
                g.dispose();
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.oldStatusText = ExperimentClusterViewer.this.framework.getStatusText();
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (ExperimentClusterViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                Graphics g = ExperimentClusterViewer.this.getGraphics();
                ExperimentClusterViewer.this.fillRectAt(g, this.oldRow, this.oldColumn);
                g.dispose();
            }
            this.setOldPosition(-1, -1);
            ExperimentClusterViewer.this.framework.setStatusText(this.oldStatusText);
            ExperimentClusterViewer.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            ExperimentClusterViewer.this.repaint();
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            int column = ExperimentClusterViewer.this.findColumn(event.getX());
            int row = ExperimentClusterViewer.this.findRow(event.getY());
            if (!ExperimentClusterViewer.this.isLegalPosition(row, column)) {
                ExperimentClusterViewer.this.inDrag = false;
                ExperimentClusterViewer.this.header.setDrag(false, 0, 0);
                return;
            }
            if (!ExperimentClusterViewer.this.inDrag) {
                return;
            }
            ExperimentClusterViewer.this.dragColumn = column;
            ExperimentClusterViewer.this.dragRow = row;
            ExperimentClusterViewer.this.header.setDrag(true, ExperimentClusterViewer.this.dragColumn, ExperimentClusterViewer.this.dragRow);
            if (column < ExperimentClusterViewer.this.getCluster().length) {
                ExperimentClusterViewer.this.inDrag = false;
                ExperimentClusterViewer.this.header.setDrag(false, 0, 0);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            this.startColumn = ExperimentClusterViewer.this.findColumn(event.getX());
            this.startRow = ExperimentClusterViewer.this.findRow(event.getY());
            if (!ExperimentClusterViewer.this.isLegalPosition(this.startRow, this.startColumn) || event.isShiftDown() || this.startColumn < ExperimentClusterViewer.this.experiment.getNumberOfSamples()) {
                return;
            }
            ExperimentClusterViewer.this.inDrag = true;
            ExperimentClusterViewer.this.dragColumn = this.startColumn;
            ExperimentClusterViewer.this.dragRow = this.startRow;
            ExperimentClusterViewer.this.header.setDrag(true, this.startColumn, this.startRow);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (!ExperimentClusterViewer.this.inDrag) {
                return;
            }
            ExperimentClusterViewer.this.inDrag = false;
            ExperimentClusterViewer.this.header.setDrag(false, 0, 0);
            int endColumn = ExperimentClusterViewer.this.findColumn(event.getX());
            if (endColumn < ExperimentClusterViewer.this.getCluster().length) {
                return;
            }
            int endRow = ExperimentClusterViewer.this.findRow(event.getY());
            if (!ExperimentClusterViewer.this.isLegalPosition(this.startRow, this.startColumn)) {
                return;
            }
            if (!ExperimentClusterViewer.this.isCompact) {
                Color inter = (Color)storedGeneColors.get(this.startColumn - ExperimentClusterViewer.this.getCluster().length);
                storedGeneColors.remove(this.startColumn - ExperimentClusterViewer.this.getCluster().length);
                storedGeneColors.add(endColumn - ExperimentClusterViewer.this.getCluster().length, inter);
                ExperimentClusterViewer.this.repaint();
            } else {
                for (int j = 0; j < storedGeneColors.size(); ++j) {
                    if (ColorOverlaps[j] == this.startColumn - ExperimentClusterViewer.this.getCluster().length) {
                        ColorOverlaps[j] = -1;
                    }
                    if (ColorOverlaps[j] == endColumn - ExperimentClusterViewer.this.getCluster().length) {
                        ColorOverlaps[j] = this.startColumn - ExperimentClusterViewer.this.getCluster().length;
                    }
                    if (ColorOverlaps[j] != -1) continue;
                    ColorOverlaps[j] = endColumn - ExperimentClusterViewer.this.getCluster().length;
                }
            }
        }

        private void setOldPosition(int row, int column) {
            this.oldColumn = column;
            this.oldRow = row;
        }

        private boolean isCurrentPosition(int row, int column) {
            return row == this.oldRow && column == this.oldColumn;
        }
    }
}

