/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableSearchDialog;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.QSort;

public class ExperimentClusterTableViewer
implements IViewer {
    private static final String NO_GENES_STR = "No Genes in Cluster!";
    private static final Font ERROR_FONT = new Font("monospaced", 1, 20);
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String STORE_SELECTED_ROWS_CMD = "store-selected-rows-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    protected static final String LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD = "launch-new-session-with-sel-rows-cmd";
    protected static final String SEARCH_CMD = "search-cmd";
    protected static final String CLEAR_ALL_CMD = "clear-all-cmd";
    protected static final String SELECT_ALL_CMD = "select-all-cmd";
    protected static final String COPY_CELLS = "copy-cells-cmd";
    protected static final String SORT_ORIG_ORDER_CMD = "sort-orig-order-cmd";
    public static final String BROADCAST_MATRIX_GAGGLE_CMD = "broadcast-matrix-to-gaggle";
    public static final String BROADCAST_SELECTED_MATRIX_GAGGLE_CMD = "broadcast-selected-matrix-to-gaggle";
    public static final String BROADCAST_NAMELIST_GAGGLE_CMD = "broadcast-namelist-to-gaggle";
    public static final String BROADCAST_MATRIX_GENOME_BROWSER_CMD = "broadcast-matrix-to-genome-browser";
    public static final int INTEGER_TYPE = 10;
    public static final int FLOAT_TYPE = 11;
    public static final int DOUBLE_TYPE = 12;
    public static final int STRING_TYPE = 13;
    public static final int BOOLEAN_TYPE = 14;
    private JComponent header;
    private JPopupMenu popup;
    private Experiment experiment;
    private IFramework framework;
    private IData data;
    private int clusterIndex;
    private int[][] clusters;
    private int[][] sortedClusters;
    private String[] auxTitles;
    private Object[][] auxData;
    private boolean[][] sortedAscending;
    private JTable clusterTable;
    private ExperimentClusterTableModel clusterModel;
    private ClusterTableSearchDialog searchDialog;
    private int exptID = 0;

    public int getExptID() {
        return this.exptID;
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, ClusterWrapper.wrapClusters((int[][])this.clusters), this.data, this.auxTitles, this.auxData});
    }

    public ExperimentClusterTableViewer(Experiment experiment, ClusterWrapper clusters, IData data, String[] auxTitles, Object[][] auxData) {
        this(experiment, clusters.getClusters(), data, auxTitles, auxData);
    }

    public ExperimentClusterTableViewer(Experiment experiment, int[][] clusters, IData data, String[] auxTitles, Object[][] auxData) {
        int i;
        int i2;
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.data = data;
        this.experiment = experiment;
        this.clusters = clusters;
        this.auxTitles = auxTitles;
        this.auxData = auxData;
        this.exptID = experiment.getId();
        this.sortedClusters = new int[clusters.length][];
        for (i2 = 0; i2 < this.sortedClusters.length; ++i2) {
            this.sortedClusters[i2] = new int[clusters[i2].length];
        }
        for (i2 = 0; i2 < this.sortedClusters.length; ++i2) {
            for (int j = 0; j < this.sortedClusters[i2].length; ++j) {
                this.sortedClusters[i2][j] = clusters[i2][j];
            }
        }
        this.clusterModel = new ExperimentClusterTableModel();
        this.clusterTable = new JTable(this.clusterModel);
        this.clusterTable.setDefaultRenderer(Color.class, new ColorRenderer(true));
        TableColumn column = null;
        for (i = 0; i < this.clusterModel.getColumnCount(); ++i) {
            column = this.clusterTable.getColumnModel().getColumn(i);
            column.setMinWidth(30);
        }
        this.sortedAscending = new boolean[clusters.length][this.clusterModel.getColumnCount()];
        for (i = 0; i < this.sortedAscending.length; ++i) {
            for (int j = 0; j < this.sortedAscending[i].length; ++j) {
                this.sortedAscending[i][j] = false;
            }
        }
        this.addMouseListenerToHeaderInTable(this.clusterTable);
        this.header = this.clusterTable.getTableHeader();
        this.searchDialog = new ClusterTableSearchDialog(JOptionPane.getFrameForComponent(this.clusterTable), this.clusterTable, false);
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.clusterTable.addMouseListener(listener);
    }

    public ExperimentClusterTableViewer(IFramework framework) {
        this(framework.getData().getExperiment(), ExperimentClusterTableViewer.defSamplesOrder(framework.getData().getExperiment().getNumberOfSamples()), framework.getData(), framework.getData().getSlideNameKeyArray(), (Object[][])framework.getData().getSampleAnnotationMatrix());
        this.framework = framework;
    }

    public ExperimentClusterTableViewer(Experiment experiment, int[][] clusters, IData data) {
        this(experiment, clusters, data, new String[0], new Object[0][0]);
    }

    private static int[][] defSamplesOrder(int size) {
        int[][] order = new int[1][size];
        for (int i = 0; i < order[0].length; ++i) {
            order[0][i] = i;
        }
        return order;
    }

    public JTable getTable() {
        return this.clusterTable;
    }

    public void setTableClusters(int[][] mat) {
        this.sortedClusters = new int[mat.length][mat[0].length];
        this.clusters = new int[mat.length][mat[0].length];
        for (int i = 0; i < mat.length; ++i) {
            for (int j = 0; j < mat[i].length; ++j) {
                this.clusters[i][j] = mat[i][j];
                this.sortedClusters[i][j] = mat[i][j];
            }
        }
        this.clusterTable.clearSelection();
    }

    @Override
    public JComponent getContentComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.gray);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        constraints.anchor = 11;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.clusterTable, constraints);
        panel.add(this.clusterTable);
        return panel;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    @Override
    public JComponent getHeaderComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.header, constraints);
        panel.add(this.header);
        return panel;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public void onClosed() {
    }

    @Override
    public void onDataChanged(IData data) {
        this.data = data;
    }

    @Override
    public void onDeselected() {
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        IDisplayMenu menu = framework.getDisplayMenu();
        Integer userObject = (Integer)framework.getUserObject();
        this.setClusterIndex(userObject == null ? 0 : userObject);
        this.clusterTable.clearSelection();
    }

    public void setClusterIndex(int clusterIndex) {
        this.clusterIndex = clusterIndex;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    @Override
    public int[][] getClusters() {
        return this.clusters;
    }

    public int[] getSortedCluster() {
        return this.sortedClusters[this.clusterIndex];
    }

    protected int getProbe(int row) {
        return this.experiment.getGeneIndexMappedToData(row);
    }

    @Override
    public Experiment getExperiment() {
        return this.experiment;
    }

    public IData getData() {
        return this.data;
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(true);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    int controlPressed = e.getModifiers() & 2;
                    boolean originalOrder = controlPressed != 0;
                    ExperimentClusterTableViewer.this.sortByColumn(column, !ExperimentClusterTableViewer.this.sortedAscending[ExperimentClusterTableViewer.this.getClusterIndex()][column], originalOrder);
                    boolean bl = ((ExperimentClusterTableViewer)ExperimentClusterTableViewer.this).sortedAscending[ExperimentClusterTableViewer.this.getClusterIndex()][column] = !ExperimentClusterTableViewer.this.sortedAscending[ExperimentClusterTableViewer.this.getClusterIndex()][column];
                    if (originalOrder) {
                        for (int i = 0; i < ExperimentClusterTableViewer.this.clusterModel.getColumnCount(); ++i) {
                            ((ExperimentClusterTableViewer)ExperimentClusterTableViewer.this).sortedAscending[ExperimentClusterTableViewer.this.getClusterIndex()][i] = false;
                        }
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void sortByColumn(int column, boolean ascending, boolean originalOrder) {
        if (originalOrder) {
            for (int i = 0; i < this.getSortedCluster().length; ++i) {
                this.sortedClusters[this.clusterIndex][i] = this.getCluster()[i];
            }
            this.clusterTable.repaint();
            this.clusterTable.clearSelection();
            return;
        }
        int[] sortedIndices = new int[this.getCluster().length];
        if (column == 0) {
            double[] origArray = new double[this.getCluster().length];
            for (int i = 0; i < origArray.length; ++i) {
                Color currColor = this.data.getExperimentColor(this.getCluster()[i]) == null ? Color.white : this.data.getExperimentColor(this.getCluster()[i]);
                origArray[i] = currColor.getRGB();
            }
            QSort sortArray = new QSort(origArray);
            int[] sortedPrimaryIndices = sortArray.getOrigIndx();
            for (int i = 0; i < sortedPrimaryIndices.length; ++i) {
                sortedIndices[i] = this.getCluster()[sortedPrimaryIndices[i]];
            }
        } else if (column == 1) {
            int i;
            Object[] sortFields = new SortableField[this.getCluster().length];
            for (i = 0; i < sortFields.length; ++i) {
                int currIndex = this.getCluster()[i];
                String currField = this.data.getFullSampleName(this.experiment.getSampleIndex(this.getCluster()[i]));
                sortFields[i] = new SortableField(currIndex, currField);
            }
            Arrays.sort(sortFields);
            for (i = 0; i < sortFields.length; ++i) {
                sortedIndices[i] = ((SortableField)sortFields[i]).getIndex();
            }
        } else {
            int obType = ExperimentClusterTableViewer.getObjectType(this.auxData[0][column - 2]);
            if (obType == 12 || obType == 11 || obType == 10) {
                double[] origArray = new double[this.getCluster().length];
                for (int i = 0; i < origArray.length; ++i) {
                    if (obType == 12) {
                        origArray[i] = (Double)this.auxData[this.getCluster()[i]][column - 2];
                        continue;
                    }
                    if (obType == 11) {
                        origArray[i] = ((Float)this.auxData[this.getCluster()[i]][column - 2]).doubleValue();
                        continue;
                    }
                    if (obType != 10) continue;
                    origArray[i] = ((Integer)this.auxData[this.getCluster()[i]][column - 2]).doubleValue();
                }
                QSort sortArray = new QSort(origArray);
                int[] sortedPrimaryIndices = sortArray.getOrigIndx();
                for (int i = 0; i < sortedPrimaryIndices.length; ++i) {
                    sortedIndices[i] = this.getCluster()[sortedPrimaryIndices[i]];
                }
            } else if (obType == 14) {
                int i;
                Object[] sortFields = new SortableField[this.getCluster().length];
                for (i = 0; i < sortFields.length; ++i) {
                    int currIndex = this.getCluster()[i];
                    String currField = ((Boolean)this.auxData[this.getCluster()[i]][column - 2]).toString();
                    sortFields[i] = new SortableField(currIndex, currField);
                }
                Arrays.sort(sortFields);
                for (i = 0; i < sortFields.length; ++i) {
                    sortedIndices[i] = ((SortableField)sortFields[i]).getIndex();
                }
            } else if (obType == 13) {
                int i;
                Object[] sortFields = new SortableField[this.getCluster().length];
                for (i = 0; i < sortFields.length; ++i) {
                    int currIndex = this.getCluster()[i];
                    String currField = (String)this.auxData[this.getCluster()[i]][column - 2];
                    sortFields[i] = new SortableField(currIndex, currField);
                }
                Arrays.sort(sortFields);
                for (i = 0; i < sortFields.length; ++i) {
                    sortedIndices[i] = ((SortableField)sortFields[i]).getIndex();
                }
            }
        }
        if (!ascending) {
            sortedIndices = this.reverse(sortedIndices);
        }
        for (int i = 0; i < this.getSortedCluster().length; ++i) {
            this.sortedClusters[this.clusterIndex][i] = sortedIndices[i];
        }
        this.clusterTable.repaint();
        this.clusterTable.removeRowSelectionInterval(0, this.clusterTable.getRowCount() - 1);
    }

    private static int[] getTypes(Object[][] objData) {
        int[] types = new int[objData[0].length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ExperimentClusterTableViewer.getObjectType(objData[0][i]);
        }
        return types;
    }

    private static int getObjectType(Object obj) {
        int obType = -1;
        if (obj instanceof Boolean) {
            return 14;
        }
        if (obj instanceof Double) {
            return 12;
        }
        if (obj instanceof Float) {
            return 11;
        }
        if (obj instanceof Integer) {
            return 10;
        }
        if (obj instanceof String) {
            return 13;
        }
        return obType;
    }

    private void searchTable() {
        this.searchDialog.setVisible(true);
        this.searchDialog.toFront();
        this.searchDialog.setLocation(this.clusterTable.getLocation().x + 100, this.clusterTable.getLocation().y + 100);
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    public void setClusterColor(Color color) {
        boolean success;
        if (color == null && !(success = this.framework.removeSubCluster(this.getArrayMappedToSelectedIndices(), this.experiment, 1))) {
            JOptionPane.showMessageDialog(null, "Cluster not deleted! Selected rows must exactly correspond to a cluster created in the current algorithm run", "Error", 0);
        }
    }

    public void storeCluster() {
        this.framework.storeCluster(this.getCluster(), this.experiment, 1);
        this.onDataChanged(this.data);
    }

    public void storeSelectedRowsAsCluster() {
        if (this.getArrayMappedToSelectedIndices().length == 0) {
            JOptionPane.showMessageDialog(null, "No rows selected! Cluster will not be saved", "Error", 0);
        } else {
            this.framework.storeSubCluster(this.getArrayMappedToSelectedIndices(), this.experiment, 1);
            this.onDataChanged(this.data);
        }
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getCluster(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    public void launchNewSessionWithSelectedRows() {
        this.framework.launchNewMAV(this.getArrayMappedToSelectedIndices(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    public void copyCells() {
        TransferHandler th = this.clusterTable.getTransferHandler();
        if (th != null) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            th.exportToClipboard(this.clusterTable, cb, 1);
        }
    }

    public void sortInOrigOrder() {
        int i;
        for (i = 0; i < this.getSortedCluster().length; ++i) {
            this.sortedClusters[this.clusterIndex][i] = this.getCluster()[i];
        }
        this.clusterTable.repaint();
        this.clusterTable.clearSelection();
        for (i = 0; i < this.clusterModel.getColumnCount(); ++i) {
            this.sortedAscending[this.getClusterIndex()][i] = false;
        }
    }

    private int[] getArrayMappedToSelectedIndices() {
        int[] selectedRows = this.clusterTable.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return new int[0];
        }
        int[] dataIndices = new int[selectedRows.length];
        for (int i = 0; i < dataIndices.length; ++i) {
            dataIndices[i] = this.getSortedCluster()[selectedRows[i]];
        }
        return dataIndices;
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Store entire cluster", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Store selected rows as cluster", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(STORE_SELECTED_ROWS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Delete cluster composed of selected rows", GUIFactory.getIcon((String)"delete16.gif"));
        menuItem.setActionCommand(SET_DEF_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Launch new session with entire cluster", GUIFactory.getIcon((String)"launch_new_mav.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Launch new session with selected rows", GUIFactory.getIcon((String)"launch_new_mav.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Search...", GUIFactory.getIcon((String)"ClusterInformationResult.gif"));
        menuItem.setActionCommand(SEARCH_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Copy", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(COPY_CELLS);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Select all rows...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(SELECT_ALL_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Clear all selections...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(CLEAR_ALL_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Sort table in original experiment order...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(SORT_ORIG_ORDER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Broadcast Matrix to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_MATRIX_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Selected Rows as Matrix to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_SELECTED_MATRIX_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Gene List to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_NAMELIST_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Matrix to Genome Browser", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_MATRIX_GENOME_BROWSER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.clusterTable);
        try {
            if (this.auxTitles.length == 0) {
                ExperimentUtil.saveAllExperimentClusters(frame, this.getExperiment(), this.getData(), this.getClusters());
            } else {
                ExperimentUtil.saveAllExperimentClustersWithAux(frame, this.getExperiment(), this.getData(), this.getClusters(), this.auxTitles, this.auxData);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.clusterTable);
        try {
            if (this.auxTitles.length == 0) {
                ExperimentUtil.saveExperimentCluster(frame, this.getExperiment(), this.getData(), this.getCluster());
            } else {
                ExperimentUtil.saveExperimentClusterWithAux(frame, this.getExperiment(), this.getData(), this.getCluster(), this.auxTitles, this.auxData);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.experiment);
        oos.writeObject(this.clusters);
        oos.writeObject(this.header);
        oos.writeObject(this.popup);
        oos.writeInt(this.clusterIndex);
        oos.writeObject(this.sortedClusters);
        oos.writeObject(this.auxTitles);
        oos.writeObject(this.auxData);
        oos.writeObject(this.sortedAscending);
        oos.writeObject(this.clusterTable);
        oos.writeObject(this.clusterModel);
        oos.writeObject(this.searchDialog);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int i;
        this.experiment = (Experiment)ois.readObject();
        this.clusters = (int[][])ois.readObject();
        this.header = (JComponent)ois.readObject();
        this.popup = (JPopupMenu)ois.readObject();
        this.clusterIndex = ois.readInt();
        this.sortedClusters = (int[][])ois.readObject();
        this.auxTitles = (String[])ois.readObject();
        this.auxData = (Object[][])ois.readObject();
        this.sortedAscending = (boolean[][])ois.readObject();
        this.clusterTable = (JTable)ois.readObject();
        this.clusterModel = (ExperimentClusterTableModel)ois.readObject();
        this.searchDialog = (ClusterTableSearchDialog)ois.readObject();
        this.clusterTable.setDefaultRenderer(Color.class, new ColorRenderer(true));
        TableColumn column = null;
        for (i = 0; i < this.clusterModel.getColumnCount(); ++i) {
            column = this.clusterTable.getColumnModel().getColumn(i);
            column.setMinWidth(30);
        }
        this.sortedAscending = new boolean[this.clusters.length][this.clusterModel.getColumnCount()];
        for (i = 0; i < this.sortedAscending.length; ++i) {
            for (int j = 0; j < this.sortedAscending[i].length; ++j) {
                this.sortedAscending[i][j] = false;
            }
        }
        this.addMouseListenerToHeaderInTable(this.clusterTable);
        this.header = this.clusterTable.getTableHeader();
        this.searchDialog = new ClusterTableSearchDialog(JOptionPane.getFrameForComponent(this.clusterTable), this.clusterTable, false);
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.clusterTable.addMouseListener(listener);
    }

    @Override
    public int getViewerType() {
        return 1;
    }

    @Override
    public void setExperiment(Experiment e) {
        this.experiment = e;
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void setExperimentID(int id) {
        this.exptID = id;
    }

    public void broadcastClusterGaggle() {
        this.framework.broadcastGeneCluster(this.getExperiment(), null, this.getCluster());
    }

    public void broadcastSelectedClusterGaggle() {
        this.framework.broadcastGeneCluster(this.getExperiment(), null, this.clusterTable.getSelectedColumns());
    }

    public void broadcastNamelistGaggle() {
        this.framework.broadcastNamelist(this.getExperiment(), this.getExperiment().getRows());
    }

    public void broadcastGeneClusterToGenomeBrowser() {
        this.framework.broadcastGeneClusterToGenomeBrowser(this.getExperiment(), this.getCluster(), null);
    }

    public class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(ExperimentClusterTableViewer.SAVE_CLUSTER_CMD)) {
                ExperimentClusterTableViewer.this.onSaveCluster();
            } else if (command.equals(ExperimentClusterTableViewer.SAVE_ALL_CLUSTERS_CMD)) {
                ExperimentClusterTableViewer.this.onSaveClusters();
            } else if (command.equals(ExperimentClusterTableViewer.STORE_CLUSTER_CMD)) {
                ExperimentClusterTableViewer.this.storeCluster();
            } else if (command.equals(ExperimentClusterTableViewer.STORE_SELECTED_ROWS_CMD)) {
                ExperimentClusterTableViewer.this.storeSelectedRowsAsCluster();
            } else if (command.equals(ExperimentClusterTableViewer.SET_DEF_COLOR_CMD)) {
                ExperimentClusterTableViewer.this.onSetDefaultColor();
            } else if (command.equals(ExperimentClusterTableViewer.LAUNCH_NEW_SESSION_CMD)) {
                ExperimentClusterTableViewer.this.launchNewSession();
            } else if (command.equals(ExperimentClusterTableViewer.LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD)) {
                ExperimentClusterTableViewer.this.launchNewSessionWithSelectedRows();
            } else if (command.equals(ExperimentClusterTableViewer.SEARCH_CMD)) {
                ExperimentClusterTableViewer.this.searchTable();
            } else if (command.equals(ExperimentClusterTableViewer.CLEAR_ALL_CMD)) {
                ExperimentClusterTableViewer.this.clusterTable.clearSelection();
            } else if (command.equals(ExperimentClusterTableViewer.SELECT_ALL_CMD)) {
                ExperimentClusterTableViewer.this.clusterTable.selectAll();
            } else if (command.equals(ExperimentClusterTableViewer.COPY_CELLS)) {
                ExperimentClusterTableViewer.this.copyCells();
            } else if (command.equals(ExperimentClusterTableViewer.SORT_ORIG_ORDER_CMD)) {
                ExperimentClusterTableViewer.this.sortInOrigOrder();
            } else if (command.equals(ExperimentClusterTableViewer.BROADCAST_MATRIX_GAGGLE_CMD)) {
                ExperimentClusterTableViewer.this.broadcastClusterGaggle();
            } else if (command.equals(ExperimentClusterTableViewer.BROADCAST_SELECTED_MATRIX_GAGGLE_CMD)) {
                ExperimentClusterTableViewer.this.broadcastSelectedClusterGaggle();
            } else if (command.equals(ExperimentClusterTableViewer.BROADCAST_NAMELIST_GAGGLE_CMD)) {
                ExperimentClusterTableViewer.this.broadcastNamelistGaggle();
            } else if (command.equals(ExperimentClusterTableViewer.BROADCAST_MATRIX_GENOME_BROWSER_CMD)) {
                ExperimentClusterTableViewer.this.broadcastGeneClusterToGenomeBrowser();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || ExperimentClusterTableViewer.this.getCluster() == null || ExperimentClusterTableViewer.this.getCluster().length == 0) {
                return;
            }
            ExperimentClusterTableViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int index, String field) {
            this.index = index;
            this.field = field;
        }

        public int compareTo(Object other) {
            SortableField otherField = (SortableField)other;
            return this.field.compareTo(otherField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class ExperimentClusterTableModel
    extends AbstractTableModel {
        String[] columnNames;

        public ExperimentClusterTableModel() {
            this.columnNames = new String[2 + ExperimentClusterTableViewer.this.auxTitles.length];
            this.columnNames[0] = "Last Stored Color";
            this.columnNames[1] = "Sample Name";
            for (int i = 2; i < this.columnNames.length; ++i) {
                this.columnNames[i] = ExperimentClusterTableViewer.this.auxTitles[i - 2];
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return ExperimentClusterTableViewer.this.getCluster().length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return ExperimentClusterTableViewer.this.data.getExperimentColor(ExperimentClusterTableViewer.this.getSortedCluster()[row]) == null ? Color.white : ExperimentClusterTableViewer.this.data.getExperimentColor(ExperimentClusterTableViewer.this.getSortedCluster()[row]);
            }
            if (col == 1) {
                return ExperimentClusterTableViewer.this.data.getFullSampleName(ExperimentClusterTableViewer.this.experiment.getSampleIndex(ExperimentClusterTableViewer.this.getSortedCluster()[row]));
            }
            return String.valueOf(ExperimentClusterTableViewer.this.auxData[ExperimentClusterTableViewer.this.getSortedCluster()[row]][col - 2]);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

